//
// File: PanelParametresSortie.h
// Created by: Éric Laly <elaly@free.fr>
// Created on: Tue Oct 17 18:36:00 2006
//

#ifndef _PANELPARAMETRESSORTIE_H_
#define _PANELPARAMETRESSORTIE_H_
#include <vector>
using std::vector;
#include <wx/wx.h>
#include <wx/spinctrl.h>

#include "PanelSaisieParametresImageSortie.h"
#include "PanelSaisieRepertoire.h"

class PanelParametresSortie:public wxPanel
{
	public:
		PanelParametresSortie(wxWindow* parent, int id);
		 ~PanelParametresSortie();
        unsigned int GetNombreEncadrement();
        wxString GetNomSortie(int index);
        wxString GetRepertoireDestination();
        wxString GetSousRepertoireDestination(int index);
        wxString GetPrefixeFichier(int index);
        int GetQualiteEnregistrement(int index);
        int GetTailleRedimensionement(int index);
	protected:
    
    private:
        int NombreSorties;
        PanelSaisieRepertoire *panel_saisie_repertoire_base;
        wxStaticText* label_nombre_sorties;
        wxTextCtrl* text_ctrl_nombre_sorties;
        wxSpinButton* spin_button_nombre_sorties;
        vector <PanelSaisieParametresImageSortie*> panel_encadrement;
        wxRadioBox* radio_box_type_sortie;
        wxBoxSizer* sizer_panel_parametres_sortie;
        wxBoxSizer *sizer_parametres;
        wxBoxSizer* sizer_nombre_sorties;
        wxScrolledWindow *sw_parametre;
        
        void AfficheNombreSorties();
        void OnSpinButtonUpNombreSorties(wxCommandEvent& event);
        void OnSpinButtonDownNombreSorties(wxCommandEvent& event);
        void OnRadioboxSelectedTypeSortie(wxCommandEvent& event);    

        void EnleveSorties();
        void CreeSortieSimpleOuMultiple();
        void CreeSortiePHPWebGallery();

};


#endif	//_PANELPARAMETRESSORTIE_H_
