package de.lmu.ifi.dbs.elki.math.statistics.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2012
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import org.junit.Test;

import de.lmu.ifi.dbs.elki.JUnit4Test;

/**
 * Unit test for the Chi Squared distribution in ELKI.
 * 
 * The reference values were computed using GNU R and SciPy.
 * 
 * @author Erich Schubert
 */
public class TestChiSquaredDistribution extends AbstractDistributionTest implements JUnit4Test {
  public static final double[] P_CDFPDF = { //
  0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 1e-05, 1e-10, 0.1234567, 3.14159265359, 2.71828182846, 0.314159265359, 0.271828182846 //
  };

  public static final double[] SCIPY_CHISQ_CDF_01 = { //
  8.82243563885668047319654760940466076135635375976562e-01, // 0.100000
  9.11257625237519408578634738660184666514396667480469e-01, // 0.200000
  9.27832443365792181033668839518213644623756408691406e-01, // 0.300000
  9.39209088699221039675535394053440541028976440429688e-01, // 0.400000
  9.47708820173318144952645525336265563964843750000000e-01, // 0.500000
  9.54381121874345095257297089119674637913703918457031e-01, // 0.600000
  9.59792062842079185536192653671605512499809265136719e-01, // 0.700000
  9.64282450147988190458647750347154214978218078613281e-01, // 0.800000
  9.68073590190356547680039511760696768760681152343750e-01, // 0.900000
  9.71317371244163729748777313943719491362571716308594e-01, // 1.000000
  9.74122543962944176243468064058106392621994018554688e-01, // 1.100000
  9.76569616477515944907850098388735204935073852539062e-01, // 1.200000
  9.78719820077030289162678400316508486866950988769531e-01, // 1.300000
  9.80620773380832644328108926856657490134239196777344e-01, // 1.400000
  9.82310206057613877206335928349290043115615844726562e-01, // 1.500000
  9.83818489875346147144341557577718049287796020507812e-01, // 1.600000
  9.85170408569036260004736504924949258565902709960938e-01, // 1.700000
  9.86386426034563057463344648567726835608482360839844e-01, // 1.800000
  9.87483614564462985896398095064796507358551025390625e-01, // 1.900000
  9.88476347051459813819462851824937388300895690917969e-01, // 2.000000
  5.57969600280356692323380229936446994543075561523438e-01, // 0.000010
  3.13769439143751660559189531340962275862693786621094e-01, // 0.000000
  8.91102932913000800319025529461214318871498107910156e-01, // 0.123457
  9.95185831509797558247498727723723277449607849121094e-01, // 3.141593
  9.93427663775691249803401206008857116103172302246094e-01, // 2.718282
  9.29682286188087236844523886247770860791206359863281e-01, // 0.314159
  9.23848956395416420761534936900716274976730346679688e-01, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_PDF_01 = { //
  4.20596758859699160204570489440811797976493835449219e-01, // 0.100000
  2.07096472560618249936226220597745850682258605957031e-01, // 0.200000
  1.34020514700378817751769133792549837380647659301758e-01, // 0.300000
  9.69984417734248427489518462607520632445812225341797e-02, // 0.400000
  7.46423873161204676218716258517815731465816497802734e-02, // 0.500000
  5.97102120258812332775910647342243464663624763488770e-02, // 0.600000
  4.90607789226714316455080222567630698904395103454590e-02, // 0.700000
  4.11080963115560762966005370344646507874131202697754e-02, // 0.800000
  3.49637289621889876811700048619968583807349205017090e-02, // 0.900000
  3.00907771823936791288911507535885903052985668182373e-02, // 1.000000
  2.61454204266986685312179616857974906452000141143799e-02, // 1.100000
  2.28971681180981344316816006312365061603486537933350e-02, // 1.200000
  2.01856643669713550770516974353085970506072044372559e-02, // 1.300000
  1.78958724006224693947597614851474645547568798065186e-02, // 1.400000
  1.59431116775097907189984169917806866578757762908936e-02, // 1.500000
  1.42636632388964210843562696595654415432363748550415e-02, // 1.600000
  1.28086648126372482786594630965737451333552598953247e-02, // 1.700000
  1.15400245359752948171028208435018314048647880554199e-02, // 1.800000
  1.04276144940537648930778402700525475665926933288574e-02, // 1.900000
  9.44729915895063145081511635225979262031614780426025e-03, // 2.000000
  2.78983471644215933338273316621780395507812500000000e+03, // 0.000010
  1.56884719564404964447021484375000000000000000000000e+08, // 0.000000
  3.40277656462092736866509312676498666405677795410156e-01, // 0.123457
  3.47616265678607179803738524981326918350532650947571e-03, // 3.141593
  4.92871253406783164929816365429360303096473217010498e-03, // 2.718282
  1.27370674605358003006472245033364742994308471679688e-01, // 0.314159
  1.49270555162829721140838046267163008451461791992188e-01, // 0.271828
  };

  public static final double[] GNUR_CHISQ_CDF_01 = { //
  8.82243563885668047319654760940466076135635375976562e-01, // 0.100000
  9.11257625237519630623239663691492751240730285644531e-01, // 0.200000
  9.27832443365792847167483614612137898802757263183594e-01, // 0.300000
  9.39209088699221039675535394053440541028976440429688e-01, // 0.400000
  9.47708820173318589041855375398881733417510986328125e-01, // 0.500000
  9.54381121874345650368809401697944849729537963867188e-01, // 0.600000
  9.59792062842079629625402503734221681952476501464844e-01, // 0.700000
  9.64282450147988301480950212862808257341384887695312e-01, // 0.800000
  9.68073590190356436657737049245042726397514343261719e-01, // 0.900000
  9.71317371244163951793382238975027576088905334472656e-01, // 1.000000
  9.74122543962944731354980376636376604437828063964844e-01, // 1.100000
  9.76569616477516500019362410967005416750907897949219e-01, // 1.200000
  9.78719820077030733251888250379124656319618225097656e-01, // 1.300000
  9.80620773380832866372713851887965574860572814941406e-01, // 1.400000
  9.82310206057613877206335928349290043115615844726562e-01, // 1.500000
  9.83818489875346147144341557577718049287796020507812e-01, // 1.600000
  9.85170408569036704093946354987565428018569946289062e-01, // 1.700000
  9.86386426034563279507949573599034920334815979003906e-01, // 1.800000
  9.87483614564463429985607945127412676811218261718750e-01, // 1.900000
  9.88476347051460035864067776856245473027229309082031e-01, // 2.000000
  5.57969600280356914367985154967755079269409179687500e-01, // 0.000010
  3.13769439143751827092643225114443339407444000244141e-01, // 0.000000
  8.91102932913001466452840304555138573050498962402344e-01, // 0.123457
  9.95185831509798335403615965333301573991775512695312e-01, // 3.141593
  9.93427663775695912740104631666326895356178283691406e-01, // 2.718282
  9.29682286188089901379782986623467877507209777832031e-01, // 0.314159
  9.23848956395430742638552601420087739825248718261719e-01, // 0.271828
  };

  public static final double[] GNUR_CHISQ_PDF_01 = { //
  4.20596758859699271226872951956465840339660644531250e-01, // 0.100000
  2.07096472560618277691801836226659361273050308227539e-01, // 0.200000
  1.34020514700378845507344749421463347971439361572266e-01, // 0.300000
  9.69984417734248705045274618896655738353729248046875e-02, // 0.400000
  7.46423873161204814996594336662383284419775009155273e-02, // 0.500000
  5.97102120258812332775910647342243464663624763488770e-02, // 0.600000
  4.90607789226714316455080222567630698904395103454590e-02, // 0.700000
  4.11080963115560832354944409416930284351110458374023e-02, // 0.800000
  3.49637289621889876811700048619968583807349205017090e-02, // 0.900000
  3.00907771823936825983381027072027791291475296020508e-02, // 1.000000
  2.61454204266986720006649136394116794690489768981934e-02, // 1.100000
  2.28971681180981309622346486776223173364996910095215e-02, // 1.200000
  2.01856643669713516076047454816944082267582416534424e-02, // 1.300000
  1.78958724006224659253128095315332757309079170227051e-02, // 1.400000
  1.59431116775097872495514650381664978340268135070801e-02, // 1.500000
  1.42636632388964228190797456363725359551608562469482e-02, // 1.600000
  1.28086648126372430744890351661524618975818157196045e-02, // 1.700000
  1.15400245359752878782089169362734537571668624877930e-02, // 1.800000
  1.04276144940537579541839363628241699188947677612305e-02, // 1.900000
  9.44729915895062624664468842183850938454270362854004e-03, // 2.000000
  2.78983471644215978813008405268192291259765625000000e+03, // 0.000010
  1.56884719564405262470245361328125000000000000000000e+08, // 0.000000
  3.40277656462092847888811775192152708768844604492188e-01, // 0.123457
  3.47616265678549370143901597884905640967190265655518e-03, // 3.141593
  4.92871253406383397904777510234453075099736452102661e-03, // 2.718282
  1.27370674605348788155367856234079226851463317871094e-01, // 0.314159
  1.49270555162772794455250391365552786737680435180664e-01, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_CDF_1 = { //
  2.48170365954150762277663488930556923151016235351562e-01, // 0.100000
  3.45279153981423170272080369613831862807273864746094e-01, // 0.200000
  4.16117579229634992898922973836306482553482055664062e-01, // 0.300000
  4.72910743134461963865788902694475837051868438720703e-01, // 0.400000
  5.20499877813046629704274437244748696684837341308594e-01, // 0.500000
  5.61421973919000283359537206706590950489044189453125e-01, // 0.600000
  5.97216305753524356880745926900999620556831359863281e-01, // 0.700000
  6.28906630477302552861829099128954112529754638671875e-01, // 0.800000
  6.57218288852088661222694554453482851386070251464844e-01, // 0.900000
  6.82689492137085962575326902879169210791587829589844e-01, // 1.000000
  7.05733895695037305451080555940279737114906311035156e-01, // 1.100000
  7.26678321707701857512518017756519839167594909667969e-01, // 1.200000
  7.45786776396035855363209066126728430390357971191406e-01, // 1.300000
  7.63276429362142794232681808352936059236526489257812e-01, // 1.400000
  7.79328638080153068834476925985654816031455993652344e-01, // 1.500000
  7.94096789267931812972278748929966241121292114257812e-01, // 1.600000
  8.07712022888480207782890829548705369234085083007812e-01, // 1.700000
  8.20287505121000126706576338619925081729888916015625e-01, // 1.800000
  8.31921680965029608501026814337819814682006835937500e-01, // 1.900000
  8.42700792949715116186837349232519045472145080566406e-01, // 2.000000
  2.52312831680559686298170873897106503136456012725830e-03, // 0.000010
  7.97884560789568197394176080061711786584055516868830e-06, // 0.000000
  2.74684755560843596455811166379135102033615112304688e-01, // 0.123457
  9.23680750542945294689900492812739685177803039550781e-01, // 3.141593
  9.00795249588885127423054655082523822784423828125000e-01, // 2.718282
  4.24860961379973645080099231563508510589599609375000e-01, // 0.314159
  3.97891959928843685911914462849381379783153533935547e-01, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_PDF_1 = { //
  1.20003894843013592108604825625661760568618774414062e+00, // 0.100000
  8.07171129357680983140710395673522725701332092285156e-01, // 0.200000
  6.26910099227520833942151057271985337138175964355469e-01, // 0.300000
  5.16441547467278438965365694457432255148887634277344e-01, // 0.400000
  4.39391289467722434558538679993944242596626281738281e-01, // 0.500000
  3.81545289384093044837698016635840758681297302246094e-01, // 0.600000
  3.36014467726770404976122108564595691859722137451172e-01, // 0.700000
  2.98983539918204976881810353006585501134395599365234e-01, // 0.800000
  2.68136721052083026872736581935896538197994232177734e-01, // 0.900000
  2.41970724519143365327522587904240936040878295898438e-01, // 1.000000
  2.19458172413343671758312325437145773321390151977539e-01, // 1.100000
  1.99867763901733275222483143807039596140384674072266e-01, // 1.200000
  1.82661481795109131853749317997426260262727737426758e-01, // 1.300000
  1.67432557345083526945117569084686692804098129272461e-01, // 1.400000
  1.53866322805455257860529627578216604888439178466797e-01, // 1.500000
  1.41714565306223921892225803276232909411191940307617e-01, // 1.600000
  1.30778181923888126014787758322199806571006774902344e-01, // 1.700000
  1.20895122473204871815788408184744184836745262145996e-01, // 1.800000
  1.11931805086169955387731533846817910671234130859375e-01, // 1.900000
  1.03776874355148679418547885688894893974065780639648e-01, // 2.000000
  1.26155995319454547143322997726500034332275390625000e+02, // 0.000010
  3.98942280381486198166385293006896972656250000000000e+04, // 0.000000
  1.06744240620741748237776391761144623160362243652344e+00, // 0.123457
  4.67893435961044684701093387957371305674314498901367e-02, // 3.141593
  6.21577700803671237550496186941018095239996910095215e-02, // 2.718282
  6.08297892453185884420463480637408792972564697265625e-01, // 0.314159
  6.67937897133326075049808423500508069992065429687500e-01, // 0.271828
  };

  public static final double[] GNUR_CHISQ_CDF_1 = { //
  2.48170365954150706766512257672729901969432830810547e-01, // 0.100000
  3.45279153981422948227475444582523778080940246582031e-01, // 0.200000
  4.16117579229634826365469280062825419008731842041016e-01, // 0.300000
  4.72910743134461908354637671436648815870285034179688e-01, // 0.400000
  5.20499877813046518681971974729094654321670532226562e-01, // 0.500000
  5.61421973919000061314932281675282865762710571289062e-01, // 0.600000
  5.97216305753524356880745926900999620556831359863281e-01, // 0.700000
  6.28906630477302330817224174097646027803421020507812e-01, // 0.800000
  6.57218288852088550200392091937828809022903442382812e-01, // 0.900000
  6.82689492137085962575326902879169210791587829589844e-01, // 1.000000
  7.05733895695037083406475630908971652388572692871094e-01, // 1.100000
  7.26678321707701857512518017756519839167594909667969e-01, // 1.200000
  7.45786776396035633318604141095420345664024353027344e-01, // 1.300000
  7.63276429362142572188076883321627974510192871093750e-01, // 1.400000
  7.79328638080153179856779388501308858394622802734375e-01, // 1.500000
  7.94096789267931590927673823898658156394958496093750e-01, // 1.600000
  8.07712022888480207782890829548705369234085083007812e-01, // 1.700000
  8.20287505121000237728878801135579124093055725097656e-01, // 1.800000
  8.31921680965029608501026814337819814682006835937500e-01, // 1.900000
  8.42700792949715449253744736779481172561645507812500e-01, // 2.000000
  2.52312831680559773034344672737461223732680082321167e-03, // 0.000010
  7.97884560789567350361228825761372718261554837226868e-06, // 0.000000
  2.74684755560843485433508703863481059670448303222656e-01, // 0.123457
  9.23680750542954953630214731674641370773315429687500e-01, // 3.141593
  9.00795249588944302310267175926128402352333068847656e-01, // 2.718282
  4.24860961379986301622579958348069339990615844726562e-01, // 0.314159
  3.97891959928907357202376715576974675059318542480469e-01, // 0.271828
  };

  public static final double[] GNUR_CHISQ_PDF_1 = { //
  1.20003894843013592108604825625661760568618774414062e+00, // 0.100000
  8.07171129357681094163012858189176768064498901367188e-01, // 0.200000
  6.26910099227520833942151057271985337138175964355469e-01, // 0.300000
  5.16441547467278327943063231941778212785720825195312e-01, // 0.400000
  4.39391289467722434558538679993944242596626281738281e-01, // 0.500000
  3.81545289384093044837698016635840758681297302246094e-01, // 0.600000
  3.36014467726770404976122108564595691859722137451172e-01, // 0.700000
  2.98983539918204921370659121748758479952812194824219e-01, // 0.800000
  2.68136721052082971361585350678069517016410827636719e-01, // 0.900000
  2.41970724519143365327522587904240936040878295898438e-01, // 1.000000
  2.19458172413343699513887941066059283912181854248047e-01, // 1.100000
  1.99867763901733275222483143807039596140384674072266e-01, // 1.200000
  1.82661481795109104098173702368512749671936035156250e-01, // 1.300000
  1.67432557345083526945117569084686692804098129272461e-01, // 1.400000
  1.53866322805455257860529627578216604888439178466797e-01, // 1.500000
  1.41714565306223921892225803276232909411191940307617e-01, // 1.600000
  1.30778181923888126014787758322199806571006774902344e-01, // 1.700000
  1.20895122473204871815788408184744184836745262145996e-01, // 1.800000
  1.11931805086169955387731533846817910671234130859375e-01, // 1.900000
  1.03776874355148693296335693503351649269461631774902e-01, // 2.000000
  1.26155995319454461878194706514477729797363281250000e+02, // 0.000010
  3.98942280381485470570623874664306640625000000000000e+04, // 0.000000
  1.06744240620741726033315899258013814687728881835938e+00, // 0.123457
  4.67893435960980846877177441456296946853399276733398e-02, // 3.141593
  6.21577700803265520423934731297777034342288970947266e-02, // 2.718282
  6.08297892453159572134779864427400752902030944824219e-01, // 0.314159
  6.67937897133176639030693877430167049169540405273438e-01, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_CDF_2 = { //
  4.87705754992859910612601481716410489752888679504395e-02, // 0.100000
  9.51625819640404407850908796717703808099031448364258e-02, // 0.200000
  1.39292023574942191999070928432047367095947265625000e-01, // 0.300000
  1.81269246922018151257915974383649881929159164428711e-01, // 0.400000
  2.21199216928595121522960198490181937813758850097656e-01, // 0.500000
  2.59181779318282068391710026844521053135395050048828e-01, // 0.600000
  2.95311910281286504886821830950793810188770294189453e-01, // 0.700000
  3.29679953964360561435853469447465613484382629394531e-01, // 0.800000
  3.62371848378226779630040255142375826835632324218750e-01, // 0.900000
  3.93469340287366520225731392201851122081279754638672e-01, // 1.000000
  4.23050189619513239414061445131665095686912536621094e-01, // 1.100000
  4.51188363905973610634703163668746128678321838378906e-01, // 1.200000
  4.77954223238983844090910224622348323464393615722656e-01, // 1.300000
  5.03414696208590473069932613725541159510612487792969e-01, // 1.400000
  5.27633447258985310845957883429946377873420715332031e-01, // 1.500000
  5.50671035882778325820652298716595396399497985839844e-01, // 1.600000
  5.72585068051273293754377391451271250844001770019531e-01, // 1.700000
  5.93430340259400890268182138242991641163825988769531e-01, // 1.800000
  6.13258976545498768473407835699617862701416015625000e-01, // 1.900000
  6.32120558828557776998025019565830007195472717285156e-01, // 2.000000
  4.99998750002083230991115070374064544012071564793587e-06, // 0.000010
  4.99999999987500220561171362591683115655927238663025e-11, // 0.000000
  5.98617593408454426451292818001093110069632530212402e-02, // 0.123457
  7.92120423649238181162957062042551115155220031738281e-01, // 3.141593
  7.43118634686529722088721428008284419775009155273438e-01, // 2.718282
  1.45364000846766538987964167972677387297153472900391e-01, // 0.314159
  1.27082379621731661467620710936898831278085708618164e-01, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_PDF_2 = { //
  4.75614712250357007938816877867793664336204528808594e-01, // 0.100000
  4.52418709017979814301924079700256697833538055419922e-01, // 0.200000
  4.30353988212528904000464535783976316452026367187500e-01, // 0.300000
  4.09365376538990910493254204993718303740024566650391e-01, // 0.400000
  3.89400391535702439238519900754909031093120574951172e-01, // 0.500000
  3.70409110340858993559720602206652984023094177246094e-01, // 0.600000
  3.52344044859356719801013468895689584314823150634766e-01, // 0.700000
  3.35160023017819663770922034018440172076225280761719e-01, // 0.800000
  3.18814075810886610184979872428812086582183837890625e-01, // 0.900000
  3.03265329856316712131558688270160928368568420410156e-01, // 1.000000
  2.88474905190243380292969277434167452156543731689453e-01, // 1.100000
  2.74405818047013250193799649423453956842422485351562e-01, // 1.200000
  2.61022888380508022443393656430998817086219787597656e-01, // 1.300000
  2.48292651895704791220609308766142930835485458374023e-01, // 1.400000
  2.36183276370507344577021058285026811063289642333984e-01, // 1.500000
  2.24664482058610809334098235012788791209459304809570e-01, // 1.600000
  2.13707465974363353122811304274364374577999114990234e-01, // 1.700000
  2.03284829870299554865908930878504179418087005615234e-01, // 1.800000
  1.93370511727250643518871697779104579240083694458008e-01, // 1.900000
  1.83939720585721139256563105845998506993055343627930e-01, // 2.000000
  4.99997500006249984139117259474005550146102905273438e-01, // 0.000010
  4.99999999974999997931490725022740662097930908203125e-01, // 0.000000
  4.70069120329577316841351830589701421558856964111328e-01, // 0.123457
  1.03939788175380951051884892422094708308577537536621e-01, // 3.141593
  1.28440682656735138955639285995857790112495422363281e-01, // 2.718282
  4.27317999576616702750442300384747795760631561279297e-01, // 0.314159
  4.36458810189134183143977452346007339656352996826172e-01, // 0.271828
  };

  public static final double[] GNUR_CHISQ_CDF_2 = { //
  4.87705754992859910612601481716410489752888679504395e-02, // 0.100000
  9.51625819640404269073030718573136255145072937011719e-02, // 0.200000
  1.39292023574942191999070928432047367095947265625000e-01, // 0.300000
  1.81269246922018151257915974383649881929159164428711e-01, // 0.400000
  2.21199216928595121522960198490181937813758850097656e-01, // 0.500000
  2.59181779318282123902861258102348074316978454589844e-01, // 0.600000
  2.95311910281286560397973062208620831370353698730469e-01, // 0.700000
  3.29679953964360727969307163220946677029132843017578e-01, // 0.800000
  3.62371848378226724118889023884548805654048919677734e-01, // 0.900000
  3.93469340287366575736882623459678143262863159179688e-01, // 1.000000
  4.23050189619513350436363907647319138050079345703125e-01, // 1.100000
  4.51188363905973610634703163668746128678321838378906e-01, // 1.200000
  4.77954223238983955113212687138002365827560424804688e-01, // 1.300000
  5.03414696208590473069932613725541159510612487792969e-01, // 1.400000
  5.27633447258985310845957883429946377873420715332031e-01, // 1.500000
  5.50671035882778325820652298716595396399497985839844e-01, // 1.600000
  5.72585068051273404776679853966925293207168579101562e-01, // 1.700000
  5.93430340259400890268182138242991641163825988769531e-01, // 1.800000
  6.13258976545498657451105373183963820338249206542969e-01, // 1.900000
  6.32120558828557665975722557050175964832305908203125e-01, // 2.000000
  4.99998750002083400397704521234132357676571700721979e-06, // 0.000010
  4.99999999987500026690715295475821817669515034765482e-11, // 0.000000
  5.98617593408454426451292818001093110069632530212402e-02, // 0.123457
  7.92120423649259608467332327563781291246414184570312e-01, // 3.141593
  7.43118634686652401732942507806001231074333190917969e-01, // 2.718282
  1.45364000846775420772161169225000776350498199462891e-01, // 0.314159
  1.27082379621773322586619769936078228056430816650391e-01, // 0.271828
  };

  public static final double[] GNUR_CHISQ_PDF_2 = { //
  4.75614712250357007938816877867793664336204528808594e-01, // 0.100000
  4.52418709017979758790772848442429676651954650878906e-01, // 0.200000
  4.30353988212528904000464535783976316452026367187500e-01, // 0.300000
  4.09365376538990910493254204993718303740024566650391e-01, // 0.400000
  3.89400391535702439238519900754909031093120574951172e-01, // 0.500000
  3.70409110340858938048569370948825962841510772705078e-01, // 0.600000
  3.52344044859356719801013468895689584314823150634766e-01, // 0.700000
  3.35160023017819663770922034018440172076225280761719e-01, // 0.800000
  3.18814075810886665696131103686639107763767242431641e-01, // 0.900000
  3.03265329856316712131558688270160928368568420410156e-01, // 1.000000
  2.88474905190243324781818046176340430974960327148438e-01, // 1.100000
  2.74405818047013194682648418165626935660839080810547e-01, // 1.200000
  2.61022888380508022443393656430998817086219787597656e-01, // 1.300000
  2.48292651895704763465033693137229420244693756103516e-01, // 1.400000
  2.36183276370507344577021058285026811063289642333984e-01, // 1.500000
  2.24664482058610781578522619383875280618667602539062e-01, // 1.600000
  2.13707465974363353122811304274364374577999114990234e-01, // 1.700000
  2.03284829870299554865908930878504179418087005615234e-01, // 1.800000
  1.93370511727250615763296082150191068649291992187500e-01, // 1.900000
  1.83939720585721167012138721474912017583847045898438e-01, // 2.000000
  4.99997500006249984139117259474005550146102905273438e-01, // 0.000010
  4.99999999974999997931490725022740662097930908203125e-01, // 0.000000
  4.70069120329577261330200599331874400377273559570312e-01, // 0.123457
  1.03939788175370209644121644032566109672188758850098e-01, // 3.141593
  1.28440682656673799133528746096999384462833404541016e-01, // 2.718282
  4.27317999576612317369495031016413122415542602539062e-01, // 0.314159
  4.36458810189113310951114499403047375380992889404297e-01, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_CDF_4 = { //
  1.20910427425029100463593767500469766673631966114044e-03, // 0.100000
  4.67884016044447376136972138738201465457677841186523e-03, // 0.200000
  1.01858271111835239214338244551072421018034219741821e-02, // 0.300000
  1.75230963064217717950477037902601296082139015197754e-02, // 0.400000
  2.64990211607439123120411039735699887387454509735107e-02, // 0.500000
  3.69363131137667791148437856918462784960865974426270e-02, // 0.600000
  4.86710788797368384961394838228443404659628868103027e-02, // 0.700000
  6.15519355501049983403483167876402148976922035217285e-02, // 0.800000
  7.54391801484287222168134690036822576075792312622070e-02, // 0.900000
  9.02040104310498636053239351895172148942947387695312e-02, // 1.000000
  1.05727793910245615460752333092386834323406219482422e-01, // 1.100000
  1.21901382249557641013204545288317603990435600280762e-01, // 1.200000
  1.38624468344323514834570687526138499379158020019531e-01, // 1.300000
  1.55804983554603787565540073956071864813566207885742e-01, // 1.400000
  1.73358532703224266224850680373492650687694549560547e-01, // 1.500000
  1.91207864589001103050591723331308458000421524047852e-01, // 1.600000
  2.09282375894855626752288912939548026770353317260742e-01, // 1.700000
  2.27517646492861713714006555164814926683902740478516e-01, // 1.800000
  2.45855004263722698443217495878343470394611358642578e-01, // 1.900000
  2.64241117657115276440293882842524908483028411865234e-01, // 2.000000
  1.24999583334114298362906795536861261509270493164081e-11, // 0.000010
  1.24999999995833552159194802776351939183872839712033e-21, // 0.000000
  1.82857697305291249344205706250932053080759942531586e-03, // 0.123457
  4.65583948701781880075145636510569602251052856445312e-01, // 3.141593
  3.93980660985851938171720121317775920033454895019531e-01, // 2.718282
  1.11180920251080228577933439737535081803798675537109e-02, // 0.314159
  8.44057436093374746644002470929990522563457489013672e-03, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_PDF_4 = { //
  2.37807356125178670502862132707377895712852478027344e-02, // 0.100000
  4.52418709017979800424136271885799942538142204284668e-02, // 0.200000
  6.45530982318793383756272419304877985268831253051758e-02, // 0.300000
  8.18730753077981932008810872503090649843215942382812e-02, // 0.400000
  9.73500978839256236874177830031840130686759948730469e-02, // 0.500000
  1.11122733102257703619031303787778597325086593627930e-01, // 0.600000
  1.23320415700774871359257645053730811923742294311523e-01, // 0.700000
  1.34064009207127854406138567355810664594173431396484e-01, // 0.800000
  1.43466334114899007889931681347661651670932769775391e-01, // 0.900000
  1.51632664928158356065779344135080464184284210205078e-01, // 1.000000
  1.58661197854633867487805787277466151863336563110352e-01, // 1.100000
  1.64643490828207922360704174025158863514661788940430e-01, // 1.200000
  1.69664877447330247894896615434845443814992904663086e-01, // 1.300000
  1.73804856326993356629984077699191402643918991088867e-01, // 1.400000
  1.77137457277880522310553601528226863592863082885742e-01, // 1.500000
  1.79731585646888653018393711136013735085725784301758e-01, // 1.600000
  1.81651346078208847378832047070318367332220077514648e-01, // 1.700000
  1.82956346883269588277087791539088357239961624145508e-01, // 1.800000
  1.83701986140888090526246401168464217334985733032227e-01, // 1.900000
  1.83939720585721139256563105845998506993055343627930e-01, // 2.000000
  2.49998750003124934010532293138240333973953966051340e-06, // 0.000010
  2.49999999987499629841753832369663826905303860570484e-11, // 0.000000
  2.90165911838962502222738493173892493359744548797607e-02, // 0.123457
  1.63268237473728039521603250250336714088916778564453e-01, // 3.141593
  1.74568986850338975225227500231994781643152236938477e-01, // 2.718282
  6.71229544108292858206610276283754501491785049438477e-02, // 0.314159
  5.93209026303989431228025352993427077308297157287598e-02, // 0.271828
  };

  public static final double[] GNUR_CHISQ_CDF_4 = { //
  1.20910427425029057095506868080292406375519931316376e-03, // 0.100000
  4.67884016044447115928450742217137303669005632400513e-03, // 0.200000
  1.01858271111835187172633965246859588660299777984619e-02, // 0.300000
  1.75230963064217613867068479294175631366670131683350e-02, // 0.400000
  2.64990211607439261898289117880267440341413021087646e-02, // 0.500000
  3.69363131137667860537376895990746561437845230102539e-02, // 0.600000
  4.86710788797368662517150994517578510567545890808105e-02, // 0.700000
  6.15519355501050191570300285093253478407859802246094e-02, // 0.800000
  7.54391801484287360946012768181390129029750823974609e-02, // 0.900000
  9.02040104310498774831117430039739701896905899047852e-02, // 1.000000
  1.05727793910245615460752333092386834323406219482422e-01, // 1.100000
  1.21901382249557682646567968731687869876623153686523e-01, // 1.200000
  1.38624468344323542590146303155052009969949722290039e-01, // 1.300000
  1.55804983554603898587842536471725907176733016967773e-01, // 1.400000
  1.73358532703224266224850680373492650687694549560547e-01, // 1.500000
  1.91207864589001158561742954589135479182004928588867e-01, // 1.600000
  2.09282375894855654507864528568461537361145019531250e-01, // 1.700000
  2.27517646492861658202855323906987905502319335937500e-01, // 1.800000
  2.45855004263722753954368727136170491576194763183594e-01, // 1.900000
  2.64241117657115276440293882842524908483028411865234e-01, // 2.000000
  1.24999583334114362986392151242148360838074561129929e-11, // 0.000010
  1.24999999995832724611171823885946329193350635251076e-21, // 0.000000
  1.82857697305291162608031907410577332484535872936249e-03, // 0.123457
  4.65583948701815852899699166300706565380096435546875e-01, // 3.141593
  3.93980660986018471625413894798839464783668518066406e-01, // 2.718282
  1.11180920251094158407445533498503209557384252548218e-02, // 0.314159
  8.44057436093940786914213703084897133521735668182373e-03, // 0.271828
  };

  public static final double[] GNUR_CHISQ_PDF_4 = { //
  2.37807356125178601113923093635094119235873222351074e-02, // 0.100000
  4.52418709017979661646258193741232389584183692932129e-02, // 0.200000
  6.45530982318793522534150497449445538222789764404297e-02, // 0.300000
  8.18730753077982070786688950647658202797174453735352e-02, // 0.400000
  9.73500978839256236874177830031840130686759948730469e-02, // 0.500000
  1.11122733102257675863455688158865086734294891357422e-01, // 0.600000
  1.23320415700774885237045452868187567219138145446777e-01, // 0.700000
  1.34064009207127882161714182984724175184965133666992e-01, // 0.800000
  1.43466334114899007889931681347661651670932769775391e-01, // 0.900000
  1.51632664928158356065779344135080464184284210205078e-01, // 1.000000
  1.58661197854633839732230171648552641272544860839844e-01, // 1.100000
  1.64643490828207977871855405282985884696245193481445e-01, // 1.200000
  1.69664877447330220139320999805931933224201202392578e-01, // 1.300000
  1.73804856326993328874408462070277892053127288818359e-01, // 1.400000
  1.77137457277880550066129217157140374183654785156250e-01, // 1.500000
  1.79731585646888653018393711136013735085725784301758e-01, // 1.600000
  1.81651346078208847378832047070318367332220077514648e-01, // 1.700000
  1.82956346883269616032663407168001867830753326416016e-01, // 1.800000
  1.83701986140888090526246401168464217334985733032227e-01, // 1.900000
  1.83939720585721167012138721474912017583847045898438e-01, // 2.000000
  2.49998750003124891658884930423223380557828932069242e-06, // 0.000010
  2.49999999987500469947063456538396118179756744126507e-11, // 0.000000
  2.90165911838962536917208012710034381598234176635742e-02, // 0.123457
  1.63268237473721905539392196260450873523950576782227e-01, // 3.141593
  1.74568986850316937298188690874667372554540634155273e-01, // 2.718282
  6.71229544108329911900057140883291140198707580566406e-02, // 0.314159
  5.93209026304169703691648862786678364500403404235840e-02, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_CDF_10 = { //
  2.49795133600650746949935939182803334990268240289879e-09, // 0.100000
  7.66780168618932654114059375288769970779867435339838e-08, // 0.200000
  5.58580784810275424538130676493929982484587526414543e-07, // 0.300000
  2.25819055295782344450553069670206696173409000039101e-06, // 0.400000
  6.61171056103424409242054135549260251991654513403773e-06, // 0.500000
  1.57850405416599700160560498796158412915247026830912e-05, // 0.600000
  3.27361747531325168996535479593035233847331255674362e-05, // 0.700000
  6.12433271023337950488690806238878394651692360639572e-05, // 0.800000
  1.05904769283482884140341895307102504375507123768330e-04, // 0.900000
  1.72115629955840721259513470542401591956149786710739e-04, // 1.000000
  2.66026240432705039958005688305320290965028107166290e-04, // 1.100000
  3.94486018340255682485678834225950595282483845949173e-04, // 1.200000
  5.64976348978787402434209585777580286958254873752594e-04, // 1.300000
  7.85535448953023811638485263131315150531008839607239e-04, // 1.400000
  1.06467777278579280725301359211698581930249929428101e-03, // 1.500000
  1.41131014588673502248294955307983400416560471057892e-03, // 1.600000
  1.83464647201952166591376602866603207075968384742737e-03, // 1.700000
  2.34412256627762561819738884594244154868647456169128e-03, // 1.800000
  2.94931240186648664300395061843573785154148936271667e-03, // 1.900000
  3.65984682734371308959753221756727725733071565628052e-03, // 2.000000
  2.60415581599546609733287774064553218283559941928103e-29, // 0.000010
  2.60416666655820244729903965275602508551632679775379e-54, // 0.000000
  7.09444350487475695446226334845915562077323102130322e-09, // 0.123457
  2.21073482327962915483521300075153703801333904266357e-02, // 3.141593
  1.27010572812203369197359137388048111461102962493896e-02, // 2.718282
  6.99320669493774398455519271389224655877114855684340e-07, // 0.314159
  3.45169511596339609613224696377242750600089493673295e-07, // 0.271828
  };

  public static final double[] SCIPY_CHISQ_PDF_10 = { //
  1.23857997981863822630169027876056997428122485871427e-07, // 0.100000
  1.88507795424158187552754212951144907606249034870416e-06, // 0.200000
  9.07777943885801461183782112840390254859812557697296e-06, // 0.300000
  2.72910251025994052959371821698297821967571508139372e-05, // 0.400000
  6.33789699765140417814235362925501249264925718307495e-05, // 0.500000
  1.25013074740039885346387649178723222576081752777100e-04, // 0.600000
  2.20306784298780056327235477020565213024383410811424e-04, // 0.700000
  3.57504024552340871068167871271725744009017944335938e-04, // 0.800000
  5.44723737342507358799581496100472577381879091262817e-04, // 0.900000
  7.89753463167491365562455918336581817129626870155334e-04, // 1.000000
  1.09988569971103010078361528201185137731954455375671e-03, // 1.100000
  1.48179141745387061429584107941082038450986146926880e-03, // 1.200000
  1.94142570704054513025527128888825245667248964309692e-03, // 1.300000
  2.48396107167327909875931268857129907701164484024048e-03, // 1.400000
  3.11374436621274317676943965693681093398481607437134e-03, // 1.500000
  3.83427382713362290000969068159974995069205760955811e-03, // 1.600000
  4.64819303792833159877373461199567827861756086349487e-03, // 1.700000
  5.55729903657931241511835906976557453162968158721924e-03, // 1.800000
  6.56256209864766217043641205464155063964426517486572e-03, // 1.900000
  7.66415502440504978198809737932606367394328117370605e-03, // 2.000000
  1.30207682293293247342964777423805818639678689634258e-23, // 0.000010
  1.30208333326823731527652024476599117068802519713176e-43, // 0.000000
  2.84373520508469333784316900384792070610728842439130e-07, // 0.123457
  2.63663549177880519869265896204524324275553226470947e-02, // 3.141593
  1.82620407865934676616692655670703970827162265777588e-02, // 2.718282
  1.08397546669860501598013635682349331545992754399776e-05, // 0.314159
  6.20568843801925594646975298251945218908076640218496e-06, // 0.271828
  };

  public static final double[] GNUR_CHISQ_CDF_10 = { //
  2.49795133600649837051262130852360976440706963330740e-09, // 0.100000
  7.66780168618931198276181281960062197100569392205216e-08, // 0.200000
  5.58580784810275424538130676493929982484587526414543e-07, // 0.300000
  2.25819055295782302098905706955189742757283966057003e-06, // 0.400000
  6.61171056103425340978296115279633227146405261009932e-06, // 0.500000
  1.57850405416599598516606828280117724716546945273876e-05, // 0.600000
  3.27361747531325507809714381313170861176331527531147e-05, // 0.700000
  6.12433271023336866286518320734444387198891490697861e-05, // 0.800000
  1.05904769283483060323194924201573030586587265133858e-04, // 0.900000
  1.72115629955840395998861724891071389720309525728226e-04, // 1.000000
  2.66026240432705039958005688305320290965028107166290e-04, // 1.100000
  3.94486018340255411435135712849842093419283628463745e-04, // 1.200000
  5.64976348978787619274644082878467088448815047740936e-04, // 1.300000
  7.85535448953025112681092245736635959474369883537292e-04, // 1.400000
  1.06467777278579280725301359211698581930249929428101e-03, // 1.500000
  1.41131014588673415512121156467628679820336401462555e-03, // 1.600000
  1.83464647201952231643506951996869247523136436939240e-03, // 1.700000
  2.34412256627762518451651985174066794570535421371460e-03, // 1.800000
  2.94931240186649314821698553146234189625829458236694e-03, // 1.900000
  3.65984682734371439064013920017259806627407670021057e-03, // 2.000000
  2.60415581599546665785226347057236055232743273524748e-29, // 0.000010
  2.60416666655812826317602590432831045081109584496352e-54, // 0.000000
  7.09444350487472965750204909854588486428639271252905e-09, // 0.123457
  2.21073482328017455189606010890202014707028865814209e-02, // 3.141593
  1.27010572812377743601164326037178398109972476959229e-02, // 2.718282
  6.99320669493999391582133694916789679041357885580510e-07, // 0.314159
  3.45169511596932850313657926977217726971502997912467e-07, // 0.271828
  };

  public static final double[] GNUR_CHISQ_PDF_10 = { //
  1.23857997981864007918626239754256168623669509543106e-07, // 0.100000
  1.88507795424158484014285751956263581519124272745103e-06, // 0.200000
  9.07777943885802816436497719720932764175813645124435e-06, // 0.300000
  2.72910251025994493416504393934474137495271861553192e-05, // 0.400000
  6.33789699765140824390050044989664002059726044535637e-05, // 0.500000
  1.25013074740039749821116088490668971644481644034386e-04, // 0.600000
  2.20306784298780218957561349846230314142303541302681e-04, // 0.700000
  3.57504024552340437387298877069952141027897596359253e-04, // 0.800000
  5.44723737342507684060233241751802779617719352245331e-04, // 0.900000
  7.89753463167491907663542161088798820856027305126190e-04, // 1.000000
  1.09988569971102879974100829940653056837618350982666e-03, // 1.100000
  1.48179141745387169849801356491525439196266233921051e-03, // 1.200000
  1.94142570704054556393614028309002605965360999107361e-03, // 1.300000
  2.48396107167327953244018168277307267999276518821716e-03, // 1.400000
  3.11374436621274404413117764534035813994705677032471e-03, // 1.500000
  3.83427382713362723681838062361748598050326108932495e-03, // 1.600000
  4.64819303792833680294416254241696151439100503921509e-03, // 1.700000
  5.55729903657931414984183504657266894355416297912598e-03, // 1.800000
  6.56256209864766303779815004304509784560650587081909e-03, // 1.900000
  7.66415502440505238407331134453670529183000326156616e-03, // 2.000000
  1.30207682293293908558537114960529051053980877147452e-23, // 0.000010
  1.30208333326823472650216465453104099875737882460008e-43, // 0.000000
  2.84373520508469280844757696991020878840572549961507e-07, // 0.123457
  2.63663549177922673649732132616918534040451049804688e-02, // 3.141593
  1.82620407866104020322417511579260462895035743713379e-02, // 2.718282
  1.08397546669888199575388851303436865691764978691936e-05, // 0.314159
  6.20568843802768815945966954239487733957503223791718e-06, // 0.271828
  };

  public static final double[] P_QUANT = { //
  0.0001, 0.001, 0.01, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999 //
  };

  public static final double[] SCIPY_CHISQ_QUANT_01 = { //
  1.16892641156733644781219710813445996321826192936318e-80, // 0.000100
  1.16892641146821240352815603348024825656653422803765e-60, // 0.001000
  1.16892641145814869325987350586058419394529211182657e-40, // 0.010000
  1.16892641145721739436487227654675467673153240504758e-20, // 0.100000
  1.06313237798343417157777858600350238808297798076552e-12, // 0.250000
  1.11477568814925462586246096563513674482237547636032e-06, // 0.500000
  3.71347136769252343657665704768078285269439220428467e-03, // 0.750000
  1.52634227818377987695441788673633709549903869628906e-01, // 0.900000
  2.17525480018361871970000720466487109661102294921875e+00, // 0.990000
  5.47291719745734983604279477731324732303619384765625e+00, // 0.999000
  9.24820164420099821711573895299807190895080566406250e+00, // 0.999900
  };

  public static final double[] GNUR_CHISQ_QUANT_01 = { //
  1.16892641145733484384707827779994069422035569294114e-80, // 0.000100
  1.16892641145731079523768921414073055688308402765104e-60, // 0.001000
  1.16892641145731997959243769324569198659341653028700e-40, // 0.010000
  1.16892641145730436213892351266574423573550225567180e-20, // 0.100000
  1.06313237798339660917691558230537590321561347561641e-12, // 0.250000
  1.11477568814925102597243513485869570445174758788198e-06, // 0.500000
  3.71347136769249915044799337238146108575165271759033e-03, // 0.750000
  1.52634227818377238294900166692968923598527908325195e-01, // 0.900000
  2.17525480018361827561079735460225492715835571289062e+00, // 0.990000
  5.47291719745735161239963417756371200084686279296875e+00, // 0.999000
  9.24820164420099821711573895299807190895080566406250e+00, // 0.999900
  };

  public static final double[] SCIPY_CHISQ_QUANT_1 = { //
  1.57079633500628175845386844643181145642074625357054e-08, // 0.000100
  1.57079714926323284399762268692679612058782367967069e-06, // 0.001000
  1.57087857909697853949632095904576090106274932622910e-04, // 0.010000
  1.57907740934312285085994176370149943977594375610352e-02, // 0.100000
  1.01531044267621481380636794256133725866675376892090e-01, // 0.250000
  4.54936423119572663775755927417776547372341156005859e-01, // 0.500000
  1.32330369693146554510576606844551861286163330078125e+00, // 0.750000
  2.70554345409541641132022959936875849962234497070312e+00, // 0.900000
  6.63489660102121447948775312397629022598266601562500e+00, // 0.990000
  1.08275661706627310820749698905274271965026855468750e+01, // 0.999000
  1.51367052266236044033576035872101783752441406250000e+01, // 0.999900
  };

  public static final double[] GNUR_CHISQ_QUANT_1 = { //
  1.57079633501956727170820513452345612570582034095423e-08, // 0.000100
  1.57079714926249020786111747910451796883535280358046e-06, // 0.001000
  1.57087857909702001022941852959036168613238260149956e-04, // 0.010000
  1.57907740934312285085994176370149943977594375610352e-02, // 0.100000
  1.01531044267621550769575833328417502343654632568359e-01, // 0.250000
  4.54936423119572830309209621191257610917091369628906e-01, // 0.500000
  1.32330369693146598919497591850813478231430053710938e+00, // 0.750000
  2.70554345409541507905260004918090999126434326171875e+00, // 0.900000
  6.63489660102121181495249402360059320926666259765625e+00, // 0.990000
  1.08275661706627310820749698905274271965026855468750e+01, // 0.999000
  1.51367052266236044033576035872101783752441406250000e+01, // 0.999900
  };

  public static final double[] SCIPY_CHISQ_QUANT_2 = { //
  2.00010000666460950081992908877737136208452284336090e-04, // 0.000100
  2.00100066716752279100122180466314603108912706375122e-03, // 0.001000
  2.01006717070028942395687465705123031511902809143066e-02, // 0.010000
  2.10721031315652534976479159922746475785970687866211e-01, // 0.100000
  5.75364144903561913757528145652031525969505310058594e-01, // 0.250000
  1.38629436111989057245352796599036082625389099121094e+00, // 0.500000
  2.77258872223978158899626578204333782196044921875000e+00, // 0.750000
  4.60517018598809180218722758581861853599548339843750e+00, // 0.900000
  9.21034037197618005166077637113630771636962890625000e+00, // 0.990000
  1.38155105579642718538480039569549262523651123046875e+01, // 0.999000
  1.84206807439525839242833171738311648368835449218750e+01, // 0.999900
  };

  public static final double[] GNUR_CHISQ_QUANT_2 = { //
  2.00010000666716686269427927236108644137857481837273e-04, // 0.000100
  2.00100066716706699240790889859908929793164134025574e-03, // 0.001000
  2.01006717070028838312278907096697366796433925628662e-02, // 0.010000
  2.10721031315652618243206006809487007558345794677734e-01, // 0.100000
  5.75364144903561802735225683136377483606338500976562e-01, // 0.250000
  1.38629436111989057245352796599036082625389099121094e+00, // 0.500000
  2.77258872223978114490705593198072165250778198242188e+00, // 0.750000
  4.60517018598809180218722758581861853599548339843750e+00, // 0.900000
  9.21034037197618005166077637113630771636962890625000e+00, // 0.990000
  1.38155105579642718538480039569549262523651123046875e+01, // 0.999000
  1.84206807439525839242833171738311648368835449218750e+01, // 0.999900
  };

  public static final double[] SCIPY_CHISQ_QUANT_4 = { //
  2.84184752435540088910670419863890856504440307617188e-02, // 0.000100
  9.08040355389811981723369171959348022937774658203125e-02, // 0.001000
  2.97109480506531686838656014515436254441738128662109e-01, // 0.010000
  1.06362321677922411211625330906827002763748168945312e+00, // 0.100000
  1.92255752622955422559414273564470931887626647949219e+00, // 0.250000
  3.35669398003332153379574265272822231054306030273438e+00, // 0.500000
  5.38526905777939113306729268515482544898986816406250e+00, // 0.750000
  7.77944033973485904454037154209800064563751220703125e+00, // 0.900000
  1.32767041359876234452030985266901552677154541015625e+01, // 0.990000
  1.84668269529031690012743638362735509872436523437500e+01, // 0.999000
  2.35127424449910797932261630194261670112609863281250e+01, // 0.999900
  };

  public static final double[] GNUR_CHISQ_QUANT_4 = { //
  2.84184752435549976834483487664329004473984241485596e-02, // 0.000100
  9.08040355389791442597413606563350185751914978027344e-02, // 0.001000
  2.97109480506531964394412170804571360349655151367188e-01, // 0.010000
  1.06362321677922389007164838403696194291114807128906e+00, // 0.100000
  1.92255752622955400354953781061340123414993286132812e+00, // 0.250000
  3.35669398003332108970653280266560614109039306640625e+00, // 0.500000
  5.38526905777939202124571238528005778789520263671875e+00, // 0.750000
  7.77944033973485904454037154209800064563751220703125e+00, // 0.900000
  1.32767041359876216688462591264396905899047851562500e+01, // 0.990000
  1.84668269529031690012743638362735509872436523437500e+01, // 0.999000
  2.35127424449910762405124842189252376556396484375000e+01, // 0.999900
  };

  public static final double[] SCIPY_CHISQ_QUANT_10 = { //
  8.88920357912773129172023800492752343416213989257812e-01, // 0.000100
  1.47874346383567578655515717400703579187393188476562e+00, // 0.001000
  2.55821216018720765106309045222587883472442626953125e+00, // 0.010000
  4.86518205192532882108480407623574137687683105468750e+00, // 0.100000
  6.73720077195464384089973464142531156539916992187500e+00, // 0.250000
  9.34181776559196919151872862130403518676757812500000e+00, // 0.500000
  1.25488613968893769623491607489995658397674560546875e+01, // 0.750000
  1.59871791721052627366361775784753262996673583984375e+01, // 0.900000
  2.32092511589543590844186837784945964813232421875000e+01, // 0.990000
  2.95882984450744146442957571707665920257568359375000e+01, // 0.999000
  3.55640139419523890751406725030392408370971679687500e+01, // 0.999900
  };

  public static final double[] GNUR_CHISQ_QUANT_10 = { //
  8.88920357912895919838547342806123197078704833984375e-01, // 0.000100
  1.47874346383566490636951584747293964028358459472656e+00, // 0.001000
  2.55821216018720631879546090203803032636642456054688e+00, // 0.010000
  4.86518205192532882108480407623574137687683105468750e+00, // 0.100000
  6.73720077195464206454289524117484688758850097656250e+00, // 0.250000
  9.34181776559196741516188922105357050895690917968750e+00, // 0.500000
  1.25488613968893769623491607489995658397674560546875e+01, // 0.750000
  1.59871791721052591839224987779743969440460205078125e+01, // 0.900000
  2.32092511589543590844186837784945964813232421875000e+01, // 0.990000
  2.95882984450744181970094359712675213813781738281250e+01, // 0.999000
  3.55640139419523890751406725030392408370971679687500e+01, // 0.999900
  };

  @Test
  public void testPDF() {
    checkPDF(new ChiSquaredDistribution(1.), P_CDFPDF, SCIPY_CHISQ_PDF_1, 1e-12);
    checkPDF(new ChiSquaredDistribution(2.), P_CDFPDF, SCIPY_CHISQ_PDF_2, 1e-12);
    checkPDF(new ChiSquaredDistribution(4.), P_CDFPDF, SCIPY_CHISQ_PDF_4, 1e-12);
    checkPDF(new ChiSquaredDistribution(10), P_CDFPDF, SCIPY_CHISQ_PDF_10, 1e-12);
    checkPDF(new ChiSquaredDistribution(.1), P_CDFPDF, SCIPY_CHISQ_PDF_01, 1e-12);
    checkPDF(new ChiSquaredDistribution(1.), P_CDFPDF, GNUR_CHISQ_PDF_1, 1e-14);
    checkPDF(new ChiSquaredDistribution(2.), P_CDFPDF, GNUR_CHISQ_PDF_2, 1e-15);
    checkPDF(new ChiSquaredDistribution(4.), P_CDFPDF, GNUR_CHISQ_PDF_4, 1e-15);
    checkPDF(new ChiSquaredDistribution(10), P_CDFPDF, GNUR_CHISQ_PDF_10, 1e-15);
    checkPDF(new ChiSquaredDistribution(.1), P_CDFPDF, GNUR_CHISQ_PDF_01, 1e-14);
  }

  @Test
  public void testCDF() {
    checkCDF(new ChiSquaredDistribution(1.), P_CDFPDF, SCIPY_CHISQ_CDF_1, 1e-12);
    checkCDF(new ChiSquaredDistribution(2.), P_CDFPDF, SCIPY_CHISQ_CDF_2, 1e-12);
    checkCDF(new ChiSquaredDistribution(4.), P_CDFPDF, SCIPY_CHISQ_CDF_4, 1e-12);
    checkCDF(new ChiSquaredDistribution(10), P_CDFPDF, SCIPY_CHISQ_CDF_10, 1e-11);
    checkCDF(new ChiSquaredDistribution(.1), P_CDFPDF, SCIPY_CHISQ_CDF_01, 1e-13);
    checkCDF(new ChiSquaredDistribution(1.), P_CDFPDF, GNUR_CHISQ_CDF_1, 1e-15);
    checkCDF(new ChiSquaredDistribution(2.), P_CDFPDF, GNUR_CHISQ_CDF_2, 1e-15);
    checkCDF(new ChiSquaredDistribution(4.), P_CDFPDF, GNUR_CHISQ_CDF_4, 1e-15);
    checkCDF(new ChiSquaredDistribution(10), P_CDFPDF, GNUR_CHISQ_CDF_10, 1e-15);
    checkCDF(new ChiSquaredDistribution(.1), P_CDFPDF, GNUR_CHISQ_CDF_01, 1e-14);
  }

  @Test
  public void testQuantile() {
    checkQuantile(new ChiSquaredDistribution(1.), P_QUANT, SCIPY_CHISQ_QUANT_1, 1e-13);
    checkQuantile(new ChiSquaredDistribution(2.), P_QUANT, SCIPY_CHISQ_QUANT_2, 1e-13);
    checkQuantile(new ChiSquaredDistribution(4.), P_QUANT, SCIPY_CHISQ_QUANT_4, 1e-13);
    checkQuantile(new ChiSquaredDistribution(10), P_QUANT, SCIPY_CHISQ_QUANT_10, 1e-12);
    checkQuantile(new ChiSquaredDistribution(.1), P_QUANT, SCIPY_CHISQ_QUANT_01, 1e-13);
    checkQuantile(new ChiSquaredDistribution(1.), P_QUANT, GNUR_CHISQ_QUANT_1, 1e-13);
    checkQuantile(new ChiSquaredDistribution(2.), P_QUANT, GNUR_CHISQ_QUANT_2, 1e-14);
    checkQuantile(new ChiSquaredDistribution(4.), P_QUANT, GNUR_CHISQ_QUANT_4, 1e-13);
    checkQuantile(new ChiSquaredDistribution(10), P_QUANT, GNUR_CHISQ_QUANT_10, 1e-13);
    checkQuantile(new ChiSquaredDistribution(.1), P_QUANT, GNUR_CHISQ_QUANT_01, 1e-13);
  }
}