# debdry

Debian, Don't Repeat Yourself.

debdry is a tool for semi-assisted automatic Debian packaging. It tries to be
for entire debian/ directories what debhelper7 is for debian/rules.

Most upstreams already provide a reasonable amount of packaging metadata in
their tarballs, and we already have auto-debianisation tools that generate a
reasonable debian/ directory from them, requiring few manual edits to be ready
for upload.

There is no reason to rewrite upstream package descriptions, dependencies, and
so on. If an upstream's tarball packaging can use improvements, instead of
working around it in `debian/` we can improve it and send upstream our patch:
*we will give back to the free software community*.

## How it works

When `debdry` is run, it:

1. moves the contents of your `debian/` directory aside;
2. it chooses and runs an automatic debianisation tool;
3. it applies your manual changes on top of the autogenerated `debian/`, to
   produce the final source package;
4. it stores the original `debian/` directory in `debian/debdry` so that the
   process can be reversed.

## Merging

This section describes the merging logic so far. The merging happens between an
`auto` directory and a `manual` directory, to generate the `debian` directory.

* If a file exists in `manual` but not in `auto`, then it is copied to `debian`.
* If a file exists in `auto` but not in `manual`, then it is copied to `debian`.
* `changelog` is always copied from `manual` to `debian`.
* `rules`: see Merging `debian/rules` below.
* `control`: see "Merging `debian/control`" below.
* Any other file that exists in both directories is copied from `manual` to
  `debian`.

### Merging `debian/rules`

If `rules` in `manual` starts with `#!`, then it is copied to `debian`.

If `rules` in `manual` does not start with `#!`, then the version in `manual`
is appended to the version in `auto` to create the version for `debian`.

The rationale for this is that the auto-generated `debian/rules` file will
generally be a simple debhelper invocation, and if any changes are needed to
that, they are likely to be in the form of overrides. One just needs to
maintain the overrides, and `debdry` will append them to the autogenerated
`debian/rules`.

### Merging `debian/control`

Control files are merged on a section by section basis. Sections are identified
by their `Source:` or `Package:` fields.

The `control` file in `debian` is built by concatenating:

1. The merged source section from the `manual` and `auto` control files.
2. All the binary sections that are in `auto` but not in `manual`.
3. All the binary sections that are in `manual` but not in `auto`. 

Sections are merged as follows:

* All fields from `auto` are used.
* All fields that exist in `manual` but not in `auto` are added.
* For all fields that exist in both, the version from `manual` is used.

If a field in `manual` starts with `X-Debdry-`, then the `X-Debdry-` prefix is
stripped and the field contents are merged smartly. See "Smart merging" below.

After merging, the fields appear in the order suggested by libapt-pkg.

### Smart merging

`manual` fields starting with `X-Debdry-` are merged smartly into their `auto`
counterpart. Smart merging is implemented for `Uploaders:` fields and all
fields that list package dependencies.

If `auto` is missing, the field contents are taken as is.

If `auto` exists, then:

* If an uploader email address, or a package name, exists in both values, the
  version from `manual` is used.
* Otherwise, the `manual` value is appended to the `auto` fields.

This can be used to add uploaders or dependencies, to fix uploader names, and
to tweak versioning constraints in dependencies.

## Auto-packaging tools by language

### Python

The tool is [python-stdeb](https://pypi.python.org/pypi/stdeb/), supported by
debdry.

### perl

The tool is [dh-make-perl](http://search.cpan.org/~dam/DhMakePerl-0.72/dh-make-perl),
supported by debdry.

### ruby

The tool is [dh-make-ruby](https://wiki.debian.org/Teams/Ruby/Packaging#gem2deb_as_the_preferred_packaging_tool_for_ruby_software),
supported by debdry.

### autotools

I cannot think of anything better than [dh-make](https://packages.debian.org/search?keywords=dh-make)
at the moment, but I haven't spent much time thinking about it yet.

### haskell

The tool is [cabal-debian](https://hackage.haskell.org/package/cabal-debian),
supported by debdry.

### node.js

[npm2debian](https://github.com/arikon/npm2debian) exists; I need help from
someone who uses it to add support to debdry and test it.

## Diffing

You can run `debdry` with `--dry` on an existing package to create
`debian/debdry` with a simplified version of the packaging.

The result currently needs manual tweaking:

* generation of `X-Debdry-` fields is not supported, so the `control` file will
  not be as small as it can be.
* generation of `debian/rules` deltas is not supported: a
  `debian/debdry/rules.diff` will be generated instead.

## Rationale

I'm generally fond of the DRY principle (http://c2.com/cgi/wiki?DontRepeatYourself)
but every time I package software for Debian I feel WET (Write
Everything Twice) instead.

Many upstream ecosystems have started including enough metadata in their
upstream packaging to significantly overlap with debian/. Think
short/long descriptions, upstream URLs, licenses, dependencies.

When the upstream packaging is well made, there is usually not much else
to add to a dh-make-equivalent initial boilerplate code, besides testing
and taking responsibility for it. Maintaining software in Debian should
be about testing and taking responsibility for it, not about retyping
things that upstream has already typed.

What if upstream got it wrong? It often happens. In that case, we can
patch their sources, and send them the patch. That way, instead of
having our own private work-arounds, we make the packaging better for
everyone, even those who do not use Debian.

The idea of debdry is to regenerate the debian/ directory every time a new
version of the software is packaged, using the dh-make-equivalent for the given
package type. It then takes manually maintained data and uses it to complete
the packaging.

At each new version there is a chance for the debianisation to be
updated: the Python team switches from dh_pysupport to dh_python2? Your
package will automatically follow (provided python-stdeb is updated
accordingly, but that is another story).

I like how with debhelper7 we are writing debian/rules files that only
describe how the package diverges from a standard. I want to do exactly
the same for the whole debian/ directory. Ideally, the debian.in/
directory used by debdry should only describe how the upstream packaging
diverges from a standard in a way that cannot be fixed by patching it.

I have no intention of having debdry replace hand-writing debian/
directories, nor have it handle all possible corner cases. I aim at it
being useful in the general case. I want to address the ordinary,
routine, boring work, and leave the rest as it is.

## TODO list

* Remove need for identifying source/binary stanzas, since we know that some
  fields are only in one or the other. This means that single-binary packages
  do not need to mark debian/control stanzas with `Source: name` or
  `Package: name` fields.
* Add a README.Source or README.Debdry to the generated debian/ directory,
  explaining that the hand-maintained files are actually in debian/debdry.
* Add a debdry-specific conffile in debian/ to allow to specify a custom
  command (or list of commands) for auto-debianisation.
