#ifndef outputbuffer_H__
#define outputbuffer_H__

#include <stdlib.h>
#include <iostream>
using namespace std;
#include <boost/shared_ptr.hpp>

namespace rpc {

/**
 * \brief A data accumulator.
 * This class is esentially a wrapper around a byte array which provides writing methods and automatic expantion.
 */
class OutputBuffer
{
public:
  OutputBuffer() { init(4*1024,4*1024); }
  OutputBuffer(int initialSize,int sizeIncrement) { init(initialSize,sizeIncrement); }
  ~OutputBuffer() { free(buf); }
  
  /** Resets the buffer so that it can be reused */
  void clear() {size = 0;}
  /** Returns a pointer to the data written to this buffer */
  const char* getByteArray() const {return buf;}
  /** Returs the size of the data written to this buffer */
  int getSize() const {return size;}

  /** Writes some data to the buffer, expanding it as necessary */
  void write(const void* data, int numBytes) {
    if(numBytes > capacity-size) {
  		while(numBytes > capacity-size) capacity+=increment;
      buf = (char*)realloc(buf,capacity);
    }
    memcpy(buf+size,data,numBytes);
    size+=numBytes;
  }

private:
  char* buf;
  int capacity;
  int size;
  int increment;

  void init(int aSize,int aIncrement) {
    buf = (char*)malloc(aSize);
    increment = aIncrement;
    size = 0;
    capacity = aSize;
  }

};

typedef boost::shared_ptr<OutputBuffer> OutputBufferPtr;
}

#endif
