#include "sys"
#include "../config/config"

bool ipmatch (struct in_addr adr, struct in_addr mask) {
    PROFILE("ipmatch");
    
    long laddr = 0, lmask = 0;
    memcpy (&laddr, &adr,  sizeof(adr));
    memcpy (&lmask, &mask, sizeof(mask));
    bool match = ( (laddr & lmask) == laddr );

    debugmsg("Matching ip " << inet2string(adr) << " against mask " <<
	     inet2string(mask) << ": " <<
	     (match ? "match" : "miss") << '\n');
    
    return (match);
}
