#include "memory"

void *Memory::realloc(void *ptr, size_t newsz, string const &desc) {
    if (!newsz) {
	free(ptr);
	return 0;
    } else {
	for (unsigned i = 0; i < s_memlog.size(); i++) {
	    MemoryEntry ent = s_memlog[i];
	    if (ent.ptr == ptr) {
		ent.ptr = ::realloc(ptr, newsz);
		ent.sz = newsz;
		ent.desc = desc;
		Mutex::lock(&s_memlog);
		s_memlog[i] = ent;
		Mutex::unlock(&s_memlog);
		if (s_follow) {
		    Mutex::lock(&cout);
		    cout << "Memory::realloc(" << ptr << ", " << newsz
			 << ") -> " << ent.ptr << ' ' << desc << '\n';
		    Mutex::unlock(&cout);
		}
		return ent.ptr;
	    }
	}
	cerr << "REALLOC Request for non previously allocated memory\n";
    }
    return 0;
}
