# GSL_CHECK_LIBS
#---------------
# Checks for the GSL libraries and header files.
AC_DEFUN([GSL_CHECK_LIBS],
[

    AC_MSG_CHECKING([for GSL])

    gsl_check_gsl_lib="-lgsl -lgslcblas"

    gsl_includes=""
    gsl_ldflags=""

    AC_ARG_WITH(gsl,
                AS_HELP_STRING([--with-gsl],
                               [location where GSL is installed]),
                [
                    gsl_with_gsl_includes=$withval/include
                    # opensuse defaults also non systems installations to lib64 ...
                    gsl_with_gsl_libs="-L$withval/lib -L$withval/lib64 -L$withval/lib32"
                ])

    AC_ARG_WITH(gsl-includes,
                AS_HELP_STRING([--with-gsl-includes],
                               [location of the GSL header files]),
                gsl_with_gsl_includes=$withval)

    AC_ARG_WITH(gsl-libs,
                AS_HELP_STRING([--with-gsl-libs],
                               [location of the GSL library]),
                gsl_with_gsl_libs=-L$withval)

    AC_ARG_ENABLE(gsl-test,
                  AS_HELP_STRING([--disable-gsl-test],
                                 [disables checks for the GSL library and headers]),
                  gsl_enable_gsl_test=$enableval,
                  gsl_enable_gsl_test=yes)


    if test "x$gsl_enable_gsl_test" = xyes; then

        AC_MSG_CHECKING(checking for gsl)
        save_LDFLAGS="$LDFLAGS"
        save_LIBS="$LIBS"
        save_CFLAGS="$CFLAGS"
        if test -n "$gsl_with_gsl_libs"; then
            LDFLAGS="$gsl_with_gsl_libs"
        elif test -n "$GSLDIR"; then
            LDFLAGS="-L$GSLDIR/lib -L$GSLDIR/lib64 -L$GSLDIR/lib32"
        fi
        if test -n "$gsl_with_gsl_includes"; then
            CFLAGS="-I$gsl_with_gsl_includes"
        elif test -n "$GSLDIR"; then
            CFLAGS="-I$GSLDIR/include"
        fi
        LIBS=$gsl_check_gsl_lib

        AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <gsl/gsl_sf_bessel.h>]], [[gsl_sf_bessel_J0(5.);]])],[
                        AC_MSG_RESULT(yes)
                        gsl_includes=$CFLAGS
                        gsl_ldflags=$LDFLAGS
                    ],[
                        AC_MSG_ERROR([GSL not found])
                    ])

        # Set up the symbols
        AC_DEFINE_UNQUOTED(HAVE_GSL, 1, [Define to 1 iff you have GSL])

        GSL_INCLUDES="$gsl_includes"
        GSL_LDFLAGS="$gsl_ldflags"
        GSL_LIBS="$gsl_check_gsl_lib"
        LDFLAGS="$save_LDFLAGS"
        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"
    else
        AC_MSG_RESULT([disabled])
        AC_MSG_WARN([GSL checks have been disabled! This package may not build!])
        GSL_INCLUDES=""
        GSL_LDFLAGS=""
        GSL_LIBS=""
    fi

    AC_SUBST(GSL_INCLUDES)
    AC_SUBST(GSL_LDFLAGS)
    AC_SUBST(GSL_LIBS)

])
