// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROMEOS_SERVICES_LIBASSISTANT_AUDIO_FAKE_INPUT_DEVICE_H_
#define CHROMEOS_SERVICES_LIBASSISTANT_AUDIO_FAKE_INPUT_DEVICE_H_

#include "base/memory/scoped_refptr.h"

namespace media {
class AudioCapturerSource;
}  // namespace media

namespace chromeos {
namespace libassistant {

// Create a fake input device. When asked to record input, it will read the
// input from an audio file generated by the chromeos/assistant/send-audio.sh
// script.
scoped_refptr<media::AudioCapturerSource> CreateFakeInputDevice();

}  // namespace libassistant
}  // namespace chromeos

#endif  // CHROMEOS_SERVICES_LIBASSISTANT_AUDIO_FAKE_INPUT_DEVICE_H_
