// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "Imageset.pypp.hpp"

namespace bp = boost::python;

void register_Imageset_class(){

    { //::CEGUI::Imageset
        typedef bp::class_< CEGUI::Imageset > Imageset_exposer_t;
        Imageset_exposer_t Imageset_exposer = Imageset_exposer_t( "Imageset", "*!\n\
        \n\
           Offers functions to define, access, and draw, a set of image components on a single graphical\
           surface or Texture.\n\
        \n\
           Imageset objects are a means by which a single graphical image (file, Texture, etc), can be split\
           into a number\n\
           of 'components' which can later be accessed via name.  The components of an Imageset can queried\
           for\n\
           various details, and sent to the Renderer object for drawing.\n\
        *\n", bp::init< CEGUI::String const &, CEGUI::Texture & >(( bp::arg("name"), bp::arg("texture") ), "*!\n\
           \n\
              Construct a new Imageset object.  Object will initially have no Images defined\n\
        \n\
           @param texture\n\
              Texture object that holds the imagery for the Imageset being created.\n\
           *\n") );
        bp::scope Imageset_scope( Imageset_exposer );
        Imageset_exposer.def( bp::init< CEGUI::String const &, CEGUI::String const &, CEGUI::String const & >(( bp::arg("name"), bp::arg("filename"), bp::arg("resourceGroup") ), "*!\n\
           \n\
                Construct a new Imageset using the specified image file and imageset name.  The created\n\
                imageset will, by default, have a single Image defined named full_image which represents\n\
                the entire area of the loaded image file.\n\
        \n\
            \note\n\
                Under certain renderers it may be required that the source image dimensions be some\n\
                power of 2, if this condition is not met then stretching and other undesired side-effects\n\
                may be experienced.  To be safe from such effects it is generally recommended that all\n\
                images that you load have dimensions that are some power of 2.\n\
        \n\
            @param name\n\
                String object holding the name to be assigned to the created imageset.\n\
        \n\
            @param filename\n\
                String object holding the filename of the image that is to be loaded.  The image should be\n\
                of some format that is supported by the Renderer that is in use.\n\
        \n\
            @param resourceGroup\n\
                Resource group identifier to be passed to the resource manager, which may specify a group\n\
                from which the image file is to be loaded.\n\
        \n\
            @exception FileIOException thrown if something goes wrong while loading the image.\n\
            *\n") );
        { //::CEGUI::Imageset::defineImage
        
            typedef void ( ::CEGUI::Imageset::*defineImage_function_type )( ::CEGUI::String const &,::CEGUI::Point const &,::CEGUI::Size const &,::CEGUI::Point const & ) ;
            
            Imageset_exposer.def( 
                "defineImage"
                , defineImage_function_type( &::CEGUI::Imageset::defineImage )
                , ( bp::arg("name"), bp::arg("position"), bp::arg("size"), bp::arg("render_offset") )
                , "*!\n\
               \n\
                  Define a new Image for this Imageset\n\
            \n\
               @param name\n\
                  String object holding the name that will be assigned to the new Image, which must be unique\
                  within the Imageset.\n\
            \n\
               @param position\n\
                  Point object describing the pixel location of the Image on the image file  texture associated\
                  with this Imageset.\n\
            \n\
               @param size\n\
                  Size object describing the dimensions of the Image, in pixels.\n\
            \n\
               @param render_offset\n\
                  Point object describing the offsets, in pixels, that are to be applied to the Image when it is\
                  drawn.\n\
            \n\
               @return\n\
                  Nothing\n\
            \n\
               @exception AlreadyExistsException   thrown if an Image named  name is already defined for this\
               Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::defineImage
        
            typedef void ( ::CEGUI::Imageset::*defineImage_function_type )( ::CEGUI::String const &,::CEGUI::Rect const &,::CEGUI::Point const & ) ;
            
            Imageset_exposer.def( 
                "defineImage"
                , defineImage_function_type( &::CEGUI::Imageset::defineImage )
                , ( bp::arg("name"), bp::arg("image_rect"), bp::arg("render_offset") )
                , "*!\n\
               \n\
                  Define a new Image for this Imageset\n\
            \n\
               @param name\n\
                  String object holding the name that will be assigned to the new Image, which must be unique\
                  within the Imageset.\n\
            \n\
               @param image_rect\n\
                  Rect object describing the area on the image file  texture associated with this Imageset that\
                  will be used for the Image.\n\
            \n\
               @param render_offset\n\
                  Point object describing the offsets, in pixels, that are to be applied to the Image when it is\
                  drawn.\n\
            \n\
               @return\n\
                  Nothing\n\
            \n\
               @exception AlreadyExistsException   thrown if an Image named  name is already defined for this\
               Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::draw
        
            typedef void ( ::CEGUI::Imageset::*draw_function_type )( ::CEGUI::GeometryBuffer &,::CEGUI::Rect const &,::CEGUI::Rect const &,::CEGUI::Rect const *,::CEGUI::ColourRect const &,::CEGUI::QuadSplitMode ) const;
            
            Imageset_exposer.def( 
                "draw"
                , draw_function_type( &::CEGUI::Imageset::draw )
                , ( bp::arg("buffer"), bp::arg("source_rect"), bp::arg("dest_rect"), bp::arg("clip_rect"), bp::arg("colours"), bp::arg("quad_split_mode") ) );
        
        }
        { //::CEGUI::Imageset::draw
        
            typedef void ( ::CEGUI::Imageset::*draw_function_type )( ::CEGUI::GeometryBuffer &,::CEGUI::Rect const &,::CEGUI::Rect const &,::CEGUI::Rect const *,::CEGUI::colour const &,::CEGUI::colour const &,::CEGUI::colour const &,::CEGUI::colour const &,::CEGUI::QuadSplitMode ) const;
            
            Imageset_exposer.def( 
                "draw"
                , draw_function_type( &::CEGUI::Imageset::draw )
                , ( bp::arg("buffer"), bp::arg("source_rect"), bp::arg("dest_rect"), bp::arg("clip_rect"), bp::arg("top_left_colour")=4294967295u, bp::arg("top_right_colour")=4294967295u, bp::arg("bottom_left_colour")=4294967295u, bp::arg("bottom_right_colour")=4294967295u, bp::arg("quad_split_mode")=::CEGUI::TopLeftToBottomRight ) );
        
        }
        { //::CEGUI::Imageset::getDefaultResourceGroup
        
            typedef ::CEGUI::String const & ( *getDefaultResourceGroup_function_type )(  );
            
            Imageset_exposer.def( 
                "getDefaultResourceGroup"
                , getDefaultResourceGroup_function_type( &::CEGUI::Imageset::getDefaultResourceGroup )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Returns the default resource group currently set for Imagesets.\n\
            \n\
                @return\n\
                    String describing the default resource group identifier that will be\n\
                    used when loading Imageset data.\n\
                *\n" );
        
        }
        { //::CEGUI::Imageset::getImage
        
            typedef ::CEGUI::Image const & ( ::CEGUI::Imageset::*getImage_function_type )( ::CEGUI::String const & ) const;
            
            Imageset_exposer.def( 
                "getImage"
                , getImage_function_type( &::CEGUI::Imageset::getImage )
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
               \n\
                  return a copy of the Image object for the named image\n\
            \n\
               @param name\n\
                  String object holding the name of the Image object to be returned\n\
            \n\
               @return\n\
                  constant Image object that has the requested name.\n\
            \n\
               @exception UnknownObjectException   thrown if no Image named  name is defined for the Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getImageCount
        
            typedef ::CEGUI::uint ( ::CEGUI::Imageset::*getImageCount_function_type )(  ) const;
            
            Imageset_exposer.def( 
                "getImageCount"
                , getImageCount_function_type( &::CEGUI::Imageset::getImageCount )
                , "*!\n\
               \n\
                  return number of images defined for this Imageset\n\
            \n\
               @return\n\
                  uint value equal to the number of Image objects defined for the Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getImageHeight
        
            typedef float ( ::CEGUI::Imageset::*getImageHeight_function_type )( ::CEGUI::String const & ) const;
            
            Imageset_exposer.def( 
                "getImageHeight"
                , getImageHeight_function_type( &::CEGUI::Imageset::getImageHeight )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  return the height of the named image.\n\
            \n\
               @param name\n\
                  String object holding the name of the Image.\n\
            \n\
               @return\n\
                  float value equalling the height of the requested Image.\n\
            \n\
               @exception UnknownObjectException   thrown if no Image named  name is defined for the Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getImageOffset
        
            typedef ::CEGUI::Point ( ::CEGUI::Imageset::*getImageOffset_function_type )( ::CEGUI::String const & ) const;
            
            Imageset_exposer.def( 
                "getImageOffset"
                , getImageOffset_function_type( &::CEGUI::Imageset::getImageOffset )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  return the rendering offsets applied to the named image.\n\
            \n\
               @param name\n\
                  String object holding the name of the Image.\n\
            \n\
               @return\n\
                  Point object that holds the rendering offsets for the requested Image.\n\
            \n\
               @exception UnknownObjectException   thrown if no Image named  name is defined for the Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getImageOffsetX
        
            typedef float ( ::CEGUI::Imageset::*getImageOffsetX_function_type )( ::CEGUI::String const & ) const;
            
            Imageset_exposer.def( 
                "getImageOffsetX"
                , getImageOffsetX_function_type( &::CEGUI::Imageset::getImageOffsetX )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  return the x rendering offset for the named image.\n\
            \n\
               @param name\n\
                  String object holding the name of the Image.\n\
            \n\
               @return\n\
                  float value equal to the x rendering offset applied when drawing the requested Image.\n\
            \n\
               @exception UnknownObjectException   thrown if no Image named  name is defined for the Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getImageOffsetY
        
            typedef float ( ::CEGUI::Imageset::*getImageOffsetY_function_type )( ::CEGUI::String const & ) const;
            
            Imageset_exposer.def( 
                "getImageOffsetY"
                , getImageOffsetY_function_type( &::CEGUI::Imageset::getImageOffsetY )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  return the y rendering offset for the named image.\n\
            \n\
               @param name\n\
                  String object holding the name of the Image.\n\
            \n\
               @return\n\
                  float value equal to the y rendering offset applied when drawing the requested Image.\n\
            \n\
               @exception UnknownObjectException   thrown if no Image named  name is defined for the Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getImageSize
        
            typedef ::CEGUI::Size ( ::CEGUI::Imageset::*getImageSize_function_type )( ::CEGUI::String const & ) const;
            
            Imageset_exposer.def( 
                "getImageSize"
                , getImageSize_function_type( &::CEGUI::Imageset::getImageSize )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  return a Size object describing the dimensions of the named image.\n\
            \n\
               @param name\n\
                  String object holding the name of the Image.\n\
            \n\
               @return\n\
                  Size object holding the dimensions of the requested Image.\n\
            \n\
               @exception UnknownObjectException   thrown if no Image named  name is defined for the Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getImageWidth
        
            typedef float ( ::CEGUI::Imageset::*getImageWidth_function_type )( ::CEGUI::String const & ) const;
            
            Imageset_exposer.def( 
                "getImageWidth"
                , getImageWidth_function_type( &::CEGUI::Imageset::getImageWidth )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  return the width of the named image.\n\
            \n\
               @param name\n\
                  String object holding the name of the Image.\n\
            \n\
               @return\n\
                  float value equalling the width of the requested Image.\n\
            \n\
               @exception UnknownObjectException   thrown if no Image named  name is defined for the Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getIterator
        
            typedef ::CEGUI::ConstBaseIterator< std::map<CEGUI::String, CEGUI::Image, CEGUI::String::FastLessCompare, std::allocator<std::pair<CEGUI::String const, CEGUI::Image> > > > ( ::CEGUI::Imageset::*getIterator_function_type )(  ) const;
            
            Imageset_exposer.def( 
                "getIterator"
                , getIterator_function_type( &::CEGUI::Imageset::getIterator )
                , "*!\n\
            \n\
               Return an Imageset.ImageIterator object that can be used to iterate over the Image objects in the\
               Imageset.\n\
            *\n" );
        
        }
        { //::CEGUI::Imageset::getName
        
            typedef ::CEGUI::String const & ( ::CEGUI::Imageset::*getName_function_type )(  ) const;
            
            Imageset_exposer.def( 
                "getName"
                , getName_function_type( &::CEGUI::Imageset::getName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
               \n\
                  return String object holding the name of the Imageset\n\
            \n\
               @return  \n\
                  String object that holds the name of the Imageset.\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getNativeResolution
        
            typedef ::CEGUI::Size ( ::CEGUI::Imageset::*getNativeResolution_function_type )(  ) const;
            
            Imageset_exposer.def( 
                "getNativeResolution"
                , getNativeResolution_function_type( &::CEGUI::Imageset::getNativeResolution )
                , "*!\n\
               \n\
                  Return the native display size for this Imageset.  This is only relevant if the Imageset is\
                  being auto-scaled.\n\
            \n\
               @return\n\
                  Size object describing the native display size for this Imageset.\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::getTexture
        
            typedef ::CEGUI::Texture * ( ::CEGUI::Imageset::*getTexture_function_type )(  ) const;
            
            Imageset_exposer.def( 
                "getTexture"
                , getTexture_function_type( &::CEGUI::Imageset::getTexture )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*************************************************************************\n\
                  Public interface\n\
               *************************************************************************\n\
               *!\n\
               \n\
                  return Texture object for this Imageset\n\
            \n\
               @return\n\
                  Texture object that holds the imagery for this Imageset\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::isAutoScaled
        
            typedef bool ( ::CEGUI::Imageset::*isAutoScaled_function_type )(  ) const;
            
            Imageset_exposer.def( 
                "isAutoScaled"
                , isAutoScaled_function_type( &::CEGUI::Imageset::isAutoScaled )
                , "*!\n\
               \n\
                  Return whether this Imageset is auto-scaled.\n\
            \n\
               @return\n\
                  true if Imageset is auto-scaled, false if not.\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::isImageDefined
        
            typedef bool ( ::CEGUI::Imageset::*isImageDefined_function_type )( ::CEGUI::String const & ) const;
            
            Imageset_exposer.def( 
                "isImageDefined"
                , isImageDefined_function_type( &::CEGUI::Imageset::isImageDefined )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  return true if an Image with the specified name exists.\n\
            \n\
               @param name\n\
                  String object holding the name of the Image to look for.\n\
            \n\
               @return\n\
                  true if an Image object named  name is defined for this Imageset, else false.\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::notifyDisplaySizeChanged
        
            typedef void ( ::CEGUI::Imageset::*notifyDisplaySizeChanged_function_type )( ::CEGUI::Size const & ) ;
            
            Imageset_exposer.def( 
                "notifyDisplaySizeChanged"
                , notifyDisplaySizeChanged_function_type( &::CEGUI::Imageset::notifyDisplaySizeChanged )
                , ( bp::arg("size") )
                , "*!\n\
                \n\
                    Notify the Imageset that the display size may have changed.\n\
            \n\
                @param size\n\
                    Size object describing the display resolution\n\
                *\n" );
        
        }
        { //::CEGUI::Imageset::setAutoScalingEnabled
        
            typedef void ( ::CEGUI::Imageset::*setAutoScalingEnabled_function_type )( bool ) ;
            
            Imageset_exposer.def( 
                "setAutoScalingEnabled"
                , setAutoScalingEnabled_function_type( &::CEGUI::Imageset::setAutoScalingEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Enable or disable auto-scaling for this Imageset.\n\
            \n\
               @param setting\n\
                  true to enable auto-scaling, false to disable auto-scaling.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::setDefaultResourceGroup
        
            typedef void ( *setDefaultResourceGroup_function_type )( ::CEGUI::String const & );
            
            Imageset_exposer.def( 
                "setDefaultResourceGroup"
                , setDefaultResourceGroup_function_type( &::CEGUI::Imageset::setDefaultResourceGroup )
                , ( bp::arg("resourceGroup") )
                , "*!\n\
                \n\
                    Sets the default resource group to be used when loading imageset data\n\
            \n\
                @param resourceGroup\n\
                    String describing the default resource group identifier to be used.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Imageset::setNativeResolution
        
            typedef void ( ::CEGUI::Imageset::*setNativeResolution_function_type )( ::CEGUI::Size const & ) ;
            
            Imageset_exposer.def( 
                "setNativeResolution"
                , setNativeResolution_function_type( &::CEGUI::Imageset::setNativeResolution )
                , ( bp::arg("size") )
                , "*!\n\
               \n\
                  Set the native resolution for this Imageset\n\
            \n\
               @param size\n\
                  Size object describing the new native screen resolution for this Imageset.\n\
            \n\
               @return\n\
                  Nothing\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::undefineAllImages
        
            typedef void ( ::CEGUI::Imageset::*undefineAllImages_function_type )(  ) ;
            
            Imageset_exposer.def( 
                "undefineAllImages"
                , undefineAllImages_function_type( &::CEGUI::Imageset::undefineAllImages )
                , "*!\n\
               \n\
                  Removes the definitions for all Image objects currently defined in the Imageset\n\
            \n\
               @return\n\
                  Nothing\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::undefineImage
        
            typedef void ( ::CEGUI::Imageset::*undefineImage_function_type )( ::CEGUI::String const & ) ;
            
            Imageset_exposer.def( 
                "undefineImage"
                , undefineImage_function_type( &::CEGUI::Imageset::undefineImage )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  remove the definition for the Image with the specified name.  If no such Image exists, nothing\
                  happens.\n\
            \n\
               @param name\n\
                  String object holding the name of the Image object to be removed from the Imageset,\n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::Imageset::writeXMLToStream
        
            typedef void ( ::CEGUI::Imageset::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            Imageset_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type( &::CEGUI::Imageset::writeXMLToStream )
                , ( bp::arg("xml_stream") )
                , "*!\n\
                \n\
                    Writes an xml representation of this Imageset to  out_stream.\n\
            \n\
                @param out_stream\n\
                    Stream where xml data should be output.\n\
            \n\
                @param indentLevel\n\
                    Current XML indentation level\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        Imageset_exposer.staticmethod( "getDefaultResourceGroup" );
        Imageset_exposer.staticmethod( "setDefaultResourceGroup" );
    }

}
