/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include <iostream>
#include <Thread.H>
#include <Profiler.H>
#include <ParallelDescriptor.H>

namespace BoxLib3
{
namespace testing
{
void profiler_main(int& argc, char**& argv);
}
}

extern "C"
void* test_profiler_routine(void*)
{
    BL_PROFILE("tp_routine");
    // BoxLib3::Thread::sleep(1.0);
    return 0;
}

namespace
{
void
thread_timing()
{
    BL_PROFILE("a_thread_timing()");
    FunctionThread ft(test_profiler_routine);
    FunctionThread ft1(test_profiler_routine);
    test_profiler_routine(0);
    ft.join();
    ft1.join();
}
}

int
main(int argc, char** argv)
{
    BoxLib::Initialize(argc, argv);
    const double million = 1000000.0;
    
    BoxLib::WallTimer wt;
    wt.start();
    wt.stop();
    std::cout << "Wall timer reports (us) = " << wt.accum_time()*million << std::endl;
    std::cout << "Wall timer tick = (us) " << wt.tick()*million << std::endl;
    thread_timing();

    BoxLib::Finalize();
}
