/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifdef BL_LANG_FORT
#      define  FORT_INITDATA  initdata
#      define  FORT_PROBINIT  probinit
#      define  FORT_SET_CELL_VELBC setcellvelbc
#      define  FORT_DERVORT   dervort
#      define  FORT_DERAVGP   deravgp
#      define  FORT_DERIVE    derive
#      define  FORT_CMPDT     cmpdt
#      define  FORT_SLOPEX    fslopex
#      define  FORT_SLOPEY    fslopey
#      define  FORT_SLOPEZ    fslopez
#      define  FORT_LAPLAC    laplac
#      define  FORT_MKFORCE   mkforce
#      define  FORT_KINE      kine
#      define  FORT_WRITEVEL  writevel
#      define  FORT_MKSCALFORCE   mkscalforce
#      define  FORT_MKDIVUCC  mkdivucc
#      define  FORT_MKDIVUNOD mkdivunod
#      define  FORT_MKUTRANS  mkutrans
#      define  FORT_MKFLUX    mkflux
#      define  FORT_SCALUPD   scalupd
#      define  FORT_VELUPD    velupd
#      define  FORT_SETVELBC  setvelbc
#      define  FORT_SETSCALBC setscalbc 
#else
#if defined(BL_FORT_USE_UNDERSCORE)
#      define  FORT_INITDATA  initdata_
#      define  FORT_PROBINIT  probinit_
#      define  FORT_SET_CELL_VELBC setcellvelbc_
#      define  FORT_DERVORT   dervort_
#      define  FORT_DERAVGP   deravgp_
#      define  FORT_DERIVE    derive_
#      define  FORT_CMPDT     cmpdt_
#      define  FORT_SLOPEX    fslopex_
#      define  FORT_SLOPEY    fslopey_
#      define  FORT_SLOPEZ    fslopez_
#      define  FORT_LAPLAC    laplac_
#      define  FORT_MKFORCE   mkforce_
#      define  FORT_KINE      kine_
#      define  FORT_WRITEVEL  writevel_
#      define  FORT_MKSCALFORCE   mkscalforce_
#      define  FORT_MKDIVUCC  mkdivucc_
#      define  FORT_MKDIVUNOD mkdivunod_
#      define  FORT_MKUTRANS  mkutrans_
#      define  FORT_MKFLUX    mkflux_
#      define  FORT_SCALUPD   scalupd_
#      define  FORT_VELUPD    velupd_
#      define  FORT_SETVELBC  setvelbc_ 
#      define  FORT_SETSCALBC setscalbc_ 
#elif defined(BL_FORT_USE_UPPERCASE)
#      define  FORT_INITDATA  INITDATA
#      define  FORT_PROBINIT  PROBINIT
#      define  FORT_SET_CELL_VELBC SETCELLVELBC
#      define  FORT_DERVORT   DERVORT
#      define  FORT_DERAVGP   DERAVGP
#      define  FORT_DERIVE    DERIVE 
#      define  FORT_CMPDT     CMPDT 
#      define  FORT_SLOPEX    FSLOPEX
#      define  FORT_SLOPEY    FSLOPEY
#      define  FORT_SLOPEZ    FSLOPEZ
#      define  FORT_LAPLAC    LAPLAC
#      define  FORT_MKFORCE   MKFORCE
#      define  FORT_KINE      KINE
#      define  FORT_WRITEVEL  WRITEVEL
#      define  FORT_MKSCALFORCE   MKSCALFORCE
#      define  FORT_MKDIVUCC  MKDIVUCC
#      define  FORT_MKDIVUNOD MKDIVUNOD
#      define  FORT_MKUTRANS  MKUTRANS
#      define  FORT_MKFLUX    MKFLUX
#      define  FORT_SCALUPD   SCALUPD
#      define  FORT_VELUPD    VELUPD
#      define  FORT_SETVELBC  SETVELBC 
#      define  FORT_SETSCALBC SETSCALBC  
#elif defined(BL_FORT_USE_LOWERCASE)
#      define  FORT_INITDATA  initdata
#      define  FORT_PROBINIT  probinit
#      define  FORT_SET_CELL_VELBC setcellvelbc
#      define  FORT_DERVORT   dervort
#      define  FORT_DERAVGP   deravgp
#      define  FORT_DERIVE    derive 
#      define  FORT_CMPDT     cmpdt 
#      define  FORT_SLOPEX    fslopex
#      define  FORT_SLOPEY    fslopey
#      define  FORT_SLOPEZ    fslopez
#      define  FORT_LAPLAC    laplac
#      define  FORT_MKFORCE   mkforce
#      define  FORT_KINE      kine
#      define  FORT_WRITEVEL  writevel
#      define  FORT_MKSCALFORCE   mkscalforce
#      define  FORT_MKDIVUCC  mkdivucc
#      define  FORT_MKDIVUNOD mkdivunod
#      define  FORT_MKUTRANS  mkutrans
#      define  FORT_MKFLUX    mkflux
#      define  FORT_SCALUPD   scalupd
#      define  FORT_VELUPD    velupd
#      define  FORT_SETVELBC  setvelbc 
#      define  FORT_SETSCALBC setscalbc  
#endif

#include <ArrayLim.H>

extern "C" {

  void  FORT_INITDATA(Real * state,
                      ARLIM_P(lo), ARLIM_P(hi),
                      const Real * dx,
		      Real * time, int * numscal);

  void FORT_PROBINIT (const int* name,
                      const int* namelen);

  void  FORT_DERVORT(Real* state, Real * derval, 
                     ARLIM_P(derlo), ARLIM_P(derhi),
                     ARLIM_P(lo), ARLIM_P(hi),
		     const Real* dx);

  void  FORT_SET_CELL_VELBC(Real* u, 
                            ARLIM_P(lo), ARLIM_P(hi),
	                    int * bc, int * irz, 
                            Real * visc_coef, const Real * dx, Real * time);

  void  FORT_DERAVGP(Real* pressure, Real * dat, 
                     ARLIM_P(lo), ARLIM_P(hi));

  void  FORT_CMPDT(Real * u, Real * rho,  Real * gp,
		   Real * force, const Real* dx, Real * dtold, Real * dt,
                   Real * cfl, ARLIM_P(lo), ARLIM_P(hi));

#if (BL_SPACEDIM == 2)

  void  FORT_SLOPEX(Real * s, Real * slx, Real * dfromx,
                    ARLIM_P(lo), ARLIM_P(hi),
                    int * first_comp, int * nvar,
                    int * bc, int * irz, int * slope_order);

  void  FORT_SLOPEY(Real * s, Real * sly, Real * dfromy,
                    ARLIM_P(lo), ARLIM_P(hi), 
                    int * nvar, int * bc, int * slope_order);

#elif (BL_SPACEDIM == 3)

  void  FORT_SLOPEX(Real * s, Real * slx, Real * dfromx,
                    ARLIM_P(lo), ARLIM_P(hi),
                    int * nvar, 
                    int * bc, int * slope_order);

  void  FORT_SLOPEY(Real * s, Real * sly, Real * dfromy,
                    ARLIM_P(lo), ARLIM_P(hi),
                    int * nvar, int * bc, int * slope_order);

  void  FORT_SLOPEZ(Real * s, Real * slz, Real * dfromz,
                    ARLIM_P(lo), ARLIM_P(hi), 
		    int * nvar, int * bc, int * slope_order);
#endif

#if (BL_SPACEDIM == 2)
  void  FORT_LAPLAC(Real * u, Real * lapu, 
		    Real * areax, Real * areay, 
                    Real * volume,
                    ARLIM_P(lo), ARLIM_P(hi), const Real* dx,
                    Real * visc_coef, int * irz, 
                    int * bc, int * idir);
#elif (BL_SPACEDIM == 3)
  void  FORT_LAPLAC(Real * u, Real * lapu, 
		    Real * areax, Real * areay, Real * areaz,
                    Real * volume,
                    ARLIM_P(lo), ARLIM_P(hi), const Real* dx,
                    Real * visc_coef, int * bc);
#endif

  void  FORT_MKFORCE(Real * force, Real * u,
		     Real * rho, Real * gravity,
		     Real * visc_coef, Real * time, const Real * dx, 
                     ARLIM_P(lo), ARLIM_P(hi));

  void  FORT_KINE( const Real* s, ARLIM_P(slo), ARLIM_P(shi),
                     D_DECL(Real* xmean, Real* ymean, Real* zmean),
                     D_DECL(Real* tix,   Real* tiy,   Real* tiz),
                     const int* lo, const int* hi);

  void FORT_WRITEVEL(const Real* dat, ARLIM_P(lo),ARLIM_P(hi),
                       const int* lo, const int* hi, const Real* probsize);

  void  FORT_MKSCALFORCE(Real * force, Real * s, 
		         Real * time, const Real * dx, 
                         ARLIM_P(lo), ARLIM_P(hi), int* numscal);

  void  FORT_MKDIVUCC(Real * divu_src, Real * u,
		      Real * rho, Real * time, const Real * dx,
                      ARLIM_P(lo), ARLIM_P(hi));

  void  FORT_MKDIVUNOD(Real * divu_src, Real * u,
		       Real * rho, Real * time, const Real * dx,
                       ARLIM_P(lo), ARLIM_P(hi));

#if (BL_SPACEDIM == 2)
  void  FORT_MKUTRANS(Real * utrans, Real * vtrans,
                      Real * vel, Real * velx, Real * vely, 
                      Real * force, 
		      const Real * dx, Real & dt,
                      ARLIM_P(lo), ARLIM_P(hi), int * bc);

  void FORT_SCALUPD(Real * s, Real * sn, 
                    Real * sedgex, Real * sedgey,
                    Real * uhalfx, Real * uhalfy,
                    Real * diff_term, Real * scalforce,
                    Real * areax, Real * areay, 
	            Real * vol,
                    ARLIM_P(lo), ARLIM_P(hi),
                    const Real * dx,Real * dt, 
                    int * is_conserv, int * numscal);

  void FORT_MKFLUX(Real * s, Real * sedgex, Real * sedgey,
	           Real * slopex, Real * slopey, 
                   Real * uhalfx, Real * uhalfy,
                   Real * utrans, Real * vtrans, Real * force,
    	   	   Real * s_l,  Real * s_r, 
                   Real * s_b,  Real * s_t,
                   ARLIM_P(lo), ARLIM_P(hi),
                   const Real * dx, Real * dt,
                   Real * visc_coef, int * irz, int * bc, 
                   int * velpred, int * nstart, int * nend);

  void FORT_VELUPD(Real * u, Real * ustar,
                   Real * lapu, Real * gradp, Real * rhohalf, 
                   Real * uadv, Real * vadv, Real * uhalfx, Real * uhalfy,
                   Real * force, Real * dt, 
                   ARLIM_P(lo), ARLIM_P(hi), const Real* dx);

  void  FORT_SETVELBC(Real* vel, 
                      ARLIM_P(lo), ARLIM_P(hi),
	              int * bc, int * irz, 
                      Real * visc_coef, const Real * dx, Real * time);

  void  FORT_SETSCALBC(Real * scal, 
                       ARLIM_P(lo), ARLIM_P(hi),
                       ARLIM_P(slo), ARLIM_P(shi),
                       int * bc, int * irz, int * which_scal,
                       const Real * dx, Real * time);


#elif (BL_SPACEDIM == 3)

  void  FORT_MKUTRANS(Real * utrans, Real * vtrans, Real * wtrans,
                      Real * vel, Real * velx, Real * vely, Real * velz,
                      Real * force, 
		      const Real * dx, Real & dt,
                      ARLIM_P(lo), ARLIM_P(hi), int * bc);

  void   FORT_SCALUPD(Real * s, Real * sn, 
                      Real * sedgex, Real * sedgey, Real * sedgez,
                      Real * uhalfx, Real * uhalfy, Real * uhalfz,
                      Real * diff_term, Real * scalforce,
                      Real * areax, Real * areay, Real * areaz,
    	              Real * vol,
                      ARLIM_P(lo), ARLIM_P(hi),
                      const Real * dx, Real * dt, 
                      int * is_conserv, int * numscal);

  void FORT_MKFLUX(Real * s, Real * sedgex, Real * sedgey,
                   Real * sedgez, 
		   Real * slopex, Real * slopey, 
                   Real * slopez, 
                   Real * uhalfx, Real * uhalfy,
                   Real * uhalfz, 
                   Real * utrans, Real * vtrans,
                   Real * wtrans, Real * force,
    	   	   Real * s_l,  Real * s_r, 
                   Real * s_b,  Real * s_t,
                   Real * s_d,  Real * s_u,
                   ARLIM_P(lo), ARLIM_P(hi),
                   const Real * dx, Real * dt, 
                   Real * visc_coef, int * bc, 
                   int * velpred, int * nstart, int * nend);

  void FORT_VELUPD(Real * u, Real * ustar,
                   Real * lapu, Real * gradp, Real * rhohalf, 
                   Real * uadv, Real * vadv, Real * wadv,
                   Real * uhalfx, Real * uhalfy, Real * uhalfz,
                   Real * force, Real * dt, 
                   ARLIM_P(lo), ARLIM_P(hi), const Real* dx);

  void  FORT_SETVELBC(Real* vel, 
                      ARLIM_P(lo), ARLIM_P(hi),
	              int * bc, 
                      Real * visc_coef, const Real * dx, Real * time);

  void  FORT_SETSCALBC(Real * scal, 
                       ARLIM_P(lo), ARLIM_P(hi),
                       ARLIM_P(slo), ARLIM_P(shi),
                       int * bc, int * which_scal,
                       const Real * dx, Real * time);

#endif
};
#endif




