{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAxis: TVector3;
    procedure SetAxis(const Value: TVector3);
  public
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: array of Single);
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: TSingleList);
    { X3D field "axis". } { }
    property Axis: TVector3 read GetAxis write SetAxis;

{$endif read_interface}

{$ifdef read_implementation}

{ TCubicBezier2DOrientationInterpolatorNode ----------------------------------------------- }

procedure TCubicBezier2DOrientationInterpolatorNode.SetKeyValue(const Value: array of Single);
begin
  FdKeyValue.Send(Value);
end;

procedure TCubicBezier2DOrientationInterpolatorNode.SetKeyValue(const Value: TSingleList);
begin
  FdKeyValue.Send(Value);
end;

function TCubicBezier2DOrientationInterpolatorNode.GetAxis: TVector3;
begin
  Result := FdAxis.Value;
end;

procedure TCubicBezier2DOrientationInterpolatorNode.SetAxis(const Value: TVector3);
begin
  FdAxis.Send(Value);
end;

{$endif read_implementation}
