#! 
#! \addtogroup CamiTKMacros
#!
#! macro camitk_sub_project_validate validates the xml_subprojects variable by ending its xml tag
#! i.e. By adding the closing </Project> xml node, this will close the xml data
#! Then create the '${CMAKE_BINARY_DIR}/Project.xml file 
#! Use this file to send to the DashBoard to get the CEP and its subprojects definition
#!
#! Usage:
#! \code
#! camitk_sub_project_validate()
#! \endcode
#!
#! \param CEP_SET (optional)   should be added only if this is a CEP set validation
macro(camitk_sub_project_validate)
    parse_arguments(ADD_SUB_PROJECT_VALIDATE
            ""        # possible lists
            "CEP_SET" # possible options
            ${ARGN}
    )
       
    # TODO check if needed
    # Add apidoc subproject at the end
#         set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"apidoc\">\n  </SubProject>")

    # Add packaging subproject at the end
#         set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"package\">\n  </SubProject>")

    # if this a standalone CEP, then write the cdash xml report
    if(NOT CAMITK_EXTENSION_PROJECT_SET OR ADD_SUB_PROJECT_VALIDATE_CEP_SET)
        # Add packaging source, packaging and api_doc target
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"package-source\">\n  </SubProject>")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"package\">\n  </SubProject>")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"apidoc\">\n  </SubProject>")
        
        # Write down the Project.xml file
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n</Project>")
        set(filename "${CMAKE_BINARY_DIR}/Project.xml")
        file(WRITE ${filename} ${CAMITK_XML_PROJECT_DESCRIPTION})
        message(STATUS "Generated ${filename} for project description")

        #Write down subprojects.cmake filename
        set(filename "${CMAKE_BINARY_DIR}/Subprojects.cmake")
        file(WRITE ${filename} "set(CAMITK_SUBPROJECTS ${CAMITK_SUBPROJECTS})")
        message(STATUS "Generated ${filename} for subprojects listing")
    endif()
endmacro()
