//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Numeric/NumberUtil.h
//! @brief     Defines class GUIHelpers functions
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_NUMERIC_NUMBERUTIL_H
#define BORNAGAIN_GUI_VIEW_NUMERIC_NUMBERUTIL_H

#include <QWidget>

class RealLimits;
class QDoubleSpinBox;
class QLineEdit;
class ScientificSpinBox;

namespace GUI::View::NumberUtil {

void configScientificDoubleEdit(QLineEdit* edit, const RealLimits& limits);

void configSpinbox(QDoubleSpinBox* spinBox, int decimals, const RealLimits& limits);
void configSpinbox(ScientificSpinBox* spinBox, int decimals, const RealLimits& limits);

} // namespace GUI::View::NumberUtil

#endif // BORNAGAIN_GUI_VIEW_NUMERIC_NUMBERUTIL_H
