//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Device/InstrumentLibrary.h
//! @brief     Defines class InstrumentLibrary
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTLIBRARY_H
#define BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTLIBRARY_H

#include "GUI/Model/Device/InstrumentModel.h"
#include "GUI/Model/Device/MultiInstrumentNotifier.h"

class InstrumentLibrary {
public:
    InstrumentLibrary();

    QString suggestName(const QString& name) const;

    //! Returns the new element
    InstrumentItem* addItemCopy(const QString& name, const InstrumentItem& itemToCopy);
    bool isEmpty() const;
    QList<InstrumentItem*> instrumentItems() const;

    bool saveIfModified();
    bool load();

    InstrumentModel* instrumentModel();

    MultiInstrumentNotifier* editController();

private:
    InstrumentModel m_instrumentModel;
    MultiInstrumentNotifier m_ec;
    bool m_modified;
};

#endif // BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTLIBRARY_H
