#include "generator.ih"

namespace
{
    DateTime dtime(DateTime::LOCALTIME);
}

void Generator::filter(istream &in, ostream &out, bool header) const
{
    Terminal::inserter(&Terminal::plainName);

    if (header)
        out << "// Generated by Bisonc++ V" << ::version << 
                " on " << dtime.rfc2822() << '\n' <<
                '\n';

    while (getline(in, d_line))
    {
        if (d_line.find("$insert") == 0)
        {
            insert(out);
            continue;
        }

        while (true)
        {
            size_t pos = d_line.rfind(s_baseFlag);

            if (pos == string::npos)
                break;

            if (d_line.find(s_namespaceBaseFlag) == pos)
                d_line.replace(pos, s_namespaceBaseFlagSize, 
                               d_options.nameSpace() + d_options.className());
            else 
                d_line.replace(pos, s_baseFlagSize, d_options.className());
        }

        out << d_line << '\n';
    }
}
