#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.3.4 on Sun Jul 24 23:17:28 2005

import wx
import BIB

class Pref_DB_Base(wx.Panel):
	def __init__(self, *args, **kwds):
		# begin wxGlade: Pref_DB_Base.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.SQLitepanel = wx.Panel(self, -1)
		self.MySQLpanel = wx.Panel(self, -1)
		self.MySQLflexPanel = wx.Panel(self.MySQLpanel, -1)
		self.label_1 = wx.StaticText(self, -1, _("Database type"))
		self.dbtype = wx.Choice(self, -1, choices=[])
		self.dbmode = wx.RadioBox(self, -1, _("Database used at startup"), choices=[_("last"), _("default")], majorDimension=2, style=wx.RA_SPECIFY_COLS)
		self.passwd = wx.CheckBox(self.MySQLpanel, -1, _("save password (Not secure!)"))
		self.label_2 = wx.StaticText(self.MySQLflexPanel, -1, _("Database"))
		self.database = wx.TextCtrl(self.MySQLflexPanel, -1, "")
		self.label_3 = wx.StaticText(self.MySQLflexPanel, -1, _("Username"))
		self.username = wx.TextCtrl(self.MySQLflexPanel, -1, "")
		self.label_4 = wx.StaticText(self.MySQLflexPanel, -1, _("Password"))
		self.password = wx.TextCtrl(self.MySQLflexPanel, -1, "", style=wx.TE_PASSWORD)
		self.label_5 = wx.StaticText(self.MySQLflexPanel, -1, _("Host"))
		self.host = wx.TextCtrl(self.MySQLflexPanel, -1, "")
		self.label_6 = wx.StaticText(self.MySQLflexPanel, -1, _("Port"))
		self.port = wx.TextCtrl(self.MySQLflexPanel, -1, "")
		self.label_7 = wx.StaticText(self.MySQLflexPanel, -1, _("Socket"))
		self.socket = wx.TextCtrl(self.MySQLflexPanel, -1, "")
		self.label_8 = wx.StaticText(self.SQLitepanel, -1, _("Username"))
		self.sqliteuser = wx.TextCtrl(self.SQLitepanel, -1, "")
		self.file = wx.Button(self.SQLitepanel, -1, _("Database file..."))
		self.sqlitefile = wx.TextCtrl(self.SQLitepanel, -1, "")

		self.__set_properties()
		self.__do_layout()
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: Pref_DB_Base.__set_properties
		self.dbtype.SetSelection(0)
		self.dbmode.SetSelection(0)
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: Pref_DB_Base.__do_layout
		sizer_1 = wx.BoxSizer(wx.VERTICAL)
		grid_sizer_2 = wx.FlexGridSizer(2, 2, 5, 5)
		sizer_3 = wx.BoxSizer(wx.VERTICAL)
		grid_sizer_1 = wx.FlexGridSizer(6, 2, 5, 5)
		sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_2.Add(self.label_1, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		sizer_2.Add(self.dbtype, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_2.Add(self.dbmode, 0, wx.LEFT, 5)
		sizer_1.Add(sizer_2, 0, wx.EXPAND, 0)
		sizer_3.Add(self.passwd, 0, 0, 0)
		grid_sizer_1.Add(self.label_2, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(self.database, 0, wx.EXPAND, 0)
		grid_sizer_1.Add(self.label_3, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(self.username, 0, wx.EXPAND, 0)
		grid_sizer_1.Add(self.label_4, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(self.password, 0, wx.EXPAND, 0)
		grid_sizer_1.Add(self.label_5, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(self.host, 0, wx.EXPAND, 0)
		grid_sizer_1.Add(self.label_6, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(self.port, 0, wx.EXPAND, 0)
		grid_sizer_1.Add(self.label_7, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(self.socket, 0, wx.EXPAND, 0)
		self.MySQLflexPanel.SetAutoLayout(1)
		self.MySQLflexPanel.SetSizer(grid_sizer_1)
		grid_sizer_1.Fit(self.MySQLflexPanel)
		grid_sizer_1.SetSizeHints(self.MySQLflexPanel)
		grid_sizer_1.AddGrowableCol(1)
		sizer_3.Add(self.MySQLflexPanel, 1, wx.EXPAND, 0)
		self.MySQLpanel.SetAutoLayout(1)
		self.MySQLpanel.SetSizer(sizer_3)
		sizer_3.Fit(self.MySQLpanel)
		sizer_3.SetSizeHints(self.MySQLpanel)
		sizer_1.Add(self.MySQLpanel, 1, wx.TOP|wx.EXPAND, 10)
		grid_sizer_2.Add(self.label_8, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_2.Add(self.sqliteuser, 0, wx.EXPAND, 0)
		grid_sizer_2.Add(self.file, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_2.Add(self.sqlitefile, 0, wx.EXPAND, 0)
		self.SQLitepanel.SetAutoLayout(1)
		self.SQLitepanel.SetSizer(grid_sizer_2)
		grid_sizer_2.Fit(self.SQLitepanel)
		grid_sizer_2.SetSizeHints(self.SQLitepanel)
		grid_sizer_2.AddGrowableCol(1)
		sizer_1.Add(self.SQLitepanel, 1, wx.TOP|wx.EXPAND, 10)
		self.SetAutoLayout(1)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		sizer_1.SetSizeHints(self)
		# end wxGlade

# end of class Pref_DB_Base

class Pref_DB(Pref_DB_Base):
	def __init__(self,parent,id, (DB_STARTUP,DB_TYPE,STORE_PASSWD,DB_NAME,USER,PASSWORD,HOST,PORT,SOCKET,SQLiteFile,SQLiteUSER) ):
		self.db_startup = DB_STARTUP
		self.db_type = DB_TYPE
		self.db_store_passwd = STORE_PASSWD
		self.db_name = DB_NAME
		self.db_user = USER
		self.db_password = PASSWORD
		self.db_host = HOST
		self.db_port = repr(PORT)
		self.db_socket = SOCKET
		self.db_sqlitefile = SQLiteFile
		self.db_sqliteuser = SQLiteUSER
		Pref_DB_Base.__init__(self,parent,id)
		self.mainsizer = self.GetSizer()
		self.__dbModeType()
		self.__set_evt()

	def _Pref_DB_Base__set_properties(self):
		for dbtype in BIB.DB_TYPES: self.dbtype.Append(dbtype)
		self.dbtype.SetStringSelection(self.db_type)
		self.dbmode.SetSelection(self.db_startup)
		self.database.SetValue(self.db_name)
		self.username.SetValue(self.db_user)
		self.password.SetValue(self.db_password)
		self.host.SetValue(self.db_host)
		self.port.SetValue(self.db_port)
		self.socket.SetValue(self.db_socket)
		self.sqliteuser.SetValue(self.db_sqliteuser)
		self.sqlitefile.SetValue(self.db_sqlitefile)
		self.passwd.SetValue(self.db_store_passwd)

	def __set_evt(self):
		wx.EVT_RADIOBOX(self,self.dbmode.GetId(),self.onDbMode)
		wx.EVT_CHECKBOX(self,self.passwd.GetId(),self.onPasswd)
		wx.EVT_BUTTON(self,self.file.GetId(),self.onFile)
		wx.EVT_CHOICE(self,self.dbtype.GetId(),self.onDbType)

	def __dbModeType(self):
		selType = self.dbtype.GetStringSelection()
		mode = self.dbmode.GetSelection()
		self.SQLitepanel.Show(False)
		self.MySQLpanel.Show(False)
		#
		if selType == 'MySQL':
			self.mainsizer.Show(self.MySQLpanel,True)
			self.mainsizer.Show(self.SQLitepanel,False)
			self.MySQLflexPanel.Show(mode)
			if mode:
				self.password.Show(self.passwd.GetValue()) # show only if password can be saved
		elif selType == 'SQLite':
			self.mainsizer.Show(self.MySQLpanel,False)
			self.mainsizer.Show(self.SQLitepanel,mode)
		self.Layout()

	def onDbType(self,event):
		"""Changing between dbTypes (MySQL,SQLite,...)"""
		self.__dbModeType()

	def onDbMode(self,event):
		self.__dbModeType()

	def onPasswd(self,event):
		if self.dbmode.GetSelection() == 1:	# 'default' selected
			self.password.Show(self.passwd.GetValue()) # show only if password can be saved

	def onFile(self,event):
		filename = wx.FileSelector(_('SQlite database file'))
		self.sqlitefile.SetValue(filename)

	def getSettings(self):
		return \
		self.dbmode.GetSelection(),\
		self.dbtype.GetStringSelection(),\
		self.passwd.GetValue(),\
		self.database.GetValue(),\
		self.username.GetValue(),\
		self.password.GetValue(),\
		self.host.GetValue(),\
		int(self.port.GetValue()),\
		self.socket.GetValue(),\
		self.sqlitefile.GetValue(),\
		self.sqliteuser.GetValue()
