/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2.section;

import android.util.Log;
import java.io.IOException;
import java.util.Arrays;
import yuku.alkitab.model.XrefEntry;
import yuku.alkitab.yes2.io.RandomInputStream;
import yuku.alkitab.yes2.section.base.SectionContent;
import yuku.bintex.BintexReader;

public class XrefsSection
extends SectionContent {
    public static final String TAG = XrefsSection.class.getSimpleName();
    public static final String SECTION_NAME = "xrefs";
    RandomInputStream input_;
    int entry_count;
    int[] index_arifs;
    int[] index_offset;
    int content_start_offset;

    XrefsSection(RandomInputStream input) throws IOException {
        super(SECTION_NAME);
        int i;
        BintexReader br = new BintexReader(input);
        int version = br.readUint8();
        if (version != 1) {
            throw new RuntimeException("Xrefs section version not supported: " + version);
        }
        this.entry_count = br.readInt();
        this.index_arifs = new int[this.entry_count];
        int len = this.entry_count;
        for (i = 0; i < len; ++i) {
            this.index_arifs[i] = br.readInt();
        }
        this.index_offset = new int[this.entry_count];
        len = this.entry_count;
        for (i = 0; i < len; ++i) {
            this.index_offset[i] = br.readInt();
        }
        this.content_start_offset = (int)input.getFilePointer();
        this.input_ = input;
    }

    public XrefEntry getXrefEntry(int arif) {
        int pos = Arrays.binarySearch(this.index_arifs, arif);
        if (pos < 0) {
            return null;
        }
        int offset = this.index_offset[pos];
        int abs_offset = this.content_start_offset + offset;
        try {
            XrefEntry res = new XrefEntry();
            this.input_.seek(abs_offset);
            BintexReader br = new BintexReader(this.input_);
            res.content = br.readValueString();
            return res;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"load xref failed", (Throwable)e);
            return null;
        }
    }

    public static class Reader
    implements SectionContent.Reader<XrefsSection> {
        @Override
        public XrefsSection read(RandomInputStream input) throws IOException {
            return new XrefsSection(input);
        }
    }
}

