/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2;

import android.util.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import yuku.alkitab.io.BibleReader;
import yuku.alkitab.model.Book;
import yuku.alkitab.model.FootnoteEntry;
import yuku.alkitab.model.PericopeBlock;
import yuku.alkitab.model.SingleChapterVerses;
import yuku.alkitab.model.XrefEntry;
import yuku.alkitab.util.Ari;
import yuku.alkitab.yes2.compress.SnappyInputStream;
import yuku.alkitab.yes2.io.RandomAccessFileRandomInputStream;
import yuku.alkitab.yes2.io.RandomInputStream;
import yuku.alkitab.yes2.io.Yes2VerseTextDecoder;
import yuku.alkitab.yes2.model.SectionIndex;
import yuku.alkitab.yes2.model.Yes2Book;
import yuku.alkitab.yes2.section.BooksInfoSection;
import yuku.alkitab.yes2.section.FootnotesSection;
import yuku.alkitab.yes2.section.PericopesSection;
import yuku.alkitab.yes2.section.VersionInfoSection;
import yuku.alkitab.yes2.section.XrefsSection;
import yuku.bintex.BintexReader;
import yuku.bintex.ValueMap;

public class Yes2Reader
implements BibleReader {
    private static final String TAG = Yes2Reader.class.getSimpleName();
    private RandomAccessFileRandomInputStream file_;
    private SectionIndex sectionIndex_;
    private VersionInfoSection versionInfo_;
    private PericopesSection pericopesSection_;
    private TextSectionReader textSectionReader_;
    private XrefsSection xrefsSection_;
    private FootnotesSection footnotesSection_;

    public Yes2Reader(RandomAccessFileRandomInputStream input) {
        this.file_ = input;
    }

    private synchronized void loadSectionIndex() throws IOException {
        if (this.sectionIndex_ != null) {
            return;
        }
        this.file_.seek(0L);
        byte[] buf = new byte[8];
        this.file_.read(buf);
        if (!Arrays.equals(buf, new byte[]{-104, 88, 13, 10, 0, 93, -32, 2})) {
            throw new RuntimeException("YES2: Header is incorrect. Found: " + Arrays.toString(buf));
        }
        this.file_.seek(12L);
        this.sectionIndex_ = SectionIndex.read(this.file_);
    }

    private synchronized void loadVersionInfo() throws Exception {
        if (this.seekToSection("versionInfo")) {
            this.versionInfo_ = new VersionInfoSection.Reader().read(this.file_);
        }
    }

    private synchronized boolean seekToSection(String sectionName) throws IOException {
        this.loadSectionIndex();
        if (this.sectionIndex_ == null) {
            Log.e((String)TAG, (String)"@@seekToSection Could not load section index");
            return false;
        }
        if (this.sectionIndex_.seekToSectionContent(sectionName, this.file_)) {
            return true;
        }
        Log.e((String)TAG, (String)("@@seekToSection Could not seek to section: " + sectionName));
        return false;
    }

    @Override
    public String getLocale() {
        try {
            this.loadVersionInfo();
            return this.versionInfo_.locale;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"yes load version info error", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getShortName() {
        try {
            this.loadVersionInfo();
            return this.versionInfo_.shortName;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"yes load version info error", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getLongName() {
        try {
            this.loadVersionInfo();
            return this.versionInfo_.longName;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"yes load version info error", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getDescription() {
        try {
            this.loadVersionInfo();
            return this.versionInfo_.description;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"yes load version info error", (Throwable)e);
            return "";
        }
    }

    @Override
    public Book[] loadBooks() {
        try {
            this.loadVersionInfo();
            if (this.seekToSection("booksInfo")) {
                BooksInfoSection section = new BooksInfoSection.Reader().read(this.file_);
                List<Yes2Book> books = section.yes2Books;
                return books.toArray(new Yes2Book[books.size()]);
            }
            Log.e((String)TAG, (String)"no section named booksInfo");
            return null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"loadBooks error", (Throwable)e);
            return null;
        }
    }

    @Override
    public Yes2SingleChapterVerses loadVerseText(Book book, int chapter_1, boolean dontSeparateVerses, boolean lowercase) {
        Yes2Book yes2Book = (Yes2Book)book;
        try {
            if (chapter_1 <= 0 || chapter_1 > yes2Book.chapter_count) {
                return null;
            }
            if (this.textSectionReader_ == null) {
                Yes2VerseTextDecoder decoder;
                int textEncoding = this.versionInfo_.textEncoding;
                if (textEncoding == 1) {
                    decoder = new Yes2VerseTextDecoder.Ascii();
                } else if (textEncoding == 2) {
                    decoder = new Yes2VerseTextDecoder.Utf8();
                } else {
                    Log.e((String)TAG, (String)("Text encoding " + textEncoding + " not supported! Fallback to ascii."));
                    decoder = new Yes2VerseTextDecoder.Ascii();
                }
                ValueMap sectionAttributes = this.sectionIndex_.getSectionAttributes("text", this.file_);
                long sectionContentOffset = this.sectionIndex_.getAbsoluteOffsetForSectionContent("text");
                this.textSectionReader_ = new TextSectionReader(this.file_, decoder, sectionAttributes, sectionContentOffset);
            }
            return this.textSectionReader_.loadVerseText(yes2Book, chapter_1, dontSeparateVerses, lowercase);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("@@loadVerseText error book=" + book + " chapter_1=" + chapter_1 + " dontSeparateVerses=" + dontSeparateVerses + " lowercase=" + lowercase), (Throwable)e);
            return null;
        }
    }

    @Override
    public int loadPericope(int bookId, int chapter_1, int[] aris, PericopeBlock[] blocks, int max) {
        try {
            this.loadVersionInfo();
            if (this.versionInfo_.hasPericopes == 0) {
                return 0;
            }
            if (this.pericopesSection_ == null) {
                RandomInputStream sectionInput = this.prepareLoadSection("pericopes");
                if (sectionInput == null) {
                    return 0;
                }
                this.pericopesSection_ = new PericopesSection.Reader().read(sectionInput);
            }
            if (this.pericopesSection_ == null) {
                Log.e((String)TAG, (String)"Didn't succeed in loading pericopes section");
                return 0;
            }
            int ariMin = Ari.encode(bookId, chapter_1, 0);
            int ariMax = Ari.encode(bookId, chapter_1 + 1, 0);
            return this.pericopesSection_.getPericopesForAris(ariMin, ariMax, aris, blocks, max);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"General exception in loading pericope block", (Throwable)e);
            return 0;
        }
    }

    @Override
    public XrefEntry getXrefEntry(int arif) {
        if (this.xrefsSection_ == null) {
            try {
                RandomInputStream sectionInput = this.prepareLoadSection("xrefs");
                if (sectionInput == null) {
                    return null;
                }
                this.xrefsSection_ = new XrefsSection.Reader().read(sectionInput);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"General exception in loading xref section", (Throwable)e);
                return null;
            }
        }
        return this.xrefsSection_.getXrefEntry(arif);
    }

    @Override
    public FootnoteEntry getFootnoteEntry(int arif) {
        if (this.footnotesSection_ == null) {
            try {
                RandomInputStream sectionInput = this.prepareLoadSection("footnotes");
                if (sectionInput == null) {
                    return null;
                }
                this.footnotesSection_ = new FootnotesSection.Reader().read(sectionInput);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"General exception in loading footnote section", (Throwable)e);
                return null;
            }
        }
        return this.footnotesSection_.getFootnoteEntry(arif);
    }

    RandomInputStream prepareLoadSection(String sectionName) throws IOException {
        String compressionName;
        ValueMap sectionAttributes = this.sectionIndex_.getSectionAttributes(sectionName, this.file_);
        long sectionContentOffset = this.sectionIndex_.getAbsoluteOffsetForSectionContent(sectionName);
        RandomInputStream sectionInput = null;
        if (sectionAttributes != null && (compressionName = sectionAttributes.getString("compression.name")) != null) {
            if ("snappy-blocks".equals(compressionName)) {
                sectionInput = SnappyInputStream.getInstanceFromAttributes(this.file_, sectionAttributes, sectionContentOffset);
            } else {
                throw new IOException("Compression " + compressionName + " is not supported");
            }
        }
        if (sectionInput == null) {
            sectionInput = this.file_;
        }
        if (this.seekToSection(sectionName)) {
            return sectionInput;
        }
        return null;
    }

    static class TextSectionReader {
        private final RandomAccessFileRandomInputStream file_;
        private final Yes2VerseTextDecoder decoder_;
        private final long sectionContentOffset_;
        private BintexReader br_;
        private SnappyInputStream snappyInputStream;

        public TextSectionReader(RandomAccessFileRandomInputStream file, Yes2VerseTextDecoder decoder, ValueMap sectionAttributes, long sectionContentOffset) throws Exception {
            String compressionName;
            this.file_ = file;
            this.decoder_ = decoder;
            this.sectionContentOffset_ = sectionContentOffset;
            this.br_ = new BintexReader(null);
            if (sectionAttributes != null && (compressionName = sectionAttributes.getString("compression.name")) != null) {
                if ("snappy-blocks".equals(compressionName)) {
                    this.snappyInputStream = SnappyInputStream.getInstanceFromAttributes(this.file_, sectionAttributes, sectionContentOffset);
                } else {
                    throw new Exception("Compression " + compressionName + " is not supported");
                }
            }
        }

        public Yes2SingleChapterVerses loadVerseText(Yes2Book yes2Book, int chapter_1, boolean dontSeparateVerses, boolean lowercase) throws Exception {
            BintexReader br;
            int contentOffset = yes2Book.offset;
            contentOffset += yes2Book.chapter_offsets[chapter_1 - 1];
            if (this.snappyInputStream != null) {
                this.snappyInputStream.seek(contentOffset);
                br = this.br_.reuse(this.snappyInputStream);
            } else {
                this.file_.seek(this.sectionContentOffset_ + (long)contentOffset);
                br = this.br_.reuse(this.file_);
            }
            int verse_count = yes2Book.verse_counts[chapter_1 - 1];
            if (dontSeparateVerses) {
                return new Yes2SingleChapterVerses(new String[]{this.decoder_.makeIntoSingleString(br, verse_count, lowercase)});
            }
            return new Yes2SingleChapterVerses(this.decoder_.separateIntoVerses(br, verse_count, lowercase));
        }
    }

    static class Yes2SingleChapterVerses
    extends SingleChapterVerses {
        private final String[] verses;

        public Yes2SingleChapterVerses(String[] verses) {
            this.verses = verses;
        }

        @Override
        public String getVerse(int verse_0) {
            return this.verses[verse_0];
        }

        @Override
        public int getVerseCount() {
            return this.verses.length;
        }
    }
}

