/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:49:54 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.FuzzyRange;
import uk.ac.sanger.artemis.io.LowerInteger;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.UpperInteger;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FuzzyRange_ESTest extends FuzzyRange_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) lowerInteger0, (Object) null);
      Range range1 = range0.copy();
      boolean boolean0 = range0.equals(range1);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Range range0 = new Range((-1329), (-175));
      Range range1 = range0.truncate(range0);
      assertEquals(1155, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Range range0 = new Range((-917));
      FuzzyRange fuzzyRange0 = (FuzzyRange)FuzzyRange.makeRange((Object) range0);
      Object object0 = fuzzyRange0.getEndObject();
      assertNull(object0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      LowerInteger lowerInteger0 = new LowerInteger((-2223));
      Range range0 = FuzzyRange.makeRange((Object) lowerInteger0);
      Range range1 = range0.copy();
      assertEquals((-2223), range1.getEnd());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      LowerInteger lowerInteger0 = new LowerInteger(1);
      Range range0 = FuzzyRange.makeRange((Object) lowerInteger0);
      Range range1 = range0.change(0, 0);
      assertEquals(1, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Range range0 = new Range((-917));
      Range range1 = FuzzyRange.makeRange((Object) range0);
      Range range2 = range1.change((-917), (-917));
      assertEquals(1, range2.getCount());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = new Range(1, 4383);
      Range range1 = FuzzyRange.makeRange((Object) lowerInteger0, (Object) range0);
      try { 
        range1.change(4383, (-4312));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // start: 4383 > end: -4312
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Integer integer0 = new Integer(1);
      Range range0 = FuzzyRange.makeRange((Object) integer0, (Object) integer0);
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = new Range(1, 4383);
      Range range1 = FuzzyRange.makeRange((Object) lowerInteger0, (Object) range0);
      Range range2 = range1.change(1, 1315);
      assertEquals(1315, range2.getCount());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Integer integer0 = new Integer(625);
      UpperInteger upperInteger0 = new UpperInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) integer0, (Object) upperInteger0);
      Range range1 = range0.change(574, 625);
      assertEquals(52, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Integer integer0 = new Integer(625);
      UpperInteger upperInteger0 = new UpperInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) integer0, (Object) upperInteger0);
      String string0 = range0.toString();
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) lowerInteger0, (Object) null);
      String string0 = range0.toString();
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = new Range(1, 4383);
      Range range1 = FuzzyRange.makeRange((Object) lowerInteger0, (Object) null);
      Range range2 = FuzzyRange.makeRange((Object) range1, (Object) range0);
      String string0 = range2.toString();
      assertEquals("(4383.4383)..(1.4383)", string0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Integer integer0 = new Integer(625);
      UpperInteger upperInteger0 = new UpperInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) integer0, (Object) upperInteger0);
      Range range1 = FuzzyRange.makeRange((Object) range0);
      boolean boolean0 = range0.equals(range1);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Integer integer0 = new Integer(625);
      UpperInteger upperInteger0 = new UpperInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) integer0, (Object) upperInteger0);
      boolean boolean0 = range0.equals(range0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = new Range(1, 4383);
      Range range1 = FuzzyRange.makeRange((Object) lowerInteger0, (Object) range0);
      Range range2 = FuzzyRange.makeRange((Object) range0, (Object) null);
      boolean boolean0 = range1.equals(range2);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = new Range(1, 4383);
      Range range1 = FuzzyRange.makeRange((Object) lowerInteger0, (Object) range0);
      boolean boolean0 = range1.equals(range1);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      // Undeclared exception!
      try { 
        FuzzyRange.makeRange((Object) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error: object is not recognised: null
         //
         verifyException("uk.ac.sanger.artemis.io.FuzzyRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Integer integer0 = new Integer((-1));
      UpperInteger upperInteger0 = new UpperInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) upperInteger0);
      assertEquals((-1), range0.getStart());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Range range0 = new Range((-917));
      Object object0 = new Object();
      // Undeclared exception!
      try { 
        FuzzyRange.makeRange((Object) range0, object0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error: object is not recognised: java.lang.Object@54ef20b9
         //
         verifyException("uk.ac.sanger.artemis.io.FuzzyRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Integer integer0 = new Integer((-3502));
      UpperInteger upperInteger0 = new UpperInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) integer0, (Object) upperInteger0);
      assertEquals((-3502), range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      LowerInteger lowerInteger0 = new LowerInteger((-2223));
      Range range0 = FuzzyRange.makeRange((Object) lowerInteger0);
      Object object0 = new Object();
      // Undeclared exception!
      try { 
        FuzzyRange.makeRange(object0, (Object) range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error: object is not recognised: java.lang.Object@2d26cf9f
         //
         verifyException("uk.ac.sanger.artemis.io.FuzzyRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Integer integer0 = new Integer(0);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) lowerInteger0);
      Range range1 = FuzzyRange.makeRange((Object) range0, (Object) range0);
      assertEquals(0, range1.getStart());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Integer integer0 = new Integer(1155);
      Range range0 = FuzzyRange.makeRange((Object) integer0);
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Integer integer0 = new Integer((-15));
      Range range0 = new Range((-16), (-16));
      try { 
        FuzzyRange.makeRange((Object) integer0, (Object) range0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // start: -15 > end: -16
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = FuzzyRange.makeRange((Object) lowerInteger0, (Object) null);
      Range range1 = range0.truncate(range0);
      range0.equals(range1);
      assertEquals(1, range1.getCount());
      assertEquals(1, range1.getStart());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Integer integer0 = new Integer(1155);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      FuzzyRange fuzzyRange0 = (FuzzyRange)FuzzyRange.makeRange((Object) lowerInteger0, (Object) integer0);
      LowerInteger lowerInteger1 = (LowerInteger)fuzzyRange0.getStartObject();
      assertEquals(1155, lowerInteger1.getPosition());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Integer integer0 = new Integer(4383);
      LowerInteger lowerInteger0 = new LowerInteger(integer0);
      Range range0 = new Range(1, 4383);
      FuzzyRange fuzzyRange0 = (FuzzyRange)FuzzyRange.makeRange((Object) lowerInteger0, (Object) range0);
      Range range1 = (Range)fuzzyRange0.getEndObject();
      assertNotNull(range1);
      assertEquals(1, fuzzyRange0.getCount());
  }
}
