/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:28:45 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.variant.FilteredPanel;
import uk.ac.sanger.artemis.components.variant.HeaderLine;
import uk.ac.sanger.artemis.components.variant.RecordFilter;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FilteredPanel_ESTest extends FilteredPanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      Hashtable<String, String> hashtable0 = new Hashtable<String, String>();
      HeaderLine headerLine0 = new HeaderLine("^3a}L~YqyxW4|N", "OO1,Tu6.<EG9)jQ", hashtable0);
      arrayList0.add(headerLine0);
      arrayList0.add(headerLine0);
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      assertFalse(filteredPanel0.getIgnoreRepaint());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Stack<HeaderLine> stack0 = new Stack<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(stack0);
      List<HeaderLine> list0 = FilteredPanel.getHeaderLineFilters();
      assertEquals(0, list0.size());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      Hashtable<String, String> hashtable0 = new Hashtable<String, String>();
      HeaderLine headerLine0 = new HeaderLine("^3a}L~YqyxW4|N", "OO1,Tu6.<EG9)jQ", hashtable0);
      arrayList0.add(headerLine0);
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      List<HeaderLine> list0 = FilteredPanel.getHeaderLineFilters();
      assertFalse(list0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        FilteredPanel.getHeaderLineFiltersIDs();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.FilteredPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      // Undeclared exception!
      try { 
        FilteredPanel.getHeader();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.FilteredPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FilteredPanel filteredPanel0 = null;
      try {
        filteredPanel0 = new FilteredPanel((List<HeaderLine>) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.FilteredPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Key key0 = new Key("AccessibleChild");
      KeyVector keyVector0 = new KeyVector(key0);
      FilteredPanel filteredPanel0 = null;
      try {
        filteredPanel0 = new FilteredPanel(keyVector0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.Key cannot be cast to uk.ac.sanger.artemis.components.variant.HeaderLine
         //
         verifyException("uk.ac.sanger.artemis.components.variant.FilteredPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      Hashtable<String, String> hashtable0 = new Hashtable<String, String>();
      HeaderLine headerLine0 = new HeaderLine("^3a}L~YqyxW4|N", "OO1,Tu6.<EG9)jQ", hashtable0);
      arrayList0.add(headerLine0);
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      String string0 = FilteredPanel.getHeader();
      assertEquals("^3a}L~YqyxW4|N\n", string0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Stack<HeaderLine> stack0 = new Stack<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(stack0);
      FilteredPanel.getHeaderLineFiltersIDs();
      List<String> list0 = FilteredPanel.getHeaderLineFiltersIDs();
      assertEquals(0, list0.size());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Stack<HeaderLine> stack0 = new Stack<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(stack0);
      filteredPanel0.updateFilters();
      assertFalse(filteredPanel0.isFocusTraversalPolicyProvider());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      Hashtable<String, String> hashtable0 = new Hashtable<String, String>();
      HeaderLine headerLine0 = new HeaderLine("^3a}L~YqyxW4|N", "OO1,Tu6.<EG9)jQ", hashtable0);
      arrayList0.add(headerLine0);
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      List<String> list0 = FilteredPanel.getHeaderLineFiltersIDs();
      assertNotNull(list0);
      assertFalse(list0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Hashtable<String, RecordFilter> hashtable0 = FilteredPanel.getFilters();
      assertTrue(hashtable0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      List<HeaderLine> list0 = FilteredPanel.getHeaderLineFilters();
      assertNull(list0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      LinkedList<HeaderLine> linkedList0 = new LinkedList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(linkedList0);
      filteredPanel0.removeFilter("BhMN'UW/x7VV]o{?Sa>");
      assertTrue(filteredPanel0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      LinkedList<HeaderLine> linkedList0 = new LinkedList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(linkedList0);
      Hashtable<String, String> hashtable0 = new Hashtable<String, String>();
      HeaderLine headerLine0 = new HeaderLine("Center", "L4YiZ", hashtable0);
      // Undeclared exception!
      try { 
        filteredPanel0.addFilter("SP", headerLine0, 1324);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.RecordFilter", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      String string0 = FilteredPanel.getHeader();
      assertEquals("", string0);
  }
}
