/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:43:36 GMT 2018
 */

package uk.ac.sanger.artemis.components.database;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.MockitoExtension.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.database.DatabaseEntrySource;
import uk.ac.sanger.artemis.components.filetree.LocalAndRemoteFileManager;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.UI;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class DatabaseEntrySource_ESTest extends DatabaseEntrySource_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      databaseEntrySource0.setLocation(false);
      databaseEntrySource0.getDatabaseDocument();
      DatabaseDocument.CONTROLLED_CURATION_TAG_CVNAME = "genedb_products";
      DatabaseDocument.PRODUCTS_TAG_CVNAME = "/etc/qualifier_mapping";
      databaseEntrySource0.setReadOnly(true);
      databaseEntrySource0.getSourceName();
      databaseEntrySource0.getSourceName();
      assertTrue(databaseEntrySource0.isReadOnly());
      
      databaseEntrySource0.setReadOnly(false);
      boolean boolean0 = databaseEntrySource0.isFullEntrySource();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      UI.UIMode uI_UIMode0 = UI.UIMode.CONSOLE;
      UI.mode = uI_UIMode0;
      databaseEntrySource0.setSplitGFF(true);
      UI.initalise();
      // Undeclared exception!
      try { 
        databaseEntrySource0.setLocation(false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseLocationParser", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      UI.UIMode uI_UIMode0 = UI.UIMode.SCRIPT;
      UI.mode = uI_UIMode0;
      String string0 = databaseEntrySource0.getSourceName();
      assertEquals("Database", string0);
      
      boolean boolean0 = databaseEntrySource0.setLocation(true);
      assertFalse(boolean0);
      assertFalse(databaseEntrySource0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      boolean boolean0 = databaseEntrySource0.isReadOnly();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      databaseEntrySource0.getSourceName();
      databaseEntrySource0.getSourceName();
      Bases bases0 = new Bases((Sequence) null);
      databaseEntrySource0.getEntry(bases0, true);
      JPasswordField jPasswordField0 = new JPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("E|b{_yl<47", jPasswordField0);
      // Undeclared exception!
      try { 
        databaseEntrySource0.makeFromGff(databaseDocument0, "", "QwiKf~84@[$OUS1Fw!");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      byte[] byteArray0 = new byte[5];
      byteArray0[0] = (byte) (-21);
      byteArray0[1] = (byte)88;
      byteArray0[2] = (byte)36;
      byteArray0[4] = (byte)88;
      ImageIcon imageIcon0 = new ImageIcon(byteArray0, "<0)&");
      JCheckBoxMenuItem jCheckBoxMenuItem0 = new JCheckBoxMenuItem("<0)&");
      LocalAndRemoteFileManager.lazyLoad = jCheckBoxMenuItem0;
      databaseEntrySource0.getPfield();
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      // Undeclared exception!
      try { 
        databaseEntrySource0.getEntry((String) null, "pFCE%mpFK,G+:WT", inputStreamProgressListener0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      boolean boolean0 = false;
      databaseEntrySource0.setLocation(false);
      databaseEntrySource0.setSplitGFF(true);
      databaseEntrySource0.setSplitGFF(true);
      databaseEntrySource0.getLocation();
      databaseEntrySource0.getSourceName();
      UI.initalise();
      databaseEntrySource0.setReadOnly(false);
      databaseEntrySource0.getPfield();
      String string0 = "The selected entry contains no sequence: ";
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      // Undeclared exception!
      databaseEntrySource0.getEntry("Database", "The selected entry contains no sequence: ", inputStreamProgressListener0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      databaseEntrySource0.setSplitGFF(false);
      databaseEntrySource0.getPfield();
      UI.UIMode uI_UIMode0 = UI.UIMode.SWING;
      UI.mode = uI_UIMode0;
      // Undeclared exception!
      try { 
        databaseEntrySource0.getDatabaseDocument();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      // Undeclared exception!
      try { 
        databaseEntrySource0.getEntry("m;", "4ru__thMLTs&e|yV", inputStreamProgressListener0, (Range) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      databaseEntrySource0.setSplitGFF(true);
      databaseEntrySource0.setReadOnly(false);
      databaseEntrySource0.setSplitGFF(false);
      databaseEntrySource0.getLocation();
      UI.initalise();
      databaseEntrySource0.setReadOnly(true);
      databaseEntrySource0.getSourceName();
      databaseEntrySource0.setLocation(false);
      databaseEntrySource0.getEntry(false);
      databaseEntrySource0.setSplitGFF(false);
      databaseEntrySource0.isFullEntrySource();
      databaseEntrySource0.setSplitGFF(false);
      databaseEntrySource0.isReadOnly();
      Selection selection0 = new Selection((Clipboard) null);
      selection0.getSelectionRange();
      // Undeclared exception!
      databaseEntrySource0.getEntry((String) null, "F! E&&<5yi", (InputStreamProgressListener) null, (Range) null);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      String string0 = ">YLhz9_v";
      // Undeclared exception!
      try { 
        databaseEntrySource0.setLocation(true);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }
}
