
/*
 *   DIS/x : An implementation of the IEEE 1278.1 protocol
 *
 *   Copyright (C) 1996, Riley Rainey (rainey@netcom.com)
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of either:
 *
 *   a) the GNU Library General Public License as published by the Free
 *   Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.  A description of the terms and conditions
 *   of the GLPL may be found in the "COPYING.LIB" file.
 *
 *   b) the "Artistic License" which comes with this Kit.  Information
 *   about this license may be found in the "Artistic" file.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License or the Artistic License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Information describing how to contact the author can be found in the
 *   README file.
 */
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>

char     *
SIMxGetSiteName(char *result, int max_size)
{
	char     *s;
#ifndef WIN32
	char      path[MAXPATHLEN];
#endif
	static char line[64];
	FILE     *f;
	int       n;

/*
 *  First look for the environment variable "DIS_SITE_NAME" ...
 */

	s = getenv("DIS_SITE_NAME");
	if (s == (char *) NULL || strlen(s) == 0) {

/*
 *  "Cyberspace" becomes the default answer if all these other tests fail ...
 */

		strcpy(line, "Cyberspace");
		s = line;

/*
 *  Now check $HOME/.dis_site_name ...
 */
#ifndef WIN32
		strcpy(path, getenv("HOME"));
		strcat(path, "/.dis_site_name");
		if ((f = fopen(path, "r")) != NULL) {
			fgets(line, sizeof(line), f);
			n = strlen(line);
			if (n > 0 && line[n - 1] == '\n') {
				line[n - 1] = '\0';
			}
			fclose(f);
		}

/*
 *  See if /etc/dis_site_name exists ...
 */

		else
#endif
		if ((f = fopen("/etc/dis_site_name", "r")) != NULL) {
			fgets(line, sizeof(line), f);
			n = strlen(line);
			if (n > 0 && line[n - 1] == '\n') {
				line[n - 1] = '\0';
			}
			fclose(f);
		}
	}

	strncpy(result, s, max_size - 1);
	result[max_size - 1] = '\0';
	return s;
}
