!{\src2tex{textfont=tt}}
!!****f* ABINIT/vxnr
!! NAME
!! vxnr
!!
!! FUNCTION
!! Calculate the exchange potential without any relativistic corrections.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  rho=density at a specific point
!!
!! OUTPUT
!!  function vxnr=exchange potential
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function vxnr(rho)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: vxnr
 real(dp),intent(in) :: rho

!Local variables-------------------------------

! *************************************************************************
 vxnr=-(3*rho/pi)**third

 end function vxnr
!!***
