/* 
 derived from file protpars.c of PHYLIP version 3.52c with the following copyright:
 
 (c) Copyright 1980-2008. University of Washington. All rights reserved. Permission is 
 granted to reproduce, perform, and modify these programs and documentation files. 
 Permission is granted to distribute or provide access to these programs provided 
 that this copyright notice is not removed, the programs are not integrated with or 
 called by any product or service that generates revenue, and that your distribution 
 of these documentation files and programs are free. Any modified versions of these 
 materials that are distributed or accessible shall indicate that they are based on 
 these programs. Institutions of higher education are granted permission to 
 distribute this material to their students and staff for a fee to recover 
 distribution costs. Permission requests for any other distribution of these 
 program should be directed to  license (at) u.washington.edu . 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <limits.h>
#include <setjmp.h>
static jmp_buf lngjmp_env;

#define Malloc(x) mymalloc(x)

#define Void       void      /* Void f() = procedure */
#define Char        char      /* Characters (not bytes) */
#define Static     static     /* Private global funcs and vars */
#define Local      static     /* Nested functions */

typedef unsigned char boolean;

# define true    1
# define false   0

int nmlngth;                 /* max number of characters in species name    */
#define maxuser         2   /* maximum number of user-defined trees    */

extern int tree_build_interrupted;

typedef long *steptr;
typedef enum {
  ala, arg, asn, asp, cys, gln, glu, gly, his, ileu, leu, lys, met, phe, pro,
  ser1, ser2, thr, trp, tyr, val, del, stop, asx, glx, ser, unk, quest
} aas;
typedef long sitearray[3];
typedef sitearray *seqptr;

/* nodes will form a binary tree */

typedef struct node {        /* describes a tip species or an ancestor */
  struct node *next, *back;  /* pointers to nodes                      */
  long index;                /* number of the node                     */
  boolean tip, bottom;       /* present species are tips of tree       */
  aas *seq;                  /* the sequence                           */
  seqptr siteset;            /* temporary storage for aa's             */
  steptr numsteps;           /* bookkeeps steps                        */
  long xcoord, ycoord, ymin; /* used by printree                       */

  long ymax;
} node;

typedef node **pointptr;
typedef long longer[6];


Static node *root;

Static long spp, nonodes, chars, col, j;
/* spp = number of species
   nonodes = number of nodes in tree
   chars = number of sites in actual sequences
   outgrno indicates outgroup */
Static boolean usertree;
Static long fullset, fulldel;
Static steptr weight;
Static pointptr treenode;   /* pointers to all nodes in tree */
Static Char **nayme;   /* names of species */
Static double threshold;
Static steptr threshwt;
Static long *enterorder;
Static sitearray translate[(long)quest - (long)ala + 1];
Static long **fsteps;
Static long **bestrees;
Static node *temp, *temp1;
Char ch;

static char* infile;
static int maxtrees ;         /* maximum number of tied trees stored     */

/* Local variables for maketree, propagated globally for c version: */
long pnextree, pwhich, pminwhich;
double like, bestyet, bestlike, minsteps, bstlike2;
boolean lastrearr, recompute;
node *there;
long *place;
boolean *names;



static void *mymalloc(size_t x)
{
	void *mem;
	
	mem = malloc(x);
	if (mem==NULL) exit(1);
	return mem;
}


static void setup()
{
  /* set up set table to get aasets from aas */
  aas a, b;
  long s;

  for (a = ala; (long)a <= (long)stop; a = (aas)((long)a + 1))
    translate[(long)a - (long)ala][0] = 1L << ((long)a);
  translate[0]
    [1] = (1L << ((long)ala)) | (1L << ((long)asp)) | (1L << ((long)glu)) |
          (1L << ((long)gly)) | (1L << ((long)ser1)) | (1L << ((long)pro)) |
          (1L << ((long)thr)) | (1L << ((long)val));
  translate[(long)arg - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)cys)) | (1L << ((long)gln)) |
          (1L << ((long)gly)) | (1L << ((long)his)) | (1L << ((long)ileu)) |
          (1L << ((long)leu)) | (1L << ((long)lys)) | (1L << ((long)met)) |
          (1L << ((long)pro)) | (1L << ((long)ser2)) | (1L << ((long)thr)) |
          (1L << ((long)trp)) | (1L << ((long)stop));
  translate[(long)asn - (long)ala]
    [1] = (1L << ((long)asn)) | (1L << ((long)asp)) | (1L << ((long)his)) |
          (1L << ((long)ileu)) | (1L << ((long)lys)) | (1L << ((long)ser2)) |
          (1L << ((long)thr)) | (1L << ((long)tyr));
  translate[(long)asp - (long)ala]
    [1] = (1L << ((long)ala)) | (1L << ((long)asp)) | (1L << ((long)asn)) |
          (1L << ((long)glu)) | (1L << ((long)gly)) | (1L << ((long)his)) |
          (1L << ((long)tyr)) | (1L << ((long)val));
  translate[(long)cys - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)cys)) | (1L << ((long)gly)) |
          (1L << ((long)phe)) | (1L << ((long)ser1)) | (1L << ((long)ser2)) |
          (1L << ((long)trp)) | (1L << ((long)tyr)) | (1L << ((long)stop));
  translate[(long)gln - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)gln)) | (1L << ((long)glu)) |
          (1L << ((long)his)) | (1L << ((long)leu)) | (1L << ((long)lys)) |
          (1L << ((long)pro)) | (1L << ((long)stop));
  translate[(long)glu - (long)ala]
    [1] = (1L << ((long)ala)) | (1L << ((long)asp)) | (1L << ((long)gln)) |
          (1L << ((long)glu)) | (1L << ((long)gly)) | (1L << ((long)lys)) |
          (1L << ((long)val)) | (1L << ((long)stop));
  translate[(long)gly - (long)ala]
    [1] = (1L << ((long)ala)) | (1L << ((long)arg)) | (1L << ((long)asp)) |
          (1L << ((long)cys)) | (1L << ((long)glu)) | (1L << ((long)gly)) |
          (1L << ((long)ser2)) | (1L << ((long)trp)) | (1L << ((long)val)) |
          (1L << ((long)stop));
  translate[(long)his - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)asn)) | (1L << ((long)asp)) |
          (1L << ((long)gln)) | (1L << ((long)his)) | (1L << ((long)leu)) |
          (1L << ((long)pro)) | (1L << ((long)tyr));
  translate[(long)ileu - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)asn)) | (1L << ((long)ileu)) |
          (1L << ((long)leu)) | (1L << ((long)lys)) | (1L << ((long)met)) |
          (1L << ((long)phe)) | (1L << ((long)ser2)) | (1L << ((long)thr)) |
          (1L << ((long)val));
  translate[(long)leu - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)gln)) | (1L << ((long)his)) |
          (1L << ((long)ileu)) | (1L << ((long)leu)) | (1L << ((long)met)) |
          (1L << ((long)phe)) | (1L << ((long)pro)) | (1L << ((long)ser1)) |
          (1L << ((long)trp)) | (1L << ((long)val)) | (1L << ((long)stop));
  translate[(long)lys - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)asn)) | (1L << ((long)gln)) |
          (1L << ((long)glu)) | (1L << ((long)ileu)) | (1L << ((long)lys)) |
          (1L << ((long)met)) | (1L << ((long)thr)) | (1L << ((long)stop));
  translate[(long)met - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)ileu)) | (1L << ((long)leu)) |
          (1L << ((long)lys)) | (1L << ((long)met)) | (1L << ((long)val)) |
          (1L << ((long)thr));
  translate[(long)phe - (long)ala]
    [1] = (1L << ((long)cys)) | (1L << ((long)ileu)) | (1L << ((long)leu)) |
          (1L << ((long)phe)) | (1L << ((long)ser1)) | (1L << ((long)tyr)) |
          (1L << ((long)val));
  translate[(long)pro - (long)ala]
    [1] = (1L << ((long)ala)) | (1L << ((long)arg)) | (1L << ((long)gln)) |
          (1L << ((long)his)) | (1L << ((long)leu)) | (1L << ((long)pro)) |
          (1L << ((long)ser1)) | (1L << ((long)thr));
  translate[(long)ser1 - (long)ala]
    [1] = (1L << ((long)ala)) | (1L << ((long)cys)) | (1L << ((long)leu)) |
          (1L << ((long)phe)) | (1L << ((long)pro)) | (1L << ((long)ser1)) |
          (1L << ((long)thr)) | (1L << ((long)trp)) | (1L << ((long)tyr)) |
          (1L << ((long)stop));
  translate[(long)ser2 - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)asn)) | (1L << ((long)cys)) |
          (1L << ((long)gly)) | (1L << ((long)ileu)) | (1L << ((long)ser2)) |
          (1L << ((long)thr));
  translate[(long)thr - (long)ala]
    [1] = (1L << ((long)ala)) | (1L << ((long)arg)) | (1L << ((long)asn)) |
          (1L << ((long)ileu)) | (1L << ((long)lys)) | (1L << ((long)met)) |
          (1L << ((long)pro)) | (1L << ((long)ser1)) | (1L << ((long)ser2)) |
          (1L << ((long)thr));
  translate[(long)trp - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)cys)) | (1L << ((long)gly)) |
          (1L << ((long)leu)) | (1L << ((long)ser1)) | (1L << ((long)stop)) |
          (1L << ((long)trp));
  translate[(long)tyr - (long)ala]
    [1] = (1L << ((long)asn)) | (1L << ((long)asp)) | (1L << ((long)cys)) |
          (1L << ((long)his)) | (1L << ((long)phe)) | (1L << ((long)ser1)) |
          (1L << ((long)stop)) | (1L << ((long)tyr));
  translate[(long)val - (long)ala]
    [1] = (1L << ((long)ala)) | (1L << ((long)asp)) | (1L << ((long)glu)) |
          (1L << ((long)gly)) | (1L << ((long)ileu)) | (1L << ((long)leu)) |
          (1L << ((long)met)) | (1L << ((long)phe)) | (1L << ((long)val));
  translate[(long)stop - (long)ala]
    [1] = (1L << ((long)arg)) | (1L << ((long)cys)) | (1L << ((long)gln)) |
          (1L << ((long)glu)) | (1L << ((long)gly)) | (1L << ((long)leu)) |
          (1L << ((long)lys)) | (1L << ((long)ser1)) | (1L << ((long)trp)) |
          (1L << ((long)tyr)) | (1L << ((long)stop));
  translate[(long)del - (long)ala][1] = 1L << ((long)del);
  fulldel = (1L << ((long)stop + 1)) - (1L << ((long)ala));
  fullset = fulldel & (~(1L << ((long)del)));
  translate[(long)asx - (long)ala]
    [0] = (1L << ((long)asn)) | (1L << ((long)asp));
  translate[(long)glx - (long)ala]
    [0] = (1L << ((long)gln)) | (1L << ((long)glu));
  translate[(long)ser - (long)ala]
    [0] = (1L << ((long)ser1)) | (1L << ((long)ser2));
  translate[(long)unk - (long)ala][0] = fullset;
  translate[(long)quest - (long)ala][0] = fulldel;
  translate[(long)asx - (long)ala]
    [1] = translate[(long)asn - (long)ala]
          [1] | translate[(long)asp - (long)ala][1];
  translate[(long)glx - (long)ala]
    [1] = translate[(long)gln - (long)ala]
          [1] | translate[(long)glu - (long)ala][1];
  translate[(long)ser - (long)ala]
    [1] = translate[(long)ser1 - (long)ala]
          [1] | translate[(long)ser2 - (long)ala][1];
  translate[(long)unk - (long)ala][1] = fullset;
  translate[(long)quest - (long)ala][1] = fulldel;
  for (a = ala; (long)a <= (long)quest; a = (aas)((long)a + 1)) {
    s = 0;
    for (b = ala; (long)b <= (long)stop; b = (aas)((long)b + 1)) {
      if (((1L << ((long)b)) & translate[(long)a - (long)ala][1]) != 0)
        s |= translate[(long)b - (long)ala][1];
    }
    translate[(long)a - (long)ala][2] = s;
  }
}  /* setup */



static void doinit()
{
  /* initializes variables */
  long i;
  node *p, *q;

  treenode = (pointptr)Malloc(nonodes*sizeof(node *));
  for (i = 0; i < (spp); i++) {
    treenode[i] = (node *)Malloc(sizeof(node));
    treenode[i]->numsteps = (steptr)Malloc(chars*sizeof(long));
    treenode[i]->siteset = (seqptr)Malloc(chars*sizeof(sitearray));
    treenode[i]->seq = (aas *)Malloc(chars*sizeof(aas));
  }
  for (i = spp; i < (nonodes); i++) {
    q = NULL;
    for (j = 1; j <= 3; j++) {
      p = (node *)Malloc(sizeof(node));
      p->numsteps = (steptr)Malloc(chars*sizeof(long));
      p->siteset = (seqptr)Malloc(chars*sizeof(sitearray));
      p->seq = (aas *)Malloc(chars*sizeof(aas));
      p->next = q;
      q = p;
    }
    p->next->next->next = p;
    treenode[i] = p;
  }
}  /* doinit*/


static void inputoptions(int *bt_weights)
{
  /* input the information on the options */
  long i ;

	if(bt_weights != NULL) for (i = 0; i < (chars); i++) weight[i] = bt_weights[i];
	else for (i = 0; i < (chars); i++) weight[i] = 1;

  threshold = spp * 3.0;
  for (i = 0; i < (chars); i++) {
    weight[i] *= 10;
    threshwt[i] = (long)(threshold * weight[i] + 0.5);
  }
}  /* inputoptions */


static void makevalues()
{
  /* set up fractional likelihoods at tips */
  long i, j;
  node *p;

  for (i = 1; i <= nonodes; i++) {
    treenode[i - 1]->back = NULL;
    treenode[i - 1]->tip = (i <= spp);
    treenode[i - 1]->index = i;
    for (j = 0; j < (chars); j++)
      treenode[i - 1]->numsteps[j] = 0;
    if (i > spp) {
      p = treenode[i - 1]->next;
      while (p != treenode[i - 1]) {
        p->back = NULL;
        p->tip = false;
        p->index = i;
        for (j = 0; j < (chars); j++)
          p->numsteps[j] = 0;
        p = p->next;
      }
    }
  }
}  /* makevalues */


static void doinput(char** seq, char** seqname, int *bt_weights)
{
  /* reads the input data */

aas aa;
char charstate;
int i,j, ll;

  inputoptions(bt_weights);
for(i=0;i<spp;i++){
	for(j=0;j<chars;j++){
	    charstate=seq[i][j];
            aa =  (charstate == 'A') ?  ala :
                  (charstate == 'B') ?  asx :
                  (charstate == 'C') ?  cys :
                  (charstate == 'D') ?  asp :
                  (charstate == 'E') ?  glu :
                  (charstate == 'F') ?  phe :
                  (charstate == 'G') ?  gly : aa;
            aa =  (charstate == 'H') ?  his :
                  (charstate == 'I') ? ileu :
                  (charstate == 'K') ?  lys :
                  (charstate == 'L') ?  leu :
                  (charstate == 'M') ?  met :
                  (charstate == 'N') ?  asn :
                  (charstate == 'P') ?  pro :
                  (charstate == 'Q') ?  gln :
                  (charstate == 'R') ?  arg : aa;
             aa = (charstate == 'S') ?  ser :
                  (charstate == 'T') ?  thr :
                  (charstate == 'V') ?  val :
                  (charstate == 'W') ?  trp :
                  (charstate == 'X') ?  unk :
                  (charstate == 'Y') ?  tyr :
                  (charstate == 'Z') ?  glx :
                  (charstate == '*') ? stop :
                  (charstate == '?') ? quest:
                  (charstate == '-') ? del  :  aa;

          treenode[i]->seq[j] = aa;
          memcpy(treenode[i]->siteset[j],
                 translate[(long)aa - (long)ala], sizeof(sitearray));
	}
	strncpy(nayme[i], seqname[i], nmlngth);
        ll=strlen(seqname[i]);
        if(ll>nmlngth) ll=nmlngth;
        for(j=ll;j<nmlngth;j++) nayme[i][j]=' ';
        nayme[i][nmlngth]='\0';
}

  makevalues();
}  /* doinput */



static void fillin(node* p, node* left, node* rt)
{
  /* sets up for each node in the tree the aa set for site m
     at that point and counts the changes.  The program
     spends much of its time in this PROCEDURE */
  boolean counted;
  aas aa;
  long s;
  sitearray ls, rs, qs;
  long i, j, k, m, n;

  for (m = 0; m < chars; m++) {
    k = 0;
    if (left != NULL)
      memcpy(ls, left->siteset[m], sizeof(sitearray));
    if (rt != NULL)
      memcpy(rs, rt->siteset[m], sizeof(sitearray));
    if (left == NULL) {
      n = rt->numsteps[m];
      memcpy(qs, rs, sizeof(sitearray));
    }
    else if (rt == NULL) {
      n = left->numsteps[m];
      memcpy(qs, ls, sizeof(sitearray));
    }
    else {
      n = left->numsteps[m] + rt->numsteps[m];
      counted = false;
      for (i = 0; i <= 5; i++) {
        if (k < 3) {
          switch (i) {

            case 0:
              s = ls[0] & rs[0];
              break;

            case 1:
              s = (ls[0] & rs[1]) | (ls[1] & rs[0]);
              break;

            case 2:
              s = (ls[0] & rs[2]) | (ls[1] & rs[1]) | (ls[2] & rs[0]);
              break;

            case 3:
              s = ls[0] | (ls[1] & rs[2]) | (ls[2] & rs[1]) | rs[0];
              break;

            case 4:
              s = ls[1] | (ls[2] & rs[2]) | rs[1];
              break;

            case 5:
              s = ls[2] | rs[2];
              break;
            }
          if (counted || s != 0) {
            qs[k] = s;
            k++;
            counted = true;
          } else if (!counted)
            n += weight[m];
        }
      }
    }
    for (i = 0; i <= 1; i++) {
      for (aa = ala; (long)aa <= (long)stop; aa = (aas)((long)aa + 1)) {
        if (((1L << ((long)aa)) & qs[i]) != 0) {
          for (j = i + 1; j <= 2; j++)
            qs[j] |= translate[(long)aa - (long)ala][j - i];
        }
      }
    }
    p->numsteps[m] = n;
    memcpy(p->siteset[m], qs, sizeof(sitearray));
  }
}  /* fillin */

static void preorder(node* p)
{
  /* recompute number of steps in preorder taking both ancestoral and
     descendent steps into account */
  if (p != NULL && !p->tip) {
    fillin (p->next, p->next->next->back, p->back);
    fillin (p->next->next, p->back, p->next->back);
    preorder (p->next->back);
    preorder (p->next->next->back);
  }
} /* preorder */


static void add(node* below, node* newtip, node* newfork)
{
  /* inserts the nodes newfork and its left descendant, newtip,
     to the tree.  below becomes newfork's right descendant */
  if (below != treenode[below->index - 1])
    below = treenode[below->index - 1];
  if (below->back != NULL)
    below->back->back = newfork;
  newfork->back = below->back;
  below->back = newfork->next->next;
  newfork->next->next->back = below;
  newfork->next->back = newtip;
  newtip->back = newfork->next;
  if (root == below)
    root = newfork;
  root->back = NULL;
  if (recompute) {
    fillin (newfork, newfork->next->back, newfork->next->next->back);
    preorder(newfork);
    if (newfork != root)
      preorder(newfork->back);
  }
}  /* add */

static void re_move(node** item, node** fork)
{
  /* removes nodes item and its ancestor, fork, from the tree.
     the new descendant of fork's ancestor is made to be
     fork's second descendant (other than item).  Also
     returns pointers to the deleted nodes, item and fork */
  node *p, *q, *other;

  if ((*item)->back == NULL) {
    *fork = NULL;
    return;
  }
  *fork = treenode[(*item)->back->index - 1];
  if ((*item) == (*fork)->next->back)
    other = (*fork)->next->next->back;
  else other = (*fork)->next->back;
  if (root == *fork)
    root = other;
  p = (*item)->back->next->back;
  q = (*item)->back->next->next->back;
  if (p != NULL) p->back = q;
  if (q != NULL) q->back = p;
  (*fork)->back = NULL;
  p = (*fork)->next;
  do {
    p->back = NULL;
    p = p->next;
  } while (p != (*fork));
  (*item)->back = NULL;
  if (recompute) {
    preorder(other);
    if (other != root) preorder(other->back);
  }
}  /* re_move */

static void evaluate(node* r)
{
  /* determines the number of steps needed for a tree. this is the
     minimum number of steps needed to evolve sequences on this tree */
  long i, steps, term;
  double sum;

  if (tree_build_interrupted) {
    longjmp(lngjmp_env, 0);
  }
  sum = 0.0;
  for (i = 0; i < (chars); i++) {
    steps = r->numsteps[i];
    if (steps <= threshwt[i])
      term = steps;
    else
      term = threshwt[i];
    sum += term;
    if (usertree && pwhich <= maxuser)
      fsteps[pwhich - 1][i] = term;
  }
  if (usertree && pwhich <= maxuser) {
    if (pwhich == 1) {
      pminwhich = 1;
      minsteps = sum;
    } else if (sum < minsteps) {
      pminwhich = pwhich;
      minsteps = sum;
    }
  }
  like = -sum;
}  /* evaluate */

static void postorder(node* p)
{
  /* traverses a binary tree, calling PROCEDURE fillin at a
     node's descendants before calling fillin at the node */
  if (p->tip)
    return;
  postorder(p->next->back);
  postorder(p->next->next->back);
  fillin(p,    p->next->back, p->next->next->back);
}  /* postorder */

static void reroot(node* outgroup)
{
  /* reorients tree, putting outgroup in desired position. */
  node *p, *q;

  if (outgroup->back->index == root->index)
    return;
  p = root->next;
  q = root->next->next;
  p->back->back = q->back;
  q->back->back = p->back;
  p->back = outgroup;
  q->back = outgroup->back;
  outgroup->back->back = q;
  outgroup->back = p;
}  /* reroot */



static void savetraverse(node* p, long* pos, boolean* found)
{
  /* sets BOOLEANs that indicate which way is down */
  p->bottom = true;
  if (p->tip)
    return;
  p->next->bottom = false;
  savetraverse(p->next->back, pos,found);
  p->next->next->bottom = false;
  savetraverse(p->next->next->back, pos,found);
}  /* savetraverse */

static void savetree(long* pos, boolean* found)
{
  /* record in place where each species has to be
     added to reconstruct this tree */
  long i, j;
  node *p;
  boolean done;

  reroot(treenode[0]);
  savetraverse(root, pos,found);
  for (i = 0; i < (nonodes); i++)
    place[i] = 0;
  place[root->index - 1] = 1;
  for (i = 1; i <= (spp); i++) {
    p = treenode[i - 1];
    while (place[p->index - 1] == 0) {
      place[p->index - 1] = i;
      while (!p->bottom)
        p = p->next;
      p = p->back;
    }
    if (i > 1) {
      place[i - 1] = place[p->index - 1];
      j = place[p->index - 1];
      done = false;
      while (!done) {
        place[p->index - 1] = spp + i - 1;
        while (!p->bottom)
          p = p->next;
        p = p->back;
        done = (p == NULL);
        if (!done)
          done = (place[p->index - 1] != j);
      }
    }
  }
}  /* savetree */

static void findtree(long* pos, boolean* found)
{
  /* finds tree given by ARRAY place in ARRAY
     bestrees by binary search */
  long i, lower, upper;
  boolean below, done;

  below = false;
  lower = 1;
  upper = pnextree - 1;
  *found = false;
  while (!(*found) && lower <= upper) {
    (*pos) = (lower + upper) / 2;
    i = 3;
    done = false;
    while (!done) {
      done = (i > spp);
      if (!done)
        done = (place[i - 1] != bestrees[(*pos) - 1][i - 1]);
      if (!done)
        i++;
    }
    (*found) = (i > spp);
    below = (place[i - 1] < bestrees[(*pos) - 1][i - 1]);
    if (*found)
      break;
    if (below)
      upper = (*pos) - 1;
    else
      lower = (*pos) + 1;
  }
  if (!(*found) && !below)
    (*pos)++;
}  /* findtree */

static void addtree(long* pos, boolean* found)
{
  /* puts tree from ARRAY place in its proper position
     in ARRAY bestrees */
  long i;

  for (i = pnextree - 1; i >= (*pos); i--)
    memcpy(bestrees[i], bestrees[i - 1], spp*sizeof(long));
  for (i = 0; i < (spp); i++)
    bestrees[(*pos) - 1][i] = place[i];
  pnextree++;
}  /* addtree */

static void tryadd(node* p, node** item, node** nufork)
{
  /* temporarily adds one fork and one tip to the tree.
     if the location where they are added yields greater
     "likelihood" than other locations tested up to that
     time, then keeps that location as there */
/* Local variables for tryadd: */
  long pos;
  boolean found;
  node *rute, *q;

  if (p == root)
    fillin(temp, *item, p);
  else {
    fillin(temp1, *item, p);
    fillin(temp, temp1, p->back);
  }
  evaluate(temp);
  if (lastrearr) {
    if (like < bestlike) {
      if ((*item) == (*nufork)->next->next->back) {
        q = (*nufork)->next;
        (*nufork)->next = (*nufork)->next->next;
        (*nufork)->next->next = q;
        q->next = (*nufork);
      }
    }
    else if (like >= bstlike2) {
      recompute = false;
      add (p, (*item), (*nufork));
      rute = root->next->back;
      savetree(&pos,&found);
      reroot(rute);
      if (like > bstlike2) {
        bestlike = bstlike2 = like;
        pos = 1;
        pnextree = 1;
        addtree(&pos,&found);
      } else {
        pos = 0;
        findtree(&pos,&found);
        if (!found) {
          if (pnextree <= maxtrees)
            addtree(&pos,&found);
        }
      }
      re_move (item, nufork);
      recompute = true;
    }
  }
  if (like > bestyet) {
    bestyet = like;
    there = p;
  }
}  /* tryadd */

static void addpreorder(node* p, node* item, node* nufork)
{
  /* traverses a binary tree, calling PROCEDURE tryadd
     at a node before calling tryadd at its descendants */

  if (p == NULL)
    return;
  tryadd(p, &item,&nufork);
  if (!p->tip) {
    addpreorder(p->next->back, item, nufork);
    addpreorder(p->next->next->back, item, nufork);
  }
}  /* addpreorder */

static void tryrearr(node* p, boolean* success)
{
  /* evaluates one rearrangement of the tree.
     if the new tree has greater "likelihood" than the old
     one sets success := TRUE and keeps the new tree.
     otherwise, restores the old tree */
  node *frombelow, *whereto, *forknode, *q;
  double oldlike;

  if (p->back == NULL)
    return;
  forknode = treenode[p->back->index - 1];
  if (forknode->back == NULL)
    return;
  oldlike = bestyet;
  if (p->back->next->next == forknode)
    frombelow = forknode->next->next->back;
  else
    frombelow = forknode->next->back;
  whereto = treenode[forknode->back->index - 1];
  if (whereto->next->back == forknode)
    q = whereto->next->next->back;
  else
    q = whereto->next->back;
  fillin(temp1, frombelow, q);
  fillin(temp, temp1, p);
  fillin(temp1, temp, whereto->back);
  evaluate(temp1);
  if (like <= oldlike) {
    if (p == forknode->next->next->back) {
      q = forknode->next;
      forknode->next = forknode->next->next;
      forknode->next->next = q;
      q->next = forknode;
    }
  }
  else {
    recompute = false;
    re_move(&p, &forknode);
    fillin(whereto, whereto->next->back, whereto->next->next->back);
    recompute = true;
    add(whereto, p, forknode);
    *success = true;
    bestyet = like;
  }
}  /* tryrearr */

static void repreorder(node* p, boolean* success)
{
  /* traverses a binary tree, calling PROCEDURE tryrearr
     at a node before calling tryrearr at its descendants */
  if (p == NULL)
    return;
  tryrearr(p,success);
  if (!p->tip) {
    repreorder(p->next->back,success);
    repreorder(p->next->next->back,success);
  }
}  /* repreorder */

static void rearrange(node** r)
{
  /* traverses the tree (preorder), finding any local
     rearrangement which decreases the number of steps.
     if traversal succeeds in increasing the tree's
     "likelihood", PROCEDURE rearrange runs traversal again */
  boolean success = true;
  while (success) {
    success = false;
    repreorder(*r, &success);
  }
}  /* rearrange */



static int findch(Char c)
//returns 0 iff OK
{
  /* scan forward until find character c */
  boolean done;

  done = false;
  while (!done) {
    if (c == ',') {
      if (ch == '(' || ch == ')' ||ch == ';') {
//        printf("\nERROR IN USER TREE:");
//	printf(" UNMATCHED PARENTHESIS OR MISSING COMMA\n");
//	exit(-1);
		  return 1;
      } else if (ch == ',')
        done = true;
    } else if (c == ')') {
      if (ch == '(' || ch == ',' || ch == ';') {
//        printf("\nERROR IN USER TREE:");
//	printf(" UNMATCHED PARENTHESIS OR NOT BIFURCATED NODE\n");
//	exit(-1);
		  return 1;
      } else {
        if (ch == ')')
          done = true;
      }
    } else if (c == ';') {
      if (ch != ';') {
//        printf("\nERROR IN USER TREE:");
//	printf(" UNMATCHED PARENTHESIS OR MISSING SEMICOLON\n");
//	exit(-1);
		  return 1;
      } else
        done = true;
    }
    if ((done && ch == ')') || !done) sscanf(infile++, "%c", &ch);
  }
	return 0;
}  /* findch */


static int addelement(node** p, long* nextnode, long* lparens, boolean* names)
//return 0 iff OK
{
  /* recursive procedure adds nodes to user-defined tree */
  node *q;
  long i, n;
  boolean found;
  Char str[nmlngth];

  do {
    sscanf(infile++, "%c", &ch);
  } while (ch == ' ');
  if (ch == '(' ) {
    if ((*lparens) >= spp - 1) {
//      printf("\nERROR IN USER TREE: TOO MANY LEFT PARENTHESES\n");
//      exit(-1);
		return 1;
    }
    (*nextnode)++;
    (*lparens)++;
    q = treenode[(*nextnode) - 1];
    if( addelement(&q->next->back, nextnode,lparens,names) ) return 1;
    q->next->back->back = q->next;
    if( findch(',') ) return 1;
    if( addelement(&q->next->next->back, nextnode,lparens,names) ) return 1;
    q->next->next->back->back = q->next->next;
    if( findch(')') ) return 1;
    *p = q;
    return 0;
  }
  for (i = 0; i < nmlngth; i++)
    str[i] = ' ';
  n = 1;
  do {
//    if (ch == '_') ch = ' ';
    str[n - 1] = ch;
    sscanf(infile++, "%c", &ch);
    n++;
  } while (ch != ',' && ch != ')' && ch != ':' && n <= nmlngth);
  n = 1;
  do {
    found = true;
    for (i = 0; i < nmlngth; i++)
      found = (found && str[i] == nayme[n - 1][i]);
    if (found) {
      if (names[n - 1] == false) {
        *p = treenode[n - 1];
        names[n - 1] = true;
      } else {
//        printf("\nERROR IN USER TREE: DUPLICATE NAME FOUND -- ");
//	exit(-1);
		  return 1;
      }
    } else
      n++;
  } while (!(n > spp || found));
  if (n <= spp)
    return 0;
//  printf("CANNOT FIND SPECIES: ");
	return 1;
}  /* addelement */


static int treeread()
// returns 0 iff OK
{
  /* read in user-defined tree and set it up */
  long nextnode, lparens;
  long i;

  root = treenode[spp];
  nextnode = spp;
  root->back = NULL;
  for (i = 0; i < (spp); i++)
    names[i] = false;
  lparens = 0;
  if( addelement(&root, &nextnode,&lparens,names) ) return 1;
  if( findch(';') ) return 1;
  if(*infile != 0) infile++;
	return 0;
}  /* treeread */


Local Void treeout(node* p, char* treefile)
{
	/* write out file with representation of final tree */
	short n;
	
	if (p->tip) {
		n = strlen(nayme[p->index - 1]);
		while(nayme[p->index - 1][n-1] == ' ') n--;
		memcpy(treefile + col, nayme[p->index - 1], n );
		col += n;
	} else {
		treefile[col]='(';
		col++;
		treeout(p->next->back, treefile);
		treefile[col]=',';
		col++;
		treeout(p->next->next->back, treefile);
		treefile[col]=')';
		col++;
	}
	if (p == root) { strcpy(treefile + col, ";\n"); col += 2; }
}  /* treeout */


static char *describe(void)
{
	col = 0;
	char *treefile = (char *)malloc(spp*(nmlngth + 3) + 10);
	treeout(root, treefile);
	treefile = (char *)realloc(treefile, col + 1);
	return treefile;
}  /* describe */


static char *maketree(void)
//returns NULL iff error
{
  /* constructs a binary tree from the pointers in treenode.
     adds each node at location which yields highest "likelihood"
     then rearranges the tree for greatest "likelihood" */
  long i, j;
  double gotlike;
  node *item, *nufork, *dummy;
	char *treefile, *onetree;
	int ltreefile = 0;

	treefile = (char *)malloc(100);
	treefile[0] = 0;
  
  if (setjmp(lngjmp_env)) goto way_out;

  if (!usertree) {
    for (i = 1; i <= (spp); i++)
      enterorder[i - 1] = i;
    root = treenode[enterorder[0] - 1];
    recompute = true;
    add(treenode[enterorder[0] - 1], treenode[enterorder[1] - 1],
        treenode[spp]);
    lastrearr = false;
    for (i = 3; i <= (spp); i++) {
      bestyet = -1.0e6;
      there = root;
      item = treenode[enterorder[i - 1] - 1];
      nufork = treenode[spp + i - 2];
      addpreorder(root, item, nufork);
      add(there, item, nufork);
      like = bestyet;
      rearrange(&root);
      lastrearr = (i == spp);
      if (lastrearr) {
        bestlike = bestyet;
        bstlike2 = bestlike;
        pnextree = 1;
        do {
          gotlike = bestlike;
          for (j = 0; j < (nonodes); j++) {
            bestyet = -1.0e6;
            item = treenode[j];
            if (item != root) {
              nufork = treenode[treenode[j]->back->index - 1];
              re_move(&item, &nufork);
              there = root;
              addpreorder(root, item, nufork);
              add(there, item, nufork);
            }
          }
        } while (bestlike > gotlike);
      }
    }
    for (i = spp - 1; i >= 1; i--)
      re_move(&treenode[i], &dummy);


      if (pnextree > maxtrees + 1) {
        pnextree = maxtrees + 1;
      }
      recompute = false;
      for (i = 0; i <= 0 /*pnextree-2*/; i++) {
        root = treenode[0];
        add(treenode[0], treenode[1], treenode[spp]);
        for (j = 3; j <= (spp); j++)
          add(treenode[bestrees[i][j - 1] - 1], treenode[j - 1],
              treenode[spp + j - 2]);
        reroot(treenode[0]);
        postorder(root);
        evaluate(root);
		  onetree = describe();
		  ltreefile += strlen(onetree);
		  treefile = realloc(treefile, ltreefile + 1);
		  strcat(treefile, onetree);
		  free(onetree);
		  for (j = 1; j < (spp); j++)
          re_move(&treenode[j], &dummy);
      }
  }



 else {
    pwhich = 1;
    fsteps = (long **)Malloc(maxuser*sizeof(long *));
    for (j = 1; j <= maxuser; j++)
      fsteps[j - 1] = (long *)Malloc(/*endsite*/chars*sizeof(long));
	 free(treefile); treefile = NULL;
    if( treeread() == 0) {
		postorder(root);
		evaluate(root);
		treefile = describe();
		}
  }
way_out:
  if (usertree) {
    for(i=0;i<maxuser;i++) free(fsteps[i]);
    free(fsteps);
    }
  return treefile;
}  /* maketree */



	 /***************** "MAIN" FUNCTION ***************/


char *protpars(char** seq, char** seqname, int notu, int* steps, char* toevaluate, int arg_maxtrees,
	int *bt_weights)
{  
	char* treefile;
int i,j;
	maxtrees = arg_maxtrees;


if (toevaluate){ usertree=true; infile=toevaluate; }
else usertree=false;

  setup();

spp=notu;
chars = strlen(seq[0]);  
nonodes = spp * 2 - 1;


  doinit();
  bestrees = (long **)Malloc(maxtrees*sizeof(long *));
  for (j = 1; j <= maxtrees; j++)
    bestrees[j - 1] = (long *)Malloc(spp*sizeof(long));
  nayme = (Char **)Malloc(spp*sizeof(Char *));
	nmlngth = 0;
	for (j = 0; j < spp; j++) {
		if(strlen(seqname[j]) > nmlngth) nmlngth = strlen(seqname[j]);
	}
	for (j = 1; j <= spp; j++)
    nayme[j - 1] = (Char *)Malloc((nmlngth+1)*sizeof(Char));
  enterorder = (long *)Malloc(spp*sizeof(long));
  names = (boolean *)Malloc(spp*sizeof(boolean));
  place = (long *)Malloc(nonodes*sizeof(long));
  weight = (steptr)Malloc(chars*sizeof(long));
  threshwt = (steptr)Malloc(chars*sizeof(long));
  temp = (node *)Malloc(sizeof(node));
  temp->numsteps = (steptr)Malloc(chars*sizeof(long));
  temp->siteset = (seqptr)Malloc(chars*sizeof(sitearray));
  temp->seq = (aas *)Malloc(chars*sizeof(aas));
  temp1 = (node *)Malloc(sizeof(node));
  temp1->numsteps = (steptr)Malloc(chars*sizeof(long));
  temp1->siteset = (seqptr)Malloc(chars*sizeof(sitearray));
  temp1->seq = (aas *)Malloc(chars*sizeof(aas));

  doinput(seq, seqname, bt_weights);
  treefile = maketree();
  
for(i=0;i<nonodes;i++) { 
  free(treenode[i]->seq); 
  free(treenode[i]->numsteps);
  free(treenode[i]->siteset);
  free(treenode[i]);
}
for(i=0;i<maxtrees;i++) free(bestrees[i]);
free(bestrees);
for(i=0;i<spp;i++) free(nayme[i]);
  free(nayme);
free(enterorder); free(names); free(place); free(weight); free(threshwt);
free(treenode);
free(temp->seq); free(temp1->seq);
free(temp->numsteps); free(temp1->numsteps);
free(temp->siteset); free(temp1->siteset);
free(temp); free(temp1);

if (steps) *steps = (int)(like/(-10.) + .5);

return treefile;
}  /* Protein parsimony by uphill search */



