#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 mortalius
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Door Kickers
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220702.1

GAME_ID='door-kickers'
GAME_NAME='Door Kickers'

ARCHIVE_BASE_GOG_0='gog_door_kickers_2.7.0.11.sh'
ARCHIVE_BASE_GOG_0_MD5='29efa58e4a61060b0b1211dddd2476a1'
ARCHIVE_BASE_GOG_0_TYPE='mojosetup'
ARCHIVE_BASE_GOG_0_SIZE='1400000'
ARCHIVE_BASE_GOG_0_VERSION='1.0.9-gog2.7.0.11'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/door_kickers'

ARCHIVE_BASE_HUMBLE_0='DoorKickers1448920440.tar.gz'
ARCHIVE_BASE_HUMBLE_0_MD5='0126db31867ae0e7a7eceee54de4a177'
ARCHIVE_BASE_HUMBLE_0_SIZE='1400000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0.9-humble151130'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/door-kickers'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='DoorKickers'
ARCHIVE_DOC_DATA_FILES='
*.txt'
ARCHIVE_GAME_BIN_FILES='
DoorKickers'
ARCHIVE_GAME_DATA_FILES='
data
linux_libs
mods'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='DoorKickers'
APP_MAIN_ICON_GOG='data/noarch/support/icon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGLU.so.1 libopenal.so.1 libSDL2-2.0.so.0"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
(
	APP_MAIN_ICON=$(get_context_specific_value 'archive' 'APP_MAIN_ICON')
	if [ -n "$APP_MAIN_ICON" ]; then
		icons_get_from_workdir 'APP_MAIN'
	fi
)

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
