#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Crypt of the NecroDancer expansions:
# - Amplified
###

script_version=20231101.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='crypt-of-the-necrodancer'
GAME_NAME='Crypt of the NecroDancer'

EXPANSION_ID_AMPLIFIED='amplified'
EXPANSION_NAME_AMPLIFIED='Amplified'

ARCHIVE_BASE_AMPLIFIED_2_NAME='crypt_of_the_necrodancer_amplified_3_7_4_b4860_68330.sh'
ARCHIVE_BASE_AMPLIFIED_2_MD5='e56eb1c2e7595ced5b67075dc08d65c9'
ARCHIVE_BASE_AMPLIFIED_2_SIZE='794448'
ARCHIVE_BASE_AMPLIFIED_2_VERSION='3.7.4-gog68330'
ARCHIVE_BASE_AMPLIFIED_2_URL='https://www.gog.com/game/crypt_of_the_necrodancer_amplified'

ARCHIVE_BASE_AMPLIFIED_1_NAME='crypt_of_the_necrodancer_amplified_3_4_0_b3655_61079.sh'
ARCHIVE_BASE_AMPLIFIED_1_MD5='410df53bd1efe43dfc6fd41cb9cdf694'
ARCHIVE_BASE_AMPLIFIED_1_SIZE='600000'
ARCHIVE_BASE_AMPLIFIED_1_VERSION='3.4.0-gog61079'

ARCHIVE_BASE_AMPLIFIED_0_NAME='crypt_of_the_necrodancer_amplified_3_1_5_b3223_59419.sh'
ARCHIVE_BASE_AMPLIFIED_0_MD5='67c2111ad6116ea68c343f9d7694eb1c'
ARCHIVE_BASE_AMPLIFIED_0_SIZE='600000'
ARCHIVE_BASE_AMPLIFIED_0_VERSION='3.1.5-gog59419'

CONTENT_PATH_DEFAULT='data/noarch/game'
## These files overwrite the ones provided by the base game
CONTENT_GAME_DATA_COMMON_FILES='
data/entities/beastmaster.png
data/entities/bossmaster.png
data/entities/char1_armor_body.png
data/entities/char1_heads.png
data/entities/char2_armor_body.png
data/entities/char2_heads.png
data/entities/char3_armor_body.png
data/entities/char3_heads.png
data/entities/char4_armor_body.png
data/entities/char4_heads.png
data/entities/char5_armor_body.png
data/entities/char5_heads.png
data/entities/char6_armor_body.png
data/entities/char6_heads.png
data/entities/char7_armor_body.png
data/entities/char7_heads.png
data/entities/char8_armor_body.png
data/entities/char8_heads.png
data/entities/char9_armor_body.png
data/entities/char9_heads.png
data/entities/dragon_blue.png
data/entities/dragon_green.png
data/entities/dragon_red.png
data/entities/golem_ooze.png
data/entities/jp10_armor_body.png
data/entities/jp10_heads.png
data/entities/jp11_armor_body.png
data/entities/jp11_heads.png
data/entities/jp1_armor_body.png
data/entities/jp1_heads.png
data/entities/jp2_armor_body.png
data/entities/jp2_heads.png
data/entities/jp3_armor_body.png
data/entities/jp3_heads.png
data/entities/jp4_armor_body.png
data/entities/jp4_heads.png
data/entities/jp5_armor_body.png
data/entities/jp5_heads.png
data/entities/jp6_armor_body.png
data/entities/jp6_heads.png
data/entities/jp7_armor_body.png
data/entities/jp7_heads.png
data/entities/jp8_armor_body.png
data/entities/jp8_heads.png
data/entities/jp9_armor_body.png
data/entities/jp9_heads.png
data/entities/player1_armor_body.png
data/entities/player1_heads.png
data/entities/player2_armor_body.png
data/entities/player2_heads.png
data/entities/player3_armor_body.png
data/entities/player3_heads.png
data/entities/player4_armor_body.png
data/entities/player4_heads.png
data/entities/skeleton_black.png
data/entities/skeleton.png
data/entities/skeleton_yellow.png
data/items/resource_hoard_gold_small.png
data/languages/brazilianportuguese/localization/characterselect_aria1.png
data/languages/brazilianportuguese/localization/characterselect_bard1.png
data/languages/brazilianportuguese/localization/characterselect_bolt1.png
data/languages/brazilianportuguese/localization/characterselect_deathless2.png
data/languages/brazilianportuguese/localization/characterselect_eli1.png
data/languages/brazilianportuguese/localization/characterselect_hint1.png
data/languages/brazilianportuguese/localization/characterselect_monk1.png
data/languages/brazilianportuguese/localization/characterselect_monk3.png
data/languages/brazilianportuguese/localization/characterselect_story2.png
data/languages/brazilianportuguese/localization/enemybig_shrineofpace.png
data/languages/brazilianportuguese/localization/enemy_chestmimic.png
data/languages/brazilianportuguese/localization/enemy_deadringer.png
data/languages/brazilianportuguese/localization/enemy_firecauldronmimic.png
data/languages/brazilianportuguese/localization/enemy_icecauldronmimic.png
data/languages/brazilianportuguese/localization/enemy_lockedchestmimic.png
data/languages/brazilianportuguese/localization/enemy_mommy.png
data/languages/brazilianportuguese/localization/enemy_shopkeeperghost.png
data/languages/brazilianportuguese/localization/enemy_shrineofpace.png
data/languages/brazilianportuguese/localization/enemy_whitechestmimic.png
data/languages/brazilianportuguese/localization/game_story2.png
data/languages/brazilianportuguese/localization/game_story3.png
data/languages/brazilianportuguese/localization/hint_1visiontrapsight.png
data/languages/brazilianportuguese/localization/hint_alreadycomplete.png
data/languages/brazilianportuguese/localization/hint_completemonk.png
data/languages/brazilianportuguese/localization/hint_enchantweapon2.png
data/languages/brazilianportuguese/localization/hint_exitunlocked.png
data/languages/brazilianportuguese/localization/hint_giveswhatyouneed.png
data/languages/brazilianportuguese/localization/hint_shrineofblood1.png
data/languages/brazilianportuguese/localization/hint_shrineofglass1.png
data/languages/brazilianportuguese/localization/hint_shrineofnoreturn2.png
data/languages/brazilianportuguese/localization/hint_shrineofpace1.png
data/languages/brazilianportuguese/localization/hint_shrineofphasing2.png
data/languages/brazilianportuguese/localization/hint_shrineofrhythm2.png
data/languages/brazilianportuguese/localization/hint_sloth.png
data/languages/brazilianportuguese/localization/item_balletshoes.png
data/languages/brazilianportuguese/localization/item_enchantweaponscroll.png
data/languages/brazilianportuguese/localization/item_glassshardshovel.png
data/languages/brazilianportuguese/localization/item_ringofmana.png
data/languages/brazilianportuguese/localization/leveleditor_dirtwall.png
data/languages/brazilianportuguese/localization/leveleditor_placecontainer.png
data/languages/brazilianportuguese/localization/leveleditor_saveandpublish.png
data/languages/brazilianportuguese/localization/leveleditor_shrineblood.png
data/languages/brazilianportuguese/localization/leveleditor_shrineglass.png
data/languages/brazilianportuguese/localization/leveleditor_shrinepace.png
data/languages/brazilianportuguese/localization/leveleditor_travelrune.png
data/languages/brazilianportuguese/localization/leveleditor_workshop.png
data/languages/brazilianportuguese/localization/lobby_allzones.png
data/languages/brazilianportuguese/localization/lobby_character.png
data/languages/brazilianportuguese/localization/lobby_dailychallenge3.png
data/languages/brazilianportuguese/localization/lobby_dancepad.png
data/languages/brazilianportuguese/localization/lobby_diamonddealerexplain2.png
data/languages/brazilianportuguese/localization/lobby_janitorexplain2.png
data/languages/brazilianportuguese/localization/lobby_modeeasier.png
data/languages/brazilianportuguese/localization/lobby_mode.png
data/languages/brazilianportuguese/localization/lobby_select.png
data/languages/brazilianportuguese/localization/options_buttonbig_joy1button.png
data/languages/brazilianportuguese/localization/options_buttonbig_joy2button.png
data/languages/brazilianportuguese/localization/options_buttonbig_joy3button.png
data/languages/brazilianportuguese/localization/options_buttonbig_joy4button.png
data/languages/brazilianportuguese/localization/options_button_joy1button.png
data/languages/brazilianportuguese/localization/options_button_joy2button.png
data/languages/brazilianportuguese/localization/options_button_joy3button.png
data/languages/brazilianportuguese/localization/options_button_joy4button.png
data/languages/brazilianportuguese/localization/options_random.png
data/languages/brazilianportuguese/localization/options_steamworkshop.png
data/languages/brazilianportuguese/localization/options_workshop.png
data/languages/brazilianportuguese/localization/selection/leveleditor_dirtwall.png
data/languages/brazilianportuguese/localization/selection/leveleditor_placecontainer.png
data/languages/brazilianportuguese/localization/selection/leveleditor_shrineblood.png
data/languages/brazilianportuguese/localization/selection/leveleditor_shrineglass.png
data/languages/brazilianportuguese/localization/selection/leveleditor_shrinepace.png
data/languages/brazilianportuguese/localization/selection/leveleditor_travelrune.png
data/languages/brazilianportuguese/localization/selection/options_button_joy1button.png
data/languages/brazilianportuguese/localization/selection/options_button_joy2button.png
data/languages/brazilianportuguese/localization/selection/options_button_joy3button.png
data/languages/brazilianportuguese/localization/selection/options_button_joy4button.png
data/languages/brazilianportuguese/localization/selection/options_leaderboardsscore.png
data/languages/brazilianportuguese/localization/selection/options_leaderboardsspeed.png
data/languages/brazilianportuguese/localization/selection/options_leaderboardsspeedseeded.png
data/languages/brazilianportuguese/localization/selection/options_random.png
data/languages/brazilianportuguese/localization/selection/options_steamworkshop.png
data/languages/brazilianportuguese/localization/training_cauldronmimic.png
data/languages/brazilianportuguese/localization/training_chestmimic.png
data/languages/brazilianportuguese/localization/training_hellhound.png
data/languages/brazilianportuguese/localization/training_mommy.png
data/languages/brazilianportuguese/localization.xml
data/languages/brazilianportuguese/subtitles.xml
data/languages/chinese/language_name.png
data/languages/chinese/localization/boss_kingcongasplash.png
data/languages/chinese/localization/characterselect_story2.png
data/languages/chinese/localization/custommusic_kingconga.png
data/languages/chinese/localization/enemybig_blooddrum.png
data/languages/chinese/localization/enemybig_bloodnightmare.png
data/languages/chinese/localization/enemybig_bloodshovel.png
data/languages/chinese/localization/enemybig_kingconga.png
data/languages/chinese/localization/enemybig_shrineofnoreturn.png
data/languages/chinese/localization/enemybig_shrineofpace.png
data/languages/chinese/localization/enemybig_shrineofrisk.png
data/languages/chinese/localization/enemy_blooddrum.png
data/languages/chinese/localization/enemy_bloodnightmare.png
data/languages/chinese/localization/enemy_bloodshovel.png
data/languages/chinese/localization/enemy_kingconga.png
data/languages/chinese/localization/enemy_shrineofnoreturn.png
data/languages/chinese/localization/enemy_shrineofpace.png
data/languages/chinese/localization/enemy_shrineofrisk.png
data/languages/chinese/localization/game_lowpercent.png
data/languages/chinese/localization/game_story2.png
data/languages/chinese/localization/game_story3.png
data/languages/chinese/localization/hint_charm.png
data/languages/chinese/localization/hint_charmshattered.png
data/languages/chinese/localization/hint_conicalblastneedsreloadingpiercing.png
data/languages/chinese/localization/hint_freezeenemieskillfrozenenemiespiercing.png
data/languages/chinese/localization/hint_helpswithsometerrain.png
data/languages/chinese/localization/hint_helpswithtrapsandice.png
data/languages/chinese/localization/hint_phasingattack2dmg.png
data/languages/chinese/localization/hint_rangedattackneedsloadingpiercing.png
data/languages/chinese/localization/hint_rangedattackneedsreloadingpiercing.png
data/languages/chinese/localization/hint_shrineofblood1.png
data/languages/chinese/localization/hint_shrineofchance1.png
data/languages/chinese/localization/hint_shrineofdarkness1.png
data/languages/chinese/localization/hint_shrineofglass1.png
data/languages/chinese/localization/hint_shrineofnoreturn1.png
data/languages/chinese/localization/hint_shrineofpace1.png
data/languages/chinese/localization/hint_shrineofpeace1.png
data/languages/chinese/localization/hint_shrineofphasing1.png
data/languages/chinese/localization/hint_shrineofrhythm1.png
data/languages/chinese/localization/hint_shrineofrisk1.png
data/languages/chinese/localization/hint_shrineofsacrifice1.png
data/languages/chinese/localization/hint_shrineofsacrifice2.png
data/languages/chinese/localization/hint_shrineofspace1.png
data/languages/chinese/localization/hint_shrineofwar1.png
data/languages/chinese/localization/hint_sloth.png
data/languages/chinese/localization/hint_thorn.png
data/languages/chinese/localization/item_bloodbow.png
data/languages/chinese/localization/item_bloodbroadsword.png
data/languages/chinese/localization/item_bloodcat.png
data/languages/chinese/localization/item_bloodcrossbow.png
data/languages/chinese/localization/item_blooddagger.png
data/languages/chinese/localization/item_blooddrum.png
data/languages/chinese/localization/item_bloodflail.png
data/languages/chinese/localization/item_bloodlongsword.png
data/languages/chinese/localization/item_bloodrapier.png
data/languages/chinese/localization/item_bloodshovel.png
data/languages/chinese/localization/item_bloodspear.png
data/languages/chinese/localization/item_bloodwhip.png
data/languages/chinese/localization/item_charmspell.png
data/languages/chinese/localization/item_daggerofphasing.png
data/languages/chinese/localization/item_drumstick.png
data/languages/chinese/localization/item_frostcharm.png
data/languages/chinese/localization/item_gluttonycharm.png
data/languages/chinese/localization/item_goldenbow.png
data/languages/chinese/localization/item_goldenbroadsword.png
data/languages/chinese/localization/item_goldencat.png
data/languages/chinese/localization/item_goldencrossbow.png
data/languages/chinese/localization/item_goldendagger.png
data/languages/chinese/localization/item_goldenflail.png
data/languages/chinese/localization/item_goldenlongsword.png
data/languages/chinese/localization/item_goldenrapier.png
data/languages/chinese/localization/item_goldenspear.png
data/languages/chinese/localization/item_goldenwhip.png
data/languages/chinese/localization/item_infernaltorch.png
data/languages/chinese/localization/item_luckycharm.png
data/languages/chinese/localization/item_nazarcharm.png
data/languages/chinese/localization/item_ringofmana.png
data/languages/chinese/localization/item_ringofphasing.png
data/languages/chinese/localization/item_ringofshielding.png
data/languages/chinese/localization/item_riskcharm.png
data/languages/chinese/localization/item_strengthcharm.png
data/languages/chinese/localization/item_titaniumbow.png
data/languages/chinese/localization/item_titaniumbroadsword.png
data/languages/chinese/localization/item_titaniumcat.png
data/languages/chinese/localization/item_titaniumcrossbow.png
data/languages/chinese/localization/item_titaniumdagger.png
data/languages/chinese/localization/item_titaniumflail.png
data/languages/chinese/localization/item_titaniumlongsword.png
data/languages/chinese/localization/item_titaniumrapier.png
data/languages/chinese/localization/item_titaniumshovel.png
data/languages/chinese/localization/item_titaniumspear.png
data/languages/chinese/localization/item_titaniumwhip.png
data/languages/chinese/localization/leaderboard_watch.png
data/languages/chinese/localization/leveleditor_kingconga.png
data/languages/chinese/localization/leveleditor_placeshrine.png
data/languages/chinese/localization/leveleditor_shopfloor.png
data/languages/chinese/localization/leveleditor_shopwall.png
data/languages/chinese/localization/leveleditor_shrineblood.png
data/languages/chinese/localization/leveleditor_shrinechance.png
data/languages/chinese/localization/leveleditor_shrinedarkness.png
data/languages/chinese/localization/leveleditor_shrineglass.png
data/languages/chinese/localization/leveleditor_shrinenoreturn.png
data/languages/chinese/localization/leveleditor_shrinepace.png
data/languages/chinese/localization/leveleditor_shrinepeace.png
data/languages/chinese/localization/leveleditor_shrinephasing.png
data/languages/chinese/localization/leveleditor_shrinerhythm.png
data/languages/chinese/localization/leveleditor_shrinerisk.png
data/languages/chinese/localization/leveleditor_shrinesacrifice.png
data/languages/chinese/localization/leveleditor_shrinespace.png
data/languages/chinese/localization/leveleditor_shrinewar.png
data/languages/chinese/localization/options_language.png
data/languages/chinese/localization/options_lowpercent.png
data/languages/chinese/localization/selection/custommusic_kingconga.png
data/languages/chinese/localization/selection/leaderboard_watch.png
data/languages/chinese/localization/selection/leveleditor_kingconga.png
data/languages/chinese/localization/selection/leveleditor_placeshrine.png
data/languages/chinese/localization/selection/leveleditor_shopfloor.png
data/languages/chinese/localization/selection/leveleditor_shopwall.png
data/languages/chinese/localization/selection/leveleditor_shrineblood.png
data/languages/chinese/localization/selection/leveleditor_shrinechance.png
data/languages/chinese/localization/selection/leveleditor_shrinedarkness.png
data/languages/chinese/localization/selection/leveleditor_shrineglass.png
data/languages/chinese/localization/selection/leveleditor_shrinenoreturn.png
data/languages/chinese/localization/selection/leveleditor_shrinepace.png
data/languages/chinese/localization/selection/leveleditor_shrinepeace.png
data/languages/chinese/localization/selection/leveleditor_shrinephasing.png
data/languages/chinese/localization/selection/leveleditor_shrinerhythm.png
data/languages/chinese/localization/selection/leveleditor_shrinerisk.png
data/languages/chinese/localization/selection/leveleditor_shrinesacrifice.png
data/languages/chinese/localization/selection/leveleditor_shrinespace.png
data/languages/chinese/localization/selection/leveleditor_shrinewar.png
data/languages/chinese/localization/selection/options_language.png
data/languages/chinese/localization/shop_shriner.png
data/languages/chinese/localization/training_bloodnightmare.png
data/languages/chinese/localization/training_kingconga1.png
data/languages/chinese/localization/training_kingconga2.png
data/languages/chinese/localization/training_kingconga3.png
data/languages/chinese/localization/training_kingconga4.png
data/languages/chinese/localization.xml
data/languages/chinesesimplified/language_name.png
data/languages/chinesesimplified/localization/characterbig_mage.png
data/languages/chinesesimplified/localization/character_mage.png
data/languages/chinesesimplified/localization/lobby_diamonddealerexplain2.png
data/languages/chinesesimplified/localization/lobby_janitorexplain1.png
data/languages/chinesesimplified/localization/lobby_janitorexplain2.png
data/languages/chinesesimplified/localization/options_language.png
data/languages/chinesesimplified/localization/selection/options_language.png
data/languages/chinesesimplified/localization.xml
data/languages/chinesesimplified/subtitles.xml
data/languages/chinese/subtitles.xml
data/languages/english/subtitles.xml
data/languages/example/localization.xml
data/languages/french/localization/characterselect_hint2.png
data/languages/french/localization/characterselect_story2.png
data/languages/french/localization/game_scoresubmitting.png
data/languages/french/localization/game_story2.png
data/languages/french/localization/game_story3.png
data/languages/french/localization/hint_4damagebreakable.png
data/languages/french/localization/hint_doubletime.png
data/languages/french/localization/hint_shrineofnoreturn2.png
data/languages/french/localization/item_bloodlongsword.png
data/languages/french/localization/item_glasslongsword.png
data/languages/french/localization/item_goldenlongsword.png
data/languages/french/localization/item_longsword.png
data/languages/french/localization/item_obsidianlongsword.png
data/languages/french/localization/item_titaniumlongsword.png
data/languages/french/localization/leaderboard_watch.png
data/languages/french/localization/lobby_codexexplain.png
data/languages/french/localization/lobby_janitorclean1.png
data/languages/french/localization/lobby_janitorclean2.png
data/languages/french/localization/options_cutscenes.png
data/languages/french/localization/options_modchooseplay.png
data/languages/french/localization/options_modchoosepublish.png
data/languages/french/localization/options_moddeactivate.png
data/languages/french/localization/options_moddefault.png
data/languages/french/localization/options_moderror2.png
data/languages/french/localization/options_moderror3.png
data/languages/french/localization/options_modplay.png
data/languages/french/localization/options_modpublished.png
data/languages/french/localization/options_modpublishfail.png
data/languages/french/localization/options_modpublish.png
data/languages/french/localization/options_mods.png
data/languages/french/localization/options_modwarning1.png
data/languages/french/localization/options_modwarning2.png
data/languages/french/localization/options_prebosseffect.png
data/languages/french/localization/options_workshop.png
data/languages/french/localization/selection/leaderboard_watch.png
data/languages/french/localization/selection/options_cutscenes.png
data/languages/french/localization/selection/options_modchooseplay.png
data/languages/french/localization/selection/options_modchoosepublish.png
data/languages/french/localization/selection/options_moddeactivate.png
data/languages/french/localization/selection/options_moddefault.png
data/languages/french/localization/selection/options_modplay.png
data/languages/french/localization/selection/options_modpublish.png
data/languages/french/localization/selection/options_mods.png
data/languages/french/localization/selection/options_prebosseffect.png
data/languages/french/localization/shop_transmog.png
data/languages/french/localization.xml
data/languages/french/subtitles.xml
data/languages/german/localization/characterselect_bard1.png
data/languages/german/localization/characterselect_coda2.png
data/languages/german/localization/characterselect_story2.png
data/languages/german/localization/enemybig_magicmonkey.png
data/languages/german/localization/enemybig_mommy.png
data/languages/german/localization/enemybig_necrodancer.png
data/languages/german/localization/enemy_magicmonkey.png
data/languages/german/localization/enemy_mommy.png
data/languages/german/localization/enemy_necrodancer.png
data/languages/german/localization/game_daily2.png
data/languages/german/localization/game_dancepad1.png
data/languages/german/localization/game_randomseed.png
data/languages/german/localization/game_story2.png
data/languages/german/localization/game_story3.png
data/languages/german/localization/hint_1dmgstrangevision.png
data/languages/german/localization/hint_1visiontrapsight.png
data/languages/german/localization/hint_completecadence.png
data/languages/german/localization/hint_completemelody.png
data/languages/german/localization/hint_completemonk.png
data/languages/german/localization/hint_completezone4cadence.png
data/languages/german/localization/hint_conjuringfail.png
data/languages/german/localization/hint_doubletime.png
data/languages/german/localization/hint_freezeenemieskillfrozenenemiespiercing.png
data/languages/german/localization/hint_goldenkeybuy.png
data/languages/german/localization/hint_shrineofrhythm2.png
data/languages/german/localization/hint_takeshealthincreasesdamage.png
data/languages/german/localization/hint_transformnearbyitems.png
data/languages/german/localization/item_frostcharm.png
data/languages/german/localization/item_glassjaw.png
data/languages/german/localization/item_leadboots.png
data/languages/german/localization/item_luckycharm.png
data/languages/german/localization/item_protectioncharm.png
data/languages/german/localization/item_riskcharm.png
data/languages/german/localization/item_strengthcharm.png
data/languages/german/localization/leaderboard_allzones_speedrun.png
data/languages/german/localization/leveleditor_generate.png
data/languages/german/localization/leveleditor_generatewarning1.png
data/languages/german/localization/leveleditor_levelgen.png
data/languages/german/localization/lobby_bossselection1.png
data/languages/german/localization/lobby_bosstraining3.png
data/languages/german/localization/lobby_enterseed2.png
data/languages/german/localization/lobby_itemhints3.png
data/languages/german/localization/lobby_minibosstraining1.png
data/languages/german/localization/lobby_minibosstraining3.png
data/languages/german/localization/lobby_weaponmasterhint.png
data/languages/german/localization/options_beatdetectionongoing.png
data/languages/german/localization/options_currentresolution.png
data/languages/german/localization/options_cutscenes.png
data/languages/german/localization/options_deletewarning1.png
data/languages/german/localization/options_modwarning2.png
data/languages/german/localization/selection/leveleditor_generate.png
data/languages/german/localization/selection/leveleditor_levelgen.png
data/languages/german/localization/selection/lobby_leavelosediamonds.png
data/languages/german/localization/selection/options_cutscenes.png
data/languages/german/localization/training_magicmonkey1.png
data/languages/german/localization.xml
data/languages/german/subtitles.xml
data/languages/italian/localization/characterselect_story2.png
data/languages/italian/localization/game_story2.png
data/languages/italian/localization/game_story3.png
data/languages/italian/localization.xml
data/languages/italian/subtitles.xml
data/languages/japanese/localization/characterselect_story2.png
data/languages/japanese/localization/game_story2.png
data/languages/japanese/localization/game_story3.png
data/languages/japanese/localization.xml
data/languages/japanese/subtitles.xml
data/languages/korean/localization/boss_kingcongasplash.png
data/languages/korean/localization/characterbig_eli.png
data/languages/korean/localization/characterbig_monk.png
data/languages/korean/localization/character_eli.png
data/languages/korean/localization/character_monk.png
data/languages/korean/localization/characterselect_aria3.png
data/languages/korean/localization/characterselect_cadence1.png
data/languages/korean/localization/characterselect_coda2.png
data/languages/korean/localization/characterselect_deathless1.png
data/languages/korean/localization/characterselect_deathless.png
data/languages/korean/localization/characterselect_dove2.png
data/languages/korean/localization/characterselect_eli1.png
data/languages/korean/localization/characterselect_hint1.png
data/languages/korean/localization/characterselect_monk1.png
data/languages/korean/localization/characterselect_story2.png
data/languages/korean/localization/character_unlockmelody1.png
data/languages/korean/localization/custommusic_1-2xspeed.png
data/languages/korean/localization/custommusic_2xspeed.png
data/languages/korean/localization/custommusic_kingconga.png
data/languages/korean/localization/custommusic_manualbeatslobby.png
data/languages/korean/localization/custommusic_manualbeats.png
data/languages/korean/localization/enemy_barrel.png
data/languages/korean/localization/enemybig_apprenticeblademaster.png
data/languages/korean/localization/enemybig_barrel.png
data/languages/korean/localization/enemybig_bishop.png
data/languages/korean/localization/enemybig_blackarmoredskeleton.png
data/languages/korean/localization/enemybig_blackbat.png
data/languages/korean/localization/enemybig_blacklich.png
data/languages/korean/localization/enemybig_blacksarcophagus.png
data/languages/korean/localization/enemybig_blackskeletonknight.png
data/languages/korean/localization/enemybig_blackskeletonmage.png
data/languages/korean/localization/enemybig_blackskeleton.png
data/languages/korean/localization/enemybig_bluebanshee.png
data/languages/korean/localization/enemybig_bluebat.png
data/languages/korean/localization/enemybig_bluedragon.png
data/languages/korean/localization/enemybig_bluemushroom.png
data/languages/korean/localization/enemybig_blueslime.png
data/languages/korean/localization/enemybig_bootsofpain.png
data/languages/korean/localization/enemybig_browndirebat.png
data/languages/korean/localization/enemybig_firebeetle.png
data/languages/korean/localization/enemybig_firecauldronmimic.png
data/languages/korean/localization/enemybig_goblinbomber.png
data/languages/korean/localization/enemybig_grayshovemonster.png
data/languages/korean/localization/enemybig_greenbanshee.png
data/languages/korean/localization/enemybig_greenbat.png
data/languages/korean/localization/enemybig_greendragon.png
data/languages/korean/localization/enemybig_greenmonkey.png
data/languages/korean/localization/enemybig_greenslime.png
data/languages/korean/localization/enemybig_icebeetle.png
data/languages/korean/localization/enemybig_icecauldronmimic.png
data/languages/korean/localization/enemybig_kingconga.png
data/languages/korean/localization/enemybig_leprechaun.png
data/languages/korean/localization/enemybig_missedbeat.png
data/languages/korean/localization/enemybig_mommy.png
data/languages/korean/localization/enemybig_monstrousshopkeeper.png
data/languages/korean/localization/enemybig_neonwarlock.png
data/languages/korean/localization/enemybig_ogre.png
data/languages/korean/localization/enemybig_redbat.png
data/languages/korean/localization/enemybig_redbishop.png
data/languages/korean/localization/enemybig_reddragon.png
data/languages/korean/localization/enemybig_redking.png
data/languages/korean/localization/enemybig_redknight.png
data/languages/korean/localization/enemybig_redlich.png
data/languages/korean/localization/enemybig_redpawn.png
data/languages/korean/localization/enemybig_redqueen.png
data/languages/korean/localization/enemybig_redrook.png
data/languages/korean/localization/enemybig_shopkeeperghost.png
data/languages/korean/localization/enemybig_shopkeeper.png
data/languages/korean/localization/enemybig_shovemonster.png
data/languages/korean/localization/enemybig_shove.png
data/languages/korean/localization/enemybig_shrineofnoreturn.png
data/languages/korean/localization/enemybig_shrineofpace.png
data/languages/korean/localization/enemybig_shrineofrisk.png
data/languages/korean/localization/enemybig_spider.png
data/languages/korean/localization/enemybig_spiketrap.png
data/languages/korean/localization/enemybig_tarmonster.png
data/languages/korean/localization/enemybig_tentacle.png
data/languages/korean/localization/enemybig_warlock.png
data/languages/korean/localization/enemybig_whitearmadillo.png
data/languages/korean/localization/enemybig_whitearmoredskeleton.png
data/languages/korean/localization/enemybig_whitechestmimic.png
data/languages/korean/localization/enemybig_whitemonkey.png
data/languages/korean/localization/enemybig_whiteskeletonknight.png
data/languages/korean/localization/enemybig_whiteskeletonmage.png
data/languages/korean/localization/enemybig_whiteskeleton.png
data/languages/korean/localization/enemybig_yellowarmadillo.png
data/languages/korean/localization/enemybig_yellowarmoredskeleton.png
data/languages/korean/localization/enemybig_yellowdirebat.png
data/languages/korean/localization/enemybig_yellowsarcophagus.png
data/languages/korean/localization/enemybig_yellowskeletonknight.png
data/languages/korean/localization/enemybig_yellowskeletonmage.png
data/languages/korean/localization/enemybig_yellowskeleton.png
data/languages/korean/localization/enemy_blackarmoredskeleton.png
data/languages/korean/localization/enemy_blackbat.png
data/languages/korean/localization/enemy_blacklich.png
data/languages/korean/localization/enemy_blacksarcophagus.png
data/languages/korean/localization/enemy_blackskeletonknight.png
data/languages/korean/localization/enemy_blackskeletonmage.png
data/languages/korean/localization/enemy_blackskeleton.png
data/languages/korean/localization/enemy_bluebanshee.png
data/languages/korean/localization/enemy_bluebat.png
data/languages/korean/localization/enemy_bluedragon.png
data/languages/korean/localization/enemy_bluemushroom.png
data/languages/korean/localization/enemy_blueslime.png
data/languages/korean/localization/enemy_browndirebat.png
data/languages/korean/localization/enemy_firebeetle.png
data/languages/korean/localization/enemy_firecauldronmimic.png
data/languages/korean/localization/enemy_grayshovemonster.png
data/languages/korean/localization/enemy_greenbanshee.png
data/languages/korean/localization/enemy_greenbat.png
data/languages/korean/localization/enemy_greendragon.png
data/languages/korean/localization/enemy_greenmonkey.png
data/languages/korean/localization/enemy_greenslime.png
data/languages/korean/localization/enemy_icecauldronmimic.png
data/languages/korean/localization/enemy_kingconga.png
data/languages/korean/localization/enemy_leprechaun.png
data/languages/korean/localization/enemy_missedbeat.png
data/languages/korean/localization/enemy_monstrousshopkeeper.png
data/languages/korean/localization/enemy_ogre.png
data/languages/korean/localization/enemy_oozegolem.png
data/languages/korean/localization/enemy_redbat.png
data/languages/korean/localization/enemy_redbishop.png
data/languages/korean/localization/enemy_reddragon.png
data/languages/korean/localization/enemy_redking.png
data/languages/korean/localization/enemy_redknight.png
data/languages/korean/localization/enemy_redlich.png
data/languages/korean/localization/enemy_redpawn.png
data/languages/korean/localization/enemy_redqueen.png
data/languages/korean/localization/enemy_redrook.png
data/languages/korean/localization/enemy_shovemonster.png
data/languages/korean/localization/enemy_shove.png
data/languages/korean/localization/enemy_shrineofnoreturn.png
data/languages/korean/localization/enemy_shrineofpace.png
data/languages/korean/localization/enemy_shrineofrisk.png
data/languages/korean/localization/enemy_tarmonster.png
data/languages/korean/localization/enemy_whitearmadillo.png
data/languages/korean/localization/enemy_whitearmoredskeleton.png
data/languages/korean/localization/enemy_whitechestmimic.png
data/languages/korean/localization/enemy_whitemonkey.png
data/languages/korean/localization/enemy_whiteskeletonknight.png
data/languages/korean/localization/enemy_whiteskeletonmage.png
data/languages/korean/localization/enemy_whiteskeleton.png
data/languages/korean/localization/enemy_yellowarmadillo.png
data/languages/korean/localization/enemy_yellowarmoredskeleton.png
data/languages/korean/localization/enemy_yellowdirebat.png
data/languages/korean/localization/enemy_yellowsarcophagus.png
data/languages/korean/localization/enemy_yellowskeletonknight.png
data/languages/korean/localization/enemy_yellowskeletonmage.png
data/languages/korean/localization/enemy_yellowskeleton.png
data/languages/korean/localization/game_coinmultiplierlost.png
data/languages/korean/localization/game_death1.png
data/languages/korean/localization/game_deathless1.png
data/languages/korean/localization/game_loading.png
data/languages/korean/localization/game_speedleaderboards.png
data/languages/korean/localization/game_speedrun.png
data/languages/korean/localization/game_story2.png
data/languages/korean/localization/game_story3.png
data/languages/korean/localization/hint_10killsheal.png
data/languages/korean/localization/hint_1dmgkilldash.png
data/languages/korean/localization/hint_1dmgmoreenemies.png
data/languages/korean/localization/hint_1dmgstrangevision.png
data/languages/korean/localization/hint_1heartfewerenemies.png
data/languages/korean/localization/hint_1visiontrapsight.png
data/languages/korean/localization/hint_2defenseheavy.png
data/languages/korean/localization/hint_2dmgatlowhealth.png
data/languages/korean/localization/hint_bombimmunity3bombs.png
data/languages/korean/localization/hint_brokerreject.png
data/languages/korean/localization/hint_chancelose.png
data/languages/korean/localization/hint_cheapershops.png
data/languages/korean/localization/hint_completebomblore.png
data/languages/korean/localization/hint_completecadence.png
data/languages/korean/localization/hint_completedragonlore.png
data/languages/korean/localization/hint_completemonk.png
data/languages/korean/localization/hint_completetraplore.png
data/languages/korean/localization/hint_completezone4cadence.png
data/languages/korean/localization/hint_conicalblastneedsreloadingpiercing.png
data/languages/korean/localization/hint_damageenemies.png
data/languages/korean/localization/hint_diganythingbuttakedamage.png
data/languages/korean/localization/hint_dodamageasyouwalk.png
data/languages/korean/localization/hint_gold.png
data/languages/korean/localization/hint_helpswithsometerrain.png
data/languages/korean/localization/hint_helpswithtrapsandice.png
data/languages/korean/localization/hint_horizontalfireblast2.png
data/languages/korean/localization/hint_horizontalfireblast.png
data/languages/korean/localization/hint_immune.png
data/languages/korean/localization/hint_longjumpattack.png
data/languages/korean/localization/hint_longjump.png
data/languages/korean/localization/hint_moveandattack.png
data/languages/korean/localization/hint_oldweaponholstered.png
data/languages/korean/localization/hint_opencage.png
data/languages/korean/localization/hint_opencagewithglasslock.png
data/languages/korean/localization/hint_opencagewithgoldenlock.png
data/languages/korean/localization/hint_rewardsovereatingonce.png
data/languages/korean/localization/hint_shoppingspree.png
data/languages/korean/localization/hint_shrineofblood1.png
data/languages/korean/localization/hint_shrineofchance1.png
data/languages/korean/localization/hint_shrineofdarkness1.png
data/languages/korean/localization/hint_shrineofglass1.png
data/languages/korean/localization/hint_shrineofnoreturn1.png
data/languages/korean/localization/hint_shrineofnoreturn2.png
data/languages/korean/localization/hint_shrineofpace1.png
data/languages/korean/localization/hint_shrineofpace2.png
data/languages/korean/localization/hint_shrineofpeace1.png
data/languages/korean/localization/hint_shrineofphasing1.png
data/languages/korean/localization/hint_shrineofrhythm1.png
data/languages/korean/localization/hint_shrineofrhythm2.png
data/languages/korean/localization/hint_shrineofrisk1.png
data/languages/korean/localization/hint_shrineofsacrifice1.png
data/languages/korean/localization/hint_shrineofsacrifice2.png
data/languages/korean/localization/hint_shrineofspace1.png
data/languages/korean/localization/hint_shrineofwar1.png
data/languages/korean/localization/hint_sloth.png
data/languages/korean/localization/hint_standstillincreasedamage.png
data/languages/korean/localization/hint_tempotrapdown.png
data/languages/korean/localization/hint_tempotrapup.png
data/languages/korean/localization/hud_0-5heart.png
data/languages/korean/localization/hud_1-5hearts.png
data/languages/korean/localization/hud_1heart.png
data/languages/korean/localization/hud_1kill.png
data/languages/korean/localization/hud_kills.png
data/languages/korean/localization/item_10diamonds.png
data/languages/korean/localization/item_15diamonds.png
data/languages/korean/localization/item_20diamonds.png
data/languages/korean/localization/item_2diamonds.png
data/languages/korean/localization/item_3bombs.png
data/languages/korean/localization/item_3diamonds.png
data/languages/korean/localization/item_4diamonds.png
data/languages/korean/localization/item_5diamonds.png
data/languages/korean/localization/item_additionalblackchest.png
data/languages/korean/localization/item_additionalredchest.png
data/languages/korean/localization/item_blasthelm.png
data/languages/korean/localization/item_bloodbroadsword.png
data/languages/korean/localization/item_bloodcrossbow.png
data/languages/korean/localization/item_bloodlongsword.png
data/languages/korean/localization/item_bootsofleaping.png
data/languages/korean/localization/item_bootsoflunging.png
data/languages/korean/localization/item_broadsword.png
data/languages/korean/localization/item_cat.png
data/languages/korean/localization/item_crossbow.png
data/languages/korean/localization/item_daggeroffrost.png
data/languages/korean/localization/item_earthquakescroll.png
data/languages/korean/localization/item_enchantweaponscroll.png
data/languages/korean/localization/item_explorersboots.png
data/languages/korean/localization/item_fearscroll.png
data/languages/korean/localization/item_fireballscroll.png
data/languages/korean/localization/item_freezescroll.png
data/languages/korean/localization/item_gigantismscroll.png
data/languages/korean/localization/item_glassbroadsword.png
data/languages/korean/localization/item_glasscrossbow.png
data/languages/korean/localization/item_glasslongsword.png
data/languages/korean/localization/item_goldenbroadsword.png
data/languages/korean/localization/item_goldencrossbow.png
data/languages/korean/localization/item_goldenlongsword.png
data/languages/korean/localization/item_heavyplate.png
data/languages/korean/localization/item_karategi.png
data/languages/korean/localization/item_leadboots.png
data/languages/korean/localization/item_longsword.png
data/languages/korean/localization/item_obsidianbroadsword.png
data/languages/korean/localization/item_obsidiancrossbow.png
data/languages/korean/localization/item_obsidianlongsword.png
data/languages/korean/localization/item_richesscroll.png
data/languages/korean/localization/item_rifle.png
data/languages/korean/localization/item_scrollofneed.png
data/languages/korean/localization/item_shieldscroll.png
data/languages/korean/localization/item_titaniumbroadsword.png
data/languages/korean/localization/item_titaniumcrossbow.png
data/languages/korean/localization/item_titaniumlongsword.png
data/languages/korean/localization/item_transmutescroll.png
data/languages/korean/localization/item_wingedboots.png
data/languages/korean/localization/leaderboard_allzones_speedrun.png
data/languages/korean/localization/leaderboard_allzones_speedrun_seeded.png
data/languages/korean/localization/leaderboard_deathless.png
data/languages/korean/localization/leaderboard_loading.png
data/languages/korean/localization/leveleditor_catacombwall.png
data/languages/korean/localization/leveleditor_headgear.png
data/languages/korean/localization/leveleditor_kingconga.png
data/languages/korean/localization/leveleditor_ooze.png
data/languages/korean/localization/leveleditor_placecontainer.png
data/languages/korean/localization/leveleditor_placeshrine.png
data/languages/korean/localization/leveleditor_shrineblood.png
data/languages/korean/localization/leveleditor_shrinechance.png
data/languages/korean/localization/leveleditor_shrinedarkness.png
data/languages/korean/localization/leveleditor_shrineglass.png
data/languages/korean/localization/leveleditor_shrinenoreturn.png
data/languages/korean/localization/leveleditor_shrinepace.png
data/languages/korean/localization/leveleditor_shrinepeace.png
data/languages/korean/localization/leveleditor_shrinephasing.png
data/languages/korean/localization/leveleditor_shrinerhythm.png
data/languages/korean/localization/leveleditor_shrinerisk.png
data/languages/korean/localization/leveleditor_shrinesacrifice.png
data/languages/korean/localization/leveleditor_shrinespace.png
data/languages/korean/localization/leveleditor_shrinewar.png
data/languages/korean/localization/leveleditor_spiketrap.png
data/languages/korean/localization/leveleditor_travelrune.png
data/languages/korean/localization/leveleditor_zone3cold.png
data/languages/korean/localization/leveleditor_zone3hot.png
data/languages/korean/localization/lobby_bomblore.png
data/languages/korean/localization/lobby_diamonddealerexplain1.png
data/languages/korean/localization/lobby_diamonddealerexplain2.png
data/languages/korean/localization/lobby_dragonlore.png
data/languages/korean/localization/lobby_howtogetaway.png
data/languages/korean/localization/lobby_janitorexplain1.png
data/languages/korean/localization/lobby_janitorexplain2.png
data/languages/korean/localization/lobby_traplore.png
data/languages/korean/localization/lobby_unspent1.png
data/languages/korean/localization/lobby_unspentdiamonds1.png
data/languages/korean/localization/lobby_weaponblood.png
data/languages/korean/localization/lobby_withmurder.png
data/languages/korean/localization/options_beatdetectionongoing.png
data/languages/korean/localization/options_cutscenes.png
data/languages/korean/localization/options_enemyhearts.png
data/languages/korean/localization/options_latencybeat.png
data/languages/korean/localization/options_leaderboardsdeathless.png
data/languages/korean/localization/options_leaderboardsspeedseeded.png
data/languages/korean/localization/selection/character_eli.png
data/languages/korean/localization/selection/character_monk.png
data/languages/korean/localization/selection/custommusic_1-2xspeed.png
data/languages/korean/localization/selection/custommusic_2xspeed.png
data/languages/korean/localization/selection/custommusic_kingconga.png
data/languages/korean/localization/selection/custommusic_manualbeatslobby.png
data/languages/korean/localization/selection/custommusic_manualbeats.png
data/languages/korean/localization/selection/game_speedleaderboards.png
data/languages/korean/localization/selection/leveleditor_catacombwall.png
data/languages/korean/localization/selection/leveleditor_headgear.png
data/languages/korean/localization/selection/leveleditor_kingconga.png
data/languages/korean/localization/selection/leveleditor_ooze.png
data/languages/korean/localization/selection/leveleditor_placecontainer.png
data/languages/korean/localization/selection/leveleditor_placeshrine.png
data/languages/korean/localization/selection/leveleditor_shrineblood.png
data/languages/korean/localization/selection/leveleditor_shrinechance.png
data/languages/korean/localization/selection/leveleditor_shrinedarkness.png
data/languages/korean/localization/selection/leveleditor_shrineglass.png
data/languages/korean/localization/selection/leveleditor_shrinenoreturn.png
data/languages/korean/localization/selection/leveleditor_shrinepace.png
data/languages/korean/localization/selection/leveleditor_shrinepeace.png
data/languages/korean/localization/selection/leveleditor_shrinephasing.png
data/languages/korean/localization/selection/leveleditor_shrinerhythm.png
data/languages/korean/localization/selection/leveleditor_shrinerisk.png
data/languages/korean/localization/selection/leveleditor_shrinesacrifice.png
data/languages/korean/localization/selection/leveleditor_shrinespace.png
data/languages/korean/localization/selection/leveleditor_shrinewar.png
data/languages/korean/localization/selection/leveleditor_spiketrap.png
data/languages/korean/localization/selection/leveleditor_travelrune.png
data/languages/korean/localization/selection/leveleditor_zone3cold.png
data/languages/korean/localization/selection/leveleditor_zone3hot.png
data/languages/korean/localization/selection/options_cutscenes.png
data/languages/korean/localization/selection/options_enemyhearts.png
data/languages/korean/localization/selection/options_leaderboardsdeathless.png
data/languages/korean/localization/selection/options_leaderboardsspeedseeded.png
data/languages/korean/localization/shop_shriner.png
data/languages/korean/localization/training_armoredskeleton1.png
data/languages/korean/localization/training_blackarmoredskeleton1.png
data/languages/korean/localization/training_blackbat.png
data/languages/korean/localization/training_blacklich.png
data/languages/korean/localization/training_blacksarcophagus1.png
data/languages/korean/localization/training_blackskeletonknight1.png
data/languages/korean/localization/training_blackskeletonmage1.png
data/languages/korean/localization/training_blackskeleton.png
data/languages/korean/localization/training_bluedragon.png
data/languages/korean/localization/training_blueslime.png
data/languages/korean/localization/training_cauldronmimic.png
data/languages/korean/localization/training_direbat.png
data/languages/korean/localization/training_firebeetle.png
data/languages/korean/localization/training_graydirebat.png
data/languages/korean/localization/training_grayshovemonster2.png
data/languages/korean/localization/training_greenbanshee1.png
data/languages/korean/localization/training_greenbat.png
data/languages/korean/localization/training_greendragon.png
data/languages/korean/localization/training_greenmonkey1.png
data/languages/korean/localization/training_greenslime.png
data/languages/korean/localization/training_neonwarlock.png
data/languages/korean/localization/training_ogre.png
data/languages/korean/localization/training_oozegolem.png
data/languages/korean/localization/training_redbat.png
data/languages/korean/localization/training_reddragon.png
data/languages/korean/localization/training_redlich.png
data/languages/korean/localization/training_shovemonster.png
data/languages/korean/localization/training_tarmonster.png
data/languages/korean/localization/training_whitemonkey.png
data/languages/korean/localization/training_yellowarmadillo.png
data/languages/korean/localization/training_yellowarmoredskeleton1.png
data/languages/korean/localization/training_yellowsarcophagus1.png
data/languages/korean/localization/training_yellowskeletonknight1.png
data/languages/korean/localization/training_yellowskeletonmage1.png
data/languages/korean/localization/training_yellowskeleton.png
data/languages/korean/localization.xml
data/languages/korean/subtitles.xml
data/languages/russian/localization/characterselect_story2.png
data/languages/russian/localization/game_story2.png
data/languages/russian/localization/game_story3.png
data/languages/russian/localization.xml
data/languages/russian/subtitles.xml
data/languages/spanish/localization/characterselect_story2.png
data/languages/spanish/localization/game_story2.png
data/languages/spanish/localization/game_story3.png
data/languages/spanish/localization.xml
data/languages/spanish/subtitles.xml
data/music/boss_1_2.ogg
data/music/boss_2_2.ogg
data/music/boss_3_2.ogg
data/music/boss_4_2.ogg
data/music/credits_1.ogg
data/music/credits_2.ogg
data/music/credits_3.ogg
data/music/credits_4.ogg
data/music/lobby_2.ogg
data/music/zone1_1_2.ogg
data/music/zone1_2_2.ogg
data/music/zone1_3_2.ogg
data/music/zone2_1_2.ogg
data/music/zone2_2_2.ogg
data/music/zone2_3_2.ogg
data/music/zone3_1_2c.ogg
data/music/zone3_1_2h.ogg
data/music/zone3_2_2c.ogg
data/music/zone3_2_2h.ogg
data/music/zone3_3_2c.ogg
data/music/zone3_3_2h.ogg
data/music/zone4_1_2.ogg
data/music/zone4_2_2.ogg
data/music/zone4_3_2.ogg
data/necrodancer.xml
data/sounds.xml
data/video/credits_1.ogv
data/video/credits_2.ogv
data/video/credits_3.ogv
data/video/credits_4.ogv'
CONTENT_GAME_MAIN_FILES='
data'

PACKAGES_LIST='
PKG_DATA_COMMON
PKG_MAIN'

PKG_DATA_COMMON_ID="${GAME_ID}-data-common"
PKG_DATA_COMMON_ID_AMPLIFIED="${PKG_DATA_COMMON_ID}-${EXPANSION_ID_AMPLIFIED}"
PKG_DATA_COMMON_PROVIDES="
$PKG_DATA_COMMON_ID"
PKG_DATA_COMMON_DESCRIPTION='data - common files between base game and expansion'

PKG_MAIN_DEPS="$PKG_DATA_COMMON_ID_AMPLIFIED $GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
