/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.compression;

import com.google.protobuf.GeneratedMessage;
import edu.cornell.med.icb.goby.compression.ChunkCodecHelper;
import edu.cornell.med.icb.goby.compression.MessageChunksReader;
import edu.cornell.med.icb.goby.exception.GobyRuntimeException;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastBufferedMessageChunksReader
extends MessageChunksReader {
    private static final Log LOG = LogFactory.getLog(FastBufferedMessageChunksReader.class);
    private final FastBufferedInputStream input;
    private final long startOffset;
    private final long endOffset;
    private ByteSet supportedCodecRegistrationCodes;
    private boolean withinSlice = true;
    byte lastCodecCodeSeen = 0;

    public FastBufferedMessageChunksReader(long start, long end, FastBufferedInputStream input) throws IOException {
        if (start < 0L) {
            throw new IllegalArgumentException("Start position (" + start + ") must not be less than zero");
        }
        if (end != Long.MAX_VALUE && end < 0L) {
            throw new IllegalArgumentException("End position (" + end + ") must not be less than zero");
        }
        if (start > end) {
            throw new IllegalArgumentException("Start position (" + start + ") must not be greater than the end position (" + end + ")");
        }
        if (end != Long.MAX_VALUE && start != end) {
            end += 11L;
        }
        this.startOffset = start;
        this.endOffset = end;
        this.input = input;
        this.in = new DataInputStream(input);
        this.supportedCodecRegistrationCodes = ChunkCodecHelper.registrationCodes();
        this.reposition(start, end);
    }

    private void reposition(long start, long end) throws IOException {
        int b;
        assert (end >= start) : "end must be larger than start ";
        if (start == 0L && this.input.position() == 0L) {
            return;
        }
        this.input.position(start);
        if (this.input.position() != start) {
            this.withinSlice = false;
            return;
        }
        this.in = new DataInputStream(this.input);
        int contiguousDelimiterBytes = 0;
        long skipped = 0L;
        long position = 0L;
        this.withinSlice = true;
        boolean codecSeen = false;
        while ((b = this.in.read()) != -1 && this.input.position() < end) {
            byte c = (byte)b;
            if (!codecSeen && this.hasValidCodecCode(c)) {
                ++skipped;
                ++contiguousDelimiterBytes;
                codecSeen = true;
                continue;
            }
            if (codecSeen && c == -1) {
                ++contiguousDelimiterBytes;
            } else {
                if (contiguousDelimiterBytes == 8) {
                    this.chunkCodec = ChunkCodecHelper.withRegistrationCode(this.lastCodecCodeSeen);
                    long positionBeforeValidation = this.input.position();
                    if (!this.chunkCodec.validate(c, this.in)) {
                        LOG.warn(String.format("Found spurious boundary around position %d ", this.input.position()));
                        contiguousDelimiterBytes = 0;
                        this.chunkCodec = null;
                        this.lastCodecCodeSeen = 0;
                        codecSeen = true;
                        continue;
                    }
                    long newPosition = positionBeforeValidation - 9L;
                    this.input.position(newPosition);
                    return;
                }
                if (skipped > 8L) {
                    contiguousDelimiterBytes = 0;
                    codecSeen = false;
                }
            }
            ++skipped;
        }
        if (b == -1 || this.input.position() >= end) {
            this.withinSlice = false;
        }
        position = start + skipped;
        this.streamPositionAtStart = this.input.position();
    }

    private boolean hasValidCodecCode(byte registrationCode) throws IOException {
        if (this.supportedCodecRegistrationCodes.contains(registrationCode)) {
            this.lastCodecCodeSeen = registrationCode;
            return true;
        }
        return false;
    }

    public void seek(long position) throws IOException {
        this.input.flush();
        this.reposition(position, Long.MAX_VALUE);
        this.compressedBytes = null;
    }

    @Override
    public boolean hasNext(GeneratedMessage collection, int collectionSize) {
        if (collection == null || this.entryIndex >= collectionSize) {
            if (this.input != null) {
                try {
                    long position = this.input.position();
                    if (position < this.startOffset || position >= this.endOffset) {
                        this.withinSlice = false;
                        return false;
                    }
                }
                catch (IOException e) {
                    throw new GobyRuntimeException(e);
                }
            }
            return this.withinSlice && this.in != null && super.hasNext(collection, collectionSize);
        }
        this.compressedBytes = null;
        return this.entryIndex < collectionSize;
    }

    @Override
    public void close() {
        super.close();
        IOUtils.closeQuietly((InputStream)this.input);
    }

    @Override
    public long position() throws IOException {
        return this.input.position();
    }

    public void flush() {
        this.input.flush();
    }
}

