/*
 * Copyright (C) 2011 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/PluginData.h>

#if PLATFORM(COCOA)
#include <mach/machine.h>
#endif

namespace WebKit {

enum PluginModuleLoadPolicy {
    // The plug-in module should be loaded normally.
    PluginModuleLoadNormally,

    // The plug-in module should be loaded normally. If the plug-in has a sandbox, it will be disabled.
    PluginModuleLoadUnsandboxed,

    // The plug-in should be blocked from being instantiated.
    // Note that the plug-in will still be seen by e.g. navigator.plugins
    PluginModuleBlockedForSecurity,
    PluginModuleBlockedForCompatibility,
};

struct PluginModuleInfo {
    String path;
    WebCore::PluginInfo info;

#if PLATFORM(COCOA)
    cpu_type_t pluginArchitecture;
    String bundleIdentifier;
    String versionString;
    String shortVersionString;
    bool hasSandboxProfile;
#endif
};

} // namespace WebKit
