// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_variables.json and
// builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_autogen.cpp: Wrapper for static or pool allocated char arrays, that are
// guaranteed to be valid and unchanged for the duration of the compilation. Implements
// mangledNameHash using perfect hash function from gen_builtin_symbols.py

#include "compiler/translator/ImmutableString.h"

std::ostream &operator<<(std::ostream &os, const sh::ImmutableString &str)
{
    return os.write(str.data(), str.length());
}

#if defined(_MSC_VER)
#    pragma warning(disable : 4309)  // truncation of constant value
#endif

namespace
{

constexpr int mangledkT1[] = {28,   3723, 1475, 371,  51,   3462, 1683, 2358, 3960, 3760,
                              2533, 2942, 2587, 1686, 466,  832,  1198, 860,  3747, 824,
                              946,  743,  1301, 3888, 1189, 1813, 3864, 248,  3590, 3448,
                              1379, 196,  1988, 2577, 1764, 270,  376};
constexpr int mangledkT2[] = {2798, 3904, 2564, 1178, 3278, 628,  2610, 1987, 3024, 1954,
                              2499, 12,   3392, 2914, 794,  3806, 3980, 2527, 3362, 3980,
                              1226, 3423, 713,  1825, 1062, 1687, 1758, 3010, 2151, 2612,
                              1189, 1755, 1372, 2634, 1830, 448,  2730};
constexpr int mangledkG[]  = {
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    639,  0,    0,    0,    3989, 0,    1769, 0,    634,  1890, 0,    0,    0,    145,  0,    0,
    0,    0,    3626, 0,    0,    0,    0,    0,    2169, 0,    0,    0,    0,    1101, 0,    0,
    0,    0,    0,    0,    0,    2836, 0,    391,  0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    3962, 0,    0,    0,    2256, 1708, 0,    594,  0,    0,    0,    0,    0,    557,
    0,    0,    1169, 825,  3786, 0,    0,    1963, 0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    3407, 0,
    2374, 0,    0,    0,    0,    0,    3517, 1263, 0,    0,    1281, 989,  3862, 3496, 1810, 0,
    3143, 0,    0,    0,    3285, 3588, 0,    0,    0,    0,    3089, 0,    1239, 553,  3392, 0,
    2301, 0,    0,    0,    0,    0,    0,    0,    0,    3748, 0,    0,    0,    2584, 1570, 0,
    1139, 0,    1034, 0,    0,    0,    0,    1335, 0,    1435, 0,    3637, 0,    0,    0,    58,
    3114, 0,    0,    0,    2043, 0,    3169, 466,  0,    495,  3598, 0,    0,    0,    0,    3506,
    4016, 0,    0,    0,    2056, 0,    303,  3319, 0,    0,    818,  1325, 0,    0,    0,    0,
    3622, 0,    0,    189,  3689, 0,    1735, 0,    0,    804,  0,    0,    0,    0,    3379, 0,
    1371, 0,    3740, 0,    0,    0,    3495, 0,    0,    0,    409,  0,    0,    0,    2608, 0,
    1229, 722,  0,    1558, 1391, 3823, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    3291, 1392, 0,    0,    228,  0,    0,    0,    0,    0,    0,    0,    0,    308,  0,
    0,    0,    0,    0,    2436, 0,    0,    0,    743,  3009, 0,    642,  0,    0,    1176, 0,
    0,    0,    1766, 0,    0,    0,    0,    0,    0,    0,    0,    287,  0,    0,    0,    0,
    3422, 3236, 3990, 0,    0,    1347, 0,    0,    0,    832,  3240, 3588, 0,    0,    0,    0,
    3033, 0,    0,    1365, 0,    0,    0,    0,    173,  3964, 0,    0,    0,    3589, 0,    0,
    0,    3240, 332,  0,    1714, 3598, 2481, 0,    0,    0,    99,   0,    0,    0,    2221, 0,
    3696, 0,    1195, 3618, 2753, 1278, 3651, 0,    0,    0,    3229, 0,    745,  0,    0,    1840,
    0,    0,    1881, 0,    0,    0,    616,  0,    561,  3158, 1367, 0,    0,    0,    571,  416,
    0,    0,    340,  3425, 1686, 286,  0,    3988, 2657, 0,    391,  280,  0,    0,    0,    0,
    1019, 0,    0,    0,    0,    3375, 0,    0,    0,    2450, 0,    0,    776,  0,    2748, 0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    236,  0,    1143, 0,
    0,    0,    0,    0,    2585, 3511, 0,    311,  0,    442,  0,    0,    0,    0,    1494, 0,
    0,    0,    0,    0,    3472, 0,    0,    719,  2609, 0,    0,    0,    2108, 2572, 0,    928,
    2589, 0,    168,  59,   3360, 3743, 502,  0,    2702, 1842, 0,    0,    0,    553,  1072, 2774,
    1330, 1355, 1713, 0,    231,  855,  1471, 0,    129,  0,    3926, 0,    3734, 0,    0,    0,
    0,    0,    0,    0,    0,    0,    3430, 0,    269,  2404, 0,    0,    0,    656,  0,    687,
    360,  2159, 1443, 0,    1863, 0,    0,    0,    0,    0,    1185, 0,    390,  0,    0,    2571,
    1704, 452,  1997, 0,    3368, 0,    0,    2868, 0,    0,    0,    0,    843,  1996, 477,  0,
    3539, 1077, 3406, 0,    0,    544,  0,    780,  0,    0,    0,    0,    0,    0,    3816, 617,
    0,    0,    0,    0,    706,  0,    0,    3204, 0,    462,  0,    0,    701,  3672, 0,    637,
    0,    0,    3916, 0,    0,    0,    535,  0,    35,   1910, 0,    1463, 619,  0,    1041, 0,
    0,    0,    0,    0,    3359, 0,    2912, 0,    0,    0,    1118, 0,    2513, 943,  0,    0,
    79,   0,    0,    0,    3387, 0,    3520, 1663, 0,    0,    0,    3688, 0,    0,    0,    0,
    3911, 1979, 0,    445,  0,    0,    847,  0,    0,    0,    0,    761,  491,  3991, 185,  0,
    0,    2133, 0,    3499, 0,    0,    0,    0,    1014, 0,    1715, 0,    483,  0,    2580, 0,
    0,    0,    2724, 0,    0,    0,    837,  1300, 0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    3746, 0,    0,    1613, 3425, 3798, 845,  0,    0,    1921, 0,    0,    0,    0,
    0,    2589, 3176, 1202, 0,    62,   3823, 4019, 3057, 0,    2992, 2406, 2078, 524,  0,    286,
    768,  0,    0,    0,    0,    0,    0,    0,    380,  0,    0,    312,  2297, 0,    3737, 0,
    0,    0,    3915, 0,    3185, 2581, 399,  0,    0,    1023, 3133, 2633, 85,   0,    2367, 0,
    0,    1657, 0,    0,    1075, 0,    1061, 3206, 0,    3974, 3515, 0,    1056, 0,    0,    0,
    0,    1204, 0,    3000, 453,  0,    967,  0,    0,    726,  0,    0,    2783, 0,    0,    75,
    0,    0,    0,    3789, 14,   0,    2026, 2458, 3987, 2971, 0,    0,    1236, 3751, 0,    0,
    0,    3143, 3506, 0,    115,  3261, 0,    1473, 996,  1203, 1625, 3678, 0,    3327, 2648, 0,
    0,    0,    1830, 3346, 0,    0,    0,    0,    0,    0,    0,    0,    0,    3794, 734,  0,
    395,  0,    2327, 0,    389,  0,    0,    0,    2024, 0,    0,    0,    439,  0,    0,    0,
    699,  154,  3658, 0,    3555, 0,    0,    0,    3248, 0,    1783, 3,    0,    0,    0,    1721,
    913,  58,   0,    3508, 0,    0,    0,    0,    0,    3651, 0,    1914, 0,    0,    0,    1176,
    0,    0,    2994, 723,  3523, 0,    3619, 0,    500,  0,    2073, 0,    0,    0,    2883, 0,
    0,    0,    2713, 0,    0,    0,    3322, 0,    0,    3167, 0,    0,    0,    2981, 0,    0,
    0,    188,  0,    768,  0,    0,    537,  0,    3180, 2744, 222,  0,    0,    0,    0,    0,
    268,  0,    618,  489,  664,  1437, 3201, 0,    0,    3166, 720,  0,    0,    0,    3125, 797,
    0,    3427, 0,    0,    1697, 1760, 3215, 1007, 557,  4005, 3545, 41,   0,    0,    0,    1027,
    0,    0,    346,  3645, 0,    1686, 0,    0,    2761, 967,  0,    3673, 0,    2700, 3365, 322,
    2043, 2449, 3552, 0,    665,  658,  1131, 1526, 938,  0,    3002, 0,    0,    0,    0,    0,
    3204, 0,    927,  131,  2262, 1069, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    1073, 0,    0,    0,    1128, 3127, 606,  0,    1095, 2066, 0,    0,    0,    0,    3707,
    370,  0,    0,    0,    0,    0,    0,    0,    1404, 1451, 0,    2882, 2569, 2081, 0,    162,
    2918, 45,   0,    1175, 399,  0,    909,  1953, 0,    0,    528,  0,    0,    1133, 0,    0,
    0,    3194, 3323, 3206, 2011, 0,    3918, 0,    0,    1787, 0,    0,    873,  0,    0,    3693,
    0,    1983, 1079, 0,    0,    1862, 0,    0,    1621, 0,    2582, 0,    349,  0,    0,    3230,
    1718, 0,    2553, 0,    507,  1543, 3773, 0,    0,    2090, 919,  0,    1466, 0,    0,    1953,
    0,    0,    0,    1709, 0,    0,    0,    1155, 1946, 0,    172,  0,    1670, 0,    0,    3933,
    3274, 180,  510,  3384, 0,    1191, 0,    0,    0,    1140, 3400, 1716, 0,    3703, 0,    0,
    0,    0,    229,  0,    142,  0,    3459, 0,    0,    0,    0,    1036, 0,    1537, 0,    0,
    0,    852,  34,   0,    0,    3691, 3536, 2301, 625,  1300, 0,    506,  660,  2455, 0,    4018,
    1901, 1275, 0,    999,  1668, 1222, 0,    1220, 1905, 640,  669,  0,    0,    1157, 0,    2267,
    0,    3032, 0,    3875, 0,    0,    757,  2063, 452,  0,    3812, 0,    1387, 0,    0,    316,
    331,  257,  0,    0,    0,    0,    1647, 0,    0,    3829, 304,  3164, 409,  1777, 0,    0,
    0,    0,    1472, 0,    0,    0,    0,    1024, 0,    2852, 0,    0,    0,    0,    0,    0,
    1337, 524,  0,    1278, 953,  199,  1077, 3940, 0,    128,  2827, 3711, 0,    2401, 33,   0,
    0,    2638, 1153, 1652, 2102, 1568, 580,  0,    3673, 2338, 0,    3514, 3335, 1898, 735,  0,
    0,    0,    730,  0,    1417, 2484, 282,  0,    0,    0,    0,    0,    0,    1940, 0,    0,
    1501, 1824, 0,    1689, 0,    0,    1,    659,  0,    713,  0,    3884, 0,    3954, 0,    0,
    3805, 0,    0,    340,  0,    2925, 0,    3874, 3525, 168,  0,    0,    1259, 0,    0,    0,
    772,  878,  695,  0,    1385, 1331, 0,    0,    0,    0,    0,    0,    2945, 1455, 886,  620,
    1992, 0,    0,    0,    474,  0,    3408, 0,    0,    0,    0,    0,    2544, 81,   0,    0,
    0,    2694, 0,    0,    0,    0,    0,    0,    23,   0,    0,    1487, 1305, 1609, 0,    0,
    0,    2720, 670,  468,  0,    0,    2669, 775,  596,  2518, 240,  3417, 581,  1629, 2339, 1773,
    3228, 0,    3507, 0,    230,  0,    352,  0,    1551, 0,    0,    683,  2302, 0,    364,  1638,
    0,    2956, 244,  0,    496,  3113, 0,    0,    0,    0,    1951, 0,    623,  0,    4020, 1321,
    0,    0,    0,    0,    1996, 958,  0,    1546, 1868, 0,    1190, 0,    3783, 0,    3032, 0,
    1695, 0,    0,    0,    0,    0,    0,    2075, 0,    0,    0,    0,    2868, 2044, 0,    0,
    2469, 0,    3864, 0,    2981, 0,    3018, 0,    3492, 0,    3670, 0,    2655, 0,    0,    122,
    0,    0,    532,  0,    635,  1835, 3904, 0,    0,    0,    3026, 3431, 0,    0,    471,  1132,
    1155, 1948, 1799, 1141, 2432, 0,    0,    0,    2077, 0,    1321, 0,    963,  0,    0,    1885,
    0,    17,   0,    0,    1618, 376,  230,  3350, 492,  2179, 0,    1267, 1652, 2937, 721,  2035,
    2882, 0,    0,    0,    1826, 1123, 0,    1099, 0,    150,  1088, 758,  0,    3285, 0,    0,
    115,  0,    1895, 0,    1468, 0,    0,    0,    388,  0,    0,    0,    1627, 0,    3686, 3560,
    214,  0,    0,    0,    0,    0,    3022, 784,  0,    0,    0,    2694, 0,    0,    3024, 0,
    0,    0,    0,    0,    0,    1871, 330,  0,    0,    0,    123,  0,    333,  0,    2609, 0,
    742,  0,    1375, 0,    143,  1186, 191,  0,    705,  0,    215,  1871, 0,    0,    1039, 2943,
    345,  1685, 0,    0,    2887, 0,    0,    0,    364,  0,    833,  1317, 0,    468,  3159, 0,
    3318, 0,    0,    1207, 3879, 1740, 0,    2986, 0,    246,  2514, 0,    0,    0,    0,    0,
    0,    0,    991,  0,    1381, 0,    1622, 1590, 345,  0,    0,    728,  0,    0,    771,  0,
    0,    0,    583,  244,  2133, 0,    0,    0,    1918, 0,    0,    1361, 1676, 1042, 0,    0,
    0,    1924, 2454, 1357, 0,    482,  605,  0,    0,    0,    0,    666,  530,  0,    2388, 0,
    680,  350,  22,   502,  1177, 3063, 0,    2804, 435,  0,    0,    0,    372,  0,    0,    1602,
    302,  0,    3456, 0,    0,    1586, 947,  2828, 0,    3397, 101,  940,  0,    2546, 0,    320,
    0,    2286, 1359, 0,    924,  754,  1792, 0,    0,    3472, 0,    666,  925,  2824, 274,  0,
    262,  1304, 2526, 839,  1295, 0,    1830, 0,    1638, 88,   421,  0,    440,  413,  327,  0,
    0,    898,  0,    2271, 1435, 0,    3651, 0,    2233, 714,  1329, 458,  544,  1603, 0,    0,
    3180, 0,    0,    2276, 0,    280,  0,    0,    2982, 998,  0,    643,  1322, 2325, 2296, 0,
    0,    0,    1860, 0,    0,    0,    0,    0,    0,    404,  0,    999,  1751, 1388, 0,    570,
    1268, 0,    3843, 0,    0,    1019, 2163, 3488, 0,    0,    0,    0,    2365, 0,    46,   3092,
    3446, 0,    373,  1059, 0,    1549, 2039, 0,    3466, 0,    1657, 0,    1178, 0,    888,  0,
    1500, 442,  0,    0,    2087, 0,    0,    0,    2065, 1097, 0,    0,    2438, 0,    585,  387,
    1631, 184,  0,    0,    293,  3954, 0,    1047, 1526, 0,    0,    0,    0,    2000, 0,    2775,
    0,    1642, 235,  3671, 1727, 715,  3762, 2015, 0,    991,  0,    427,  0,    0,    0,    0,
    0,    3002, 0,    844,  0,    0,    0,    217,  3686, 3249, 3741, 0,    1763, 0,    0,    0,
    332,  2793, 2468, 3530, 826,  0,    0,    0,    0,    1873, 0,    0,    0,    3375, 909,  0,
    1656, 854,  0,    0,    3326, 854,  71,   3695, 188,  1502, 0,    0,    827,  0,    0,    0,
    0,    3489, 3969, 1537, 0,    0,    602,  0,    0,    751,  3016, 0,    0,    0,    0,    0,
    7,    3902, 1764, 3674, 0,    3507, 3007, 0,    0,    2302, 3079, 1995, 947,  3503, 3352, 1242,
    0,    1504, 1205, 0,    0,    3631, 0,    984,  1490, 0,    0,    1471, 3727, 1306, 1051, 3583,
    74,   0,    82,   2206, 3322, 0,    0,    304,  1905, 0,    2365, 2984, 3200, 1636, 1137, 2851,
    0,    795,  0,    685,  0,    3407, 647,  0,    1053, 0,    3202, 0,    1385, 734,  1996, 834,
    2557, 574,  996,  1392, 0,    0,    1985, 324,  0,    2615, 0,    507,  817,  195,  0,    0,
    0,    2626, 0,    1150, 0,    0,    743,  0,    775,  0,    615,  3188, 863,  0,    1451, 0,
    3296, 0,    1133, 0,    579,  1174, 736,  2205, 1151, 1716, 0,    1965, 0,    0,    176,  1428,
    774,  1146, 2880, 0,    0,    0,    839,  806,  0,    0,    0,    0,    456,  1578, 0,    0,
    3023, 0,    0,    816,  2369, 1826, 0,    0,    3522, 0,    2551, 0,    1172, 59,   1000, 0,
    783,  2193, 127,  481,  0,    0,    0,    0,    326,  792,  3825, 221,  0,    904,  3019, 408,
    1600, 0,    2395, 0,    0,    0,    2701, 2301, 3013, 2166, 2673, 3171, 0,    0,    0,    0,
    0,    1763, 0,    0,    0,    761,  912,  1845, 0,    0,    1362, 549,  0,    989,  3912, 0,
    602,  730,  0,    1613, 0,    2662, 31,   86,   232,  0,    0,    0,    0,    1387, 0,    0,
    874,  1908, 2056, 0,    897,  0,    0,    0,    1731, 2716, 971,  0,    1593, 498,  2647, 653,
    0,    1440, 434,  0,    2713, 356,  3433, 0,    0,    0,    710,  3218, 3047, 1875, 1393, 1474,
    0,    887,  2026, 1053, 2094, 0,    0,    0,    0,    0,    0,    0,    1873, 0,    1859, 928,
    0,    0,    293,  1882, 0,    0,    1493, 2847, 0,    0,    2415, 0,    316,  2267, 837,  0,
    561,  658,  3319, 2655, 1238, 2192, 123,  0,    1330, 1203, 0,    0,    3025, 1288, 2260, 770,
    0,    3534, 767,  2854, 0,    1907, 1771, 0,    0,    3029, 1421, 0,    3463, 0,    0,    727,
    1310, 3422, 1236, 745,  1397, 3497, 504,  1194, 3248, 861,  2535, 0,    1634, 0,    0,    1812,
    2973, 0,    2372, 0,    0,    0,    0,    0,    3940, 1210, 0,    0,    0,    1512, 0,    0,
    1607, 899,  0,    3590, 0,    0,    0,    0,    0,    102,  0,    0,    1702, 3513, 1211, 1746,
    222,  2894, 631,  0,    0,    3317, 0,    0,    1525, 2109, 3766, 1233, 0,    233,  1538, 1661,
    898,  2825, 0,    0,    941,  0,    0,    0,    516,  0,    611,  0,    0,    859,  0,    1001,
    2597, 0,    0,    0,    0,    1688, 0,    0,    0,    0,    1076, 0,    3326, 894,  74,   444,
    3779, 1995, 3249, 113,  3998, 0,    0,    604,  0,    0,    1077, 1516, 1750, 1302, 0,    3676,
    0,    0,    0,    0,    1097, 0,    1098, 2570, 1489, 0,    2960, 0,    3767, 323,  0,    1580,
    1382, 0,    0,    2195, 0,    0,    2225, 1268, 1815, 0,    192,  0,    0,    0,    2183, 290,
    359,  0,    2946, 0,    1584, 288,  2338, 0,    1893, 1619, 0,    1516, 415,  0,    0,    0,
    0,    3375, 836,  1220, 0,    0,    3968, 0,    0,    0,    1112, 1984, 467,  2890, 0,    0,
    2006, 3484, 0,    2187, 1682, 371,  2264, 3088, 924,  985,  0,    0,    0,    1035, 147,  3525,
    250,  2598, 128,  1110, 2120, 0,    3091, 0,    0,    0,    0,    0,    400,  574,  0,    477,
    0,    0,    3820, 0,    3832, 2194, 475,  2732, 0,    0,    941,  0,    0,    1975, 0,    0,
    0,    2021, 0,    0,    1951, 1427, 870,  1516, 588,  2952, 3441, 0,    496,  0,    782,  0,
    692,  3,    866,  1136, 313,  672,  0,    1262, 3262, 2669, 0,    716,  994,  0,    1449, 1588,
    0,    0,    0,    0,    171,  1094, 0,    633,  3489, 595,  2117, 0,    1797, 1676, 808,  0,
    0,    0,    0,    1260, 0,    0,    1533, 0,    3734, 3356, 344,  748,  0,    3317, 1804, 0,
    1374, 0,    1523, 3383, 1050, 429,  2565, 1047, 2193, 0,    1380, 2517, 3143, 514,  0,    0,
    3999, 2604, 0,    3399, 2080, 0,    0,    1567, 0,    1691, 763,  0,    2130, 2674, 0,    1229,
    0,    0,    0,    1333, 0,    1847, 0,    0,    1111, 0,    0,    141,  3630, 0,    0,    1838,
    1839, 0,    2905, 2380, 0,    874,  0,    2307, 0,    0,    906,  0,    1080, 0,    119,  1876,
    3868, 0,    0,    0,    1000, 499,  0,    0,    55,   781,  3828, 0,    0,    2079, 1177, 2365,
    0,    0,    239,  2310, 72,   644,  884,  2436, 8,    1466, 1377, 135,  1383, 0,    737,  0,
    0,    0,    3843, 3767, 0,    703,  1737, 1676, 732,  2077, 0,    0,    1420, 910,  1148, 295,
    3553, 884,  0,    1496, 1919, 1201, 0,    0,    385,  1385, 857,  2422, 805,  0,    3311, 419,
    3122, 1191, 0,    1632, 1964, 1231, 0,    0,    1427, 0,    0,    1196, 1829, 1486, 211,  0,
    1434, 0,    0,    0,    1024, 0,    0,    0,    0,    2012, 0,    2838, 1788, 2981, 0,    2644,
    0,    554,  3956, 592,  165,  2866, 0,    0,    161,  0,    0,    4020, 1663, 0,    0,    0,
    0,    222,  0,    2281, 901,  0,    3955, 1208, 1130, 197,  1913, 0,    24,   3783, 0,    0,
    1069, 0,    974,  0,    2754, 0,    1182, 0,    661,  3477, 2007, 0,    2882, 0,    643,  3412,
    0,    3698, 0,    782,  3085, 30,   0,    0,    2020, 925,  0,    460,  521,  472,  0,    276,
    892,  0,    0,    1112, 477,  0,    1241, 0,    834,  3832, 0,    0,    1170, 0,    0,    964,
    4013, 2536, 0,    793,  43,   3455, 869,  0,    2271, 2775, 2780, 0,    1570, 0,    1793, 1562,
    3715, 0,    3316, 488,  3666, 3126, 773,  913,  2188, 1999, 0,    207,  3621, 2074, 1338, 3773,
    2038, 1047, 538,  0,    0,    3302, 3342, 1244, 0,    0,    0,    0,    292,  0,    3159, 0,
    1359, 942,  0,    0,    0,    1343, 0,    0,    1814, 1015, 0,    1271, 1971, 0,    0,    3671,
    0,    0,    0,    0,    0,    0,    1059, 0,    0,    3156, 2039, 0,    1187, 0,    0,    3534,
    1123, 3522, 1498, 2434, 2894, 1810, 1523, 711,  467,  0,    0,    0,    3191, 1639, 2043, 1604,
    760,  2138, 0,    1852, 0,    0,    2676, 3705, 2571, 0,    3545, 1671, 1802, 0,    0,    704,
    0,    0,    0,    692,  61,   0,    310,  3856, 2564, 565,  0,    0,    504,  1251, 2170, 3452,
    3396, 3101, 566,  213,  2406, 3646, 3744, 1817, 0,    1087, 0,    3900, 2071, 0,    337,  679,
    1624, 923,  0,    0,    0,    3192, 1419, 0,    2963, 0,    0,    342,  3253, 0,    1694, 1556,
    1296, 0,    0,    0,    2498, 1160, 824,  1610, 0,    0,    0,    275,  0,    3964, 3032, 2090,
    1319, 2833, 556,  1313, 0,    2045, 3841, 0,    2825, 1572, 1903, 465,  0,    0,    0,    2292,
    0,    0,    706,  0,    1258, 0,    0,    0,    1666, 113,  361,  1062, 0,    0,    0,    2078,
    350,  683,  120,  0,    0,    0,    0,    1571, 0,    0,    0,    1223, 0,    970,  3641, 0,
    0,    0,    0,    0,    651,  79,   3953, 0,    0,    0,    3176, 0,    1888, 3999, 1370, 0,
    3115, 0,    1478, 1733, 0,    143,  2020, 0,    1784, 0,    3804, 0,    0,    0,    2497, 0,
    0,    3758, 0,    1974, 0,    0,    0,    988,  827,  0,    1221, 1581, 0,    1697, 3718, 0,
    0,    0,    0,    3462, 1777, 0,    0,    0,    3747, 459,  492,  0,    0,    0,    3515, 0,
    2754, 3266, 3651, 0,    3440, 0,    194,  1151, 2823, 0,    1169, 1823, 2888, 0,    1396, 0,
    3110, 3416, 783,  919,  135,  0,    0,    0,    173,  0,    0,    0,    1623, 235,  3170, 2701,
    2767, 3232, 117,  3821, 0,    0,    3167, 0,    1627, 0,    0,    1899, 299,  0,    0,    0,
    0,    3903, 1125, 0,    211,  2381, 3281, 3245, 1986, 0,    0,    0,    1434, 1480, 1937, 751,
    1813, 3941, 3132, 3627, 239,  129,  545,  0,    2299, 3244, 932,  0,    1287, 1888, 3139, 1881,
    3259, 0,    183,  207,  0,    578,  1498, 0,    0,    282,  2237, 959,  1558, 1824, 0,    0,
    0,    0,    2725, 2136, 359,  0,    1228, 0,    1232, 0,    712,  3543, 3420, 0,    0,    0,
    2148, 0,    0,    16,   0,    893,  3703, 0,    0,    0,    569,  2389, 914,  0,    3497, 2681,
    86,   0,    0,    0,    0,    0,    2709, 201,  1108, 1488, 2033, 3653, 102,  0,    0,    0,
    1230, 0,    509,  0,    0,    349,  414,  2385, 3932, 0,    844,  3971, 1346, 3504, 703,  1739,
    1554, 0,    0,    0,    818,  1642, 9,    1090, 2711, 1503, 542,  0,    1292, 1392, 1240, 3638,
    0,    0,    420,  518,  1358, 876,  0,    0,    1749, 4006, 1740, 3392, 1200, 0,    0,    0,
    0,    1697, 1659, 0,    1265, 276,  0,    0,    0,    0,    898,  1961, 0,    0,    0,    166,
    234,  1477, 1935, 2676, 0,    888,  3405, 2636, 1825, 1966, 1192, 161,  0,    445,  884,  0,
    1278, 0,    2604, 560,  1464, 0,    0,    2565, 2087, 460,  1889, 0,    2310, 1354, 0,    2503,
    0,    1812, 1949, 0,    0,    636,  176,  2903, 1081, 0,    0,    1156, 3930, 0,    1090, 422,
    1746, 309,  0,    474,  0,    1801, 100,  0,    18,   0,    1043, 1942, 0,    0,    36,   1969,
    1606, 1045, 1067, 869,  1391, 3768, 2285, 0,    252,  414,  0,    587,  3908, 0,    3402, 3341,
    1056, 0,    0,    0,    605,  0,    1075, 52,   2122, 0,    3998, 1017, 3265, 0,    0,    1980,
    0,    1351, 0,    940,  1715, 85,   1551, 0,    2884, 2849, 0,    1118, 0,    1515, 0,    0,
    515,  1737, 0,    1187, 1594, 1304, 0,    1080, 3888, 0,    1065, 0,    0,    0,    1479, 0,
    3477, 1690, 35,   0,    1709, 0,    3827, 566,  0,    1986, 2721, 0,    1556, 1443, 3970, 2814,
    2155, 0,    1540, 0,    3570, 3224, 0,    0,    3756, 3105, 1359, 176,  1408, 1946, 1334, 1297,
    2031, 2680, 3954, 515,  631,  2797, 726,  532,  2283, 0,    603,  0,    2053, 982,  1342, 0,
    2261, 999,  0,    1086, 0,    671,  0,    0,    1710, 0,    0,    2137, 2965, 297,  453,  2376,
    1441, 2694, 460,  1550, 3562, 3662, 3967, 740,  0,    44,   0,    0,    1158, 0,    1243, 0,
    3190, 1590, 2649, 0,    384,  0,    0,    537,  1444, 2887, 2274, 624,  3931, 562,  1129, 0,
    968,  806,  1073, 0,    0,    2426, 1526, 81,   662,  2025, 1565, 0,    0,    612,  220,  0,
    756,  0,    979,  0,    1778, 1105, 0,    3591, 3838, 0,    0,    0,    1231, 2707, 3269, 0,
    0,    0,    0,    0,    893,  0,    238,  3866, 1400, 669,  710,  0,    3593, 1800, 0,    0,
    1596, 0,    590,  1483, 0,    335,  2667, 0,    1506, 0,    751,  1656, 12,   0,    1670, 3962,
    3716, 0,    0,    199,  1026, 0,    484,  0,    0,    0,    0,    1318, 1307, 1818, 3331, 425,
    935,  205,  0,    3609, 1985, 2055, 0,    1518, 1036, 991,  1264, 3230, 879,  2781, 1466, 178,
    2969, 0,    918,  1430, 0,    0,    0,    0,    3951, 154,  156,  2405, 0,    696,  0,    0,
    1433, 0,    770,  0,    945,  1858, 0,    0,    747,  1908, 0,    1339, 0,    1267, 0,    0,
    0,    0,    0,    1070, 0,    1908, 2668, 0,    2320, 1081, 2337, 0,    0,    1303, 0,    2088,
    690,  2035, 0,    225,  1173, 0,    13,   237,  1329, 0,    536,  1432, 86,   3591, 2933, 1949,
    0,    722,  3951, 0,    0,    20,   655,  3734, 1995, 580,  0,    0,    0,    3598, 3963, 0,
    3048, 2762, 0,    3436, 3001, 3780, 995,  0,    880,  3269, 1597, 869,  0,    3329, 986,  729,
    0,    711,  0,    926,  3975, 1870, 0,    0,    1303, 312,  329,  1259, 0,    1233, 3990, 1356,
    344,  0,    3701, 0,    3902, 0,    1364, 0,    0,    0,    2051, 385,  0,    0,    2232, 0,
    0,    181,  1607, 3883, 1565, 0,    2111, 1506, 0,    0,    0,    0,    2022, 0,    3832, 0,
    3596, 0,    1945, 1957, 1805, 1482, 3996, 3426, 266,  2114, 652,  0,    407,  1835, 1499, 2095,
    1637, 1690, 2134, 0,    0,    0,    658,  1598, 2171, 0,    0,    0,    1628, 0,    365,  3169,
    245,  977,  0,    0,    0,    1101, 3365, 1626, 2555, 2041, 2816, 0,    0,    898,  1309, 2692,
    3795, 604,  594,  2840, 1930, 3968, 2128, 0,    943,  1972, 1114, 0,    119,  0,    2945, 3516,
    2200, 3310, 0,    0,    453,  2788, 1064, 0,    0,    1700, 791,  1818, 0,    123,  0,    2124,
    1031, 1645, 0,    1263, 0,    0,    1108, 0,    3436, 0,    274,  1394, 720,  0,    0,    0,
    833,  0,    0,    0,    0,    0,    3425, 1818, 1515, 0,    0,    2894, 0,    2901, 0,    1999,
    1699, 0,    2529, 1199, 2024, 0,    0,    272,  2583, 0,    2900, 3332, 2018, 820,  3395, 0,
    0,    0,    2066, 0,    1136, 3784, 3739, 345,  0,    1241, 363,  0,    0,    3584, 519,  986,
    0,    0,    1521, 0,    0,    3112, 0,    117,  0,    0,    2799, 155,  3937, 449,  3970, 79,
    0,    3989, 0,    0,    2678, 2121, 3104, 0,    0,    842,  2820, 0,    1744, 3316, 0,    1531,
    1304, 807,  0,    0,    266,  0,    3355, 0,    3301, 0,    362,  1335, 2051, 700,  0,    798,
    2449, 2927, 0,    0,    1171, 0,    1406, 2140, 980,  1208, 260,  0,    0,    0,    3867, 774,
    1993, 0,    0,    0,    298,  0,    1922, 275,  2473, 0,    112,  0,    1002, 2985, 3527, 1860,
    0,    0,    3477, 0,    2168, 0,    4014, 2355, 2489, 1669, 899,  0,    3764, 2568, 3985, 0,
    5,    1573, 0,    1654, 3474, 1507, 790,  1389, 0,    0,    301,  209,  687,  2057, 271,  1496,
    302,  0,    287,  0,    1529, 1353, 0,    0,    0,    2452, 912,  2152, 240,  0,    0,    0,
    0,    3258, 139,  1593, 2314, 0,    0,    1921, 3918, 141,  0,    1962, 1188, 0,    106,  0,
    2686, 0,    3260, 3800, 1119, 0,    2097, 2623, 3684, 0,    393,  3188, 1029, 3345, 2540, 2796,
    1458, 2377, 1349, 0,    0,    3698, 0,    1860, 521,  248,  548,  1599, 0,    1747, 902,  3,
    0,    1883, 0,    2009, 713,  2002};

int MangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 4022;
    }
    return mangledkG[sum];
}

int MangledPerfectHash(const char *key)
{
    if (strlen(key) > 37)
        return 0;

    return (MangledHashG(key, mangledkT1) + MangledHashG(key, mangledkT2)) % 4022;
}

constexpr int unmangledkT1[] = {144, 106, 306, 148, 131, 219, 212, 45,  287, 341, 277, 20,  111,
                                58,  208, 119, 14,  175, 302, 100, 209, 295, 267, 0,   229, 180};
constexpr int unmangledkT2[] = {121, 122, 34, 65,  319, 69,  163, 60, 246, 67,  291, 196, 119,
                                224, 117, 41, 360, 309, 210, 88,  98, 242, 241, 278, 10,  1};
constexpr int unmangledkG[]  = {
    0,   0,   0,   0,   169, 0,   213, 0,   0,   147, 0,   364, 0,   83,  271, 0,   0,   0,   0,
    26,  0,   190, 0,   0,   0,   0,   0,   84,  6,   0,   0,   47,  0,   0,   171, 0,   36,  74,
    236, 0,   82,  0,   0,   0,   65,  189, 121, 0,   0,   0,   3,   65,  244, 37,  317, 71,  327,
    0,   133, 0,   73,  0,   337, 0,   0,   77,  0,   0,   98,  0,   0,   45,  0,   41,  0,   51,
    339, 23,  0,   0,   240, 0,   0,   0,   0,   0,   186, 0,   0,   0,   103, 42,  184, 0,   0,
    350, 0,   82,  25,  105, 61,  0,   0,   119, 0,   69,  177, 0,   360, 344, 0,   0,   0,   0,
    157, 0,   41,  0,   0,   0,   0,   87,  313, 0,   14,  12,  0,   0,   0,   175, 286, 0,   0,
    120, 0,   111, 0,   0,   0,   0,   291, 0,   188, 270, 307, 356, 0,   5,   54,  130, 20,  47,
    123, 0,   149, 308, 120, 39,  165, 351, 131, 0,   52,  110, 95,  88,  172, 0,   98,  0,   169,
    67,  0,   93,  321, 13,  1,   178, 0,   248, 51,  0,   63,  189, 157, 0,   134, 299, 0,   0,
    0,   130, 19,  0,   141, 0,   0,   186, 287, 184, 0,   314, 0,   352, 63,  109, 49,  0,   276,
    0,   0,   19,  285, 202, 128, 0,   54,  287, 19,  74,  0,   0,   86,  75,  29,  122, 27,  37,
    1,   0,   0,   353, 98,  0,   94,  136, 207, 30,  30,  107, 175, 0,   0,   0,   22,  0,   24,
    2,   20,  300, 0,   0,   265, 0,   0,   0,   169, 95,  93,  15,  94,  241, 94,  6,   0,   0,
    0,   332, 283, 0,   131, 299, 2,   0,   127, 0,   0,   296, 183, 0,   0,   276, 0,   150, 163,
    133, 112, 0,   332, 245, 192, 0,   0,   15,  56,  0,   0,   37,  125, 0,   0,   0,   15,  142,
    0,   0,   0,   0,   50,  0,   0,   348, 0,   111, 0,   37,  52,  67,  260, 90,  98,  176, 31,
    0,   175, 24,  0,   158, 0,   0,   75,  108, 128, 60,  0,   107, 106, 0,   0,   59,  317, 0,
    17,  132, 0,   203, 0,   0,   0,   91,  50,  15,  62,  0,   129, 0,   0,   168, 267, 0,   261,
    200, 0,   73,  0};

int UnmangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 365;
    }
    return unmangledkG[sum];
}

int UnmangledPerfectHash(const char *key)
{
    if (strlen(key) > 26)
        return 0;

    return (UnmangledHashG(key, unmangledkT1) + UnmangledHashG(key, unmangledkT2)) % 365;
}

}  // namespace

namespace sh
{

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvPrime = 16777619u;

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvOffsetBasis = 0x811c9dc5u;

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvPrime =
    static_cast<size_t>(1099511628211ull);

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvOffsetBasis =
    static_cast<size_t>(0xcbf29ce484222325ull);

uint32_t ImmutableString::mangledNameHash() const
{
    return MangledPerfectHash(data());
}

uint32_t ImmutableString::unmangledNameHash() const
{
    return UnmangledPerfectHash(data());
}

}  // namespace sh
