/*
 * Copyright (C) 2006, 2007, 2009, 2010 Apple Inc. All rights reserved.
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef DOMWindowNotifications_h
#define DOMWindowNotifications_h

#if ENABLE(NOTIFICATIONS) || ENABLE(LEGACY_NOTIFICATIONS)

#include "DOMWindowProperty.h"
#include "Supplementable.h"
#include <wtf/text/WTFString.h>

namespace WebCore {

class DOMWindow;
class NotificationCenter;

class DOMWindowNotifications : public Supplement<DOMWindow>, public DOMWindowProperty {
public:
    explicit DOMWindowNotifications(DOMWindow*);
    virtual ~DOMWindowNotifications();

    static NotificationCenter* webkitNotifications(DOMWindow*);
    static DOMWindowNotifications* from(DOMWindow*);

    virtual void disconnectFrameForPageCache() override;
    virtual void reconnectFrameFromPageCache(Frame*) override;
    virtual void willDestroyGlobalObjectInCachedFrame() override;
    virtual void willDestroyGlobalObjectInFrame() override;
    virtual void willDetachGlobalObjectFromFrame() override;

private:
    NotificationCenter* webkitNotifications();
    static const char* supplementName();

    DOMWindow* m_window;
    RefPtr<NotificationCenter> m_notificationCenter;
    RefPtr<NotificationCenter> m_suspendedNotificationCenter;
};

} // namespace WebCore

#endif // ENABLE(NOTIFICATIONS) || ENABLE(LEGACY_NOTIFICATIONS)

#endif // DOMWindowNotifications_h
