/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.Gradient;

public class RadialGradient
implements Gradient {
    private double cx;
    private double cy;
    private double fx;
    private double fy;
    private double r;
    private boolean isRelativeToFigureBounds = true;
    private double[] stopOffsets;
    private Color[] stopColors;
    private AffineTransform transform;
    private double[] stopOpacities;

    public RadialGradient() {
    }

    public RadialGradient(double d, double d2, double d3, double d4, double d5, double[] dArray, Color[] colorArray, double[] dArray2, boolean bl, AffineTransform affineTransform) {
        this.cx = d;
        this.cy = d2;
        this.fx = d3;
        this.fy = d4;
        this.r = d5;
        this.stopOffsets = dArray;
        this.stopColors = colorArray;
        this.stopOpacities = dArray2;
        this.isRelativeToFigureBounds = bl;
        this.transform = affineTransform;
    }

    public void setGradientCircle(double d, double d2, double d3) {
        this.cx = d;
        this.cy = d2;
        this.r = d3;
    }

    public void setStops(double[] dArray, Color[] colorArray, double[] dArray2) {
        this.stopOffsets = dArray;
        this.stopColors = colorArray;
        this.stopOpacities = dArray2;
    }

    public void setRelativeToFigureBounds(boolean bl) {
        this.isRelativeToFigureBounds = bl;
    }

    @Override
    public void makeRelativeToFigureBounds(Figure figure) {
        if (!this.isRelativeToFigureBounds) {
            this.isRelativeToFigureBounds = true;
            Rectangle2D.Double double_ = figure.getBounds();
            this.cx = (this.cx - double_.x) / double_.width;
            this.cy = (this.cy - double_.y) / double_.height;
            this.r /= Math.sqrt(double_.width * double_.width / 2.0 + double_.height * double_.height / 2.0);
        }
    }

    @Override
    public Paint getPaint(Figure figure, double d) {
        Object object;
        if (this.stopColors.length == 0 || this.r <= 0.0) {
            return new Color(-1600086016, true);
        }
        Color[] colorArray = new Color[this.stopColors.length];
        float[] fArray = new float[this.stopColors.length];
        for (int i = 0; i < this.stopColors.length; ++i) {
            fArray[i] = (float)this.stopOffsets[i];
            colorArray[i] = new Color(this.stopColors[i].getRGB() & 0xFFFFFF | (int)(d * this.stopOpacities[i] * 255.0) << 24, true);
        }
        Point2D.Double double_ = new Point2D.Double(this.cx, this.cy);
        Point2D.Double double_2 = new Point2D.Double(this.fx, this.fy);
        double d2 = this.r;
        AffineTransform affineTransform = this.transform;
        if (this.isRelativeToFigureBounds) {
            if (!affineTransform.isIdentity()) {
                System.out.println("RadialGradient " + this.hashCode() + " t=" + affineTransform);
            }
            affineTransform = new AffineTransform();
            object = figure.getBounds();
            affineTransform.translate(((Rectangle2D.Double)object).x, ((Rectangle2D.Double)object).y);
            affineTransform.scale(((Rectangle2D.Double)object).width, ((Rectangle2D.Double)object).height);
        }
        if (this.stopColors.length == 1 || affineTransform.getDeterminant() == 0.0) {
            return colorArray[0];
        }
        object = new RadialGradientPaint(double_, (float)d2, double_2, fArray, colorArray, RadialGradientPaint.NO_CYCLE, RadialGradientPaint.SRGB, affineTransform);
        return object;
    }

    public double getCX() {
        return this.cx;
    }

    public double getCY() {
        return this.cy;
    }

    public double getFX() {
        return this.fx;
    }

    public double getFY() {
        return this.fy;
    }

    public double getR() {
        return this.r;
    }

    public double[] getStopOffsets() {
        return (double[])this.stopOffsets.clone();
    }

    public Color[] getStopColors() {
        return (Color[])this.stopColors.clone();
    }

    public double[] getStopOpacities() {
        return (double[])this.stopOpacities.clone();
    }

    @Override
    public boolean isRelativeToFigureBounds() {
        return this.isRelativeToFigureBounds;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.transform == null) {
            this.transform = (AffineTransform)affineTransform.clone();
        } else {
            this.transform.preConcatenate(affineTransform);
        }
    }

    @Override
    public Object clone() {
        try {
            RadialGradient radialGradient = (RadialGradient)super.clone();
            radialGradient.stopOffsets = (double[])this.stopOffsets.clone();
            radialGradient.stopColors = (Color[])this.stopColors.clone();
            radialGradient.stopOpacities = (double[])this.stopOpacities.clone();
            radialGradient.transform = (AffineTransform)this.transform.clone();
            return radialGradient;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError();
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.cx);
        l += Double.doubleToLongBits(this.cy) * 37L;
        l += (long)(this.stopColors[0].hashCode() * 43);
        return (int)(l += (long)(this.stopColors[this.stopColors.length - 1].hashCode() * 47)) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof RadialGradient) {
            return this.equals((RadialGradient)object);
        }
        return false;
    }

    public boolean equals(RadialGradient radialGradient) {
        return this.cx == radialGradient.cx && this.cy == radialGradient.cy && this.fx == radialGradient.fx && this.fy == radialGradient.fy && this.r == radialGradient.r && this.isRelativeToFigureBounds == radialGradient.isRelativeToFigureBounds && Arrays.equals(this.stopOffsets, radialGradient.stopOffsets) && Arrays.equals(this.stopOpacities, radialGradient.stopOpacities) && Arrays.equals(this.stopColors, radialGradient.stopColors) && this.transform.equals(radialGradient.transform);
    }
}

