'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbFreeCompatMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbFreeCompatMap \- Free an entire compatibility map or selected portions of one
.SH SYNOPSIS
.HP
.B void XkbFreeCompatMap
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "Bool " "free_map" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
Xkb description in which to free compatibility map
.TP
.I \- which
mask of compatibility map components to free
.TP
.I \- free_map
True => free XkbCompatMap structure itself
.SH DESCRIPTION
.LP
.I which 
specifies the compatibility map components to be freed (see XkbGetCompatMap). 
.I which 
is an inclusive OR of the bits shown in Table 1.

.TS
c s s
l l l.
Table 1 Compatibility Map Component Masks
_
Mask	Value	Affecting
_
XkbSymInterpMask	(1<<0)	Symbol interpretations
XkbGroupCompatMask	(1<<1)	Group maps
XkbAllCompatMask	(0x3)	All compatibility map components
.TE

.I free_map 
indicates whether the XkbCompatMap structure itself should be freed. If 
.I free_map 
is True, 
.I which 
is ignored, all non-NULL compatibility map components are freed, and the 
.I compat 
field in the XkbDescRec referenced by 
.I xkb 
is set to NULL.
.SH STRUCTURES
.LP
.nf

    typedef struct _XkbCompatMapRec {
        XkbSymInterpretPtr    sym_interpret;            /\(** symbol based key semantics*/
        XkbModsRec            groups[XkbNumKbdGroups];  /\(** group => modifier map */
        unsigned short        num_si;                   /\(** # structures used in sym_interpret */
        unsigned short        size_si;                  /\(** # structures allocated in sym_interpret */
    } XkbCompatMapRec, *XkbCompatMapPtr;
    
.fi

The complete description of an Xkb keyboard is given by an XkbDescRec. The component 
structures in the XkbDescRec represent the major Xkb components outlined in Figure 1.1.

.nf
typedef struct {
   struct _XDisplay * display;      /\(** connection to X server */
   unsigned short     flags;        /\(** private to Xkb, do not modify */
   unsigned short     device_spec;  /\(** device of interest */
   KeyCode            min_key_code; /\(** minimum keycode for device */
   KeyCode            max_key_code; /\(** maximum keycode for device */
   XkbControlsPtr     ctrls;        /\(** controls */
   XkbServerMapPtr    server;       /\(** server keymap */
   XkbClientMapPtr    map;          /\(** client keymap */
   XkbIndicatorPtr    indicators;   /\(** indicator map */
   XkbNamesPtr        names;        /\(** names for all components */
   XkbCompatMapPtr    compat;       /\(** compatibility map */
   XkbGeometryPtr     geom;         /\(** physical geometry of keyboard */
} XkbDescRec, *XkbDescPtr;

.fi
The 
.I display 
field points to an X display structure. The 
.I flags field is private to the library: modifying 
.I flags 
may yield unpredictable results. The 
.I device_spec 
field specifies the device identifier of the keyboard input device, or 
XkbUseCoreKeyboard, which specifies the core keyboard device. The 
.I min_key_code
and 
.I max_key_code 
fields specify the least and greatest keycode that can be returned by the keyboard. 
The other fields specify structure components of the keyboard description and are 
described in detail in other sections of this document. Table 2 identifies the 
subsequent sections of this document that discuss the individual components of the 
XkbDescRec.

.TS
c s
l l
l l.
Table 2 XkbDescRec Component References
_
XkbDescRec Field	For more info
_
ctrls	Chapter 10
server	Chapter 16
map	Chapter 15
indicators	Chapter 8
names	Chapter 18
compat	Chapter 17
geom	Chapter 13
.TE

Each structure component has a corresponding mask bit that is used in function calls to 
indicate that the structure should be manipulated in some manner, such as allocating it 
or freeing it. These masks and their relationships to the fields in the XkbDescRec are 
shown in Table 3.

.TS
c s s
l l l
l l l.
Table 3 Mask Bits for XkbDescRec
_
Mask Bit	XkbDescRec Field	Value
_	
XkbControlsMask	ctrls	(1L<<0)
XkbServerMapMask	server	(1L<<1)
XkbIClientMapMask	map	(1L<<2)
XkbIndicatorMapMask	indicators	(1L<<3)
XkbNamesMask	names	(1L<<4)
XkbCompatMapMask	compat	(1L<<5)
XkbGeometryMask	geom	(1L<<6)
XkbAllComponentsMask	All Fields	(0x7f)
.TE
.SH "SEE ALSO"
.BR XkbGetCompatMap (__libmansuffix__)
