/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.output;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Pattern;
import net.rootdev.javardfa.StatementSink;

public class NTripleSink
implements StatementSink {
    protected final PrintWriter out;
    protected final String[] comments;
    private Pattern quotePattern = Pattern.compile("\"");

    public NTripleSink(OutputStream os, String ... comments) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(os, "US-ASCII"), comments);
    }

    public NTripleSink(Writer writer, String ... comments) {
        this.out = new PrintWriter(writer);
        this.comments = comments;
    }

    public void start() {
        for (String line : this.comments) {
            this.out.print("# ");
            this.out.println(line);
        }
    }

    public void end() {
        this.out.flush();
    }

    public void addObject(String subject, String predicate, String object) {
        this.out.print(this.toNode(subject));
        this.out.print(this.toNode(predicate));
        this.out.print(this.toNode(object));
        this.out.println(".");
    }

    public void addLiteral(String subject, String predicate, String lex, String lang, String datatype) {
        this.out.print(this.toNode(subject));
        this.out.print(this.toNode(predicate));
        this.out.print(this.toLiteral(lex, lang, datatype));
        this.out.println(".");
    }

    public void addPrefix(String prefix, String uri) {
    }

    protected final String toNode(String node) {
        if (node.startsWith("_:") || node.startsWith("?")) {
            return node + " ";
        }
        return "<" + node + "> ";
    }

    protected final String toLiteral(String lex, String lang, String datatype) {
        if (lang != null && lang.length() != 0) {
            return this.quote(lex) + "@" + lang + " ";
        }
        if (datatype != null) {
            return this.quote(lex) + "^^<" + datatype + "> ";
        }
        return this.quote(lex) + " ";
    }

    protected final String quote(String lex) {
        return "\"" + this.encode(lex) + "\"";
    }

    protected final String encode(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (c <= 8) {
                b.append(this.enc(c));
                continue;
            }
            if (c == 9) {
                b.append("\\t");
                continue;
            }
            if (c == 10) {
                b.append("\\n");
                continue;
            }
            if (c == 13) {
                b.append("\\r");
                continue;
            }
            if (c == 34) {
                b.append("\\\"");
                continue;
            }
            if (c == 92) {
                b.append("\\\\");
                continue;
            }
            if (c <= 127) {
                b.appendCodePoint(c);
                continue;
            }
            if (c <= 65535) {
                b.append(this.enc(c));
                continue;
            }
            b.append(this.longenc(c));
        }
        return b.toString();
    }

    protected String enc(int codepoint) {
        return String.format("\\u%04x", codepoint);
    }

    protected String longenc(int codepoint) {
        return String.format("\\U%08x", codepoint);
    }

    public void setBase(String base) {
    }
}

