//===-- AArch64PerfectShuffle.h - AdvSIMD Perfect Shuffle Table -----------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file, which was autogenerated by llvm-PerfectShuffle, contains data
// for the optimal way to build a perfect shuffle using AdvSIMD instructions.
//
//===----------------------------------------------------------------------===//

// 31 entries have cost 0
// 242 entries have cost 1
// 1447 entries have cost 2
// 3602 entries have cost 3
// 1237 entries have cost 4
// 2 entries have cost 5

// This table is 6561*4 = 26244 bytes in size.
static const unsigned PerfectShuffleTable[6561+1] = {
  135053414U, // <0,0,0,0>: Cost 1 vdup0 LHS
  1543503974U, // <0,0,0,1>: Cost 2 vext2 <0,0,0,0>, LHS
  2618572962U, // <0,0,0,2>: Cost 3 vext2 <0,2,0,0>, <0,2,0,0>
  2568054923U, // <0,0,0,3>: Cost 3 vext1 <3,0,0,0>, <3,0,0,0>
  1476398390U, // <0,0,0,4>: Cost 2 vext1 <0,0,0,0>, RHS
  2550140624U, // <0,0,0,5>: Cost 3 vext1 <0,0,0,0>, <5,1,7,3>
  2550141434U, // <0,0,0,6>: Cost 3 vext1 <0,0,0,0>, <6,2,7,3>
  2591945711U, // <0,0,0,7>: Cost 3 vext1 <7,0,0,0>, <7,0,0,0>
  135053414U, // <0,0,0,u>: Cost 1 vdup0 LHS
  2886516736U, // <0,0,1,0>: Cost 3 vzipl LHS, <0,0,0,0>
  1812775014U, // <0,0,1,1>: Cost 2 vzipl LHS, LHS
  1618133094U, // <0,0,1,2>: Cost 2 vext3 <1,2,3,0>, LHS
  2625209292U, // <0,0,1,3>: Cost 3 vext2 <1,3,0,0>, <1,3,0,0>
  2886558034U, // <0,0,1,4>: Cost 3 vzipl LHS, <0,4,1,5>
  2617246864U, // <0,0,1,5>: Cost 3 vext2 <0,0,0,0>, <1,5,3,7>
  3659723031U, // <0,0,1,6>: Cost 4 vext1 <6,0,0,1>, <6,0,0,1>
  2591953904U, // <0,0,1,7>: Cost 3 vext1 <7,0,0,1>, <7,0,0,1>
  1812775581U, // <0,0,1,u>: Cost 2 vzipl LHS, LHS
  3020734464U, // <0,0,2,0>: Cost 3 vtrnl LHS, <0,0,0,0>
  3020734474U, // <0,0,2,1>: Cost 3 vtrnl LHS, <0,0,1,1>
  1946992742U, // <0,0,2,2>: Cost 2 vtrnl LHS, LHS
  2631181989U, // <0,0,2,3>: Cost 3 vext2 <2,3,0,0>, <2,3,0,0>
  3020734668U, // <0,0,2,4>: Cost 3 vtrnl LHS, <0,2,4,6>
  3826550569U, // <0,0,2,5>: Cost 4 vuzpl <0,2,0,2>, <2,4,5,6>
  2617247674U, // <0,0,2,6>: Cost 3 vext2 <0,0,0,0>, <2,6,3,7>
  2591962097U, // <0,0,2,7>: Cost 3 vext1 <7,0,0,2>, <7,0,0,2>
  1946992796U, // <0,0,2,u>: Cost 2 vtrnl LHS, LHS
  2635163787U, // <0,0,3,0>: Cost 3 vext2 <3,0,0,0>, <3,0,0,0>
  2686419196U, // <0,0,3,1>: Cost 3 vext3 <0,3,1,0>, <0,3,1,0>
  2686492933U, // <0,0,3,2>: Cost 3 vext3 <0,3,2,0>, <0,3,2,0>
  2617248156U, // <0,0,3,3>: Cost 3 vext2 <0,0,0,0>, <3,3,3,3>
  2617248258U, // <0,0,3,4>: Cost 3 vext2 <0,0,0,0>, <3,4,5,6>
  3826551298U, // <0,0,3,5>: Cost 4 vuzpl <0,2,0,2>, <3,4,5,6>
  3690990200U, // <0,0,3,6>: Cost 4 vext2 <0,0,0,0>, <3,6,0,7>
  3713551042U, // <0,0,3,7>: Cost 4 vext2 <3,7,0,0>, <3,7,0,0>
  2635163787U, // <0,0,3,u>: Cost 3 vext2 <3,0,0,0>, <3,0,0,0>
  2617248658U, // <0,0,4,0>: Cost 3 vext2 <0,0,0,0>, <4,0,5,1>
  2888450150U, // <0,0,4,1>: Cost 3 vzipl <0,4,1,5>, LHS
  3021570150U, // <0,0,4,2>: Cost 3 vtrnl <0,2,4,6>, LHS
  3641829519U, // <0,0,4,3>: Cost 4 vext1 <3,0,0,4>, <3,0,0,4>
  3021570252U, // <0,0,4,4>: Cost 3 vtrnl <0,2,4,6>, <0,2,4,6>
  1543507254U, // <0,0,4,5>: Cost 2 vext2 <0,0,0,0>, RHS
  2752810294U, // <0,0,4,6>: Cost 3 vuzpl <0,2,0,2>, RHS
  3786998152U, // <0,0,4,7>: Cost 4 vext3 <4,7,5,0>, <0,4,7,5>
  1543507497U, // <0,0,4,u>: Cost 2 vext2 <0,0,0,0>, RHS
  2684354972U, // <0,0,5,0>: Cost 3 vext3 <0,0,0,0>, <0,5,0,7>
  2617249488U, // <0,0,5,1>: Cost 3 vext2 <0,0,0,0>, <5,1,7,3>
  3765617070U, // <0,0,5,2>: Cost 4 vext3 <1,2,3,0>, <0,5,2,7>
  3635865780U, // <0,0,5,3>: Cost 4 vext1 <2,0,0,5>, <3,0,4,5>
  2617249734U, // <0,0,5,4>: Cost 3 vext2 <0,0,0,0>, <5,4,7,6>
  2617249796U, // <0,0,5,5>: Cost 3 vext2 <0,0,0,0>, <5,5,5,5>
  2718712274U, // <0,0,5,6>: Cost 3 vext3 <5,6,7,0>, <0,5,6,7>
  2617249960U, // <0,0,5,7>: Cost 3 vext2 <0,0,0,0>, <5,7,5,7>
  2720039396U, // <0,0,5,u>: Cost 3 vext3 <5,u,7,0>, <0,5,u,7>
  2684355053U, // <0,0,6,0>: Cost 3 vext3 <0,0,0,0>, <0,6,0,7>
  3963609190U, // <0,0,6,1>: Cost 4 vzipl <0,6,2,7>, LHS
  2617250298U, // <0,0,6,2>: Cost 3 vext2 <0,0,0,0>, <6,2,7,3>
  3796435464U, // <0,0,6,3>: Cost 4 vext3 <6,3,7,0>, <0,6,3,7>
  3659762998U, // <0,0,6,4>: Cost 4 vext1 <6,0,0,6>, RHS
  3659763810U, // <0,0,6,5>: Cost 4 vext1 <6,0,0,6>, <5,6,7,0>
  2617250616U, // <0,0,6,6>: Cost 3 vext2 <0,0,0,0>, <6,6,6,6>
  2657727309U, // <0,0,6,7>: Cost 3 vext2 <6,7,0,0>, <6,7,0,0>
  2658390942U, // <0,0,6,u>: Cost 3 vext2 <6,u,0,0>, <6,u,0,0>
  2659054575U, // <0,0,7,0>: Cost 3 vext2 <7,0,0,0>, <7,0,0,0>
  3635880854U, // <0,0,7,1>: Cost 4 vext1 <2,0,0,7>, <1,2,3,0>
  3635881401U, // <0,0,7,2>: Cost 4 vext1 <2,0,0,7>, <2,0,0,7>
  3734787298U, // <0,0,7,3>: Cost 4 vext2 <7,3,0,0>, <7,3,0,0>
  2617251174U, // <0,0,7,4>: Cost 3 vext2 <0,0,0,0>, <7,4,5,6>
  3659772002U, // <0,0,7,5>: Cost 4 vext1 <6,0,0,7>, <5,6,7,0>
  3659772189U, // <0,0,7,6>: Cost 4 vext1 <6,0,0,7>, <6,0,0,7>
  2617251436U, // <0,0,7,7>: Cost 3 vext2 <0,0,0,0>, <7,7,7,7>
  2659054575U, // <0,0,7,u>: Cost 3 vext2 <7,0,0,0>, <7,0,0,0>
  135053414U, // <0,0,u,0>: Cost 1 vdup0 LHS
  1817419878U, // <0,0,u,1>: Cost 2 vzipl LHS, LHS
  1947435110U, // <0,0,u,2>: Cost 2 vtrnl LHS, LHS
  2568120467U, // <0,0,u,3>: Cost 3 vext1 <3,0,0,u>, <3,0,0,u>
  1476463926U, // <0,0,u,4>: Cost 2 vext1 <0,0,0,u>, RHS
  1543510170U, // <0,0,u,5>: Cost 2 vext2 <0,0,0,0>, RHS
  2752813210U, // <0,0,u,6>: Cost 3 vuzpl <0,2,0,2>, RHS
  2592011255U, // <0,0,u,7>: Cost 3 vext1 <7,0,0,u>, <7,0,0,u>
  135053414U, // <0,0,u,u>: Cost 1 vdup0 LHS
  2618581002U, // <0,1,0,0>: Cost 3 vext2 <0,2,0,1>, <0,0,1,1>
  1557446758U, // <0,1,0,1>: Cost 2 vext2 <2,3,0,1>, LHS
  2618581155U, // <0,1,0,2>: Cost 3 vext2 <0,2,0,1>, <0,2,0,1>
  2690548468U, // <0,1,0,3>: Cost 3 vext3 <1,0,3,0>, <1,0,3,0>
  2626543954U, // <0,1,0,4>: Cost 3 vext2 <1,5,0,1>, <0,4,1,5>
  4094985216U, // <0,1,0,5>: Cost 4 vtrnl <0,2,0,2>, <1,3,5,7>
  2592019278U, // <0,1,0,6>: Cost 3 vext1 <7,0,1,0>, <6,7,0,1>
  2592019448U, // <0,1,0,7>: Cost 3 vext1 <7,0,1,0>, <7,0,1,0>
  1557447325U, // <0,1,0,u>: Cost 2 vext2 <2,3,0,1>, LHS
  1476476938U, // <0,1,1,0>: Cost 2 vext1 <0,0,1,1>, <0,0,1,1>
  2886517556U, // <0,1,1,1>: Cost 3 vzipl LHS, <1,1,1,1>
  2886517654U, // <0,1,1,2>: Cost 3 vzipl LHS, <1,2,3,0>
  2886517720U, // <0,1,1,3>: Cost 3 vzipl LHS, <1,3,1,3>
  1476480310U, // <0,1,1,4>: Cost 2 vext1 <0,0,1,1>, RHS
  2886558864U, // <0,1,1,5>: Cost 3 vzipl LHS, <1,5,3,7>
  2550223354U, // <0,1,1,6>: Cost 3 vext1 <0,0,1,1>, <6,2,7,3>
  2550223856U, // <0,1,1,7>: Cost 3 vext1 <0,0,1,1>, <7,0,0,1>
  1476482862U, // <0,1,1,u>: Cost 2 vext1 <0,0,1,1>, LHS
  1494401126U, // <0,1,2,0>: Cost 2 vext1 <3,0,1,2>, LHS
  3020735284U, // <0,1,2,1>: Cost 3 vtrnl LHS, <1,1,1,1>
  2562172349U, // <0,1,2,2>: Cost 3 vext1 <2,0,1,2>, <2,0,1,2>
  835584U, // <0,1,2,3>: Cost 0 copy LHS
  1494404406U, // <0,1,2,4>: Cost 2 vext1 <3,0,1,2>, RHS
  3020735488U, // <0,1,2,5>: Cost 3 vtrnl LHS, <1,3,5,7>
  2631190458U, // <0,1,2,6>: Cost 3 vext2 <2,3,0,1>, <2,6,3,7>
  1518294010U, // <0,1,2,7>: Cost 2 vext1 <7,0,1,2>, <7,0,1,2>
  835584U, // <0,1,2,u>: Cost 0 copy LHS
  2692318156U, // <0,1,3,0>: Cost 3 vext3 <1,3,0,0>, <1,3,0,0>
  2691875800U, // <0,1,3,1>: Cost 3 vext3 <1,2,3,0>, <1,3,1,3>
  2691875806U, // <0,1,3,2>: Cost 3 vext3 <1,2,3,0>, <1,3,2,0>
  2692539367U, // <0,1,3,3>: Cost 3 vext3 <1,3,3,0>, <1,3,3,0>
  2562182454U, // <0,1,3,4>: Cost 3 vext1 <2,0,1,3>, RHS
  2691875840U, // <0,1,3,5>: Cost 3 vext3 <1,2,3,0>, <1,3,5,7>
  2692760578U, // <0,1,3,6>: Cost 3 vext3 <1,3,6,0>, <1,3,6,0>
  2639817411U, // <0,1,3,7>: Cost 3 vext2 <3,7,0,1>, <3,7,0,1>
  2691875863U, // <0,1,3,u>: Cost 3 vext3 <1,2,3,0>, <1,3,u,3>
  2568159334U, // <0,1,4,0>: Cost 3 vext1 <3,0,1,4>, LHS
  4095312692U, // <0,1,4,1>: Cost 4 vtrnl <0,2,4,6>, <1,1,1,1>
  2568160934U, // <0,1,4,2>: Cost 3 vext1 <3,0,1,4>, <2,3,0,1>
  2568161432U, // <0,1,4,3>: Cost 3 vext1 <3,0,1,4>, <3,0,1,4>
  2568162614U, // <0,1,4,4>: Cost 3 vext1 <3,0,1,4>, RHS
  1557450038U, // <0,1,4,5>: Cost 2 vext2 <2,3,0,1>, RHS
  2754235702U, // <0,1,4,6>: Cost 3 vuzpl <0,4,1,5>, RHS
  2592052220U, // <0,1,4,7>: Cost 3 vext1 <7,0,1,4>, <7,0,1,4>
  1557450281U, // <0,1,4,u>: Cost 2 vext2 <2,3,0,1>, RHS
  3765617775U, // <0,1,5,0>: Cost 4 vext3 <1,2,3,0>, <1,5,0,1>
  2647781007U, // <0,1,5,1>: Cost 3 vext2 <5,1,0,1>, <5,1,0,1>
  3704934138U, // <0,1,5,2>: Cost 4 vext2 <2,3,0,1>, <5,2,3,0>
  2691875984U, // <0,1,5,3>: Cost 3 vext3 <1,2,3,0>, <1,5,3,7>
  2657734598U, // <0,1,5,4>: Cost 3 vext2 <6,7,0,1>, <5,4,7,6>
  2650435539U, // <0,1,5,5>: Cost 3 vext2 <5,5,0,1>, <5,5,0,1>
  2651099172U, // <0,1,5,6>: Cost 3 vext2 <5,6,0,1>, <5,6,0,1>
  2651762805U, // <0,1,5,7>: Cost 3 vext2 <5,7,0,1>, <5,7,0,1>
  2691876029U, // <0,1,5,u>: Cost 3 vext3 <1,2,3,0>, <1,5,u,7>
  2592063590U, // <0,1,6,0>: Cost 3 vext1 <7,0,1,6>, LHS
  3765617871U, // <0,1,6,1>: Cost 4 vext3 <1,2,3,0>, <1,6,1,7>
  2654417337U, // <0,1,6,2>: Cost 3 vext2 <6,2,0,1>, <6,2,0,1>
  3765617889U, // <0,1,6,3>: Cost 4 vext3 <1,2,3,0>, <1,6,3,7>
  2592066870U, // <0,1,6,4>: Cost 3 vext1 <7,0,1,6>, RHS
  3765617907U, // <0,1,6,5>: Cost 4 vext3 <1,2,3,0>, <1,6,5,7>
  2657071869U, // <0,1,6,6>: Cost 3 vext2 <6,6,0,1>, <6,6,0,1>
  1583993678U, // <0,1,6,7>: Cost 2 vext2 <6,7,0,1>, <6,7,0,1>
  1584657311U, // <0,1,6,u>: Cost 2 vext2 <6,u,0,1>, <6,u,0,1>
  2657735672U, // <0,1,7,0>: Cost 3 vext2 <6,7,0,1>, <7,0,1,0>
  2657735808U, // <0,1,7,1>: Cost 3 vext2 <6,7,0,1>, <7,1,7,1>
  2631193772U, // <0,1,7,2>: Cost 3 vext2 <2,3,0,1>, <7,2,3,0>
  2661053667U, // <0,1,7,3>: Cost 3 vext2 <7,3,0,1>, <7,3,0,1>
  2657736038U, // <0,1,7,4>: Cost 3 vext2 <6,7,0,1>, <7,4,5,6>
  3721524621U, // <0,1,7,5>: Cost 4 vext2 <5,1,0,1>, <7,5,1,0>
  2657736158U, // <0,1,7,6>: Cost 3 vext2 <6,7,0,1>, <7,6,1,0>
  2657736300U, // <0,1,7,7>: Cost 3 vext2 <6,7,0,1>, <7,7,7,7>
  2657736322U, // <0,1,7,u>: Cost 3 vext2 <6,7,0,1>, <7,u,1,2>
  1494450278U, // <0,1,u,0>: Cost 2 vext1 <3,0,1,u>, LHS
  1557452590U, // <0,1,u,1>: Cost 2 vext2 <2,3,0,1>, LHS
  2754238254U, // <0,1,u,2>: Cost 3 vuzpl <0,4,1,5>, LHS
  835584U, // <0,1,u,3>: Cost 0 copy LHS
  1494453558U, // <0,1,u,4>: Cost 2 vext1 <3,0,1,u>, RHS
  1557452954U, // <0,1,u,5>: Cost 2 vext2 <2,3,0,1>, RHS
  2754238618U, // <0,1,u,6>: Cost 3 vuzpl <0,4,1,5>, RHS
  1518343168U, // <0,1,u,7>: Cost 2 vext1 <7,0,1,u>, <7,0,1,u>
  835584U, // <0,1,u,u>: Cost 0 copy LHS
  2752299008U, // <0,2,0,0>: Cost 3 vuzpl LHS, <0,0,0,0>
  1544847462U, // <0,2,0,1>: Cost 2 vext2 <0,2,0,2>, LHS
  1678557286U, // <0,2,0,2>: Cost 2 vuzpl LHS, LHS
  2696521165U, // <0,2,0,3>: Cost 3 vext3 <2,0,3,0>, <2,0,3,0>
  2752340172U, // <0,2,0,4>: Cost 3 vuzpl LHS, <0,2,4,6>
  2691876326U, // <0,2,0,5>: Cost 3 vext3 <1,2,3,0>, <2,0,5,7>
  2618589695U, // <0,2,0,6>: Cost 3 vext2 <0,2,0,2>, <0,6,2,7>
  2592093185U, // <0,2,0,7>: Cost 3 vext1 <7,0,2,0>, <7,0,2,0>
  1678557340U, // <0,2,0,u>: Cost 2 vuzpl LHS, LHS
  2618589942U, // <0,2,1,0>: Cost 3 vext2 <0,2,0,2>, <1,0,3,2>
  2752299828U, // <0,2,1,1>: Cost 3 vuzpl LHS, <1,1,1,1>
  2886518376U, // <0,2,1,2>: Cost 3 vzipl LHS, <2,2,2,2>
  2752299766U, // <0,2,1,3>: Cost 3 vuzpl LHS, <1,0,3,2>
  2550295862U, // <0,2,1,4>: Cost 3 vext1 <0,0,2,1>, RHS
  2752340992U, // <0,2,1,5>: Cost 3 vuzpl LHS, <1,3,5,7>
  2886559674U, // <0,2,1,6>: Cost 3 vzipl LHS, <2,6,3,7>
  3934208106U, // <0,2,1,7>: Cost 4 vuzpr <7,0,1,2>, <0,1,2,7>
  2752340771U, // <0,2,1,u>: Cost 3 vuzpl LHS, <1,0,u,2>
  1476558868U, // <0,2,2,0>: Cost 2 vext1 <0,0,2,2>, <0,0,2,2>
  2226628029U, // <0,2,2,1>: Cost 3 vrev <2,0,1,2>
  2752300648U, // <0,2,2,2>: Cost 3 vuzpl LHS, <2,2,2,2>
  3020736114U, // <0,2,2,3>: Cost 3 vtrnl LHS, <2,2,3,3>
  1476562230U, // <0,2,2,4>: Cost 2 vext1 <0,0,2,2>, RHS
  2550304464U, // <0,2,2,5>: Cost 3 vext1 <0,0,2,2>, <5,1,7,3>
  2618591162U, // <0,2,2,6>: Cost 3 vext2 <0,2,0,2>, <2,6,3,7>
  2550305777U, // <0,2,2,7>: Cost 3 vext1 <0,0,2,2>, <7,0,0,2>
  1476564782U, // <0,2,2,u>: Cost 2 vext1 <0,0,2,2>, LHS
  2618591382U, // <0,2,3,0>: Cost 3 vext2 <0,2,0,2>, <3,0,1,2>
  2752301206U, // <0,2,3,1>: Cost 3 vuzpl LHS, <3,0,1,2>
  3826043121U, // <0,2,3,2>: Cost 4 vuzpl LHS, <3,1,2,3>
  2752301468U, // <0,2,3,3>: Cost 3 vuzpl LHS, <3,3,3,3>
  2618591746U, // <0,2,3,4>: Cost 3 vext2 <0,2,0,2>, <3,4,5,6>
  2752301570U, // <0,2,3,5>: Cost 3 vuzpl LHS, <3,4,5,6>
  3830688102U, // <0,2,3,6>: Cost 4 vuzpl LHS, <3,2,6,3>
  2698807012U, // <0,2,3,7>: Cost 3 vext3 <2,3,7,0>, <2,3,7,0>
  2752301269U, // <0,2,3,u>: Cost 3 vuzpl LHS, <3,0,u,2>
  2562261094U, // <0,2,4,0>: Cost 3 vext1 <2,0,2,4>, LHS
  4095313828U, // <0,2,4,1>: Cost 4 vtrnl <0,2,4,6>, <2,6,1,3>
  2226718152U, // <0,2,4,2>: Cost 3 vrev <2,0,2,4>
  2568235169U, // <0,2,4,3>: Cost 3 vext1 <3,0,2,4>, <3,0,2,4>
  2562264374U, // <0,2,4,4>: Cost 3 vext1 <2,0,2,4>, RHS
  1544850742U, // <0,2,4,5>: Cost 2 vext2 <0,2,0,2>, RHS
  1678560566U, // <0,2,4,6>: Cost 2 vuzpl LHS, RHS
  2592125957U, // <0,2,4,7>: Cost 3 vext1 <7,0,2,4>, <7,0,2,4>
  1678560584U, // <0,2,4,u>: Cost 2 vuzpl LHS, RHS
  2691876686U, // <0,2,5,0>: Cost 3 vext3 <1,2,3,0>, <2,5,0,7>
  2618592976U, // <0,2,5,1>: Cost 3 vext2 <0,2,0,2>, <5,1,7,3>
  3765618528U, // <0,2,5,2>: Cost 4 vext3 <1,2,3,0>, <2,5,2,7>
  3765618536U, // <0,2,5,3>: Cost 4 vext3 <1,2,3,0>, <2,5,3,6>
  2618593222U, // <0,2,5,4>: Cost 3 vext2 <0,2,0,2>, <5,4,7,6>
  2752303108U, // <0,2,5,5>: Cost 3 vuzpl LHS, <5,5,5,5>
  2618593378U, // <0,2,5,6>: Cost 3 vext2 <0,2,0,2>, <5,6,7,0>
  2824785206U, // <0,2,5,7>: Cost 3 vuzpr <1,0,3,2>, RHS
  2824785207U, // <0,2,5,u>: Cost 3 vuzpr <1,0,3,2>, RHS
  2752303950U, // <0,2,6,0>: Cost 3 vuzpl LHS, <6,7,0,1>
  3830690081U, // <0,2,6,1>: Cost 4 vuzpl LHS, <6,0,1,2>
  2618593786U, // <0,2,6,2>: Cost 3 vext2 <0,2,0,2>, <6,2,7,3>
  2691876794U, // <0,2,6,3>: Cost 3 vext3 <1,2,3,0>, <2,6,3,7>
  2752303990U, // <0,2,6,4>: Cost 3 vuzpl LHS, <6,7,4,5>
  3830690445U, // <0,2,6,5>: Cost 4 vuzpl LHS, <6,4,5,6>
  2752303928U, // <0,2,6,6>: Cost 3 vuzpl LHS, <6,6,6,6>
  2657743695U, // <0,2,6,7>: Cost 3 vext2 <6,7,0,2>, <6,7,0,2>
  2691876839U, // <0,2,6,u>: Cost 3 vext3 <1,2,3,0>, <2,6,u,7>
  2659070961U, // <0,2,7,0>: Cost 3 vext2 <7,0,0,2>, <7,0,0,2>
  2659734594U, // <0,2,7,1>: Cost 3 vext2 <7,1,0,2>, <7,1,0,2>
  3734140051U, // <0,2,7,2>: Cost 4 vext2 <7,2,0,2>, <7,2,0,2>
  2701166596U, // <0,2,7,3>: Cost 3 vext3 <2,7,3,0>, <2,7,3,0>
  2662389094U, // <0,2,7,4>: Cost 3 vext2 <7,5,0,2>, <7,4,5,6>
  2662389126U, // <0,2,7,5>: Cost 3 vext2 <7,5,0,2>, <7,5,0,2>
  3736794583U, // <0,2,7,6>: Cost 4 vext2 <7,6,0,2>, <7,6,0,2>
  2752304748U, // <0,2,7,7>: Cost 3 vuzpl LHS, <7,7,7,7>
  2659070961U, // <0,2,7,u>: Cost 3 vext2 <7,0,0,2>, <7,0,0,2>
  1476608026U, // <0,2,u,0>: Cost 2 vext1 <0,0,2,u>, <0,0,2,u>
  1544853294U, // <0,2,u,1>: Cost 2 vext2 <0,2,0,2>, LHS
  1678563118U, // <0,2,u,2>: Cost 2 vuzpl LHS, LHS
  3021178482U, // <0,2,u,3>: Cost 3 vtrnl LHS, <2,2,3,3>
  1476611382U, // <0,2,u,4>: Cost 2 vext1 <0,0,2,u>, RHS
  1544853658U, // <0,2,u,5>: Cost 2 vext2 <0,2,0,2>, RHS
  1678563482U, // <0,2,u,6>: Cost 2 vuzpl LHS, RHS
  2824785449U, // <0,2,u,7>: Cost 3 vuzpr <1,0,3,2>, RHS
  1678563172U, // <0,2,u,u>: Cost 2 vuzpl LHS, LHS
  2556329984U, // <0,3,0,0>: Cost 3 vext1 <1,0,3,0>, <0,0,0,0>
  2686421142U, // <0,3,0,1>: Cost 3 vext3 <0,3,1,0>, <3,0,1,2>
  2562303437U, // <0,3,0,2>: Cost 3 vext1 <2,0,3,0>, <2,0,3,0>
  4094986652U, // <0,3,0,3>: Cost 4 vtrnl <0,2,0,2>, <3,3,3,3>
  2556333366U, // <0,3,0,4>: Cost 3 vext1 <1,0,3,0>, RHS
  4094986754U, // <0,3,0,5>: Cost 4 vtrnl <0,2,0,2>, <3,4,5,6>
  3798796488U, // <0,3,0,6>: Cost 4 vext3 <6,7,3,0>, <3,0,6,7>
  3776530634U, // <0,3,0,7>: Cost 4 vext3 <3,0,7,0>, <3,0,7,0>
  2556335918U, // <0,3,0,u>: Cost 3 vext1 <1,0,3,0>, LHS
  2886518934U, // <0,3,1,0>: Cost 3 vzipl LHS, <3,0,1,2>
  2556338933U, // <0,3,1,1>: Cost 3 vext1 <1,0,3,1>, <1,0,3,1>
  2691877105U, // <0,3,1,2>: Cost 3 vext3 <1,2,3,0>, <3,1,2,3>
  2886519196U, // <0,3,1,3>: Cost 3 vzipl LHS, <3,3,3,3>
  2886519298U, // <0,3,1,4>: Cost 3 vzipl LHS, <3,4,5,6>
  4095740418U, // <0,3,1,5>: Cost 4 vtrnl <0,3,1,4>, <3,4,5,6>
  3659944242U, // <0,3,1,6>: Cost 4 vext1 <6,0,3,1>, <6,0,3,1>
  3769600286U, // <0,3,1,7>: Cost 4 vext3 <1,u,3,0>, <3,1,7,3>
  2886519582U, // <0,3,1,u>: Cost 3 vzipl LHS, <3,u,1,2>
  1482604646U, // <0,3,2,0>: Cost 2 vext1 <1,0,3,2>, LHS
  1482605302U, // <0,3,2,1>: Cost 2 vext1 <1,0,3,2>, <1,0,3,2>
  2556348008U, // <0,3,2,2>: Cost 3 vext1 <1,0,3,2>, <2,2,2,2>
  3020736924U, // <0,3,2,3>: Cost 3 vtrnl LHS, <3,3,3,3>
  1482607926U, // <0,3,2,4>: Cost 2 vext1 <1,0,3,2>, RHS
  3020737026U, // <0,3,2,5>: Cost 3 vtrnl LHS, <3,4,5,6>
  2598154746U, // <0,3,2,6>: Cost 3 vext1 <u,0,3,2>, <6,2,7,3>
  2598155258U, // <0,3,2,7>: Cost 3 vext1 <u,0,3,2>, <7,0,1,2>
  1482610478U, // <0,3,2,u>: Cost 2 vext1 <1,0,3,2>, LHS
  3692341398U, // <0,3,3,0>: Cost 4 vext2 <0,2,0,3>, <3,0,1,2>
  2635851999U, // <0,3,3,1>: Cost 3 vext2 <3,1,0,3>, <3,1,0,3>
  3636069840U, // <0,3,3,2>: Cost 4 vext1 <2,0,3,3>, <2,0,3,3>
  2691877276U, // <0,3,3,3>: Cost 3 vext3 <1,2,3,0>, <3,3,3,3>
  3961522690U, // <0,3,3,4>: Cost 4 vzipl <0,3,1,4>, <3,4,5,6>
  3826797058U, // <0,3,3,5>: Cost 4 vuzpl <0,2,3,5>, <3,4,5,6>
  3703622282U, // <0,3,3,6>: Cost 4 vext2 <2,1,0,3>, <3,6,2,7>
  3769600452U, // <0,3,3,7>: Cost 4 vext3 <1,u,3,0>, <3,3,7,7>
  2640497430U, // <0,3,3,u>: Cost 3 vext2 <3,u,0,3>, <3,u,0,3>
  3962194070U, // <0,3,4,0>: Cost 4 vzipl <0,4,1,5>, <3,0,1,2>
  2232617112U, // <0,3,4,1>: Cost 3 vrev <3,0,1,4>
  2232690849U, // <0,3,4,2>: Cost 3 vrev <3,0,2,4>
  4095314332U, // <0,3,4,3>: Cost 4 vtrnl <0,2,4,6>, <3,3,3,3>
  3962194434U, // <0,3,4,4>: Cost 4 vzipl <0,4,1,5>, <3,4,5,6>
  2691877378U, // <0,3,4,5>: Cost 3 vext3 <1,2,3,0>, <3,4,5,6>
  3826765110U, // <0,3,4,6>: Cost 4 vuzpl <0,2,3,1>, RHS
  3665941518U, // <0,3,4,7>: Cost 4 vext1 <7,0,3,4>, <7,0,3,4>
  2691877405U, // <0,3,4,u>: Cost 3 vext3 <1,2,3,0>, <3,4,u,6>
  3630112870U, // <0,3,5,0>: Cost 4 vext1 <1,0,3,5>, LHS
  3630113526U, // <0,3,5,1>: Cost 4 vext1 <1,0,3,5>, <1,0,3,2>
  4035199734U, // <0,3,5,2>: Cost 4 vzipr <1,4,0,5>, <1,0,3,2>
  3769600578U, // <0,3,5,3>: Cost 4 vext3 <1,u,3,0>, <3,5,3,7>
  2232846516U, // <0,3,5,4>: Cost 3 vrev <3,0,4,5>
  3779037780U, // <0,3,5,5>: Cost 4 vext3 <3,4,5,0>, <3,5,5,7>
  2718714461U, // <0,3,5,6>: Cost 3 vext3 <5,6,7,0>, <3,5,6,7>
  2706106975U, // <0,3,5,7>: Cost 3 vext3 <3,5,7,0>, <3,5,7,0>
  2233141464U, // <0,3,5,u>: Cost 3 vrev <3,0,u,5>
  2691877496U, // <0,3,6,0>: Cost 3 vext3 <1,2,3,0>, <3,6,0,7>
  3727511914U, // <0,3,6,1>: Cost 4 vext2 <6,1,0,3>, <6,1,0,3>
  3765619338U, // <0,3,6,2>: Cost 4 vext3 <1,2,3,0>, <3,6,2,7>
  3765619347U, // <0,3,6,3>: Cost 4 vext3 <1,2,3,0>, <3,6,3,7>
  3765987996U, // <0,3,6,4>: Cost 4 vext3 <1,2,u,0>, <3,6,4,7>
  3306670270U, // <0,3,6,5>: Cost 4 vrev <3,0,5,6>
  3792456365U, // <0,3,6,6>: Cost 4 vext3 <5,6,7,0>, <3,6,6,6>
  2706770608U, // <0,3,6,7>: Cost 3 vext3 <3,6,7,0>, <3,6,7,0>
  2706844345U, // <0,3,6,u>: Cost 3 vext3 <3,6,u,0>, <3,6,u,0>
  3769600707U, // <0,3,7,0>: Cost 4 vext3 <1,u,3,0>, <3,7,0,1>
  2659742787U, // <0,3,7,1>: Cost 3 vext2 <7,1,0,3>, <7,1,0,3>
  3636102612U, // <0,3,7,2>: Cost 4 vext1 <2,0,3,7>, <2,0,3,7>
  3769600740U, // <0,3,7,3>: Cost 4 vext3 <1,u,3,0>, <3,7,3,7>
  3769600747U, // <0,3,7,4>: Cost 4 vext3 <1,u,3,0>, <3,7,4,5>
  3769600758U, // <0,3,7,5>: Cost 4 vext3 <1,u,3,0>, <3,7,5,7>
  3659993400U, // <0,3,7,6>: Cost 4 vext1 <6,0,3,7>, <6,0,3,7>
  3781176065U, // <0,3,7,7>: Cost 4 vext3 <3,7,7,0>, <3,7,7,0>
  2664388218U, // <0,3,7,u>: Cost 3 vext2 <7,u,0,3>, <7,u,0,3>
  1482653798U, // <0,3,u,0>: Cost 2 vext1 <1,0,3,u>, LHS
  1482654460U, // <0,3,u,1>: Cost 2 vext1 <1,0,3,u>, <1,0,3,u>
  2556397160U, // <0,3,u,2>: Cost 3 vext1 <1,0,3,u>, <2,2,2,2>
  3021179292U, // <0,3,u,3>: Cost 3 vtrnl LHS, <3,3,3,3>
  1482657078U, // <0,3,u,4>: Cost 2 vext1 <1,0,3,u>, RHS
  3021179394U, // <0,3,u,5>: Cost 3 vtrnl LHS, <3,4,5,6>
  2598203898U, // <0,3,u,6>: Cost 3 vext1 <u,0,3,u>, <6,2,7,3>
  2708097874U, // <0,3,u,7>: Cost 3 vext3 <3,u,7,0>, <3,u,7,0>
  1482659630U, // <0,3,u,u>: Cost 2 vext1 <1,0,3,u>, LHS
  2617278468U, // <0,4,0,0>: Cost 3 vext2 <0,0,0,4>, <0,0,0,4>
  2618605670U, // <0,4,0,1>: Cost 3 vext2 <0,2,0,4>, LHS
  2618605734U, // <0,4,0,2>: Cost 3 vext2 <0,2,0,4>, <0,2,0,4>
  3642091695U, // <0,4,0,3>: Cost 4 vext1 <3,0,4,0>, <3,0,4,0>
  2753134796U, // <0,4,0,4>: Cost 3 vuzpl <0,2,4,6>, <0,2,4,6>
  2718714770U, // <0,4,0,5>: Cost 3 vext3 <5,6,7,0>, <4,0,5,1>
  3021245750U, // <0,4,0,6>: Cost 3 vtrnl <0,2,0,2>, RHS
  3665982483U, // <0,4,0,7>: Cost 4 vext1 <7,0,4,0>, <7,0,4,0>
  3021245768U, // <0,4,0,u>: Cost 3 vtrnl <0,2,0,2>, RHS
  2568355942U, // <0,4,1,0>: Cost 3 vext1 <3,0,4,1>, LHS
  3692348212U, // <0,4,1,1>: Cost 4 vext2 <0,2,0,4>, <1,1,1,1>
  3692348310U, // <0,4,1,2>: Cost 4 vext2 <0,2,0,4>, <1,2,3,0>
  2568358064U, // <0,4,1,3>: Cost 3 vext1 <3,0,4,1>, <3,0,4,1>
  2568359222U, // <0,4,1,4>: Cost 3 vext1 <3,0,4,1>, RHS
  1812778294U, // <0,4,1,5>: Cost 2 vzipl LHS, RHS
  3022671158U, // <0,4,1,6>: Cost 3 vtrnl <0,4,1,5>, RHS
  2592248852U, // <0,4,1,7>: Cost 3 vext1 <7,0,4,1>, <7,0,4,1>
  1812778537U, // <0,4,1,u>: Cost 2 vzipl LHS, RHS
  2568364134U, // <0,4,2,0>: Cost 3 vext1 <3,0,4,2>, LHS
  2238573423U, // <0,4,2,1>: Cost 3 vrev <4,0,1,2>
  3692349032U, // <0,4,2,2>: Cost 4 vext2 <0,2,0,4>, <2,2,2,2>
  2631214761U, // <0,4,2,3>: Cost 3 vext2 <2,3,0,4>, <2,3,0,4>
  2568367414U, // <0,4,2,4>: Cost 3 vext1 <3,0,4,2>, RHS
  2887028022U, // <0,4,2,5>: Cost 3 vzipl <0,2,0,2>, RHS
  1946996022U, // <0,4,2,6>: Cost 2 vtrnl LHS, RHS
  2592257045U, // <0,4,2,7>: Cost 3 vext1 <7,0,4,2>, <7,0,4,2>
  1946996040U, // <0,4,2,u>: Cost 2 vtrnl LHS, RHS
  3692349590U, // <0,4,3,0>: Cost 4 vext2 <0,2,0,4>, <3,0,1,2>
  3826878614U, // <0,4,3,1>: Cost 4 vuzpl <0,2,4,6>, <3,0,1,2>
  3826878625U, // <0,4,3,2>: Cost 4 vuzpl <0,2,4,6>, <3,0,2,4>
  3692349852U, // <0,4,3,3>: Cost 4 vext2 <0,2,0,4>, <3,3,3,3>
  3692349954U, // <0,4,3,4>: Cost 4 vext2 <0,2,0,4>, <3,4,5,6>
  3826878978U, // <0,4,3,5>: Cost 4 vuzpl <0,2,4,6>, <3,4,5,6>
  4095200566U, // <0,4,3,6>: Cost 4 vtrnl <0,2,3,1>, RHS
  3713583814U, // <0,4,3,7>: Cost 4 vext2 <3,7,0,4>, <3,7,0,4>
  3692350238U, // <0,4,3,u>: Cost 4 vext2 <0,2,0,4>, <3,u,1,2>
  2550464552U, // <0,4,4,0>: Cost 3 vext1 <0,0,4,4>, <0,0,4,4>
  3962194914U, // <0,4,4,1>: Cost 4 vzipl <0,4,1,5>, <4,1,5,0>
  3693677631U, // <0,4,4,2>: Cost 4 vext2 <0,4,0,4>, <4,2,6,3>
  3642124467U, // <0,4,4,3>: Cost 4 vext1 <3,0,4,4>, <3,0,4,4>
  2718715088U, // <0,4,4,4>: Cost 3 vext3 <5,6,7,0>, <4,4,4,4>
  2618608950U, // <0,4,4,5>: Cost 3 vext2 <0,2,0,4>, RHS
  2753137974U, // <0,4,4,6>: Cost 3 vuzpl <0,2,4,6>, RHS
  3666015255U, // <0,4,4,7>: Cost 4 vext1 <7,0,4,4>, <7,0,4,4>
  2618609193U, // <0,4,4,u>: Cost 3 vext2 <0,2,0,4>, RHS
  2568388710U, // <0,4,5,0>: Cost 3 vext1 <3,0,4,5>, LHS
  2568389526U, // <0,4,5,1>: Cost 3 vext1 <3,0,4,5>, <1,2,3,0>
  3636159963U, // <0,4,5,2>: Cost 4 vext1 <2,0,4,5>, <2,0,4,5>
  2568390836U, // <0,4,5,3>: Cost 3 vext1 <3,0,4,5>, <3,0,4,5>
  2568391990U, // <0,4,5,4>: Cost 3 vext1 <3,0,4,5>, RHS
  2718715180U, // <0,4,5,5>: Cost 3 vext3 <5,6,7,0>, <4,5,5,6>
  1618136374U, // <0,4,5,6>: Cost 2 vext3 <1,2,3,0>, RHS
  2592281624U, // <0,4,5,7>: Cost 3 vext1 <7,0,4,5>, <7,0,4,5>
  1618136392U, // <0,4,5,u>: Cost 2 vext3 <1,2,3,0>, RHS
  2550480938U, // <0,4,6,0>: Cost 3 vext1 <0,0,4,6>, <0,0,4,6>
  3826880801U, // <0,4,6,1>: Cost 4 vuzpl <0,2,4,6>, <6,0,1,2>
  2562426332U, // <0,4,6,2>: Cost 3 vext1 <2,0,4,6>, <2,0,4,6>
  3786190181U, // <0,4,6,3>: Cost 4 vext3 <4,6,3,0>, <4,6,3,0>
  2718715252U, // <0,4,6,4>: Cost 3 vext3 <5,6,7,0>, <4,6,4,6>
  3826881165U, // <0,4,6,5>: Cost 4 vuzpl <0,2,4,6>, <6,4,5,6>
  2712669568U, // <0,4,6,6>: Cost 3 vext3 <4,6,6,0>, <4,6,6,0>
  2657760081U, // <0,4,6,7>: Cost 3 vext2 <6,7,0,4>, <6,7,0,4>
  2718715284U, // <0,4,6,u>: Cost 3 vext3 <5,6,7,0>, <4,6,u,2>
  3654090854U, // <0,4,7,0>: Cost 4 vext1 <5,0,4,7>, LHS
  3934229326U, // <0,4,7,1>: Cost 4 vuzpr <7,0,1,4>, <6,7,0,1>
  3734156437U, // <0,4,7,2>: Cost 4 vext2 <7,2,0,4>, <7,2,0,4>
  3734820070U, // <0,4,7,3>: Cost 4 vext2 <7,3,0,4>, <7,3,0,4>
  3654094134U, // <0,4,7,4>: Cost 4 vext1 <5,0,4,7>, RHS
  2713259464U, // <0,4,7,5>: Cost 3 vext3 <4,7,5,0>, <4,7,5,0>
  2713333201U, // <0,4,7,6>: Cost 3 vext3 <4,7,6,0>, <4,7,6,0>
  3654095866U, // <0,4,7,7>: Cost 4 vext1 <5,0,4,7>, <7,0,1,2>
  2713259464U, // <0,4,7,u>: Cost 3 vext3 <4,7,5,0>, <4,7,5,0>
  2568413286U, // <0,4,u,0>: Cost 3 vext1 <3,0,4,u>, LHS
  2618611502U, // <0,4,u,1>: Cost 3 vext2 <0,2,0,4>, LHS
  2753140526U, // <0,4,u,2>: Cost 3 vuzpl <0,2,4,6>, LHS
  2568415415U, // <0,4,u,3>: Cost 3 vext1 <3,0,4,u>, <3,0,4,u>
  2568416566U, // <0,4,u,4>: Cost 3 vext1 <3,0,4,u>, RHS
  1817423158U, // <0,4,u,5>: Cost 2 vzipl LHS, RHS
  1947438390U, // <0,4,u,6>: Cost 2 vtrnl LHS, RHS
  2592306203U, // <0,4,u,7>: Cost 3 vext1 <7,0,4,u>, <7,0,4,u>
  1947438408U, // <0,4,u,u>: Cost 2 vtrnl LHS, RHS
  3630219264U, // <0,5,0,0>: Cost 4 vext1 <1,0,5,0>, <0,0,0,0>
  2625912934U, // <0,5,0,1>: Cost 3 vext2 <1,4,0,5>, LHS
  3692355748U, // <0,5,0,2>: Cost 4 vext2 <0,2,0,5>, <0,2,0,2>
  3693019384U, // <0,5,0,3>: Cost 4 vext2 <0,3,0,5>, <0,3,0,5>
  3630222646U, // <0,5,0,4>: Cost 4 vext1 <1,0,5,0>, RHS
  3699655062U, // <0,5,0,5>: Cost 4 vext2 <1,4,0,5>, <0,5,0,1>
  2718715508U, // <0,5,0,6>: Cost 3 vext3 <5,6,7,0>, <5,0,6,1>
  3087011126U, // <0,5,0,7>: Cost 3 vtrnr <0,0,0,0>, RHS
  2625913501U, // <0,5,0,u>: Cost 3 vext2 <1,4,0,5>, LHS
  1500659814U, // <0,5,1,0>: Cost 2 vext1 <4,0,5,1>, LHS
  2886520528U, // <0,5,1,1>: Cost 3 vzipl LHS, <5,1,7,3>
  2574403176U, // <0,5,1,2>: Cost 3 vext1 <4,0,5,1>, <2,2,2,2>
  2574403734U, // <0,5,1,3>: Cost 3 vext1 <4,0,5,1>, <3,0,1,2>
  1500662674U, // <0,5,1,4>: Cost 2 vext1 <4,0,5,1>, <4,0,5,1>
  2886520836U, // <0,5,1,5>: Cost 3 vzipl LHS, <5,5,5,5>
  2886520930U, // <0,5,1,6>: Cost 3 vzipl LHS, <5,6,7,0>
  2718715600U, // <0,5,1,7>: Cost 3 vext3 <5,6,7,0>, <5,1,7,3>
  1500665646U, // <0,5,1,u>: Cost 2 vext1 <4,0,5,1>, LHS
  2556493926U, // <0,5,2,0>: Cost 3 vext1 <1,0,5,2>, LHS
  2244546120U, // <0,5,2,1>: Cost 3 vrev <5,0,1,2>
  3692357256U, // <0,5,2,2>: Cost 4 vext2 <0,2,0,5>, <2,2,5,7>
  2568439994U, // <0,5,2,3>: Cost 3 vext1 <3,0,5,2>, <3,0,5,2>
  2556497206U, // <0,5,2,4>: Cost 3 vext1 <1,0,5,2>, RHS
  3020738564U, // <0,5,2,5>: Cost 3 vtrnl LHS, <5,5,5,5>
  4027877161U, // <0,5,2,6>: Cost 4 vzipr <0,2,0,2>, <2,4,5,6>
  3093220662U, // <0,5,2,7>: Cost 3 vtrnr <1,0,3,2>, RHS
  3093220663U, // <0,5,2,u>: Cost 3 vtrnr <1,0,3,2>, RHS
  3699656854U, // <0,5,3,0>: Cost 4 vext2 <1,4,0,5>, <3,0,1,2>
  3699656927U, // <0,5,3,1>: Cost 4 vext2 <1,4,0,5>, <3,1,0,3>
  3699657006U, // <0,5,3,2>: Cost 4 vext2 <1,4,0,5>, <3,2,0,1>
  3699657116U, // <0,5,3,3>: Cost 4 vext2 <1,4,0,5>, <3,3,3,3>
  2637859284U, // <0,5,3,4>: Cost 3 vext2 <3,4,0,5>, <3,4,0,5>
  3790319453U, // <0,5,3,5>: Cost 4 vext3 <5,3,5,0>, <5,3,5,0>
  3699657354U, // <0,5,3,6>: Cost 4 vext2 <1,4,0,5>, <3,6,2,7>
  2716725103U, // <0,5,3,7>: Cost 3 vext3 <5,3,7,0>, <5,3,7,0>
  2716798840U, // <0,5,3,u>: Cost 3 vext3 <5,3,u,0>, <5,3,u,0>
  2661747602U, // <0,5,4,0>: Cost 3 vext2 <7,4,0,5>, <4,0,5,1>
  3630252810U, // <0,5,4,1>: Cost 4 vext1 <1,0,5,4>, <1,0,5,4>
  3636225507U, // <0,5,4,2>: Cost 4 vext1 <2,0,5,4>, <2,0,5,4>
  3716910172U, // <0,5,4,3>: Cost 4 vext2 <4,3,0,5>, <4,3,0,5>
  3962195892U, // <0,5,4,4>: Cost 4 vzipl <0,4,1,5>, <5,4,5,6>
  2625916214U, // <0,5,4,5>: Cost 3 vext2 <1,4,0,5>, RHS
  3718901071U, // <0,5,4,6>: Cost 4 vext2 <4,6,0,5>, <4,6,0,5>
  2718715846U, // <0,5,4,7>: Cost 3 vext3 <5,6,7,0>, <5,4,7,6>
  2625916457U, // <0,5,4,u>: Cost 3 vext2 <1,4,0,5>, RHS
  3791278034U, // <0,5,5,0>: Cost 4 vext3 <5,5,0,0>, <5,5,0,0>
  3791351771U, // <0,5,5,1>: Cost 4 vext3 <5,5,1,0>, <5,5,1,0>
  3318386260U, // <0,5,5,2>: Cost 4 vrev <5,0,2,5>
  3791499245U, // <0,5,5,3>: Cost 4 vext3 <5,5,3,0>, <5,5,3,0>
  3318533734U, // <0,5,5,4>: Cost 4 vrev <5,0,4,5>
  2718715908U, // <0,5,5,5>: Cost 3 vext3 <5,6,7,0>, <5,5,5,5>
  2657767522U, // <0,5,5,6>: Cost 3 vext2 <6,7,0,5>, <5,6,7,0>
  2718715928U, // <0,5,5,7>: Cost 3 vext3 <5,6,7,0>, <5,5,7,7>
  2718715937U, // <0,5,5,u>: Cost 3 vext3 <5,6,7,0>, <5,5,u,7>
  2592358502U, // <0,5,6,0>: Cost 3 vext1 <7,0,5,6>, LHS
  3792015404U, // <0,5,6,1>: Cost 4 vext3 <5,6,1,0>, <5,6,1,0>
  3731509754U, // <0,5,6,2>: Cost 4 vext2 <6,7,0,5>, <6,2,7,3>
  3785748546U, // <0,5,6,3>: Cost 4 vext3 <4,5,6,0>, <5,6,3,4>
  2592361782U, // <0,5,6,4>: Cost 3 vext1 <7,0,5,6>, RHS
  2592362594U, // <0,5,6,5>: Cost 3 vext1 <7,0,5,6>, <5,6,7,0>
  3785748576U, // <0,5,6,6>: Cost 4 vext3 <4,5,6,0>, <5,6,6,7>
  1644974178U, // <0,5,6,7>: Cost 2 vext3 <5,6,7,0>, <5,6,7,0>
  1645047915U, // <0,5,6,u>: Cost 2 vext3 <5,6,u,0>, <5,6,u,0>
  2562506854U, // <0,5,7,0>: Cost 3 vext1 <2,0,5,7>, LHS
  2562507670U, // <0,5,7,1>: Cost 3 vext1 <2,0,5,7>, <1,2,3,0>
  2562508262U, // <0,5,7,2>: Cost 3 vext1 <2,0,5,7>, <2,0,5,7>
  3636250774U, // <0,5,7,3>: Cost 4 vext1 <2,0,5,7>, <3,0,1,2>
  2562510134U, // <0,5,7,4>: Cost 3 vext1 <2,0,5,7>, RHS
  2718716072U, // <0,5,7,5>: Cost 3 vext3 <5,6,7,0>, <5,7,5,7>
  2718716074U, // <0,5,7,6>: Cost 3 vext3 <5,6,7,0>, <5,7,6,0>
  2719379635U, // <0,5,7,7>: Cost 3 vext3 <5,7,7,0>, <5,7,7,0>
  2562512686U, // <0,5,7,u>: Cost 3 vext1 <2,0,5,7>, LHS
  1500717158U, // <0,5,u,0>: Cost 2 vext1 <4,0,5,u>, LHS
  2625918766U, // <0,5,u,1>: Cost 3 vext2 <1,4,0,5>, LHS
  2719674583U, // <0,5,u,2>: Cost 3 vext3 <5,u,2,0>, <5,u,2,0>
  2568489152U, // <0,5,u,3>: Cost 3 vext1 <3,0,5,u>, <3,0,5,u>
  1500720025U, // <0,5,u,4>: Cost 2 vext1 <4,0,5,u>, <4,0,5,u>
  2625919130U, // <0,5,u,5>: Cost 3 vext2 <1,4,0,5>, RHS
  2586407243U, // <0,5,u,6>: Cost 3 vext1 <6,0,5,u>, <6,0,5,u>
  1646301444U, // <0,5,u,7>: Cost 2 vext3 <5,u,7,0>, <5,u,7,0>
  1646375181U, // <0,5,u,u>: Cost 2 vext3 <5,u,u,0>, <5,u,u,0>
  2586411110U, // <0,6,0,0>: Cost 3 vext1 <6,0,6,0>, LHS
  2619949158U, // <0,6,0,1>: Cost 3 vext2 <0,4,0,6>, LHS
  2619949220U, // <0,6,0,2>: Cost 3 vext2 <0,4,0,6>, <0,2,0,2>
  3785748789U, // <0,6,0,3>: Cost 4 vext3 <4,5,6,0>, <6,0,3,4>
  2619949386U, // <0,6,0,4>: Cost 3 vext2 <0,4,0,6>, <0,4,0,6>
  2586415202U, // <0,6,0,5>: Cost 3 vext1 <6,0,6,0>, <5,6,7,0>
  2586415436U, // <0,6,0,6>: Cost 3 vext1 <6,0,6,0>, <6,0,6,0>
  2952793398U, // <0,6,0,7>: Cost 3 vzipr <0,0,0,0>, RHS
  2619949725U, // <0,6,0,u>: Cost 3 vext2 <0,4,0,6>, LHS
  2562531430U, // <0,6,1,0>: Cost 3 vext1 <2,0,6,1>, LHS
  3693691700U, // <0,6,1,1>: Cost 4 vext2 <0,4,0,6>, <1,1,1,1>
  2886521338U, // <0,6,1,2>: Cost 3 vzipl LHS, <6,2,7,3>
  3693691864U, // <0,6,1,3>: Cost 4 vext2 <0,4,0,6>, <1,3,1,3>
  2562534710U, // <0,6,1,4>: Cost 3 vext1 <2,0,6,1>, RHS
  2580450932U, // <0,6,1,5>: Cost 3 vext1 <5,0,6,1>, <5,0,6,1>
  2886521656U, // <0,6,1,6>: Cost 3 vzipl LHS, <6,6,6,6>
  2966736182U, // <0,6,1,7>: Cost 3 vzipr <2,3,0,1>, RHS
  2966736183U, // <0,6,1,u>: Cost 3 vzipr <2,3,0,1>, RHS
  1500741734U, // <0,6,2,0>: Cost 2 vext1 <4,0,6,2>, LHS
  2250518817U, // <0,6,2,1>: Cost 3 vrev <6,0,1,2>
  2574485096U, // <0,6,2,2>: Cost 3 vext1 <4,0,6,2>, <2,2,2,2>
  2631894694U, // <0,6,2,3>: Cost 3 vext2 <2,4,0,6>, <2,3,0,1>
  1500744604U, // <0,6,2,4>: Cost 2 vext1 <4,0,6,2>, <4,0,6,2>
  2574487248U, // <0,6,2,5>: Cost 3 vext1 <4,0,6,2>, <5,1,7,3>
  3020739384U, // <0,6,2,6>: Cost 3 vtrnl LHS, <6,6,6,6>
  2954136886U, // <0,6,2,7>: Cost 3 vzipr <0,2,0,2>, RHS
  1500747566U, // <0,6,2,u>: Cost 2 vext1 <4,0,6,2>, LHS
  3693693078U, // <0,6,3,0>: Cost 4 vext2 <0,4,0,6>, <3,0,1,2>
  3705637136U, // <0,6,3,1>: Cost 4 vext2 <2,4,0,6>, <3,1,5,7>
  3705637192U, // <0,6,3,2>: Cost 4 vext2 <2,4,0,6>, <3,2,3,0>
  3693693340U, // <0,6,3,3>: Cost 4 vext2 <0,4,0,6>, <3,3,3,3>
  2637867477U, // <0,6,3,4>: Cost 3 vext2 <3,4,0,6>, <3,4,0,6>
  3705637424U, // <0,6,3,5>: Cost 4 vext2 <2,4,0,6>, <3,5,1,7>
  3666154056U, // <0,6,3,6>: Cost 4 vext1 <7,0,6,3>, <6,3,7,0>
  2722697800U, // <0,6,3,7>: Cost 3 vext3 <6,3,7,0>, <6,3,7,0>
  2722771537U, // <0,6,3,u>: Cost 3 vext3 <6,3,u,0>, <6,3,u,0>
  2562556006U, // <0,6,4,0>: Cost 3 vext1 <2,0,6,4>, LHS
  4095316257U, // <0,6,4,1>: Cost 4 vtrnl <0,2,4,6>, <6,0,1,2>
  2562557420U, // <0,6,4,2>: Cost 3 vext1 <2,0,6,4>, <2,0,6,4>
  3636299926U, // <0,6,4,3>: Cost 4 vext1 <2,0,6,4>, <3,0,1,2>
  2562559286U, // <0,6,4,4>: Cost 3 vext1 <2,0,6,4>, RHS
  2619952438U, // <0,6,4,5>: Cost 3 vext2 <0,4,0,6>, RHS
  2723287696U, // <0,6,4,6>: Cost 3 vext3 <6,4,6,0>, <6,4,6,0>
  4027895094U, // <0,6,4,7>: Cost 4 vzipr <0,2,0,4>, RHS
  2619952681U, // <0,6,4,u>: Cost 3 vext2 <0,4,0,6>, RHS
  2718716594U, // <0,6,5,0>: Cost 3 vext3 <5,6,7,0>, <6,5,0,7>
  3648250774U, // <0,6,5,1>: Cost 4 vext1 <4,0,6,5>, <1,2,3,0>
  3792458436U, // <0,6,5,2>: Cost 4 vext3 <5,6,7,0>, <6,5,2,7>
  3705638767U, // <0,6,5,3>: Cost 5 vext2 <2,4,0,6>, <5,3,7,0>
  3648252831U, // <0,6,5,4>: Cost 4 vext1 <4,0,6,5>, <4,0,6,5>
  3797619416U, // <0,6,5,5>: Cost 4 vext3 <6,5,5,0>, <6,5,5,0>
  3792458472U, // <0,6,5,6>: Cost 4 vext3 <5,6,7,0>, <6,5,6,7>
  4035202358U, // <0,6,5,7>: Cost 4 vzipr <1,4,0,5>, RHS
  2718716594U, // <0,6,5,u>: Cost 3 vext3 <5,6,7,0>, <6,5,0,7>
  3786412796U, // <0,6,6,0>: Cost 4 vext3 <4,6,6,0>, <6,6,0,0>
  3792458504U, // <0,6,6,1>: Cost 4 vext3 <5,6,7,0>, <6,6,1,3>
  3728200126U, // <0,6,6,2>: Cost 4 vext2 <6,2,0,6>, <6,2,0,6>
  3798135575U, // <0,6,6,3>: Cost 4 vext3 <6,6,3,0>, <6,6,3,0>
  3786412836U, // <0,6,6,4>: Cost 4 vext3 <4,6,6,0>, <6,6,4,4>
  3792458543U, // <0,6,6,5>: Cost 4 vext3 <5,6,7,0>, <6,6,5,6>
  2718716728U, // <0,6,6,6>: Cost 3 vext3 <5,6,7,0>, <6,6,6,6>
  2718716738U, // <0,6,6,7>: Cost 3 vext3 <5,6,7,0>, <6,6,7,7>
  2718716747U, // <0,6,6,u>: Cost 3 vext3 <5,6,7,0>, <6,6,u,7>
  2718716750U, // <0,6,7,0>: Cost 3 vext3 <5,6,7,0>, <6,7,0,1>
  2724909910U, // <0,6,7,1>: Cost 3 vext3 <6,7,1,0>, <6,7,1,0>
  3636323823U, // <0,6,7,2>: Cost 4 vext1 <2,0,6,7>, <2,0,6,7>
  2725057384U, // <0,6,7,3>: Cost 3 vext3 <6,7,3,0>, <6,7,3,0>
  2718716790U, // <0,6,7,4>: Cost 3 vext3 <5,6,7,0>, <6,7,4,5>
  2718716800U, // <0,6,7,5>: Cost 3 vext3 <5,6,7,0>, <6,7,5,6>
  3792458629U, // <0,6,7,6>: Cost 4 vext3 <5,6,7,0>, <6,7,6,2>
  2725352332U, // <0,6,7,7>: Cost 3 vext3 <6,7,7,0>, <6,7,7,0>
  2718716822U, // <0,6,7,u>: Cost 3 vext3 <5,6,7,0>, <6,7,u,1>
  1500790886U, // <0,6,u,0>: Cost 2 vext1 <4,0,6,u>, LHS
  2619954990U, // <0,6,u,1>: Cost 3 vext2 <0,4,0,6>, LHS
  2562590192U, // <0,6,u,2>: Cost 3 vext1 <2,0,6,u>, <2,0,6,u>
  2725721017U, // <0,6,u,3>: Cost 3 vext3 <6,u,3,0>, <6,u,3,0>
  1500793762U, // <0,6,u,4>: Cost 2 vext1 <4,0,6,u>, <4,0,6,u>
  2619955354U, // <0,6,u,5>: Cost 3 vext2 <0,4,0,6>, RHS
  2725942228U, // <0,6,u,6>: Cost 3 vext3 <6,u,6,0>, <6,u,6,0>
  2954186038U, // <0,6,u,7>: Cost 3 vzipr <0,2,0,u>, RHS
  1500796718U, // <0,6,u,u>: Cost 2 vext1 <4,0,6,u>, LHS
  2256401391U, // <0,7,0,0>: Cost 3 vrev <7,0,0,0>
  2632564838U, // <0,7,0,1>: Cost 3 vext2 <2,5,0,7>, LHS
  2256548865U, // <0,7,0,2>: Cost 3 vrev <7,0,2,0>
  3700998396U, // <0,7,0,3>: Cost 4 vext2 <1,6,0,7>, <0,3,1,0>
  2718716952U, // <0,7,0,4>: Cost 3 vext3 <5,6,7,0>, <7,0,4,5>
  2718716962U, // <0,7,0,5>: Cost 3 vext3 <5,6,7,0>, <7,0,5,6>
  2621284845U, // <0,7,0,6>: Cost 3 vext2 <0,6,0,7>, <0,6,0,7>
  3904685542U, // <0,7,0,7>: Cost 4 vuzpr <2,0,5,7>, <2,0,5,7>
  2632565405U, // <0,7,0,u>: Cost 3 vext2 <2,5,0,7>, LHS
  2256409584U, // <0,7,1,0>: Cost 3 vrev <7,0,0,1>
  3706307380U, // <0,7,1,1>: Cost 4 vext2 <2,5,0,7>, <1,1,1,1>
  2632565654U, // <0,7,1,2>: Cost 3 vext2 <2,5,0,7>, <1,2,3,0>
  3769603168U, // <0,7,1,3>: Cost 4 vext3 <1,u,3,0>, <7,1,3,5>
  2256704532U, // <0,7,1,4>: Cost 3 vrev <7,0,4,1>
  3769603184U, // <0,7,1,5>: Cost 4 vext3 <1,u,3,0>, <7,1,5,3>
  3700999366U, // <0,7,1,6>: Cost 4 vext2 <1,6,0,7>, <1,6,0,7>
  2886522476U, // <0,7,1,7>: Cost 3 vzipl LHS, <7,7,7,7>
  2256999480U, // <0,7,1,u>: Cost 3 vrev <7,0,u,1>
  2586501222U, // <0,7,2,0>: Cost 3 vext1 <6,0,7,2>, LHS
  1182749690U, // <0,7,2,1>: Cost 2 vrev <7,0,1,2>
  3636356595U, // <0,7,2,2>: Cost 4 vext1 <2,0,7,2>, <2,0,7,2>
  2727711916U, // <0,7,2,3>: Cost 3 vext3 <7,2,3,0>, <7,2,3,0>
  2586504502U, // <0,7,2,4>: Cost 3 vext1 <6,0,7,2>, RHS
  2632566606U, // <0,7,2,5>: Cost 3 vext2 <2,5,0,7>, <2,5,0,7>
  2586505559U, // <0,7,2,6>: Cost 3 vext1 <6,0,7,2>, <6,0,7,2>
  3020740204U, // <0,7,2,7>: Cost 3 vtrnl LHS, <7,7,7,7>
  1183265849U, // <0,7,2,u>: Cost 2 vrev <7,0,u,2>
  3701000342U, // <0,7,3,0>: Cost 4 vext2 <1,6,0,7>, <3,0,1,2>
  3706308849U, // <0,7,3,1>: Cost 4 vext2 <2,5,0,7>, <3,1,2,3>
  3330315268U, // <0,7,3,2>: Cost 4 vrev <7,0,2,3>
  3706309020U, // <0,7,3,3>: Cost 4 vext2 <2,5,0,7>, <3,3,3,3>
  3706309122U, // <0,7,3,4>: Cost 4 vext2 <2,5,0,7>, <3,4,5,6>
  3712281127U, // <0,7,3,5>: Cost 4 vext2 <3,5,0,7>, <3,5,0,7>
  2639202936U, // <0,7,3,6>: Cost 3 vext2 <3,6,0,7>, <3,6,0,7>
  3802412321U, // <0,7,3,7>: Cost 4 vext3 <7,3,7,0>, <7,3,7,0>
  2640530202U, // <0,7,3,u>: Cost 3 vext2 <3,u,0,7>, <3,u,0,7>
  3654287462U, // <0,7,4,0>: Cost 4 vext1 <5,0,7,4>, LHS
  2256507900U, // <0,7,4,1>: Cost 3 vrev <7,0,1,4>
  2256581637U, // <0,7,4,2>: Cost 3 vrev <7,0,2,4>
  3660262008U, // <0,7,4,3>: Cost 4 vext1 <6,0,7,4>, <3,6,0,7>
  3786413405U, // <0,7,4,4>: Cost 4 vext3 <4,6,6,0>, <7,4,4,6>
  2632568118U, // <0,7,4,5>: Cost 3 vext2 <2,5,0,7>, RHS
  3718917457U, // <0,7,4,6>: Cost 4 vext2 <4,6,0,7>, <4,6,0,7>
  3787003255U, // <0,7,4,7>: Cost 4 vext3 <4,7,5,0>, <7,4,7,5>
  2632568361U, // <0,7,4,u>: Cost 3 vext2 <2,5,0,7>, RHS
  3706310268U, // <0,7,5,0>: Cost 4 vext2 <2,5,0,7>, <5,0,7,0>
  3792459156U, // <0,7,5,1>: Cost 4 vext3 <5,6,7,0>, <7,5,1,7>
  3330331654U, // <0,7,5,2>: Cost 4 vrev <7,0,2,5>
  3722899255U, // <0,7,5,3>: Cost 4 vext2 <5,3,0,7>, <5,3,0,7>
  2256737304U, // <0,7,5,4>: Cost 3 vrev <7,0,4,5>
  3724226521U, // <0,7,5,5>: Cost 4 vext2 <5,5,0,7>, <5,5,0,7>
  2718717377U, // <0,7,5,6>: Cost 3 vext3 <5,6,7,0>, <7,5,6,7>
  2729997763U, // <0,7,5,7>: Cost 3 vext3 <7,5,7,0>, <7,5,7,0>
  2720044499U, // <0,7,5,u>: Cost 3 vext3 <5,u,7,0>, <7,5,u,7>
  3712946517U, // <0,7,6,0>: Cost 4 vext2 <3,6,0,7>, <6,0,7,0>
  2256524286U, // <0,7,6,1>: Cost 3 vrev <7,0,1,6>
  3792459246U, // <0,7,6,2>: Cost 4 vext3 <5,6,7,0>, <7,6,2,7>
  3796440567U, // <0,7,6,3>: Cost 4 vext3 <6,3,7,0>, <7,6,3,7>
  3654307126U, // <0,7,6,4>: Cost 4 vext1 <5,0,7,6>, RHS
  2656457394U, // <0,7,6,5>: Cost 3 vext2 <6,5,0,7>, <6,5,0,7>
  3792459281U, // <0,7,6,6>: Cost 4 vext3 <5,6,7,0>, <7,6,6,6>
  2730661396U, // <0,7,6,7>: Cost 3 vext3 <7,6,7,0>, <7,6,7,0>
  2658448293U, // <0,7,6,u>: Cost 3 vext2 <6,u,0,7>, <6,u,0,7>
  3787003431U, // <0,7,7,0>: Cost 4 vext3 <4,7,5,0>, <7,7,0,1>
  3654312854U, // <0,7,7,1>: Cost 4 vext1 <5,0,7,7>, <1,2,3,0>
  3654313446U, // <0,7,7,2>: Cost 4 vext1 <5,0,7,7>, <2,0,5,7>
  3804771905U, // <0,7,7,3>: Cost 4 vext3 <7,7,3,0>, <7,7,3,0>
  3654315318U, // <0,7,7,4>: Cost 4 vext1 <5,0,7,7>, RHS
  3654315651U, // <0,7,7,5>: Cost 4 vext1 <5,0,7,7>, <5,0,7,7>
  3660288348U, // <0,7,7,6>: Cost 4 vext1 <6,0,7,7>, <6,0,7,7>
  2718717548U, // <0,7,7,7>: Cost 3 vext3 <5,6,7,0>, <7,7,7,7>
  2664420990U, // <0,7,7,u>: Cost 3 vext2 <7,u,0,7>, <7,u,0,7>
  2256466935U, // <0,7,u,0>: Cost 3 vrev <7,0,0,u>
  1182798848U, // <0,7,u,1>: Cost 2 vrev <7,0,1,u>
  2256614409U, // <0,7,u,2>: Cost 3 vrev <7,0,2,u>
  2731693714U, // <0,7,u,3>: Cost 3 vext3 <7,u,3,0>, <7,u,3,0>
  2256761883U, // <0,7,u,4>: Cost 3 vrev <7,0,4,u>
  2632571034U, // <0,7,u,5>: Cost 3 vext2 <2,5,0,7>, RHS
  2669066421U, // <0,7,u,6>: Cost 3 vext2 <u,6,0,7>, <u,6,0,7>
  2731988662U, // <0,7,u,7>: Cost 3 vext3 <7,u,7,0>, <7,u,7,0>
  1183315007U, // <0,7,u,u>: Cost 2 vrev <7,0,u,u>
  135053414U, // <0,u,0,0>: Cost 1 vdup0 LHS
  1544896614U, // <0,u,0,1>: Cost 2 vext2 <0,2,0,u>, LHS
  1678999654U, // <0,u,0,2>: Cost 2 vuzpl LHS, LHS
  2691880677U, // <0,u,0,3>: Cost 3 vext3 <1,2,3,0>, <u,0,3,2>
  1476988214U, // <0,u,0,4>: Cost 2 vext1 <0,0,u,0>, RHS
  2718791419U, // <0,u,0,5>: Cost 3 vext3 <5,6,u,0>, <u,0,5,6>
  3021248666U, // <0,u,0,6>: Cost 3 vtrnl <0,2,0,2>, RHS
  2592535607U, // <0,u,0,7>: Cost 3 vext1 <7,0,u,0>, <7,0,u,0>
  135053414U, // <0,u,0,u>: Cost 1 vdup0 LHS
  1476993097U, // <0,u,1,0>: Cost 2 vext1 <0,0,u,1>, <0,0,u,1>
  1812780846U, // <0,u,1,1>: Cost 2 vzipl LHS, LHS
  1618138926U, // <0,u,1,2>: Cost 2 vext3 <1,2,3,0>, LHS
  2752742134U, // <0,u,1,3>: Cost 3 vuzpl LHS, <1,0,3,2>
  1476996406U, // <0,u,1,4>: Cost 2 vext1 <0,0,u,1>, RHS
  1812781210U, // <0,u,1,5>: Cost 2 vzipl LHS, RHS
  2887006416U, // <0,u,1,6>: Cost 3 vzipl LHS, <u,6,3,7>
  2966736200U, // <0,u,1,7>: Cost 3 vzipr <2,3,0,1>, RHS
  1812781413U, // <0,u,1,u>: Cost 2 vzipl LHS, LHS
  1482973286U, // <0,u,2,0>: Cost 2 vext1 <1,0,u,2>, LHS
  1482973987U, // <0,u,2,1>: Cost 2 vext1 <1,0,u,2>, <1,0,u,2>
  1946998574U, // <0,u,2,2>: Cost 2 vtrnl LHS, LHS
  835584U, // <0,u,2,3>: Cost 0 copy LHS
  1482976566U, // <0,u,2,4>: Cost 2 vext1 <1,0,u,2>, RHS
  3020781631U, // <0,u,2,5>: Cost 3 vtrnl LHS, <u,4,5,6>
  1946998938U, // <0,u,2,6>: Cost 2 vtrnl LHS, RHS
  1518810169U, // <0,u,2,7>: Cost 2 vext1 <7,0,u,2>, <7,0,u,2>
  835584U, // <0,u,2,u>: Cost 0 copy LHS
  2618640534U, // <0,u,3,0>: Cost 3 vext2 <0,2,0,u>, <3,0,1,2>
  2752743574U, // <0,u,3,1>: Cost 3 vuzpl LHS, <3,0,1,2>
  2636556597U, // <0,u,3,2>: Cost 3 vext2 <3,2,0,u>, <3,2,0,u>
  2752743836U, // <0,u,3,3>: Cost 3 vuzpl LHS, <3,3,3,3>
  2618640898U, // <0,u,3,4>: Cost 3 vext2 <0,2,0,u>, <3,4,5,6>
  2752743938U, // <0,u,3,5>: Cost 3 vuzpl LHS, <3,4,5,6>
  2639202936U, // <0,u,3,6>: Cost 3 vext2 <3,6,0,7>, <3,6,0,7>
  2639874762U, // <0,u,3,7>: Cost 3 vext2 <3,7,0,u>, <3,7,0,u>
  2752743637U, // <0,u,3,u>: Cost 3 vuzpl LHS, <3,0,u,2>
  2562703462U, // <0,u,4,0>: Cost 3 vext1 <2,0,u,4>, LHS
  2888455982U, // <0,u,4,1>: Cost 3 vzipl <0,4,1,5>, LHS
  3021575982U, // <0,u,4,2>: Cost 3 vtrnl <0,2,4,6>, LHS
  2568677591U, // <0,u,4,3>: Cost 3 vext1 <3,0,u,4>, <3,0,u,4>
  2562706742U, // <0,u,4,4>: Cost 3 vext1 <2,0,u,4>, RHS
  1544899894U, // <0,u,4,5>: Cost 2 vext2 <0,2,0,u>, RHS
  1679002934U, // <0,u,4,6>: Cost 2 vuzpl LHS, RHS
  2718718033U, // <0,u,4,7>: Cost 3 vext3 <5,6,7,0>, <u,4,7,6>
  1679002952U, // <0,u,4,u>: Cost 2 vuzpl LHS, RHS
  2568683622U, // <0,u,5,0>: Cost 3 vext1 <3,0,u,5>, LHS
  2568684438U, // <0,u,5,1>: Cost 3 vext1 <3,0,u,5>, <1,2,3,0>
  3765622902U, // <0,u,5,2>: Cost 4 vext3 <1,2,3,0>, <u,5,2,7>
  2691881087U, // <0,u,5,3>: Cost 3 vext3 <1,2,3,0>, <u,5,3,7>
  2568686902U, // <0,u,5,4>: Cost 3 vext1 <3,0,u,5>, RHS
  2650492890U, // <0,u,5,5>: Cost 3 vext2 <5,5,0,u>, <5,5,0,u>
  1618139290U, // <0,u,5,6>: Cost 2 vext3 <1,2,3,0>, RHS
  2824834358U, // <0,u,5,7>: Cost 3 vuzpr <1,0,3,u>, RHS
  1618139308U, // <0,u,5,u>: Cost 2 vext3 <1,2,3,0>, RHS
  2592579686U, // <0,u,6,0>: Cost 3 vext1 <7,0,u,6>, LHS
  2262496983U, // <0,u,6,1>: Cost 3 vrev <u,0,1,6>
  2654474688U, // <0,u,6,2>: Cost 3 vext2 <6,2,0,u>, <6,2,0,u>
  2691881168U, // <0,u,6,3>: Cost 3 vext3 <1,2,3,0>, <u,6,3,7>
  2592582966U, // <0,u,6,4>: Cost 3 vext1 <7,0,u,6>, RHS
  2656465587U, // <0,u,6,5>: Cost 3 vext2 <6,5,0,u>, <6,5,0,u>
  2657129220U, // <0,u,6,6>: Cost 3 vext2 <6,6,0,u>, <6,6,0,u>
  1584051029U, // <0,u,6,7>: Cost 2 vext2 <6,7,0,u>, <6,7,0,u>
  1584714662U, // <0,u,6,u>: Cost 2 vext2 <6,u,0,u>, <6,u,0,u>
  2562728038U, // <0,u,7,0>: Cost 3 vext1 <2,0,u,7>, LHS
  2562728854U, // <0,u,7,1>: Cost 3 vext1 <2,0,u,7>, <1,2,3,0>
  2562729473U, // <0,u,7,2>: Cost 3 vext1 <2,0,u,7>, <2,0,u,7>
  2661111018U, // <0,u,7,3>: Cost 3 vext2 <7,3,0,u>, <7,3,0,u>
  2562731318U, // <0,u,7,4>: Cost 3 vext1 <2,0,u,7>, RHS
  2718718258U, // <0,u,7,5>: Cost 3 vext3 <5,6,7,0>, <u,7,5,6>
  2586620261U, // <0,u,7,6>: Cost 3 vext1 <6,0,u,7>, <6,0,u,7>
  2657793644U, // <0,u,7,7>: Cost 3 vext2 <6,7,0,u>, <7,7,7,7>
  2562733870U, // <0,u,7,u>: Cost 3 vext1 <2,0,u,7>, LHS
  135053414U, // <0,u,u,0>: Cost 1 vdup0 LHS
  1544902446U, // <0,u,u,1>: Cost 2 vext2 <0,2,0,u>, LHS
  1679005486U, // <0,u,u,2>: Cost 2 vuzpl LHS, LHS
  835584U, // <0,u,u,3>: Cost 0 copy LHS
  1483025718U, // <0,u,u,4>: Cost 2 vext1 <1,0,u,u>, RHS
  1544902810U, // <0,u,u,5>: Cost 2 vext2 <0,2,0,u>, RHS
  1679005850U, // <0,u,u,6>: Cost 2 vuzpl LHS, RHS
  1518859327U, // <0,u,u,7>: Cost 2 vext1 <7,0,u,u>, <7,0,u,u>
  835584U, // <0,u,u,u>: Cost 0 copy LHS
  2689744896U, // <1,0,0,0>: Cost 3 vext3 <0,u,1,1>, <0,0,0,0>
  1610694666U, // <1,0,0,1>: Cost 2 vext3 <0,0,1,1>, <0,0,1,1>
  2689744916U, // <1,0,0,2>: Cost 3 vext3 <0,u,1,1>, <0,0,2,2>
  2619310332U, // <1,0,0,3>: Cost 3 vext2 <0,3,1,0>, <0,3,1,0>
  2684657701U, // <1,0,0,4>: Cost 3 vext3 <0,0,4,1>, <0,0,4,1>
  2620637598U, // <1,0,0,5>: Cost 3 vext2 <0,5,1,0>, <0,5,1,0>
  3708977654U, // <1,0,0,6>: Cost 4 vext2 <3,0,1,0>, <0,6,1,7>
  3666351168U, // <1,0,0,7>: Cost 4 vext1 <7,1,0,0>, <7,1,0,0>
  1611210825U, // <1,0,0,u>: Cost 2 vext3 <0,0,u,1>, <0,0,u,1>
  2556780646U, // <1,0,1,0>: Cost 3 vext1 <1,1,0,1>, LHS
  2556781355U, // <1,0,1,1>: Cost 3 vext1 <1,1,0,1>, <1,1,0,1>
  1616003174U, // <1,0,1,2>: Cost 2 vext3 <0,u,1,1>, LHS
  3693052888U, // <1,0,1,3>: Cost 4 vext2 <0,3,1,0>, <1,3,1,3>
  2556783926U, // <1,0,1,4>: Cost 3 vext1 <1,1,0,1>, RHS
  2580672143U, // <1,0,1,5>: Cost 3 vext1 <5,1,0,1>, <5,1,0,1>
  2724839566U, // <1,0,1,6>: Cost 3 vext3 <6,7,0,1>, <0,1,6,7>
  3654415354U, // <1,0,1,7>: Cost 4 vext1 <5,1,0,1>, <7,0,1,2>
  1616003228U, // <1,0,1,u>: Cost 2 vext3 <0,u,1,1>, LHS
  2685690019U, // <1,0,2,0>: Cost 3 vext3 <0,2,0,1>, <0,2,0,1>
  2685763756U, // <1,0,2,1>: Cost 3 vext3 <0,2,1,1>, <0,2,1,1>
  2698297524U, // <1,0,2,2>: Cost 3 vext3 <2,3,0,1>, <0,2,2,0>
  2685911230U, // <1,0,2,3>: Cost 3 vext3 <0,2,3,1>, <0,2,3,1>
  2689745100U, // <1,0,2,4>: Cost 3 vext3 <0,u,1,1>, <0,2,4,6>
  3764814038U, // <1,0,2,5>: Cost 4 vext3 <1,1,1,1>, <0,2,5,7>
  2724839640U, // <1,0,2,6>: Cost 3 vext3 <6,7,0,1>, <0,2,6,0>
  2592625658U, // <1,0,2,7>: Cost 3 vext1 <7,1,0,2>, <7,0,1,2>
  2686279915U, // <1,0,2,u>: Cost 3 vext3 <0,2,u,1>, <0,2,u,1>
  3087843328U, // <1,0,3,0>: Cost 3 vtrnr LHS, <0,0,0,0>
  3087843338U, // <1,0,3,1>: Cost 3 vtrnr LHS, <0,0,1,1>
  67944550U, // <1,0,3,2>: Cost 1 vrev LHS
  2568743135U, // <1,0,3,3>: Cost 3 vext1 <3,1,0,3>, <3,1,0,3>
  2562772278U, // <1,0,3,4>: Cost 3 vext1 <2,1,0,3>, RHS
  4099850454U, // <1,0,3,5>: Cost 4 vtrnl <1,0,3,2>, <0,2,5,7>
  3704998538U, // <1,0,3,6>: Cost 4 vext2 <2,3,1,0>, <3,6,2,7>
  2592633923U, // <1,0,3,7>: Cost 3 vext1 <7,1,0,3>, <7,1,0,3>
  68386972U, // <1,0,3,u>: Cost 1 vrev LHS
  2620640146U, // <1,0,4,0>: Cost 3 vext2 <0,5,1,0>, <4,0,5,1>
  2689745234U, // <1,0,4,1>: Cost 3 vext3 <0,u,1,1>, <0,4,1,5>
  2689745244U, // <1,0,4,2>: Cost 3 vext3 <0,u,1,1>, <0,4,2,6>
  3760980320U, // <1,0,4,3>: Cost 4 vext3 <0,4,3,1>, <0,4,3,1>
  3761054057U, // <1,0,4,4>: Cost 4 vext3 <0,4,4,1>, <0,4,4,1>
  2619313462U, // <1,0,4,5>: Cost 3 vext2 <0,3,1,0>, RHS
  3761201531U, // <1,0,4,6>: Cost 4 vext3 <0,4,6,1>, <0,4,6,1>
  3666383940U, // <1,0,4,7>: Cost 4 vext1 <7,1,0,4>, <7,1,0,4>
  2619313705U, // <1,0,4,u>: Cost 3 vext2 <0,3,1,0>, RHS
  4029300736U, // <1,0,5,0>: Cost 4 vzipr <0,4,1,5>, <0,0,0,0>
  2895249510U, // <1,0,5,1>: Cost 3 vzipl <1,5,3,7>, LHS
  3028287590U, // <1,0,5,2>: Cost 3 vtrnl <1,3,5,7>, LHS
  3642501345U, // <1,0,5,3>: Cost 4 vext1 <3,1,0,5>, <3,1,0,5>
  2215592058U, // <1,0,5,4>: Cost 3 vrev <0,1,4,5>
  3724242907U, // <1,0,5,5>: Cost 4 vext2 <5,5,1,0>, <5,5,1,0>
  3724906540U, // <1,0,5,6>: Cost 4 vext2 <5,6,1,0>, <5,6,1,0>
  3911118134U, // <1,0,5,7>: Cost 4 vuzpr <3,1,3,0>, RHS
  3028287644U, // <1,0,5,u>: Cost 3 vtrnl <1,3,5,7>, LHS
  3762086375U, // <1,0,6,0>: Cost 4 vext3 <0,6,0,1>, <0,6,0,1>
  2698297846U, // <1,0,6,1>: Cost 3 vext3 <2,3,0,1>, <0,6,1,7>
  3760022015U, // <1,0,6,2>: Cost 4 vext3 <0,2,u,1>, <0,6,2,7>
  3642509538U, // <1,0,6,3>: Cost 4 vext1 <3,1,0,6>, <3,1,0,6>
  3762381323U, // <1,0,6,4>: Cost 4 vext3 <0,6,4,1>, <0,6,4,1>
  3730215604U, // <1,0,6,5>: Cost 4 vext2 <6,5,1,0>, <6,5,1,0>
  3730879237U, // <1,0,6,6>: Cost 4 vext2 <6,6,1,0>, <6,6,1,0>
  2657801046U, // <1,0,6,7>: Cost 3 vext2 <6,7,1,0>, <6,7,1,0>
  2658464679U, // <1,0,6,u>: Cost 3 vext2 <6,u,1,0>, <6,u,1,0>
  2659128312U, // <1,0,7,0>: Cost 3 vext2 <7,0,1,0>, <7,0,1,0>
  4047898278U, // <1,0,7,1>: Cost 4 vzipr <3,5,1,7>, <2,3,0,1>
  2215460970U, // <1,0,7,2>: Cost 3 vrev <0,1,2,7>
  3734861035U, // <1,0,7,3>: Cost 4 vext2 <7,3,1,0>, <7,3,1,0>
  3731543398U, // <1,0,7,4>: Cost 4 vext2 <6,7,1,0>, <7,4,5,6>
  3736188301U, // <1,0,7,5>: Cost 4 vext2 <7,5,1,0>, <7,5,1,0>
  2663110110U, // <1,0,7,6>: Cost 3 vext2 <7,6,1,0>, <7,6,1,0>
  3731543660U, // <1,0,7,7>: Cost 4 vext2 <6,7,1,0>, <7,7,7,7>
  2664437376U, // <1,0,7,u>: Cost 3 vext2 <7,u,1,0>, <7,u,1,0>
  3087884288U, // <1,0,u,0>: Cost 3 vtrnr LHS, <0,0,0,0>
  1616003730U, // <1,0,u,1>: Cost 2 vext3 <0,u,1,1>, <0,u,1,1>
  67985515U, // <1,0,u,2>: Cost 1 vrev LHS
  2689893028U, // <1,0,u,3>: Cost 3 vext3 <0,u,3,1>, <0,u,3,1>
  2689745586U, // <1,0,u,4>: Cost 3 vext3 <0,u,1,1>, <0,u,4,6>
  2619316378U, // <1,0,u,5>: Cost 3 vext2 <0,3,1,0>, RHS
  2669082807U, // <1,0,u,6>: Cost 3 vext2 <u,6,1,0>, <u,6,1,0>
  2592674888U, // <1,0,u,7>: Cost 3 vext1 <7,1,0,u>, <7,1,0,u>
  68427937U, // <1,0,u,u>: Cost 1 vrev LHS
  1543585802U, // <1,1,0,0>: Cost 2 vext2 <0,0,1,1>, <0,0,1,1>
  1548894310U, // <1,1,0,1>: Cost 2 vext2 <0,u,1,1>, LHS
  2618654892U, // <1,1,0,2>: Cost 3 vext2 <0,2,1,1>, <0,2,1,1>
  2689745654U, // <1,1,0,3>: Cost 3 vext3 <0,u,1,1>, <1,0,3,2>
  2622636370U, // <1,1,0,4>: Cost 3 vext2 <0,u,1,1>, <0,4,1,5>
  2620645791U, // <1,1,0,5>: Cost 3 vext2 <0,5,1,1>, <0,5,1,1>
  3696378367U, // <1,1,0,6>: Cost 4 vext2 <0,u,1,1>, <0,6,2,7>
  3666424905U, // <1,1,0,7>: Cost 4 vext1 <7,1,1,0>, <7,1,1,0>
  1548894866U, // <1,1,0,u>: Cost 2 vext2 <0,u,1,1>, <0,u,1,1>
  1483112550U, // <1,1,1,0>: Cost 2 vext1 <1,1,1,1>, LHS
  202162278U, // <1,1,1,1>: Cost 1 vdup1 LHS
  2622636950U, // <1,1,1,2>: Cost 3 vext2 <0,u,1,1>, <1,2,3,0>
  2622637016U, // <1,1,1,3>: Cost 3 vext2 <0,u,1,1>, <1,3,1,3>
  1483115830U, // <1,1,1,4>: Cost 2 vext1 <1,1,1,1>, RHS
  2622637200U, // <1,1,1,5>: Cost 3 vext2 <0,u,1,1>, <1,5,3,7>
  2622637263U, // <1,1,1,6>: Cost 3 vext2 <0,u,1,1>, <1,6,1,7>
  2592691274U, // <1,1,1,7>: Cost 3 vext1 <7,1,1,1>, <7,1,1,1>
  202162278U, // <1,1,1,u>: Cost 1 vdup1 LHS
  2550890588U, // <1,1,2,0>: Cost 3 vext1 <0,1,1,2>, <0,1,1,2>
  2617329183U, // <1,1,2,1>: Cost 3 vext2 <0,0,1,1>, <2,1,3,1>
  2622637672U, // <1,1,2,2>: Cost 3 vext2 <0,u,1,1>, <2,2,2,2>
  2622637734U, // <1,1,2,3>: Cost 3 vext2 <0,u,1,1>, <2,3,0,1>
  2550893878U, // <1,1,2,4>: Cost 3 vext1 <0,1,1,2>, RHS
  3696379744U, // <1,1,2,5>: Cost 4 vext2 <0,u,1,1>, <2,5,2,7>
  2622638010U, // <1,1,2,6>: Cost 3 vext2 <0,u,1,1>, <2,6,3,7>
  3804554170U, // <1,1,2,7>: Cost 4 vext3 <7,7,0,1>, <1,2,7,0>
  2622638139U, // <1,1,2,u>: Cost 3 vext2 <0,u,1,1>, <2,u,0,1>
  2622638230U, // <1,1,3,0>: Cost 3 vext2 <0,u,1,1>, <3,0,1,2>
  3087844148U, // <1,1,3,1>: Cost 3 vtrnr LHS, <1,1,1,1>
  4161585244U, // <1,1,3,2>: Cost 4 vtrnr LHS, <0,1,1,2>
  2014101606U, // <1,1,3,3>: Cost 2 vtrnr LHS, LHS
  2622638594U, // <1,1,3,4>: Cost 3 vext2 <0,u,1,1>, <3,4,5,6>
  2689745920U, // <1,1,3,5>: Cost 3 vext3 <0,u,1,1>, <1,3,5,7>
  3763487753U, // <1,1,3,6>: Cost 4 vext3 <0,u,1,1>, <1,3,6,7>
  2592707660U, // <1,1,3,7>: Cost 3 vext1 <7,1,1,3>, <7,1,1,3>
  2014101611U, // <1,1,3,u>: Cost 2 vtrnr LHS, LHS
  2556878950U, // <1,1,4,0>: Cost 3 vext1 <1,1,1,4>, LHS
  2221335351U, // <1,1,4,1>: Cost 3 vrev <1,1,1,4>
  3696380988U, // <1,1,4,2>: Cost 4 vext2 <0,u,1,1>, <4,2,6,0>
  3763487805U, // <1,1,4,3>: Cost 4 vext3 <0,u,1,1>, <1,4,3,5>
  2556882230U, // <1,1,4,4>: Cost 3 vext1 <1,1,1,4>, RHS
  1548897590U, // <1,1,4,5>: Cost 2 vext2 <0,u,1,1>, RHS
  2758184246U, // <1,1,4,6>: Cost 3 vuzpl <1,1,1,1>, RHS
  3666457677U, // <1,1,4,7>: Cost 4 vext1 <7,1,1,4>, <7,1,1,4>
  1548897833U, // <1,1,4,u>: Cost 2 vext2 <0,u,1,1>, RHS
  2693653615U, // <1,1,5,0>: Cost 3 vext3 <1,5,0,1>, <1,5,0,1>
  2617331408U, // <1,1,5,1>: Cost 3 vext2 <0,0,1,1>, <5,1,7,3>
  4029302934U, // <1,1,5,2>: Cost 4 vzipr <0,4,1,5>, <3,0,1,2>
  2689746064U, // <1,1,5,3>: Cost 3 vext3 <0,u,1,1>, <1,5,3,7>
  2221564755U, // <1,1,5,4>: Cost 3 vrev <1,1,4,5>
  2955559250U, // <1,1,5,5>: Cost 3 vzipr <0,4,1,5>, <0,4,1,5>
  2617331810U, // <1,1,5,6>: Cost 3 vext2 <0,0,1,1>, <5,6,7,0>
  2825293110U, // <1,1,5,7>: Cost 3 vuzpr <1,1,1,1>, RHS
  2689746109U, // <1,1,5,u>: Cost 3 vext3 <0,u,1,1>, <1,5,u,7>
  3696382241U, // <1,1,6,0>: Cost 4 vext2 <0,u,1,1>, <6,0,1,2>
  2689746127U, // <1,1,6,1>: Cost 3 vext3 <0,u,1,1>, <1,6,1,7>
  2617332218U, // <1,1,6,2>: Cost 3 vext2 <0,0,1,1>, <6,2,7,3>
  3763487969U, // <1,1,6,3>: Cost 4 vext3 <0,u,1,1>, <1,6,3,7>
  3696382605U, // <1,1,6,4>: Cost 4 vext2 <0,u,1,1>, <6,4,5,6>
  4029309266U, // <1,1,6,5>: Cost 4 vzipr <0,4,1,6>, <0,4,1,5>
  2617332536U, // <1,1,6,6>: Cost 3 vext2 <0,0,1,1>, <6,6,6,6>
  2724840702U, // <1,1,6,7>: Cost 3 vext3 <6,7,0,1>, <1,6,7,0>
  2725504263U, // <1,1,6,u>: Cost 3 vext3 <6,u,0,1>, <1,6,u,0>
  2617332720U, // <1,1,7,0>: Cost 3 vext2 <0,0,1,1>, <7,0,0,1>
  2659800138U, // <1,1,7,1>: Cost 3 vext2 <7,1,1,1>, <7,1,1,1>
  3691074717U, // <1,1,7,2>: Cost 4 vext2 <0,0,1,1>, <7,2,1,3>
  4167811174U, // <1,1,7,3>: Cost 4 vtrnr <1,1,5,7>, LHS
  2617333094U, // <1,1,7,4>: Cost 3 vext2 <0,0,1,1>, <7,4,5,6>
  3295396702U, // <1,1,7,5>: Cost 4 vrev <1,1,5,7>
  3803891014U, // <1,1,7,6>: Cost 4 vext3 <7,6,0,1>, <1,7,6,0>
  2617333356U, // <1,1,7,7>: Cost 3 vext2 <0,0,1,1>, <7,7,7,7>
  2659800138U, // <1,1,7,u>: Cost 3 vext2 <7,1,1,1>, <7,1,1,1>
  1483112550U, // <1,1,u,0>: Cost 2 vext1 <1,1,1,1>, LHS
  202162278U, // <1,1,u,1>: Cost 1 vdup1 LHS
  2622642056U, // <1,1,u,2>: Cost 3 vext2 <0,u,1,1>, <u,2,3,3>
  2014142566U, // <1,1,u,3>: Cost 2 vtrnr LHS, LHS
  1483115830U, // <1,1,u,4>: Cost 2 vext1 <1,1,1,1>, RHS
  1548900506U, // <1,1,u,5>: Cost 2 vext2 <0,u,1,1>, RHS
  2622642384U, // <1,1,u,6>: Cost 3 vext2 <0,u,1,1>, <u,6,3,7>
  2825293353U, // <1,1,u,7>: Cost 3 vuzpr <1,1,1,1>, RHS
  202162278U, // <1,1,u,u>: Cost 1 vdup1 LHS
  2635251712U, // <1,2,0,0>: Cost 3 vext2 <3,0,1,2>, <0,0,0,0>
  1561509990U, // <1,2,0,1>: Cost 2 vext2 <3,0,1,2>, LHS
  2618663085U, // <1,2,0,2>: Cost 3 vext2 <0,2,1,2>, <0,2,1,2>
  2696529358U, // <1,2,0,3>: Cost 3 vext3 <2,0,3,1>, <2,0,3,1>
  2635252050U, // <1,2,0,4>: Cost 3 vext2 <3,0,1,2>, <0,4,1,5>
  3769533926U, // <1,2,0,5>: Cost 4 vext3 <1,u,2,1>, <2,0,5,7>
  2621317617U, // <1,2,0,6>: Cost 3 vext2 <0,6,1,2>, <0,6,1,2>
  2659140170U, // <1,2,0,7>: Cost 3 vext2 <7,0,1,2>, <0,7,2,1>
  1561510557U, // <1,2,0,u>: Cost 2 vext2 <3,0,1,2>, LHS
  2623308516U, // <1,2,1,0>: Cost 3 vext2 <1,0,1,2>, <1,0,1,2>
  2635252532U, // <1,2,1,1>: Cost 3 vext2 <3,0,1,2>, <1,1,1,1>
  2631271318U, // <1,2,1,2>: Cost 3 vext2 <2,3,1,2>, <1,2,3,0>
  2958180454U, // <1,2,1,3>: Cost 3 vzipr <0,u,1,1>, LHS
  2550959414U, // <1,2,1,4>: Cost 3 vext1 <0,1,2,1>, RHS
  2635252880U, // <1,2,1,5>: Cost 3 vext2 <3,0,1,2>, <1,5,3,7>
  2635252952U, // <1,2,1,6>: Cost 3 vext2 <3,0,1,2>, <1,6,2,7>
  3732882731U, // <1,2,1,7>: Cost 4 vext2 <7,0,1,2>, <1,7,3,0>
  2958180459U, // <1,2,1,u>: Cost 3 vzipr <0,u,1,1>, LHS
  2629281213U, // <1,2,2,0>: Cost 3 vext2 <2,0,1,2>, <2,0,1,2>
  2635253280U, // <1,2,2,1>: Cost 3 vext2 <3,0,1,2>, <2,1,3,2>
  2618664552U, // <1,2,2,2>: Cost 3 vext2 <0,2,1,2>, <2,2,2,2>
  2689746546U, // <1,2,2,3>: Cost 3 vext3 <0,u,1,1>, <2,2,3,3>
  3764815485U, // <1,2,2,4>: Cost 4 vext3 <1,1,1,1>, <2,2,4,5>
  3760023176U, // <1,2,2,5>: Cost 4 vext3 <0,2,u,1>, <2,2,5,7>
  2635253690U, // <1,2,2,6>: Cost 3 vext2 <3,0,1,2>, <2,6,3,7>
  2659141610U, // <1,2,2,7>: Cost 3 vext2 <7,0,1,2>, <2,7,0,1>
  2689746591U, // <1,2,2,u>: Cost 3 vext3 <0,u,1,1>, <2,2,u,3>
  403488870U, // <1,2,3,0>: Cost 1 vext1 LHS, LHS
  1477231350U, // <1,2,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
  1477232232U, // <1,2,3,2>: Cost 2 vext1 LHS, <2,2,2,2>
  1477233052U, // <1,2,3,3>: Cost 2 vext1 LHS, <3,3,3,3>
  403492150U, // <1,2,3,4>: Cost 1 vext1 LHS, RHS
  1525010128U, // <1,2,3,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1525010938U, // <1,2,3,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1525011450U, // <1,2,3,7>: Cost 2 vext1 LHS, <7,0,1,2>
  403494702U, // <1,2,3,u>: Cost 1 vext1 LHS, LHS
  2641226607U, // <1,2,4,0>: Cost 3 vext2 <4,0,1,2>, <4,0,1,2>
  3624723446U, // <1,2,4,1>: Cost 4 vext1 <0,1,2,4>, <1,3,4,6>
  3301123609U, // <1,2,4,2>: Cost 4 vrev <2,1,2,4>
  2598759198U, // <1,2,4,3>: Cost 3 vext1 <u,1,2,4>, <3,u,1,2>
  2659142864U, // <1,2,4,4>: Cost 3 vext2 <7,0,1,2>, <4,4,4,4>
  1561513270U, // <1,2,4,5>: Cost 2 vext2 <3,0,1,2>, RHS
  2659143028U, // <1,2,4,6>: Cost 3 vext2 <7,0,1,2>, <4,6,4,6>
  2659143112U, // <1,2,4,7>: Cost 3 vext2 <7,0,1,2>, <4,7,5,0>
  1561513513U, // <1,2,4,u>: Cost 2 vext2 <3,0,1,2>, RHS
  2550988902U, // <1,2,5,0>: Cost 3 vext1 <0,1,2,5>, LHS
  2550989824U, // <1,2,5,1>: Cost 3 vext1 <0,1,2,5>, <1,3,5,7>
  3624732264U, // <1,2,5,2>: Cost 4 vext1 <0,1,2,5>, <2,2,2,2>
  2955559014U, // <1,2,5,3>: Cost 3 vzipr <0,4,1,5>, LHS
  2550992182U, // <1,2,5,4>: Cost 3 vext1 <0,1,2,5>, RHS
  2659143684U, // <1,2,5,5>: Cost 3 vext2 <7,0,1,2>, <5,5,5,5>
  2659143778U, // <1,2,5,6>: Cost 3 vext2 <7,0,1,2>, <5,6,7,0>
  2659143848U, // <1,2,5,7>: Cost 3 vext2 <7,0,1,2>, <5,7,5,7>
  2550994734U, // <1,2,5,u>: Cost 3 vext1 <0,1,2,5>, LHS
  2700289945U, // <1,2,6,0>: Cost 3 vext3 <2,6,0,1>, <2,6,0,1>
  2635256232U, // <1,2,6,1>: Cost 3 vext2 <3,0,1,2>, <6,1,7,2>
  2659144186U, // <1,2,6,2>: Cost 3 vext2 <7,0,1,2>, <6,2,7,3>
  2689746874U, // <1,2,6,3>: Cost 3 vext3 <0,u,1,1>, <2,6,3,7>
  3763488705U, // <1,2,6,4>: Cost 4 vext3 <0,u,1,1>, <2,6,4,5>
  3763488716U, // <1,2,6,5>: Cost 4 vext3 <0,u,1,1>, <2,6,5,7>
  2659144504U, // <1,2,6,6>: Cost 3 vext2 <7,0,1,2>, <6,6,6,6>
  2657817432U, // <1,2,6,7>: Cost 3 vext2 <6,7,1,2>, <6,7,1,2>
  2689746919U, // <1,2,6,u>: Cost 3 vext3 <0,u,1,1>, <2,6,u,7>
  1585402874U, // <1,2,7,0>: Cost 2 vext2 <7,0,1,2>, <7,0,1,2>
  2659144770U, // <1,2,7,1>: Cost 3 vext2 <7,0,1,2>, <7,1,0,2>
  3708998858U, // <1,2,7,2>: Cost 4 vext2 <3,0,1,2>, <7,2,6,3>
  2635257059U, // <1,2,7,3>: Cost 3 vext2 <3,0,1,2>, <7,3,0,1>
  2659145062U, // <1,2,7,4>: Cost 3 vext2 <7,0,1,2>, <7,4,5,6>
  3732886916U, // <1,2,7,5>: Cost 4 vext2 <7,0,1,2>, <7,5,0,0>
  3732886998U, // <1,2,7,6>: Cost 4 vext2 <7,0,1,2>, <7,6,0,1>
  2659145255U, // <1,2,7,7>: Cost 3 vext2 <7,0,1,2>, <7,7,0,1>
  1590711938U, // <1,2,7,u>: Cost 2 vext2 <7,u,1,2>, <7,u,1,2>
  403529835U, // <1,2,u,0>: Cost 1 vext1 LHS, LHS
  1477272310U, // <1,2,u,1>: Cost 2 vext1 LHS, <1,0,3,2>
  1477273192U, // <1,2,u,2>: Cost 2 vext1 LHS, <2,2,2,2>
  1477273750U, // <1,2,u,3>: Cost 2 vext1 LHS, <3,0,1,2>
  403533110U, // <1,2,u,4>: Cost 1 vext1 LHS, RHS
  1561516186U, // <1,2,u,5>: Cost 2 vext2 <3,0,1,2>, RHS
  1525051898U, // <1,2,u,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1525052410U, // <1,2,u,7>: Cost 2 vext1 LHS, <7,0,1,2>
  403535662U, // <1,2,u,u>: Cost 1 vext1 LHS, LHS
  2819407872U, // <1,3,0,0>: Cost 3 vuzpr LHS, <0,0,0,0>
  1551564902U, // <1,3,0,1>: Cost 2 vext2 <1,3,1,3>, LHS
  2819408630U, // <1,3,0,2>: Cost 3 vuzpr LHS, <1,0,3,2>
  2619334911U, // <1,3,0,3>: Cost 3 vext2 <0,3,1,3>, <0,3,1,3>
  2625306962U, // <1,3,0,4>: Cost 3 vext2 <1,3,1,3>, <0,4,1,5>
  3832725879U, // <1,3,0,5>: Cost 4 vuzpl <1,2,3,0>, <0,4,5,6>
  3699048959U, // <1,3,0,6>: Cost 4 vext2 <1,3,1,3>, <0,6,2,7>
  3776538827U, // <1,3,0,7>: Cost 4 vext3 <3,0,7,1>, <3,0,7,1>
  1551565469U, // <1,3,0,u>: Cost 2 vext2 <1,3,1,3>, LHS
  2618671862U, // <1,3,1,0>: Cost 3 vext2 <0,2,1,3>, <1,0,3,2>
  2819408692U, // <1,3,1,1>: Cost 3 vuzpr LHS, <1,1,1,1>
  2624643975U, // <1,3,1,2>: Cost 3 vext2 <1,2,1,3>, <1,2,1,3>
  1745666150U, // <1,3,1,3>: Cost 2 vuzpr LHS, LHS
  2557005110U, // <1,3,1,4>: Cost 3 vext1 <1,1,3,1>, RHS
  2625307792U, // <1,3,1,5>: Cost 3 vext2 <1,3,1,3>, <1,5,3,7>
  3698386127U, // <1,3,1,6>: Cost 4 vext2 <1,2,1,3>, <1,6,1,7>
  2592838748U, // <1,3,1,7>: Cost 3 vext1 <7,1,3,1>, <7,1,3,1>
  1745666155U, // <1,3,1,u>: Cost 2 vuzpr LHS, LHS
  2819408790U, // <1,3,2,0>: Cost 3 vuzpr LHS, <1,2,3,0>
  2625308193U, // <1,3,2,1>: Cost 3 vext2 <1,3,1,3>, <2,1,3,3>
  2819408036U, // <1,3,2,2>: Cost 3 vuzpr LHS, <0,2,0,2>
  2819851890U, // <1,3,2,3>: Cost 3 vuzpr LHS, <2,2,3,3>
  2819408794U, // <1,3,2,4>: Cost 3 vuzpr LHS, <1,2,3,4>
  3893149890U, // <1,3,2,5>: Cost 4 vuzpr LHS, <0,2,3,5>
  2819408076U, // <1,3,2,6>: Cost 3 vuzpr LHS, <0,2,4,6>
  3772041583U, // <1,3,2,7>: Cost 4 vext3 <2,3,0,1>, <3,2,7,3>
  2819408042U, // <1,3,2,u>: Cost 3 vuzpr LHS, <0,2,0,u>
  1483276390U, // <1,3,3,0>: Cost 2 vext1 <1,1,3,3>, LHS
  1483277128U, // <1,3,3,1>: Cost 2 vext1 <1,1,3,3>, <1,1,3,3>
  2557019752U, // <1,3,3,2>: Cost 3 vext1 <1,1,3,3>, <2,2,2,2>
  2819408856U, // <1,3,3,3>: Cost 3 vuzpr LHS, <1,3,1,3>
  1483279670U, // <1,3,3,4>: Cost 2 vext1 <1,1,3,3>, RHS
  2819409614U, // <1,3,3,5>: Cost 3 vuzpr LHS, <2,3,4,5>
  2598826490U, // <1,3,3,6>: Cost 3 vext1 <u,1,3,3>, <6,2,7,3>
  3087844352U, // <1,3,3,7>: Cost 3 vtrnr LHS, <1,3,5,7>
  1483282222U, // <1,3,3,u>: Cost 2 vext1 <1,1,3,3>, LHS
  2568970342U, // <1,3,4,0>: Cost 3 vext1 <3,1,3,4>, LHS
  2568971224U, // <1,3,4,1>: Cost 3 vext1 <3,1,3,4>, <1,3,1,3>
  3832761290U, // <1,3,4,2>: Cost 4 vuzpl <1,2,3,4>, <4,1,2,3>
  2233428219U, // <1,3,4,3>: Cost 3 vrev <3,1,3,4>
  2568973622U, // <1,3,4,4>: Cost 3 vext1 <3,1,3,4>, RHS
  1551568182U, // <1,3,4,5>: Cost 2 vext2 <1,3,1,3>, RHS
  2819410434U, // <1,3,4,6>: Cost 3 vuzpr LHS, <3,4,5,6>
  3666605151U, // <1,3,4,7>: Cost 4 vext1 <7,1,3,4>, <7,1,3,4>
  1551568425U, // <1,3,4,u>: Cost 2 vext2 <1,3,1,3>, RHS
  2563006566U, // <1,3,5,0>: Cost 3 vext1 <2,1,3,5>, LHS
  2568979456U, // <1,3,5,1>: Cost 3 vext1 <3,1,3,5>, <1,3,5,7>
  2563008035U, // <1,3,5,2>: Cost 3 vext1 <2,1,3,5>, <2,1,3,5>
  2233436412U, // <1,3,5,3>: Cost 3 vrev <3,1,3,5>
  2563009846U, // <1,3,5,4>: Cost 3 vext1 <2,1,3,5>, RHS
  2867187716U, // <1,3,5,5>: Cost 3 vuzpr LHS, <5,5,5,5>
  2655834214U, // <1,3,5,6>: Cost 3 vext2 <6,4,1,3>, <5,6,7,4>
  1745669430U, // <1,3,5,7>: Cost 2 vuzpr LHS, RHS
  1745669431U, // <1,3,5,u>: Cost 2 vuzpr LHS, RHS
  2867187810U, // <1,3,6,0>: Cost 3 vuzpr LHS, <5,6,7,0>
  3699052931U, // <1,3,6,1>: Cost 4 vext2 <1,3,1,3>, <6,1,3,1>
  2654507460U, // <1,3,6,2>: Cost 3 vext2 <6,2,1,3>, <6,2,1,3>
  3766291091U, // <1,3,6,3>: Cost 4 vext3 <1,3,3,1>, <3,6,3,7>
  2655834726U, // <1,3,6,4>: Cost 3 vext2 <6,4,1,3>, <6,4,1,3>
  3923384562U, // <1,3,6,5>: Cost 4 vuzpr <5,1,7,3>, <u,6,7,5>
  2657161992U, // <1,3,6,6>: Cost 3 vext2 <6,6,1,3>, <6,6,1,3>
  2819852218U, // <1,3,6,7>: Cost 3 vuzpr LHS, <2,6,3,7>
  2819852219U, // <1,3,6,u>: Cost 3 vuzpr LHS, <2,6,3,u>
  2706926275U, // <1,3,7,0>: Cost 3 vext3 <3,7,0,1>, <3,7,0,1>
  2659816524U, // <1,3,7,1>: Cost 3 vext2 <7,1,1,3>, <7,1,1,3>
  3636766245U, // <1,3,7,2>: Cost 4 vext1 <2,1,3,7>, <2,1,3,7>
  2867187903U, // <1,3,7,3>: Cost 3 vuzpr LHS, <5,7,u,3>
  2625312102U, // <1,3,7,4>: Cost 3 vext2 <1,3,1,3>, <7,4,5,6>
  2867188598U, // <1,3,7,5>: Cost 3 vuzpr LHS, <6,7,4,5>
  3728250344U, // <1,3,7,6>: Cost 4 vext2 <6,2,1,3>, <7,6,2,1>
  2867187880U, // <1,3,7,7>: Cost 3 vuzpr LHS, <5,7,5,7>
  2707516171U, // <1,3,7,u>: Cost 3 vext3 <3,7,u,1>, <3,7,u,1>
  1483317350U, // <1,3,u,0>: Cost 2 vext1 <1,1,3,u>, LHS
  1483318093U, // <1,3,u,1>: Cost 2 vext1 <1,1,3,u>, <1,1,3,u>
  2819410718U, // <1,3,u,2>: Cost 3 vuzpr LHS, <3,u,1,2>
  1745666717U, // <1,3,u,3>: Cost 2 vuzpr LHS, LHS
  1483320630U, // <1,3,u,4>: Cost 2 vext1 <1,1,3,u>, RHS
  1551571098U, // <1,3,u,5>: Cost 2 vext2 <1,3,1,3>, RHS
  2819410758U, // <1,3,u,6>: Cost 3 vuzpr LHS, <3,u,5,6>
  1745669673U, // <1,3,u,7>: Cost 2 vuzpr LHS, RHS
  1745666722U, // <1,3,u,u>: Cost 2 vuzpr LHS, LHS
  2617352205U, // <1,4,0,0>: Cost 3 vext2 <0,0,1,4>, <0,0,1,4>
  2619342950U, // <1,4,0,1>: Cost 3 vext2 <0,3,1,4>, LHS
  3692421295U, // <1,4,0,2>: Cost 4 vext2 <0,2,1,4>, <0,2,1,4>
  2619343104U, // <1,4,0,3>: Cost 3 vext2 <0,3,1,4>, <0,3,1,4>
  2617352530U, // <1,4,0,4>: Cost 3 vext2 <0,0,1,4>, <0,4,1,5>
  1634880402U, // <1,4,0,5>: Cost 2 vext3 <4,0,5,1>, <4,0,5,1>
  2713930652U, // <1,4,0,6>: Cost 3 vext3 <4,u,5,1>, <4,0,6,2>
  3732898396U, // <1,4,0,7>: Cost 4 vext2 <7,0,1,4>, <0,7,4,1>
  1635101613U, // <1,4,0,u>: Cost 2 vext3 <4,0,u,1>, <4,0,u,1>
  3693085430U, // <1,4,1,0>: Cost 4 vext2 <0,3,1,4>, <1,0,3,2>
  2623988535U, // <1,4,1,1>: Cost 3 vext2 <1,1,1,4>, <1,1,1,4>
  3693085590U, // <1,4,1,2>: Cost 4 vext2 <0,3,1,4>, <1,2,3,0>
  3692422134U, // <1,4,1,3>: Cost 4 vext2 <0,2,1,4>, <1,3,4,6>
  3693085726U, // <1,4,1,4>: Cost 4 vext2 <0,3,1,4>, <1,4,0,1>
  2892401974U, // <1,4,1,5>: Cost 3 vzipl <1,1,1,1>, RHS
  3026619702U, // <1,4,1,6>: Cost 3 vtrnl <1,1,1,1>, RHS
  3800206324U, // <1,4,1,7>: Cost 4 vext3 <7,0,4,1>, <4,1,7,0>
  2892402217U, // <1,4,1,u>: Cost 3 vzipl <1,1,1,1>, RHS
  3966978927U, // <1,4,2,0>: Cost 4 vzipl <1,2,3,4>, <4,0,1,2>
  3966979018U, // <1,4,2,1>: Cost 4 vzipl <1,2,3,4>, <4,1,2,3>
  3693086312U, // <1,4,2,2>: Cost 4 vext2 <0,3,1,4>, <2,2,2,2>
  2635269798U, // <1,4,2,3>: Cost 3 vext2 <3,0,1,4>, <2,3,0,1>
  3966979280U, // <1,4,2,4>: Cost 4 vzipl <1,2,3,4>, <4,4,4,4>
  2893204790U, // <1,4,2,5>: Cost 3 vzipl <1,2,3,0>, RHS
  3693086650U, // <1,4,2,6>: Cost 4 vext2 <0,3,1,4>, <2,6,3,7>
  3666662502U, // <1,4,2,7>: Cost 4 vext1 <7,1,4,2>, <7,1,4,2>
  2893205033U, // <1,4,2,u>: Cost 3 vzipl <1,2,3,0>, RHS
  2563063910U, // <1,4,3,0>: Cost 3 vext1 <2,1,4,3>, LHS
  2563064730U, // <1,4,3,1>: Cost 3 vext1 <2,1,4,3>, <1,2,3,4>
  2563065386U, // <1,4,3,2>: Cost 3 vext1 <2,1,4,3>, <2,1,4,3>
  3693087132U, // <1,4,3,3>: Cost 4 vext2 <0,3,1,4>, <3,3,3,3>
  2619345410U, // <1,4,3,4>: Cost 3 vext2 <0,3,1,4>, <3,4,5,6>
  3087843666U, // <1,4,3,5>: Cost 3 vtrnr LHS, <0,4,1,5>
  3087843676U, // <1,4,3,6>: Cost 3 vtrnr LHS, <0,4,2,6>
  3666670695U, // <1,4,3,7>: Cost 4 vext1 <7,1,4,3>, <7,1,4,3>
  3087843669U, // <1,4,3,u>: Cost 3 vtrnr LHS, <0,4,1,u>
  2620672914U, // <1,4,4,0>: Cost 3 vext2 <0,5,1,4>, <4,0,5,1>
  3630842706U, // <1,4,4,1>: Cost 4 vext1 <1,1,4,4>, <1,1,4,4>
  3313069003U, // <1,4,4,2>: Cost 4 vrev <4,1,2,4>
  3642788100U, // <1,4,4,3>: Cost 4 vext1 <3,1,4,4>, <3,1,4,4>
  2713930960U, // <1,4,4,4>: Cost 3 vext3 <4,u,5,1>, <4,4,4,4>
  2619346230U, // <1,4,4,5>: Cost 3 vext2 <0,3,1,4>, RHS
  2713930980U, // <1,4,4,6>: Cost 3 vext3 <4,u,5,1>, <4,4,6,6>
  3736882642U, // <1,4,4,7>: Cost 4 vext2 <7,6,1,4>, <4,7,6,1>
  2619346473U, // <1,4,4,u>: Cost 3 vext2 <0,3,1,4>, RHS
  2557108326U, // <1,4,5,0>: Cost 3 vext1 <1,1,4,5>, LHS
  2557109075U, // <1,4,5,1>: Cost 3 vext1 <1,1,4,5>, <1,1,4,5>
  2598913774U, // <1,4,5,2>: Cost 3 vext1 <u,1,4,5>, <2,3,u,1>
  3630852246U, // <1,4,5,3>: Cost 4 vext1 <1,1,4,5>, <3,0,1,2>
  2557111606U, // <1,4,5,4>: Cost 3 vext1 <1,1,4,5>, RHS
  2895252790U, // <1,4,5,5>: Cost 3 vzipl <1,5,3,7>, RHS
  1616006454U, // <1,4,5,6>: Cost 2 vext3 <0,u,1,1>, RHS
  3899059510U, // <1,4,5,7>: Cost 4 vuzpr <1,1,1,4>, RHS
  1616006472U, // <1,4,5,u>: Cost 2 vext3 <0,u,1,1>, RHS
  2557116518U, // <1,4,6,0>: Cost 3 vext1 <1,1,4,6>, LHS
  2557117236U, // <1,4,6,1>: Cost 3 vext1 <1,1,4,6>, <1,1,1,1>
  3630859880U, // <1,4,6,2>: Cost 4 vext1 <1,1,4,6>, <2,2,2,2>
  2569062550U, // <1,4,6,3>: Cost 3 vext1 <3,1,4,6>, <3,0,1,2>
  2557119798U, // <1,4,6,4>: Cost 3 vext1 <1,1,4,6>, RHS
  3763490174U, // <1,4,6,5>: Cost 4 vext3 <0,u,1,1>, <4,6,5,7>
  3763490183U, // <1,4,6,6>: Cost 4 vext3 <0,u,1,1>, <4,6,6,7>
  2712751498U, // <1,4,6,7>: Cost 3 vext3 <4,6,7,1>, <4,6,7,1>
  2557122350U, // <1,4,6,u>: Cost 3 vext1 <1,1,4,6>, LHS
  2659161084U, // <1,4,7,0>: Cost 3 vext2 <7,0,1,4>, <7,0,1,4>
  3732903040U, // <1,4,7,1>: Cost 4 vext2 <7,0,1,4>, <7,1,7,1>
  3734230174U, // <1,4,7,2>: Cost 4 vext2 <7,2,1,4>, <7,2,1,4>
  3734893807U, // <1,4,7,3>: Cost 4 vext2 <7,3,1,4>, <7,3,1,4>
  3660729654U, // <1,4,7,4>: Cost 4 vext1 <6,1,4,7>, RHS
  3786493384U, // <1,4,7,5>: Cost 4 vext3 <4,6,7,1>, <4,7,5,0>
  2713341394U, // <1,4,7,6>: Cost 3 vext3 <4,7,6,1>, <4,7,6,1>
  3660731386U, // <1,4,7,7>: Cost 4 vext1 <6,1,4,7>, <7,0,1,2>
  2664470148U, // <1,4,7,u>: Cost 3 vext2 <7,u,1,4>, <7,u,1,4>
  2557132902U, // <1,4,u,0>: Cost 3 vext1 <1,1,4,u>, LHS
  2619348782U, // <1,4,u,1>: Cost 3 vext2 <0,3,1,4>, LHS
  2563106351U, // <1,4,u,2>: Cost 3 vext1 <2,1,4,u>, <2,1,4,u>
  2713783816U, // <1,4,u,3>: Cost 3 vext3 <4,u,3,1>, <4,u,3,1>
  2622666815U, // <1,4,u,4>: Cost 3 vext2 <0,u,1,4>, <u,4,5,6>
  1640189466U, // <1,4,u,5>: Cost 2 vext3 <4,u,5,1>, <4,u,5,1>
  1616006697U, // <1,4,u,6>: Cost 2 vext3 <0,u,1,1>, RHS
  2712751498U, // <1,4,u,7>: Cost 3 vext3 <4,6,7,1>, <4,6,7,1>
  1616006715U, // <1,4,u,u>: Cost 2 vext3 <0,u,1,1>, RHS
  2620014592U, // <1,5,0,0>: Cost 3 vext2 <0,4,1,5>, <0,0,0,0>
  1546272870U, // <1,5,0,1>: Cost 2 vext2 <0,4,1,5>, LHS
  2618687664U, // <1,5,0,2>: Cost 3 vext2 <0,2,1,5>, <0,2,1,5>
  3693093120U, // <1,5,0,3>: Cost 4 vext2 <0,3,1,5>, <0,3,1,4>
  1546273106U, // <1,5,0,4>: Cost 2 vext2 <0,4,1,5>, <0,4,1,5>
  2620678563U, // <1,5,0,5>: Cost 3 vext2 <0,5,1,5>, <0,5,1,5>
  2714668660U, // <1,5,0,6>: Cost 3 vext3 <5,0,6,1>, <5,0,6,1>
  3772042877U, // <1,5,0,7>: Cost 4 vext3 <2,3,0,1>, <5,0,7,1>
  1546273437U, // <1,5,0,u>: Cost 2 vext2 <0,4,1,5>, LHS
  2620015350U, // <1,5,1,0>: Cost 3 vext2 <0,4,1,5>, <1,0,3,2>
  2620015412U, // <1,5,1,1>: Cost 3 vext2 <0,4,1,5>, <1,1,1,1>
  2620015510U, // <1,5,1,2>: Cost 3 vext2 <0,4,1,5>, <1,2,3,0>
  2618688512U, // <1,5,1,3>: Cost 3 vext2 <0,2,1,5>, <1,3,5,7>
  2620015677U, // <1,5,1,4>: Cost 3 vext2 <0,4,1,5>, <1,4,3,5>
  2620015727U, // <1,5,1,5>: Cost 3 vext2 <0,4,1,5>, <1,5,0,1>
  2620015859U, // <1,5,1,6>: Cost 3 vext2 <0,4,1,5>, <1,6,5,7>
  3093728566U, // <1,5,1,7>: Cost 3 vtrnr <1,1,1,1>, RHS
  2620015981U, // <1,5,1,u>: Cost 3 vext2 <0,4,1,5>, <1,u,1,3>
  3692430816U, // <1,5,2,0>: Cost 4 vext2 <0,2,1,5>, <2,0,5,1>
  2620016163U, // <1,5,2,1>: Cost 3 vext2 <0,4,1,5>, <2,1,3,5>
  2620016232U, // <1,5,2,2>: Cost 3 vext2 <0,4,1,5>, <2,2,2,2>
  2620016294U, // <1,5,2,3>: Cost 3 vext2 <0,4,1,5>, <2,3,0,1>
  3693758221U, // <1,5,2,4>: Cost 4 vext2 <0,4,1,5>, <2,4,2,5>
  3692431209U, // <1,5,2,5>: Cost 4 vext2 <0,2,1,5>, <2,5,3,7>
  2620016570U, // <1,5,2,6>: Cost 3 vext2 <0,4,1,5>, <2,6,3,7>
  4173598006U, // <1,5,2,7>: Cost 4 vtrnr <2,1,3,2>, RHS
  2620016699U, // <1,5,2,u>: Cost 3 vext2 <0,4,1,5>, <2,u,0,1>
  2620016790U, // <1,5,3,0>: Cost 3 vext2 <0,4,1,5>, <3,0,1,2>
  2569110672U, // <1,5,3,1>: Cost 3 vext1 <3,1,5,3>, <1,5,3,7>
  3693758785U, // <1,5,3,2>: Cost 4 vext2 <0,4,1,5>, <3,2,2,2>
  2620017052U, // <1,5,3,3>: Cost 3 vext2 <0,4,1,5>, <3,3,3,3>
  2620017154U, // <1,5,3,4>: Cost 3 vext2 <0,4,1,5>, <3,4,5,6>
  3135623172U, // <1,5,3,5>: Cost 3 vtrnr LHS, <5,5,5,5>
  4161587048U, // <1,5,3,6>: Cost 4 vtrnr LHS, <2,5,3,6>
  2014104886U, // <1,5,3,7>: Cost 2 vtrnr LHS, RHS
  2014104887U, // <1,5,3,u>: Cost 2 vtrnr LHS, RHS
  2620017554U, // <1,5,4,0>: Cost 3 vext2 <0,4,1,5>, <4,0,5,1>
  2620017634U, // <1,5,4,1>: Cost 3 vext2 <0,4,1,5>, <4,1,5,0>
  3693759551U, // <1,5,4,2>: Cost 4 vext2 <0,4,1,5>, <4,2,6,3>
  3642861837U, // <1,5,4,3>: Cost 4 vext1 <3,1,5,4>, <3,1,5,4>
  2575092710U, // <1,5,4,4>: Cost 3 vext1 <4,1,5,4>, <4,1,5,4>
  1546276150U, // <1,5,4,5>: Cost 2 vext2 <0,4,1,5>, RHS
  2759855414U, // <1,5,4,6>: Cost 3 vuzpl <1,3,5,7>, RHS
  2713931718U, // <1,5,4,7>: Cost 3 vext3 <4,u,5,1>, <5,4,7,6>
  1546276393U, // <1,5,4,u>: Cost 2 vext2 <0,4,1,5>, RHS
  2557182054U, // <1,5,5,0>: Cost 3 vext1 <1,1,5,5>, LHS
  2557182812U, // <1,5,5,1>: Cost 3 vext1 <1,1,5,5>, <1,1,5,5>
  3630925347U, // <1,5,5,2>: Cost 4 vext1 <1,1,5,5>, <2,1,3,5>
  4029301675U, // <1,5,5,3>: Cost 4 vzipr <0,4,1,5>, <1,2,5,3>
  2557185334U, // <1,5,5,4>: Cost 3 vext1 <1,1,5,5>, RHS
  2713931780U, // <1,5,5,5>: Cost 3 vext3 <4,u,5,1>, <5,5,5,5>
  2667794530U, // <1,5,5,6>: Cost 3 vext2 <u,4,1,5>, <5,6,7,0>
  2713931800U, // <1,5,5,7>: Cost 3 vext3 <4,u,5,1>, <5,5,7,7>
  2557187886U, // <1,5,5,u>: Cost 3 vext1 <1,1,5,5>, LHS
  2718208036U, // <1,5,6,0>: Cost 3 vext3 <5,6,0,1>, <5,6,0,1>
  2620019115U, // <1,5,6,1>: Cost 3 vext2 <0,4,1,5>, <6,1,7,5>
  2667794938U, // <1,5,6,2>: Cost 3 vext2 <u,4,1,5>, <6,2,7,3>
  3787673666U, // <1,5,6,3>: Cost 4 vext3 <4,u,5,1>, <5,6,3,4>
  3693761165U, // <1,5,6,4>: Cost 4 vext2 <0,4,1,5>, <6,4,5,6>
  3319279297U, // <1,5,6,5>: Cost 4 vrev <5,1,5,6>
  2667795256U, // <1,5,6,6>: Cost 3 vext2 <u,4,1,5>, <6,6,6,6>
  2713931874U, // <1,5,6,7>: Cost 3 vext3 <4,u,5,1>, <5,6,7,0>
  2713931883U, // <1,5,6,u>: Cost 3 vext3 <4,u,5,1>, <5,6,u,0>
  2557198438U, // <1,5,7,0>: Cost 3 vext1 <1,1,5,7>, LHS
  2557199156U, // <1,5,7,1>: Cost 3 vext1 <1,1,5,7>, <1,1,1,1>
  2569143974U, // <1,5,7,2>: Cost 3 vext1 <3,1,5,7>, <2,3,0,1>
  2569144592U, // <1,5,7,3>: Cost 3 vext1 <3,1,5,7>, <3,1,5,7>
  2557201718U, // <1,5,7,4>: Cost 3 vext1 <1,1,5,7>, RHS
  2713931944U, // <1,5,7,5>: Cost 3 vext3 <4,u,5,1>, <5,7,5,7>
  3787673770U, // <1,5,7,6>: Cost 4 vext3 <4,u,5,1>, <5,7,6,0>
  2719387828U, // <1,5,7,7>: Cost 3 vext3 <5,7,7,1>, <5,7,7,1>
  2557204270U, // <1,5,7,u>: Cost 3 vext1 <1,1,5,7>, LHS
  2620020435U, // <1,5,u,0>: Cost 3 vext2 <0,4,1,5>, <u,0,1,2>
  1546278702U, // <1,5,u,1>: Cost 2 vext2 <0,4,1,5>, LHS
  2620020616U, // <1,5,u,2>: Cost 3 vext2 <0,4,1,5>, <u,2,3,3>
  2620020668U, // <1,5,u,3>: Cost 3 vext2 <0,4,1,5>, <u,3,0,1>
  1594054682U, // <1,5,u,4>: Cost 2 vext2 <u,4,1,5>, <u,4,1,5>
  1546279066U, // <1,5,u,5>: Cost 2 vext2 <0,4,1,5>, RHS
  2620020944U, // <1,5,u,6>: Cost 3 vext2 <0,4,1,5>, <u,6,3,7>
  2014145846U, // <1,5,u,7>: Cost 2 vtrnr LHS, RHS
  2014145847U, // <1,5,u,u>: Cost 2 vtrnr LHS, RHS
  3692437504U, // <1,6,0,0>: Cost 4 vext2 <0,2,1,6>, <0,0,0,0>
  2618695782U, // <1,6,0,1>: Cost 3 vext2 <0,2,1,6>, LHS
  2618695857U, // <1,6,0,2>: Cost 3 vext2 <0,2,1,6>, <0,2,1,6>
  3794161970U, // <1,6,0,3>: Cost 4 vext3 <6,0,3,1>, <6,0,3,1>
  2620023122U, // <1,6,0,4>: Cost 3 vext2 <0,4,1,6>, <0,4,1,5>
  2620686756U, // <1,6,0,5>: Cost 3 vext2 <0,5,1,6>, <0,5,1,6>
  2621350389U, // <1,6,0,6>: Cost 3 vext2 <0,6,1,6>, <0,6,1,6>
  4028599606U, // <1,6,0,7>: Cost 4 vzipr <0,3,1,0>, RHS
  2618696349U, // <1,6,0,u>: Cost 3 vext2 <0,2,1,6>, LHS
  3692438262U, // <1,6,1,0>: Cost 4 vext2 <0,2,1,6>, <1,0,3,2>
  2625995572U, // <1,6,1,1>: Cost 3 vext2 <1,4,1,6>, <1,1,1,1>
  3692438422U, // <1,6,1,2>: Cost 4 vext2 <0,2,1,6>, <1,2,3,0>
  3692438488U, // <1,6,1,3>: Cost 4 vext2 <0,2,1,6>, <1,3,1,3>
  2625995820U, // <1,6,1,4>: Cost 3 vext2 <1,4,1,6>, <1,4,1,6>
  3692438672U, // <1,6,1,5>: Cost 4 vext2 <0,2,1,6>, <1,5,3,7>
  3692438720U, // <1,6,1,6>: Cost 4 vext2 <0,2,1,6>, <1,6,0,1>
  2958183734U, // <1,6,1,7>: Cost 3 vzipr <0,u,1,1>, RHS
  2958183735U, // <1,6,1,u>: Cost 3 vzipr <0,u,1,1>, RHS
  2721526201U, // <1,6,2,0>: Cost 3 vext3 <6,2,0,1>, <6,2,0,1>
  3692439097U, // <1,6,2,1>: Cost 4 vext2 <0,2,1,6>, <2,1,6,0>
  3692439144U, // <1,6,2,2>: Cost 4 vext2 <0,2,1,6>, <2,2,2,2>
  3692439206U, // <1,6,2,3>: Cost 4 vext2 <0,2,1,6>, <2,3,0,1>
  3636948278U, // <1,6,2,4>: Cost 4 vext1 <2,1,6,2>, RHS
  3787674092U, // <1,6,2,5>: Cost 4 vext3 <4,u,5,1>, <6,2,5,7>
  2618697658U, // <1,6,2,6>: Cost 3 vext2 <0,2,1,6>, <2,6,3,7>
  2970799414U, // <1,6,2,7>: Cost 3 vzipr <3,0,1,2>, RHS
  2970799415U, // <1,6,2,u>: Cost 3 vzipr <3,0,1,2>, RHS
  2563211366U, // <1,6,3,0>: Cost 3 vext1 <2,1,6,3>, LHS
  3699738854U, // <1,6,3,1>: Cost 4 vext2 <1,4,1,6>, <3,1,1,1>
  2563212860U, // <1,6,3,2>: Cost 3 vext1 <2,1,6,3>, <2,1,6,3>
  3692439964U, // <1,6,3,3>: Cost 4 vext2 <0,2,1,6>, <3,3,3,3>
  2563214646U, // <1,6,3,4>: Cost 3 vext1 <2,1,6,3>, RHS
  4191820018U, // <1,6,3,5>: Cost 4 vtrnr <5,1,7,3>, <u,6,7,5>
  2587103648U, // <1,6,3,6>: Cost 3 vext1 <6,1,6,3>, <6,1,6,3>
  3087845306U, // <1,6,3,7>: Cost 3 vtrnr LHS, <2,6,3,7>
  3087845307U, // <1,6,3,u>: Cost 3 vtrnr LHS, <2,6,3,u>
  3693767570U, // <1,6,4,0>: Cost 4 vext2 <0,4,1,6>, <4,0,5,1>
  3693767650U, // <1,6,4,1>: Cost 4 vext2 <0,4,1,6>, <4,1,5,0>
  3636962877U, // <1,6,4,2>: Cost 4 vext1 <2,1,6,4>, <2,1,6,4>
  3325088134U, // <1,6,4,3>: Cost 4 vrev <6,1,3,4>
  3693767898U, // <1,6,4,4>: Cost 4 vext2 <0,4,1,6>, <4,4,5,5>
  2618699062U, // <1,6,4,5>: Cost 3 vext2 <0,2,1,6>, RHS
  3833670966U, // <1,6,4,6>: Cost 4 vuzpl <1,3,6,7>, RHS
  4028632374U, // <1,6,4,7>: Cost 4 vzipr <0,3,1,4>, RHS
  2618699305U, // <1,6,4,u>: Cost 3 vext2 <0,2,1,6>, RHS
  3693768264U, // <1,6,5,0>: Cost 4 vext2 <0,4,1,6>, <5,0,1,2>
  3630998373U, // <1,6,5,1>: Cost 4 vext1 <1,1,6,5>, <1,1,6,5>
  3636971070U, // <1,6,5,2>: Cost 4 vext1 <2,1,6,5>, <2,1,6,5>
  3642943767U, // <1,6,5,3>: Cost 4 vext1 <3,1,6,5>, <3,1,6,5>
  3693768628U, // <1,6,5,4>: Cost 4 vext2 <0,4,1,6>, <5,4,5,6>
  3732918276U, // <1,6,5,5>: Cost 4 vext2 <7,0,1,6>, <5,5,5,5>
  2620690530U, // <1,6,5,6>: Cost 3 vext2 <0,5,1,6>, <5,6,7,0>
  2955562294U, // <1,6,5,7>: Cost 3 vzipr <0,4,1,5>, RHS
  2955562295U, // <1,6,5,u>: Cost 3 vzipr <0,4,1,5>, RHS
  2724180733U, // <1,6,6,0>: Cost 3 vext3 <6,6,0,1>, <6,6,0,1>
  3631006566U, // <1,6,6,1>: Cost 4 vext1 <1,1,6,6>, <1,1,6,6>
  3631007674U, // <1,6,6,2>: Cost 4 vext1 <1,1,6,6>, <2,6,3,7>
  3692442184U, // <1,6,6,3>: Cost 4 vext2 <0,2,1,6>, <6,3,7,0>
  3631009078U, // <1,6,6,4>: Cost 4 vext1 <1,1,6,6>, RHS
  3787674416U, // <1,6,6,5>: Cost 4 vext3 <4,u,5,1>, <6,6,5,7>
  2713932600U, // <1,6,6,6>: Cost 3 vext3 <4,u,5,1>, <6,6,6,6>
  2713932610U, // <1,6,6,7>: Cost 3 vext3 <4,u,5,1>, <6,6,7,7>
  2713932619U, // <1,6,6,u>: Cost 3 vext3 <4,u,5,1>, <6,6,u,7>
  1651102542U, // <1,6,7,0>: Cost 2 vext3 <6,7,0,1>, <6,7,0,1>
  2724918103U, // <1,6,7,1>: Cost 3 vext3 <6,7,1,1>, <6,7,1,1>
  2698302306U, // <1,6,7,2>: Cost 3 vext3 <2,3,0,1>, <6,7,2,3>
  3642960153U, // <1,6,7,3>: Cost 4 vext1 <3,1,6,7>, <3,1,6,7>
  2713932662U, // <1,6,7,4>: Cost 3 vext3 <4,u,5,1>, <6,7,4,5>
  2725213051U, // <1,6,7,5>: Cost 3 vext3 <6,7,5,1>, <6,7,5,1>
  2724844426U, // <1,6,7,6>: Cost 3 vext3 <6,7,0,1>, <6,7,6,7>
  4035956022U, // <1,6,7,7>: Cost 4 vzipr <1,5,1,7>, RHS
  1651692438U, // <1,6,7,u>: Cost 2 vext3 <6,7,u,1>, <6,7,u,1>
  1651766175U, // <1,6,u,0>: Cost 2 vext3 <6,u,0,1>, <6,u,0,1>
  2618701614U, // <1,6,u,1>: Cost 3 vext2 <0,2,1,6>, LHS
  3135663508U, // <1,6,u,2>: Cost 3 vtrnr LHS, <4,6,u,2>
  3692443580U, // <1,6,u,3>: Cost 4 vext2 <0,2,1,6>, <u,3,0,1>
  2713932743U, // <1,6,u,4>: Cost 3 vext3 <4,u,5,1>, <6,u,4,5>
  2618701978U, // <1,6,u,5>: Cost 3 vext2 <0,2,1,6>, RHS
  2622683344U, // <1,6,u,6>: Cost 3 vext2 <0,u,1,6>, <u,6,3,7>
  3087886266U, // <1,6,u,7>: Cost 3 vtrnr LHS, <2,6,3,7>
  1652356071U, // <1,6,u,u>: Cost 2 vext3 <6,u,u,1>, <6,u,u,1>
  2726171632U, // <1,7,0,0>: Cost 3 vext3 <7,0,0,1>, <7,0,0,1>
  2626666598U, // <1,7,0,1>: Cost 3 vext2 <1,5,1,7>, LHS
  3695100067U, // <1,7,0,2>: Cost 4 vext2 <0,6,1,7>, <0,2,0,1>
  3707044102U, // <1,7,0,3>: Cost 4 vext2 <2,6,1,7>, <0,3,2,1>
  2726466580U, // <1,7,0,4>: Cost 3 vext3 <7,0,4,1>, <7,0,4,1>
  3654921933U, // <1,7,0,5>: Cost 4 vext1 <5,1,7,0>, <5,1,7,0>
  2621358582U, // <1,7,0,6>: Cost 3 vext2 <0,6,1,7>, <0,6,1,7>
  2622022215U, // <1,7,0,7>: Cost 3 vext2 <0,7,1,7>, <0,7,1,7>
  2626667165U, // <1,7,0,u>: Cost 3 vext2 <1,5,1,7>, LHS
  2593128550U, // <1,7,1,0>: Cost 3 vext1 <7,1,7,1>, LHS
  2626667316U, // <1,7,1,1>: Cost 3 vext2 <1,5,1,7>, <1,1,1,1>
  3700409238U, // <1,7,1,2>: Cost 4 vext2 <1,5,1,7>, <1,2,3,0>
  2257294428U, // <1,7,1,3>: Cost 3 vrev <7,1,3,1>
  2593131830U, // <1,7,1,4>: Cost 3 vext1 <7,1,7,1>, RHS
  2626667646U, // <1,7,1,5>: Cost 3 vext2 <1,5,1,7>, <1,5,1,7>
  2627331279U, // <1,7,1,6>: Cost 3 vext2 <1,6,1,7>, <1,6,1,7>
  2593133696U, // <1,7,1,7>: Cost 3 vext1 <7,1,7,1>, <7,1,7,1>
  2628658545U, // <1,7,1,u>: Cost 3 vext2 <1,u,1,7>, <1,u,1,7>
  2587164774U, // <1,7,2,0>: Cost 3 vext1 <6,1,7,2>, LHS
  3701073445U, // <1,7,2,1>: Cost 4 vext2 <1,6,1,7>, <2,1,3,7>
  3700409960U, // <1,7,2,2>: Cost 4 vext2 <1,5,1,7>, <2,2,2,2>
  2638612134U, // <1,7,2,3>: Cost 3 vext2 <3,5,1,7>, <2,3,0,1>
  2587168054U, // <1,7,2,4>: Cost 3 vext1 <6,1,7,2>, RHS
  3706382167U, // <1,7,2,5>: Cost 4 vext2 <2,5,1,7>, <2,5,1,7>
  2587169192U, // <1,7,2,6>: Cost 3 vext1 <6,1,7,2>, <6,1,7,2>
  3660911610U, // <1,7,2,7>: Cost 4 vext1 <6,1,7,2>, <7,0,1,2>
  2587170606U, // <1,7,2,u>: Cost 3 vext1 <6,1,7,2>, LHS
  1507459174U, // <1,7,3,0>: Cost 2 vext1 <5,1,7,3>, LHS
  2569257984U, // <1,7,3,1>: Cost 3 vext1 <3,1,7,3>, <1,3,5,7>
  2581202536U, // <1,7,3,2>: Cost 3 vext1 <5,1,7,3>, <2,2,2,2>
  2569259294U, // <1,7,3,3>: Cost 3 vext1 <3,1,7,3>, <3,1,7,3>
  1507462454U, // <1,7,3,4>: Cost 2 vext1 <5,1,7,3>, RHS
  1507462864U, // <1,7,3,5>: Cost 2 vext1 <5,1,7,3>, <5,1,7,3>
  2581205498U, // <1,7,3,6>: Cost 3 vext1 <5,1,7,3>, <6,2,7,3>
  2581206010U, // <1,7,3,7>: Cost 3 vext1 <5,1,7,3>, <7,0,1,2>
  1507465006U, // <1,7,3,u>: Cost 2 vext1 <5,1,7,3>, LHS
  2728826164U, // <1,7,4,0>: Cost 3 vext3 <7,4,0,1>, <7,4,0,1>
  3654951732U, // <1,7,4,1>: Cost 4 vext1 <5,1,7,4>, <1,1,1,1>
  3330987094U, // <1,7,4,2>: Cost 4 vrev <7,1,2,4>
  3331060831U, // <1,7,4,3>: Cost 4 vrev <7,1,3,4>
  3787674971U, // <1,7,4,4>: Cost 4 vext3 <4,u,5,1>, <7,4,4,4>
  2626669878U, // <1,7,4,5>: Cost 3 vext2 <1,5,1,7>, RHS
  3785979241U, // <1,7,4,6>: Cost 4 vext3 <4,6,0,1>, <7,4,6,0>
  3787085176U, // <1,7,4,7>: Cost 4 vext3 <4,7,6,1>, <7,4,7,6>
  2626670121U, // <1,7,4,u>: Cost 3 vext2 <1,5,1,7>, RHS
  2569273446U, // <1,7,5,0>: Cost 3 vext1 <3,1,7,5>, LHS
  2569274368U, // <1,7,5,1>: Cost 3 vext1 <3,1,7,5>, <1,3,5,7>
  3643016808U, // <1,7,5,2>: Cost 4 vext1 <3,1,7,5>, <2,2,2,2>
  2569275680U, // <1,7,5,3>: Cost 3 vext1 <3,1,7,5>, <3,1,7,5>
  2569276726U, // <1,7,5,4>: Cost 3 vext1 <3,1,7,5>, RHS
  4102034790U, // <1,7,5,5>: Cost 4 vtrnl <1,3,5,7>, <7,4,5,6>
  2651222067U, // <1,7,5,6>: Cost 3 vext2 <5,6,1,7>, <5,6,1,7>
  3899378998U, // <1,7,5,7>: Cost 4 vuzpr <1,1,5,7>, RHS
  2569279278U, // <1,7,5,u>: Cost 3 vext1 <3,1,7,5>, LHS
  2730153430U, // <1,7,6,0>: Cost 3 vext3 <7,6,0,1>, <7,6,0,1>
  2724845022U, // <1,7,6,1>: Cost 3 vext3 <6,7,0,1>, <7,6,1,0>
  3643025338U, // <1,7,6,2>: Cost 4 vext1 <3,1,7,6>, <2,6,3,7>
  3643025697U, // <1,7,6,3>: Cost 4 vext1 <3,1,7,6>, <3,1,7,6>
  3643026742U, // <1,7,6,4>: Cost 4 vext1 <3,1,7,6>, RHS
  3654971091U, // <1,7,6,5>: Cost 4 vext1 <5,1,7,6>, <5,1,7,6>
  3787675153U, // <1,7,6,6>: Cost 4 vext3 <4,u,5,1>, <7,6,6,6>
  2724845076U, // <1,7,6,7>: Cost 3 vext3 <6,7,0,1>, <7,6,7,0>
  2725508637U, // <1,7,6,u>: Cost 3 vext3 <6,u,0,1>, <7,6,u,0>
  2730817063U, // <1,7,7,0>: Cost 3 vext3 <7,7,0,1>, <7,7,0,1>
  3631088436U, // <1,7,7,1>: Cost 4 vext1 <1,1,7,7>, <1,1,1,1>
  3660949158U, // <1,7,7,2>: Cost 4 vext1 <6,1,7,7>, <2,3,0,1>
  3801904705U, // <1,7,7,3>: Cost 4 vext3 <7,3,0,1>, <7,7,3,0>
  3631090998U, // <1,7,7,4>: Cost 4 vext1 <1,1,7,7>, RHS
  2662503828U, // <1,7,7,5>: Cost 3 vext2 <7,5,1,7>, <7,5,1,7>
  3660951981U, // <1,7,7,6>: Cost 4 vext1 <6,1,7,7>, <6,1,7,7>
  2713933420U, // <1,7,7,7>: Cost 3 vext3 <4,u,5,1>, <7,7,7,7>
  2731406959U, // <1,7,7,u>: Cost 3 vext3 <7,7,u,1>, <7,7,u,1>
  1507500134U, // <1,7,u,0>: Cost 2 vext1 <5,1,7,u>, LHS
  2626672430U, // <1,7,u,1>: Cost 3 vext2 <1,5,1,7>, LHS
  2581243496U, // <1,7,u,2>: Cost 3 vext1 <5,1,7,u>, <2,2,2,2>
  2569300259U, // <1,7,u,3>: Cost 3 vext1 <3,1,7,u>, <3,1,7,u>
  1507503414U, // <1,7,u,4>: Cost 2 vext1 <5,1,7,u>, RHS
  1507503829U, // <1,7,u,5>: Cost 2 vext1 <5,1,7,u>, <5,1,7,u>
  2581246458U, // <1,7,u,6>: Cost 3 vext1 <5,1,7,u>, <6,2,7,3>
  2581246970U, // <1,7,u,7>: Cost 3 vext1 <5,1,7,u>, <7,0,1,2>
  1507505966U, // <1,7,u,u>: Cost 2 vext1 <5,1,7,u>, LHS
  1543643153U, // <1,u,0,0>: Cost 2 vext2 <0,0,1,u>, <0,0,1,u>
  1546297446U, // <1,u,0,1>: Cost 2 vext2 <0,4,1,u>, LHS
  2819448852U, // <1,u,0,2>: Cost 3 vuzpr LHS, <0,0,2,2>
  2619375876U, // <1,u,0,3>: Cost 3 vext2 <0,3,1,u>, <0,3,1,u>
  1546297685U, // <1,u,0,4>: Cost 2 vext2 <0,4,1,u>, <0,4,1,u>
  1658771190U, // <1,u,0,5>: Cost 2 vext3 <u,0,5,1>, <u,0,5,1>
  2736789248U, // <1,u,0,6>: Cost 3 vext3 <u,7,0,1>, <u,0,6,2>
  2659189376U, // <1,u,0,7>: Cost 3 vext2 <7,0,1,u>, <0,7,u,1>
  1546298013U, // <1,u,0,u>: Cost 2 vext2 <0,4,1,u>, LHS
  1483112550U, // <1,u,1,0>: Cost 2 vext1 <1,1,1,1>, LHS
  202162278U, // <1,u,1,1>: Cost 1 vdup1 LHS
  1616009006U, // <1,u,1,2>: Cost 2 vext3 <0,u,1,1>, LHS
  1745707110U, // <1,u,1,3>: Cost 2 vuzpr LHS, LHS
  1483115830U, // <1,u,1,4>: Cost 2 vext1 <1,1,1,1>, RHS
  2620040336U, // <1,u,1,5>: Cost 3 vext2 <0,4,1,u>, <1,5,3,7>
  3026622618U, // <1,u,1,6>: Cost 3 vtrnl <1,1,1,1>, RHS
  2958183752U, // <1,u,1,7>: Cost 3 vzipr <0,u,1,1>, RHS
  202162278U, // <1,u,1,u>: Cost 1 vdup1 LHS
  2819449750U, // <1,u,2,0>: Cost 3 vuzpr LHS, <1,2,3,0>
  2893207342U, // <1,u,2,1>: Cost 3 vzipl <1,2,3,0>, LHS
  2819448996U, // <1,u,2,2>: Cost 3 vuzpr LHS, <0,2,0,2>
  2819450482U, // <1,u,2,3>: Cost 3 vuzpr LHS, <2,2,3,3>
  2819449754U, // <1,u,2,4>: Cost 3 vuzpr LHS, <1,2,3,4>
  2893207706U, // <1,u,2,5>: Cost 3 vzipl <1,2,3,0>, RHS
  2819449036U, // <1,u,2,6>: Cost 3 vuzpr LHS, <0,2,4,6>
  2970799432U, // <1,u,2,7>: Cost 3 vzipr <3,0,1,2>, RHS
  2819449002U, // <1,u,2,u>: Cost 3 vuzpr LHS, <0,2,0,u>
  403931292U, // <1,u,3,0>: Cost 1 vext1 LHS, LHS
  1477673718U, // <1,u,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
  115726126U, // <1,u,3,2>: Cost 1 vrev LHS
  2014102173U, // <1,u,3,3>: Cost 2 vtrnr LHS, LHS
  403934518U, // <1,u,3,4>: Cost 1 vext1 LHS, RHS
  1507536601U, // <1,u,3,5>: Cost 2 vext1 <5,1,u,3>, <5,1,u,3>
  1525453306U, // <1,u,3,6>: Cost 2 vext1 LHS, <6,2,7,3>
  2014105129U, // <1,u,3,7>: Cost 2 vtrnr LHS, RHS
  403937070U, // <1,u,3,u>: Cost 1 vext1 LHS, LHS
  2620042157U, // <1,u,4,0>: Cost 3 vext2 <0,4,1,u>, <4,0,u,1>
  2620042237U, // <1,u,4,1>: Cost 3 vext2 <0,4,1,u>, <4,1,u,0>
  2263217967U, // <1,u,4,2>: Cost 3 vrev <u,1,2,4>
  2569341224U, // <1,u,4,3>: Cost 3 vext1 <3,1,u,4>, <3,1,u,4>
  2569342262U, // <1,u,4,4>: Cost 3 vext1 <3,1,u,4>, RHS
  1546300726U, // <1,u,4,5>: Cost 2 vext2 <0,4,1,u>, RHS
  2819449180U, // <1,u,4,6>: Cost 3 vuzpr LHS, <0,4,2,6>
  2724845649U, // <1,u,4,7>: Cost 3 vext3 <6,7,0,1>, <u,4,7,6>
  1546300969U, // <1,u,4,u>: Cost 2 vext2 <0,4,1,u>, RHS
  2551431270U, // <1,u,5,0>: Cost 3 vext1 <0,1,u,5>, LHS
  2551432192U, // <1,u,5,1>: Cost 3 vext1 <0,1,u,5>, <1,3,5,7>
  3028293422U, // <1,u,5,2>: Cost 3 vtrnl <1,3,5,7>, LHS
  2955559068U, // <1,u,5,3>: Cost 3 vzipr <0,4,1,5>, LHS
  2551434550U, // <1,u,5,4>: Cost 3 vext1 <0,1,u,5>, RHS
  2895255706U, // <1,u,5,5>: Cost 3 vzipl <1,5,3,7>, RHS
  1616009370U, // <1,u,5,6>: Cost 2 vext3 <0,u,1,1>, RHS
  1745710390U, // <1,u,5,7>: Cost 2 vuzpr LHS, RHS
  1745710391U, // <1,u,5,u>: Cost 2 vuzpr LHS, RHS
  2653221159U, // <1,u,6,0>: Cost 3 vext2 <6,0,1,u>, <6,0,1,u>
  2725509303U, // <1,u,6,1>: Cost 3 vext3 <6,u,0,1>, <u,6,1,0>
  2659193338U, // <1,u,6,2>: Cost 3 vext2 <7,0,1,u>, <6,2,7,3>
  2689751248U, // <1,u,6,3>: Cost 3 vext3 <0,u,1,1>, <u,6,3,7>
  2867228774U, // <1,u,6,4>: Cost 3 vuzpr LHS, <5,6,7,4>
  3764820194U, // <1,u,6,5>: Cost 4 vext3 <1,1,1,1>, <u,6,5,7>
  2657202957U, // <1,u,6,6>: Cost 3 vext2 <6,6,1,u>, <6,6,1,u>
  2819450810U, // <1,u,6,7>: Cost 3 vuzpr LHS, <2,6,3,7>
  2819450811U, // <1,u,6,u>: Cost 3 vuzpr LHS, <2,6,3,u>
  1585452032U, // <1,u,7,0>: Cost 2 vext2 <7,0,1,u>, <7,0,1,u>
  2557420340U, // <1,u,7,1>: Cost 3 vext1 <1,1,u,7>, <1,1,1,1>
  2569365158U, // <1,u,7,2>: Cost 3 vext1 <3,1,u,7>, <2,3,0,1>
  2569365803U, // <1,u,7,3>: Cost 3 vext1 <3,1,u,7>, <3,1,u,7>
  2557422902U, // <1,u,7,4>: Cost 3 vext1 <1,1,u,7>, RHS
  2662512021U, // <1,u,7,5>: Cost 3 vext2 <7,5,1,u>, <7,5,1,u>
  2724845884U, // <1,u,7,6>: Cost 3 vext3 <6,7,0,1>, <u,7,6,7>
  2659194476U, // <1,u,7,7>: Cost 3 vext2 <7,0,1,u>, <7,7,7,7>
  1590761096U, // <1,u,7,u>: Cost 2 vext2 <7,u,1,u>, <7,u,1,u>
  403972257U, // <1,u,u,0>: Cost 1 vext1 LHS, LHS
  202162278U, // <1,u,u,1>: Cost 1 vdup1 LHS
  115767091U, // <1,u,u,2>: Cost 1 vrev LHS
  1745707677U, // <1,u,u,3>: Cost 2 vuzpr LHS, LHS
  403975478U, // <1,u,u,4>: Cost 1 vext1 LHS, RHS
  1546303642U, // <1,u,u,5>: Cost 2 vext2 <0,4,1,u>, RHS
  1616009613U, // <1,u,u,6>: Cost 2 vext3 <0,u,1,1>, RHS
  1745710633U, // <1,u,u,7>: Cost 2 vuzpr LHS, RHS
  403978030U, // <1,u,u,u>: Cost 1 vext1 LHS, LHS
  2551463936U, // <2,0,0,0>: Cost 3 vext1 <0,2,0,0>, <0,0,0,0>
  2685698058U, // <2,0,0,1>: Cost 3 vext3 <0,2,0,2>, <0,0,1,1>
  1610776596U, // <2,0,0,2>: Cost 2 vext3 <0,0,2,2>, <0,0,2,2>
  2619384069U, // <2,0,0,3>: Cost 3 vext2 <0,3,2,0>, <0,3,2,0>
  2551467318U, // <2,0,0,4>: Cost 3 vext1 <0,2,0,0>, RHS
  3899836596U, // <2,0,0,5>: Cost 4 vuzpr <1,2,3,0>, <3,0,4,5>
  2621374968U, // <2,0,0,6>: Cost 3 vext2 <0,6,2,0>, <0,6,2,0>
  4168271334U, // <2,0,0,7>: Cost 4 vtrnr <1,2,3,0>, <2,0,5,7>
  1611219018U, // <2,0,0,u>: Cost 2 vext3 <0,0,u,2>, <0,0,u,2>
  2551472138U, // <2,0,1,0>: Cost 3 vext1 <0,2,0,1>, <0,0,1,1>
  2690564186U, // <2,0,1,1>: Cost 3 vext3 <1,0,3,2>, <0,1,1,0>
  1611956326U, // <2,0,1,2>: Cost 2 vext3 <0,2,0,2>, LHS
  2826092646U, // <2,0,1,3>: Cost 3 vuzpr <1,2,3,0>, LHS
  2551475510U, // <2,0,1,4>: Cost 3 vext1 <0,2,0,1>, RHS
  3692463248U, // <2,0,1,5>: Cost 4 vext2 <0,2,2,0>, <1,5,3,7>
  2587308473U, // <2,0,1,6>: Cost 3 vext1 <6,2,0,1>, <6,2,0,1>
  3661050874U, // <2,0,1,7>: Cost 4 vext1 <6,2,0,1>, <7,0,1,2>
  1611956380U, // <2,0,1,u>: Cost 2 vext3 <0,2,0,2>, LHS
  1477738598U, // <2,0,2,0>: Cost 2 vext1 <0,2,0,2>, LHS
  2551481078U, // <2,0,2,1>: Cost 3 vext1 <0,2,0,2>, <1,0,3,2>
  2551481796U, // <2,0,2,2>: Cost 3 vext1 <0,2,0,2>, <2,0,2,0>
  2551482518U, // <2,0,2,3>: Cost 3 vext1 <0,2,0,2>, <3,0,1,2>
  1477741878U, // <2,0,2,4>: Cost 2 vext1 <0,2,0,2>, RHS
  2551484112U, // <2,0,2,5>: Cost 3 vext1 <0,2,0,2>, <5,1,7,3>
  2551484759U, // <2,0,2,6>: Cost 3 vext1 <0,2,0,2>, <6,0,7,2>
  2551485434U, // <2,0,2,7>: Cost 3 vext1 <0,2,0,2>, <7,0,1,2>
  1477744430U, // <2,0,2,u>: Cost 2 vext1 <0,2,0,2>, LHS
  2953625600U, // <2,0,3,0>: Cost 3 vzipr LHS, <0,0,0,0>
  2953627302U, // <2,0,3,1>: Cost 3 vzipr LHS, <2,3,0,1>
  2953625764U, // <2,0,3,2>: Cost 3 vzipr LHS, <0,2,0,2>
  4027369695U, // <2,0,3,3>: Cost 4 vzipr LHS, <3,1,0,3>
  3625233718U, // <2,0,3,4>: Cost 4 vext1 <0,2,0,3>, RHS
  3899836110U, // <2,0,3,5>: Cost 4 vuzpr <1,2,3,0>, <2,3,4,5>
  4032012618U, // <2,0,3,6>: Cost 4 vzipr LHS, <0,4,0,6>
  3899835392U, // <2,0,3,7>: Cost 4 vuzpr <1,2,3,0>, <1,3,5,7>
  2953625770U, // <2,0,3,u>: Cost 3 vzipr LHS, <0,2,0,u>
  2551496806U, // <2,0,4,0>: Cost 3 vext1 <0,2,0,4>, LHS
  2685698386U, // <2,0,4,1>: Cost 3 vext3 <0,2,0,2>, <0,4,1,5>
  2685698396U, // <2,0,4,2>: Cost 3 vext3 <0,2,0,2>, <0,4,2,6>
  3625240726U, // <2,0,4,3>: Cost 4 vext1 <0,2,0,4>, <3,0,1,2>
  2551500086U, // <2,0,4,4>: Cost 3 vext1 <0,2,0,4>, RHS
  2618723638U, // <2,0,4,5>: Cost 3 vext2 <0,2,2,0>, RHS
  2765409590U, // <2,0,4,6>: Cost 3 vuzpl <2,3,0,1>, RHS
  3799990664U, // <2,0,4,7>: Cost 4 vext3 <7,0,1,2>, <0,4,7,5>
  2685698450U, // <2,0,4,u>: Cost 3 vext3 <0,2,0,2>, <0,4,u,6>
  3625246822U, // <2,0,5,0>: Cost 4 vext1 <0,2,0,5>, LHS
  3289776304U, // <2,0,5,1>: Cost 4 vrev <0,2,1,5>
  2690564526U, // <2,0,5,2>: Cost 3 vext3 <1,0,3,2>, <0,5,2,7>
  3289923778U, // <2,0,5,3>: Cost 4 vrev <0,2,3,5>
  2216255691U, // <2,0,5,4>: Cost 3 vrev <0,2,4,5>
  3726307332U, // <2,0,5,5>: Cost 4 vext2 <5,u,2,0>, <5,5,5,5>
  3726307426U, // <2,0,5,6>: Cost 4 vext2 <5,u,2,0>, <5,6,7,0>
  2826095926U, // <2,0,5,7>: Cost 3 vuzpr <1,2,3,0>, RHS
  2216550639U, // <2,0,5,u>: Cost 3 vrev <0,2,u,5>
  4162420736U, // <2,0,6,0>: Cost 4 vtrnr <0,2,4,6>, <0,0,0,0>
  2901885030U, // <2,0,6,1>: Cost 3 vzipl <2,6,3,7>, LHS
  2685698559U, // <2,0,6,2>: Cost 3 vext3 <0,2,0,2>, <0,6,2,7>
  3643173171U, // <2,0,6,3>: Cost 4 vext1 <3,2,0,6>, <3,2,0,6>
  2216263884U, // <2,0,6,4>: Cost 3 vrev <0,2,4,6>
  3730289341U, // <2,0,6,5>: Cost 4 vext2 <6,5,2,0>, <6,5,2,0>
  3726308152U, // <2,0,6,6>: Cost 4 vext2 <5,u,2,0>, <6,6,6,6>
  3899836346U, // <2,0,6,7>: Cost 4 vuzpr <1,2,3,0>, <2,6,3,7>
  2216558832U, // <2,0,6,u>: Cost 3 vrev <0,2,u,6>
  2659202049U, // <2,0,7,0>: Cost 3 vext2 <7,0,2,0>, <7,0,2,0>
  3726308437U, // <2,0,7,1>: Cost 4 vext2 <5,u,2,0>, <7,1,2,3>
  2726249034U, // <2,0,7,2>: Cost 3 vext3 <7,0,1,2>, <0,7,2,1>
  3734934772U, // <2,0,7,3>: Cost 4 vext2 <7,3,2,0>, <7,3,2,0>
  3726308710U, // <2,0,7,4>: Cost 4 vext2 <5,u,2,0>, <7,4,5,6>
  3726308814U, // <2,0,7,5>: Cost 4 vext2 <5,u,2,0>, <7,5,u,2>
  3736925671U, // <2,0,7,6>: Cost 4 vext2 <7,6,2,0>, <7,6,2,0>
  3726308972U, // <2,0,7,7>: Cost 4 vext2 <5,u,2,0>, <7,7,7,7>
  2659202049U, // <2,0,7,u>: Cost 3 vext2 <7,0,2,0>, <7,0,2,0>
  1477787750U, // <2,0,u,0>: Cost 2 vext1 <0,2,0,u>, LHS
  2953668262U, // <2,0,u,1>: Cost 3 vzipr LHS, <2,3,0,1>
  1611956893U, // <2,0,u,2>: Cost 2 vext3 <0,2,0,2>, LHS
  2551531670U, // <2,0,u,3>: Cost 3 vext1 <0,2,0,u>, <3,0,1,2>
  1477791030U, // <2,0,u,4>: Cost 2 vext1 <0,2,0,u>, RHS
  2618726554U, // <2,0,u,5>: Cost 3 vext2 <0,2,2,0>, RHS
  2765412506U, // <2,0,u,6>: Cost 3 vuzpl <2,3,0,1>, RHS
  2826096169U, // <2,0,u,7>: Cost 3 vuzpr <1,2,3,0>, RHS
  1611956947U, // <2,0,u,u>: Cost 2 vext3 <0,2,0,2>, LHS
  2569453670U, // <2,1,0,0>: Cost 3 vext1 <3,2,1,0>, LHS
  2619392102U, // <2,1,0,1>: Cost 3 vext2 <0,3,2,1>, LHS
  3759440619U, // <2,1,0,2>: Cost 4 vext3 <0,2,0,2>, <1,0,2,0>
  1616823030U, // <2,1,0,3>: Cost 2 vext3 <1,0,3,2>, <1,0,3,2>
  2569456950U, // <2,1,0,4>: Cost 3 vext1 <3,2,1,0>, RHS
  2690712328U, // <2,1,0,5>: Cost 3 vext3 <1,0,5,2>, <1,0,5,2>
  3661115841U, // <2,1,0,6>: Cost 4 vext1 <6,2,1,0>, <6,2,1,0>
  2622046794U, // <2,1,0,7>: Cost 3 vext2 <0,7,2,1>, <0,7,2,1>
  1617191715U, // <2,1,0,u>: Cost 2 vext3 <1,0,u,2>, <1,0,u,2>
  2551545958U, // <2,1,1,0>: Cost 3 vext1 <0,2,1,1>, LHS
  2685698868U, // <2,1,1,1>: Cost 3 vext3 <0,2,0,2>, <1,1,1,1>
  2628682646U, // <2,1,1,2>: Cost 3 vext2 <1,u,2,1>, <1,2,3,0>
  2685698888U, // <2,1,1,3>: Cost 3 vext3 <0,2,0,2>, <1,1,3,3>
  2551549238U, // <2,1,1,4>: Cost 3 vext1 <0,2,1,1>, RHS
  3693134992U, // <2,1,1,5>: Cost 4 vext2 <0,3,2,1>, <1,5,3,7>
  3661124034U, // <2,1,1,6>: Cost 4 vext1 <6,2,1,1>, <6,2,1,1>
  3625292794U, // <2,1,1,7>: Cost 4 vext1 <0,2,1,1>, <7,0,1,2>
  2685698933U, // <2,1,1,u>: Cost 3 vext3 <0,2,0,2>, <1,1,u,3>
  2551554150U, // <2,1,2,0>: Cost 3 vext1 <0,2,1,2>, LHS
  3893649571U, // <2,1,2,1>: Cost 4 vuzpr <0,2,0,1>, <0,2,0,1>
  2551555688U, // <2,1,2,2>: Cost 3 vext1 <0,2,1,2>, <2,2,2,2>
  2685698966U, // <2,1,2,3>: Cost 3 vext3 <0,2,0,2>, <1,2,3,0>
  2551557430U, // <2,1,2,4>: Cost 3 vext1 <0,2,1,2>, RHS
  3763422123U, // <2,1,2,5>: Cost 4 vext3 <0,u,0,2>, <1,2,5,3>
  3693135802U, // <2,1,2,6>: Cost 4 vext2 <0,3,2,1>, <2,6,3,7>
  2726249402U, // <2,1,2,7>: Cost 3 vext3 <7,0,1,2>, <1,2,7,0>
  2685699011U, // <2,1,2,u>: Cost 3 vext3 <0,2,0,2>, <1,2,u,0>
  2551562342U, // <2,1,3,0>: Cost 3 vext1 <0,2,1,3>, LHS
  2953625610U, // <2,1,3,1>: Cost 3 vzipr LHS, <0,0,1,1>
  2953627798U, // <2,1,3,2>: Cost 3 vzipr LHS, <3,0,1,2>
  2953626584U, // <2,1,3,3>: Cost 3 vzipr LHS, <1,3,1,3>
  2551565622U, // <2,1,3,4>: Cost 3 vext1 <0,2,1,3>, RHS
  2953625938U, // <2,1,3,5>: Cost 3 vzipr LHS, <0,4,1,5>
  2587398596U, // <2,1,3,6>: Cost 3 vext1 <6,2,1,3>, <6,2,1,3>
  4032013519U, // <2,1,3,7>: Cost 4 vzipr LHS, <1,6,1,7>
  2953625617U, // <2,1,3,u>: Cost 3 vzipr LHS, <0,0,1,u>
  2690565154U, // <2,1,4,0>: Cost 3 vext3 <1,0,3,2>, <1,4,0,5>
  3625313270U, // <2,1,4,1>: Cost 4 vext1 <0,2,1,4>, <1,3,4,6>
  3771532340U, // <2,1,4,2>: Cost 4 vext3 <2,2,2,2>, <1,4,2,5>
  1148404634U, // <2,1,4,3>: Cost 2 vrev <1,2,3,4>
  3625315638U, // <2,1,4,4>: Cost 4 vext1 <0,2,1,4>, RHS
  2619395382U, // <2,1,4,5>: Cost 3 vext2 <0,3,2,1>, RHS
  3837242678U, // <2,1,4,6>: Cost 4 vuzpl <2,0,1,2>, RHS
  3799991394U, // <2,1,4,7>: Cost 4 vext3 <7,0,1,2>, <1,4,7,6>
  1148773319U, // <2,1,4,u>: Cost 2 vrev <1,2,u,4>
  2551578726U, // <2,1,5,0>: Cost 3 vext1 <0,2,1,5>, LHS
  2551579648U, // <2,1,5,1>: Cost 3 vext1 <0,2,1,5>, <1,3,5,7>
  3625321952U, // <2,1,5,2>: Cost 4 vext1 <0,2,1,5>, <2,0,5,1>
  2685699216U, // <2,1,5,3>: Cost 3 vext3 <0,2,0,2>, <1,5,3,7>
  2551582006U, // <2,1,5,4>: Cost 3 vext1 <0,2,1,5>, RHS
  3740913668U, // <2,1,5,5>: Cost 4 vext2 <u,3,2,1>, <5,5,5,5>
  3661156806U, // <2,1,5,6>: Cost 4 vext1 <6,2,1,5>, <6,2,1,5>
  3893652790U, // <2,1,5,7>: Cost 4 vuzpr <0,2,0,1>, RHS
  2685699261U, // <2,1,5,u>: Cost 3 vext3 <0,2,0,2>, <1,5,u,7>
  2551586918U, // <2,1,6,0>: Cost 3 vext1 <0,2,1,6>, LHS
  3625329398U, // <2,1,6,1>: Cost 4 vext1 <0,2,1,6>, <1,0,3,2>
  2551588794U, // <2,1,6,2>: Cost 3 vext1 <0,2,1,6>, <2,6,3,7>
  3088679014U, // <2,1,6,3>: Cost 3 vtrnr <0,2,4,6>, LHS
  2551590198U, // <2,1,6,4>: Cost 3 vext1 <0,2,1,6>, RHS
  4029382994U, // <2,1,6,5>: Cost 4 vzipr <0,4,2,6>, <0,4,1,5>
  3625333560U, // <2,1,6,6>: Cost 4 vext1 <0,2,1,6>, <6,6,6,6>
  3731624800U, // <2,1,6,7>: Cost 4 vext2 <6,7,2,1>, <6,7,2,1>
  2551592750U, // <2,1,6,u>: Cost 3 vext1 <0,2,1,6>, LHS
  2622051322U, // <2,1,7,0>: Cost 3 vext2 <0,7,2,1>, <7,0,1,2>
  3733615699U, // <2,1,7,1>: Cost 4 vext2 <7,1,2,1>, <7,1,2,1>
  3795125538U, // <2,1,7,2>: Cost 4 vext3 <6,1,7,2>, <1,7,2,0>
  2222171037U, // <2,1,7,3>: Cost 3 vrev <1,2,3,7>
  3740915046U, // <2,1,7,4>: Cost 4 vext2 <u,3,2,1>, <7,4,5,6>
  3296060335U, // <2,1,7,5>: Cost 4 vrev <1,2,5,7>
  3736933864U, // <2,1,7,6>: Cost 4 vext2 <7,6,2,1>, <7,6,2,1>
  3805300055U, // <2,1,7,7>: Cost 4 vext3 <7,u,1,2>, <1,7,7,u>
  2669827714U, // <2,1,7,u>: Cost 3 vext2 <u,7,2,1>, <7,u,1,2>
  2551603302U, // <2,1,u,0>: Cost 3 vext1 <0,2,1,u>, LHS
  2953666570U, // <2,1,u,1>: Cost 3 vzipr LHS, <0,0,1,1>
  2953668758U, // <2,1,u,2>: Cost 3 vzipr LHS, <3,0,1,2>
  1148437406U, // <2,1,u,3>: Cost 2 vrev <1,2,3,u>
  2551606582U, // <2,1,u,4>: Cost 3 vext1 <0,2,1,u>, RHS
  2953666898U, // <2,1,u,5>: Cost 3 vzipr LHS, <0,4,1,5>
  2587398596U, // <2,1,u,6>: Cost 3 vext1 <6,2,1,3>, <6,2,1,3>
  2669828370U, // <2,1,u,7>: Cost 3 vext2 <u,7,2,1>, <u,7,2,1>
  1148806091U, // <2,1,u,u>: Cost 2 vrev <1,2,u,u>
  1543667732U, // <2,2,0,0>: Cost 2 vext2 <0,0,2,2>, <0,0,2,2>
  1548976230U, // <2,2,0,1>: Cost 2 vext2 <0,u,2,2>, LHS
  2685699524U, // <2,2,0,2>: Cost 3 vext3 <0,2,0,2>, <2,0,2,0>
  2685699535U, // <2,2,0,3>: Cost 3 vext3 <0,2,0,2>, <2,0,3,2>
  2551614774U, // <2,2,0,4>: Cost 3 vext1 <0,2,2,0>, RHS
  3704422830U, // <2,2,0,5>: Cost 4 vext2 <2,2,2,2>, <0,5,2,7>
  3893657642U, // <2,2,0,6>: Cost 4 vuzpr <0,2,0,2>, <0,0,4,6>
  3770574323U, // <2,2,0,7>: Cost 4 vext3 <2,0,7,2>, <2,0,7,2>
  1548976796U, // <2,2,0,u>: Cost 2 vext2 <0,u,2,2>, <0,u,2,2>
  2622718710U, // <2,2,1,0>: Cost 3 vext2 <0,u,2,2>, <1,0,3,2>
  2622718772U, // <2,2,1,1>: Cost 3 vext2 <0,u,2,2>, <1,1,1,1>
  2622718870U, // <2,2,1,2>: Cost 3 vext2 <0,u,2,2>, <1,2,3,0>
  2819915878U, // <2,2,1,3>: Cost 3 vuzpr <0,2,0,2>, LHS
  3625364790U, // <2,2,1,4>: Cost 4 vext1 <0,2,2,1>, RHS
  2622719120U, // <2,2,1,5>: Cost 3 vext2 <0,u,2,2>, <1,5,3,7>
  3760031292U, // <2,2,1,6>: Cost 4 vext3 <0,2,u,2>, <2,1,6,3>
  3667170468U, // <2,2,1,7>: Cost 4 vext1 <7,2,2,1>, <7,2,2,1>
  2819915883U, // <2,2,1,u>: Cost 3 vuzpr <0,2,0,2>, LHS
  1489829990U, // <2,2,2,0>: Cost 2 vext1 <2,2,2,2>, LHS
  2563572470U, // <2,2,2,1>: Cost 3 vext1 <2,2,2,2>, <1,0,3,2>
  269271142U, // <2,2,2,2>: Cost 1 vdup2 LHS
  2685699698U, // <2,2,2,3>: Cost 3 vext3 <0,2,0,2>, <2,2,3,3>
  1489833270U, // <2,2,2,4>: Cost 2 vext1 <2,2,2,2>, RHS
  2685699720U, // <2,2,2,5>: Cost 3 vext3 <0,2,0,2>, <2,2,5,7>
  2622719930U, // <2,2,2,6>: Cost 3 vext2 <0,u,2,2>, <2,6,3,7>
  2593436837U, // <2,2,2,7>: Cost 3 vext1 <7,2,2,2>, <7,2,2,2>
  269271142U, // <2,2,2,u>: Cost 1 vdup2 LHS
  2685699750U, // <2,2,3,0>: Cost 3 vext3 <0,2,0,2>, <2,3,0,1>
  2690565806U, // <2,2,3,1>: Cost 3 vext3 <1,0,3,2>, <2,3,1,0>
  2953627240U, // <2,2,3,2>: Cost 3 vzipr LHS, <2,2,2,2>
  1879883878U, // <2,2,3,3>: Cost 2 vzipr LHS, LHS
  2685699790U, // <2,2,3,4>: Cost 3 vext3 <0,2,0,2>, <2,3,4,5>
  3893659342U, // <2,2,3,5>: Cost 4 vuzpr <0,2,0,2>, <2,3,4,5>
  2958270812U, // <2,2,3,6>: Cost 3 vzipr LHS, <0,4,2,6>
  2593445030U, // <2,2,3,7>: Cost 3 vext1 <7,2,2,3>, <7,2,2,3>
  1879883883U, // <2,2,3,u>: Cost 2 vzipr LHS, LHS
  2551644262U, // <2,2,4,0>: Cost 3 vext1 <0,2,2,4>, LHS
  3625386742U, // <2,2,4,1>: Cost 4 vext1 <0,2,2,4>, <1,0,3,2>
  2551645902U, // <2,2,4,2>: Cost 3 vext1 <0,2,2,4>, <2,3,4,5>
  3759441686U, // <2,2,4,3>: Cost 4 vext3 <0,2,0,2>, <2,4,3,5>
  2551647542U, // <2,2,4,4>: Cost 3 vext1 <0,2,2,4>, RHS
  1548979510U, // <2,2,4,5>: Cost 2 vext2 <0,u,2,2>, RHS
  2764901686U, // <2,2,4,6>: Cost 3 vuzpl <2,2,2,2>, RHS
  3667195047U, // <2,2,4,7>: Cost 4 vext1 <7,2,2,4>, <7,2,2,4>
  1548979753U, // <2,2,4,u>: Cost 2 vext2 <0,u,2,2>, RHS
  3696463432U, // <2,2,5,0>: Cost 4 vext2 <0,u,2,2>, <5,0,1,2>
  2617413328U, // <2,2,5,1>: Cost 3 vext2 <0,0,2,2>, <5,1,7,3>
  2685699936U, // <2,2,5,2>: Cost 3 vext3 <0,2,0,2>, <2,5,2,7>
  4027383910U, // <2,2,5,3>: Cost 4 vzipr <0,1,2,5>, LHS
  2228201085U, // <2,2,5,4>: Cost 3 vrev <2,2,4,5>
  2617413636U, // <2,2,5,5>: Cost 3 vext2 <0,0,2,2>, <5,5,5,5>
  2617413730U, // <2,2,5,6>: Cost 3 vext2 <0,0,2,2>, <5,6,7,0>
  2819919158U, // <2,2,5,7>: Cost 3 vuzpr <0,2,0,2>, RHS
  2819919159U, // <2,2,5,u>: Cost 3 vuzpr <0,2,0,2>, RHS
  3625402554U, // <2,2,6,0>: Cost 4 vext1 <0,2,2,6>, <0,2,2,6>
  3760031652U, // <2,2,6,1>: Cost 4 vext3 <0,2,u,2>, <2,6,1,3>
  2617414138U, // <2,2,6,2>: Cost 3 vext2 <0,0,2,2>, <6,2,7,3>
  2685700026U, // <2,2,6,3>: Cost 3 vext3 <0,2,0,2>, <2,6,3,7>
  3625405750U, // <2,2,6,4>: Cost 4 vext1 <0,2,2,6>, RHS
  3760031692U, // <2,2,6,5>: Cost 4 vext3 <0,2,u,2>, <2,6,5,7>
  3088679116U, // <2,2,6,6>: Cost 3 vtrnr <0,2,4,6>, <0,2,4,6>
  2657891169U, // <2,2,6,7>: Cost 3 vext2 <6,7,2,2>, <6,7,2,2>
  2685700071U, // <2,2,6,u>: Cost 3 vext3 <0,2,0,2>, <2,6,u,7>
  2726250474U, // <2,2,7,0>: Cost 3 vext3 <7,0,1,2>, <2,7,0,1>
  3704427616U, // <2,2,7,1>: Cost 4 vext2 <2,2,2,2>, <7,1,3,5>
  2660545701U, // <2,2,7,2>: Cost 3 vext2 <7,2,2,2>, <7,2,2,2>
  4030718054U, // <2,2,7,3>: Cost 4 vzipr <0,6,2,7>, LHS
  2617415014U, // <2,2,7,4>: Cost 3 vext2 <0,0,2,2>, <7,4,5,6>
  3302033032U, // <2,2,7,5>: Cost 4 vrev <2,2,5,7>
  3661246929U, // <2,2,7,6>: Cost 4 vext1 <6,2,2,7>, <6,2,2,7>
  2617415276U, // <2,2,7,7>: Cost 3 vext2 <0,0,2,2>, <7,7,7,7>
  2731558962U, // <2,2,7,u>: Cost 3 vext3 <7,u,1,2>, <2,7,u,1>
  1489829990U, // <2,2,u,0>: Cost 2 vext1 <2,2,2,2>, LHS
  1548982062U, // <2,2,u,1>: Cost 2 vext2 <0,u,2,2>, LHS
  269271142U, // <2,2,u,2>: Cost 1 vdup2 LHS
  1879924838U, // <2,2,u,3>: Cost 2 vzipr LHS, LHS
  1489833270U, // <2,2,u,4>: Cost 2 vext1 <2,2,2,2>, RHS
  1548982426U, // <2,2,u,5>: Cost 2 vext2 <0,u,2,2>, RHS
  2953666908U, // <2,2,u,6>: Cost 3 vzipr LHS, <0,4,2,6>
  2819919401U, // <2,2,u,7>: Cost 3 vuzpr <0,2,0,2>, RHS
  269271142U, // <2,2,u,u>: Cost 1 vdup2 LHS
  1544339456U, // <2,3,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
  470597734U, // <2,3,0,1>: Cost 1 vext2 LHS, LHS
  1548984484U, // <2,3,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
  2619408648U, // <2,3,0,3>: Cost 3 vext2 <0,3,2,3>, <0,3,2,3>
  1548984658U, // <2,3,0,4>: Cost 2 vext2 LHS, <0,4,1,5>
  2665857454U, // <2,3,0,5>: Cost 3 vext2 LHS, <0,5,2,7>
  2622726655U, // <2,3,0,6>: Cost 3 vext2 LHS, <0,6,2,7>
  2593494188U, // <2,3,0,7>: Cost 3 vext1 <7,2,3,0>, <7,2,3,0>
  470598301U, // <2,3,0,u>: Cost 1 vext2 LHS, LHS
  1544340214U, // <2,3,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
  1544340276U, // <2,3,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
  1544340374U, // <2,3,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
  1548985304U, // <2,3,1,3>: Cost 2 vext2 LHS, <1,3,1,3>
  2551696694U, // <2,3,1,4>: Cost 3 vext1 <0,2,3,1>, RHS
  1548985488U, // <2,3,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
  2622727375U, // <2,3,1,6>: Cost 3 vext2 LHS, <1,6,1,7>
  2665858347U, // <2,3,1,7>: Cost 3 vext2 LHS, <1,7,3,0>
  1548985709U, // <2,3,1,u>: Cost 2 vext2 LHS, <1,u,1,3>
  2622727613U, // <2,3,2,0>: Cost 3 vext2 LHS, <2,0,1,2>
  2622727711U, // <2,3,2,1>: Cost 3 vext2 LHS, <2,1,3,1>
  1544341096U, // <2,3,2,2>: Cost 2 vext2 LHS, <2,2,2,2>
  1544341158U, // <2,3,2,3>: Cost 2 vext2 LHS, <2,3,0,1>
  2622727958U, // <2,3,2,4>: Cost 3 vext2 LHS, <2,4,3,5>
  2622728032U, // <2,3,2,5>: Cost 3 vext2 LHS, <2,5,2,7>
  1548986298U, // <2,3,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
  2665859050U, // <2,3,2,7>: Cost 3 vext2 LHS, <2,7,0,1>
  1548986427U, // <2,3,2,u>: Cost 2 vext2 LHS, <2,u,0,1>
  1548986518U, // <2,3,3,0>: Cost 2 vext2 LHS, <3,0,1,2>
  2622728415U, // <2,3,3,1>: Cost 3 vext2 LHS, <3,1,0,3>
  1489913458U, // <2,3,3,2>: Cost 2 vext1 <2,2,3,3>, <2,2,3,3>
  1544341916U, // <2,3,3,3>: Cost 2 vext2 LHS, <3,3,3,3>
  1548986882U, // <2,3,3,4>: Cost 2 vext2 LHS, <3,4,5,6>
  2665859632U, // <2,3,3,5>: Cost 3 vext2 LHS, <3,5,1,7>
  2234304870U, // <2,3,3,6>: Cost 3 vrev <3,2,6,3>
  2958271632U, // <2,3,3,7>: Cost 3 vzipr LHS, <1,5,3,7>
  1548987166U, // <2,3,3,u>: Cost 2 vext2 LHS, <3,u,1,2>
  1483948134U, // <2,3,4,0>: Cost 2 vext1 <1,2,3,4>, LHS
  1483948954U, // <2,3,4,1>: Cost 2 vext1 <1,2,3,4>, <1,2,3,4>
  2622729276U, // <2,3,4,2>: Cost 3 vext2 LHS, <4,2,6,0>
  2557692054U, // <2,3,4,3>: Cost 3 vext1 <1,2,3,4>, <3,0,1,2>
  1483951414U, // <2,3,4,4>: Cost 2 vext1 <1,2,3,4>, RHS
  470601014U, // <2,3,4,5>: Cost 1 vext2 LHS, RHS
  1592118644U, // <2,3,4,6>: Cost 2 vext2 LHS, <4,6,4,6>
  2593526960U, // <2,3,4,7>: Cost 3 vext1 <7,2,3,4>, <7,2,3,4>
  470601257U, // <2,3,4,u>: Cost 1 vext2 LHS, RHS
  2551726182U, // <2,3,5,0>: Cost 3 vext1 <0,2,3,5>, LHS
  1592118992U, // <2,3,5,1>: Cost 2 vext2 LHS, <5,1,7,3>
  2665860862U, // <2,3,5,2>: Cost 3 vext2 LHS, <5,2,3,4>
  2551728642U, // <2,3,5,3>: Cost 3 vext1 <0,2,3,5>, <3,4,5,6>
  1592119238U, // <2,3,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
  1592119300U, // <2,3,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
  1592119394U, // <2,3,5,6>: Cost 2 vext2 LHS, <5,6,7,0>
  1592119464U, // <2,3,5,7>: Cost 2 vext2 LHS, <5,7,5,7>
  1592119545U, // <2,3,5,u>: Cost 2 vext2 LHS, <5,u,5,7>
  2622730529U, // <2,3,6,0>: Cost 3 vext2 LHS, <6,0,1,2>
  2557707164U, // <2,3,6,1>: Cost 3 vext1 <1,2,3,6>, <1,2,3,6>
  1592119802U, // <2,3,6,2>: Cost 2 vext2 LHS, <6,2,7,3>
  2665861682U, // <2,3,6,3>: Cost 3 vext2 LHS, <6,3,4,5>
  2622730893U, // <2,3,6,4>: Cost 3 vext2 LHS, <6,4,5,6>
  2665861810U, // <2,3,6,5>: Cost 3 vext2 LHS, <6,5,0,7>
  1592120120U, // <2,3,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
  1592120142U, // <2,3,6,7>: Cost 2 vext2 LHS, <6,7,0,1>
  1592120223U, // <2,3,6,u>: Cost 2 vext2 LHS, <6,u,0,1>
  1592120314U, // <2,3,7,0>: Cost 2 vext2 LHS, <7,0,1,2>
  2659890261U, // <2,3,7,1>: Cost 3 vext2 <7,1,2,3>, <7,1,2,3>
  2660553894U, // <2,3,7,2>: Cost 3 vext2 <7,2,2,3>, <7,2,2,3>
  2665862371U, // <2,3,7,3>: Cost 3 vext2 LHS, <7,3,0,1>
  1592120678U, // <2,3,7,4>: Cost 2 vext2 LHS, <7,4,5,6>
  2665862534U, // <2,3,7,5>: Cost 3 vext2 LHS, <7,5,0,2>
  2665862614U, // <2,3,7,6>: Cost 3 vext2 LHS, <7,6,0,1>
  1592120940U, // <2,3,7,7>: Cost 2 vext2 LHS, <7,7,7,7>
  1592120962U, // <2,3,7,u>: Cost 2 vext2 LHS, <7,u,1,2>
  1548990163U, // <2,3,u,0>: Cost 2 vext2 LHS, <u,0,1,2>
  470603566U, // <2,3,u,1>: Cost 1 vext2 LHS, LHS
  1548990341U, // <2,3,u,2>: Cost 2 vext2 LHS, <u,2,3,0>
  1548990396U, // <2,3,u,3>: Cost 2 vext2 LHS, <u,3,0,1>
  1548990527U, // <2,3,u,4>: Cost 2 vext2 LHS, <u,4,5,6>
  470603930U, // <2,3,u,5>: Cost 1 vext2 LHS, RHS
  1548990672U, // <2,3,u,6>: Cost 2 vext2 LHS, <u,6,3,7>
  1592121600U, // <2,3,u,7>: Cost 2 vext2 LHS, <u,7,0,1>
  470604133U, // <2,3,u,u>: Cost 1 vext2 LHS, LHS
  2617425942U, // <2,4,0,0>: Cost 3 vext2 <0,0,2,4>, <0,0,2,4>
  2618753126U, // <2,4,0,1>: Cost 3 vext2 <0,2,2,4>, LHS
  2618753208U, // <2,4,0,2>: Cost 3 vext2 <0,2,2,4>, <0,2,2,4>
  2619416841U, // <2,4,0,3>: Cost 3 vext2 <0,3,2,4>, <0,3,2,4>
  2587593628U, // <2,4,0,4>: Cost 3 vext1 <6,2,4,0>, <4,0,6,2>
  2712832914U, // <2,4,0,5>: Cost 3 vext3 <4,6,u,2>, <4,0,5,1>
  1634962332U, // <2,4,0,6>: Cost 2 vext3 <4,0,6,2>, <4,0,6,2>
  3799993252U, // <2,4,0,7>: Cost 4 vext3 <7,0,1,2>, <4,0,7,1>
  1634962332U, // <2,4,0,u>: Cost 2 vext3 <4,0,6,2>, <4,0,6,2>
  2619417334U, // <2,4,1,0>: Cost 3 vext2 <0,3,2,4>, <1,0,3,2>
  3692495668U, // <2,4,1,1>: Cost 4 vext2 <0,2,2,4>, <1,1,1,1>
  2625389466U, // <2,4,1,2>: Cost 3 vext2 <1,3,2,4>, <1,2,3,4>
  2826125414U, // <2,4,1,3>: Cost 3 vuzpr <1,2,3,4>, LHS
  3699794995U, // <2,4,1,4>: Cost 4 vext2 <1,4,2,4>, <1,4,2,4>
  3692496016U, // <2,4,1,5>: Cost 4 vext2 <0,2,2,4>, <1,5,3,7>
  3763424238U, // <2,4,1,6>: Cost 4 vext3 <0,u,0,2>, <4,1,6,3>
  3667317942U, // <2,4,1,7>: Cost 4 vext1 <7,2,4,1>, <7,2,4,1>
  2826125419U, // <2,4,1,u>: Cost 3 vuzpr <1,2,3,4>, LHS
  2629371336U, // <2,4,2,0>: Cost 3 vext2 <2,0,2,4>, <2,0,2,4>
  3699131946U, // <2,4,2,1>: Cost 4 vext2 <1,3,2,4>, <2,1,4,3>
  2630698602U, // <2,4,2,2>: Cost 3 vext2 <2,2,2,4>, <2,2,2,4>
  2618754766U, // <2,4,2,3>: Cost 3 vext2 <0,2,2,4>, <2,3,4,5>
  2826126234U, // <2,4,2,4>: Cost 3 vuzpr <1,2,3,4>, <1,2,3,4>
  2899119414U, // <2,4,2,5>: Cost 3 vzipl <2,2,2,2>, RHS
  3033337142U, // <2,4,2,6>: Cost 3 vtrnl <2,2,2,2>, RHS
  3800214597U, // <2,4,2,7>: Cost 4 vext3 <7,0,4,2>, <4,2,7,0>
  2899119657U, // <2,4,2,u>: Cost 3 vzipl <2,2,2,2>, RHS
  2635344033U, // <2,4,3,0>: Cost 3 vext2 <3,0,2,4>, <3,0,2,4>
  4032012325U, // <2,4,3,1>: Cost 4 vzipr LHS, <0,0,4,1>
  3692497228U, // <2,4,3,2>: Cost 4 vext2 <0,2,2,4>, <3,2,3,4>
  3692497308U, // <2,4,3,3>: Cost 4 vext2 <0,2,2,4>, <3,3,3,3>
  3001404624U, // <2,4,3,4>: Cost 3 vzipr LHS, <4,4,4,4>
  2953627342U, // <2,4,3,5>: Cost 3 vzipr LHS, <2,3,4,5>
  2953625804U, // <2,4,3,6>: Cost 3 vzipr LHS, <0,2,4,6>
  3899868160U, // <2,4,3,7>: Cost 4 vuzpr <1,2,3,4>, <1,3,5,7>
  2953625806U, // <2,4,3,u>: Cost 3 vzipr LHS, <0,2,4,u>
  2710916266U, // <2,4,4,0>: Cost 3 vext3 <4,4,0,2>, <4,4,0,2>
  3899869648U, // <2,4,4,1>: Cost 4 vuzpr <1,2,3,4>, <3,4,0,1>
  3899869658U, // <2,4,4,2>: Cost 4 vuzpr <1,2,3,4>, <3,4,1,2>
  3899868930U, // <2,4,4,3>: Cost 4 vuzpr <1,2,3,4>, <2,4,1,3>
  2712833232U, // <2,4,4,4>: Cost 3 vext3 <4,6,u,2>, <4,4,4,4>
  2618756406U, // <2,4,4,5>: Cost 3 vext2 <0,2,2,4>, RHS
  2765737270U, // <2,4,4,6>: Cost 3 vuzpl <2,3,4,5>, RHS
  4168304426U, // <2,4,4,7>: Cost 4 vtrnr <1,2,3,4>, <2,4,5,7>
  2618756649U, // <2,4,4,u>: Cost 3 vext2 <0,2,2,4>, RHS
  2551800011U, // <2,4,5,0>: Cost 3 vext1 <0,2,4,5>, <0,2,4,5>
  2569716470U, // <2,4,5,1>: Cost 3 vext1 <3,2,4,5>, <1,0,3,2>
  2563745405U, // <2,4,5,2>: Cost 3 vext1 <2,2,4,5>, <2,2,4,5>
  2569718102U, // <2,4,5,3>: Cost 3 vext1 <3,2,4,5>, <3,2,4,5>
  2551803190U, // <2,4,5,4>: Cost 3 vext1 <0,2,4,5>, RHS
  3625545732U, // <2,4,5,5>: Cost 4 vext1 <0,2,4,5>, <5,5,5,5>
  1611959606U, // <2,4,5,6>: Cost 2 vext3 <0,2,0,2>, RHS
  2826128694U, // <2,4,5,7>: Cost 3 vuzpr <1,2,3,4>, RHS
  1611959624U, // <2,4,5,u>: Cost 2 vext3 <0,2,0,2>, RHS
  1478066278U, // <2,4,6,0>: Cost 2 vext1 <0,2,4,6>, LHS
  2551808758U, // <2,4,6,1>: Cost 3 vext1 <0,2,4,6>, <1,0,3,2>
  2551809516U, // <2,4,6,2>: Cost 3 vext1 <0,2,4,6>, <2,0,6,4>
  2551810198U, // <2,4,6,3>: Cost 3 vext1 <0,2,4,6>, <3,0,1,2>
  1478069558U, // <2,4,6,4>: Cost 2 vext1 <0,2,4,6>, RHS
  2901888310U, // <2,4,6,5>: Cost 3 vzipl <2,6,3,7>, RHS
  2551812920U, // <2,4,6,6>: Cost 3 vext1 <0,2,4,6>, <6,6,6,6>
  2726251914U, // <2,4,6,7>: Cost 3 vext3 <7,0,1,2>, <4,6,7,1>
  1478072110U, // <2,4,6,u>: Cost 2 vext1 <0,2,4,6>, LHS
  2659234821U, // <2,4,7,0>: Cost 3 vext2 <7,0,2,4>, <7,0,2,4>
  3786722726U, // <2,4,7,1>: Cost 4 vext3 <4,7,1,2>, <4,7,1,2>
  3734303911U, // <2,4,7,2>: Cost 4 vext2 <7,2,2,4>, <7,2,2,4>
  3734967544U, // <2,4,7,3>: Cost 4 vext2 <7,3,2,4>, <7,3,2,4>
  3727005030U, // <2,4,7,4>: Cost 4 vext2 <6,0,2,4>, <7,4,5,6>
  2726251976U, // <2,4,7,5>: Cost 3 vext3 <7,0,1,2>, <4,7,5,0>
  2726251986U, // <2,4,7,6>: Cost 3 vext3 <7,0,1,2>, <4,7,6,1>
  3727005292U, // <2,4,7,7>: Cost 4 vext2 <6,0,2,4>, <7,7,7,7>
  2659234821U, // <2,4,7,u>: Cost 3 vext2 <7,0,2,4>, <7,0,2,4>
  1478082662U, // <2,4,u,0>: Cost 2 vext1 <0,2,4,u>, LHS
  2618758958U, // <2,4,u,1>: Cost 3 vext2 <0,2,2,4>, LHS
  2551826024U, // <2,4,u,2>: Cost 3 vext1 <0,2,4,u>, <2,2,2,2>
  2551826582U, // <2,4,u,3>: Cost 3 vext1 <0,2,4,u>, <3,0,1,2>
  1478085942U, // <2,4,u,4>: Cost 2 vext1 <0,2,4,u>, RHS
  2953668302U, // <2,4,u,5>: Cost 3 vzipr LHS, <2,3,4,5>
  1611959849U, // <2,4,u,6>: Cost 2 vext3 <0,2,0,2>, RHS
  2826128937U, // <2,4,u,7>: Cost 3 vuzpr <1,2,3,4>, RHS
  1611959867U, // <2,4,u,u>: Cost 2 vext3 <0,2,0,2>, RHS
  3691839488U, // <2,5,0,0>: Cost 4 vext2 <0,1,2,5>, <0,0,0,0>
  2618097766U, // <2,5,0,1>: Cost 3 vext2 <0,1,2,5>, LHS
  2620088484U, // <2,5,0,2>: Cost 3 vext2 <0,4,2,5>, <0,2,0,2>
  2619425034U, // <2,5,0,3>: Cost 3 vext2 <0,3,2,5>, <0,3,2,5>
  2620088667U, // <2,5,0,4>: Cost 3 vext2 <0,4,2,5>, <0,4,2,5>
  2620752300U, // <2,5,0,5>: Cost 3 vext2 <0,5,2,5>, <0,5,2,5>
  3693830655U, // <2,5,0,6>: Cost 4 vext2 <0,4,2,5>, <0,6,2,7>
  3094531382U, // <2,5,0,7>: Cost 3 vtrnr <1,2,3,0>, RHS
  2618098333U, // <2,5,0,u>: Cost 3 vext2 <0,1,2,5>, LHS
  3691840246U, // <2,5,1,0>: Cost 4 vext2 <0,1,2,5>, <1,0,3,2>
  3691840308U, // <2,5,1,1>: Cost 4 vext2 <0,1,2,5>, <1,1,1,1>
  2626061206U, // <2,5,1,2>: Cost 3 vext2 <1,4,2,5>, <1,2,3,0>
  2618098688U, // <2,5,1,3>: Cost 3 vext2 <0,1,2,5>, <1,3,5,7>
  2626061364U, // <2,5,1,4>: Cost 3 vext2 <1,4,2,5>, <1,4,2,5>
  3691840656U, // <2,5,1,5>: Cost 4 vext2 <0,1,2,5>, <1,5,3,7>
  3789082310U, // <2,5,1,6>: Cost 4 vext3 <5,1,6,2>, <5,1,6,2>
  2712833744U, // <2,5,1,7>: Cost 3 vext3 <4,6,u,2>, <5,1,7,3>
  2628715896U, // <2,5,1,u>: Cost 3 vext2 <1,u,2,5>, <1,u,2,5>
  3693831613U, // <2,5,2,0>: Cost 4 vext2 <0,4,2,5>, <2,0,1,2>
  4026698642U, // <2,5,2,1>: Cost 4 vzipr <0,0,2,2>, <4,0,5,1>
  2632033896U, // <2,5,2,2>: Cost 3 vext2 <2,4,2,5>, <2,2,2,2>
  3691841190U, // <2,5,2,3>: Cost 4 vext2 <0,1,2,5>, <2,3,0,1>
  2632034061U, // <2,5,2,4>: Cost 3 vext2 <2,4,2,5>, <2,4,2,5>
  3691841352U, // <2,5,2,5>: Cost 4 vext2 <0,1,2,5>, <2,5,0,1>
  3691841466U, // <2,5,2,6>: Cost 4 vext2 <0,1,2,5>, <2,6,3,7>
  3088354614U, // <2,5,2,7>: Cost 3 vtrnr <0,2,0,2>, RHS
  3088354615U, // <2,5,2,u>: Cost 3 vtrnr <0,2,0,2>, RHS
  2557829222U, // <2,5,3,0>: Cost 3 vext1 <1,2,5,3>, LHS
  2557830059U, // <2,5,3,1>: Cost 3 vext1 <1,2,5,3>, <1,2,5,3>
  2575746766U, // <2,5,3,2>: Cost 3 vext1 <4,2,5,3>, <2,3,4,5>
  3691841948U, // <2,5,3,3>: Cost 4 vext2 <0,1,2,5>, <3,3,3,3>
  2619427330U, // <2,5,3,4>: Cost 3 vext2 <0,3,2,5>, <3,4,5,6>
  2581720847U, // <2,5,3,5>: Cost 3 vext1 <5,2,5,3>, <5,2,5,3>
  2953628162U, // <2,5,3,6>: Cost 3 vzipr LHS, <3,4,5,6>
  2953626624U, // <2,5,3,7>: Cost 3 vzipr LHS, <1,3,5,7>
  2953626625U, // <2,5,3,u>: Cost 3 vzipr LHS, <1,3,5,u>
  2569781350U, // <2,5,4,0>: Cost 3 vext1 <3,2,5,4>, LHS
  3631580076U, // <2,5,4,1>: Cost 4 vext1 <1,2,5,4>, <1,2,5,4>
  2569782990U, // <2,5,4,2>: Cost 3 vext1 <3,2,5,4>, <2,3,4,5>
  2569783646U, // <2,5,4,3>: Cost 3 vext1 <3,2,5,4>, <3,2,5,4>
  2569784630U, // <2,5,4,4>: Cost 3 vext1 <3,2,5,4>, RHS
  2618101046U, // <2,5,4,5>: Cost 3 vext2 <0,1,2,5>, RHS
  3893905922U, // <2,5,4,6>: Cost 4 vuzpr <0,2,3,5>, <3,4,5,6>
  3094564150U, // <2,5,4,7>: Cost 3 vtrnr <1,2,3,4>, RHS
  2618101289U, // <2,5,4,u>: Cost 3 vext2 <0,1,2,5>, RHS
  2551873638U, // <2,5,5,0>: Cost 3 vext1 <0,2,5,5>, LHS
  3637560320U, // <2,5,5,1>: Cost 4 vext1 <2,2,5,5>, <1,3,5,7>
  3637560966U, // <2,5,5,2>: Cost 4 vext1 <2,2,5,5>, <2,2,5,5>
  3723030343U, // <2,5,5,3>: Cost 4 vext2 <5,3,2,5>, <5,3,2,5>
  2551876918U, // <2,5,5,4>: Cost 3 vext1 <0,2,5,5>, RHS
  2712834052U, // <2,5,5,5>: Cost 3 vext3 <4,6,u,2>, <5,5,5,5>
  4028713474U, // <2,5,5,6>: Cost 4 vzipr <0,3,2,5>, <3,4,5,6>
  2712834072U, // <2,5,5,7>: Cost 3 vext3 <4,6,u,2>, <5,5,7,7>
  2712834081U, // <2,5,5,u>: Cost 3 vext3 <4,6,u,2>, <5,5,u,7>
  2575769702U, // <2,5,6,0>: Cost 3 vext1 <4,2,5,6>, LHS
  3631596462U, // <2,5,6,1>: Cost 4 vext1 <1,2,5,6>, <1,2,5,6>
  2655924730U, // <2,5,6,2>: Cost 3 vext2 <6,4,2,5>, <6,2,7,3>
  3643541856U, // <2,5,6,3>: Cost 4 vext1 <3,2,5,6>, <3,2,5,6>
  2655924849U, // <2,5,6,4>: Cost 3 vext2 <6,4,2,5>, <6,4,2,5>
  3787755607U, // <2,5,6,5>: Cost 4 vext3 <4,u,6,2>, <5,6,5,7>
  4029385218U, // <2,5,6,6>: Cost 4 vzipr <0,4,2,6>, <3,4,5,6>
  3088682294U, // <2,5,6,7>: Cost 3 vtrnr <0,2,4,6>, RHS
  3088682295U, // <2,5,6,u>: Cost 3 vtrnr <0,2,4,6>, RHS
  2563833958U, // <2,5,7,0>: Cost 3 vext1 <2,2,5,7>, LHS
  2551890678U, // <2,5,7,1>: Cost 3 vext1 <0,2,5,7>, <1,0,3,2>
  2563835528U, // <2,5,7,2>: Cost 3 vext1 <2,2,5,7>, <2,2,5,7>
  3637577878U, // <2,5,7,3>: Cost 4 vext1 <2,2,5,7>, <3,0,1,2>
  2563837238U, // <2,5,7,4>: Cost 3 vext1 <2,2,5,7>, RHS
  2712834216U, // <2,5,7,5>: Cost 3 vext3 <4,6,u,2>, <5,7,5,7>
  2712834220U, // <2,5,7,6>: Cost 3 vext3 <4,6,u,2>, <5,7,6,2>
  4174449974U, // <2,5,7,7>: Cost 4 vtrnr <2,2,5,7>, RHS
  2563839790U, // <2,5,7,u>: Cost 3 vext1 <2,2,5,7>, LHS
  2563842150U, // <2,5,u,0>: Cost 3 vext1 <2,2,5,u>, LHS
  2618103598U, // <2,5,u,1>: Cost 3 vext2 <0,1,2,5>, LHS
  2563843721U, // <2,5,u,2>: Cost 3 vext1 <2,2,5,u>, <2,2,5,u>
  2569816418U, // <2,5,u,3>: Cost 3 vext1 <3,2,5,u>, <3,2,5,u>
  2622748735U, // <2,5,u,4>: Cost 3 vext2 <0,u,2,5>, <u,4,5,6>
  2618103962U, // <2,5,u,5>: Cost 3 vext2 <0,1,2,5>, RHS
  2953669122U, // <2,5,u,6>: Cost 3 vzipr LHS, <3,4,5,6>
  2953667584U, // <2,5,u,7>: Cost 3 vzipr LHS, <1,3,5,7>
  2618104165U, // <2,5,u,u>: Cost 3 vext2 <0,1,2,5>, LHS
  2620096512U, // <2,6,0,0>: Cost 3 vext2 <0,4,2,6>, <0,0,0,0>
  1546354790U, // <2,6,0,1>: Cost 2 vext2 <0,4,2,6>, LHS
  2620096676U, // <2,6,0,2>: Cost 3 vext2 <0,4,2,6>, <0,2,0,2>
  3693838588U, // <2,6,0,3>: Cost 4 vext2 <0,4,2,6>, <0,3,1,0>
  1546355036U, // <2,6,0,4>: Cost 2 vext2 <0,4,2,6>, <0,4,2,6>
  3694502317U, // <2,6,0,5>: Cost 4 vext2 <0,5,2,6>, <0,5,2,6>
  2551911246U, // <2,6,0,6>: Cost 3 vext1 <0,2,6,0>, <6,7,0,1>
  2720723287U, // <2,6,0,7>: Cost 3 vext3 <6,0,7,2>, <6,0,7,2>
  1546355357U, // <2,6,0,u>: Cost 2 vext2 <0,4,2,6>, LHS
  2620097270U, // <2,6,1,0>: Cost 3 vext2 <0,4,2,6>, <1,0,3,2>
  2620097332U, // <2,6,1,1>: Cost 3 vext2 <0,4,2,6>, <1,1,1,1>
  2620097430U, // <2,6,1,2>: Cost 3 vext2 <0,4,2,6>, <1,2,3,0>
  2820243558U, // <2,6,1,3>: Cost 3 vuzpr <0,2,4,6>, LHS
  2620097598U, // <2,6,1,4>: Cost 3 vext2 <0,4,2,6>, <1,4,3,6>
  2620097680U, // <2,6,1,5>: Cost 3 vext2 <0,4,2,6>, <1,5,3,7>
  3693839585U, // <2,6,1,6>: Cost 4 vext2 <0,4,2,6>, <1,6,3,7>
  2721386920U, // <2,6,1,7>: Cost 3 vext3 <6,1,7,2>, <6,1,7,2>
  2820243563U, // <2,6,1,u>: Cost 3 vuzpr <0,2,4,6>, LHS
  2714014137U, // <2,6,2,0>: Cost 3 vext3 <4,u,6,2>, <6,2,0,1>
  2712834500U, // <2,6,2,1>: Cost 3 vext3 <4,6,u,2>, <6,2,1,3>
  2620098152U, // <2,6,2,2>: Cost 3 vext2 <0,4,2,6>, <2,2,2,2>
  2620098214U, // <2,6,2,3>: Cost 3 vext2 <0,4,2,6>, <2,3,0,1>
  2632042254U, // <2,6,2,4>: Cost 3 vext2 <2,4,2,6>, <2,4,2,6>
  2712834540U, // <2,6,2,5>: Cost 3 vext3 <4,6,u,2>, <6,2,5,7>
  2820243660U, // <2,6,2,6>: Cost 3 vuzpr <0,2,4,6>, <0,2,4,6>
  2958265654U, // <2,6,2,7>: Cost 3 vzipr <0,u,2,2>, RHS
  2620098619U, // <2,6,2,u>: Cost 3 vext2 <0,4,2,6>, <2,u,0,1>
  2620098710U, // <2,6,3,0>: Cost 3 vext2 <0,4,2,6>, <3,0,1,2>
  3893986982U, // <2,6,3,1>: Cost 4 vuzpr <0,2,4,6>, <2,3,0,1>
  2569848762U, // <2,6,3,2>: Cost 3 vext1 <3,2,6,3>, <2,6,3,7>
  2620098972U, // <2,6,3,3>: Cost 3 vext2 <0,4,2,6>, <3,3,3,3>
  2620099074U, // <2,6,3,4>: Cost 3 vext2 <0,4,2,6>, <3,4,5,6>
  3893987022U, // <2,6,3,5>: Cost 4 vuzpr <0,2,4,6>, <2,3,4,5>
  3001404644U, // <2,6,3,6>: Cost 3 vzipr LHS, <4,4,6,6>
  1879887158U, // <2,6,3,7>: Cost 2 vzipr LHS, RHS
  1879887159U, // <2,6,3,u>: Cost 2 vzipr LHS, RHS
  2620099484U, // <2,6,4,0>: Cost 3 vext2 <0,4,2,6>, <4,0,6,2>
  2620099566U, // <2,6,4,1>: Cost 3 vext2 <0,4,2,6>, <4,1,6,3>
  2620099644U, // <2,6,4,2>: Cost 3 vext2 <0,4,2,6>, <4,2,6,0>
  3643599207U, // <2,6,4,3>: Cost 4 vext1 <3,2,6,4>, <3,2,6,4>
  2575830080U, // <2,6,4,4>: Cost 3 vext1 <4,2,6,4>, <4,2,6,4>
  1546358070U, // <2,6,4,5>: Cost 2 vext2 <0,4,2,6>, RHS
  2667875700U, // <2,6,4,6>: Cost 3 vext2 <u,4,2,6>, <4,6,4,6>
  4028042550U, // <2,6,4,7>: Cost 4 vzipr <0,2,2,4>, RHS
  1546358313U, // <2,6,4,u>: Cost 2 vext2 <0,4,2,6>, RHS
  3693841992U, // <2,6,5,0>: Cost 4 vext2 <0,4,2,6>, <5,0,1,2>
  2667876048U, // <2,6,5,1>: Cost 3 vext2 <u,4,2,6>, <5,1,7,3>
  2712834756U, // <2,6,5,2>: Cost 3 vext3 <4,6,u,2>, <6,5,2,7>
  3643607400U, // <2,6,5,3>: Cost 4 vext1 <3,2,6,5>, <3,2,6,5>
  2252091873U, // <2,6,5,4>: Cost 3 vrev <6,2,4,5>
  2667876356U, // <2,6,5,5>: Cost 3 vext2 <u,4,2,6>, <5,5,5,5>
  2667876450U, // <2,6,5,6>: Cost 3 vext2 <u,4,2,6>, <5,6,7,0>
  2820246838U, // <2,6,5,7>: Cost 3 vuzpr <0,2,4,6>, RHS
  2820246839U, // <2,6,5,u>: Cost 3 vuzpr <0,2,4,6>, RHS
  2563899494U, // <2,6,6,0>: Cost 3 vext1 <2,2,6,6>, LHS
  3893988683U, // <2,6,6,1>: Cost 4 vuzpr <0,2,4,6>, <4,6,0,1>
  2563901072U, // <2,6,6,2>: Cost 3 vext1 <2,2,6,6>, <2,2,6,6>
  3893987236U, // <2,6,6,3>: Cost 4 vuzpr <0,2,4,6>, <2,6,1,3>
  2563902774U, // <2,6,6,4>: Cost 3 vext1 <2,2,6,6>, RHS
  3893988723U, // <2,6,6,5>: Cost 4 vuzpr <0,2,4,6>, <4,6,4,5>
  2712834872U, // <2,6,6,6>: Cost 3 vext3 <4,6,u,2>, <6,6,6,6>
  2955644214U, // <2,6,6,7>: Cost 3 vzipr <0,4,2,6>, RHS
  2955644215U, // <2,6,6,u>: Cost 3 vzipr <0,4,2,6>, RHS
  2712834894U, // <2,6,7,0>: Cost 3 vext3 <4,6,u,2>, <6,7,0,1>
  2724926296U, // <2,6,7,1>: Cost 3 vext3 <6,7,1,2>, <6,7,1,2>
  2725000033U, // <2,6,7,2>: Cost 3 vext3 <6,7,2,2>, <6,7,2,2>
  2702365544U, // <2,6,7,3>: Cost 3 vext3 <3,0,1,2>, <6,7,3,0>
  2712834934U, // <2,6,7,4>: Cost 3 vext3 <4,6,u,2>, <6,7,4,5>
  3776107393U, // <2,6,7,5>: Cost 4 vext3 <3,0,1,2>, <6,7,5,7>
  2725294981U, // <2,6,7,6>: Cost 3 vext3 <6,7,6,2>, <6,7,6,2>
  2726253452U, // <2,6,7,7>: Cost 3 vext3 <7,0,1,2>, <6,7,7,0>
  2712834966U, // <2,6,7,u>: Cost 3 vext3 <4,6,u,2>, <6,7,u,1>
  2620102355U, // <2,6,u,0>: Cost 3 vext2 <0,4,2,6>, <u,0,1,2>
  1546360622U, // <2,6,u,1>: Cost 2 vext2 <0,4,2,6>, LHS
  2620102536U, // <2,6,u,2>: Cost 3 vext2 <0,4,2,6>, <u,2,3,3>
  2820244125U, // <2,6,u,3>: Cost 3 vuzpr <0,2,4,6>, LHS
  1594136612U, // <2,6,u,4>: Cost 2 vext2 <u,4,2,6>, <u,4,2,6>
  1546360986U, // <2,6,u,5>: Cost 2 vext2 <0,4,2,6>, RHS
  2620102864U, // <2,6,u,6>: Cost 3 vext2 <0,4,2,6>, <u,6,3,7>
  1879928118U, // <2,6,u,7>: Cost 2 vzipr LHS, RHS
  1879928119U, // <2,6,u,u>: Cost 2 vzipr LHS, RHS
  2726179825U, // <2,7,0,0>: Cost 3 vext3 <7,0,0,2>, <7,0,0,2>
  1652511738U, // <2,7,0,1>: Cost 2 vext3 <7,0,1,2>, <7,0,1,2>
  2621431972U, // <2,7,0,2>: Cost 3 vext2 <0,6,2,7>, <0,2,0,2>
  2257949868U, // <2,7,0,3>: Cost 3 vrev <7,2,3,0>
  2726474773U, // <2,7,0,4>: Cost 3 vext3 <7,0,4,2>, <7,0,4,2>
  2620768686U, // <2,7,0,5>: Cost 3 vext2 <0,5,2,7>, <0,5,2,7>
  2621432319U, // <2,7,0,6>: Cost 3 vext2 <0,6,2,7>, <0,6,2,7>
  2599760953U, // <2,7,0,7>: Cost 3 vext1 <u,2,7,0>, <7,0,u,2>
  1653027897U, // <2,7,0,u>: Cost 2 vext3 <7,0,u,2>, <7,0,u,2>
  2639348470U, // <2,7,1,0>: Cost 3 vext2 <3,6,2,7>, <1,0,3,2>
  3695174452U, // <2,7,1,1>: Cost 4 vext2 <0,6,2,7>, <1,1,1,1>
  3695174550U, // <2,7,1,2>: Cost 4 vext2 <0,6,2,7>, <1,2,3,0>
  3694511104U, // <2,7,1,3>: Cost 4 vext2 <0,5,2,7>, <1,3,5,7>
  3713090594U, // <2,7,1,4>: Cost 4 vext2 <3,6,2,7>, <1,4,0,5>
  3693184144U, // <2,7,1,5>: Cost 4 vext2 <0,3,2,7>, <1,5,3,7>
  2627405016U, // <2,7,1,6>: Cost 3 vext2 <1,6,2,7>, <1,6,2,7>
  3799995519U, // <2,7,1,7>: Cost 4 vext3 <7,0,1,2>, <7,1,7,0>
  2639348470U, // <2,7,1,u>: Cost 3 vext2 <3,6,2,7>, <1,0,3,2>
  3695175101U, // <2,7,2,0>: Cost 4 vext2 <0,6,2,7>, <2,0,1,2>
  3643655168U, // <2,7,2,1>: Cost 4 vext1 <3,2,7,2>, <1,3,5,7>
  2257892517U, // <2,7,2,2>: Cost 3 vrev <7,2,2,2>
  3695175334U, // <2,7,2,3>: Cost 4 vext2 <0,6,2,7>, <2,3,0,1>
  3695175465U, // <2,7,2,4>: Cost 4 vext2 <0,6,2,7>, <2,4,5,6>
  2632714080U, // <2,7,2,5>: Cost 3 vext2 <2,5,2,7>, <2,5,2,7>
  2633377713U, // <2,7,2,6>: Cost 3 vext2 <2,6,2,7>, <2,6,2,7>
  3695175658U, // <2,7,2,7>: Cost 4 vext2 <0,6,2,7>, <2,7,0,1>
  2634704979U, // <2,7,2,u>: Cost 3 vext2 <2,u,2,7>, <2,u,2,7>
  1514094694U, // <2,7,3,0>: Cost 2 vext1 <6,2,7,3>, LHS
  2569921680U, // <2,7,3,1>: Cost 3 vext1 <3,2,7,3>, <1,5,3,7>
  2587838056U, // <2,7,3,2>: Cost 3 vext1 <6,2,7,3>, <2,2,2,2>
  2569922927U, // <2,7,3,3>: Cost 3 vext1 <3,2,7,3>, <3,2,7,3>
  1514097974U, // <2,7,3,4>: Cost 2 vext1 <6,2,7,3>, RHS
  2581868321U, // <2,7,3,5>: Cost 3 vext1 <5,2,7,3>, <5,2,7,3>
  1514099194U, // <2,7,3,6>: Cost 2 vext1 <6,2,7,3>, <6,2,7,3>
  2587841530U, // <2,7,3,7>: Cost 3 vext1 <6,2,7,3>, <7,0,1,2>
  1514100526U, // <2,7,3,u>: Cost 2 vext1 <6,2,7,3>, LHS
  2708706617U, // <2,7,4,0>: Cost 3 vext3 <4,0,6,2>, <7,4,0,6>
  3649643418U, // <2,7,4,1>: Cost 4 vext1 <4,2,7,4>, <1,2,3,4>
  3649644330U, // <2,7,4,2>: Cost 4 vext1 <4,2,7,4>, <2,4,5,7>
  2257982640U, // <2,7,4,3>: Cost 3 vrev <7,2,3,4>
  3649645641U, // <2,7,4,4>: Cost 4 vext1 <4,2,7,4>, <4,2,7,4>
  2621435190U, // <2,7,4,5>: Cost 3 vext2 <0,6,2,7>, RHS
  2712835441U, // <2,7,4,6>: Cost 3 vext3 <4,6,u,2>, <7,4,6,u>
  3799995762U, // <2,7,4,7>: Cost 4 vext3 <7,0,1,2>, <7,4,7,0>
  2621435433U, // <2,7,4,u>: Cost 3 vext2 <0,6,2,7>, RHS
  2729497990U, // <2,7,5,0>: Cost 3 vext3 <7,5,0,2>, <7,5,0,2>
  3643679744U, // <2,7,5,1>: Cost 4 vext1 <3,2,7,5>, <1,3,5,7>
  3637708424U, // <2,7,5,2>: Cost 4 vext1 <2,2,7,5>, <2,2,5,7>
  3643681137U, // <2,7,5,3>: Cost 4 vext1 <3,2,7,5>, <3,2,7,5>
  2599800118U, // <2,7,5,4>: Cost 3 vext1 <u,2,7,5>, RHS
  3786577334U, // <2,7,5,5>: Cost 4 vext3 <4,6,u,2>, <7,5,5,5>
  3786577345U, // <2,7,5,6>: Cost 4 vext3 <4,6,u,2>, <7,5,6,7>
  2599802214U, // <2,7,5,7>: Cost 3 vext1 <u,2,7,5>, <7,4,5,6>
  2599802670U, // <2,7,5,u>: Cost 3 vext1 <u,2,7,5>, LHS
  2581889126U, // <2,7,6,0>: Cost 3 vext1 <5,2,7,6>, LHS
  3643687936U, // <2,7,6,1>: Cost 4 vext1 <3,2,7,6>, <1,3,5,7>
  2663240186U, // <2,7,6,2>: Cost 3 vext2 <7,6,2,7>, <6,2,7,3>
  3643689330U, // <2,7,6,3>: Cost 4 vext1 <3,2,7,6>, <3,2,7,6>
  2581892406U, // <2,7,6,4>: Cost 3 vext1 <5,2,7,6>, RHS
  2581892900U, // <2,7,6,5>: Cost 3 vext1 <5,2,7,6>, <5,2,7,6>
  2587865597U, // <2,7,6,6>: Cost 3 vext1 <6,2,7,6>, <6,2,7,6>
  3786577428U, // <2,7,6,7>: Cost 4 vext3 <4,6,u,2>, <7,6,7,0>
  2581894958U, // <2,7,6,u>: Cost 3 vext1 <5,2,7,6>, LHS
  2726254119U, // <2,7,7,0>: Cost 3 vext3 <7,0,1,2>, <7,7,0,1>
  3804640817U, // <2,7,7,1>: Cost 4 vext3 <7,7,1,2>, <7,7,1,2>
  3637724826U, // <2,7,7,2>: Cost 4 vext1 <2,2,7,7>, <2,2,7,7>
  3734992123U, // <2,7,7,3>: Cost 4 vext2 <7,3,2,7>, <7,3,2,7>
  2552040758U, // <2,7,7,4>: Cost 3 vext1 <0,2,7,7>, RHS
  3799995992U, // <2,7,7,5>: Cost 4 vext3 <7,0,1,2>, <7,7,5,5>
  2663241198U, // <2,7,7,6>: Cost 3 vext2 <7,6,2,7>, <7,6,2,7>
  2712835692U, // <2,7,7,7>: Cost 3 vext3 <4,6,u,2>, <7,7,7,7>
  2731562607U, // <2,7,7,u>: Cost 3 vext3 <7,u,1,2>, <7,7,u,1>
  1514135654U, // <2,7,u,0>: Cost 2 vext1 <6,2,7,u>, LHS
  1657820802U, // <2,7,u,1>: Cost 2 vext3 <7,u,1,2>, <7,u,1,2>
  2587879016U, // <2,7,u,2>: Cost 3 vext1 <6,2,7,u>, <2,2,2,2>
  2569963892U, // <2,7,u,3>: Cost 3 vext1 <3,2,7,u>, <3,2,7,u>
  1514138934U, // <2,7,u,4>: Cost 2 vext1 <6,2,7,u>, RHS
  2621438106U, // <2,7,u,5>: Cost 3 vext2 <0,6,2,7>, RHS
  1514140159U, // <2,7,u,6>: Cost 2 vext1 <6,2,7,u>, <6,2,7,u>
  2587882490U, // <2,7,u,7>: Cost 3 vext1 <6,2,7,u>, <7,0,1,2>
  1514141486U, // <2,7,u,u>: Cost 2 vext1 <6,2,7,u>, LHS
  1544380416U, // <2,u,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
  470638699U, // <2,u,0,1>: Cost 1 vext2 LHS, LHS
  1544380580U, // <2,u,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
  1658631909U, // <2,u,0,3>: Cost 2 vext3 <u,0,3,2>, <u,0,3,2>
  1544380754U, // <2,u,0,4>: Cost 2 vext2 LHS, <0,4,1,5>
  2665898414U, // <2,u,0,5>: Cost 3 vext2 LHS, <0,5,2,7>
  1658853120U, // <2,u,0,6>: Cost 2 vext3 <u,0,6,2>, <u,0,6,2>
  3094531625U, // <2,u,0,7>: Cost 3 vtrnr <1,2,3,0>, RHS
  470639261U, // <2,u,0,u>: Cost 1 vext2 LHS, LHS
  1544381174U, // <2,u,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
  1544381236U, // <2,u,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
  1544381334U, // <2,u,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
  1544381400U, // <2,u,1,3>: Cost 2 vext2 LHS, <1,3,1,3>
  2618123325U, // <2,u,1,4>: Cost 3 vext2 LHS, <1,4,3,5>
  1544381584U, // <2,u,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
  2618123489U, // <2,u,1,6>: Cost 3 vext2 LHS, <1,6,3,7>
  2726254427U, // <2,u,1,7>: Cost 3 vext3 <7,0,1,2>, <u,1,7,3>
  1544381823U, // <2,u,1,u>: Cost 2 vext2 LHS, <1,u,3,3>
  1478328422U, // <2,u,2,0>: Cost 2 vext1 <0,2,u,2>, LHS
  2618123807U, // <2,u,2,1>: Cost 3 vext2 LHS, <2,1,3,1>
  269271142U, // <2,u,2,2>: Cost 1 vdup2 LHS
  1544382118U, // <2,u,2,3>: Cost 2 vext2 LHS, <2,3,0,1>
  1478331702U, // <2,u,2,4>: Cost 2 vext1 <0,2,u,2>, RHS
  2618124136U, // <2,u,2,5>: Cost 3 vext2 LHS, <2,5,3,6>
  1544382394U, // <2,u,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
  3088354857U, // <2,u,2,7>: Cost 3 vtrnr <0,2,0,2>, RHS
  269271142U, // <2,u,2,u>: Cost 1 vdup2 LHS
  1544382614U, // <2,u,3,0>: Cost 2 vext2 LHS, <3,0,1,2>
  2953627374U, // <2,u,3,1>: Cost 3 vzipr LHS, <2,3,u,1>
  1490282143U, // <2,u,3,2>: Cost 2 vext1 <2,2,u,3>, <2,2,u,3>
  1879883932U, // <2,u,3,3>: Cost 2 vzipr LHS, LHS
  1544382978U, // <2,u,3,4>: Cost 2 vext2 LHS, <3,4,5,6>
  2953627378U, // <2,u,3,5>: Cost 3 vzipr LHS, <2,3,u,5>
  1514172931U, // <2,u,3,6>: Cost 2 vext1 <6,2,u,3>, <6,2,u,3>
  1879887176U, // <2,u,3,7>: Cost 2 vzipr LHS, RHS
  1879883937U, // <2,u,3,u>: Cost 2 vzipr LHS, LHS
  1484316774U, // <2,u,4,0>: Cost 2 vext1 <1,2,u,4>, LHS
  1484317639U, // <2,u,4,1>: Cost 2 vext1 <1,2,u,4>, <1,2,u,4>
  2552088270U, // <2,u,4,2>: Cost 3 vext1 <0,2,u,4>, <2,3,4,5>
  1190213513U, // <2,u,4,3>: Cost 2 vrev <u,2,3,4>
  1484320054U, // <2,u,4,4>: Cost 2 vext1 <1,2,u,4>, RHS
  470641974U, // <2,u,4,5>: Cost 1 vext2 LHS, RHS
  1592159604U, // <2,u,4,6>: Cost 2 vext2 LHS, <4,6,4,6>
  3094564393U, // <2,u,4,7>: Cost 3 vtrnr <1,2,3,4>, RHS
  470642217U, // <2,u,4,u>: Cost 1 vext2 LHS, RHS
  2552094959U, // <2,u,5,0>: Cost 3 vext1 <0,2,u,5>, <0,2,u,5>
  1592159952U, // <2,u,5,1>: Cost 2 vext2 LHS, <5,1,7,3>
  2564040353U, // <2,u,5,2>: Cost 3 vext1 <2,2,u,5>, <2,2,u,5>
  2690275455U, // <2,u,5,3>: Cost 3 vext3 <0,u,u,2>, <u,5,3,7>
  1592160198U, // <2,u,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
  1592160260U, // <2,u,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
  1611962522U, // <2,u,5,6>: Cost 2 vext3 <0,2,0,2>, RHS
  1592160424U, // <2,u,5,7>: Cost 2 vext2 LHS, <5,7,5,7>
  1611962540U, // <2,u,5,u>: Cost 2 vext3 <0,2,0,2>, RHS
  1478361190U, // <2,u,6,0>: Cost 2 vext1 <0,2,u,6>, LHS
  2552103670U, // <2,u,6,1>: Cost 3 vext1 <0,2,u,6>, <1,0,3,2>
  1592160762U, // <2,u,6,2>: Cost 2 vext2 LHS, <6,2,7,3>
  2685704400U, // <2,u,6,3>: Cost 3 vext3 <0,2,0,2>, <u,6,3,7>
  1478364470U, // <2,u,6,4>: Cost 2 vext1 <0,2,u,6>, RHS
  2901891226U, // <2,u,6,5>: Cost 3 vzipl <2,6,3,7>, RHS
  1592161080U, // <2,u,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
  1592161102U, // <2,u,6,7>: Cost 2 vext2 LHS, <6,7,0,1>
  1478367022U, // <2,u,6,u>: Cost 2 vext1 <0,2,u,6>, LHS
  1592161274U, // <2,u,7,0>: Cost 2 vext2 LHS, <7,0,1,2>
  2659931226U, // <2,u,7,1>: Cost 3 vext2 <7,1,2,u>, <7,1,2,u>
  2564056739U, // <2,u,7,2>: Cost 3 vext1 <2,2,u,7>, <2,2,u,7>
  2665903331U, // <2,u,7,3>: Cost 3 vext2 LHS, <7,3,0,1>
  1592161638U, // <2,u,7,4>: Cost 2 vext2 LHS, <7,4,5,6>
  2665903494U, // <2,u,7,5>: Cost 3 vext2 LHS, <7,5,0,2>
  2587947527U, // <2,u,7,6>: Cost 3 vext1 <6,2,u,7>, <6,2,u,7>
  1592161900U, // <2,u,7,7>: Cost 2 vext2 LHS, <7,7,7,7>
  1592161922U, // <2,u,7,u>: Cost 2 vext2 LHS, <7,u,1,2>
  1478377574U, // <2,u,u,0>: Cost 2 vext1 <0,2,u,u>, LHS
  470644526U, // <2,u,u,1>: Cost 1 vext2 LHS, LHS
  269271142U, // <2,u,u,2>: Cost 1 vdup2 LHS
  1879924892U, // <2,u,u,3>: Cost 2 vzipr LHS, LHS
  1478380854U, // <2,u,u,4>: Cost 2 vext1 <0,2,u,u>, RHS
  470644890U, // <2,u,u,5>: Cost 1 vext2 LHS, RHS
  1611962765U, // <2,u,u,6>: Cost 2 vext3 <0,2,0,2>, RHS
  1879928136U, // <2,u,u,7>: Cost 2 vzipr LHS, RHS
  470645093U, // <2,u,u,u>: Cost 1 vext2 LHS, LHS
  1611448320U, // <3,0,0,0>: Cost 2 vext3 LHS, <0,0,0,0>
  1611890698U, // <3,0,0,1>: Cost 2 vext3 LHS, <0,0,1,1>
  1611890708U, // <3,0,0,2>: Cost 2 vext3 LHS, <0,0,2,2>
  3763576860U, // <3,0,0,3>: Cost 4 vext3 LHS, <0,0,3,1>
  2689835045U, // <3,0,0,4>: Cost 3 vext3 LHS, <0,0,4,1>
  3698508206U, // <3,0,0,5>: Cost 4 vext2 <1,2,3,0>, <0,5,2,7>
  3763576887U, // <3,0,0,6>: Cost 4 vext3 LHS, <0,0,6,1>
  3667678434U, // <3,0,0,7>: Cost 4 vext1 <7,3,0,0>, <7,3,0,0>
  1616093258U, // <3,0,0,u>: Cost 2 vext3 LHS, <0,0,u,2>
  1490337894U, // <3,0,1,0>: Cost 2 vext1 <2,3,0,1>, LHS
  2685632602U, // <3,0,1,1>: Cost 3 vext3 LHS, <0,1,1,0>
  537706598U, // <3,0,1,2>: Cost 1 vext3 LHS, LHS
  2624766936U, // <3,0,1,3>: Cost 3 vext2 <1,2,3,0>, <1,3,1,3>
  1490341174U, // <3,0,1,4>: Cost 2 vext1 <2,3,0,1>, RHS
  2624767120U, // <3,0,1,5>: Cost 3 vext2 <1,2,3,0>, <1,5,3,7>
  2732966030U, // <3,0,1,6>: Cost 3 vext3 LHS, <0,1,6,7>
  2593944803U, // <3,0,1,7>: Cost 3 vext1 <7,3,0,1>, <7,3,0,1>
  537706652U, // <3,0,1,u>: Cost 1 vext3 LHS, LHS
  1611890852U, // <3,0,2,0>: Cost 2 vext3 LHS, <0,2,0,2>
  2685632684U, // <3,0,2,1>: Cost 3 vext3 LHS, <0,2,1,1>
  2685632692U, // <3,0,2,2>: Cost 3 vext3 LHS, <0,2,2,0>
  2685632702U, // <3,0,2,3>: Cost 3 vext3 LHS, <0,2,3,1>
  1611890892U, // <3,0,2,4>: Cost 2 vext3 LHS, <0,2,4,6>
  2732966102U, // <3,0,2,5>: Cost 3 vext3 LHS, <0,2,5,7>
  2624767930U, // <3,0,2,6>: Cost 3 vext2 <1,2,3,0>, <2,6,3,7>
  2685632744U, // <3,0,2,7>: Cost 3 vext3 LHS, <0,2,7,7>
  1611890924U, // <3,0,2,u>: Cost 2 vext3 LHS, <0,2,u,2>
  2624768150U, // <3,0,3,0>: Cost 3 vext2 <1,2,3,0>, <3,0,1,2>
  2685632764U, // <3,0,3,1>: Cost 3 vext3 LHS, <0,3,1,0>
  2685632774U, // <3,0,3,2>: Cost 3 vext3 LHS, <0,3,2,1>
  2624768412U, // <3,0,3,3>: Cost 3 vext2 <1,2,3,0>, <3,3,3,3>
  2624768514U, // <3,0,3,4>: Cost 3 vext2 <1,2,3,0>, <3,4,5,6>
  3702491714U, // <3,0,3,5>: Cost 4 vext2 <1,u,3,0>, <3,5,3,7>
  2624768632U, // <3,0,3,6>: Cost 3 vext2 <1,2,3,0>, <3,6,0,7>
  3702491843U, // <3,0,3,7>: Cost 4 vext2 <1,u,3,0>, <3,7,0,1>
  2686959934U, // <3,0,3,u>: Cost 3 vext3 <0,3,u,3>, <0,3,u,3>
  2689835336U, // <3,0,4,0>: Cost 3 vext3 LHS, <0,4,0,4>
  1611891026U, // <3,0,4,1>: Cost 2 vext3 LHS, <0,4,1,5>
  1611891036U, // <3,0,4,2>: Cost 2 vext3 LHS, <0,4,2,6>
  3763577184U, // <3,0,4,3>: Cost 4 vext3 LHS, <0,4,3,1>
  2689835374U, // <3,0,4,4>: Cost 3 vext3 LHS, <0,4,4,6>
  1551027510U, // <3,0,4,5>: Cost 2 vext2 <1,2,3,0>, RHS
  2666573172U, // <3,0,4,6>: Cost 3 vext2 <u,2,3,0>, <4,6,4,6>
  3667711206U, // <3,0,4,7>: Cost 4 vext1 <7,3,0,4>, <7,3,0,4>
  1616093586U, // <3,0,4,u>: Cost 2 vext3 LHS, <0,4,u,6>
  2685190556U, // <3,0,5,0>: Cost 3 vext3 LHS, <0,5,0,7>
  2666573520U, // <3,0,5,1>: Cost 3 vext2 <u,2,3,0>, <5,1,7,3>
  3040886886U, // <3,0,5,2>: Cost 3 vtrnl <3,4,5,6>, LHS
  3625912834U, // <3,0,5,3>: Cost 4 vext1 <0,3,0,5>, <3,4,5,6>
  2666573766U, // <3,0,5,4>: Cost 3 vext2 <u,2,3,0>, <5,4,7,6>
  2666573828U, // <3,0,5,5>: Cost 3 vext2 <u,2,3,0>, <5,5,5,5>
  2732966354U, // <3,0,5,6>: Cost 3 vext3 LHS, <0,5,6,7>
  2666573992U, // <3,0,5,7>: Cost 3 vext2 <u,2,3,0>, <5,7,5,7>
  3040886940U, // <3,0,5,u>: Cost 3 vtrnl <3,4,5,6>, LHS
  2685190637U, // <3,0,6,0>: Cost 3 vext3 LHS, <0,6,0,7>
  2732966390U, // <3,0,6,1>: Cost 3 vext3 LHS, <0,6,1,7>
  2689835519U, // <3,0,6,2>: Cost 3 vext3 LHS, <0,6,2,7>
  3667724438U, // <3,0,6,3>: Cost 4 vext1 <7,3,0,6>, <3,0,1,2>
  3763577355U, // <3,0,6,4>: Cost 4 vext3 LHS, <0,6,4,1>
  3806708243U, // <3,0,6,5>: Cost 4 vext3 LHS, <0,6,5,0>
  2666574648U, // <3,0,6,6>: Cost 3 vext2 <u,2,3,0>, <6,6,6,6>
  2657948520U, // <3,0,6,7>: Cost 3 vext2 <6,7,3,0>, <6,7,3,0>
  2689835573U, // <3,0,6,u>: Cost 3 vext3 LHS, <0,6,u,7>
  2666574842U, // <3,0,7,0>: Cost 3 vext2 <u,2,3,0>, <7,0,1,2>
  2685633095U, // <3,0,7,1>: Cost 3 vext3 LHS, <0,7,1,7>
  2660603052U, // <3,0,7,2>: Cost 3 vext2 <7,2,3,0>, <7,2,3,0>
  3643844997U, // <3,0,7,3>: Cost 4 vext1 <3,3,0,7>, <3,3,0,7>
  2666575206U, // <3,0,7,4>: Cost 3 vext2 <u,2,3,0>, <7,4,5,6>
  3655790391U, // <3,0,7,5>: Cost 4 vext1 <5,3,0,7>, <5,3,0,7>
  3731690968U, // <3,0,7,6>: Cost 4 vext2 <6,7,3,0>, <7,6,0,3>
  2666575468U, // <3,0,7,7>: Cost 3 vext2 <u,2,3,0>, <7,7,7,7>
  2664584850U, // <3,0,7,u>: Cost 3 vext2 <7,u,3,0>, <7,u,3,0>
  1616093834U, // <3,0,u,0>: Cost 2 vext3 LHS, <0,u,0,2>
  1611891346U, // <3,0,u,1>: Cost 2 vext3 LHS, <0,u,1,1>
  537707165U, // <3,0,u,2>: Cost 1 vext3 LHS, LHS
  2689835684U, // <3,0,u,3>: Cost 3 vext3 LHS, <0,u,3,1>
  1616093874U, // <3,0,u,4>: Cost 2 vext3 LHS, <0,u,4,6>
  1551030426U, // <3,0,u,5>: Cost 2 vext2 <1,2,3,0>, RHS
  2624772304U, // <3,0,u,6>: Cost 3 vext2 <1,2,3,0>, <u,6,3,7>
  2594002154U, // <3,0,u,7>: Cost 3 vext1 <7,3,0,u>, <7,3,0,u>
  537707219U, // <3,0,u,u>: Cost 1 vext3 LHS, LHS
  2552201318U, // <3,1,0,0>: Cost 3 vext1 <0,3,1,0>, LHS
  2618802278U, // <3,1,0,1>: Cost 3 vext2 <0,2,3,1>, LHS
  2618802366U, // <3,1,0,2>: Cost 3 vext2 <0,2,3,1>, <0,2,3,1>
  1611449078U, // <3,1,0,3>: Cost 2 vext3 LHS, <1,0,3,2>
  2552204598U, // <3,1,0,4>: Cost 3 vext1 <0,3,1,0>, RHS
  2732966663U, // <3,1,0,5>: Cost 3 vext3 LHS, <1,0,5,1>
  3906258396U, // <3,1,0,6>: Cost 4 vuzpr <2,3,0,1>, <2,0,4,6>
  3667752171U, // <3,1,0,7>: Cost 4 vext1 <7,3,1,0>, <7,3,1,0>
  1611891491U, // <3,1,0,u>: Cost 2 vext3 LHS, <1,0,u,2>
  2689835819U, // <3,1,1,0>: Cost 3 vext3 LHS, <1,1,0,1>
  1611449140U, // <3,1,1,1>: Cost 2 vext3 LHS, <1,1,1,1>
  2624775063U, // <3,1,1,2>: Cost 3 vext2 <1,2,3,1>, <1,2,3,1>
  1611891528U, // <3,1,1,3>: Cost 2 vext3 LHS, <1,1,3,3>
  2689835859U, // <3,1,1,4>: Cost 3 vext3 LHS, <1,1,4,5>
  2689835868U, // <3,1,1,5>: Cost 3 vext3 LHS, <1,1,5,5>
  3763577701U, // <3,1,1,6>: Cost 4 vext3 LHS, <1,1,6,5>
  3765273452U, // <3,1,1,7>: Cost 4 vext3 <1,1,7,3>, <1,1,7,3>
  1611891573U, // <3,1,1,u>: Cost 2 vext3 LHS, <1,1,u,3>
  2629420494U, // <3,1,2,0>: Cost 3 vext2 <2,0,3,1>, <2,0,3,1>
  2689835911U, // <3,1,2,1>: Cost 3 vext3 LHS, <1,2,1,3>
  2564163248U, // <3,1,2,2>: Cost 3 vext1 <2,3,1,2>, <2,3,1,2>
  1611449238U, // <3,1,2,3>: Cost 2 vext3 LHS, <1,2,3,0>
  2564164918U, // <3,1,2,4>: Cost 3 vext1 <2,3,1,2>, RHS
  2689835947U, // <3,1,2,5>: Cost 3 vext3 LHS, <1,2,5,3>
  3692545978U, // <3,1,2,6>: Cost 4 vext2 <0,2,3,1>, <2,6,3,7>
  2732966842U, // <3,1,2,7>: Cost 3 vext3 LHS, <1,2,7,0>
  1611891651U, // <3,1,2,u>: Cost 2 vext3 LHS, <1,2,u,0>
  1484456038U, // <3,1,3,0>: Cost 2 vext1 <1,3,1,3>, LHS
  1611891672U, // <3,1,3,1>: Cost 2 vext3 LHS, <1,3,1,3>
  2685633502U, // <3,1,3,2>: Cost 3 vext3 LHS, <1,3,2,0>
  2685633512U, // <3,1,3,3>: Cost 3 vext3 LHS, <1,3,3,1>
  1484459318U, // <3,1,3,4>: Cost 2 vext1 <1,3,1,3>, RHS
  1611891712U, // <3,1,3,5>: Cost 2 vext3 LHS, <1,3,5,7>
  2689836041U, // <3,1,3,6>: Cost 3 vext3 LHS, <1,3,6,7>
  2733409294U, // <3,1,3,7>: Cost 3 vext3 LHS, <1,3,7,3>
  1611891735U, // <3,1,3,u>: Cost 2 vext3 LHS, <1,3,u,3>
  2552234086U, // <3,1,4,0>: Cost 3 vext1 <0,3,1,4>, LHS
  2732966955U, // <3,1,4,1>: Cost 3 vext3 LHS, <1,4,1,5>
  2732966964U, // <3,1,4,2>: Cost 3 vext3 LHS, <1,4,2,5>
  2685633597U, // <3,1,4,3>: Cost 3 vext3 LHS, <1,4,3,5>
  2552237366U, // <3,1,4,4>: Cost 3 vext1 <0,3,1,4>, RHS
  2618805558U, // <3,1,4,5>: Cost 3 vext2 <0,2,3,1>, RHS
  2769472822U, // <3,1,4,6>: Cost 3 vuzpl <3,0,1,2>, RHS
  3667784943U, // <3,1,4,7>: Cost 4 vext1 <7,3,1,4>, <7,3,1,4>
  2685633642U, // <3,1,4,u>: Cost 3 vext3 LHS, <1,4,u,5>
  2689836143U, // <3,1,5,0>: Cost 3 vext3 LHS, <1,5,0,1>
  2564187280U, // <3,1,5,1>: Cost 3 vext1 <2,3,1,5>, <1,5,3,7>
  2564187827U, // <3,1,5,2>: Cost 3 vext1 <2,3,1,5>, <2,3,1,5>
  1611891856U, // <3,1,5,3>: Cost 2 vext3 LHS, <1,5,3,7>
  2689836183U, // <3,1,5,4>: Cost 3 vext3 LHS, <1,5,4,5>
  3759375522U, // <3,1,5,5>: Cost 4 vext3 LHS, <1,5,5,7>
  3720417378U, // <3,1,5,6>: Cost 4 vext2 <4,u,3,1>, <5,6,7,0>
  2832518454U, // <3,1,5,7>: Cost 3 vuzpr <2,3,0,1>, RHS
  1611891901U, // <3,1,5,u>: Cost 2 vext3 LHS, <1,5,u,7>
  3763578048U, // <3,1,6,0>: Cost 4 vext3 LHS, <1,6,0,1>
  2689836239U, // <3,1,6,1>: Cost 3 vext3 LHS, <1,6,1,7>
  2732967128U, // <3,1,6,2>: Cost 3 vext3 LHS, <1,6,2,7>
  2685633761U, // <3,1,6,3>: Cost 3 vext3 LHS, <1,6,3,7>
  3763578088U, // <3,1,6,4>: Cost 4 vext3 LHS, <1,6,4,5>
  2689836275U, // <3,1,6,5>: Cost 3 vext3 LHS, <1,6,5,7>
  3763578108U, // <3,1,6,6>: Cost 4 vext3 LHS, <1,6,6,7>
  2732967166U, // <3,1,6,7>: Cost 3 vext3 LHS, <1,6,7,0>
  2685633806U, // <3,1,6,u>: Cost 3 vext3 LHS, <1,6,u,7>
  3631972454U, // <3,1,7,0>: Cost 4 vext1 <1,3,1,7>, LHS
  2659947612U, // <3,1,7,1>: Cost 3 vext2 <7,1,3,1>, <7,1,3,1>
  4036102294U, // <3,1,7,2>: Cost 4 vzipr <1,5,3,7>, <3,0,1,2>
  3095396454U, // <3,1,7,3>: Cost 3 vtrnr <1,3,5,7>, LHS
  3631975734U, // <3,1,7,4>: Cost 4 vext1 <1,3,1,7>, RHS
  2222982144U, // <3,1,7,5>: Cost 3 vrev <1,3,5,7>
  3296797705U, // <3,1,7,6>: Cost 4 vrev <1,3,6,7>
  3720418924U, // <3,1,7,7>: Cost 4 vext2 <4,u,3,1>, <7,7,7,7>
  3095396459U, // <3,1,7,u>: Cost 3 vtrnr <1,3,5,7>, LHS
  1484496998U, // <3,1,u,0>: Cost 2 vext1 <1,3,1,u>, LHS
  1611892077U, // <3,1,u,1>: Cost 2 vext3 LHS, <1,u,1,3>
  2685633907U, // <3,1,u,2>: Cost 3 vext3 LHS, <1,u,2,0>
  1611892092U, // <3,1,u,3>: Cost 2 vext3 LHS, <1,u,3,0>
  1484500278U, // <3,1,u,4>: Cost 2 vext1 <1,3,1,u>, RHS
  1611892117U, // <3,1,u,5>: Cost 2 vext3 LHS, <1,u,5,7>
  2685633950U, // <3,1,u,6>: Cost 3 vext3 LHS, <1,u,6,7>
  2832518697U, // <3,1,u,7>: Cost 3 vuzpr <2,3,0,1>, RHS
  1611892140U, // <3,1,u,u>: Cost 2 vext3 LHS, <1,u,u,3>
  2623455232U, // <3,2,0,0>: Cost 3 vext2 <1,0,3,2>, <0,0,0,0>
  1549713510U, // <3,2,0,1>: Cost 2 vext2 <1,0,3,2>, LHS
  2689836484U, // <3,2,0,2>: Cost 3 vext3 LHS, <2,0,2,0>
  2685633997U, // <3,2,0,3>: Cost 3 vext3 LHS, <2,0,3,0>
  2623455570U, // <3,2,0,4>: Cost 3 vext2 <1,0,3,2>, <0,4,1,5>
  2732967398U, // <3,2,0,5>: Cost 3 vext3 LHS, <2,0,5,7>
  2689836524U, // <3,2,0,6>: Cost 3 vext3 LHS, <2,0,6,4>
  2229044964U, // <3,2,0,7>: Cost 3 vrev <2,3,7,0>
  1549714077U, // <3,2,0,u>: Cost 2 vext2 <1,0,3,2>, LHS
  1549714166U, // <3,2,1,0>: Cost 2 vext2 <1,0,3,2>, <1,0,3,2>
  2623456052U, // <3,2,1,1>: Cost 3 vext2 <1,0,3,2>, <1,1,1,1>
  2623456150U, // <3,2,1,2>: Cost 3 vext2 <1,0,3,2>, <1,2,3,0>
  2685634079U, // <3,2,1,3>: Cost 3 vext3 LHS, <2,1,3,1>
  2552286518U, // <3,2,1,4>: Cost 3 vext1 <0,3,2,1>, RHS
  2623456400U, // <3,2,1,5>: Cost 3 vext2 <1,0,3,2>, <1,5,3,7>
  2689836604U, // <3,2,1,6>: Cost 3 vext3 LHS, <2,1,6,3>
  3667834101U, // <3,2,1,7>: Cost 4 vext1 <7,3,2,1>, <7,3,2,1>
  1155385070U, // <3,2,1,u>: Cost 2 vrev <2,3,u,1>
  2689836629U, // <3,2,2,0>: Cost 3 vext3 LHS, <2,2,0,1>
  2689836640U, // <3,2,2,1>: Cost 3 vext3 LHS, <2,2,1,3>
  1611449960U, // <3,2,2,2>: Cost 2 vext3 LHS, <2,2,2,2>
  1611892338U, // <3,2,2,3>: Cost 2 vext3 LHS, <2,2,3,3>
  2689836669U, // <3,2,2,4>: Cost 3 vext3 LHS, <2,2,4,5>
  2689836680U, // <3,2,2,5>: Cost 3 vext3 LHS, <2,2,5,7>
  2689836688U, // <3,2,2,6>: Cost 3 vext3 LHS, <2,2,6,6>
  3763578518U, // <3,2,2,7>: Cost 4 vext3 LHS, <2,2,7,3>
  1611892383U, // <3,2,2,u>: Cost 2 vext3 LHS, <2,2,u,3>
  1611450022U, // <3,2,3,0>: Cost 2 vext3 LHS, <2,3,0,1>
  2685191854U, // <3,2,3,1>: Cost 3 vext3 LHS, <2,3,1,0>
  2685191865U, // <3,2,3,2>: Cost 3 vext3 LHS, <2,3,2,2>
  2685191875U, // <3,2,3,3>: Cost 3 vext3 LHS, <2,3,3,3>
  1611450062U, // <3,2,3,4>: Cost 2 vext3 LHS, <2,3,4,5>
  2732967635U, // <3,2,3,5>: Cost 3 vext3 LHS, <2,3,5,1>
  2732967645U, // <3,2,3,6>: Cost 3 vext3 LHS, <2,3,6,2>
  2732967652U, // <3,2,3,7>: Cost 3 vext3 LHS, <2,3,7,0>
  1611450094U, // <3,2,3,u>: Cost 2 vext3 LHS, <2,3,u,1>
  2558279782U, // <3,2,4,0>: Cost 3 vext1 <1,3,2,4>, LHS
  2558280602U, // <3,2,4,1>: Cost 3 vext1 <1,3,2,4>, <1,2,3,4>
  2732967692U, // <3,2,4,2>: Cost 3 vext3 LHS, <2,4,2,4>
  2685634326U, // <3,2,4,3>: Cost 3 vext3 LHS, <2,4,3,5>
  2558283062U, // <3,2,4,4>: Cost 3 vext1 <1,3,2,4>, RHS
  1549716790U, // <3,2,4,5>: Cost 2 vext2 <1,0,3,2>, RHS
  2689836844U, // <3,2,4,6>: Cost 3 vext3 LHS, <2,4,6,0>
  2229077736U, // <3,2,4,7>: Cost 3 vrev <2,3,7,4>
  1549717033U, // <3,2,4,u>: Cost 2 vext2 <1,0,3,2>, RHS
  2552316006U, // <3,2,5,0>: Cost 3 vext1 <0,3,2,5>, LHS
  2228643507U, // <3,2,5,1>: Cost 3 vrev <2,3,1,5>
  2689836896U, // <3,2,5,2>: Cost 3 vext3 LHS, <2,5,2,7>
  2685634408U, // <3,2,5,3>: Cost 3 vext3 LHS, <2,5,3,6>
  1155122894U, // <3,2,5,4>: Cost 2 vrev <2,3,4,5>
  2665263108U, // <3,2,5,5>: Cost 3 vext2 <u,0,3,2>, <5,5,5,5>
  2689836932U, // <3,2,5,6>: Cost 3 vext3 LHS, <2,5,6,7>
  2665263272U, // <3,2,5,7>: Cost 3 vext2 <u,0,3,2>, <5,7,5,7>
  1155417842U, // <3,2,5,u>: Cost 2 vrev <2,3,u,5>
  2689836953U, // <3,2,6,0>: Cost 3 vext3 LHS, <2,6,0,1>
  2689836964U, // <3,2,6,1>: Cost 3 vext3 LHS, <2,6,1,3>
  2689836976U, // <3,2,6,2>: Cost 3 vext3 LHS, <2,6,2,6>
  1611892666U, // <3,2,6,3>: Cost 2 vext3 LHS, <2,6,3,7>
  2689836993U, // <3,2,6,4>: Cost 3 vext3 LHS, <2,6,4,5>
  2689837004U, // <3,2,6,5>: Cost 3 vext3 LHS, <2,6,5,7>
  2689837013U, // <3,2,6,6>: Cost 3 vext3 LHS, <2,6,6,7>
  2665263950U, // <3,2,6,7>: Cost 3 vext2 <u,0,3,2>, <6,7,0,1>
  1611892711U, // <3,2,6,u>: Cost 2 vext3 LHS, <2,6,u,7>
  2665264122U, // <3,2,7,0>: Cost 3 vext2 <u,0,3,2>, <7,0,1,2>
  2623460419U, // <3,2,7,1>: Cost 3 vext2 <1,0,3,2>, <7,1,0,3>
  4169138340U, // <3,2,7,2>: Cost 4 vtrnr <1,3,5,7>, <0,2,0,2>
  2962358374U, // <3,2,7,3>: Cost 3 vzipr <1,5,3,7>, LHS
  2665264486U, // <3,2,7,4>: Cost 3 vext2 <u,0,3,2>, <7,4,5,6>
  2228954841U, // <3,2,7,5>: Cost 3 vrev <2,3,5,7>
  2229028578U, // <3,2,7,6>: Cost 3 vrev <2,3,6,7>
  2665264748U, // <3,2,7,7>: Cost 3 vext2 <u,0,3,2>, <7,7,7,7>
  2962358379U, // <3,2,7,u>: Cost 3 vzipr <1,5,3,7>, LHS
  1611892795U, // <3,2,u,0>: Cost 2 vext3 LHS, <2,u,0,1>
  1549719342U, // <3,2,u,1>: Cost 2 vext2 <1,0,3,2>, LHS
  1611449960U, // <3,2,u,2>: Cost 2 vext3 LHS, <2,2,2,2>
  1611892824U, // <3,2,u,3>: Cost 2 vext3 LHS, <2,u,3,3>
  1611892835U, // <3,2,u,4>: Cost 2 vext3 LHS, <2,u,4,5>
  1549719706U, // <3,2,u,5>: Cost 2 vext2 <1,0,3,2>, RHS
  2689837168U, // <3,2,u,6>: Cost 3 vext3 LHS, <2,u,6,0>
  2665265408U, // <3,2,u,7>: Cost 3 vext2 <u,0,3,2>, <u,7,0,1>
  1611892867U, // <3,2,u,u>: Cost 2 vext3 LHS, <2,u,u,1>
  2685192331U, // <3,3,0,0>: Cost 3 vext3 LHS, <3,0,0,0>
  1611450518U, // <3,3,0,1>: Cost 2 vext3 LHS, <3,0,1,2>
  2685634717U, // <3,3,0,2>: Cost 3 vext3 LHS, <3,0,2,0>
  2564294806U, // <3,3,0,3>: Cost 3 vext1 <2,3,3,0>, <3,0,1,2>
  2685634736U, // <3,3,0,4>: Cost 3 vext3 LHS, <3,0,4,1>
  2732968122U, // <3,3,0,5>: Cost 3 vext3 LHS, <3,0,5,2>
  3763579075U, // <3,3,0,6>: Cost 4 vext3 LHS, <3,0,6,2>
  4034053264U, // <3,3,0,7>: Cost 4 vzipr <1,2,3,0>, <1,5,3,7>
  1611450581U, // <3,3,0,u>: Cost 2 vext3 LHS, <3,0,u,2>
  2685192415U, // <3,3,1,0>: Cost 3 vext3 LHS, <3,1,0,3>
  1550385992U, // <3,3,1,1>: Cost 2 vext2 <1,1,3,3>, <1,1,3,3>
  2685192433U, // <3,3,1,2>: Cost 3 vext3 LHS, <3,1,2,3>
  2685634808U, // <3,3,1,3>: Cost 3 vext3 LHS, <3,1,3,1>
  2558332214U, // <3,3,1,4>: Cost 3 vext1 <1,3,3,1>, RHS
  2685634828U, // <3,3,1,5>: Cost 3 vext3 LHS, <3,1,5,3>
  3759376661U, // <3,3,1,6>: Cost 4 vext3 LHS, <3,1,6,3>
  2703477022U, // <3,3,1,7>: Cost 3 vext3 <3,1,7,3>, <3,1,7,3>
  1555031423U, // <3,3,1,u>: Cost 2 vext2 <1,u,3,3>, <1,u,3,3>
  2564309094U, // <3,3,2,0>: Cost 3 vext1 <2,3,3,2>, LHS
  2630100513U, // <3,3,2,1>: Cost 3 vext2 <2,1,3,3>, <2,1,3,3>
  1557022322U, // <3,3,2,2>: Cost 2 vext2 <2,2,3,3>, <2,2,3,3>
  2685192520U, // <3,3,2,3>: Cost 3 vext3 LHS, <3,2,3,0>
  2564312374U, // <3,3,2,4>: Cost 3 vext1 <2,3,3,2>, RHS
  2732968286U, // <3,3,2,5>: Cost 3 vext3 LHS, <3,2,5,4>
  2685634918U, // <3,3,2,6>: Cost 3 vext3 LHS, <3,2,6,3>
  2704140655U, // <3,3,2,7>: Cost 3 vext3 <3,2,7,3>, <3,2,7,3>
  1561004120U, // <3,3,2,u>: Cost 2 vext2 <2,u,3,3>, <2,u,3,3>
  1496547430U, // <3,3,3,0>: Cost 2 vext1 <3,3,3,3>, LHS
  2624129256U, // <3,3,3,1>: Cost 3 vext2 <1,1,3,3>, <3,1,1,3>
  2630764866U, // <3,3,3,2>: Cost 3 vext2 <2,2,3,3>, <3,2,2,3>
  336380006U, // <3,3,3,3>: Cost 1 vdup3 LHS
  1496550710U, // <3,3,3,4>: Cost 2 vext1 <3,3,3,3>, RHS
  2732968368U, // <3,3,3,5>: Cost 3 vext3 LHS, <3,3,5,5>
  2624129683U, // <3,3,3,6>: Cost 3 vext2 <1,1,3,3>, <3,6,3,7>
  2594182400U, // <3,3,3,7>: Cost 3 vext1 <7,3,3,3>, <7,3,3,3>
  336380006U, // <3,3,3,u>: Cost 1 vdup3 LHS
  2558353510U, // <3,3,4,0>: Cost 3 vext1 <1,3,3,4>, LHS
  2558354411U, // <3,3,4,1>: Cost 3 vext1 <1,3,3,4>, <1,3,3,4>
  2564327108U, // <3,3,4,2>: Cost 3 vext1 <2,3,3,4>, <2,3,3,4>
  2564327938U, // <3,3,4,3>: Cost 3 vext1 <2,3,3,4>, <3,4,5,6>
  2960343962U, // <3,3,4,4>: Cost 3 vzipr <1,2,3,4>, <1,2,3,4>
  1611893250U, // <3,3,4,5>: Cost 2 vext3 LHS, <3,4,5,6>
  2771619126U, // <3,3,4,6>: Cost 3 vuzpl <3,3,3,3>, RHS
  4034086032U, // <3,3,4,7>: Cost 4 vzipr <1,2,3,4>, <1,5,3,7>
  1611893277U, // <3,3,4,u>: Cost 2 vext3 LHS, <3,4,u,6>
  2558361702U, // <3,3,5,0>: Cost 3 vext1 <1,3,3,5>, LHS
  2558362604U, // <3,3,5,1>: Cost 3 vext1 <1,3,3,5>, <1,3,3,5>
  2558363342U, // <3,3,5,2>: Cost 3 vext1 <1,3,3,5>, <2,3,4,5>
  2732968512U, // <3,3,5,3>: Cost 3 vext3 LHS, <3,5,3,5>
  2558364982U, // <3,3,5,4>: Cost 3 vext1 <1,3,3,5>, RHS
  3101279950U, // <3,3,5,5>: Cost 3 vtrnr <2,3,4,5>, <2,3,4,5>
  2665934946U, // <3,3,5,6>: Cost 3 vext2 <u,1,3,3>, <5,6,7,0>
  2826636598U, // <3,3,5,7>: Cost 3 vuzpr <1,3,1,3>, RHS
  2826636599U, // <3,3,5,u>: Cost 3 vuzpr <1,3,1,3>, RHS
  2732968568U, // <3,3,6,0>: Cost 3 vext3 LHS, <3,6,0,7>
  3763579521U, // <3,3,6,1>: Cost 4 vext3 LHS, <3,6,1,7>
  2732968586U, // <3,3,6,2>: Cost 3 vext3 LHS, <3,6,2,7>
  2732968595U, // <3,3,6,3>: Cost 3 vext3 LHS, <3,6,3,7>
  2732968604U, // <3,3,6,4>: Cost 3 vext3 LHS, <3,6,4,7>
  3763579557U, // <3,3,6,5>: Cost 4 vext3 LHS, <3,6,5,7>
  2732968621U, // <3,3,6,6>: Cost 3 vext3 LHS, <3,6,6,6>
  2657973099U, // <3,3,6,7>: Cost 3 vext2 <6,7,3,3>, <6,7,3,3>
  2658636732U, // <3,3,6,u>: Cost 3 vext2 <6,u,3,3>, <6,u,3,3>
  2558378086U, // <3,3,7,0>: Cost 3 vext1 <1,3,3,7>, LHS
  2558378990U, // <3,3,7,1>: Cost 3 vext1 <1,3,3,7>, <1,3,3,7>
  2564351687U, // <3,3,7,2>: Cost 3 vext1 <2,3,3,7>, <2,3,3,7>
  2661291264U, // <3,3,7,3>: Cost 3 vext2 <7,3,3,3>, <7,3,3,3>
  2558381366U, // <3,3,7,4>: Cost 3 vext1 <1,3,3,7>, RHS
  2732968694U, // <3,3,7,5>: Cost 3 vext3 LHS, <3,7,5,7>
  3781126907U, // <3,3,7,6>: Cost 4 vext3 <3,7,6,3>, <3,7,6,3>
  3095397376U, // <3,3,7,7>: Cost 3 vtrnr <1,3,5,7>, <1,3,5,7>
  2558383918U, // <3,3,7,u>: Cost 3 vext1 <1,3,3,7>, LHS
  1496547430U, // <3,3,u,0>: Cost 2 vext1 <3,3,3,3>, LHS
  1611893534U, // <3,3,u,1>: Cost 2 vext3 LHS, <3,u,1,2>
  1592858504U, // <3,3,u,2>: Cost 2 vext2 <u,2,3,3>, <u,2,3,3>
  336380006U, // <3,3,u,3>: Cost 1 vdup3 LHS
  1496550710U, // <3,3,u,4>: Cost 2 vext1 <3,3,3,3>, RHS
  1611893574U, // <3,3,u,5>: Cost 2 vext3 LHS, <3,u,5,6>
  2690280268U, // <3,3,u,6>: Cost 3 vext3 LHS, <3,u,6,3>
  2826636841U, // <3,3,u,7>: Cost 3 vuzpr <1,3,1,3>, RHS
  336380006U, // <3,3,u,u>: Cost 1 vdup3 LHS
  2624798720U, // <3,4,0,0>: Cost 3 vext2 <1,2,3,4>, <0,0,0,0>
  1551056998U, // <3,4,0,1>: Cost 2 vext2 <1,2,3,4>, LHS
  2624798884U, // <3,4,0,2>: Cost 3 vext2 <1,2,3,4>, <0,2,0,2>
  3693232384U, // <3,4,0,3>: Cost 4 vext2 <0,3,3,4>, <0,3,1,4>
  2624799058U, // <3,4,0,4>: Cost 3 vext2 <1,2,3,4>, <0,4,1,5>
  1659227026U, // <3,4,0,5>: Cost 2 vext3 LHS, <4,0,5,1>
  1659227036U, // <3,4,0,6>: Cost 2 vext3 LHS, <4,0,6,2>
  3667973382U, // <3,4,0,7>: Cost 4 vext1 <7,3,4,0>, <7,3,4,0>
  1551057565U, // <3,4,0,u>: Cost 2 vext2 <1,2,3,4>, LHS
  2624799478U, // <3,4,1,0>: Cost 3 vext2 <1,2,3,4>, <1,0,3,2>
  2624799540U, // <3,4,1,1>: Cost 3 vext2 <1,2,3,4>, <1,1,1,1>
  1551057818U, // <3,4,1,2>: Cost 2 vext2 <1,2,3,4>, <1,2,3,4>
  2624799704U, // <3,4,1,3>: Cost 3 vext2 <1,2,3,4>, <1,3,1,3>
  2564377910U, // <3,4,1,4>: Cost 3 vext1 <2,3,4,1>, RHS
  2689838050U, // <3,4,1,5>: Cost 3 vext3 LHS, <4,1,5,0>
  2689838062U, // <3,4,1,6>: Cost 3 vext3 LHS, <4,1,6,3>
  2628117807U, // <3,4,1,7>: Cost 3 vext2 <1,7,3,4>, <1,7,3,4>
  1555039616U, // <3,4,1,u>: Cost 2 vext2 <1,u,3,4>, <1,u,3,4>
  3626180710U, // <3,4,2,0>: Cost 4 vext1 <0,3,4,2>, LHS
  2624800298U, // <3,4,2,1>: Cost 3 vext2 <1,2,3,4>, <2,1,4,3>
  2624800360U, // <3,4,2,2>: Cost 3 vext2 <1,2,3,4>, <2,2,2,2>
  2624800422U, // <3,4,2,3>: Cost 3 vext2 <1,2,3,4>, <2,3,0,1>
  2624800514U, // <3,4,2,4>: Cost 3 vext2 <1,2,3,4>, <2,4,1,3>
  2709965878U, // <3,4,2,5>: Cost 3 vext3 <4,2,5,3>, <4,2,5,3>
  2689838140U, // <3,4,2,6>: Cost 3 vext3 LHS, <4,2,6,0>
  2634090504U, // <3,4,2,7>: Cost 3 vext2 <2,7,3,4>, <2,7,3,4>
  2689838158U, // <3,4,2,u>: Cost 3 vext3 LHS, <4,2,u,0>
  2624800918U, // <3,4,3,0>: Cost 3 vext2 <1,2,3,4>, <3,0,1,2>
  2636081403U, // <3,4,3,1>: Cost 3 vext2 <3,1,3,4>, <3,1,3,4>
  2636745036U, // <3,4,3,2>: Cost 3 vext2 <3,2,3,4>, <3,2,3,4>
  2624801180U, // <3,4,3,3>: Cost 3 vext2 <1,2,3,4>, <3,3,3,3>
  2624801232U, // <3,4,3,4>: Cost 3 vext2 <1,2,3,4>, <3,4,0,1>
  2905836854U, // <3,4,3,5>: Cost 3 vzipl <3,3,3,3>, RHS
  3040054582U, // <3,4,3,6>: Cost 3 vtrnl <3,3,3,3>, RHS
  3702524611U, // <3,4,3,7>: Cost 4 vext2 <1,u,3,4>, <3,7,0,1>
  2624801566U, // <3,4,3,u>: Cost 3 vext2 <1,2,3,4>, <3,u,1,2>
  2564399206U, // <3,4,4,0>: Cost 3 vext1 <2,3,4,4>, LHS
  2564400026U, // <3,4,4,1>: Cost 3 vext1 <2,3,4,4>, <1,2,3,4>
  2564400845U, // <3,4,4,2>: Cost 3 vext1 <2,3,4,4>, <2,3,4,4>
  2570373542U, // <3,4,4,3>: Cost 3 vext1 <3,3,4,4>, <3,3,4,4>
  1659227344U, // <3,4,4,4>: Cost 2 vext3 LHS, <4,4,4,4>
  1551060278U, // <3,4,4,5>: Cost 2 vext2 <1,2,3,4>, RHS
  1659227364U, // <3,4,4,6>: Cost 2 vext3 LHS, <4,4,6,6>
  3668006154U, // <3,4,4,7>: Cost 4 vext1 <7,3,4,4>, <7,3,4,4>
  1551060521U, // <3,4,4,u>: Cost 2 vext2 <1,2,3,4>, RHS
  1490665574U, // <3,4,5,0>: Cost 2 vext1 <2,3,4,5>, LHS
  2689838341U, // <3,4,5,1>: Cost 3 vext3 LHS, <4,5,1,3>
  1490667214U, // <3,4,5,2>: Cost 2 vext1 <2,3,4,5>, <2,3,4,5>
  2564409494U, // <3,4,5,3>: Cost 3 vext1 <2,3,4,5>, <3,0,1,2>
  1490668854U, // <3,4,5,4>: Cost 2 vext1 <2,3,4,5>, RHS
  2689838381U, // <3,4,5,5>: Cost 3 vext3 LHS, <4,5,5,7>
  537709878U, // <3,4,5,6>: Cost 1 vext3 LHS, RHS
  2594272523U, // <3,4,5,7>: Cost 3 vext1 <7,3,4,5>, <7,3,4,5>
  537709896U, // <3,4,5,u>: Cost 1 vext3 LHS, RHS
  2689838411U, // <3,4,6,0>: Cost 3 vext3 LHS, <4,6,0,1>
  2558444534U, // <3,4,6,1>: Cost 3 vext1 <1,3,4,6>, <1,3,4,6>
  2666607098U, // <3,4,6,2>: Cost 3 vext2 <u,2,3,4>, <6,2,7,3>
  2558446082U, // <3,4,6,3>: Cost 3 vext1 <1,3,4,6>, <3,4,5,6>
  1659227508U, // <3,4,6,4>: Cost 2 vext3 LHS, <4,6,4,6>
  2689838462U, // <3,4,6,5>: Cost 3 vext3 LHS, <4,6,5,7>
  2689838471U, // <3,4,6,6>: Cost 3 vext3 LHS, <4,6,6,7>
  2657981292U, // <3,4,6,7>: Cost 3 vext2 <6,7,3,4>, <6,7,3,4>
  1659227540U, // <3,4,6,u>: Cost 2 vext3 LHS, <4,6,u,2>
  2666607610U, // <3,4,7,0>: Cost 3 vext2 <u,2,3,4>, <7,0,1,2>
  3702527072U, // <3,4,7,1>: Cost 4 vext2 <1,u,3,4>, <7,1,3,5>
  2660635824U, // <3,4,7,2>: Cost 3 vext2 <7,2,3,4>, <7,2,3,4>
  3644139945U, // <3,4,7,3>: Cost 4 vext1 <3,3,4,7>, <3,3,4,7>
  2666607974U, // <3,4,7,4>: Cost 3 vext2 <u,2,3,4>, <7,4,5,6>
  2732969416U, // <3,4,7,5>: Cost 3 vext3 LHS, <4,7,5,0>
  2732969425U, // <3,4,7,6>: Cost 3 vext3 LHS, <4,7,6,0>
  2666608236U, // <3,4,7,7>: Cost 3 vext2 <u,2,3,4>, <7,7,7,7>
  2664617622U, // <3,4,7,u>: Cost 3 vext2 <7,u,3,4>, <7,u,3,4>
  1490690150U, // <3,4,u,0>: Cost 2 vext1 <2,3,4,u>, LHS
  1551062830U, // <3,4,u,1>: Cost 2 vext2 <1,2,3,4>, LHS
  1490691793U, // <3,4,u,2>: Cost 2 vext1 <2,3,4,u>, <2,3,4,u>
  2624804796U, // <3,4,u,3>: Cost 3 vext2 <1,2,3,4>, <u,3,0,1>
  1490693430U, // <3,4,u,4>: Cost 2 vext1 <2,3,4,u>, RHS
  1551063194U, // <3,4,u,5>: Cost 2 vext2 <1,2,3,4>, RHS
  537710121U, // <3,4,u,6>: Cost 1 vext3 LHS, RHS
  2594297102U, // <3,4,u,7>: Cost 3 vext1 <7,3,4,u>, <7,3,4,u>
  537710139U, // <3,4,u,u>: Cost 1 vext3 LHS, RHS
  3692576768U, // <3,5,0,0>: Cost 4 vext2 <0,2,3,5>, <0,0,0,0>
  2618835046U, // <3,5,0,1>: Cost 3 vext2 <0,2,3,5>, LHS
  2618835138U, // <3,5,0,2>: Cost 3 vext2 <0,2,3,5>, <0,2,3,5>
  3692577024U, // <3,5,0,3>: Cost 4 vext2 <0,2,3,5>, <0,3,1,4>
  2689838690U, // <3,5,0,4>: Cost 3 vext3 LHS, <5,0,4,1>
  2732969579U, // <3,5,0,5>: Cost 3 vext3 LHS, <5,0,5,1>
  2732969588U, // <3,5,0,6>: Cost 3 vext3 LHS, <5,0,6,1>
  2246963055U, // <3,5,0,7>: Cost 3 vrev <5,3,7,0>
  2618835613U, // <3,5,0,u>: Cost 3 vext2 <0,2,3,5>, LHS
  2594308198U, // <3,5,1,0>: Cost 3 vext1 <7,3,5,1>, LHS
  3692577588U, // <3,5,1,1>: Cost 4 vext2 <0,2,3,5>, <1,1,1,1>
  2624807835U, // <3,5,1,2>: Cost 3 vext2 <1,2,3,5>, <1,2,3,5>
  2625471468U, // <3,5,1,3>: Cost 3 vext2 <1,3,3,5>, <1,3,3,5>
  2626135101U, // <3,5,1,4>: Cost 3 vext2 <1,4,3,5>, <1,4,3,5>
  2594311888U, // <3,5,1,5>: Cost 3 vext1 <7,3,5,1>, <5,1,7,3>
  3699877107U, // <3,5,1,6>: Cost 4 vext2 <1,4,3,5>, <1,6,5,7>
  1641680592U, // <3,5,1,7>: Cost 2 vext3 <5,1,7,3>, <5,1,7,3>
  1641754329U, // <3,5,1,u>: Cost 2 vext3 <5,1,u,3>, <5,1,u,3>
  3692578274U, // <3,5,2,0>: Cost 4 vext2 <0,2,3,5>, <2,0,5,3>
  2630116899U, // <3,5,2,1>: Cost 3 vext2 <2,1,3,5>, <2,1,3,5>
  3692578408U, // <3,5,2,2>: Cost 4 vext2 <0,2,3,5>, <2,2,2,2>
  2625472206U, // <3,5,2,3>: Cost 3 vext2 <1,3,3,5>, <2,3,4,5>
  2632107798U, // <3,5,2,4>: Cost 3 vext2 <2,4,3,5>, <2,4,3,5>
  2715938575U, // <3,5,2,5>: Cost 3 vext3 <5,2,5,3>, <5,2,5,3>
  3692578746U, // <3,5,2,6>: Cost 4 vext2 <0,2,3,5>, <2,6,3,7>
  2716086049U, // <3,5,2,7>: Cost 3 vext3 <5,2,7,3>, <5,2,7,3>
  2634762330U, // <3,5,2,u>: Cost 3 vext2 <2,u,3,5>, <2,u,3,5>
  3692578966U, // <3,5,3,0>: Cost 4 vext2 <0,2,3,5>, <3,0,1,2>
  2636089596U, // <3,5,3,1>: Cost 3 vext2 <3,1,3,5>, <3,1,3,5>
  3699214668U, // <3,5,3,2>: Cost 4 vext2 <1,3,3,5>, <3,2,3,4>
  2638080412U, // <3,5,3,3>: Cost 3 vext2 <3,4,3,5>, <3,3,3,3>
  2618837506U, // <3,5,3,4>: Cost 3 vext2 <0,2,3,5>, <3,4,5,6>
  2832844494U, // <3,5,3,5>: Cost 3 vuzpr <2,3,4,5>, <2,3,4,5>
  4033415682U, // <3,5,3,6>: Cost 4 vzipr <1,1,3,3>, <3,4,5,6>
  3095072054U, // <3,5,3,7>: Cost 3 vtrnr <1,3,1,3>, RHS
  3095072055U, // <3,5,3,u>: Cost 3 vtrnr <1,3,1,3>, RHS
  2600304742U, // <3,5,4,0>: Cost 3 vext1 <u,3,5,4>, LHS
  3763580815U, // <3,5,4,1>: Cost 4 vext3 LHS, <5,4,1,5>
  2564474582U, // <3,5,4,2>: Cost 3 vext1 <2,3,5,4>, <2,3,5,4>
  3699879044U, // <3,5,4,3>: Cost 4 vext2 <1,4,3,5>, <4,3,5,0>
  2600308022U, // <3,5,4,4>: Cost 3 vext1 <u,3,5,4>, RHS
  2618838326U, // <3,5,4,5>: Cost 3 vext2 <0,2,3,5>, RHS
  2772454710U, // <3,5,4,6>: Cost 3 vuzpl <3,4,5,6>, RHS
  1659228102U, // <3,5,4,7>: Cost 2 vext3 LHS, <5,4,7,6>
  1659228111U, // <3,5,4,u>: Cost 2 vext3 LHS, <5,4,u,6>
  2570453094U, // <3,5,5,0>: Cost 3 vext1 <3,3,5,5>, LHS
  2624810704U, // <3,5,5,1>: Cost 3 vext2 <1,2,3,5>, <5,1,7,3>
  2570454734U, // <3,5,5,2>: Cost 3 vext1 <3,3,5,5>, <2,3,4,5>
  2570455472U, // <3,5,5,3>: Cost 3 vext1 <3,3,5,5>, <3,3,5,5>
  2570456374U, // <3,5,5,4>: Cost 3 vext1 <3,3,5,5>, RHS
  1659228164U, // <3,5,5,5>: Cost 2 vext3 LHS, <5,5,5,5>
  2732969998U, // <3,5,5,6>: Cost 3 vext3 LHS, <5,5,6,6>
  1659228184U, // <3,5,5,7>: Cost 2 vext3 LHS, <5,5,7,7>
  1659228193U, // <3,5,5,u>: Cost 2 vext3 LHS, <5,5,u,7>
  2732970020U, // <3,5,6,0>: Cost 3 vext3 LHS, <5,6,0,1>
  2732970035U, // <3,5,6,1>: Cost 3 vext3 LHS, <5,6,1,7>
  2564490968U, // <3,5,6,2>: Cost 3 vext1 <2,3,5,6>, <2,3,5,6>
  2732970050U, // <3,5,6,3>: Cost 3 vext3 LHS, <5,6,3,4>
  2732970060U, // <3,5,6,4>: Cost 3 vext3 LHS, <5,6,4,5>
  2732970071U, // <3,5,6,5>: Cost 3 vext3 LHS, <5,6,5,7>
  2732970080U, // <3,5,6,6>: Cost 3 vext3 LHS, <5,6,6,7>
  1659228258U, // <3,5,6,7>: Cost 2 vext3 LHS, <5,6,7,0>
  1659228267U, // <3,5,6,u>: Cost 2 vext3 LHS, <5,6,u,0>
  1484783718U, // <3,5,7,0>: Cost 2 vext1 <1,3,5,7>, LHS
  1484784640U, // <3,5,7,1>: Cost 2 vext1 <1,3,5,7>, <1,3,5,7>
  2558527080U, // <3,5,7,2>: Cost 3 vext1 <1,3,5,7>, <2,2,2,2>
  2558527638U, // <3,5,7,3>: Cost 3 vext1 <1,3,5,7>, <3,0,1,2>
  1484786998U, // <3,5,7,4>: Cost 2 vext1 <1,3,5,7>, RHS
  1659228328U, // <3,5,7,5>: Cost 2 vext3 LHS, <5,7,5,7>
  2732970154U, // <3,5,7,6>: Cost 3 vext3 LHS, <5,7,6,0>
  2558531180U, // <3,5,7,7>: Cost 3 vext1 <1,3,5,7>, <7,7,7,7>
  1484789550U, // <3,5,7,u>: Cost 2 vext1 <1,3,5,7>, LHS
  1484791910U, // <3,5,u,0>: Cost 2 vext1 <1,3,5,u>, LHS
  1484792833U, // <3,5,u,1>: Cost 2 vext1 <1,3,5,u>, <1,3,5,u>
  2558535272U, // <3,5,u,2>: Cost 3 vext1 <1,3,5,u>, <2,2,2,2>
  2558535830U, // <3,5,u,3>: Cost 3 vext1 <1,3,5,u>, <3,0,1,2>
  1484795190U, // <3,5,u,4>: Cost 2 vext1 <1,3,5,u>, RHS
  1659228409U, // <3,5,u,5>: Cost 2 vext3 LHS, <5,u,5,7>
  2772457626U, // <3,5,u,6>: Cost 3 vuzpl <3,4,5,6>, RHS
  1646326023U, // <3,5,u,7>: Cost 2 vext3 <5,u,7,3>, <5,u,7,3>
  1484797742U, // <3,5,u,u>: Cost 2 vext1 <1,3,5,u>, LHS
  2558541926U, // <3,6,0,0>: Cost 3 vext1 <1,3,6,0>, LHS
  2689839393U, // <3,6,0,1>: Cost 3 vext3 LHS, <6,0,1,2>
  2689839404U, // <3,6,0,2>: Cost 3 vext3 LHS, <6,0,2,4>
  3706519808U, // <3,6,0,3>: Cost 4 vext2 <2,5,3,6>, <0,3,1,4>
  2689839420U, // <3,6,0,4>: Cost 3 vext3 LHS, <6,0,4,2>
  2732970314U, // <3,6,0,5>: Cost 3 vext3 LHS, <6,0,5,7>
  2732970316U, // <3,6,0,6>: Cost 3 vext3 LHS, <6,0,6,0>
  2960313654U, // <3,6,0,7>: Cost 3 vzipr <1,2,3,0>, RHS
  2689839456U, // <3,6,0,u>: Cost 3 vext3 LHS, <6,0,u,2>
  3763581290U, // <3,6,1,0>: Cost 4 vext3 LHS, <6,1,0,3>
  3763581297U, // <3,6,1,1>: Cost 4 vext3 LHS, <6,1,1,1>
  2624816028U, // <3,6,1,2>: Cost 3 vext2 <1,2,3,6>, <1,2,3,6>
  3763581315U, // <3,6,1,3>: Cost 4 vext3 LHS, <6,1,3,1>
  2626143294U, // <3,6,1,4>: Cost 3 vext2 <1,4,3,6>, <1,4,3,6>
  3763581335U, // <3,6,1,5>: Cost 4 vext3 LHS, <6,1,5,3>
  2721321376U, // <3,6,1,6>: Cost 3 vext3 <6,1,6,3>, <6,1,6,3>
  2721395113U, // <3,6,1,7>: Cost 3 vext3 <6,1,7,3>, <6,1,7,3>
  2628797826U, // <3,6,1,u>: Cost 3 vext2 <1,u,3,6>, <1,u,3,6>
  2594390118U, // <3,6,2,0>: Cost 3 vext1 <7,3,6,2>, LHS
  2721616324U, // <3,6,2,1>: Cost 3 vext3 <6,2,1,3>, <6,2,1,3>
  2630788725U, // <3,6,2,2>: Cost 3 vext2 <2,2,3,6>, <2,2,3,6>
  3763581395U, // <3,6,2,3>: Cost 4 vext3 LHS, <6,2,3,0>
  2632115991U, // <3,6,2,4>: Cost 3 vext2 <2,4,3,6>, <2,4,3,6>
  2632779624U, // <3,6,2,5>: Cost 3 vext2 <2,5,3,6>, <2,5,3,6>
  2594394618U, // <3,6,2,6>: Cost 3 vext1 <7,3,6,2>, <6,2,7,3>
  1648316922U, // <3,6,2,7>: Cost 2 vext3 <6,2,7,3>, <6,2,7,3>
  1648390659U, // <3,6,2,u>: Cost 2 vext3 <6,2,u,3>, <6,2,u,3>
  3693914262U, // <3,6,3,0>: Cost 4 vext2 <0,4,3,6>, <3,0,1,2>
  3638281176U, // <3,6,3,1>: Cost 4 vext1 <2,3,6,3>, <1,3,1,3>
  3696568678U, // <3,6,3,2>: Cost 4 vext2 <0,u,3,6>, <3,2,6,3>
  2638088604U, // <3,6,3,3>: Cost 3 vext2 <3,4,3,6>, <3,3,3,3>
  2632780290U, // <3,6,3,4>: Cost 3 vext2 <2,5,3,6>, <3,4,5,6>
  3712494145U, // <3,6,3,5>: Cost 4 vext2 <3,5,3,6>, <3,5,3,6>
  3698559612U, // <3,6,3,6>: Cost 4 vext2 <1,2,3,6>, <3,6,1,2>
  2959674678U, // <3,6,3,7>: Cost 3 vzipr <1,1,3,3>, RHS
  2959674679U, // <3,6,3,u>: Cost 3 vzipr <1,1,3,3>, RHS
  3763581536U, // <3,6,4,0>: Cost 4 vext3 LHS, <6,4,0,6>
  2722943590U, // <3,6,4,1>: Cost 3 vext3 <6,4,1,3>, <6,4,1,3>
  2732970609U, // <3,6,4,2>: Cost 3 vext3 LHS, <6,4,2,5>
  3698560147U, // <3,6,4,3>: Cost 4 vext2 <1,2,3,6>, <4,3,6,6>
  2732970628U, // <3,6,4,4>: Cost 3 vext3 LHS, <6,4,4,6>
  2689839757U, // <3,6,4,5>: Cost 3 vext3 LHS, <6,4,5,6>
  2732970640U, // <3,6,4,6>: Cost 3 vext3 LHS, <6,4,6,0>
  2960346422U, // <3,6,4,7>: Cost 3 vzipr <1,2,3,4>, RHS
  2689839784U, // <3,6,4,u>: Cost 3 vext3 LHS, <6,4,u,6>
  2576498790U, // <3,6,5,0>: Cost 3 vext1 <4,3,6,5>, LHS
  3650241270U, // <3,6,5,1>: Cost 4 vext1 <4,3,6,5>, <1,0,3,2>
  2732970692U, // <3,6,5,2>: Cost 3 vext3 LHS, <6,5,2,7>
  2576501250U, // <3,6,5,3>: Cost 3 vext1 <4,3,6,5>, <3,4,5,6>
  2576501906U, // <3,6,5,4>: Cost 3 vext1 <4,3,6,5>, <4,3,6,5>
  3650244622U, // <3,6,5,5>: Cost 4 vext1 <4,3,6,5>, <5,5,6,6>
  4114633528U, // <3,6,5,6>: Cost 4 vtrnl <3,4,5,6>, <6,6,6,6>
  2732970735U, // <3,6,5,7>: Cost 3 vext3 LHS, <6,5,7,5>
  2576504622U, // <3,6,5,u>: Cost 3 vext1 <4,3,6,5>, LHS
  2732970749U, // <3,6,6,0>: Cost 3 vext3 LHS, <6,6,0,1>
  2724270856U, // <3,6,6,1>: Cost 3 vext3 <6,6,1,3>, <6,6,1,3>
  2624819706U, // <3,6,6,2>: Cost 3 vext2 <1,2,3,6>, <6,2,7,3>
  3656223234U, // <3,6,6,3>: Cost 4 vext1 <5,3,6,6>, <3,4,5,6>
  2732970788U, // <3,6,6,4>: Cost 3 vext3 LHS, <6,6,4,4>
  2732970800U, // <3,6,6,5>: Cost 3 vext3 LHS, <6,6,5,7>
  1659228984U, // <3,6,6,6>: Cost 2 vext3 LHS, <6,6,6,6>
  1659228994U, // <3,6,6,7>: Cost 2 vext3 LHS, <6,6,7,7>
  1659229003U, // <3,6,6,u>: Cost 2 vext3 LHS, <6,6,u,7>
  1659229006U, // <3,6,7,0>: Cost 2 vext3 LHS, <6,7,0,1>
  2558600201U, // <3,6,7,1>: Cost 3 vext1 <1,3,6,7>, <1,3,6,7>
  2558601146U, // <3,6,7,2>: Cost 3 vext1 <1,3,6,7>, <2,6,3,7>
  2725081963U, // <3,6,7,3>: Cost 3 vext3 <6,7,3,3>, <6,7,3,3>
  1659229046U, // <3,6,7,4>: Cost 2 vext3 LHS, <6,7,4,5>
  2715423611U, // <3,6,7,5>: Cost 3 vext3 <5,1,7,3>, <6,7,5,1>
  2722059141U, // <3,6,7,6>: Cost 3 vext3 <6,2,7,3>, <6,7,6,2>
  2962361654U, // <3,6,7,7>: Cost 3 vzipr <1,5,3,7>, RHS
  1659229078U, // <3,6,7,u>: Cost 2 vext3 LHS, <6,7,u,1>
  1659229087U, // <3,6,u,0>: Cost 2 vext3 LHS, <6,u,0,1>
  2689840041U, // <3,6,u,1>: Cost 3 vext3 LHS, <6,u,1,2>
  2558609339U, // <3,6,u,2>: Cost 3 vext1 <1,3,6,u>, <2,6,3,u>
  2576525853U, // <3,6,u,3>: Cost 3 vext1 <4,3,6,u>, <3,4,u,6>
  1659229127U, // <3,6,u,4>: Cost 2 vext3 LHS, <6,u,4,5>
  2689840081U, // <3,6,u,5>: Cost 3 vext3 LHS, <6,u,5,6>
  1659228984U, // <3,6,u,6>: Cost 2 vext3 LHS, <6,6,6,6>
  1652298720U, // <3,6,u,7>: Cost 2 vext3 <6,u,7,3>, <6,u,7,3>
  1659229159U, // <3,6,u,u>: Cost 2 vext3 LHS, <6,u,u,1>
  2626813952U, // <3,7,0,0>: Cost 3 vext2 <1,5,3,7>, <0,0,0,0>
  1553072230U, // <3,7,0,1>: Cost 2 vext2 <1,5,3,7>, LHS
  2626814116U, // <3,7,0,2>: Cost 3 vext2 <1,5,3,7>, <0,2,0,2>
  3700556028U, // <3,7,0,3>: Cost 4 vext2 <1,5,3,7>, <0,3,1,0>
  2626814290U, // <3,7,0,4>: Cost 3 vext2 <1,5,3,7>, <0,4,1,5>
  2582507375U, // <3,7,0,5>: Cost 3 vext1 <5,3,7,0>, <5,3,7,0>
  2588480072U, // <3,7,0,6>: Cost 3 vext1 <6,3,7,0>, <6,3,7,0>
  2732971055U, // <3,7,0,7>: Cost 3 vext3 LHS, <7,0,7,1>
  1553072797U, // <3,7,0,u>: Cost 2 vext2 <1,5,3,7>, LHS
  2626814710U, // <3,7,1,0>: Cost 3 vext2 <1,5,3,7>, <1,0,3,2>
  2626814772U, // <3,7,1,1>: Cost 3 vext2 <1,5,3,7>, <1,1,1,1>
  2626814870U, // <3,7,1,2>: Cost 3 vext2 <1,5,3,7>, <1,2,3,0>
  2625487854U, // <3,7,1,3>: Cost 3 vext2 <1,3,3,7>, <1,3,3,7>
  2582514998U, // <3,7,1,4>: Cost 3 vext1 <5,3,7,1>, RHS
  1553073296U, // <3,7,1,5>: Cost 2 vext2 <1,5,3,7>, <1,5,3,7>
  2627478753U, // <3,7,1,6>: Cost 3 vext2 <1,6,3,7>, <1,6,3,7>
  2727367810U, // <3,7,1,7>: Cost 3 vext3 <7,1,7,3>, <7,1,7,3>
  1555064195U, // <3,7,1,u>: Cost 2 vext2 <1,u,3,7>, <1,u,3,7>
  2588491878U, // <3,7,2,0>: Cost 3 vext1 <6,3,7,2>, LHS
  3700557318U, // <3,7,2,1>: Cost 4 vext2 <1,5,3,7>, <2,1,0,3>
  2626815592U, // <3,7,2,2>: Cost 3 vext2 <1,5,3,7>, <2,2,2,2>
  2626815654U, // <3,7,2,3>: Cost 3 vext2 <1,5,3,7>, <2,3,0,1>
  2588495158U, // <3,7,2,4>: Cost 3 vext1 <6,3,7,2>, RHS
  2632787817U, // <3,7,2,5>: Cost 3 vext2 <2,5,3,7>, <2,5,3,7>
  1559709626U, // <3,7,2,6>: Cost 2 vext2 <2,6,3,7>, <2,6,3,7>
  2728031443U, // <3,7,2,7>: Cost 3 vext3 <7,2,7,3>, <7,2,7,3>
  1561036892U, // <3,7,2,u>: Cost 2 vext2 <2,u,3,7>, <2,u,3,7>
  2626816150U, // <3,7,3,0>: Cost 3 vext2 <1,5,3,7>, <3,0,1,2>
  2626816268U, // <3,7,3,1>: Cost 3 vext2 <1,5,3,7>, <3,1,5,3>
  2633451878U, // <3,7,3,2>: Cost 3 vext2 <2,6,3,7>, <3,2,6,3>
  2626816412U, // <3,7,3,3>: Cost 3 vext2 <1,5,3,7>, <3,3,3,3>
  2626816514U, // <3,7,3,4>: Cost 3 vext2 <1,5,3,7>, <3,4,5,6>
  2638760514U, // <3,7,3,5>: Cost 3 vext2 <3,5,3,7>, <3,5,3,7>
  2639424147U, // <3,7,3,6>: Cost 3 vext2 <3,6,3,7>, <3,6,3,7>
  2826961920U, // <3,7,3,7>: Cost 3 vuzpr <1,3,5,7>, <1,3,5,7>
  2626816798U, // <3,7,3,u>: Cost 3 vext2 <1,5,3,7>, <3,u,1,2>
  2582536294U, // <3,7,4,0>: Cost 3 vext1 <5,3,7,4>, LHS
  2582537360U, // <3,7,4,1>: Cost 3 vext1 <5,3,7,4>, <1,5,3,7>
  2588510138U, // <3,7,4,2>: Cost 3 vext1 <6,3,7,4>, <2,6,3,7>
  3700558996U, // <3,7,4,3>: Cost 4 vext2 <1,5,3,7>, <4,3,6,7>
  2582539574U, // <3,7,4,4>: Cost 3 vext1 <5,3,7,4>, RHS
  1553075510U, // <3,7,4,5>: Cost 2 vext2 <1,5,3,7>, RHS
  2588512844U, // <3,7,4,6>: Cost 3 vext1 <6,3,7,4>, <6,3,7,4>
  2564625766U, // <3,7,4,7>: Cost 3 vext1 <2,3,7,4>, <7,4,5,6>
  1553075753U, // <3,7,4,u>: Cost 2 vext2 <1,5,3,7>, RHS
  2732971398U, // <3,7,5,0>: Cost 3 vext3 LHS, <7,5,0,2>
  2626817744U, // <3,7,5,1>: Cost 3 vext2 <1,5,3,7>, <5,1,7,3>
  3700559649U, // <3,7,5,2>: Cost 4 vext2 <1,5,3,7>, <5,2,7,3>
  2626817903U, // <3,7,5,3>: Cost 3 vext2 <1,5,3,7>, <5,3,7,0>
  2258728203U, // <3,7,5,4>: Cost 3 vrev <7,3,4,5>
  2732971446U, // <3,7,5,5>: Cost 3 vext3 LHS, <7,5,5,5>
  2732971457U, // <3,7,5,6>: Cost 3 vext3 LHS, <7,5,6,7>
  2826964278U, // <3,7,5,7>: Cost 3 vuzpr <1,3,5,7>, RHS
  2826964279U, // <3,7,5,u>: Cost 3 vuzpr <1,3,5,7>, RHS
  2732971478U, // <3,7,6,0>: Cost 3 vext3 LHS, <7,6,0,1>
  2732971486U, // <3,7,6,1>: Cost 3 vext3 LHS, <7,6,1,0>
  2633454074U, // <3,7,6,2>: Cost 3 vext2 <2,6,3,7>, <6,2,7,3>
  2633454152U, // <3,7,6,3>: Cost 3 vext2 <2,6,3,7>, <6,3,7,0>
  2732971518U, // <3,7,6,4>: Cost 3 vext3 LHS, <7,6,4,5>
  2732971526U, // <3,7,6,5>: Cost 3 vext3 LHS, <7,6,5,4>
  2732971537U, // <3,7,6,6>: Cost 3 vext3 LHS, <7,6,6,6>
  2732971540U, // <3,7,6,7>: Cost 3 vext3 LHS, <7,6,7,0>
  2726041124U, // <3,7,6,u>: Cost 3 vext3 <6,u,7,3>, <7,6,u,7>
  2570616934U, // <3,7,7,0>: Cost 3 vext1 <3,3,7,7>, LHS
  2570617856U, // <3,7,7,1>: Cost 3 vext1 <3,3,7,7>, <1,3,5,7>
  2564646635U, // <3,7,7,2>: Cost 3 vext1 <2,3,7,7>, <2,3,7,7>
  2570619332U, // <3,7,7,3>: Cost 3 vext1 <3,3,7,7>, <3,3,7,7>
  2570620214U, // <3,7,7,4>: Cost 3 vext1 <3,3,7,7>, RHS
  2582564726U, // <3,7,7,5>: Cost 3 vext1 <5,3,7,7>, <5,3,7,7>
  2588537423U, // <3,7,7,6>: Cost 3 vext1 <6,3,7,7>, <6,3,7,7>
  1659229804U, // <3,7,7,7>: Cost 2 vext3 LHS, <7,7,7,7>
  1659229804U, // <3,7,7,u>: Cost 2 vext3 LHS, <7,7,7,7>
  2626819795U, // <3,7,u,0>: Cost 3 vext2 <1,5,3,7>, <u,0,1,2>
  1553078062U, // <3,7,u,1>: Cost 2 vext2 <1,5,3,7>, LHS
  2626819973U, // <3,7,u,2>: Cost 3 vext2 <1,5,3,7>, <u,2,3,0>
  2826961565U, // <3,7,u,3>: Cost 3 vuzpr <1,3,5,7>, LHS
  2626820159U, // <3,7,u,4>: Cost 3 vext2 <1,5,3,7>, <u,4,5,6>
  1553078426U, // <3,7,u,5>: Cost 2 vext2 <1,5,3,7>, RHS
  1595545808U, // <3,7,u,6>: Cost 2 vext2 <u,6,3,7>, <u,6,3,7>
  1659229804U, // <3,7,u,7>: Cost 2 vext3 LHS, <7,7,7,7>
  1553078629U, // <3,7,u,u>: Cost 2 vext2 <1,5,3,7>, LHS
  1611448320U, // <3,u,0,0>: Cost 2 vext3 LHS, <0,0,0,0>
  1611896531U, // <3,u,0,1>: Cost 2 vext3 LHS, <u,0,1,2>
  1659672284U, // <3,u,0,2>: Cost 2 vext3 LHS, <u,0,2,2>
  1616099045U, // <3,u,0,3>: Cost 2 vext3 LHS, <u,0,3,2>
  2685638381U, // <3,u,0,4>: Cost 3 vext3 LHS, <u,0,4,1>
  1663874806U, // <3,u,0,5>: Cost 2 vext3 LHS, <u,0,5,1>
  1663874816U, // <3,u,0,6>: Cost 2 vext3 LHS, <u,0,6,2>
  2960313672U, // <3,u,0,7>: Cost 3 vzipr <1,2,3,0>, RHS
  1611896594U, // <3,u,0,u>: Cost 2 vext3 LHS, <u,0,u,2>
  1549763324U, // <3,u,1,0>: Cost 2 vext2 <1,0,3,u>, <1,0,3,u>
  1550426957U, // <3,u,1,1>: Cost 2 vext2 <1,1,3,u>, <1,1,3,u>
  537712430U, // <3,u,1,2>: Cost 1 vext3 LHS, LHS
  1616541495U, // <3,u,1,3>: Cost 2 vext3 LHS, <u,1,3,3>
  1490930998U, // <3,u,1,4>: Cost 2 vext1 <2,3,u,1>, RHS
  1553081489U, // <3,u,1,5>: Cost 2 vext2 <1,5,3,u>, <1,5,3,u>
  2627486946U, // <3,u,1,6>: Cost 3 vext2 <1,6,3,u>, <1,6,3,u>
  1659230043U, // <3,u,1,7>: Cost 2 vext3 LHS, <u,1,7,3>
  537712484U, // <3,u,1,u>: Cost 1 vext3 LHS, LHS
  1611890852U, // <3,u,2,0>: Cost 2 vext3 LHS, <0,2,0,2>
  2624833102U, // <3,u,2,1>: Cost 3 vext2 <1,2,3,u>, <2,1,u,3>
  1557063287U, // <3,u,2,2>: Cost 2 vext2 <2,2,3,u>, <2,2,3,u>
  1616099205U, // <3,u,2,3>: Cost 2 vext3 LHS, <u,2,3,0>
  1611890892U, // <3,u,2,4>: Cost 2 vext3 LHS, <0,2,4,6>
  2689841054U, // <3,u,2,5>: Cost 3 vext3 LHS, <u,2,5,7>
  1559717819U, // <3,u,2,6>: Cost 2 vext2 <2,6,3,u>, <2,6,3,u>
  1659230124U, // <3,u,2,7>: Cost 2 vext3 LHS, <u,2,7,3>
  1616541618U, // <3,u,2,u>: Cost 2 vext3 LHS, <u,2,u,0>
  1611896764U, // <3,u,3,0>: Cost 2 vext3 LHS, <u,3,0,1>
  1484973079U, // <3,u,3,1>: Cost 2 vext1 <1,3,u,3>, <1,3,u,3>
  2685638607U, // <3,u,3,2>: Cost 3 vext3 LHS, <u,3,2,2>
  336380006U, // <3,u,3,3>: Cost 1 vdup3 LHS
  1611896804U, // <3,u,3,4>: Cost 2 vext3 LHS, <u,3,4,5>
  1616541679U, // <3,u,3,5>: Cost 2 vext3 LHS, <u,3,5,7>
  2690283512U, // <3,u,3,6>: Cost 3 vext3 LHS, <u,3,6,7>
  2959674696U, // <3,u,3,7>: Cost 3 vzipr <1,1,3,3>, RHS
  336380006U, // <3,u,3,u>: Cost 1 vdup3 LHS
  2558722150U, // <3,u,4,0>: Cost 3 vext1 <1,3,u,4>, LHS
  1659672602U, // <3,u,4,1>: Cost 2 vext3 LHS, <u,4,1,5>
  1659672612U, // <3,u,4,2>: Cost 2 vext3 LHS, <u,4,2,6>
  2689841196U, // <3,u,4,3>: Cost 3 vext3 LHS, <u,4,3,5>
  1659227344U, // <3,u,4,4>: Cost 2 vext3 LHS, <4,4,4,4>
  1611896895U, // <3,u,4,5>: Cost 2 vext3 LHS, <u,4,5,6>
  1663875144U, // <3,u,4,6>: Cost 2 vext3 LHS, <u,4,6,6>
  1659230289U, // <3,u,4,7>: Cost 2 vext3 LHS, <u,4,7,6>
  1611896922U, // <3,u,4,u>: Cost 2 vext3 LHS, <u,4,u,6>
  1490960486U, // <3,u,5,0>: Cost 2 vext1 <2,3,u,5>, LHS
  2689841261U, // <3,u,5,1>: Cost 3 vext3 LHS, <u,5,1,7>
  1490962162U, // <3,u,5,2>: Cost 2 vext1 <2,3,u,5>, <2,3,u,5>
  1616541823U, // <3,u,5,3>: Cost 2 vext3 LHS, <u,5,3,7>
  1490963766U, // <3,u,5,4>: Cost 2 vext1 <2,3,u,5>, RHS
  1659228164U, // <3,u,5,5>: Cost 2 vext3 LHS, <5,5,5,5>
  537712794U, // <3,u,5,6>: Cost 1 vext3 LHS, RHS
  1659230371U, // <3,u,5,7>: Cost 2 vext3 LHS, <u,5,7,7>
  537712812U, // <3,u,5,u>: Cost 1 vext3 LHS, RHS
  2689841327U, // <3,u,6,0>: Cost 3 vext3 LHS, <u,6,0,1>
  2558739482U, // <3,u,6,1>: Cost 3 vext1 <1,3,u,6>, <1,3,u,6>
  2689841351U, // <3,u,6,2>: Cost 3 vext3 LHS, <u,6,2,7>
  1616099536U, // <3,u,6,3>: Cost 2 vext3 LHS, <u,6,3,7>
  1659227508U, // <3,u,6,4>: Cost 2 vext3 LHS, <4,6,4,6>
  2690283746U, // <3,u,6,5>: Cost 3 vext3 LHS, <u,6,5,7>
  1659228984U, // <3,u,6,6>: Cost 2 vext3 LHS, <6,6,6,6>
  1659230445U, // <3,u,6,7>: Cost 2 vext3 LHS, <u,6,7,0>
  1616099581U, // <3,u,6,u>: Cost 2 vext3 LHS, <u,6,u,7>
  1485004902U, // <3,u,7,0>: Cost 2 vext1 <1,3,u,7>, LHS
  1485005851U, // <3,u,7,1>: Cost 2 vext1 <1,3,u,7>, <1,3,u,7>
  2558748264U, // <3,u,7,2>: Cost 3 vext1 <1,3,u,7>, <2,2,2,2>
  3095397021U, // <3,u,7,3>: Cost 3 vtrnr <1,3,5,7>, LHS
  1485008182U, // <3,u,7,4>: Cost 2 vext1 <1,3,u,7>, RHS
  1659228328U, // <3,u,7,5>: Cost 2 vext3 LHS, <5,7,5,7>
  2722060599U, // <3,u,7,6>: Cost 3 vext3 <6,2,7,3>, <u,7,6,2>
  1659229804U, // <3,u,7,7>: Cost 2 vext3 LHS, <7,7,7,7>
  1485010734U, // <3,u,7,u>: Cost 2 vext1 <1,3,u,7>, LHS
  1616099665U, // <3,u,u,0>: Cost 2 vext3 LHS, <u,u,0,1>
  1611897179U, // <3,u,u,1>: Cost 2 vext3 LHS, <u,u,1,2>
  537712997U, // <3,u,u,2>: Cost 1 vext3 LHS, LHS
  336380006U, // <3,u,u,3>: Cost 1 vdup3 LHS
  1616099705U, // <3,u,u,4>: Cost 2 vext3 LHS, <u,u,4,5>
  1611897219U, // <3,u,u,5>: Cost 2 vext3 LHS, <u,u,5,6>
  537713037U, // <3,u,u,6>: Cost 1 vext3 LHS, RHS
  1659230607U, // <3,u,u,7>: Cost 2 vext3 LHS, <u,u,7,0>
  537713051U, // <3,u,u,u>: Cost 1 vext3 LHS, LHS
  2691907584U, // <4,0,0,0>: Cost 3 vext3 <1,2,3,4>, <0,0,0,0>
  2691907594U, // <4,0,0,1>: Cost 3 vext3 <1,2,3,4>, <0,0,1,1>
  2691907604U, // <4,0,0,2>: Cost 3 vext3 <1,2,3,4>, <0,0,2,2>
  3709862144U, // <4,0,0,3>: Cost 4 vext2 <3,1,4,0>, <0,3,1,4>
  2684682280U, // <4,0,0,4>: Cost 3 vext3 <0,0,4,4>, <0,0,4,4>
  3694600633U, // <4,0,0,5>: Cost 4 vext2 <0,5,4,0>, <0,5,4,0>
  3291431290U, // <4,0,0,6>: Cost 4 vrev <0,4,6,0>
  3668342067U, // <4,0,0,7>: Cost 4 vext1 <7,4,0,0>, <7,4,0,0>
  2691907657U, // <4,0,0,u>: Cost 3 vext3 <1,2,3,4>, <0,0,u,1>
  2570715238U, // <4,0,1,0>: Cost 3 vext1 <3,4,0,1>, LHS
  2570716058U, // <4,0,1,1>: Cost 3 vext1 <3,4,0,1>, <1,2,3,4>
  1618165862U, // <4,0,1,2>: Cost 2 vext3 <1,2,3,4>, LHS
  2570717648U, // <4,0,1,3>: Cost 3 vext1 <3,4,0,1>, <3,4,0,1>
  2570718518U, // <4,0,1,4>: Cost 3 vext1 <3,4,0,1>, RHS
  2594607206U, // <4,0,1,5>: Cost 3 vext1 <7,4,0,1>, <5,6,7,4>
  3662377563U, // <4,0,1,6>: Cost 4 vext1 <6,4,0,1>, <6,4,0,1>
  2594608436U, // <4,0,1,7>: Cost 3 vext1 <7,4,0,1>, <7,4,0,1>
  1618165916U, // <4,0,1,u>: Cost 2 vext3 <1,2,3,4>, LHS
  2685714598U, // <4,0,2,0>: Cost 3 vext3 <0,2,0,4>, <0,2,0,4>
  3759530159U, // <4,0,2,1>: Cost 4 vext3 <0,2,1,4>, <0,2,1,4>
  2685862072U, // <4,0,2,2>: Cost 3 vext3 <0,2,2,4>, <0,2,2,4>
  2631476937U, // <4,0,2,3>: Cost 3 vext2 <2,3,4,0>, <2,3,4,0>
  2685714636U, // <4,0,2,4>: Cost 3 vext3 <0,2,0,4>, <0,2,4,6>
  3765649622U, // <4,0,2,5>: Cost 4 vext3 <1,2,3,4>, <0,2,5,7>
  2686157020U, // <4,0,2,6>: Cost 3 vext3 <0,2,6,4>, <0,2,6,4>
  3668358453U, // <4,0,2,7>: Cost 4 vext1 <7,4,0,2>, <7,4,0,2>
  2686304494U, // <4,0,2,u>: Cost 3 vext3 <0,2,u,4>, <0,2,u,4>
  3632529510U, // <4,0,3,0>: Cost 4 vext1 <1,4,0,3>, LHS
  2686451968U, // <4,0,3,1>: Cost 3 vext3 <0,3,1,4>, <0,3,1,4>
  2686525705U, // <4,0,3,2>: Cost 3 vext3 <0,3,2,4>, <0,3,2,4>
  3760341266U, // <4,0,3,3>: Cost 4 vext3 <0,3,3,4>, <0,3,3,4>
  3632532790U, // <4,0,3,4>: Cost 4 vext1 <1,4,0,3>, RHS
  3913254606U, // <4,0,3,5>: Cost 4 vuzpr <3,4,5,0>, <2,3,4,5>
  3705219740U, // <4,0,3,6>: Cost 4 vext2 <2,3,4,0>, <3,6,4,7>
  3713845990U, // <4,0,3,7>: Cost 4 vext2 <3,7,4,0>, <3,7,4,0>
  2686451968U, // <4,0,3,u>: Cost 3 vext3 <0,3,1,4>, <0,3,1,4>
  2552823910U, // <4,0,4,0>: Cost 3 vext1 <0,4,0,4>, LHS
  2691907922U, // <4,0,4,1>: Cost 3 vext3 <1,2,3,4>, <0,4,1,5>
  2691907932U, // <4,0,4,2>: Cost 3 vext3 <1,2,3,4>, <0,4,2,6>
  3626567830U, // <4,0,4,3>: Cost 4 vext1 <0,4,0,4>, <3,0,1,2>
  2552827190U, // <4,0,4,4>: Cost 3 vext1 <0,4,0,4>, RHS
  2631478582U, // <4,0,4,5>: Cost 3 vext2 <2,3,4,0>, RHS
  3626570017U, // <4,0,4,6>: Cost 4 vext1 <0,4,0,4>, <6,0,1,2>
  3668374839U, // <4,0,4,7>: Cost 4 vext1 <7,4,0,4>, <7,4,0,4>
  2552829742U, // <4,0,4,u>: Cost 3 vext1 <0,4,0,4>, LHS
  2558804070U, // <4,0,5,0>: Cost 3 vext1 <1,4,0,5>, LHS
  1839644774U, // <4,0,5,1>: Cost 2 vzipl RHS, LHS
  2913386660U, // <4,0,5,2>: Cost 3 vzipl RHS, <0,2,0,2>
  2570750420U, // <4,0,5,3>: Cost 3 vext1 <3,4,0,5>, <3,4,0,5>
  2558807350U, // <4,0,5,4>: Cost 3 vext1 <1,4,0,5>, RHS
  3987128750U, // <4,0,5,5>: Cost 4 vzipl RHS, <0,5,2,7>
  3987128822U, // <4,0,5,6>: Cost 4 vzipl RHS, <0,6,1,7>
  2594641208U, // <4,0,5,7>: Cost 3 vext1 <7,4,0,5>, <7,4,0,5>
  1839645341U, // <4,0,5,u>: Cost 2 vzipl RHS, LHS
  2552840294U, // <4,0,6,0>: Cost 3 vext1 <0,4,0,6>, LHS
  3047604234U, // <4,0,6,1>: Cost 3 vtrnl RHS, <0,0,1,1>
  1973862502U, // <4,0,6,2>: Cost 2 vtrnl RHS, LHS
  2570758613U, // <4,0,6,3>: Cost 3 vext1 <3,4,0,6>, <3,4,0,6>
  2552843574U, // <4,0,6,4>: Cost 3 vext1 <0,4,0,6>, RHS
  2217664887U, // <4,0,6,5>: Cost 3 vrev <0,4,5,6>
  3662418528U, // <4,0,6,6>: Cost 4 vext1 <6,4,0,6>, <6,4,0,6>
  2658022257U, // <4,0,6,7>: Cost 3 vext2 <6,7,4,0>, <6,7,4,0>
  1973862556U, // <4,0,6,u>: Cost 2 vtrnl RHS, LHS
  3731764218U, // <4,0,7,0>: Cost 4 vext2 <6,7,4,0>, <7,0,1,2>
  3988324454U, // <4,0,7,1>: Cost 4 vzipl <4,7,5,0>, LHS
  4122034278U, // <4,0,7,2>: Cost 4 vtrnl <4,6,7,1>, LHS
  3735082246U, // <4,0,7,3>: Cost 4 vext2 <7,3,4,0>, <7,3,4,0>
  3731764536U, // <4,0,7,4>: Cost 4 vext2 <6,7,4,0>, <7,4,0,5>
  3937145718U, // <4,0,7,5>: Cost 4 vuzpr <7,4,5,0>, <6,7,4,5>
  3737073145U, // <4,0,7,6>: Cost 4 vext2 <7,6,4,0>, <7,6,4,0>
  3731764844U, // <4,0,7,7>: Cost 4 vext2 <6,7,4,0>, <7,7,7,7>
  4122034332U, // <4,0,7,u>: Cost 4 vtrnl <4,6,7,1>, LHS
  2552856678U, // <4,0,u,0>: Cost 3 vext1 <0,4,0,u>, LHS
  1841635430U, // <4,0,u,1>: Cost 2 vzipl RHS, LHS
  1618166429U, // <4,0,u,2>: Cost 2 vext3 <1,2,3,4>, LHS
  2570774999U, // <4,0,u,3>: Cost 3 vext1 <3,4,0,u>, <3,4,0,u>
  2552859958U, // <4,0,u,4>: Cost 3 vext1 <0,4,0,u>, RHS
  2631481498U, // <4,0,u,5>: Cost 3 vext2 <2,3,4,0>, RHS
  2686157020U, // <4,0,u,6>: Cost 3 vext3 <0,2,6,4>, <0,2,6,4>
  2594665787U, // <4,0,u,7>: Cost 3 vext1 <7,4,0,u>, <7,4,0,u>
  1618166483U, // <4,0,u,u>: Cost 2 vext3 <1,2,3,4>, LHS
  2617548837U, // <4,1,0,0>: Cost 3 vext2 <0,0,4,1>, <0,0,4,1>
  2622857318U, // <4,1,0,1>: Cost 3 vext2 <0,u,4,1>, LHS
  3693281484U, // <4,1,0,2>: Cost 4 vext2 <0,3,4,1>, <0,2,4,6>
  2691908342U, // <4,1,0,3>: Cost 3 vext3 <1,2,3,4>, <1,0,3,2>
  2622857554U, // <4,1,0,4>: Cost 3 vext2 <0,u,4,1>, <0,4,1,5>
  3764470538U, // <4,1,0,5>: Cost 4 vext3 <1,0,5,4>, <1,0,5,4>
  3695272459U, // <4,1,0,6>: Cost 4 vext2 <0,6,4,1>, <0,6,4,1>
  3733094980U, // <4,1,0,7>: Cost 4 vext2 <7,0,4,1>, <0,7,1,4>
  2622857885U, // <4,1,0,u>: Cost 3 vext2 <0,u,4,1>, LHS
  3696599798U, // <4,1,1,0>: Cost 4 vext2 <0,u,4,1>, <1,0,3,2>
  2691097399U, // <4,1,1,1>: Cost 3 vext3 <1,1,1,4>, <1,1,1,4>
  2631484314U, // <4,1,1,2>: Cost 3 vext2 <2,3,4,1>, <1,2,3,4>
  2691908424U, // <4,1,1,3>: Cost 3 vext3 <1,2,3,4>, <1,1,3,3>
  3696600125U, // <4,1,1,4>: Cost 4 vext2 <0,u,4,1>, <1,4,3,5>
  3696600175U, // <4,1,1,5>: Cost 4 vext2 <0,u,4,1>, <1,5,0,1>
  3696600307U, // <4,1,1,6>: Cost 4 vext2 <0,u,4,1>, <1,6,5,7>
  3668423997U, // <4,1,1,7>: Cost 4 vext1 <7,4,1,1>, <7,4,1,1>
  2691908469U, // <4,1,1,u>: Cost 3 vext3 <1,2,3,4>, <1,1,u,3>
  2570797158U, // <4,1,2,0>: Cost 3 vext1 <3,4,1,2>, LHS
  2570797978U, // <4,1,2,1>: Cost 3 vext1 <3,4,1,2>, <1,2,3,4>
  3696600680U, // <4,1,2,2>: Cost 4 vext2 <0,u,4,1>, <2,2,2,2>
  1618166682U, // <4,1,2,3>: Cost 2 vext3 <1,2,3,4>, <1,2,3,4>
  2570800438U, // <4,1,2,4>: Cost 3 vext1 <3,4,1,2>, RHS
  3765650347U, // <4,1,2,5>: Cost 4 vext3 <1,2,3,4>, <1,2,5,3>
  3696601018U, // <4,1,2,6>: Cost 4 vext2 <0,u,4,1>, <2,6,3,7>
  3668432190U, // <4,1,2,7>: Cost 4 vext1 <7,4,1,2>, <7,4,1,2>
  1618535367U, // <4,1,2,u>: Cost 2 vext3 <1,2,u,4>, <1,2,u,4>
  2564833382U, // <4,1,3,0>: Cost 3 vext1 <2,4,1,3>, LHS
  2691908568U, // <4,1,3,1>: Cost 3 vext3 <1,2,3,4>, <1,3,1,3>
  2691908578U, // <4,1,3,2>: Cost 3 vext3 <1,2,3,4>, <1,3,2,4>
  2692572139U, // <4,1,3,3>: Cost 3 vext3 <1,3,3,4>, <1,3,3,4>
  2564836662U, // <4,1,3,4>: Cost 3 vext1 <2,4,1,3>, RHS
  2691908608U, // <4,1,3,5>: Cost 3 vext3 <1,2,3,4>, <1,3,5,7>
  2588725862U, // <4,1,3,6>: Cost 3 vext1 <6,4,1,3>, <6,4,1,3>
  3662468090U, // <4,1,3,7>: Cost 4 vext1 <6,4,1,3>, <7,0,1,2>
  2691908631U, // <4,1,3,u>: Cost 3 vext3 <1,2,3,4>, <1,3,u,3>
  3760194590U, // <4,1,4,0>: Cost 4 vext3 <0,3,1,4>, <1,4,0,1>
  3693947874U, // <4,1,4,1>: Cost 4 vext2 <0,4,4,1>, <4,1,5,0>
  3765650484U, // <4,1,4,2>: Cost 4 vext3 <1,2,3,4>, <1,4,2,5>
  3113877606U, // <4,1,4,3>: Cost 3 vtrnr <4,4,4,4>, LHS
  3760194630U, // <4,1,4,4>: Cost 4 vext3 <0,3,1,4>, <1,4,4,5>
  2622860598U, // <4,1,4,5>: Cost 3 vext2 <0,u,4,1>, RHS
  3297436759U, // <4,1,4,6>: Cost 4 vrev <1,4,6,4>
  3800007772U, // <4,1,4,7>: Cost 4 vext3 <7,0,1,4>, <1,4,7,0>
  2622860841U, // <4,1,4,u>: Cost 3 vext2 <0,u,4,1>, RHS
  1479164006U, // <4,1,5,0>: Cost 2 vext1 <0,4,1,5>, LHS
  2552906486U, // <4,1,5,1>: Cost 3 vext1 <0,4,1,5>, <1,0,3,2>
  2552907299U, // <4,1,5,2>: Cost 3 vext1 <0,4,1,5>, <2,1,3,5>
  2552907926U, // <4,1,5,3>: Cost 3 vext1 <0,4,1,5>, <3,0,1,2>
  1479167286U, // <4,1,5,4>: Cost 2 vext1 <0,4,1,5>, RHS
  2913387664U, // <4,1,5,5>: Cost 3 vzipl RHS, <1,5,3,7>
  2600686074U, // <4,1,5,6>: Cost 3 vext1 <u,4,1,5>, <6,2,7,3>
  2600686586U, // <4,1,5,7>: Cost 3 vext1 <u,4,1,5>, <7,0,1,2>
  1479169838U, // <4,1,5,u>: Cost 2 vext1 <0,4,1,5>, LHS
  2552914022U, // <4,1,6,0>: Cost 3 vext1 <0,4,1,6>, LHS
  2558886708U, // <4,1,6,1>: Cost 3 vext1 <1,4,1,6>, <1,1,1,1>
  4028205206U, // <4,1,6,2>: Cost 4 vzipr <0,2,4,6>, <3,0,1,2>
  3089858662U, // <4,1,6,3>: Cost 3 vtrnr <0,4,2,6>, LHS
  2552917302U, // <4,1,6,4>: Cost 3 vext1 <0,4,1,6>, RHS
  2223637584U, // <4,1,6,5>: Cost 3 vrev <1,4,5,6>
  4121347081U, // <4,1,6,6>: Cost 4 vtrnl RHS, <1,3,6,7>
  3721155406U, // <4,1,6,7>: Cost 4 vext2 <5,0,4,1>, <6,7,0,1>
  2552919854U, // <4,1,6,u>: Cost 3 vext1 <0,4,1,6>, LHS
  2659357716U, // <4,1,7,0>: Cost 3 vext2 <7,0,4,1>, <7,0,4,1>
  3733763173U, // <4,1,7,1>: Cost 4 vext2 <7,1,4,1>, <7,1,4,1>
  3734426806U, // <4,1,7,2>: Cost 4 vext2 <7,2,4,1>, <7,2,4,1>
  2695226671U, // <4,1,7,3>: Cost 3 vext3 <1,7,3,4>, <1,7,3,4>
  3721155942U, // <4,1,7,4>: Cost 4 vext2 <5,0,4,1>, <7,4,5,6>
  3721155976U, // <4,1,7,5>: Cost 4 vext2 <5,0,4,1>, <7,5,0,4>
  3662500458U, // <4,1,7,6>: Cost 4 vext1 <6,4,1,7>, <6,4,1,7>
  3721156204U, // <4,1,7,7>: Cost 4 vext2 <5,0,4,1>, <7,7,7,7>
  2659357716U, // <4,1,7,u>: Cost 3 vext2 <7,0,4,1>, <7,0,4,1>
  1479188582U, // <4,1,u,0>: Cost 2 vext1 <0,4,1,u>, LHS
  2552931062U, // <4,1,u,1>: Cost 3 vext1 <0,4,1,u>, <1,0,3,2>
  2552931944U, // <4,1,u,2>: Cost 3 vext1 <0,4,1,u>, <2,2,2,2>
  1622148480U, // <4,1,u,3>: Cost 2 vext3 <1,u,3,4>, <1,u,3,4>
  1479191862U, // <4,1,u,4>: Cost 2 vext1 <0,4,1,u>, RHS
  2622863514U, // <4,1,u,5>: Cost 3 vext2 <0,u,4,1>, RHS
  2588725862U, // <4,1,u,6>: Cost 3 vext1 <6,4,1,3>, <6,4,1,3>
  2600686586U, // <4,1,u,7>: Cost 3 vext1 <u,4,1,5>, <7,0,1,2>
  1479194414U, // <4,1,u,u>: Cost 2 vext1 <0,4,1,u>, LHS
  2617557030U, // <4,2,0,0>: Cost 3 vext2 <0,0,4,2>, <0,0,4,2>
  2622865510U, // <4,2,0,1>: Cost 3 vext2 <0,u,4,2>, LHS
  2622865612U, // <4,2,0,2>: Cost 3 vext2 <0,u,4,2>, <0,2,4,6>
  3693289753U, // <4,2,0,3>: Cost 4 vext2 <0,3,4,2>, <0,3,4,2>
  2635473244U, // <4,2,0,4>: Cost 3 vext2 <3,0,4,2>, <0,4,2,6>
  3765650918U, // <4,2,0,5>: Cost 4 vext3 <1,2,3,4>, <2,0,5,7>
  2696775148U, // <4,2,0,6>: Cost 3 vext3 <2,0,6,4>, <2,0,6,4>
  3695944285U, // <4,2,0,7>: Cost 4 vext2 <0,7,4,2>, <0,7,4,2>
  2622866077U, // <4,2,0,u>: Cost 3 vext2 <0,u,4,2>, LHS
  3696607990U, // <4,2,1,0>: Cost 4 vext2 <0,u,4,2>, <1,0,3,2>
  3696608052U, // <4,2,1,1>: Cost 4 vext2 <0,u,4,2>, <1,1,1,1>
  3696608150U, // <4,2,1,2>: Cost 4 vext2 <0,u,4,2>, <1,2,3,0>
  3895574630U, // <4,2,1,3>: Cost 4 vuzpr <0,4,u,2>, LHS
  2691909162U, // <4,2,1,4>: Cost 3 vext3 <1,2,3,4>, <2,1,4,3>
  3696608400U, // <4,2,1,5>: Cost 4 vext2 <0,u,4,2>, <1,5,3,7>
  3760784956U, // <4,2,1,6>: Cost 4 vext3 <0,4,0,4>, <2,1,6,3>
  3773908549U, // <4,2,1,7>: Cost 5 vext3 <2,5,7,4>, <2,1,7,3>
  2691909162U, // <4,2,1,u>: Cost 3 vext3 <1,2,3,4>, <2,1,4,3>
  3696608748U, // <4,2,2,0>: Cost 4 vext2 <0,u,4,2>, <2,0,6,4>
  3696608828U, // <4,2,2,1>: Cost 4 vext2 <0,u,4,2>, <2,1,6,3>
  2691909224U, // <4,2,2,2>: Cost 3 vext3 <1,2,3,4>, <2,2,2,2>
  2691909234U, // <4,2,2,3>: Cost 3 vext3 <1,2,3,4>, <2,2,3,3>
  3759605368U, // <4,2,2,4>: Cost 4 vext3 <0,2,2,4>, <2,2,4,0>
  3696609156U, // <4,2,2,5>: Cost 4 vext2 <0,u,4,2>, <2,5,6,7>
  3760785040U, // <4,2,2,6>: Cost 4 vext3 <0,4,0,4>, <2,2,6,6>
  3668505927U, // <4,2,2,7>: Cost 4 vext1 <7,4,2,2>, <7,4,2,2>
  2691909279U, // <4,2,2,u>: Cost 3 vext3 <1,2,3,4>, <2,2,u,3>
  2691909286U, // <4,2,3,0>: Cost 3 vext3 <1,2,3,4>, <2,3,0,1>
  3764840111U, // <4,2,3,1>: Cost 4 vext3 <1,1,1,4>, <2,3,1,1>
  3765651129U, // <4,2,3,2>: Cost 4 vext3 <1,2,3,4>, <2,3,2,2>
  2698544836U, // <4,2,3,3>: Cost 3 vext3 <2,3,3,4>, <2,3,3,4>
  2685863630U, // <4,2,3,4>: Cost 3 vext3 <0,2,2,4>, <2,3,4,5>
  2698692310U, // <4,2,3,5>: Cost 3 vext3 <2,3,5,4>, <2,3,5,4>
  3772507871U, // <4,2,3,6>: Cost 4 vext3 <2,3,6,4>, <2,3,6,4>
  2698839784U, // <4,2,3,7>: Cost 3 vext3 <2,3,7,4>, <2,3,7,4>
  2691909358U, // <4,2,3,u>: Cost 3 vext3 <1,2,3,4>, <2,3,u,1>
  2564915302U, // <4,2,4,0>: Cost 3 vext1 <2,4,2,4>, LHS
  2564916122U, // <4,2,4,1>: Cost 3 vext1 <2,4,2,4>, <1,2,3,4>
  2564917004U, // <4,2,4,2>: Cost 3 vext1 <2,4,2,4>, <2,4,2,4>
  2699208469U, // <4,2,4,3>: Cost 3 vext3 <2,4,3,4>, <2,4,3,4>
  2564918582U, // <4,2,4,4>: Cost 3 vext1 <2,4,2,4>, RHS
  2622868790U, // <4,2,4,5>: Cost 3 vext2 <0,u,4,2>, RHS
  2229667632U, // <4,2,4,6>: Cost 3 vrev <2,4,6,4>
  3800082229U, // <4,2,4,7>: Cost 4 vext3 <7,0,2,4>, <2,4,7,0>
  2622869033U, // <4,2,4,u>: Cost 3 vext2 <0,u,4,2>, RHS
  2552979558U, // <4,2,5,0>: Cost 3 vext1 <0,4,2,5>, LHS
  2558952342U, // <4,2,5,1>: Cost 3 vext1 <1,4,2,5>, <1,2,3,0>
  2564925032U, // <4,2,5,2>: Cost 3 vext1 <2,4,2,5>, <2,2,2,2>
  2967060582U, // <4,2,5,3>: Cost 3 vzipr <2,3,4,5>, LHS
  2552982838U, // <4,2,5,4>: Cost 3 vext1 <0,4,2,5>, RHS
  3987130190U, // <4,2,5,5>: Cost 4 vzipl RHS, <2,5,0,7>
  2913388474U, // <4,2,5,6>: Cost 3 vzipl RHS, <2,6,3,7>
  3895577910U, // <4,2,5,7>: Cost 4 vuzpr <0,4,u,2>, RHS
  2552985390U, // <4,2,5,u>: Cost 3 vext1 <0,4,2,5>, LHS
  1479245926U, // <4,2,6,0>: Cost 2 vext1 <0,4,2,6>, LHS
  2552988406U, // <4,2,6,1>: Cost 3 vext1 <0,4,2,6>, <1,0,3,2>
  2552989288U, // <4,2,6,2>: Cost 3 vext1 <0,4,2,6>, <2,2,2,2>
  2954461286U, // <4,2,6,3>: Cost 3 vzipr <0,2,4,6>, LHS
  1479249206U, // <4,2,6,4>: Cost 2 vext1 <0,4,2,6>, RHS
  2229610281U, // <4,2,6,5>: Cost 3 vrev <2,4,5,6>
  2600767994U, // <4,2,6,6>: Cost 3 vext1 <u,4,2,6>, <6,2,7,3>
  2600768506U, // <4,2,6,7>: Cost 3 vext1 <u,4,2,6>, <7,0,1,2>
  1479251758U, // <4,2,6,u>: Cost 2 vext1 <0,4,2,6>, LHS
  2659365909U, // <4,2,7,0>: Cost 3 vext2 <7,0,4,2>, <7,0,4,2>
  3733771366U, // <4,2,7,1>: Cost 4 vext2 <7,1,4,2>, <7,1,4,2>
  3734434999U, // <4,2,7,2>: Cost 4 vext2 <7,2,4,2>, <7,2,4,2>
  2701199368U, // <4,2,7,3>: Cost 3 vext3 <2,7,3,4>, <2,7,3,4>
  4175774618U, // <4,2,7,4>: Cost 4 vtrnr <2,4,5,7>, <1,2,3,4>
  3303360298U, // <4,2,7,5>: Cost 4 vrev <2,4,5,7>
  3727136217U, // <4,2,7,6>: Cost 4 vext2 <6,0,4,2>, <7,6,0,4>
  3727136364U, // <4,2,7,7>: Cost 4 vext2 <6,0,4,2>, <7,7,7,7>
  2659365909U, // <4,2,7,u>: Cost 3 vext2 <7,0,4,2>, <7,0,4,2>
  1479262310U, // <4,2,u,0>: Cost 2 vext1 <0,4,2,u>, LHS
  2553004790U, // <4,2,u,1>: Cost 3 vext1 <0,4,2,u>, <1,0,3,2>
  2553005672U, // <4,2,u,2>: Cost 3 vext1 <0,4,2,u>, <2,2,2,2>
  2954477670U, // <4,2,u,3>: Cost 3 vzipr <0,2,4,u>, LHS
  1479265590U, // <4,2,u,4>: Cost 2 vext1 <0,4,2,u>, RHS
  2622871706U, // <4,2,u,5>: Cost 3 vext2 <0,u,4,2>, RHS
  2229700404U, // <4,2,u,6>: Cost 3 vrev <2,4,6,u>
  2600784890U, // <4,2,u,7>: Cost 3 vext1 <u,4,2,u>, <7,0,1,2>
  1479268142U, // <4,2,u,u>: Cost 2 vext1 <0,4,2,u>, LHS
  3765651595U, // <4,3,0,0>: Cost 4 vext3 <1,2,3,4>, <3,0,0,0>
  2691909782U, // <4,3,0,1>: Cost 3 vext3 <1,2,3,4>, <3,0,1,2>
  2702452897U, // <4,3,0,2>: Cost 3 vext3 <3,0,2,4>, <3,0,2,4>
  3693297946U, // <4,3,0,3>: Cost 4 vext2 <0,3,4,3>, <0,3,4,3>
  3760711856U, // <4,3,0,4>: Cost 4 vext3 <0,3,u,4>, <3,0,4,1>
  2235533820U, // <4,3,0,5>: Cost 3 vrev <3,4,5,0>
  3309349381U, // <4,3,0,6>: Cost 4 vrev <3,4,6,0>
  3668563278U, // <4,3,0,7>: Cost 4 vext1 <7,4,3,0>, <7,4,3,0>
  2691909845U, // <4,3,0,u>: Cost 3 vext3 <1,2,3,4>, <3,0,u,2>
  2235173328U, // <4,3,1,0>: Cost 3 vrev <3,4,0,1>
  3764840678U, // <4,3,1,1>: Cost 4 vext3 <1,1,1,4>, <3,1,1,1>
  2630173594U, // <4,3,1,2>: Cost 3 vext2 <2,1,4,3>, <1,2,3,4>
  2703190267U, // <4,3,1,3>: Cost 3 vext3 <3,1,3,4>, <3,1,3,4>
  3760195840U, // <4,3,1,4>: Cost 4 vext3 <0,3,1,4>, <3,1,4,0>
  3765651724U, // <4,3,1,5>: Cost 4 vext3 <1,2,3,4>, <3,1,5,3>
  3309357574U, // <4,3,1,6>: Cost 4 vrev <3,4,6,1>
  3769633054U, // <4,3,1,7>: Cost 4 vext3 <1,u,3,4>, <3,1,7,3>
  2703558952U, // <4,3,1,u>: Cost 3 vext3 <3,1,u,4>, <3,1,u,4>
  3626770534U, // <4,3,2,0>: Cost 4 vext1 <0,4,3,2>, LHS
  2630174250U, // <4,3,2,1>: Cost 3 vext2 <2,1,4,3>, <2,1,4,3>
  3765651777U, // <4,3,2,2>: Cost 4 vext3 <1,2,3,4>, <3,2,2,2>
  2703853900U, // <4,3,2,3>: Cost 3 vext3 <3,2,3,4>, <3,2,3,4>
  3626773814U, // <4,3,2,4>: Cost 4 vext1 <0,4,3,2>, RHS
  2704001374U, // <4,3,2,5>: Cost 3 vext3 <3,2,5,4>, <3,2,5,4>
  3765651814U, // <4,3,2,6>: Cost 4 vext3 <1,2,3,4>, <3,2,6,3>
  3769633135U, // <4,3,2,7>: Cost 4 vext3 <1,u,3,4>, <3,2,7,3>
  2634819681U, // <4,3,2,u>: Cost 3 vext2 <2,u,4,3>, <2,u,4,3>
  3765651839U, // <4,3,3,0>: Cost 4 vext3 <1,2,3,4>, <3,3,0,1>
  3765651848U, // <4,3,3,1>: Cost 4 vext3 <1,2,3,4>, <3,3,1,1>
  3710552404U, // <4,3,3,2>: Cost 4 vext2 <3,2,4,3>, <3,2,4,3>
  2691910044U, // <4,3,3,3>: Cost 3 vext3 <1,2,3,4>, <3,3,3,3>
  2704591270U, // <4,3,3,4>: Cost 3 vext3 <3,3,4,4>, <3,3,4,4>
  3769633202U, // <4,3,3,5>: Cost 4 vext3 <1,u,3,4>, <3,3,5,7>
  3703917212U, // <4,3,3,6>: Cost 4 vext2 <2,1,4,3>, <3,6,4,7>
  3769633220U, // <4,3,3,7>: Cost 4 vext3 <1,u,3,4>, <3,3,7,7>
  2691910044U, // <4,3,3,u>: Cost 3 vext3 <1,2,3,4>, <3,3,3,3>
  2691910096U, // <4,3,4,0>: Cost 3 vext3 <1,2,3,4>, <3,4,0,1>
  2691910106U, // <4,3,4,1>: Cost 3 vext3 <1,2,3,4>, <3,4,1,2>
  2564990741U, // <4,3,4,2>: Cost 3 vext1 <2,4,3,4>, <2,4,3,4>
  3765651946U, // <4,3,4,3>: Cost 4 vext3 <1,2,3,4>, <3,4,3,0>
  2691910136U, // <4,3,4,4>: Cost 3 vext3 <1,2,3,4>, <3,4,4,5>
  2686454274U, // <4,3,4,5>: Cost 3 vext3 <0,3,1,4>, <3,4,5,6>
  2235640329U, // <4,3,4,6>: Cost 3 vrev <3,4,6,4>
  3801483792U, // <4,3,4,7>: Cost 4 vext3 <7,2,3,4>, <3,4,7,2>
  2691910168U, // <4,3,4,u>: Cost 3 vext3 <1,2,3,4>, <3,4,u,1>
  2559025254U, // <4,3,5,0>: Cost 3 vext1 <1,4,3,5>, LHS
  2559026237U, // <4,3,5,1>: Cost 3 vext1 <1,4,3,5>, <1,4,3,5>
  2564998862U, // <4,3,5,2>: Cost 3 vext1 <2,4,3,5>, <2,3,4,5>
  2570971548U, // <4,3,5,3>: Cost 3 vext1 <3,4,3,5>, <3,3,3,3>
  2559028534U, // <4,3,5,4>: Cost 3 vext1 <1,4,3,5>, RHS
  4163519477U, // <4,3,5,5>: Cost 4 vtrnr <0,4,1,5>, <1,3,4,5>
  3309390346U, // <4,3,5,6>: Cost 4 vrev <3,4,6,5>
  2706139747U, // <4,3,5,7>: Cost 3 vext3 <3,5,7,4>, <3,5,7,4>
  2559031086U, // <4,3,5,u>: Cost 3 vext1 <1,4,3,5>, LHS
  2559033446U, // <4,3,6,0>: Cost 3 vext1 <1,4,3,6>, LHS
  2559034430U, // <4,3,6,1>: Cost 3 vext1 <1,4,3,6>, <1,4,3,6>
  2565007127U, // <4,3,6,2>: Cost 3 vext1 <2,4,3,6>, <2,4,3,6>
  2570979740U, // <4,3,6,3>: Cost 3 vext1 <3,4,3,6>, <3,3,3,3>
  2559036726U, // <4,3,6,4>: Cost 3 vext1 <1,4,3,6>, RHS
  1161841154U, // <4,3,6,5>: Cost 2 vrev <3,4,5,6>
  4028203932U, // <4,3,6,6>: Cost 4 vzipr <0,2,4,6>, <1,2,3,6>
  2706803380U, // <4,3,6,7>: Cost 3 vext3 <3,6,7,4>, <3,6,7,4>
  1162062365U, // <4,3,6,u>: Cost 2 vrev <3,4,u,6>
  3769633475U, // <4,3,7,0>: Cost 4 vext3 <1,u,3,4>, <3,7,0,1>
  3769633488U, // <4,3,7,1>: Cost 4 vext3 <1,u,3,4>, <3,7,1,5>
  3638757144U, // <4,3,7,2>: Cost 4 vext1 <2,4,3,7>, <2,4,3,7>
  3769633508U, // <4,3,7,3>: Cost 4 vext3 <1,u,3,4>, <3,7,3,7>
  3769633515U, // <4,3,7,4>: Cost 4 vext3 <1,u,3,4>, <3,7,4,5>
  3769633526U, // <4,3,7,5>: Cost 4 vext3 <1,u,3,4>, <3,7,5,7>
  3662647932U, // <4,3,7,6>: Cost 4 vext1 <6,4,3,7>, <6,4,3,7>
  3781208837U, // <4,3,7,7>: Cost 4 vext3 <3,7,7,4>, <3,7,7,4>
  3769633547U, // <4,3,7,u>: Cost 4 vext3 <1,u,3,4>, <3,7,u,1>
  2559049830U, // <4,3,u,0>: Cost 3 vext1 <1,4,3,u>, LHS
  2691910430U, // <4,3,u,1>: Cost 3 vext3 <1,2,3,4>, <3,u,1,2>
  2565023513U, // <4,3,u,2>: Cost 3 vext1 <2,4,3,u>, <2,4,3,u>
  2707835698U, // <4,3,u,3>: Cost 3 vext3 <3,u,3,4>, <3,u,3,4>
  2559053110U, // <4,3,u,4>: Cost 3 vext1 <1,4,3,u>, RHS
  1161857540U, // <4,3,u,5>: Cost 2 vrev <3,4,5,u>
  2235673101U, // <4,3,u,6>: Cost 3 vrev <3,4,6,u>
  2708130646U, // <4,3,u,7>: Cost 3 vext3 <3,u,7,4>, <3,u,7,4>
  1162078751U, // <4,3,u,u>: Cost 2 vrev <3,4,u,u>
  2617573416U, // <4,4,0,0>: Cost 3 vext2 <0,0,4,4>, <0,0,4,4>
  1570373734U, // <4,4,0,1>: Cost 2 vext2 <4,4,4,4>, LHS
  2779676774U, // <4,4,0,2>: Cost 3 vuzpl <4,6,4,6>, LHS
  3760196480U, // <4,4,0,3>: Cost 4 vext3 <0,3,1,4>, <4,0,3,1>
  2576977100U, // <4,4,0,4>: Cost 3 vext1 <4,4,4,0>, <4,4,4,0>
  2718747538U, // <4,4,0,5>: Cost 3 vext3 <5,6,7,4>, <4,0,5,1>
  2718747548U, // <4,4,0,6>: Cost 3 vext3 <5,6,7,4>, <4,0,6,2>
  3668637015U, // <4,4,0,7>: Cost 4 vext1 <7,4,4,0>, <7,4,4,0>
  1570374301U, // <4,4,0,u>: Cost 2 vext2 <4,4,4,4>, LHS
  2644116214U, // <4,4,1,0>: Cost 3 vext2 <4,4,4,4>, <1,0,3,2>
  2644116276U, // <4,4,1,1>: Cost 3 vext2 <4,4,4,4>, <1,1,1,1>
  2691910602U, // <4,4,1,2>: Cost 3 vext3 <1,2,3,4>, <4,1,2,3>
  2644116440U, // <4,4,1,3>: Cost 3 vext2 <4,4,4,4>, <1,3,1,3>
  2711227356U, // <4,4,1,4>: Cost 3 vext3 <4,4,4,4>, <4,1,4,3>
  2709310438U, // <4,4,1,5>: Cost 3 vext3 <4,1,5,4>, <4,1,5,4>
  3765652462U, // <4,4,1,6>: Cost 4 vext3 <1,2,3,4>, <4,1,6,3>
  3768970231U, // <4,4,1,7>: Cost 4 vext3 <1,7,3,4>, <4,1,7,3>
  2695891968U, // <4,4,1,u>: Cost 3 vext3 <1,u,3,4>, <4,1,u,3>
  3703260634U, // <4,4,2,0>: Cost 4 vext2 <2,0,4,4>, <2,0,4,4>
  3765652499U, // <4,4,2,1>: Cost 4 vext3 <1,2,3,4>, <4,2,1,4>
  2644117096U, // <4,4,2,2>: Cost 3 vext2 <4,4,4,4>, <2,2,2,2>
  2631509709U, // <4,4,2,3>: Cost 3 vext2 <2,3,4,4>, <2,3,4,4>
  2644117269U, // <4,4,2,4>: Cost 3 vext2 <4,4,4,4>, <2,4,3,4>
  3705251698U, // <4,4,2,5>: Cost 4 vext2 <2,3,4,4>, <2,5,4,7>
  2710047808U, // <4,4,2,6>: Cost 3 vext3 <4,2,6,4>, <4,2,6,4>
  3783863369U, // <4,4,2,7>: Cost 4 vext3 <4,2,7,4>, <4,2,7,4>
  2634827874U, // <4,4,2,u>: Cost 3 vext2 <2,u,4,4>, <2,u,4,4>
  2644117654U, // <4,4,3,0>: Cost 3 vext2 <4,4,4,4>, <3,0,1,2>
  3638797210U, // <4,4,3,1>: Cost 4 vext1 <2,4,4,3>, <1,2,3,4>
  3638798082U, // <4,4,3,2>: Cost 4 vext1 <2,4,4,3>, <2,4,1,3>
  2637482406U, // <4,4,3,3>: Cost 3 vext2 <3,3,4,4>, <3,3,4,4>
  2638146039U, // <4,4,3,4>: Cost 3 vext2 <3,4,4,4>, <3,4,4,4>
  3913287374U, // <4,4,3,5>: Cost 4 vuzpr <3,4,5,4>, <2,3,4,5>
  3765652625U, // <4,4,3,6>: Cost 4 vext3 <1,2,3,4>, <4,3,6,4>
  3713878762U, // <4,4,3,7>: Cost 4 vext2 <3,7,4,4>, <3,7,4,4>
  2637482406U, // <4,4,3,u>: Cost 3 vext2 <3,3,4,4>, <3,3,4,4>
  1503264870U, // <4,4,4,0>: Cost 2 vext1 <4,4,4,4>, LHS
  2577007514U, // <4,4,4,1>: Cost 3 vext1 <4,4,4,4>, <1,2,3,4>
  2577008232U, // <4,4,4,2>: Cost 3 vext1 <4,4,4,4>, <2,2,2,2>
  2571037175U, // <4,4,4,3>: Cost 3 vext1 <3,4,4,4>, <3,4,4,4>
  161926454U, // <4,4,4,4>: Cost 1 vdup0 RHS
  1570377014U, // <4,4,4,5>: Cost 2 vext2 <4,4,4,4>, RHS
  2779680054U, // <4,4,4,6>: Cost 3 vuzpl <4,6,4,6>, RHS
  2594927963U, // <4,4,4,7>: Cost 3 vext1 <7,4,4,4>, <7,4,4,4>
  161926454U, // <4,4,4,u>: Cost 1 vdup0 RHS
  2571042918U, // <4,4,5,0>: Cost 3 vext1 <3,4,4,5>, LHS
  2571043738U, // <4,4,5,1>: Cost 3 vext1 <3,4,4,5>, <1,2,3,4>
  3638814495U, // <4,4,5,2>: Cost 4 vext1 <2,4,4,5>, <2,4,4,5>
  2571045368U, // <4,4,5,3>: Cost 3 vext1 <3,4,4,5>, <3,4,4,5>
  2571046198U, // <4,4,5,4>: Cost 3 vext1 <3,4,4,5>, RHS
  1839648054U, // <4,4,5,5>: Cost 2 vzipl RHS, RHS
  1618169142U, // <4,4,5,6>: Cost 2 vext3 <1,2,3,4>, RHS
  2594936156U, // <4,4,5,7>: Cost 3 vext1 <7,4,4,5>, <7,4,4,5>
  1618169160U, // <4,4,5,u>: Cost 2 vext3 <1,2,3,4>, RHS
  2553135206U, // <4,4,6,0>: Cost 3 vext1 <0,4,4,6>, LHS
  3626877686U, // <4,4,6,1>: Cost 4 vext1 <0,4,4,6>, <1,0,3,2>
  2565080782U, // <4,4,6,2>: Cost 3 vext1 <2,4,4,6>, <2,3,4,5>
  2571053561U, // <4,4,6,3>: Cost 3 vext1 <3,4,4,6>, <3,4,4,6>
  2553138486U, // <4,4,6,4>: Cost 3 vext1 <0,4,4,6>, RHS
  2241555675U, // <4,4,6,5>: Cost 3 vrev <4,4,5,6>
  1973865782U, // <4,4,6,6>: Cost 2 vtrnl RHS, RHS
  2658055029U, // <4,4,6,7>: Cost 3 vext2 <6,7,4,4>, <6,7,4,4>
  1973865800U, // <4,4,6,u>: Cost 2 vtrnl RHS, RHS
  2644120570U, // <4,4,7,0>: Cost 3 vext2 <4,4,4,4>, <7,0,1,2>
  3638829978U, // <4,4,7,1>: Cost 4 vext1 <2,4,4,7>, <1,2,3,4>
  3638830881U, // <4,4,7,2>: Cost 4 vext1 <2,4,4,7>, <2,4,4,7>
  3735115018U, // <4,4,7,3>: Cost 4 vext2 <7,3,4,4>, <7,3,4,4>
  2662036827U, // <4,4,7,4>: Cost 3 vext2 <7,4,4,4>, <7,4,4,4>
  2713292236U, // <4,4,7,5>: Cost 3 vext3 <4,7,5,4>, <4,7,5,4>
  2713365973U, // <4,4,7,6>: Cost 3 vext3 <4,7,6,4>, <4,7,6,4>
  2644121196U, // <4,4,7,7>: Cost 3 vext2 <4,4,4,4>, <7,7,7,7>
  2662036827U, // <4,4,7,u>: Cost 3 vext2 <7,4,4,4>, <7,4,4,4>
  1503297638U, // <4,4,u,0>: Cost 2 vext1 <4,4,4,u>, LHS
  1570379566U, // <4,4,u,1>: Cost 2 vext2 <4,4,4,4>, LHS
  2779682606U, // <4,4,u,2>: Cost 3 vuzpl <4,6,4,6>, LHS
  2571069947U, // <4,4,u,3>: Cost 3 vext1 <3,4,4,u>, <3,4,4,u>
  161926454U, // <4,4,u,4>: Cost 1 vdup0 RHS
  1841638710U, // <4,4,u,5>: Cost 2 vzipl RHS, RHS
  1618169385U, // <4,4,u,6>: Cost 2 vext3 <1,2,3,4>, RHS
  2594960735U, // <4,4,u,7>: Cost 3 vext1 <7,4,4,u>, <7,4,4,u>
  161926454U, // <4,4,u,u>: Cost 1 vdup0 RHS
  2631516160U, // <4,5,0,0>: Cost 3 vext2 <2,3,4,5>, <0,0,0,0>
  1557774438U, // <4,5,0,1>: Cost 2 vext2 <2,3,4,5>, LHS
  2618908875U, // <4,5,0,2>: Cost 3 vext2 <0,2,4,5>, <0,2,4,5>
  2571078140U, // <4,5,0,3>: Cost 3 vext1 <3,4,5,0>, <3,4,5,0>
  2626871634U, // <4,5,0,4>: Cost 3 vext2 <1,5,4,5>, <0,4,1,5>
  3705258414U, // <4,5,0,5>: Cost 4 vext2 <2,3,4,5>, <0,5,2,7>
  2594968438U, // <4,5,0,6>: Cost 3 vext1 <7,4,5,0>, <6,7,4,5>
  2594968928U, // <4,5,0,7>: Cost 3 vext1 <7,4,5,0>, <7,4,5,0>
  1557775005U, // <4,5,0,u>: Cost 2 vext2 <2,3,4,5>, LHS
  2631516918U, // <4,5,1,0>: Cost 3 vext2 <2,3,4,5>, <1,0,3,2>
  2624217939U, // <4,5,1,1>: Cost 3 vext2 <1,1,4,5>, <1,1,4,5>
  2631517078U, // <4,5,1,2>: Cost 3 vext2 <2,3,4,5>, <1,2,3,0>
  2821341286U, // <4,5,1,3>: Cost 3 vuzpr <0,4,1,5>, LHS
  3895086054U, // <4,5,1,4>: Cost 4 vuzpr <0,4,1,5>, <4,1,5,4>
  2626872471U, // <4,5,1,5>: Cost 3 vext2 <1,5,4,5>, <1,5,4,5>
  3895083131U, // <4,5,1,6>: Cost 4 vuzpr <0,4,1,5>, <0,1,4,6>
  2718748368U, // <4,5,1,7>: Cost 3 vext3 <5,6,7,4>, <5,1,7,3>
  2821341291U, // <4,5,1,u>: Cost 3 vuzpr <0,4,1,5>, LHS
  2571092070U, // <4,5,2,0>: Cost 3 vext1 <3,4,5,2>, LHS
  3699287585U, // <4,5,2,1>: Cost 4 vext2 <1,3,4,5>, <2,1,3,3>
  2630854269U, // <4,5,2,2>: Cost 3 vext2 <2,2,4,5>, <2,2,4,5>
  1557776078U, // <4,5,2,3>: Cost 2 vext2 <2,3,4,5>, <2,3,4,5>
  2631517974U, // <4,5,2,4>: Cost 3 vext2 <2,3,4,5>, <2,4,3,5>
  3692652384U, // <4,5,2,5>: Cost 4 vext2 <0,2,4,5>, <2,5,2,7>
  2631518138U, // <4,5,2,6>: Cost 3 vext2 <2,3,4,5>, <2,6,3,7>
  4164013366U, // <4,5,2,7>: Cost 4 vtrnr <0,4,u,2>, RHS
  1561094243U, // <4,5,2,u>: Cost 2 vext2 <2,u,4,5>, <2,u,4,5>
  2631518358U, // <4,5,3,0>: Cost 3 vext2 <2,3,4,5>, <3,0,1,2>
  3895084710U, // <4,5,3,1>: Cost 4 vuzpr <0,4,1,5>, <2,3,0,1>
  2631518540U, // <4,5,3,2>: Cost 3 vext2 <2,3,4,5>, <3,2,3,4>
  2631518620U, // <4,5,3,3>: Cost 3 vext2 <2,3,4,5>, <3,3,3,3>
  2631518716U, // <4,5,3,4>: Cost 3 vext2 <2,3,4,5>, <3,4,5,0>
  2631518784U, // <4,5,3,5>: Cost 3 vext2 <2,3,4,5>, <3,5,3,5>
  2658060980U, // <4,5,3,6>: Cost 3 vext2 <6,7,4,5>, <3,6,7,4>
  2640145131U, // <4,5,3,7>: Cost 3 vext2 <3,7,4,5>, <3,7,4,5>
  2631519006U, // <4,5,3,u>: Cost 3 vext2 <2,3,4,5>, <3,u,1,2>
  2571108454U, // <4,5,4,0>: Cost 3 vext1 <3,4,5,4>, LHS
  3632907342U, // <4,5,4,1>: Cost 4 vext1 <1,4,5,4>, <1,4,5,4>
  2571110094U, // <4,5,4,2>: Cost 3 vext1 <3,4,5,4>, <2,3,4,5>
  2571110912U, // <4,5,4,3>: Cost 3 vext1 <3,4,5,4>, <3,4,5,4>
  2571111734U, // <4,5,4,4>: Cost 3 vext1 <3,4,5,4>, RHS
  1557777718U, // <4,5,4,5>: Cost 2 vext2 <2,3,4,5>, RHS
  2645454195U, // <4,5,4,6>: Cost 3 vext2 <4,6,4,5>, <4,6,4,5>
  2718748614U, // <4,5,4,7>: Cost 3 vext3 <5,6,7,4>, <5,4,7,6>
  1557777961U, // <4,5,4,u>: Cost 2 vext2 <2,3,4,5>, RHS
  1503346790U, // <4,5,5,0>: Cost 2 vext1 <4,4,5,5>, LHS
  2913398480U, // <4,5,5,1>: Cost 3 vzipl RHS, <5,1,7,3>
  2631519998U, // <4,5,5,2>: Cost 3 vext2 <2,3,4,5>, <5,2,3,4>
  2577090710U, // <4,5,5,3>: Cost 3 vext1 <4,4,5,5>, <3,0,1,2>
  1503349978U, // <4,5,5,4>: Cost 2 vext1 <4,4,5,5>, <4,4,5,5>
  2631520260U, // <4,5,5,5>: Cost 3 vext2 <2,3,4,5>, <5,5,5,5>
  2913390690U, // <4,5,5,6>: Cost 3 vzipl RHS, <5,6,7,0>
  2821344566U, // <4,5,5,7>: Cost 3 vuzpr <0,4,1,5>, RHS
  1503352622U, // <4,5,5,u>: Cost 2 vext1 <4,4,5,5>, LHS
  1497383014U, // <4,5,6,0>: Cost 2 vext1 <3,4,5,6>, LHS
  2559181904U, // <4,5,6,1>: Cost 3 vext1 <1,4,5,6>, <1,4,5,6>
  2565154601U, // <4,5,6,2>: Cost 3 vext1 <2,4,5,6>, <2,4,5,6>
  1497385474U, // <4,5,6,3>: Cost 2 vext1 <3,4,5,6>, <3,4,5,6>
  1497386294U, // <4,5,6,4>: Cost 2 vext1 <3,4,5,6>, RHS
  3047608324U, // <4,5,6,5>: Cost 3 vtrnl RHS, <5,5,5,5>
  2571129656U, // <4,5,6,6>: Cost 3 vext1 <3,4,5,6>, <6,6,6,6>
  27705344U, // <4,5,6,7>: Cost 0 copy RHS
  27705344U, // <4,5,6,u>: Cost 0 copy RHS
  2565161062U, // <4,5,7,0>: Cost 3 vext1 <2,4,5,7>, LHS
  2565161882U, // <4,5,7,1>: Cost 3 vext1 <2,4,5,7>, <1,2,3,4>
  2565162794U, // <4,5,7,2>: Cost 3 vext1 <2,4,5,7>, <2,4,5,7>
  2661381387U, // <4,5,7,3>: Cost 3 vext2 <7,3,4,5>, <7,3,4,5>
  2565164342U, // <4,5,7,4>: Cost 3 vext1 <2,4,5,7>, RHS
  2718748840U, // <4,5,7,5>: Cost 3 vext3 <5,6,7,4>, <5,7,5,7>
  2718748846U, // <4,5,7,6>: Cost 3 vext3 <5,6,7,4>, <5,7,6,4>
  2719412407U, // <4,5,7,7>: Cost 3 vext3 <5,7,7,4>, <5,7,7,4>
  2565166894U, // <4,5,7,u>: Cost 3 vext1 <2,4,5,7>, LHS
  1497399398U, // <4,5,u,0>: Cost 2 vext1 <3,4,5,u>, LHS
  1557780270U, // <4,5,u,1>: Cost 2 vext2 <2,3,4,5>, LHS
  2631522181U, // <4,5,u,2>: Cost 3 vext2 <2,3,4,5>, <u,2,3,0>
  1497401860U, // <4,5,u,3>: Cost 2 vext1 <3,4,5,u>, <3,4,5,u>
  1497402678U, // <4,5,u,4>: Cost 2 vext1 <3,4,5,u>, RHS
  1557780634U, // <4,5,u,5>: Cost 2 vext2 <2,3,4,5>, RHS
  2631522512U, // <4,5,u,6>: Cost 3 vext2 <2,3,4,5>, <u,6,3,7>
  27705344U, // <4,5,u,7>: Cost 0 copy RHS
  27705344U, // <4,5,u,u>: Cost 0 copy RHS
  2618916864U, // <4,6,0,0>: Cost 3 vext2 <0,2,4,6>, <0,0,0,0>
  1545175142U, // <4,6,0,1>: Cost 2 vext2 <0,2,4,6>, LHS
  1545175244U, // <4,6,0,2>: Cost 2 vext2 <0,2,4,6>, <0,2,4,6>
  3692658940U, // <4,6,0,3>: Cost 4 vext2 <0,2,4,6>, <0,3,1,0>
  2618917202U, // <4,6,0,4>: Cost 3 vext2 <0,2,4,6>, <0,4,1,5>
  3852910806U, // <4,6,0,5>: Cost 4 vuzpl RHS, <0,2,5,7>
  2253525648U, // <4,6,0,6>: Cost 3 vrev <6,4,6,0>
  4040764726U, // <4,6,0,7>: Cost 4 vzipr <2,3,4,0>, RHS
  1545175709U, // <4,6,0,u>: Cost 2 vext2 <0,2,4,6>, LHS
  2618917622U, // <4,6,1,0>: Cost 3 vext2 <0,2,4,6>, <1,0,3,2>
  2618917684U, // <4,6,1,1>: Cost 3 vext2 <0,2,4,6>, <1,1,1,1>
  2618917782U, // <4,6,1,2>: Cost 3 vext2 <0,2,4,6>, <1,2,3,0>
  2618917848U, // <4,6,1,3>: Cost 3 vext2 <0,2,4,6>, <1,3,1,3>
  3692659773U, // <4,6,1,4>: Cost 4 vext2 <0,2,4,6>, <1,4,3,5>
  2618918032U, // <4,6,1,5>: Cost 3 vext2 <0,2,4,6>, <1,5,3,7>
  3692659937U, // <4,6,1,6>: Cost 4 vext2 <0,2,4,6>, <1,6,3,7>
  4032146742U, // <4,6,1,7>: Cost 4 vzipr <0,u,4,1>, RHS
  2618918253U, // <4,6,1,u>: Cost 3 vext2 <0,2,4,6>, <1,u,1,3>
  2618918380U, // <4,6,2,0>: Cost 3 vext2 <0,2,4,6>, <2,0,6,4>
  2618918460U, // <4,6,2,1>: Cost 3 vext2 <0,2,4,6>, <2,1,6,3>
  2618918504U, // <4,6,2,2>: Cost 3 vext2 <0,2,4,6>, <2,2,2,2>
  2618918566U, // <4,6,2,3>: Cost 3 vext2 <0,2,4,6>, <2,3,0,1>
  2618918679U, // <4,6,2,4>: Cost 3 vext2 <0,2,4,6>, <2,4,3,6>
  2618918788U, // <4,6,2,5>: Cost 3 vext2 <0,2,4,6>, <2,5,6,7>
  2618918842U, // <4,6,2,6>: Cost 3 vext2 <0,2,4,6>, <2,6,3,7>
  2718749178U, // <4,6,2,7>: Cost 3 vext3 <5,6,7,4>, <6,2,7,3>
  2618918971U, // <4,6,2,u>: Cost 3 vext2 <0,2,4,6>, <2,u,0,1>
  2618919062U, // <4,6,3,0>: Cost 3 vext2 <0,2,4,6>, <3,0,1,2>
  2636171526U, // <4,6,3,1>: Cost 3 vext2 <3,1,4,6>, <3,1,4,6>
  3692661057U, // <4,6,3,2>: Cost 4 vext2 <0,2,4,6>, <3,2,2,2>
  2618919324U, // <4,6,3,3>: Cost 3 vext2 <0,2,4,6>, <3,3,3,3>
  2618919426U, // <4,6,3,4>: Cost 3 vext2 <0,2,4,6>, <3,4,5,6>
  2638826058U, // <4,6,3,5>: Cost 3 vext2 <3,5,4,6>, <3,5,4,6>
  3913303030U, // <4,6,3,6>: Cost 4 vuzpr <3,4,5,6>, <1,3,4,6>
  2722730572U, // <4,6,3,7>: Cost 3 vext3 <6,3,7,4>, <6,3,7,4>
  2618919710U, // <4,6,3,u>: Cost 3 vext2 <0,2,4,6>, <3,u,1,2>
  2565210214U, // <4,6,4,0>: Cost 3 vext1 <2,4,6,4>, LHS
  2718749286U, // <4,6,4,1>: Cost 3 vext3 <5,6,7,4>, <6,4,1,3>
  2565211952U, // <4,6,4,2>: Cost 3 vext1 <2,4,6,4>, <2,4,6,4>
  2571184649U, // <4,6,4,3>: Cost 3 vext1 <3,4,6,4>, <3,4,6,4>
  2565213494U, // <4,6,4,4>: Cost 3 vext1 <2,4,6,4>, RHS
  1545178422U, // <4,6,4,5>: Cost 2 vext2 <0,2,4,6>, RHS
  1705430326U, // <4,6,4,6>: Cost 2 vuzpl RHS, RHS
  2595075437U, // <4,6,4,7>: Cost 3 vext1 <7,4,6,4>, <7,4,6,4>
  1545178665U, // <4,6,4,u>: Cost 2 vext2 <0,2,4,6>, RHS
  2565218406U, // <4,6,5,0>: Cost 3 vext1 <2,4,6,5>, LHS
  2645462736U, // <4,6,5,1>: Cost 3 vext2 <4,6,4,6>, <5,1,7,3>
  2913399290U, // <4,6,5,2>: Cost 3 vzipl RHS, <6,2,7,3>
  3913305394U, // <4,6,5,3>: Cost 4 vuzpr <3,4,5,6>, <4,5,6,3>
  2645462982U, // <4,6,5,4>: Cost 3 vext2 <4,6,4,6>, <5,4,7,6>
  2779172868U, // <4,6,5,5>: Cost 3 vuzpl RHS, <5,5,5,5>
  2913391416U, // <4,6,5,6>: Cost 3 vzipl RHS, <6,6,6,6>
  2821426486U, // <4,6,5,7>: Cost 3 vuzpr <0,4,2,6>, RHS
  2821426487U, // <4,6,5,u>: Cost 3 vuzpr <0,4,2,6>, RHS
  1503428710U, // <4,6,6,0>: Cost 2 vext1 <4,4,6,6>, LHS
  2577171190U, // <4,6,6,1>: Cost 3 vext1 <4,4,6,6>, <1,0,3,2>
  2645463546U, // <4,6,6,2>: Cost 3 vext2 <4,6,4,6>, <6,2,7,3>
  2577172630U, // <4,6,6,3>: Cost 3 vext1 <4,4,6,6>, <3,0,1,2>
  1503431908U, // <4,6,6,4>: Cost 2 vext1 <4,4,6,6>, <4,4,6,6>
  2253501069U, // <4,6,6,5>: Cost 3 vrev <6,4,5,6>
  2618921784U, // <4,6,6,6>: Cost 3 vext2 <0,2,4,6>, <6,6,6,6>
  2954464566U, // <4,6,6,7>: Cost 3 vzipr <0,2,4,6>, RHS
  1503434542U, // <4,6,6,u>: Cost 2 vext1 <4,4,6,6>, LHS
  2645464058U, // <4,6,7,0>: Cost 3 vext2 <4,6,4,6>, <7,0,1,2>
  2779173882U, // <4,6,7,1>: Cost 3 vuzpl RHS, <7,0,1,2>
  3638978355U, // <4,6,7,2>: Cost 4 vext1 <2,4,6,7>, <2,4,6,7>
  2725090156U, // <4,6,7,3>: Cost 3 vext3 <6,7,3,4>, <6,7,3,4>
  2645464422U, // <4,6,7,4>: Cost 3 vext2 <4,6,4,6>, <7,4,5,6>
  2779174246U, // <4,6,7,5>: Cost 3 vuzpl RHS, <7,4,5,6>
  3852915914U, // <4,6,7,6>: Cost 4 vuzpl RHS, <7,2,6,3>
  2779174508U, // <4,6,7,7>: Cost 3 vuzpl RHS, <7,7,7,7>
  2779173945U, // <4,6,7,u>: Cost 3 vuzpl RHS, <7,0,u,2>
  1503445094U, // <4,6,u,0>: Cost 2 vext1 <4,4,6,u>, LHS
  1545180974U, // <4,6,u,1>: Cost 2 vext2 <0,2,4,6>, LHS
  1705432878U, // <4,6,u,2>: Cost 2 vuzpl RHS, LHS
  2618922940U, // <4,6,u,3>: Cost 3 vext2 <0,2,4,6>, <u,3,0,1>
  1503448294U, // <4,6,u,4>: Cost 2 vext1 <4,4,6,u>, <4,4,6,u>
  1545181338U, // <4,6,u,5>: Cost 2 vext2 <0,2,4,6>, RHS
  1705433242U, // <4,6,u,6>: Cost 2 vuzpl RHS, RHS
  2954480950U, // <4,6,u,7>: Cost 3 vzipr <0,2,4,u>, RHS
  1545181541U, // <4,6,u,u>: Cost 2 vext2 <0,2,4,6>, LHS
  3706601472U, // <4,7,0,0>: Cost 4 vext2 <2,5,4,7>, <0,0,0,0>
  2632859750U, // <4,7,0,1>: Cost 3 vext2 <2,5,4,7>, LHS
  2726343685U, // <4,7,0,2>: Cost 3 vext3 <7,0,2,4>, <7,0,2,4>
  3701293312U, // <4,7,0,3>: Cost 4 vext2 <1,6,4,7>, <0,3,1,4>
  3706601810U, // <4,7,0,4>: Cost 4 vext2 <2,5,4,7>, <0,4,1,5>
  2259424608U, // <4,7,0,5>: Cost 3 vrev <7,4,5,0>
  3695321617U, // <4,7,0,6>: Cost 4 vext2 <0,6,4,7>, <0,6,4,7>
  3800454194U, // <4,7,0,7>: Cost 4 vext3 <7,0,7,4>, <7,0,7,4>
  2632860317U, // <4,7,0,u>: Cost 3 vext2 <2,5,4,7>, LHS
  2259064116U, // <4,7,1,0>: Cost 3 vrev <7,4,0,1>
  3700630324U, // <4,7,1,1>: Cost 4 vext2 <1,5,4,7>, <1,1,1,1>
  2632860570U, // <4,7,1,2>: Cost 3 vext2 <2,5,4,7>, <1,2,3,4>
  3769635936U, // <4,7,1,3>: Cost 4 vext3 <1,u,3,4>, <7,1,3,5>
  3656920374U, // <4,7,1,4>: Cost 4 vext1 <5,4,7,1>, RHS
  3700630681U, // <4,7,1,5>: Cost 4 vext2 <1,5,4,7>, <1,5,4,7>
  3701294314U, // <4,7,1,6>: Cost 4 vext2 <1,6,4,7>, <1,6,4,7>
  3793818754U, // <4,7,1,7>: Cost 4 vext3 <5,u,7,4>, <7,1,7,3>
  2259654012U, // <4,7,1,u>: Cost 3 vrev <7,4,u,1>
  3656925286U, // <4,7,2,0>: Cost 4 vext1 <5,4,7,2>, LHS
  3706603050U, // <4,7,2,1>: Cost 4 vext2 <2,5,4,7>, <2,1,4,3>
  3706603112U, // <4,7,2,2>: Cost 4 vext2 <2,5,4,7>, <2,2,2,2>
  2727744688U, // <4,7,2,3>: Cost 3 vext3 <7,2,3,4>, <7,2,3,4>
  3705939745U, // <4,7,2,4>: Cost 4 vext2 <2,4,4,7>, <2,4,4,7>
  2632861554U, // <4,7,2,5>: Cost 3 vext2 <2,5,4,7>, <2,5,4,7>
  3706603450U, // <4,7,2,6>: Cost 4 vext2 <2,5,4,7>, <2,6,3,7>
  3792491731U, // <4,7,2,7>: Cost 4 vext3 <5,6,7,4>, <7,2,7,3>
  2634852453U, // <4,7,2,u>: Cost 3 vext2 <2,u,4,7>, <2,u,4,7>
  3706603670U, // <4,7,3,0>: Cost 4 vext2 <2,5,4,7>, <3,0,1,2>
  3662906266U, // <4,7,3,1>: Cost 4 vext1 <6,4,7,3>, <1,2,3,4>
  3725183326U, // <4,7,3,2>: Cost 4 vext2 <5,6,4,7>, <3,2,5,4>
  3706603932U, // <4,7,3,3>: Cost 4 vext2 <2,5,4,7>, <3,3,3,3>
  3701295618U, // <4,7,3,4>: Cost 4 vext2 <1,6,4,7>, <3,4,5,6>
  2638834251U, // <4,7,3,5>: Cost 3 vext2 <3,5,4,7>, <3,5,4,7>
  2639497884U, // <4,7,3,6>: Cost 3 vext2 <3,6,4,7>, <3,6,4,7>
  3802445093U, // <4,7,3,7>: Cost 4 vext3 <7,3,7,4>, <7,3,7,4>
  2640825150U, // <4,7,3,u>: Cost 3 vext2 <3,u,4,7>, <3,u,4,7>
  2718750004U, // <4,7,4,0>: Cost 3 vext3 <5,6,7,4>, <7,4,0,1>
  3706604490U, // <4,7,4,1>: Cost 4 vext2 <2,5,4,7>, <4,1,2,3>
  3656943474U, // <4,7,4,2>: Cost 4 vext1 <5,4,7,4>, <2,5,4,7>
  3779884371U, // <4,7,4,3>: Cost 4 vext3 <3,5,7,4>, <7,4,3,5>
  2259383643U, // <4,7,4,4>: Cost 3 vrev <7,4,4,4>
  2632863030U, // <4,7,4,5>: Cost 3 vext2 <2,5,4,7>, RHS
  2259531117U, // <4,7,4,6>: Cost 3 vrev <7,4,6,4>
  3907340074U, // <4,7,4,7>: Cost 4 vuzpr <2,4,5,7>, <2,4,5,7>
  2632863273U, // <4,7,4,u>: Cost 3 vext2 <2,5,4,7>, RHS
  2913391610U, // <4,7,5,0>: Cost 3 vzipl RHS, <7,0,1,2>
  3645006848U, // <4,7,5,1>: Cost 4 vext1 <3,4,7,5>, <1,3,5,7>
  2589181646U, // <4,7,5,2>: Cost 3 vext1 <6,4,7,5>, <2,3,4,5>
  3645008403U, // <4,7,5,3>: Cost 4 vext1 <3,4,7,5>, <3,4,7,5>
  2913391974U, // <4,7,5,4>: Cost 3 vzipl RHS, <7,4,5,6>
  2583211973U, // <4,7,5,5>: Cost 3 vext1 <5,4,7,5>, <5,4,7,5>
  2589184670U, // <4,7,5,6>: Cost 3 vext1 <6,4,7,5>, <6,4,7,5>
  2913392236U, // <4,7,5,7>: Cost 3 vzipl RHS, <7,7,7,7>
  2913392258U, // <4,7,5,u>: Cost 3 vzipl RHS, <7,u,1,2>
  1509474406U, // <4,7,6,0>: Cost 2 vext1 <5,4,7,6>, LHS
  3047609338U, // <4,7,6,1>: Cost 3 vtrnl RHS, <7,0,1,2>
  2583217768U, // <4,7,6,2>: Cost 3 vext1 <5,4,7,6>, <2,2,2,2>
  2583218326U, // <4,7,6,3>: Cost 3 vext1 <5,4,7,6>, <3,0,1,2>
  1509477686U, // <4,7,6,4>: Cost 2 vext1 <5,4,7,6>, RHS
  1509478342U, // <4,7,6,5>: Cost 2 vext1 <5,4,7,6>, <5,4,7,6>
  2583220730U, // <4,7,6,6>: Cost 3 vext1 <5,4,7,6>, <6,2,7,3>
  3047609964U, // <4,7,6,7>: Cost 3 vtrnl RHS, <7,7,7,7>
  1509480238U, // <4,7,6,u>: Cost 2 vext1 <5,4,7,6>, LHS
  3650994278U, // <4,7,7,0>: Cost 4 vext1 <4,4,7,7>, LHS
  3650995098U, // <4,7,7,1>: Cost 4 vext1 <4,4,7,7>, <1,2,3,4>
  3650996010U, // <4,7,7,2>: Cost 4 vext1 <4,4,7,7>, <2,4,5,7>
  3804804677U, // <4,7,7,3>: Cost 4 vext3 <7,7,3,4>, <7,7,3,4>
  3650997486U, // <4,7,7,4>: Cost 4 vext1 <4,4,7,7>, <4,4,7,7>
  2662725039U, // <4,7,7,5>: Cost 3 vext2 <7,5,4,7>, <7,5,4,7>
  3662942880U, // <4,7,7,6>: Cost 4 vext1 <6,4,7,7>, <6,4,7,7>
  2718750316U, // <4,7,7,7>: Cost 3 vext3 <5,6,7,4>, <7,7,7,7>
  2664715938U, // <4,7,7,u>: Cost 3 vext2 <7,u,4,7>, <7,u,4,7>
  1509490790U, // <4,7,u,0>: Cost 2 vext1 <5,4,7,u>, LHS
  2632865582U, // <4,7,u,1>: Cost 3 vext2 <2,5,4,7>, LHS
  2583234152U, // <4,7,u,2>: Cost 3 vext1 <5,4,7,u>, <2,2,2,2>
  2583234710U, // <4,7,u,3>: Cost 3 vext1 <5,4,7,u>, <3,0,1,2>
  1509494070U, // <4,7,u,4>: Cost 2 vext1 <5,4,7,u>, RHS
  1509494728U, // <4,7,u,5>: Cost 2 vext1 <5,4,7,u>, <5,4,7,u>
  2583237114U, // <4,7,u,6>: Cost 3 vext1 <5,4,7,u>, <6,2,7,3>
  3047757420U, // <4,7,u,7>: Cost 3 vtrnl RHS, <7,7,7,7>
  1509496622U, // <4,7,u,u>: Cost 2 vext1 <5,4,7,u>, LHS
  2618933248U, // <4,u,0,0>: Cost 3 vext2 <0,2,4,u>, <0,0,0,0>
  1545191526U, // <4,u,0,1>: Cost 2 vext2 <0,2,4,u>, LHS
  1545191630U, // <4,u,0,2>: Cost 2 vext2 <0,2,4,u>, <0,2,4,u>
  2691913445U, // <4,u,0,3>: Cost 3 vext3 <1,2,3,4>, <u,0,3,2>
  2618933586U, // <4,u,0,4>: Cost 3 vext2 <0,2,4,u>, <0,4,1,5>
  2265397305U, // <4,u,0,5>: Cost 3 vrev <u,4,5,0>
  2595189625U, // <4,u,0,6>: Cost 3 vext1 <7,4,u,0>, <6,7,4,u>
  2595190139U, // <4,u,0,7>: Cost 3 vext1 <7,4,u,0>, <7,4,u,0>
  1545192093U, // <4,u,0,u>: Cost 2 vext2 <0,2,4,u>, LHS
  2618934006U, // <4,u,1,0>: Cost 3 vext2 <0,2,4,u>, <1,0,3,2>
  2618934068U, // <4,u,1,1>: Cost 3 vext2 <0,2,4,u>, <1,1,1,1>
  1618171694U, // <4,u,1,2>: Cost 2 vext3 <1,2,3,4>, LHS
  2618934232U, // <4,u,1,3>: Cost 3 vext2 <0,2,4,u>, <1,3,1,3>
  2695894848U, // <4,u,1,4>: Cost 3 vext3 <1,u,3,4>, <u,1,4,3>
  2618934416U, // <4,u,1,5>: Cost 3 vext2 <0,2,4,u>, <1,5,3,7>
  3692676321U, // <4,u,1,6>: Cost 4 vext2 <0,2,4,u>, <1,6,3,7>
  2718750555U, // <4,u,1,7>: Cost 3 vext3 <5,6,7,4>, <u,1,7,3>
  1618171748U, // <4,u,1,u>: Cost 2 vext3 <1,2,3,4>, LHS
  2553397350U, // <4,u,2,0>: Cost 3 vext1 <0,4,u,2>, LHS
  2630215215U, // <4,u,2,1>: Cost 3 vext2 <2,1,4,u>, <2,1,4,u>
  2618934888U, // <4,u,2,2>: Cost 3 vext2 <0,2,4,u>, <2,2,2,2>
  1557800657U, // <4,u,2,3>: Cost 2 vext2 <2,3,4,u>, <2,3,4,u>
  2618935065U, // <4,u,2,4>: Cost 3 vext2 <0,2,4,u>, <2,4,3,u>
  2733864859U, // <4,u,2,5>: Cost 3 vext3 <u,2,5,4>, <u,2,5,4>
  2618935226U, // <4,u,2,6>: Cost 3 vext2 <0,2,4,u>, <2,6,3,7>
  2718750636U, // <4,u,2,7>: Cost 3 vext3 <5,6,7,4>, <u,2,7,3>
  1561118822U, // <4,u,2,u>: Cost 2 vext2 <2,u,4,u>, <2,u,4,u>
  2618935446U, // <4,u,3,0>: Cost 3 vext2 <0,2,4,u>, <3,0,1,2>
  2779318422U, // <4,u,3,1>: Cost 3 vuzpl RHS, <3,0,1,2>
  2636851545U, // <4,u,3,2>: Cost 3 vext2 <3,2,4,u>, <3,2,4,u>
  2618935708U, // <4,u,3,3>: Cost 3 vext2 <0,2,4,u>, <3,3,3,3>
  2618935810U, // <4,u,3,4>: Cost 3 vext2 <0,2,4,u>, <3,4,5,6>
  2691913711U, // <4,u,3,5>: Cost 3 vext3 <1,2,3,4>, <u,3,5,7>
  2588725862U, // <4,u,3,6>: Cost 3 vext1 <6,4,1,3>, <6,4,1,3>
  2640169710U, // <4,u,3,7>: Cost 3 vext2 <3,7,4,u>, <3,7,4,u>
  2618936094U, // <4,u,3,u>: Cost 3 vext2 <0,2,4,u>, <3,u,1,2>
  1503559782U, // <4,u,4,0>: Cost 2 vext1 <4,4,u,4>, LHS
  2692282391U, // <4,u,4,1>: Cost 3 vext3 <1,2,u,4>, <u,4,1,2>
  2565359426U, // <4,u,4,2>: Cost 3 vext1 <2,4,u,4>, <2,4,u,4>
  2571332123U, // <4,u,4,3>: Cost 3 vext1 <3,4,u,4>, <3,4,u,4>
  161926454U, // <4,u,4,4>: Cost 1 vdup0 RHS
  1545194806U, // <4,u,4,5>: Cost 2 vext2 <0,2,4,u>, RHS
  1705577782U, // <4,u,4,6>: Cost 2 vuzpl RHS, RHS
  2718750801U, // <4,u,4,7>: Cost 3 vext3 <5,6,7,4>, <u,4,7,6>
  161926454U, // <4,u,4,u>: Cost 1 vdup0 RHS
  1479164006U, // <4,u,5,0>: Cost 2 vext1 <0,4,1,5>, LHS
  1839650606U, // <4,u,5,1>: Cost 2 vzipl RHS, LHS
  2565367502U, // <4,u,5,2>: Cost 3 vext1 <2,4,u,5>, <2,3,4,5>
  3089777309U, // <4,u,5,3>: Cost 3 vtrnr <0,4,1,5>, LHS
  1479167286U, // <4,u,5,4>: Cost 2 vext1 <0,4,1,5>, RHS
  1839650970U, // <4,u,5,5>: Cost 2 vzipl RHS, RHS
  1618172058U, // <4,u,5,6>: Cost 2 vext3 <1,2,3,4>, RHS
  3089780265U, // <4,u,5,7>: Cost 3 vtrnr <0,4,1,5>, RHS
  1618172076U, // <4,u,5,u>: Cost 2 vext3 <1,2,3,4>, RHS
  1479688294U, // <4,u,6,0>: Cost 2 vext1 <0,4,u,6>, LHS
  2553430774U, // <4,u,6,1>: Cost 3 vext1 <0,4,u,6>, <1,0,3,2>
  1973868334U, // <4,u,6,2>: Cost 2 vtrnl RHS, LHS
  1497606685U, // <4,u,6,3>: Cost 2 vext1 <3,4,u,6>, <3,4,u,6>
  1479691574U, // <4,u,6,4>: Cost 2 vext1 <0,4,u,6>, RHS
  1509552079U, // <4,u,6,5>: Cost 2 vext1 <5,4,u,6>, <5,4,u,6>
  1973868698U, // <4,u,6,6>: Cost 2 vtrnl RHS, RHS
  27705344U, // <4,u,6,7>: Cost 0 copy RHS
  27705344U, // <4,u,6,u>: Cost 0 copy RHS
  2565382246U, // <4,u,7,0>: Cost 3 vext1 <2,4,u,7>, LHS
  2565383066U, // <4,u,7,1>: Cost 3 vext1 <2,4,u,7>, <1,2,3,4>
  2565384005U, // <4,u,7,2>: Cost 3 vext1 <2,4,u,7>, <2,4,u,7>
  2661405966U, // <4,u,7,3>: Cost 3 vext2 <7,3,4,u>, <7,3,4,u>
  2565385526U, // <4,u,7,4>: Cost 3 vext1 <2,4,u,7>, RHS
  2779321702U, // <4,u,7,5>: Cost 3 vuzpl RHS, <7,4,5,6>
  2589274793U, // <4,u,7,6>: Cost 3 vext1 <6,4,u,7>, <6,4,u,7>
  2779321964U, // <4,u,7,7>: Cost 3 vuzpl RHS, <7,7,7,7>
  2565388078U, // <4,u,7,u>: Cost 3 vext1 <2,4,u,7>, LHS
  1479704678U, // <4,u,u,0>: Cost 2 vext1 <0,4,u,u>, LHS
  1545197358U, // <4,u,u,1>: Cost 2 vext2 <0,2,4,u>, LHS
  1618172261U, // <4,u,u,2>: Cost 2 vext3 <1,2,3,4>, LHS
  1497623071U, // <4,u,u,3>: Cost 2 vext1 <3,4,u,u>, <3,4,u,u>
  161926454U, // <4,u,u,4>: Cost 1 vdup0 RHS
  1545197722U, // <4,u,u,5>: Cost 2 vext2 <0,2,4,u>, RHS
  1618172301U, // <4,u,u,6>: Cost 2 vext3 <1,2,3,4>, RHS
  27705344U, // <4,u,u,7>: Cost 0 copy RHS
  27705344U, // <4,u,u,u>: Cost 0 copy RHS
  2687123456U, // <5,0,0,0>: Cost 3 vext3 <0,4,1,5>, <0,0,0,0>
  2687123466U, // <5,0,0,1>: Cost 3 vext3 <0,4,1,5>, <0,0,1,1>
  2687123476U, // <5,0,0,2>: Cost 3 vext3 <0,4,1,5>, <0,0,2,2>
  3710599434U, // <5,0,0,3>: Cost 4 vext2 <3,2,5,0>, <0,3,2,5>
  2642166098U, // <5,0,0,4>: Cost 3 vext2 <4,1,5,0>, <0,4,1,5>
  3657060306U, // <5,0,0,5>: Cost 4 vext1 <5,5,0,0>, <5,5,0,0>
  3292094923U, // <5,0,0,6>: Cost 4 vrev <0,5,6,0>
  3669005700U, // <5,0,0,7>: Cost 4 vext1 <7,5,0,0>, <7,5,0,0>
  2687123530U, // <5,0,0,u>: Cost 3 vext3 <0,4,1,5>, <0,0,u,2>
  2559434854U, // <5,0,1,0>: Cost 3 vext1 <1,5,0,1>, LHS
  2559435887U, // <5,0,1,1>: Cost 3 vext1 <1,5,0,1>, <1,5,0,1>
  1613381734U, // <5,0,1,2>: Cost 2 vext3 <0,4,1,5>, LHS
  3698656256U, // <5,0,1,3>: Cost 4 vext2 <1,2,5,0>, <1,3,5,7>
  2559438134U, // <5,0,1,4>: Cost 3 vext1 <1,5,0,1>, RHS
  2583326675U, // <5,0,1,5>: Cost 3 vext1 <5,5,0,1>, <5,5,0,1>
  3715908851U, // <5,0,1,6>: Cost 4 vext2 <4,1,5,0>, <1,6,5,7>
  3657069562U, // <5,0,1,7>: Cost 4 vext1 <5,5,0,1>, <7,0,1,2>
  1613381788U, // <5,0,1,u>: Cost 2 vext3 <0,4,1,5>, LHS
  2686017700U, // <5,0,2,0>: Cost 3 vext3 <0,2,4,5>, <0,2,0,2>
  2685796528U, // <5,0,2,1>: Cost 3 vext3 <0,2,1,5>, <0,2,1,5>
  2698625208U, // <5,0,2,2>: Cost 3 vext3 <2,3,4,5>, <0,2,2,4>
  2685944002U, // <5,0,2,3>: Cost 3 vext3 <0,2,3,5>, <0,2,3,5>
  2686017739U, // <5,0,2,4>: Cost 3 vext3 <0,2,4,5>, <0,2,4,5>
  2686091476U, // <5,0,2,5>: Cost 3 vext3 <0,2,5,5>, <0,2,5,5>
  2725167324U, // <5,0,2,6>: Cost 3 vext3 <6,7,4,5>, <0,2,6,4>
  2595280230U, // <5,0,2,7>: Cost 3 vext1 <7,5,0,2>, <7,4,5,6>
  2686312687U, // <5,0,2,u>: Cost 3 vext3 <0,2,u,5>, <0,2,u,5>
  3760128248U, // <5,0,3,0>: Cost 4 vext3 <0,3,0,5>, <0,3,0,5>
  3759685888U, // <5,0,3,1>: Cost 4 vext3 <0,2,3,5>, <0,3,1,4>
  2686533898U, // <5,0,3,2>: Cost 3 vext3 <0,3,2,5>, <0,3,2,5>
  3760349459U, // <5,0,3,3>: Cost 4 vext3 <0,3,3,5>, <0,3,3,5>
  2638187004U, // <5,0,3,4>: Cost 3 vext2 <3,4,5,0>, <3,4,5,0>
  3776348452U, // <5,0,3,5>: Cost 4 vext3 <3,0,4,5>, <0,3,5,4>
  3713256094U, // <5,0,3,6>: Cost 4 vext2 <3,6,5,0>, <3,6,5,0>
  3914064896U, // <5,0,3,7>: Cost 4 vuzpr <3,5,7,0>, <1,3,5,7>
  2686976320U, // <5,0,3,u>: Cost 3 vext3 <0,3,u,5>, <0,3,u,5>
  2559459430U, // <5,0,4,0>: Cost 3 vext1 <1,5,0,4>, LHS
  1613381970U, // <5,0,4,1>: Cost 2 vext3 <0,4,1,5>, <0,4,1,5>
  2687123804U, // <5,0,4,2>: Cost 3 vext3 <0,4,1,5>, <0,4,2,6>
  3761013092U, // <5,0,4,3>: Cost 4 vext3 <0,4,3,5>, <0,4,3,5>
  2559462710U, // <5,0,4,4>: Cost 3 vext1 <1,5,0,4>, RHS
  2638187830U, // <5,0,4,5>: Cost 3 vext2 <3,4,5,0>, RHS
  3761234303U, // <5,0,4,6>: Cost 4 vext3 <0,4,6,5>, <0,4,6,5>
  2646150600U, // <5,0,4,7>: Cost 3 vext2 <4,7,5,0>, <4,7,5,0>
  1613381970U, // <5,0,4,u>: Cost 2 vext3 <0,4,1,5>, <0,4,1,5>
  3766763926U, // <5,0,5,0>: Cost 4 vext3 <1,4,0,5>, <0,5,0,1>
  2919268454U, // <5,0,5,1>: Cost 3 vzipl <5,5,5,5>, LHS
  3053486182U, // <5,0,5,2>: Cost 3 vtrnl <5,5,5,5>, LHS
  3723210589U, // <5,0,5,3>: Cost 4 vext2 <5,3,5,0>, <5,3,5,0>
  3766763966U, // <5,0,5,4>: Cost 4 vext3 <1,4,0,5>, <0,5,4,5>
  2650796031U, // <5,0,5,5>: Cost 3 vext2 <5,5,5,0>, <5,5,5,0>
  3719893090U, // <5,0,5,6>: Cost 4 vext2 <4,7,5,0>, <5,6,7,0>
  3914067254U, // <5,0,5,7>: Cost 4 vuzpr <3,5,7,0>, RHS
  2919269021U, // <5,0,5,u>: Cost 3 vzipl <5,5,5,5>, LHS
  4047519744U, // <5,0,6,0>: Cost 4 vzipr <3,4,5,6>, <0,0,0,0>
  2920038502U, // <5,0,6,1>: Cost 3 vzipl <5,6,7,0>, LHS
  3759759871U, // <5,0,6,2>: Cost 4 vext3 <0,2,4,5>, <0,6,2,7>
  3645164070U, // <5,0,6,3>: Cost 4 vext1 <3,5,0,6>, <3,5,0,6>
  3762414095U, // <5,0,6,4>: Cost 4 vext3 <0,6,4,5>, <0,6,4,5>
  3993780690U, // <5,0,6,5>: Cost 4 vzipl <5,6,7,0>, <0,5,6,7>
  3719893816U, // <5,0,6,6>: Cost 4 vext2 <4,7,5,0>, <6,6,6,6>
  2662077302U, // <5,0,6,7>: Cost 3 vext2 <7,4,5,0>, <6,7,4,5>
  2920039069U, // <5,0,6,u>: Cost 3 vzipl <5,6,7,0>, LHS
  2565455974U, // <5,0,7,0>: Cost 3 vext1 <2,5,0,7>, LHS
  2565456790U, // <5,0,7,1>: Cost 3 vext1 <2,5,0,7>, <1,2,3,0>
  2565457742U, // <5,0,7,2>: Cost 3 vext1 <2,5,0,7>, <2,5,0,7>
  3639199894U, // <5,0,7,3>: Cost 4 vext1 <2,5,0,7>, <3,0,1,2>
  2565459254U, // <5,0,7,4>: Cost 3 vext1 <2,5,0,7>, RHS
  2589347938U, // <5,0,7,5>: Cost 3 vext1 <6,5,0,7>, <5,6,7,0>
  2589348530U, // <5,0,7,6>: Cost 3 vext1 <6,5,0,7>, <6,5,0,7>
  4188456422U, // <5,0,7,7>: Cost 4 vtrnr RHS, <2,0,5,7>
  2565461806U, // <5,0,7,u>: Cost 3 vext1 <2,5,0,7>, LHS
  2687124106U, // <5,0,u,0>: Cost 3 vext3 <0,4,1,5>, <0,u,0,2>
  1616036502U, // <5,0,u,1>: Cost 2 vext3 <0,u,1,5>, <0,u,1,5>
  1613382301U, // <5,0,u,2>: Cost 2 vext3 <0,4,1,5>, LHS
  2689925800U, // <5,0,u,3>: Cost 3 vext3 <0,u,3,5>, <0,u,3,5>
  2687124146U, // <5,0,u,4>: Cost 3 vext3 <0,4,1,5>, <0,u,4,6>
  2638190746U, // <5,0,u,5>: Cost 3 vext2 <3,4,5,0>, RHS
  2589356723U, // <5,0,u,6>: Cost 3 vext1 <6,5,0,u>, <6,5,0,u>
  2595280230U, // <5,0,u,7>: Cost 3 vext1 <7,5,0,2>, <7,4,5,6>
  1613382355U, // <5,0,u,u>: Cost 2 vext3 <0,4,1,5>, LHS
  2646818816U, // <5,1,0,0>: Cost 3 vext2 <4,u,5,1>, <0,0,0,0>
  1573077094U, // <5,1,0,1>: Cost 2 vext2 <4,u,5,1>, LHS
  2646818980U, // <5,1,0,2>: Cost 3 vext2 <4,u,5,1>, <0,2,0,2>
  2687124214U, // <5,1,0,3>: Cost 3 vext3 <0,4,1,5>, <1,0,3,2>
  2641510738U, // <5,1,0,4>: Cost 3 vext2 <4,0,5,1>, <0,4,1,5>
  2641510814U, // <5,1,0,5>: Cost 3 vext2 <4,0,5,1>, <0,5,1,0>
  3720561142U, // <5,1,0,6>: Cost 4 vext2 <4,u,5,1>, <0,6,1,7>
  3298141357U, // <5,1,0,7>: Cost 4 vrev <1,5,7,0>
  1573077661U, // <5,1,0,u>: Cost 2 vext2 <4,u,5,1>, LHS
  2223891567U, // <5,1,1,0>: Cost 3 vrev <1,5,0,1>
  2687124276U, // <5,1,1,1>: Cost 3 vext3 <0,4,1,5>, <1,1,1,1>
  2646819734U, // <5,1,1,2>: Cost 3 vext2 <4,u,5,1>, <1,2,3,0>
  2687124296U, // <5,1,1,3>: Cost 3 vext3 <0,4,1,5>, <1,1,3,3>
  2691326803U, // <5,1,1,4>: Cost 3 vext3 <1,1,4,5>, <1,1,4,5>
  2691400540U, // <5,1,1,5>: Cost 3 vext3 <1,1,5,5>, <1,1,5,5>
  3765216101U, // <5,1,1,6>: Cost 4 vext3 <1,1,6,5>, <1,1,6,5>
  3765289838U, // <5,1,1,7>: Cost 4 vext3 <1,1,7,5>, <1,1,7,5>
  2687124341U, // <5,1,1,u>: Cost 3 vext3 <0,4,1,5>, <1,1,u,3>
  3297641584U, // <5,1,2,0>: Cost 4 vrev <1,5,0,2>
  3763520391U, // <5,1,2,1>: Cost 4 vext3 <0,u,1,5>, <1,2,1,3>
  2646820456U, // <5,1,2,2>: Cost 3 vext2 <4,u,5,1>, <2,2,2,2>
  2687124374U, // <5,1,2,3>: Cost 3 vext3 <0,4,1,5>, <1,2,3,0>
  2691990436U, // <5,1,2,4>: Cost 3 vext3 <1,2,4,5>, <1,2,4,5>
  2687124395U, // <5,1,2,5>: Cost 3 vext3 <0,4,1,5>, <1,2,5,3>
  2646820794U, // <5,1,2,6>: Cost 3 vext2 <4,u,5,1>, <2,6,3,7>
  3808199610U, // <5,1,2,7>: Cost 4 vext3 <u,3,4,5>, <1,2,7,0>
  2687124419U, // <5,1,2,u>: Cost 3 vext3 <0,4,1,5>, <1,2,u,0>
  2577440870U, // <5,1,3,0>: Cost 3 vext1 <4,5,1,3>, LHS
  2687124440U, // <5,1,3,1>: Cost 3 vext3 <0,4,1,5>, <1,3,1,3>
  3759686627U, // <5,1,3,2>: Cost 4 vext3 <0,2,3,5>, <1,3,2,5>
  2692580332U, // <5,1,3,3>: Cost 3 vext3 <1,3,3,5>, <1,3,3,5>
  2687124469U, // <5,1,3,4>: Cost 3 vext3 <0,4,1,5>, <1,3,4,5>
  2685207552U, // <5,1,3,5>: Cost 3 vext3 <0,1,2,5>, <1,3,5,7>
  3760866313U, // <5,1,3,6>: Cost 4 vext3 <0,4,1,5>, <1,3,6,7>
  2692875280U, // <5,1,3,7>: Cost 3 vext3 <1,3,7,5>, <1,3,7,5>
  2687124503U, // <5,1,3,u>: Cost 3 vext3 <0,4,1,5>, <1,3,u,3>
  1567771538U, // <5,1,4,0>: Cost 2 vext2 <4,0,5,1>, <4,0,5,1>
  2693096491U, // <5,1,4,1>: Cost 3 vext3 <1,4,1,5>, <1,4,1,5>
  2693170228U, // <5,1,4,2>: Cost 3 vext3 <1,4,2,5>, <1,4,2,5>
  2687124541U, // <5,1,4,3>: Cost 3 vext3 <0,4,1,5>, <1,4,3,5>
  2646822096U, // <5,1,4,4>: Cost 3 vext2 <4,u,5,1>, <4,4,4,4>
  1573080374U, // <5,1,4,5>: Cost 2 vext2 <4,u,5,1>, RHS
  2646822260U, // <5,1,4,6>: Cost 3 vext2 <4,u,5,1>, <4,6,4,6>
  3298174129U, // <5,1,4,7>: Cost 4 vrev <1,5,7,4>
  1573080602U, // <5,1,4,u>: Cost 2 vext2 <4,u,5,1>, <4,u,5,1>
  2687124591U, // <5,1,5,0>: Cost 3 vext3 <0,4,1,5>, <1,5,0,1>
  2646822543U, // <5,1,5,1>: Cost 3 vext2 <4,u,5,1>, <5,1,0,1>
  3760866433U, // <5,1,5,2>: Cost 4 vext3 <0,4,1,5>, <1,5,2,1>
  2687124624U, // <5,1,5,3>: Cost 3 vext3 <0,4,1,5>, <1,5,3,7>
  2687124631U, // <5,1,5,4>: Cost 3 vext3 <0,4,1,5>, <1,5,4,5>
  2646822916U, // <5,1,5,5>: Cost 3 vext2 <4,u,5,1>, <5,5,5,5>
  2646823010U, // <5,1,5,6>: Cost 3 vext2 <4,u,5,1>, <5,6,7,0>
  2646823080U, // <5,1,5,7>: Cost 3 vext2 <4,u,5,1>, <5,7,5,7>
  2687124663U, // <5,1,5,u>: Cost 3 vext3 <0,4,1,5>, <1,5,u,1>
  2553577574U, // <5,1,6,0>: Cost 3 vext1 <0,5,1,6>, LHS
  3763520719U, // <5,1,6,1>: Cost 4 vext3 <0,u,1,5>, <1,6,1,7>
  2646823418U, // <5,1,6,2>: Cost 3 vext2 <4,u,5,1>, <6,2,7,3>
  3760866529U, // <5,1,6,3>: Cost 4 vext3 <0,4,1,5>, <1,6,3,7>
  2553580854U, // <5,1,6,4>: Cost 3 vext1 <0,5,1,6>, RHS
  2687124723U, // <5,1,6,5>: Cost 3 vext3 <0,4,1,5>, <1,6,5,7>
  2646823736U, // <5,1,6,6>: Cost 3 vext2 <4,u,5,1>, <6,6,6,6>
  2646823758U, // <5,1,6,7>: Cost 3 vext2 <4,u,5,1>, <6,7,0,1>
  2646823839U, // <5,1,6,u>: Cost 3 vext2 <4,u,5,1>, <6,u,0,1>
  2559557734U, // <5,1,7,0>: Cost 3 vext1 <1,5,1,7>, LHS
  2559558452U, // <5,1,7,1>: Cost 3 vext1 <1,5,1,7>, <1,1,1,1>
  2571503270U, // <5,1,7,2>: Cost 3 vext1 <3,5,1,7>, <2,3,0,1>
  2040971366U, // <5,1,7,3>: Cost 2 vtrnr RHS, LHS
  2559561014U, // <5,1,7,4>: Cost 3 vext1 <1,5,1,7>, RHS
  2595393232U, // <5,1,7,5>: Cost 3 vext1 <7,5,1,7>, <5,1,7,3>
  4188455035U, // <5,1,7,6>: Cost 4 vtrnr RHS, <0,1,4,6>
  2646824556U, // <5,1,7,7>: Cost 3 vext2 <4,u,5,1>, <7,7,7,7>
  2040971371U, // <5,1,7,u>: Cost 2 vtrnr RHS, LHS
  1591662326U, // <5,1,u,0>: Cost 2 vext2 <u,0,5,1>, <u,0,5,1>
  1573082926U, // <5,1,u,1>: Cost 2 vext2 <4,u,5,1>, LHS
  2695824760U, // <5,1,u,2>: Cost 3 vext3 <1,u,2,5>, <1,u,2,5>
  2040979558U, // <5,1,u,3>: Cost 2 vtrnr RHS, LHS
  2687124874U, // <5,1,u,4>: Cost 3 vext3 <0,4,1,5>, <1,u,4,5>
  1573083290U, // <5,1,u,5>: Cost 2 vext2 <4,u,5,1>, RHS
  2646825168U, // <5,1,u,6>: Cost 3 vext2 <4,u,5,1>, <u,6,3,7>
  2646825216U, // <5,1,u,7>: Cost 3 vext2 <4,u,5,1>, <u,7,0,1>
  2040979563U, // <5,1,u,u>: Cost 2 vtrnr RHS, LHS
  3702652928U, // <5,2,0,0>: Cost 4 vext2 <1,u,5,2>, <0,0,0,0>
  2628911206U, // <5,2,0,1>: Cost 3 vext2 <1,u,5,2>, LHS
  2641518756U, // <5,2,0,2>: Cost 3 vext2 <4,0,5,2>, <0,2,0,2>
  3759760847U, // <5,2,0,3>: Cost 4 vext3 <0,2,4,5>, <2,0,3,2>
  3760866775U, // <5,2,0,4>: Cost 4 vext3 <0,4,1,5>, <2,0,4,1>
  3759539680U, // <5,2,0,5>: Cost 4 vext3 <0,2,1,5>, <2,0,5,1>
  3760866796U, // <5,2,0,6>: Cost 4 vext3 <0,4,1,5>, <2,0,6,4>
  3304114054U, // <5,2,0,7>: Cost 4 vrev <2,5,7,0>
  2628911773U, // <5,2,0,u>: Cost 3 vext2 <1,u,5,2>, LHS
  2623603464U, // <5,2,1,0>: Cost 3 vext2 <1,0,5,2>, <1,0,5,2>
  3698008921U, // <5,2,1,1>: Cost 4 vext2 <1,1,5,2>, <1,1,5,2>
  3633325603U, // <5,2,1,2>: Cost 4 vext1 <1,5,2,1>, <2,1,3,5>
  2687125027U, // <5,2,1,3>: Cost 3 vext3 <0,4,1,5>, <2,1,3,5>
  3633327414U, // <5,2,1,4>: Cost 4 vext1 <1,5,2,1>, RHS
  3759539760U, // <5,2,1,5>: Cost 4 vext3 <0,2,1,5>, <2,1,5,0>
  3760866876U, // <5,2,1,6>: Cost 4 vext3 <0,4,1,5>, <2,1,6,3>
  3304122247U, // <5,2,1,7>: Cost 4 vrev <2,5,7,1>
  2687125072U, // <5,2,1,u>: Cost 3 vext3 <0,4,1,5>, <2,1,u,5>
  3633332326U, // <5,2,2,0>: Cost 4 vext1 <1,5,2,2>, LHS
  3759760992U, // <5,2,2,1>: Cost 4 vext3 <0,2,4,5>, <2,2,1,3>
  2687125096U, // <5,2,2,2>: Cost 3 vext3 <0,4,1,5>, <2,2,2,2>
  2687125106U, // <5,2,2,3>: Cost 3 vext3 <0,4,1,5>, <2,2,3,3>
  2697963133U, // <5,2,2,4>: Cost 3 vext3 <2,2,4,5>, <2,2,4,5>
  3759466120U, // <5,2,2,5>: Cost 4 vext3 <0,2,0,5>, <2,2,5,7>
  3760866960U, // <5,2,2,6>: Cost 4 vext3 <0,4,1,5>, <2,2,6,6>
  3771926168U, // <5,2,2,7>: Cost 4 vext3 <2,2,7,5>, <2,2,7,5>
  2687125151U, // <5,2,2,u>: Cost 3 vext3 <0,4,1,5>, <2,2,u,3>
  2687125158U, // <5,2,3,0>: Cost 3 vext3 <0,4,1,5>, <2,3,0,1>
  2698405555U, // <5,2,3,1>: Cost 3 vext3 <2,3,1,5>, <2,3,1,5>
  2577516238U, // <5,2,3,2>: Cost 3 vext1 <4,5,2,3>, <2,3,4,5>
  3759687365U, // <5,2,3,3>: Cost 4 vext3 <0,2,3,5>, <2,3,3,5>
  1624884942U, // <5,2,3,4>: Cost 2 vext3 <2,3,4,5>, <2,3,4,5>
  2698700503U, // <5,2,3,5>: Cost 3 vext3 <2,3,5,5>, <2,3,5,5>
  3772368608U, // <5,2,3,6>: Cost 4 vext3 <2,3,4,5>, <2,3,6,5>
  3702655716U, // <5,2,3,7>: Cost 4 vext2 <1,u,5,2>, <3,7,3,7>
  1625179890U, // <5,2,3,u>: Cost 2 vext3 <2,3,u,5>, <2,3,u,5>
  2641521555U, // <5,2,4,0>: Cost 3 vext2 <4,0,5,2>, <4,0,5,2>
  3772368642U, // <5,2,4,1>: Cost 4 vext3 <2,3,4,5>, <2,4,1,3>
  2699142925U, // <5,2,4,2>: Cost 3 vext3 <2,4,2,5>, <2,4,2,5>
  2698626838U, // <5,2,4,3>: Cost 3 vext3 <2,3,4,5>, <2,4,3,5>
  2698626848U, // <5,2,4,4>: Cost 3 vext3 <2,3,4,5>, <2,4,4,6>
  2628914486U, // <5,2,4,5>: Cost 3 vext2 <1,u,5,2>, RHS
  2645503353U, // <5,2,4,6>: Cost 3 vext2 <4,6,5,2>, <4,6,5,2>
  3304146826U, // <5,2,4,7>: Cost 4 vrev <2,5,7,4>
  2628914729U, // <5,2,4,u>: Cost 3 vext2 <1,u,5,2>, RHS
  2553643110U, // <5,2,5,0>: Cost 3 vext1 <0,5,2,5>, LHS
  3758950227U, // <5,2,5,1>: Cost 4 vext3 <0,1,2,5>, <2,5,1,3>
  3759761248U, // <5,2,5,2>: Cost 4 vext3 <0,2,4,5>, <2,5,2,7>
  2982396006U, // <5,2,5,3>: Cost 3 vzipr <4,u,5,5>, LHS
  2553646390U, // <5,2,5,4>: Cost 3 vext1 <0,5,2,5>, RHS
  2553647108U, // <5,2,5,5>: Cost 3 vext1 <0,5,2,5>, <5,5,5,5>
  3760867204U, // <5,2,5,6>: Cost 4 vext3 <0,4,1,5>, <2,5,6,7>
  3702657141U, // <5,2,5,7>: Cost 4 vext2 <1,u,5,2>, <5,7,0,1>
  2982396011U, // <5,2,5,u>: Cost 3 vzipr <4,u,5,5>, LHS
  3627393126U, // <5,2,6,0>: Cost 4 vext1 <0,5,2,6>, LHS
  3760867236U, // <5,2,6,1>: Cost 4 vext3 <0,4,1,5>, <2,6,1,3>
  2645504506U, // <5,2,6,2>: Cost 3 vext2 <4,6,5,2>, <6,2,7,3>
  2687125434U, // <5,2,6,3>: Cost 3 vext3 <0,4,1,5>, <2,6,3,7>
  2700617665U, // <5,2,6,4>: Cost 3 vext3 <2,6,4,5>, <2,6,4,5>
  3760867276U, // <5,2,6,5>: Cost 4 vext3 <0,4,1,5>, <2,6,5,7>
  3763521493U, // <5,2,6,6>: Cost 4 vext3 <0,u,1,5>, <2,6,6,7>
  3719246670U, // <5,2,6,7>: Cost 4 vext2 <4,6,5,2>, <6,7,0,1>
  2687125479U, // <5,2,6,u>: Cost 3 vext3 <0,4,1,5>, <2,6,u,7>
  2565603430U, // <5,2,7,0>: Cost 3 vext1 <2,5,2,7>, LHS
  2553660150U, // <5,2,7,1>: Cost 3 vext1 <0,5,2,7>, <1,0,3,2>
  2565605216U, // <5,2,7,2>: Cost 3 vext1 <2,5,2,7>, <2,5,2,7>
  2961178726U, // <5,2,7,3>: Cost 3 vzipr <1,3,5,7>, LHS
  2565606710U, // <5,2,7,4>: Cost 3 vext1 <2,5,2,7>, RHS
  4034920552U, // <5,2,7,5>: Cost 4 vzipr <1,3,5,7>, <0,1,2,5>
  3114713292U, // <5,2,7,6>: Cost 3 vtrnr RHS, <0,2,4,6>
  3702658668U, // <5,2,7,7>: Cost 4 vext2 <1,u,5,2>, <7,7,7,7>
  2961178731U, // <5,2,7,u>: Cost 3 vzipr <1,3,5,7>, LHS
  2687125563U, // <5,2,u,0>: Cost 3 vext3 <0,4,1,5>, <2,u,0,1>
  2628917038U, // <5,2,u,1>: Cost 3 vext2 <1,u,5,2>, LHS
  2565613409U, // <5,2,u,2>: Cost 3 vext1 <2,5,2,u>, <2,5,2,u>
  2687125592U, // <5,2,u,3>: Cost 3 vext3 <0,4,1,5>, <2,u,3,3>
  1628203107U, // <5,2,u,4>: Cost 2 vext3 <2,u,4,5>, <2,u,4,5>
  2628917402U, // <5,2,u,5>: Cost 3 vext2 <1,u,5,2>, RHS
  2702092405U, // <5,2,u,6>: Cost 3 vext3 <2,u,6,5>, <2,u,6,5>
  3304179598U, // <5,2,u,7>: Cost 4 vrev <2,5,7,u>
  1628498055U, // <5,2,u,u>: Cost 2 vext3 <2,u,u,5>, <2,u,u,5>
  3760867467U, // <5,3,0,0>: Cost 4 vext3 <0,4,1,5>, <3,0,0,0>
  2687125654U, // <5,3,0,1>: Cost 3 vext3 <0,4,1,5>, <3,0,1,2>
  3759761565U, // <5,3,0,2>: Cost 4 vext3 <0,2,4,5>, <3,0,2,0>
  3633391766U, // <5,3,0,3>: Cost 4 vext1 <1,5,3,0>, <3,0,1,2>
  2687125680U, // <5,3,0,4>: Cost 3 vext3 <0,4,1,5>, <3,0,4,1>
  3760277690U, // <5,3,0,5>: Cost 4 vext3 <0,3,2,5>, <3,0,5,2>
  3310013014U, // <5,3,0,6>: Cost 4 vrev <3,5,6,0>
  2236344927U, // <5,3,0,7>: Cost 3 vrev <3,5,7,0>
  2687125717U, // <5,3,0,u>: Cost 3 vext3 <0,4,1,5>, <3,0,u,2>
  3760867551U, // <5,3,1,0>: Cost 4 vext3 <0,4,1,5>, <3,1,0,3>
  3760867558U, // <5,3,1,1>: Cost 4 vext3 <0,4,1,5>, <3,1,1,1>
  2624938923U, // <5,3,1,2>: Cost 3 vext2 <1,2,5,3>, <1,2,5,3>
  2703198460U, // <5,3,1,3>: Cost 3 vext3 <3,1,3,5>, <3,1,3,5>
  3760867587U, // <5,3,1,4>: Cost 4 vext3 <0,4,1,5>, <3,1,4,3>
  2636219536U, // <5,3,1,5>: Cost 3 vext2 <3,1,5,3>, <1,5,3,7>
  3698681075U, // <5,3,1,6>: Cost 4 vext2 <1,2,5,3>, <1,6,5,7>
  2703493408U, // <5,3,1,7>: Cost 3 vext3 <3,1,7,5>, <3,1,7,5>
  2628920721U, // <5,3,1,u>: Cost 3 vext2 <1,u,5,3>, <1,u,5,3>
  3766765870U, // <5,3,2,0>: Cost 4 vext3 <1,4,0,5>, <3,2,0,1>
  3698681379U, // <5,3,2,1>: Cost 4 vext2 <1,2,5,3>, <2,1,3,5>
  3760867649U, // <5,3,2,2>: Cost 4 vext3 <0,4,1,5>, <3,2,2,2>
  2698627404U, // <5,3,2,3>: Cost 3 vext3 <2,3,4,5>, <3,2,3,4>
  2703935830U, // <5,3,2,4>: Cost 3 vext3 <3,2,4,5>, <3,2,4,5>
  2698627422U, // <5,3,2,5>: Cost 3 vext3 <2,3,4,5>, <3,2,5,4>
  3760867686U, // <5,3,2,6>: Cost 4 vext3 <0,4,1,5>, <3,2,6,3>
  3769788783U, // <5,3,2,7>: Cost 4 vext3 <1,u,5,5>, <3,2,7,3>
  2701945209U, // <5,3,2,u>: Cost 3 vext3 <2,u,4,5>, <3,2,u,4>
  3760867711U, // <5,3,3,0>: Cost 4 vext3 <0,4,1,5>, <3,3,0,1>
  2636220684U, // <5,3,3,1>: Cost 3 vext2 <3,1,5,3>, <3,1,5,3>
  3772369298U, // <5,3,3,2>: Cost 4 vext3 <2,3,4,5>, <3,3,2,2>
  2687125916U, // <5,3,3,3>: Cost 3 vext3 <0,4,1,5>, <3,3,3,3>
  2704599463U, // <5,3,3,4>: Cost 3 vext3 <3,3,4,5>, <3,3,4,5>
  2704673200U, // <5,3,3,5>: Cost 3 vext3 <3,3,5,5>, <3,3,5,5>
  3709962935U, // <5,3,3,6>: Cost 4 vext2 <3,1,5,3>, <3,6,7,7>
  3772369346U, // <5,3,3,7>: Cost 4 vext3 <2,3,4,5>, <3,3,7,5>
  2704894411U, // <5,3,3,u>: Cost 3 vext3 <3,3,u,5>, <3,3,u,5>
  2704968148U, // <5,3,4,0>: Cost 3 vext3 <3,4,0,5>, <3,4,0,5>
  3698682850U, // <5,3,4,1>: Cost 4 vext2 <1,2,5,3>, <4,1,5,0>
  2642857014U, // <5,3,4,2>: Cost 3 vext2 <4,2,5,3>, <4,2,5,3>
  2705189359U, // <5,3,4,3>: Cost 3 vext3 <3,4,3,5>, <3,4,3,5>
  2705263096U, // <5,3,4,4>: Cost 3 vext3 <3,4,4,5>, <3,4,4,5>
  2685946370U, // <5,3,4,5>: Cost 3 vext3 <0,2,3,5>, <3,4,5,6>
  3779152394U, // <5,3,4,6>: Cost 4 vext3 <3,4,6,5>, <3,4,6,5>
  2236377699U, // <5,3,4,7>: Cost 3 vrev <3,5,7,4>
  2687126045U, // <5,3,4,u>: Cost 3 vext3 <0,4,1,5>, <3,4,u,6>
  2571632742U, // <5,3,5,0>: Cost 3 vext1 <3,5,3,5>, LHS
  2559689870U, // <5,3,5,1>: Cost 3 vext1 <1,5,3,5>, <1,5,3,5>
  2571634382U, // <5,3,5,2>: Cost 3 vext1 <3,5,3,5>, <2,3,4,5>
  2571635264U, // <5,3,5,3>: Cost 3 vext1 <3,5,3,5>, <3,5,3,5>
  2571636022U, // <5,3,5,4>: Cost 3 vext1 <3,5,3,5>, RHS
  2559692804U, // <5,3,5,5>: Cost 3 vext1 <1,5,3,5>, <5,5,5,5>
  3720581218U, // <5,3,5,6>: Cost 4 vext2 <4,u,5,3>, <5,6,7,0>
  2236385892U, // <5,3,5,7>: Cost 3 vrev <3,5,7,5>
  2571638574U, // <5,3,5,u>: Cost 3 vext1 <3,5,3,5>, LHS
  2565668966U, // <5,3,6,0>: Cost 3 vext1 <2,5,3,6>, LHS
  3633439887U, // <5,3,6,1>: Cost 4 vext1 <1,5,3,6>, <1,5,3,6>
  2565670760U, // <5,3,6,2>: Cost 3 vext1 <2,5,3,6>, <2,5,3,6>
  2565671426U, // <5,3,6,3>: Cost 3 vext1 <2,5,3,6>, <3,4,5,6>
  2565672246U, // <5,3,6,4>: Cost 3 vext1 <2,5,3,6>, RHS
  3639414630U, // <5,3,6,5>: Cost 4 vext1 <2,5,3,6>, <5,3,6,0>
  4047521640U, // <5,3,6,6>: Cost 4 vzipr <3,4,5,6>, <2,5,3,6>
  2725169844U, // <5,3,6,7>: Cost 3 vext3 <6,7,4,5>, <3,6,7,4>
  2565674798U, // <5,3,6,u>: Cost 3 vext1 <2,5,3,6>, LHS
  1485963366U, // <5,3,7,0>: Cost 2 vext1 <1,5,3,7>, LHS
  1485964432U, // <5,3,7,1>: Cost 2 vext1 <1,5,3,7>, <1,5,3,7>
  2559706728U, // <5,3,7,2>: Cost 3 vext1 <1,5,3,7>, <2,2,2,2>
  2559707286U, // <5,3,7,3>: Cost 3 vext1 <1,5,3,7>, <3,0,1,2>
  1485966646U, // <5,3,7,4>: Cost 2 vext1 <1,5,3,7>, RHS
  2559708880U, // <5,3,7,5>: Cost 3 vext1 <1,5,3,7>, <5,1,7,3>
  2601513466U, // <5,3,7,6>: Cost 3 vext1 <u,5,3,7>, <6,2,7,3>
  3114714112U, // <5,3,7,7>: Cost 3 vtrnr RHS, <1,3,5,7>
  1485969198U, // <5,3,7,u>: Cost 2 vext1 <1,5,3,7>, LHS
  1485971558U, // <5,3,u,0>: Cost 2 vext1 <1,5,3,u>, LHS
  1485972625U, // <5,3,u,1>: Cost 2 vext1 <1,5,3,u>, <1,5,3,u>
  2559714920U, // <5,3,u,2>: Cost 3 vext1 <1,5,3,u>, <2,2,2,2>
  2559715478U, // <5,3,u,3>: Cost 3 vext1 <1,5,3,u>, <3,0,1,2>
  1485974838U, // <5,3,u,4>: Cost 2 vext1 <1,5,3,u>, RHS
  2687126342U, // <5,3,u,5>: Cost 3 vext3 <0,4,1,5>, <3,u,5,6>
  2601521658U, // <5,3,u,6>: Cost 3 vext1 <u,5,3,u>, <6,2,7,3>
  2236410471U, // <5,3,u,7>: Cost 3 vrev <3,5,7,u>
  1485977390U, // <5,3,u,u>: Cost 2 vext1 <1,5,3,u>, LHS
  3627491430U, // <5,4,0,0>: Cost 4 vext1 <0,5,4,0>, LHS
  2636890214U, // <5,4,0,1>: Cost 3 vext2 <3,2,5,4>, LHS
  3703333028U, // <5,4,0,2>: Cost 4 vext2 <2,0,5,4>, <0,2,0,2>
  3782249348U, // <5,4,0,3>: Cost 4 vext3 <4,0,3,5>, <4,0,3,5>
  2642198866U, // <5,4,0,4>: Cost 3 vext2 <4,1,5,4>, <0,4,1,5>
  2687126418U, // <5,4,0,5>: Cost 3 vext3 <0,4,1,5>, <4,0,5,1>
  2242243887U, // <5,4,0,6>: Cost 3 vrev <4,5,6,0>
  3316059448U, // <5,4,0,7>: Cost 4 vrev <4,5,7,0>
  2636890781U, // <5,4,0,u>: Cost 3 vext2 <3,2,5,4>, LHS
  2241809658U, // <5,4,1,0>: Cost 3 vrev <4,5,0,1>
  3698025307U, // <5,4,1,1>: Cost 4 vext2 <1,1,5,4>, <1,1,5,4>
  3698688940U, // <5,4,1,2>: Cost 4 vext2 <1,2,5,4>, <1,2,5,4>
  3698689024U, // <5,4,1,3>: Cost 4 vext2 <1,2,5,4>, <1,3,5,7>
  3700016206U, // <5,4,1,4>: Cost 4 vext2 <1,4,5,4>, <1,4,5,4>
  2687126498U, // <5,4,1,5>: Cost 3 vext3 <0,4,1,5>, <4,1,5,0>
  3760868336U, // <5,4,1,6>: Cost 4 vext3 <0,4,1,5>, <4,1,6,5>
  3316067641U, // <5,4,1,7>: Cost 4 vrev <4,5,7,1>
  2242399554U, // <5,4,1,u>: Cost 3 vrev <4,5,u,1>
  3703334371U, // <5,4,2,0>: Cost 4 vext2 <2,0,5,4>, <2,0,5,4>
  3703998004U, // <5,4,2,1>: Cost 4 vext2 <2,1,5,4>, <2,1,5,4>
  3704661637U, // <5,4,2,2>: Cost 4 vext2 <2,2,5,4>, <2,2,5,4>
  2636891854U, // <5,4,2,3>: Cost 3 vext2 <3,2,5,4>, <2,3,4,5>
  3705988903U, // <5,4,2,4>: Cost 4 vext2 <2,4,5,4>, <2,4,5,4>
  2698628150U, // <5,4,2,5>: Cost 3 vext3 <2,3,4,5>, <4,2,5,3>
  3760868415U, // <5,4,2,6>: Cost 4 vext3 <0,4,1,5>, <4,2,6,3>
  3783871562U, // <5,4,2,7>: Cost 4 vext3 <4,2,7,5>, <4,2,7,5>
  2666752099U, // <5,4,2,u>: Cost 3 vext2 <u,2,5,4>, <2,u,4,5>
  3639459942U, // <5,4,3,0>: Cost 4 vext1 <2,5,4,3>, LHS
  3709970701U, // <5,4,3,1>: Cost 4 vext2 <3,1,5,4>, <3,1,5,4>
  2636892510U, // <5,4,3,2>: Cost 3 vext2 <3,2,5,4>, <3,2,5,4>
  3710634396U, // <5,4,3,3>: Cost 4 vext2 <3,2,5,4>, <3,3,3,3>
  2638219776U, // <5,4,3,4>: Cost 3 vext2 <3,4,5,4>, <3,4,5,4>
  3766987908U, // <5,4,3,5>: Cost 4 vext3 <1,4,3,5>, <4,3,5,0>
  2710719634U, // <5,4,3,6>: Cost 3 vext3 <4,3,6,5>, <4,3,6,5>
  3914097664U, // <5,4,3,7>: Cost 4 vuzpr <3,5,7,4>, <1,3,5,7>
  2640874308U, // <5,4,3,u>: Cost 3 vext2 <3,u,5,4>, <3,u,5,4>
  2583642214U, // <5,4,4,0>: Cost 3 vext1 <5,5,4,4>, LHS
  2642201574U, // <5,4,4,1>: Cost 3 vext2 <4,1,5,4>, <4,1,5,4>
  3710635062U, // <5,4,4,2>: Cost 4 vext2 <3,2,5,4>, <4,2,5,3>
  3717270664U, // <5,4,4,3>: Cost 4 vext2 <4,3,5,4>, <4,3,5,4>
  2713963728U, // <5,4,4,4>: Cost 3 vext3 <4,u,5,5>, <4,4,4,4>
  1637567706U, // <5,4,4,5>: Cost 2 vext3 <4,4,5,5>, <4,4,5,5>
  2242276659U, // <5,4,4,6>: Cost 3 vrev <4,5,6,4>
  2646183372U, // <5,4,4,7>: Cost 3 vext2 <4,7,5,4>, <4,7,5,4>
  1637788917U, // <5,4,4,u>: Cost 2 vext3 <4,4,u,5>, <4,4,u,5>
  2559762534U, // <5,4,5,0>: Cost 3 vext1 <1,5,4,5>, LHS
  2559763607U, // <5,4,5,1>: Cost 3 vext1 <1,5,4,5>, <1,5,4,5>
  2698628366U, // <5,4,5,2>: Cost 3 vext3 <2,3,4,5>, <4,5,2,3>
  3633506454U, // <5,4,5,3>: Cost 4 vext1 <1,5,4,5>, <3,0,1,2>
  2559765814U, // <5,4,5,4>: Cost 3 vext1 <1,5,4,5>, RHS
  2583654395U, // <5,4,5,5>: Cost 3 vext1 <5,5,4,5>, <5,5,4,5>
  1613385014U, // <5,4,5,6>: Cost 2 vext3 <0,4,1,5>, RHS
  3901639990U, // <5,4,5,7>: Cost 4 vuzpr <1,5,0,4>, RHS
  1613385032U, // <5,4,5,u>: Cost 2 vext3 <0,4,1,5>, RHS
  2559770726U, // <5,4,6,0>: Cost 3 vext1 <1,5,4,6>, LHS
  2559771648U, // <5,4,6,1>: Cost 3 vext1 <1,5,4,6>, <1,3,5,7>
  3633514088U, // <5,4,6,2>: Cost 4 vext1 <1,5,4,6>, <2,2,2,2>
  2571717122U, // <5,4,6,3>: Cost 3 vext1 <3,5,4,6>, <3,4,5,6>
  2559774006U, // <5,4,6,4>: Cost 3 vext1 <1,5,4,6>, RHS
  2712636796U, // <5,4,6,5>: Cost 3 vext3 <4,6,5,5>, <4,6,5,5>
  3760868743U, // <5,4,6,6>: Cost 4 vext3 <0,4,1,5>, <4,6,6,7>
  2712784270U, // <5,4,6,7>: Cost 3 vext3 <4,6,7,5>, <4,6,7,5>
  2559776558U, // <5,4,6,u>: Cost 3 vext1 <1,5,4,6>, LHS
  2565750886U, // <5,4,7,0>: Cost 3 vext1 <2,5,4,7>, LHS
  2565751706U, // <5,4,7,1>: Cost 3 vext1 <2,5,4,7>, <1,2,3,4>
  2565752690U, // <5,4,7,2>: Cost 3 vext1 <2,5,4,7>, <2,5,4,7>
  2571725387U, // <5,4,7,3>: Cost 3 vext1 <3,5,4,7>, <3,5,4,7>
  2565754166U, // <5,4,7,4>: Cost 3 vext1 <2,5,4,7>, RHS
  3114713426U, // <5,4,7,5>: Cost 3 vtrnr RHS, <0,4,1,5>
  94817590U, // <5,4,7,6>: Cost 1 vrev RHS
  2595616175U, // <5,4,7,7>: Cost 3 vext1 <7,5,4,7>, <7,5,4,7>
  94965064U, // <5,4,7,u>: Cost 1 vrev RHS
  2559787110U, // <5,4,u,0>: Cost 3 vext1 <1,5,4,u>, LHS
  2559788186U, // <5,4,u,1>: Cost 3 vext1 <1,5,4,u>, <1,5,4,u>
  2242014483U, // <5,4,u,2>: Cost 3 vrev <4,5,2,u>
  2667419628U, // <5,4,u,3>: Cost 3 vext2 <u,3,5,4>, <u,3,5,4>
  2559790390U, // <5,4,u,4>: Cost 3 vext1 <1,5,4,u>, RHS
  1640222238U, // <5,4,u,5>: Cost 2 vext3 <4,u,5,5>, <4,u,5,5>
  94825783U, // <5,4,u,6>: Cost 1 vrev RHS
  2714111536U, // <5,4,u,7>: Cost 3 vext3 <4,u,7,5>, <4,u,7,5>
  94973257U, // <5,4,u,u>: Cost 1 vrev RHS
  2646851584U, // <5,5,0,0>: Cost 3 vext2 <4,u,5,5>, <0,0,0,0>
  1573109862U, // <5,5,0,1>: Cost 2 vext2 <4,u,5,5>, LHS
  2646851748U, // <5,5,0,2>: Cost 3 vext2 <4,u,5,5>, <0,2,0,2>
  3760279130U, // <5,5,0,3>: Cost 4 vext3 <0,3,2,5>, <5,0,3,2>
  2687127138U, // <5,5,0,4>: Cost 3 vext3 <0,4,1,5>, <5,0,4,1>
  2248142847U, // <5,5,0,5>: Cost 3 vrev <5,5,5,0>
  3720593910U, // <5,5,0,6>: Cost 4 vext2 <4,u,5,5>, <0,6,1,7>
  4182502710U, // <5,5,0,7>: Cost 4 vtrnr <3,5,7,0>, RHS
  1573110429U, // <5,5,0,u>: Cost 2 vext2 <4,u,5,5>, LHS
  2646852342U, // <5,5,1,0>: Cost 3 vext2 <4,u,5,5>, <1,0,3,2>
  2624291676U, // <5,5,1,1>: Cost 3 vext2 <1,1,5,5>, <1,1,5,5>
  2646852502U, // <5,5,1,2>: Cost 3 vext2 <4,u,5,5>, <1,2,3,0>
  2646852568U, // <5,5,1,3>: Cost 3 vext2 <4,u,5,5>, <1,3,1,3>
  2715217591U, // <5,5,1,4>: Cost 3 vext3 <5,1,4,5>, <5,1,4,5>
  2628936848U, // <5,5,1,5>: Cost 3 vext2 <1,u,5,5>, <1,5,3,7>
  3698033907U, // <5,5,1,6>: Cost 4 vext2 <1,1,5,5>, <1,6,5,7>
  2713964240U, // <5,5,1,7>: Cost 3 vext3 <4,u,5,5>, <5,1,7,3>
  2628937107U, // <5,5,1,u>: Cost 3 vext2 <1,u,5,5>, <1,u,5,5>
  3645497446U, // <5,5,2,0>: Cost 4 vext1 <3,5,5,2>, LHS
  3760869099U, // <5,5,2,1>: Cost 4 vext3 <0,4,1,5>, <5,2,1,3>
  2646853224U, // <5,5,2,2>: Cost 3 vext2 <4,u,5,5>, <2,2,2,2>
  2698628862U, // <5,5,2,3>: Cost 3 vext3 <2,3,4,5>, <5,2,3,4>
  3772370694U, // <5,5,2,4>: Cost 4 vext3 <2,3,4,5>, <5,2,4,3>
  2713964303U, // <5,5,2,5>: Cost 3 vext3 <4,u,5,5>, <5,2,5,3>
  2646853562U, // <5,5,2,6>: Cost 3 vext2 <4,u,5,5>, <2,6,3,7>
  4038198272U, // <5,5,2,7>: Cost 4 vzipr <1,u,5,2>, <1,3,5,7>
  2701946667U, // <5,5,2,u>: Cost 3 vext3 <2,u,4,5>, <5,2,u,4>
  2646853782U, // <5,5,3,0>: Cost 3 vext2 <4,u,5,5>, <3,0,1,2>
  3698034922U, // <5,5,3,1>: Cost 4 vext2 <1,1,5,5>, <3,1,1,5>
  3702679919U, // <5,5,3,2>: Cost 4 vext2 <1,u,5,5>, <3,2,7,3>
  2637564336U, // <5,5,3,3>: Cost 3 vext2 <3,3,5,5>, <3,3,5,5>
  2646854146U, // <5,5,3,4>: Cost 3 vext2 <4,u,5,5>, <3,4,5,6>
  2638891602U, // <5,5,3,5>: Cost 3 vext2 <3,5,5,5>, <3,5,5,5>
  3702680247U, // <5,5,3,6>: Cost 4 vext2 <1,u,5,5>, <3,6,7,7>
  3702680259U, // <5,5,3,7>: Cost 4 vext2 <1,u,5,5>, <3,7,0,1>
  2646854430U, // <5,5,3,u>: Cost 3 vext2 <4,u,5,5>, <3,u,1,2>
  2646854546U, // <5,5,4,0>: Cost 3 vext2 <4,u,5,5>, <4,0,5,1>
  2642209767U, // <5,5,4,1>: Cost 3 vext2 <4,1,5,5>, <4,1,5,5>
  3711306806U, // <5,5,4,2>: Cost 4 vext2 <3,3,5,5>, <4,2,5,3>
  3645516369U, // <5,5,4,3>: Cost 4 vext1 <3,5,5,4>, <3,5,5,4>
  1570458842U, // <5,5,4,4>: Cost 2 vext2 <4,4,5,5>, <4,4,5,5>
  1573113142U, // <5,5,4,5>: Cost 2 vext2 <4,u,5,5>, RHS
  2645527932U, // <5,5,4,6>: Cost 3 vext2 <4,6,5,5>, <4,6,5,5>
  2713964486U, // <5,5,4,7>: Cost 3 vext3 <4,u,5,5>, <5,4,7,6>
  1573113374U, // <5,5,4,u>: Cost 2 vext2 <4,u,5,5>, <4,u,5,5>
  1509982310U, // <5,5,5,0>: Cost 2 vext1 <5,5,5,5>, LHS
  2646855376U, // <5,5,5,1>: Cost 3 vext2 <4,u,5,5>, <5,1,7,3>
  2583725672U, // <5,5,5,2>: Cost 3 vext1 <5,5,5,5>, <2,2,2,2>
  2583726230U, // <5,5,5,3>: Cost 3 vext1 <5,5,5,5>, <3,0,1,2>
  1509985590U, // <5,5,5,4>: Cost 2 vext1 <5,5,5,5>, RHS
  229035318U, // <5,5,5,5>: Cost 1 vdup1 RHS
  2646855778U, // <5,5,5,6>: Cost 3 vext2 <4,u,5,5>, <5,6,7,0>
  2646855848U, // <5,5,5,7>: Cost 3 vext2 <4,u,5,5>, <5,7,5,7>
  229035318U, // <5,5,5,u>: Cost 1 vdup1 RHS
  2577760358U, // <5,5,6,0>: Cost 3 vext1 <4,5,5,6>, LHS
  3633587361U, // <5,5,6,1>: Cost 4 vext1 <1,5,5,6>, <1,5,5,6>
  2646856186U, // <5,5,6,2>: Cost 3 vext2 <4,u,5,5>, <6,2,7,3>
  3633588738U, // <5,5,6,3>: Cost 4 vext1 <1,5,5,6>, <3,4,5,6>
  2718535756U, // <5,5,6,4>: Cost 3 vext3 <5,6,4,5>, <5,6,4,5>
  2644202223U, // <5,5,6,5>: Cost 3 vext2 <4,4,5,5>, <6,5,7,5>
  2973780482U, // <5,5,6,6>: Cost 3 vzipr <3,4,5,6>, <3,4,5,6>
  2646856526U, // <5,5,6,7>: Cost 3 vext2 <4,u,5,5>, <6,7,0,1>
  2646856607U, // <5,5,6,u>: Cost 3 vext2 <4,u,5,5>, <6,u,0,1>
  2571796582U, // <5,5,7,0>: Cost 3 vext1 <3,5,5,7>, LHS
  3633595392U, // <5,5,7,1>: Cost 4 vext1 <1,5,5,7>, <1,3,5,7>
  2571798222U, // <5,5,7,2>: Cost 3 vext1 <3,5,5,7>, <2,3,4,5>
  2571799124U, // <5,5,7,3>: Cost 3 vext1 <3,5,5,7>, <3,5,5,7>
  2571799862U, // <5,5,7,4>: Cost 3 vext1 <3,5,5,7>, RHS
  3114717188U, // <5,5,7,5>: Cost 3 vtrnr RHS, <5,5,5,5>
  4034923010U, // <5,5,7,6>: Cost 4 vzipr <1,3,5,7>, <3,4,5,6>
  2040974646U, // <5,5,7,7>: Cost 2 vtrnr RHS, RHS
  2040974647U, // <5,5,7,u>: Cost 2 vtrnr RHS, RHS
  1509982310U, // <5,5,u,0>: Cost 2 vext1 <5,5,5,5>, LHS
  1573115694U, // <5,5,u,1>: Cost 2 vext2 <4,u,5,5>, LHS
  2571806414U, // <5,5,u,2>: Cost 3 vext1 <3,5,5,u>, <2,3,4,5>
  2571807317U, // <5,5,u,3>: Cost 3 vext1 <3,5,5,u>, <3,5,5,u>
  1509985590U, // <5,5,u,4>: Cost 2 vext1 <5,5,5,5>, RHS
  229035318U, // <5,5,u,5>: Cost 1 vdup1 RHS
  2646857936U, // <5,5,u,6>: Cost 3 vext2 <4,u,5,5>, <u,6,3,7>
  2040982838U, // <5,5,u,7>: Cost 2 vtrnr RHS, RHS
  229035318U, // <5,5,u,u>: Cost 1 vdup1 RHS
  2638233600U, // <5,6,0,0>: Cost 3 vext2 <3,4,5,6>, <0,0,0,0>
  1564491878U, // <5,6,0,1>: Cost 2 vext2 <3,4,5,6>, LHS
  2632261796U, // <5,6,0,2>: Cost 3 vext2 <2,4,5,6>, <0,2,0,2>
  2638233856U, // <5,6,0,3>: Cost 3 vext2 <3,4,5,6>, <0,3,1,4>
  2638233938U, // <5,6,0,4>: Cost 3 vext2 <3,4,5,6>, <0,4,1,5>
  3706003885U, // <5,6,0,5>: Cost 4 vext2 <2,4,5,6>, <0,5,2,6>
  3706003967U, // <5,6,0,6>: Cost 4 vext2 <2,4,5,6>, <0,6,2,7>
  4047473974U, // <5,6,0,7>: Cost 4 vzipr <3,4,5,0>, RHS
  1564492445U, // <5,6,0,u>: Cost 2 vext2 <3,4,5,6>, LHS
  2638234358U, // <5,6,1,0>: Cost 3 vext2 <3,4,5,6>, <1,0,3,2>
  2638234420U, // <5,6,1,1>: Cost 3 vext2 <3,4,5,6>, <1,1,1,1>
  2638234518U, // <5,6,1,2>: Cost 3 vext2 <3,4,5,6>, <1,2,3,0>
  2638234584U, // <5,6,1,3>: Cost 3 vext2 <3,4,5,6>, <1,3,1,3>
  2626290768U, // <5,6,1,4>: Cost 3 vext2 <1,4,5,6>, <1,4,5,6>
  2638234768U, // <5,6,1,5>: Cost 3 vext2 <3,4,5,6>, <1,5,3,7>
  3700032719U, // <5,6,1,6>: Cost 4 vext2 <1,4,5,6>, <1,6,1,7>
  2982366518U, // <5,6,1,7>: Cost 3 vzipr <4,u,5,1>, RHS
  2628945300U, // <5,6,1,u>: Cost 3 vext2 <1,u,5,6>, <1,u,5,6>
  3706004925U, // <5,6,2,0>: Cost 4 vext2 <2,4,5,6>, <2,0,1,2>
  3711976966U, // <5,6,2,1>: Cost 4 vext2 <3,4,5,6>, <2,1,0,3>
  2638235240U, // <5,6,2,2>: Cost 3 vext2 <3,4,5,6>, <2,2,2,2>
  2638235302U, // <5,6,2,3>: Cost 3 vext2 <3,4,5,6>, <2,3,0,1>
  2632263465U, // <5,6,2,4>: Cost 3 vext2 <2,4,5,6>, <2,4,5,6>
  2638235496U, // <5,6,2,5>: Cost 3 vext2 <3,4,5,6>, <2,5,3,6>
  2638235578U, // <5,6,2,6>: Cost 3 vext2 <3,4,5,6>, <2,6,3,7>
  2713965050U, // <5,6,2,7>: Cost 3 vext3 <4,u,5,5>, <6,2,7,3>
  2634917997U, // <5,6,2,u>: Cost 3 vext2 <2,u,5,6>, <2,u,5,6>
  2638235798U, // <5,6,3,0>: Cost 3 vext2 <3,4,5,6>, <3,0,1,2>
  3711977695U, // <5,6,3,1>: Cost 4 vext2 <3,4,5,6>, <3,1,0,3>
  3710650720U, // <5,6,3,2>: Cost 4 vext2 <3,2,5,6>, <3,2,5,6>
  2638236060U, // <5,6,3,3>: Cost 3 vext2 <3,4,5,6>, <3,3,3,3>
  1564494338U, // <5,6,3,4>: Cost 2 vext2 <3,4,5,6>, <3,4,5,6>
  2638236234U, // <5,6,3,5>: Cost 3 vext2 <3,4,5,6>, <3,5,4,6>
  3711978104U, // <5,6,3,6>: Cost 4 vext2 <3,4,5,6>, <3,6,0,7>
  4034227510U, // <5,6,3,7>: Cost 4 vzipr <1,2,5,3>, RHS
  1567148870U, // <5,6,3,u>: Cost 2 vext2 <3,u,5,6>, <3,u,5,6>
  2577817702U, // <5,6,4,0>: Cost 3 vext1 <4,5,6,4>, LHS
  3700034544U, // <5,6,4,1>: Cost 4 vext2 <1,4,5,6>, <4,1,6,5>
  2723033713U, // <5,6,4,2>: Cost 3 vext3 <6,4,2,5>, <6,4,2,5>
  2638236818U, // <5,6,4,3>: Cost 3 vext2 <3,4,5,6>, <4,3,6,5>
  2644208859U, // <5,6,4,4>: Cost 3 vext2 <4,4,5,6>, <4,4,5,6>
  1564495158U, // <5,6,4,5>: Cost 2 vext2 <3,4,5,6>, RHS
  2645536125U, // <5,6,4,6>: Cost 3 vext2 <4,6,5,6>, <4,6,5,6>
  2723402398U, // <5,6,4,7>: Cost 3 vext3 <6,4,7,5>, <6,4,7,5>
  1564495401U, // <5,6,4,u>: Cost 2 vext2 <3,4,5,6>, RHS
  2577825894U, // <5,6,5,0>: Cost 3 vext1 <4,5,6,5>, LHS
  2662125264U, // <5,6,5,1>: Cost 3 vext2 <7,4,5,6>, <5,1,7,3>
  3775836867U, // <5,6,5,2>: Cost 4 vext3 <2,u,6,5>, <6,5,2,6>
  3711979343U, // <5,6,5,3>: Cost 4 vext2 <3,4,5,6>, <5,3,3,4>
  2650181556U, // <5,6,5,4>: Cost 3 vext2 <5,4,5,6>, <5,4,5,6>
  2662125572U, // <5,6,5,5>: Cost 3 vext2 <7,4,5,6>, <5,5,5,5>
  2638237732U, // <5,6,5,6>: Cost 3 vext2 <3,4,5,6>, <5,6,0,1>
  2982399286U, // <5,6,5,7>: Cost 3 vzipr <4,u,5,5>, RHS
  2982399287U, // <5,6,5,u>: Cost 3 vzipr <4,u,5,5>, RHS
  2583806054U, // <5,6,6,0>: Cost 3 vext1 <5,5,6,6>, LHS
  3711979910U, // <5,6,6,1>: Cost 4 vext2 <3,4,5,6>, <6,1,3,4>
  2662126074U, // <5,6,6,2>: Cost 3 vext2 <7,4,5,6>, <6,2,7,3>
  2583808514U, // <5,6,6,3>: Cost 3 vext1 <5,5,6,6>, <3,4,5,6>
  2583809334U, // <5,6,6,4>: Cost 3 vext1 <5,5,6,6>, RHS
  2583810062U, // <5,6,6,5>: Cost 3 vext1 <5,5,6,6>, <5,5,6,6>
  2638238520U, // <5,6,6,6>: Cost 3 vext2 <3,4,5,6>, <6,6,6,6>
  2973781302U, // <5,6,6,7>: Cost 3 vzipr <3,4,5,6>, RHS
  2973781303U, // <5,6,6,u>: Cost 3 vzipr <3,4,5,6>, RHS
  430358630U, // <5,6,7,0>: Cost 1 vext1 RHS, LHS
  1504101110U, // <5,6,7,1>: Cost 2 vext1 RHS, <1,0,3,2>
  1504101992U, // <5,6,7,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1504102550U, // <5,6,7,3>: Cost 2 vext1 RHS, <3,0,1,2>
  430361910U, // <5,6,7,4>: Cost 1 vext1 RHS, RHS
  1504104390U, // <5,6,7,5>: Cost 2 vext1 RHS, <5,4,7,6>
  1504105272U, // <5,6,7,6>: Cost 2 vext1 RHS, <6,6,6,6>
  1504106092U, // <5,6,7,7>: Cost 2 vext1 RHS, <7,7,7,7>
  430364462U, // <5,6,7,u>: Cost 1 vext1 RHS, LHS
  430366822U, // <5,6,u,0>: Cost 1 vext1 RHS, LHS
  1564497710U, // <5,6,u,1>: Cost 2 vext2 <3,4,5,6>, LHS
  1504110184U, // <5,6,u,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1504110742U, // <5,6,u,3>: Cost 2 vext1 RHS, <3,0,1,2>
  430370103U, // <5,6,u,4>: Cost 1 vext1 RHS, RHS
  1564498074U, // <5,6,u,5>: Cost 2 vext2 <3,4,5,6>, RHS
  1504113146U, // <5,6,u,6>: Cost 2 vext1 RHS, <6,2,7,3>
  1504113658U, // <5,6,u,7>: Cost 2 vext1 RHS, <7,0,1,2>
  430372654U, // <5,6,u,u>: Cost 1 vext1 RHS, LHS
  2625634304U, // <5,7,0,0>: Cost 3 vext2 <1,3,5,7>, <0,0,0,0>
  1551892582U, // <5,7,0,1>: Cost 2 vext2 <1,3,5,7>, LHS
  2625634468U, // <5,7,0,2>: Cost 3 vext2 <1,3,5,7>, <0,2,0,2>
  2571889247U, // <5,7,0,3>: Cost 3 vext1 <3,5,7,0>, <3,5,7,0>
  2625634642U, // <5,7,0,4>: Cost 3 vext2 <1,3,5,7>, <0,4,1,5>
  2595778728U, // <5,7,0,5>: Cost 3 vext1 <7,5,7,0>, <5,7,5,7>
  3699376639U, // <5,7,0,6>: Cost 4 vext2 <1,3,5,7>, <0,6,2,7>
  2260235715U, // <5,7,0,7>: Cost 3 vrev <7,5,7,0>
  1551893149U, // <5,7,0,u>: Cost 2 vext2 <1,3,5,7>, LHS
  2625635062U, // <5,7,1,0>: Cost 3 vext2 <1,3,5,7>, <1,0,3,2>
  2624308020U, // <5,7,1,1>: Cost 3 vext2 <1,1,5,7>, <1,1,1,1>
  2625635222U, // <5,7,1,2>: Cost 3 vext2 <1,3,5,7>, <1,2,3,0>
  1551893504U, // <5,7,1,3>: Cost 2 vext2 <1,3,5,7>, <1,3,5,7>
  2571898166U, // <5,7,1,4>: Cost 3 vext1 <3,5,7,1>, RHS
  2625635472U, // <5,7,1,5>: Cost 3 vext2 <1,3,5,7>, <1,5,3,7>
  2627626227U, // <5,7,1,6>: Cost 3 vext2 <1,6,5,7>, <1,6,5,7>
  3702031684U, // <5,7,1,7>: Cost 4 vext2 <1,7,5,7>, <1,7,5,7>
  1555211669U, // <5,7,1,u>: Cost 2 vext2 <1,u,5,7>, <1,u,5,7>
  2629617126U, // <5,7,2,0>: Cost 3 vext2 <2,0,5,7>, <2,0,5,7>
  3699377670U, // <5,7,2,1>: Cost 4 vext2 <1,3,5,7>, <2,1,0,3>
  2625635944U, // <5,7,2,2>: Cost 3 vext2 <1,3,5,7>, <2,2,2,2>
  2625636006U, // <5,7,2,3>: Cost 3 vext2 <1,3,5,7>, <2,3,0,1>
  2632271658U, // <5,7,2,4>: Cost 3 vext2 <2,4,5,7>, <2,4,5,7>
  2625636201U, // <5,7,2,5>: Cost 3 vext2 <1,3,5,7>, <2,5,3,7>
  2625636282U, // <5,7,2,6>: Cost 3 vext2 <1,3,5,7>, <2,6,3,7>
  3708004381U, // <5,7,2,7>: Cost 4 vext2 <2,7,5,7>, <2,7,5,7>
  2625636411U, // <5,7,2,u>: Cost 3 vext2 <1,3,5,7>, <2,u,0,1>
  2625636502U, // <5,7,3,0>: Cost 3 vext2 <1,3,5,7>, <3,0,1,2>
  2625636604U, // <5,7,3,1>: Cost 3 vext2 <1,3,5,7>, <3,1,3,5>
  3699378478U, // <5,7,3,2>: Cost 4 vext2 <1,3,5,7>, <3,2,0,1>
  2625636764U, // <5,7,3,3>: Cost 3 vext2 <1,3,5,7>, <3,3,3,3>
  2625636866U, // <5,7,3,4>: Cost 3 vext2 <1,3,5,7>, <3,4,5,6>
  2625636959U, // <5,7,3,5>: Cost 3 vext2 <1,3,5,7>, <3,5,7,0>
  3699378808U, // <5,7,3,6>: Cost 4 vext2 <1,3,5,7>, <3,6,0,7>
  2640235254U, // <5,7,3,7>: Cost 3 vext2 <3,7,5,7>, <3,7,5,7>
  2625637150U, // <5,7,3,u>: Cost 3 vext2 <1,3,5,7>, <3,u,1,2>
  2571919462U, // <5,7,4,0>: Cost 3 vext1 <3,5,7,4>, LHS
  2571920384U, // <5,7,4,1>: Cost 3 vext1 <3,5,7,4>, <1,3,5,7>
  3699379260U, // <5,7,4,2>: Cost 4 vext2 <1,3,5,7>, <4,2,6,0>
  2571922019U, // <5,7,4,3>: Cost 3 vext1 <3,5,7,4>, <3,5,7,4>
  2571922742U, // <5,7,4,4>: Cost 3 vext1 <3,5,7,4>, RHS
  1551895862U, // <5,7,4,5>: Cost 2 vext2 <1,3,5,7>, RHS
  2846277980U, // <5,7,4,6>: Cost 3 vuzpr RHS, <0,4,2,6>
  2646207951U, // <5,7,4,7>: Cost 3 vext2 <4,7,5,7>, <4,7,5,7>
  1551896105U, // <5,7,4,u>: Cost 2 vext2 <1,3,5,7>, RHS
  2583871590U, // <5,7,5,0>: Cost 3 vext1 <5,5,7,5>, LHS
  2652180176U, // <5,7,5,1>: Cost 3 vext2 <5,7,5,7>, <5,1,7,3>
  2625638177U, // <5,7,5,2>: Cost 3 vext2 <1,3,5,7>, <5,2,7,3>
  2625638262U, // <5,7,5,3>: Cost 3 vext2 <1,3,5,7>, <5,3,7,7>
  2583874870U, // <5,7,5,4>: Cost 3 vext1 <5,5,7,5>, RHS
  2846281732U, // <5,7,5,5>: Cost 3 vuzpr RHS, <5,5,5,5>
  2651517015U, // <5,7,5,6>: Cost 3 vext2 <5,6,5,7>, <5,6,5,7>
  1772539190U, // <5,7,5,7>: Cost 2 vuzpr RHS, RHS
  1772539191U, // <5,7,5,u>: Cost 2 vuzpr RHS, RHS
  2846281826U, // <5,7,6,0>: Cost 3 vuzpr RHS, <5,6,7,0>
  3699380615U, // <5,7,6,1>: Cost 4 vext2 <1,3,5,7>, <6,1,3,5>
  2846281108U, // <5,7,6,2>: Cost 3 vuzpr RHS, <4,6,u,2>
  2589854210U, // <5,7,6,3>: Cost 3 vext1 <6,5,7,6>, <3,4,5,6>
  2846281830U, // <5,7,6,4>: Cost 3 vuzpr RHS, <5,6,7,4>
  2725467658U, // <5,7,6,5>: Cost 3 vext3 <6,7,u,5>, <7,6,5,u>
  2846281076U, // <5,7,6,6>: Cost 3 vuzpr RHS, <4,6,4,6>
  2846279610U, // <5,7,6,7>: Cost 3 vuzpr RHS, <2,6,3,7>
  2846279611U, // <5,7,6,u>: Cost 3 vuzpr RHS, <2,6,3,u>
  1510146150U, // <5,7,7,0>: Cost 2 vext1 <5,5,7,7>, LHS
  2846282574U, // <5,7,7,1>: Cost 3 vuzpr RHS, <6,7,0,1>
  2583889512U, // <5,7,7,2>: Cost 3 vext1 <5,5,7,7>, <2,2,2,2>
  2846281919U, // <5,7,7,3>: Cost 3 vuzpr RHS, <5,7,u,3>
  1510149430U, // <5,7,7,4>: Cost 2 vext1 <5,5,7,7>, RHS
  1510150168U, // <5,7,7,5>: Cost 2 vext1 <5,5,7,7>, <5,5,7,7>
  2583892474U, // <5,7,7,6>: Cost 3 vext1 <5,5,7,7>, <6,2,7,3>
  2625640044U, // <5,7,7,7>: Cost 3 vext2 <1,3,5,7>, <7,7,7,7>
  1510151982U, // <5,7,7,u>: Cost 2 vext1 <5,5,7,7>, LHS
  1510154342U, // <5,7,u,0>: Cost 2 vext1 <5,5,7,u>, LHS
  1551898414U, // <5,7,u,1>: Cost 2 vext2 <1,3,5,7>, LHS
  2625640325U, // <5,7,u,2>: Cost 3 vext2 <1,3,5,7>, <u,2,3,0>
  1772536477U, // <5,7,u,3>: Cost 2 vuzpr RHS, LHS
  1510157622U, // <5,7,u,4>: Cost 2 vext1 <5,5,7,u>, RHS
  1551898778U, // <5,7,u,5>: Cost 2 vext2 <1,3,5,7>, RHS
  2625640656U, // <5,7,u,6>: Cost 3 vext2 <1,3,5,7>, <u,6,3,7>
  1772539433U, // <5,7,u,7>: Cost 2 vuzpr RHS, RHS
  1551898981U, // <5,7,u,u>: Cost 2 vext2 <1,3,5,7>, LHS
  2625642496U, // <5,u,0,0>: Cost 3 vext2 <1,3,5,u>, <0,0,0,0>
  1551900774U, // <5,u,0,1>: Cost 2 vext2 <1,3,5,u>, LHS
  2625642660U, // <5,u,0,2>: Cost 3 vext2 <1,3,5,u>, <0,2,0,2>
  2698630885U, // <5,u,0,3>: Cost 3 vext3 <2,3,4,5>, <u,0,3,2>
  2687129325U, // <5,u,0,4>: Cost 3 vext3 <0,4,1,5>, <u,0,4,1>
  2689783542U, // <5,u,0,5>: Cost 3 vext3 <0,u,1,5>, <u,0,5,1>
  2266134675U, // <5,u,0,6>: Cost 3 vrev <u,5,6,0>
  2595853772U, // <5,u,0,7>: Cost 3 vext1 <7,5,u,0>, <7,5,u,0>
  1551901341U, // <5,u,0,u>: Cost 2 vext2 <1,3,5,u>, LHS
  2625643254U, // <5,u,1,0>: Cost 3 vext2 <1,3,5,u>, <1,0,3,2>
  2625643316U, // <5,u,1,1>: Cost 3 vext2 <1,3,5,u>, <1,1,1,1>
  1613387566U, // <5,u,1,2>: Cost 2 vext3 <0,4,1,5>, LHS
  1551901697U, // <5,u,1,3>: Cost 2 vext2 <1,3,5,u>, <1,3,5,u>
  2626307154U, // <5,u,1,4>: Cost 3 vext2 <1,4,5,u>, <1,4,5,u>
  2689783622U, // <5,u,1,5>: Cost 3 vext3 <0,u,1,5>, <u,1,5,0>
  2627634420U, // <5,u,1,6>: Cost 3 vext2 <1,6,5,u>, <1,6,5,u>
  2982366536U, // <5,u,1,7>: Cost 3 vzipr <4,u,5,1>, RHS
  1613387620U, // <5,u,1,u>: Cost 2 vext3 <0,4,1,5>, LHS
  2846286742U, // <5,u,2,0>: Cost 3 vuzpr RHS, <1,2,3,0>
  2685796528U, // <5,u,2,1>: Cost 3 vext3 <0,2,1,5>, <0,2,1,5>
  2625644136U, // <5,u,2,2>: Cost 3 vext2 <1,3,5,u>, <2,2,2,2>
  2687129480U, // <5,u,2,3>: Cost 3 vext3 <0,4,1,5>, <u,2,3,3>
  2632279851U, // <5,u,2,4>: Cost 3 vext2 <2,4,5,u>, <2,4,5,u>
  2625644394U, // <5,u,2,5>: Cost 3 vext2 <1,3,5,u>, <2,5,3,u>
  2625644474U, // <5,u,2,6>: Cost 3 vext2 <1,3,5,u>, <2,6,3,7>
  2713966508U, // <5,u,2,7>: Cost 3 vext3 <4,u,5,5>, <u,2,7,3>
  2625644603U, // <5,u,2,u>: Cost 3 vext2 <1,3,5,u>, <2,u,0,1>
  2687129532U, // <5,u,3,0>: Cost 3 vext3 <0,4,1,5>, <u,3,0,1>
  2636261649U, // <5,u,3,1>: Cost 3 vext2 <3,1,5,u>, <3,1,5,u>
  2636925282U, // <5,u,3,2>: Cost 3 vext2 <3,2,5,u>, <3,2,5,u>
  2625644956U, // <5,u,3,3>: Cost 3 vext2 <1,3,5,u>, <3,3,3,3>
  1564510724U, // <5,u,3,4>: Cost 2 vext2 <3,4,5,u>, <3,4,5,u>
  2625645160U, // <5,u,3,5>: Cost 3 vext2 <1,3,5,u>, <3,5,u,0>
  2734610422U, // <5,u,3,6>: Cost 3 vext3 <u,3,6,5>, <u,3,6,5>
  2640243447U, // <5,u,3,7>: Cost 3 vext2 <3,7,5,u>, <3,7,5,u>
  1567165256U, // <5,u,3,u>: Cost 2 vext2 <3,u,5,u>, <3,u,5,u>
  1567828889U, // <5,u,4,0>: Cost 2 vext2 <4,0,5,u>, <4,0,5,u>
  1661163546U, // <5,u,4,1>: Cost 2 vext3 <u,4,1,5>, <u,4,1,5>
  2734463012U, // <5,u,4,2>: Cost 3 vext3 <u,3,4,5>, <u,4,2,6>
  2698631212U, // <5,u,4,3>: Cost 3 vext3 <2,3,4,5>, <u,4,3,5>
  1570458842U, // <5,u,4,4>: Cost 2 vext2 <4,4,5,5>, <4,4,5,5>
  1551904054U, // <5,u,4,5>: Cost 2 vext2 <1,3,5,u>, RHS
  2846286172U, // <5,u,4,6>: Cost 3 vuzpr RHS, <0,4,2,6>
  2646216144U, // <5,u,4,7>: Cost 3 vext2 <4,7,5,u>, <4,7,5,u>
  1551904297U, // <5,u,4,u>: Cost 2 vext2 <1,3,5,u>, RHS
  1509982310U, // <5,u,5,0>: Cost 2 vext1 <5,5,5,5>, LHS
  2560058555U, // <5,u,5,1>: Cost 3 vext1 <1,5,u,5>, <1,5,u,5>
  2698926194U, // <5,u,5,2>: Cost 3 vext3 <2,3,u,5>, <u,5,2,3>
  2698631295U, // <5,u,5,3>: Cost 3 vext3 <2,3,4,5>, <u,5,3,7>
  1509985590U, // <5,u,5,4>: Cost 2 vext1 <5,5,5,5>, RHS
  229035318U, // <5,u,5,5>: Cost 1 vdup1 RHS
  1613387930U, // <5,u,5,6>: Cost 2 vext3 <0,4,1,5>, RHS
  1772547382U, // <5,u,5,7>: Cost 2 vuzpr RHS, RHS
  229035318U, // <5,u,5,u>: Cost 1 vdup1 RHS
  2566037606U, // <5,u,6,0>: Cost 3 vext1 <2,5,u,6>, LHS
  2920044334U, // <5,u,6,1>: Cost 3 vzipl <5,6,7,0>, LHS
  2566039445U, // <5,u,6,2>: Cost 3 vext1 <2,5,u,6>, <2,5,u,6>
  2687129808U, // <5,u,6,3>: Cost 3 vext3 <0,4,1,5>, <u,6,3,7>
  2566040886U, // <5,u,6,4>: Cost 3 vext1 <2,5,u,6>, RHS
  2920044698U, // <5,u,6,5>: Cost 3 vzipl <5,6,7,0>, RHS
  2846289268U, // <5,u,6,6>: Cost 3 vuzpr RHS, <4,6,4,6>
  2973781320U, // <5,u,6,7>: Cost 3 vzipr <3,4,5,6>, RHS
  2687129853U, // <5,u,6,u>: Cost 3 vext3 <0,4,1,5>, <u,6,u,7>
  430506086U, // <5,u,7,0>: Cost 1 vext1 RHS, LHS
  1486333117U, // <5,u,7,1>: Cost 2 vext1 <1,5,u,7>, <1,5,u,7>
  1504249448U, // <5,u,7,2>: Cost 2 vext1 RHS, <2,2,2,2>
  2040971933U, // <5,u,7,3>: Cost 2 vtrnr RHS, LHS
  430509384U, // <5,u,7,4>: Cost 1 vext1 RHS, RHS
  1504251600U, // <5,u,7,5>: Cost 2 vext1 RHS, <5,1,7,3>
  118708378U, // <5,u,7,6>: Cost 1 vrev RHS
  2040974889U, // <5,u,7,7>: Cost 2 vtrnr RHS, RHS
  430511918U, // <5,u,7,u>: Cost 1 vext1 RHS, LHS
  430514278U, // <5,u,u,0>: Cost 1 vext1 RHS, LHS
  1551906606U, // <5,u,u,1>: Cost 2 vext2 <1,3,5,u>, LHS
  1613388133U, // <5,u,u,2>: Cost 2 vext3 <0,4,1,5>, LHS
  1772544669U, // <5,u,u,3>: Cost 2 vuzpr RHS, LHS
  430517577U, // <5,u,u,4>: Cost 1 vext1 RHS, RHS
  229035318U, // <5,u,u,5>: Cost 1 vdup1 RHS
  118716571U, // <5,u,u,6>: Cost 1 vrev RHS
  1772547625U, // <5,u,u,7>: Cost 2 vuzpr RHS, RHS
  430520110U, // <5,u,u,u>: Cost 1 vext1 RHS, LHS
  2686025728U, // <6,0,0,0>: Cost 3 vext3 <0,2,4,6>, <0,0,0,0>
  2686025738U, // <6,0,0,1>: Cost 3 vext3 <0,2,4,6>, <0,0,1,1>
  2686025748U, // <6,0,0,2>: Cost 3 vext3 <0,2,4,6>, <0,0,2,2>
  3779084320U, // <6,0,0,3>: Cost 4 vext3 <3,4,5,6>, <0,0,3,5>
  2642903388U, // <6,0,0,4>: Cost 3 vext2 <4,2,6,0>, <0,4,2,6>
  3657723939U, // <6,0,0,5>: Cost 4 vext1 <5,6,0,0>, <5,6,0,0>
  3926676514U, // <6,0,0,6>: Cost 4 vuzpr <5,6,7,0>, <7,0,5,6>
  3926675786U, // <6,0,0,7>: Cost 4 vuzpr <5,6,7,0>, <6,0,5,7>
  2686025802U, // <6,0,0,u>: Cost 3 vext3 <0,2,4,6>, <0,0,u,2>
  2566070374U, // <6,0,1,0>: Cost 3 vext1 <2,6,0,1>, LHS
  3759767642U, // <6,0,1,1>: Cost 4 vext3 <0,2,4,6>, <0,1,1,0>
  1612284006U, // <6,0,1,2>: Cost 2 vext3 <0,2,4,6>, LHS
  2583988738U, // <6,0,1,3>: Cost 3 vext1 <5,6,0,1>, <3,4,5,6>
  2566073654U, // <6,0,1,4>: Cost 3 vext1 <2,6,0,1>, RHS
  2583990308U, // <6,0,1,5>: Cost 3 vext1 <5,6,0,1>, <5,6,0,1>
  2589963005U, // <6,0,1,6>: Cost 3 vext1 <6,6,0,1>, <6,6,0,1>
  2595935702U, // <6,0,1,7>: Cost 3 vext1 <7,6,0,1>, <7,6,0,1>
  1612284060U, // <6,0,1,u>: Cost 2 vext3 <0,2,4,6>, LHS
  2686025892U, // <6,0,2,0>: Cost 3 vext3 <0,2,4,6>, <0,2,0,2>
  2685804721U, // <6,0,2,1>: Cost 3 vext3 <0,2,1,6>, <0,2,1,6>
  3759620282U, // <6,0,2,2>: Cost 4 vext3 <0,2,2,6>, <0,2,2,6>
  2705342658U, // <6,0,2,3>: Cost 3 vext3 <3,4,5,6>, <0,2,3,5>
  1612284108U, // <6,0,2,4>: Cost 2 vext3 <0,2,4,6>, <0,2,4,6>
  3706029956U, // <6,0,2,5>: Cost 4 vext2 <2,4,6,0>, <2,5,6,7>
  2686173406U, // <6,0,2,6>: Cost 3 vext3 <0,2,6,6>, <0,2,6,6>
  3651769338U, // <6,0,2,7>: Cost 4 vext1 <4,6,0,2>, <7,0,1,2>
  1612579056U, // <6,0,2,u>: Cost 2 vext3 <0,2,u,6>, <0,2,u,6>
  3706030230U, // <6,0,3,0>: Cost 4 vext2 <2,4,6,0>, <3,0,1,2>
  2705342720U, // <6,0,3,1>: Cost 3 vext3 <3,4,5,6>, <0,3,1,4>
  2705342730U, // <6,0,3,2>: Cost 3 vext3 <3,4,5,6>, <0,3,2,5>
  3706030492U, // <6,0,3,3>: Cost 4 vext2 <2,4,6,0>, <3,3,3,3>
  2644896258U, // <6,0,3,4>: Cost 3 vext2 <4,5,6,0>, <3,4,5,6>
  3718638154U, // <6,0,3,5>: Cost 4 vext2 <4,5,6,0>, <3,5,4,6>
  3729918619U, // <6,0,3,6>: Cost 4 vext2 <6,4,6,0>, <3,6,4,6>
  3926672384U, // <6,0,3,7>: Cost 4 vuzpr <5,6,7,0>, <1,3,5,7>
  2705342784U, // <6,0,3,u>: Cost 3 vext3 <3,4,5,6>, <0,3,u,5>
  2687058250U, // <6,0,4,0>: Cost 3 vext3 <0,4,0,6>, <0,4,0,6>
  2686026066U, // <6,0,4,1>: Cost 3 vext3 <0,2,4,6>, <0,4,1,5>
  1613463900U, // <6,0,4,2>: Cost 2 vext3 <0,4,2,6>, <0,4,2,6>
  3761021285U, // <6,0,4,3>: Cost 4 vext3 <0,4,3,6>, <0,4,3,6>
  2687353198U, // <6,0,4,4>: Cost 3 vext3 <0,4,4,6>, <0,4,4,6>
  2632289590U, // <6,0,4,5>: Cost 3 vext2 <2,4,6,0>, RHS
  2645560704U, // <6,0,4,6>: Cost 3 vext2 <4,6,6,0>, <4,6,6,0>
  2646224337U, // <6,0,4,7>: Cost 3 vext2 <4,7,6,0>, <4,7,6,0>
  1613906322U, // <6,0,4,u>: Cost 2 vext3 <0,4,u,6>, <0,4,u,6>
  3651788902U, // <6,0,5,0>: Cost 4 vext1 <4,6,0,5>, LHS
  2687795620U, // <6,0,5,1>: Cost 3 vext3 <0,5,1,6>, <0,5,1,6>
  3761611181U, // <6,0,5,2>: Cost 4 vext3 <0,5,2,6>, <0,5,2,6>
  3723284326U, // <6,0,5,3>: Cost 4 vext2 <5,3,6,0>, <5,3,6,0>
  2646224838U, // <6,0,5,4>: Cost 3 vext2 <4,7,6,0>, <5,4,7,6>
  3718639630U, // <6,0,5,5>: Cost 4 vext2 <4,5,6,0>, <5,5,6,6>
  2652196962U, // <6,0,5,6>: Cost 3 vext2 <5,7,6,0>, <5,6,7,0>
  2852932918U, // <6,0,5,7>: Cost 3 vuzpr <5,6,7,0>, RHS
  2852932919U, // <6,0,5,u>: Cost 3 vuzpr <5,6,7,0>, RHS
  2852933730U, // <6,0,6,0>: Cost 3 vuzpr <5,6,7,0>, <5,6,7,0>
  2925985894U, // <6,0,6,1>: Cost 3 vzipl <6,6,6,6>, LHS
  3060203622U, // <6,0,6,2>: Cost 3 vtrnl <6,6,6,6>, LHS
  3718640178U, // <6,0,6,3>: Cost 4 vext2 <4,5,6,0>, <6,3,4,5>
  2656178832U, // <6,0,6,4>: Cost 3 vext2 <6,4,6,0>, <6,4,6,0>
  3725939378U, // <6,0,6,5>: Cost 4 vext2 <5,7,6,0>, <6,5,0,7>
  2657506098U, // <6,0,6,6>: Cost 3 vext2 <6,6,6,0>, <6,6,6,0>
  2619020110U, // <6,0,6,7>: Cost 3 vext2 <0,2,6,0>, <6,7,0,1>
  2925986461U, // <6,0,6,u>: Cost 3 vzipl <6,6,6,6>, LHS
  2572091494U, // <6,0,7,0>: Cost 3 vext1 <3,6,0,7>, LHS
  2572092310U, // <6,0,7,1>: Cost 3 vext1 <3,6,0,7>, <1,2,3,0>
  2980495524U, // <6,0,7,2>: Cost 3 vzipr RHS, <0,2,0,2>
  2572094072U, // <6,0,7,3>: Cost 3 vext1 <3,6,0,7>, <3,6,0,7>
  2572094774U, // <6,0,7,4>: Cost 3 vext1 <3,6,0,7>, RHS
  4054238242U, // <6,0,7,5>: Cost 4 vzipr RHS, <1,4,0,5>
  3645837653U, // <6,0,7,6>: Cost 4 vext1 <3,6,0,7>, <6,0,7,0>
  4054239054U, // <6,0,7,7>: Cost 4 vzipr RHS, <2,5,0,7>
  2572097326U, // <6,0,7,u>: Cost 3 vext1 <3,6,0,7>, LHS
  2686026378U, // <6,0,u,0>: Cost 3 vext3 <0,2,4,6>, <0,u,0,2>
  2686026386U, // <6,0,u,1>: Cost 3 vext3 <0,2,4,6>, <0,u,1,1>
  1612284573U, // <6,0,u,2>: Cost 2 vext3 <0,2,4,6>, LHS
  2705343144U, // <6,0,u,3>: Cost 3 vext3 <3,4,5,6>, <0,u,3,5>
  1616265906U, // <6,0,u,4>: Cost 2 vext3 <0,u,4,6>, <0,u,4,6>
  2632292506U, // <6,0,u,5>: Cost 3 vext2 <2,4,6,0>, RHS
  2590020356U, // <6,0,u,6>: Cost 3 vext1 <6,6,0,u>, <6,6,0,u>
  2852933161U, // <6,0,u,7>: Cost 3 vuzpr <5,6,7,0>, RHS
  1612284627U, // <6,0,u,u>: Cost 2 vext3 <0,2,4,6>, LHS
  2595995750U, // <6,1,0,0>: Cost 3 vext1 <7,6,1,0>, LHS
  2646229094U, // <6,1,0,1>: Cost 3 vext2 <4,7,6,1>, LHS
  3694092492U, // <6,1,0,2>: Cost 4 vext2 <0,4,6,1>, <0,2,4,6>
  2686026486U, // <6,1,0,3>: Cost 3 vext3 <0,2,4,6>, <1,0,3,2>
  2595999030U, // <6,1,0,4>: Cost 3 vext1 <7,6,1,0>, RHS
  3767730952U, // <6,1,0,5>: Cost 4 vext3 <1,5,4,6>, <1,0,5,2>
  2596000590U, // <6,1,0,6>: Cost 3 vext1 <7,6,1,0>, <6,7,0,1>
  2596001246U, // <6,1,0,7>: Cost 3 vext1 <7,6,1,0>, <7,6,1,0>
  2686026531U, // <6,1,0,u>: Cost 3 vext3 <0,2,4,6>, <1,0,u,2>
  3763602219U, // <6,1,1,0>: Cost 4 vext3 <0,u,2,6>, <1,1,0,1>
  2686026548U, // <6,1,1,1>: Cost 3 vext3 <0,2,4,6>, <1,1,1,1>
  3764929346U, // <6,1,1,2>: Cost 4 vext3 <1,1,2,6>, <1,1,2,6>
  2686026568U, // <6,1,1,3>: Cost 3 vext3 <0,2,4,6>, <1,1,3,3>
  2691334996U, // <6,1,1,4>: Cost 3 vext3 <1,1,4,6>, <1,1,4,6>
  3760874332U, // <6,1,1,5>: Cost 4 vext3 <0,4,1,6>, <1,1,5,5>
  3765224294U, // <6,1,1,6>: Cost 4 vext3 <1,1,6,6>, <1,1,6,6>
  3669751263U, // <6,1,1,7>: Cost 4 vext1 <7,6,1,1>, <7,6,1,1>
  2686026613U, // <6,1,1,u>: Cost 3 vext3 <0,2,4,6>, <1,1,u,3>
  2554208358U, // <6,1,2,0>: Cost 3 vext1 <0,6,1,2>, LHS
  3763602311U, // <6,1,2,1>: Cost 4 vext3 <0,u,2,6>, <1,2,1,3>
  3639895971U, // <6,1,2,2>: Cost 4 vext1 <2,6,1,2>, <2,6,1,2>
  2686026646U, // <6,1,2,3>: Cost 3 vext3 <0,2,4,6>, <1,2,3,0>
  2554211638U, // <6,1,2,4>: Cost 3 vext1 <0,6,1,2>, RHS
  3760874411U, // <6,1,2,5>: Cost 4 vext3 <0,4,1,6>, <1,2,5,3>
  2554212858U, // <6,1,2,6>: Cost 3 vext1 <0,6,1,2>, <6,2,7,3>
  3802973114U, // <6,1,2,7>: Cost 4 vext3 <7,4,5,6>, <1,2,7,0>
  2686026691U, // <6,1,2,u>: Cost 3 vext3 <0,2,4,6>, <1,2,u,0>
  2566160486U, // <6,1,3,0>: Cost 3 vext1 <2,6,1,3>, LHS
  2686026712U, // <6,1,3,1>: Cost 3 vext3 <0,2,4,6>, <1,3,1,3>
  2686026724U, // <6,1,3,2>: Cost 3 vext3 <0,2,4,6>, <1,3,2,6>
  3759768552U, // <6,1,3,3>: Cost 4 vext3 <0,2,4,6>, <1,3,3,1>
  2692662262U, // <6,1,3,4>: Cost 3 vext3 <1,3,4,6>, <1,3,4,6>
  2686026752U, // <6,1,3,5>: Cost 3 vext3 <0,2,4,6>, <1,3,5,7>
  2590053128U, // <6,1,3,6>: Cost 3 vext1 <6,6,1,3>, <6,6,1,3>
  3663795194U, // <6,1,3,7>: Cost 4 vext1 <6,6,1,3>, <7,0,1,2>
  2686026775U, // <6,1,3,u>: Cost 3 vext3 <0,2,4,6>, <1,3,u,3>
  2641587099U, // <6,1,4,0>: Cost 3 vext2 <4,0,6,1>, <4,0,6,1>
  2693104684U, // <6,1,4,1>: Cost 3 vext3 <1,4,1,6>, <1,4,1,6>
  3639912357U, // <6,1,4,2>: Cost 4 vext1 <2,6,1,4>, <2,6,1,4>
  2687206462U, // <6,1,4,3>: Cost 3 vext3 <0,4,2,6>, <1,4,3,6>
  3633941814U, // <6,1,4,4>: Cost 4 vext1 <1,6,1,4>, RHS
  2693399632U, // <6,1,4,5>: Cost 3 vext3 <1,4,5,6>, <1,4,5,6>
  3765077075U, // <6,1,4,6>: Cost 4 vext3 <1,1,4,6>, <1,4,6,0>
  2646232530U, // <6,1,4,7>: Cost 3 vext2 <4,7,6,1>, <4,7,6,1>
  2687206507U, // <6,1,4,u>: Cost 3 vext3 <0,4,2,6>, <1,4,u,6>
  2647559796U, // <6,1,5,0>: Cost 3 vext2 <5,0,6,1>, <5,0,6,1>
  3765077118U, // <6,1,5,1>: Cost 4 vext3 <1,1,4,6>, <1,5,1,7>
  3767583878U, // <6,1,5,2>: Cost 4 vext3 <1,5,2,6>, <1,5,2,6>
  2686026896U, // <6,1,5,3>: Cost 3 vext3 <0,2,4,6>, <1,5,3,7>
  2693989528U, // <6,1,5,4>: Cost 3 vext3 <1,5,4,6>, <1,5,4,6>
  3767805089U, // <6,1,5,5>: Cost 4 vext3 <1,5,5,6>, <1,5,5,6>
  2652868706U, // <6,1,5,6>: Cost 3 vext2 <5,u,6,1>, <5,6,7,0>
  3908250934U, // <6,1,5,7>: Cost 4 vuzpr <2,6,0,1>, RHS
  2686026941U, // <6,1,5,u>: Cost 3 vext3 <0,2,4,6>, <1,5,u,7>
  2554241126U, // <6,1,6,0>: Cost 3 vext1 <0,6,1,6>, LHS
  3763602639U, // <6,1,6,1>: Cost 4 vext3 <0,u,2,6>, <1,6,1,7>
  3759547607U, // <6,1,6,2>: Cost 4 vext3 <0,2,1,6>, <1,6,2,6>
  3115221094U, // <6,1,6,3>: Cost 3 vtrnr <4,6,4,6>, LHS
  2554244406U, // <6,1,6,4>: Cost 3 vext1 <0,6,1,6>, RHS
  3760874739U, // <6,1,6,5>: Cost 4 vext3 <0,4,1,6>, <1,6,5,7>
  2554245944U, // <6,1,6,6>: Cost 3 vext1 <0,6,1,6>, <6,6,6,6>
  3719975758U, // <6,1,6,7>: Cost 4 vext2 <4,7,6,1>, <6,7,0,1>
  3115221099U, // <6,1,6,u>: Cost 3 vtrnr <4,6,4,6>, LHS
  2560221286U, // <6,1,7,0>: Cost 3 vext1 <1,6,1,7>, LHS
  2560222415U, // <6,1,7,1>: Cost 3 vext1 <1,6,1,7>, <1,6,1,7>
  2980497558U, // <6,1,7,2>: Cost 3 vzipr RHS, <3,0,1,2>
  3103211622U, // <6,1,7,3>: Cost 3 vtrnr <2,6,3,7>, LHS
  2560224566U, // <6,1,7,4>: Cost 3 vext1 <1,6,1,7>, RHS
  2980495698U, // <6,1,7,5>: Cost 3 vzipr RHS, <0,4,1,5>
  3633967526U, // <6,1,7,6>: Cost 4 vext1 <1,6,1,7>, <6,1,7,0>
  4054237686U, // <6,1,7,7>: Cost 4 vzipr RHS, <0,6,1,7>
  2560227118U, // <6,1,7,u>: Cost 3 vext1 <1,6,1,7>, LHS
  2560229478U, // <6,1,u,0>: Cost 3 vext1 <1,6,1,u>, LHS
  2686027117U, // <6,1,u,1>: Cost 3 vext3 <0,2,4,6>, <1,u,1,3>
  2686027129U, // <6,1,u,2>: Cost 3 vext3 <0,2,4,6>, <1,u,2,6>
  2686027132U, // <6,1,u,3>: Cost 3 vext3 <0,2,4,6>, <1,u,3,0>
  2687206795U, // <6,1,u,4>: Cost 3 vext3 <0,4,2,6>, <1,u,4,6>
  2686027157U, // <6,1,u,5>: Cost 3 vext3 <0,2,4,6>, <1,u,5,7>
  2590094093U, // <6,1,u,6>: Cost 3 vext1 <6,6,1,u>, <6,6,1,u>
  2596066790U, // <6,1,u,7>: Cost 3 vext1 <7,6,1,u>, <7,6,1,u>
  2686027177U, // <6,1,u,u>: Cost 3 vext3 <0,2,4,6>, <1,u,u,0>
  2646900736U, // <6,2,0,0>: Cost 3 vext2 <4,u,6,2>, <0,0,0,0>
  1573159014U, // <6,2,0,1>: Cost 2 vext2 <4,u,6,2>, LHS
  2646900900U, // <6,2,0,2>: Cost 3 vext2 <4,u,6,2>, <0,2,0,2>
  3759769037U, // <6,2,0,3>: Cost 4 vext3 <0,2,4,6>, <2,0,3,0>
  2641592668U, // <6,2,0,4>: Cost 3 vext2 <4,0,6,2>, <0,4,2,6>
  3779085794U, // <6,2,0,5>: Cost 4 vext3 <3,4,5,6>, <2,0,5,3>
  2686027244U, // <6,2,0,6>: Cost 3 vext3 <0,2,4,6>, <2,0,6,4>
  3669816807U, // <6,2,0,7>: Cost 4 vext1 <7,6,2,0>, <7,6,2,0>
  1573159581U, // <6,2,0,u>: Cost 2 vext2 <4,u,6,2>, LHS
  2230527897U, // <6,2,1,0>: Cost 3 vrev <2,6,0,1>
  2646901556U, // <6,2,1,1>: Cost 3 vext2 <4,u,6,2>, <1,1,1,1>
  2646901654U, // <6,2,1,2>: Cost 3 vext2 <4,u,6,2>, <1,2,3,0>
  2847047782U, // <6,2,1,3>: Cost 3 vuzpr <4,6,u,2>, LHS
  3771049517U, // <6,2,1,4>: Cost 4 vext3 <2,1,4,6>, <2,1,4,6>
  2646901904U, // <6,2,1,5>: Cost 3 vext2 <4,u,6,2>, <1,5,3,7>
  2686027324U, // <6,2,1,6>: Cost 3 vext3 <0,2,4,6>, <2,1,6,3>
  3669825000U, // <6,2,1,7>: Cost 4 vext1 <7,6,2,1>, <7,6,2,1>
  2231117793U, // <6,2,1,u>: Cost 3 vrev <2,6,u,1>
  3763603029U, // <6,2,2,0>: Cost 4 vext3 <0,u,2,6>, <2,2,0,1>
  3759769184U, // <6,2,2,1>: Cost 4 vext3 <0,2,4,6>, <2,2,1,3>
  2686027368U, // <6,2,2,2>: Cost 3 vext3 <0,2,4,6>, <2,2,2,2>
  2686027378U, // <6,2,2,3>: Cost 3 vext3 <0,2,4,6>, <2,2,3,3>
  2697971326U, // <6,2,2,4>: Cost 3 vext3 <2,2,4,6>, <2,2,4,6>
  3759769224U, // <6,2,2,5>: Cost 4 vext3 <0,2,4,6>, <2,2,5,7>
  2698118800U, // <6,2,2,6>: Cost 3 vext3 <2,2,6,6>, <2,2,6,6>
  3920794092U, // <6,2,2,7>: Cost 4 vuzpr <4,6,u,2>, <6,2,5,7>
  2686027423U, // <6,2,2,u>: Cost 3 vext3 <0,2,4,6>, <2,2,u,3>
  2686027430U, // <6,2,3,0>: Cost 3 vext3 <0,2,4,6>, <2,3,0,1>
  3759769262U, // <6,2,3,1>: Cost 4 vext3 <0,2,4,6>, <2,3,1,0>
  2698487485U, // <6,2,3,2>: Cost 3 vext3 <2,3,2,6>, <2,3,2,6>
  2705344196U, // <6,2,3,3>: Cost 3 vext3 <3,4,5,6>, <2,3,3,4>
  2686027470U, // <6,2,3,4>: Cost 3 vext3 <0,2,4,6>, <2,3,4,5>
  2698708696U, // <6,2,3,5>: Cost 3 vext3 <2,3,5,6>, <2,3,5,6>
  2724660961U, // <6,2,3,6>: Cost 3 vext3 <6,6,6,6>, <2,3,6,6>
  2729232104U, // <6,2,3,7>: Cost 3 vext3 <7,4,5,6>, <2,3,7,4>
  2686027502U, // <6,2,3,u>: Cost 3 vext3 <0,2,4,6>, <2,3,u,1>
  1567853468U, // <6,2,4,0>: Cost 2 vext2 <4,0,6,2>, <4,0,6,2>
  3759769351U, // <6,2,4,1>: Cost 4 vext3 <0,2,4,6>, <2,4,1,u>
  2699151118U, // <6,2,4,2>: Cost 3 vext3 <2,4,2,6>, <2,4,2,6>
  2686027543U, // <6,2,4,3>: Cost 3 vext3 <0,2,4,6>, <2,4,3,6>
  2699298592U, // <6,2,4,4>: Cost 3 vext3 <2,4,4,6>, <2,4,4,6>
  1573162294U, // <6,2,4,5>: Cost 2 vext2 <4,u,6,2>, RHS
  2686027564U, // <6,2,4,6>: Cost 3 vext3 <0,2,4,6>, <2,4,6,0>
  3719982547U, // <6,2,4,7>: Cost 4 vext2 <4,7,6,2>, <4,7,6,2>
  1573162532U, // <6,2,4,u>: Cost 2 vext2 <4,u,6,2>, <4,u,6,2>
  3779086154U, // <6,2,5,0>: Cost 4 vext3 <3,4,5,6>, <2,5,0,3>
  2646904528U, // <6,2,5,1>: Cost 3 vext2 <4,u,6,2>, <5,1,7,3>
  3759769440U, // <6,2,5,2>: Cost 4 vext3 <0,2,4,6>, <2,5,2,7>
  2699888488U, // <6,2,5,3>: Cost 3 vext3 <2,5,3,6>, <2,5,3,6>
  2230855617U, // <6,2,5,4>: Cost 3 vrev <2,6,4,5>
  2646904836U, // <6,2,5,5>: Cost 3 vext2 <4,u,6,2>, <5,5,5,5>
  2646904930U, // <6,2,5,6>: Cost 3 vext2 <4,u,6,2>, <5,6,7,0>
  2847051062U, // <6,2,5,7>: Cost 3 vuzpr <4,6,u,2>, RHS
  2700257173U, // <6,2,5,u>: Cost 3 vext3 <2,5,u,6>, <2,5,u,6>
  2687207321U, // <6,2,6,0>: Cost 3 vext3 <0,4,2,6>, <2,6,0,1>
  2686027684U, // <6,2,6,1>: Cost 3 vext3 <0,2,4,6>, <2,6,1,3>
  2566260656U, // <6,2,6,2>: Cost 3 vext1 <2,6,2,6>, <2,6,2,6>
  2685806522U, // <6,2,6,3>: Cost 3 vext3 <0,2,1,6>, <2,6,3,7>
  2687207361U, // <6,2,6,4>: Cost 3 vext3 <0,4,2,6>, <2,6,4,5>
  2686027724U, // <6,2,6,5>: Cost 3 vext3 <0,2,4,6>, <2,6,5,7>
  2646905656U, // <6,2,6,6>: Cost 3 vext2 <4,u,6,2>, <6,6,6,6>
  2646905678U, // <6,2,6,7>: Cost 3 vext2 <4,u,6,2>, <6,7,0,1>
  2686027751U, // <6,2,6,u>: Cost 3 vext3 <0,2,4,6>, <2,6,u,7>
  2554323046U, // <6,2,7,0>: Cost 3 vext1 <0,6,2,7>, LHS
  2572239606U, // <6,2,7,1>: Cost 3 vext1 <3,6,2,7>, <1,0,3,2>
  2566268849U, // <6,2,7,2>: Cost 3 vext1 <2,6,2,7>, <2,6,2,7>
  1906753638U, // <6,2,7,3>: Cost 2 vzipr RHS, LHS
  2554326326U, // <6,2,7,4>: Cost 3 vext1 <0,6,2,7>, RHS
  3304687564U, // <6,2,7,5>: Cost 4 vrev <2,6,5,7>
  2980495708U, // <6,2,7,6>: Cost 3 vzipr RHS, <0,4,2,6>
  2646906476U, // <6,2,7,7>: Cost 3 vext2 <4,u,6,2>, <7,7,7,7>
  1906753643U, // <6,2,7,u>: Cost 2 vzipr RHS, LHS
  1591744256U, // <6,2,u,0>: Cost 2 vext2 <u,0,6,2>, <u,0,6,2>
  1573164846U, // <6,2,u,1>: Cost 2 vext2 <4,u,6,2>, LHS
  2701805650U, // <6,2,u,2>: Cost 3 vext3 <2,u,2,6>, <2,u,2,6>
  1906761830U, // <6,2,u,3>: Cost 2 vzipr RHS, LHS
  2686027875U, // <6,2,u,4>: Cost 3 vext3 <0,2,4,6>, <2,u,4,5>
  1573165210U, // <6,2,u,5>: Cost 2 vext2 <4,u,6,2>, RHS
  2686322800U, // <6,2,u,6>: Cost 3 vext3 <0,2,u,6>, <2,u,6,0>
  2847051305U, // <6,2,u,7>: Cost 3 vuzpr <4,6,u,2>, RHS
  1906761835U, // <6,2,u,u>: Cost 2 vzipr RHS, LHS
  3759769739U, // <6,3,0,0>: Cost 4 vext3 <0,2,4,6>, <3,0,0,0>
  2686027926U, // <6,3,0,1>: Cost 3 vext3 <0,2,4,6>, <3,0,1,2>
  2686027937U, // <6,3,0,2>: Cost 3 vext3 <0,2,4,6>, <3,0,2,4>
  3640027286U, // <6,3,0,3>: Cost 4 vext1 <2,6,3,0>, <3,0,1,2>
  2687207601U, // <6,3,0,4>: Cost 3 vext3 <0,4,2,6>, <3,0,4,2>
  2705344698U, // <6,3,0,5>: Cost 3 vext3 <3,4,5,6>, <3,0,5,2>
  3663917847U, // <6,3,0,6>: Cost 4 vext1 <6,6,3,0>, <6,6,3,0>
  2237008560U, // <6,3,0,7>: Cost 3 vrev <3,6,7,0>
  2686027989U, // <6,3,0,u>: Cost 3 vext3 <0,2,4,6>, <3,0,u,2>
  3759769823U, // <6,3,1,0>: Cost 4 vext3 <0,2,4,6>, <3,1,0,3>
  3759769830U, // <6,3,1,1>: Cost 4 vext3 <0,2,4,6>, <3,1,1,1>
  3759769841U, // <6,3,1,2>: Cost 4 vext3 <0,2,4,6>, <3,1,2,3>
  3759769848U, // <6,3,1,3>: Cost 4 vext3 <0,2,4,6>, <3,1,3,1>
  2703280390U, // <6,3,1,4>: Cost 3 vext3 <3,1,4,6>, <3,1,4,6>
  3759769868U, // <6,3,1,5>: Cost 4 vext3 <0,2,4,6>, <3,1,5,3>
  3704063194U, // <6,3,1,6>: Cost 4 vext2 <2,1,6,3>, <1,6,3,0>
  3767732510U, // <6,3,1,7>: Cost 4 vext3 <1,5,4,6>, <3,1,7,3>
  2703280390U, // <6,3,1,u>: Cost 3 vext3 <3,1,4,6>, <3,1,4,6>
  3704063468U, // <6,3,2,0>: Cost 4 vext2 <2,1,6,3>, <2,0,6,4>
  2630321724U, // <6,3,2,1>: Cost 3 vext2 <2,1,6,3>, <2,1,6,3>
  3759769921U, // <6,3,2,2>: Cost 4 vext3 <0,2,4,6>, <3,2,2,2>
  3759769928U, // <6,3,2,3>: Cost 4 vext3 <0,2,4,6>, <3,2,3,0>
  3704063767U, // <6,3,2,4>: Cost 4 vext2 <2,1,6,3>, <2,4,3,6>
  3704063876U, // <6,3,2,5>: Cost 4 vext2 <2,1,6,3>, <2,5,6,7>
  2636957626U, // <6,3,2,6>: Cost 3 vext2 <3,2,6,3>, <2,6,3,7>
  3777907058U, // <6,3,2,7>: Cost 4 vext3 <3,2,7,6>, <3,2,7,6>
  2630321724U, // <6,3,2,u>: Cost 3 vext2 <2,1,6,3>, <2,1,6,3>
  3759769983U, // <6,3,3,0>: Cost 4 vext3 <0,2,4,6>, <3,3,0,1>
  3710036245U, // <6,3,3,1>: Cost 4 vext2 <3,1,6,3>, <3,1,6,3>
  2636958054U, // <6,3,3,2>: Cost 3 vext2 <3,2,6,3>, <3,2,6,3>
  2686028188U, // <6,3,3,3>: Cost 3 vext3 <0,2,4,6>, <3,3,3,3>
  2704607656U, // <6,3,3,4>: Cost 3 vext3 <3,3,4,6>, <3,3,4,6>
  3773041072U, // <6,3,3,5>: Cost 4 vext3 <2,4,4,6>, <3,3,5,5>
  3711363731U, // <6,3,3,6>: Cost 4 vext2 <3,3,6,3>, <3,6,3,7>
  3767732676U, // <6,3,3,7>: Cost 4 vext3 <1,5,4,6>, <3,3,7,7>
  2707999179U, // <6,3,3,u>: Cost 3 vext3 <3,u,5,6>, <3,3,u,5>
  2584232038U, // <6,3,4,0>: Cost 3 vext1 <5,6,3,4>, LHS
  2642267118U, // <6,3,4,1>: Cost 3 vext2 <4,1,6,3>, <4,1,6,3>
  2642930751U, // <6,3,4,2>: Cost 3 vext2 <4,2,6,3>, <4,2,6,3>
  2705197552U, // <6,3,4,3>: Cost 3 vext3 <3,4,3,6>, <3,4,3,6>
  2584235318U, // <6,3,4,4>: Cost 3 vext1 <5,6,3,4>, RHS
  1631603202U, // <6,3,4,5>: Cost 2 vext3 <3,4,5,6>, <3,4,5,6>
  2654211444U, // <6,3,4,6>: Cost 3 vext2 <6,1,6,3>, <4,6,4,6>
  2237041332U, // <6,3,4,7>: Cost 3 vrev <3,6,7,4>
  1631824413U, // <6,3,4,u>: Cost 2 vext3 <3,4,u,6>, <3,4,u,6>
  3640066150U, // <6,3,5,0>: Cost 4 vext1 <2,6,3,5>, LHS
  3772746288U, // <6,3,5,1>: Cost 4 vext3 <2,4,0,6>, <3,5,1,7>
  3640067790U, // <6,3,5,2>: Cost 4 vext1 <2,6,3,5>, <2,3,4,5>
  3773041216U, // <6,3,5,3>: Cost 4 vext3 <2,4,4,6>, <3,5,3,5>
  2705934922U, // <6,3,5,4>: Cost 3 vext3 <3,5,4,6>, <3,5,4,6>
  3773041236U, // <6,3,5,5>: Cost 4 vext3 <2,4,4,6>, <3,5,5,7>
  3779086940U, // <6,3,5,6>: Cost 4 vext3 <3,4,5,6>, <3,5,6,6>
  3767732831U, // <6,3,5,7>: Cost 4 vext3 <1,5,4,6>, <3,5,7,0>
  2706229870U, // <6,3,5,u>: Cost 3 vext3 <3,5,u,6>, <3,5,u,6>
  2602164326U, // <6,3,6,0>: Cost 3 vext1 <u,6,3,6>, LHS
  2654212512U, // <6,3,6,1>: Cost 3 vext2 <6,1,6,3>, <6,1,6,3>
  2566334393U, // <6,3,6,2>: Cost 3 vext1 <2,6,3,6>, <2,6,3,6>
  3704066588U, // <6,3,6,3>: Cost 4 vext2 <2,1,6,3>, <6,3,2,1>
  2602167524U, // <6,3,6,4>: Cost 3 vext1 <u,6,3,6>, <4,4,6,6>
  3710702321U, // <6,3,6,5>: Cost 4 vext2 <3,2,6,3>, <6,5,7,7>
  2724661933U, // <6,3,6,6>: Cost 3 vext3 <6,6,6,6>, <3,6,6,6>
  3710702465U, // <6,3,6,7>: Cost 4 vext2 <3,2,6,3>, <6,7,5,7>
  2602170158U, // <6,3,6,u>: Cost 3 vext1 <u,6,3,6>, LHS
  1492598886U, // <6,3,7,0>: Cost 2 vext1 <2,6,3,7>, LHS
  2560369889U, // <6,3,7,1>: Cost 3 vext1 <1,6,3,7>, <1,6,3,7>
  1492600762U, // <6,3,7,2>: Cost 2 vext1 <2,6,3,7>, <2,6,3,7>
  2566342806U, // <6,3,7,3>: Cost 3 vext1 <2,6,3,7>, <3,0,1,2>
  1492602166U, // <6,3,7,4>: Cost 2 vext1 <2,6,3,7>, RHS
  2602176208U, // <6,3,7,5>: Cost 3 vext1 <u,6,3,7>, <5,1,7,3>
  2566345210U, // <6,3,7,6>: Cost 3 vext1 <2,6,3,7>, <6,2,7,3>
  2980496528U, // <6,3,7,7>: Cost 3 vzipr RHS, <1,5,3,7>
  1492604718U, // <6,3,7,u>: Cost 2 vext1 <2,6,3,7>, LHS
  1492607078U, // <6,3,u,0>: Cost 2 vext1 <2,6,3,u>, LHS
  2686028574U, // <6,3,u,1>: Cost 3 vext3 <0,2,4,6>, <3,u,1,2>
  1492608955U, // <6,3,u,2>: Cost 2 vext1 <2,6,3,u>, <2,6,3,u>
  2566350998U, // <6,3,u,3>: Cost 3 vext1 <2,6,3,u>, <3,0,1,2>
  1492610358U, // <6,3,u,4>: Cost 2 vext1 <2,6,3,u>, RHS
  1634257734U, // <6,3,u,5>: Cost 2 vext3 <3,u,5,6>, <3,u,5,6>
  2566353489U, // <6,3,u,6>: Cost 3 vext1 <2,6,3,u>, <6,3,u,0>
  2980504720U, // <6,3,u,7>: Cost 3 vzipr RHS, <1,5,3,7>
  1492612910U, // <6,3,u,u>: Cost 2 vext1 <2,6,3,u>, LHS
  3703406592U, // <6,4,0,0>: Cost 4 vext2 <2,0,6,4>, <0,0,0,0>
  2629664870U, // <6,4,0,1>: Cost 3 vext2 <2,0,6,4>, LHS
  2629664972U, // <6,4,0,2>: Cost 3 vext2 <2,0,6,4>, <0,2,4,6>
  3779087232U, // <6,4,0,3>: Cost 4 vext3 <3,4,5,6>, <4,0,3,1>
  2642936156U, // <6,4,0,4>: Cost 3 vext2 <4,2,6,4>, <0,4,2,6>
  2712570770U, // <6,4,0,5>: Cost 3 vext3 <4,6,4,6>, <4,0,5,1>
  2687208348U, // <6,4,0,6>: Cost 3 vext3 <0,4,2,6>, <4,0,6,2>
  3316723081U, // <6,4,0,7>: Cost 4 vrev <4,6,7,0>
  2629665437U, // <6,4,0,u>: Cost 3 vext2 <2,0,6,4>, LHS
  2242473291U, // <6,4,1,0>: Cost 3 vrev <4,6,0,1>
  3700089652U, // <6,4,1,1>: Cost 4 vext2 <1,4,6,4>, <1,1,1,1>
  3703407510U, // <6,4,1,2>: Cost 4 vext2 <2,0,6,4>, <1,2,3,0>
  2852962406U, // <6,4,1,3>: Cost 3 vuzpr <5,6,7,4>, LHS
  3628166454U, // <6,4,1,4>: Cost 4 vext1 <0,6,4,1>, RHS
  3760876514U, // <6,4,1,5>: Cost 4 vext3 <0,4,1,6>, <4,1,5,0>
  2687208430U, // <6,4,1,6>: Cost 3 vext3 <0,4,2,6>, <4,1,6,3>
  3316731274U, // <6,4,1,7>: Cost 4 vrev <4,6,7,1>
  2243063187U, // <6,4,1,u>: Cost 3 vrev <4,6,u,1>
  2629666284U, // <6,4,2,0>: Cost 3 vext2 <2,0,6,4>, <2,0,6,4>
  3703408188U, // <6,4,2,1>: Cost 4 vext2 <2,0,6,4>, <2,1,6,3>
  3703408232U, // <6,4,2,2>: Cost 4 vext2 <2,0,6,4>, <2,2,2,2>
  3703408294U, // <6,4,2,3>: Cost 4 vext2 <2,0,6,4>, <2,3,0,1>
  2632320816U, // <6,4,2,4>: Cost 3 vext2 <2,4,6,4>, <2,4,6,4>
  2923384118U, // <6,4,2,5>: Cost 3 vzipl <6,2,7,3>, RHS
  2687208508U, // <6,4,2,6>: Cost 3 vext3 <0,4,2,6>, <4,2,6,0>
  3760950341U, // <6,4,2,7>: Cost 4 vext3 <0,4,2,6>, <4,2,7,0>
  2634975348U, // <6,4,2,u>: Cost 3 vext2 <2,u,6,4>, <2,u,6,4>
  3703408790U, // <6,4,3,0>: Cost 4 vext2 <2,0,6,4>, <3,0,1,2>
  3316305238U, // <6,4,3,1>: Cost 4 vrev <4,6,1,3>
  3703408947U, // <6,4,3,2>: Cost 4 vext2 <2,0,6,4>, <3,2,0,6>
  3703409052U, // <6,4,3,3>: Cost 4 vext2 <2,0,6,4>, <3,3,3,3>
  2644929026U, // <6,4,3,4>: Cost 3 vext2 <4,5,6,4>, <3,4,5,6>
  3718670922U, // <6,4,3,5>: Cost 4 vext2 <4,5,6,4>, <3,5,4,6>
  2705345682U, // <6,4,3,6>: Cost 3 vext3 <3,4,5,6>, <4,3,6,5>
  3926705152U, // <6,4,3,7>: Cost 4 vuzpr <5,6,7,4>, <1,3,5,7>
  2668817222U, // <6,4,3,u>: Cost 3 vext2 <u,5,6,4>, <3,u,5,6>
  2590277734U, // <6,4,4,0>: Cost 3 vext1 <6,6,4,4>, LHS
  3716017135U, // <6,4,4,1>: Cost 4 vext2 <4,1,6,4>, <4,1,6,4>
  2642938944U, // <6,4,4,2>: Cost 3 vext2 <4,2,6,4>, <4,2,6,4>
  3717344401U, // <6,4,4,3>: Cost 4 vext2 <4,3,6,4>, <4,3,6,4>
  2712571088U, // <6,4,4,4>: Cost 3 vext3 <4,6,4,6>, <4,4,4,4>
  2629668150U, // <6,4,4,5>: Cost 3 vext2 <2,0,6,4>, RHS
  1637649636U, // <6,4,4,6>: Cost 2 vext3 <4,4,6,6>, <4,4,6,6>
  2646257109U, // <6,4,4,7>: Cost 3 vext2 <4,7,6,4>, <4,7,6,4>
  1637649636U, // <6,4,4,u>: Cost 2 vext3 <4,4,6,6>, <4,4,6,6>
  2566398054U, // <6,4,5,0>: Cost 3 vext1 <2,6,4,5>, LHS
  3760876805U, // <6,4,5,1>: Cost 4 vext3 <0,4,1,6>, <4,5,1,3>
  2566399937U, // <6,4,5,2>: Cost 3 vext1 <2,6,4,5>, <2,6,4,5>
  2584316418U, // <6,4,5,3>: Cost 3 vext1 <5,6,4,5>, <3,4,5,6>
  2566401334U, // <6,4,5,4>: Cost 3 vext1 <2,6,4,5>, RHS
  2584318028U, // <6,4,5,5>: Cost 3 vext1 <5,6,4,5>, <5,6,4,5>
  1612287286U, // <6,4,5,6>: Cost 2 vext3 <0,2,4,6>, RHS
  2852965686U, // <6,4,5,7>: Cost 3 vuzpr <5,6,7,4>, RHS
  1612287304U, // <6,4,5,u>: Cost 2 vext3 <0,2,4,6>, RHS
  1504608358U, // <6,4,6,0>: Cost 2 vext1 <4,6,4,6>, LHS
  2578350838U, // <6,4,6,1>: Cost 3 vext1 <4,6,4,6>, <1,0,3,2>
  2578351720U, // <6,4,6,2>: Cost 3 vext1 <4,6,4,6>, <2,2,2,2>
  2578352278U, // <6,4,6,3>: Cost 3 vext1 <4,6,4,6>, <3,0,1,2>
  1504611638U, // <6,4,6,4>: Cost 2 vext1 <4,6,4,6>, RHS
  2578353872U, // <6,4,6,5>: Cost 3 vext1 <4,6,4,6>, <5,1,7,3>
  2578354682U, // <6,4,6,6>: Cost 3 vext1 <4,6,4,6>, <6,2,7,3>
  2578355194U, // <6,4,6,7>: Cost 3 vext1 <4,6,4,6>, <7,0,1,2>
  1504614190U, // <6,4,6,u>: Cost 2 vext1 <4,6,4,6>, LHS
  2572386406U, // <6,4,7,0>: Cost 3 vext1 <3,6,4,7>, LHS
  2572387226U, // <6,4,7,1>: Cost 3 vext1 <3,6,4,7>, <1,2,3,4>
  3640157902U, // <6,4,7,2>: Cost 4 vext1 <2,6,4,7>, <2,3,4,5>
  2572389020U, // <6,4,7,3>: Cost 3 vext1 <3,6,4,7>, <3,6,4,7>
  2572389686U, // <6,4,7,4>: Cost 3 vext1 <3,6,4,7>, RHS
  2980497102U, // <6,4,7,5>: Cost 3 vzipr RHS, <2,3,4,5>
  2980495564U, // <6,4,7,6>: Cost 3 vzipr RHS, <0,2,4,6>
  4054239090U, // <6,4,7,7>: Cost 4 vzipr RHS, <2,5,4,7>
  2572392238U, // <6,4,7,u>: Cost 3 vext1 <3,6,4,7>, LHS
  1504608358U, // <6,4,u,0>: Cost 2 vext1 <4,6,4,6>, LHS
  2629670702U, // <6,4,u,1>: Cost 3 vext2 <2,0,6,4>, LHS
  2566424516U, // <6,4,u,2>: Cost 3 vext1 <2,6,4,u>, <2,6,4,u>
  2584340994U, // <6,4,u,3>: Cost 3 vext1 <5,6,4,u>, <3,4,5,6>
  1640156694U, // <6,4,u,4>: Cost 2 vext3 <4,u,4,6>, <4,u,4,6>
  2629671066U, // <6,4,u,5>: Cost 3 vext2 <2,0,6,4>, RHS
  1612287529U, // <6,4,u,6>: Cost 2 vext3 <0,2,4,6>, RHS
  2852965929U, // <6,4,u,7>: Cost 3 vuzpr <5,6,7,4>, RHS
  1612287547U, // <6,4,u,u>: Cost 2 vext3 <0,2,4,6>, RHS
  3708723200U, // <6,5,0,0>: Cost 4 vext2 <2,u,6,5>, <0,0,0,0>
  2634981478U, // <6,5,0,1>: Cost 3 vext2 <2,u,6,5>, LHS
  3694125260U, // <6,5,0,2>: Cost 4 vext2 <0,4,6,5>, <0,2,4,6>
  3779087962U, // <6,5,0,3>: Cost 4 vext3 <3,4,5,6>, <5,0,3,2>
  3760877154U, // <6,5,0,4>: Cost 4 vext3 <0,4,1,6>, <5,0,4,1>
  4195110916U, // <6,5,0,5>: Cost 4 vtrnr <5,6,7,0>, <5,5,5,5>
  3696779775U, // <6,5,0,6>: Cost 4 vext2 <0,u,6,5>, <0,6,2,7>
  1175212130U, // <6,5,0,7>: Cost 2 vrev <5,6,7,0>
  1175285867U, // <6,5,0,u>: Cost 2 vrev <5,6,u,0>
  2248445988U, // <6,5,1,0>: Cost 3 vrev <5,6,0,1>
  3698107237U, // <6,5,1,1>: Cost 4 vext2 <1,1,6,5>, <1,1,6,5>
  3708724118U, // <6,5,1,2>: Cost 4 vext2 <2,u,6,5>, <1,2,3,0>
  3908575334U, // <6,5,1,3>: Cost 4 vuzpr <2,6,4,5>, LHS
  3716023376U, // <6,5,1,4>: Cost 4 vext2 <4,1,6,5>, <1,4,5,6>
  3708724368U, // <6,5,1,5>: Cost 4 vext2 <2,u,6,5>, <1,5,3,7>
  3767733960U, // <6,5,1,6>: Cost 4 vext3 <1,5,4,6>, <5,1,6,4>
  2712571600U, // <6,5,1,7>: Cost 3 vext3 <4,6,4,6>, <5,1,7,3>
  2712571609U, // <6,5,1,u>: Cost 3 vext3 <4,6,4,6>, <5,1,u,3>
  2578391142U, // <6,5,2,0>: Cost 3 vext1 <4,6,5,2>, LHS
  3704079934U, // <6,5,2,1>: Cost 4 vext2 <2,1,6,5>, <2,1,6,5>
  3708724840U, // <6,5,2,2>: Cost 4 vext2 <2,u,6,5>, <2,2,2,2>
  3705407182U, // <6,5,2,3>: Cost 4 vext2 <2,3,6,5>, <2,3,4,5>
  2578394422U, // <6,5,2,4>: Cost 3 vext1 <4,6,5,2>, RHS
  3717351272U, // <6,5,2,5>: Cost 4 vext2 <4,3,6,5>, <2,5,3,6>
  2634983354U, // <6,5,2,6>: Cost 3 vext2 <2,u,6,5>, <2,6,3,7>
  3115486518U, // <6,5,2,7>: Cost 3 vtrnr <4,6,u,2>, RHS
  2634983541U, // <6,5,2,u>: Cost 3 vext2 <2,u,6,5>, <2,u,6,5>
  3708725398U, // <6,5,3,0>: Cost 4 vext2 <2,u,6,5>, <3,0,1,2>
  3710052631U, // <6,5,3,1>: Cost 4 vext2 <3,1,6,5>, <3,1,6,5>
  3708725606U, // <6,5,3,2>: Cost 4 vext2 <2,u,6,5>, <3,2,6,3>
  3708725660U, // <6,5,3,3>: Cost 4 vext2 <2,u,6,5>, <3,3,3,3>
  2643610114U, // <6,5,3,4>: Cost 3 vext2 <4,3,6,5>, <3,4,5,6>
  3717352010U, // <6,5,3,5>: Cost 4 vext2 <4,3,6,5>, <3,5,4,6>
  3773632358U, // <6,5,3,6>: Cost 4 vext3 <2,5,3,6>, <5,3,6,0>
  2248978533U, // <6,5,3,7>: Cost 3 vrev <5,6,7,3>
  2249052270U, // <6,5,3,u>: Cost 3 vrev <5,6,u,3>
  2596323430U, // <6,5,4,0>: Cost 3 vext1 <7,6,5,4>, LHS
  3716025328U, // <6,5,4,1>: Cost 4 vext2 <4,1,6,5>, <4,1,6,5>
  3716688961U, // <6,5,4,2>: Cost 4 vext2 <4,2,6,5>, <4,2,6,5>
  2643610770U, // <6,5,4,3>: Cost 3 vext2 <4,3,6,5>, <4,3,6,5>
  2596326710U, // <6,5,4,4>: Cost 3 vext1 <7,6,5,4>, RHS
  2634984758U, // <6,5,4,5>: Cost 3 vext2 <2,u,6,5>, RHS
  3767734199U, // <6,5,4,6>: Cost 4 vext3 <1,5,4,6>, <5,4,6,0>
  1643696070U, // <6,5,4,7>: Cost 2 vext3 <5,4,7,6>, <5,4,7,6>
  1643769807U, // <6,5,4,u>: Cost 2 vext3 <5,4,u,6>, <5,4,u,6>
  2578415718U, // <6,5,5,0>: Cost 3 vext1 <4,6,5,5>, LHS
  3652158198U, // <6,5,5,1>: Cost 4 vext1 <4,6,5,5>, <1,0,3,2>
  3652159080U, // <6,5,5,2>: Cost 4 vext1 <4,6,5,5>, <2,2,2,2>
  3652159638U, // <6,5,5,3>: Cost 4 vext1 <4,6,5,5>, <3,0,1,2>
  2578418998U, // <6,5,5,4>: Cost 3 vext1 <4,6,5,5>, RHS
  2712571908U, // <6,5,5,5>: Cost 3 vext3 <4,6,4,6>, <5,5,5,5>
  2718027790U, // <6,5,5,6>: Cost 3 vext3 <5,5,6,6>, <5,5,6,6>
  2712571928U, // <6,5,5,7>: Cost 3 vext3 <4,6,4,6>, <5,5,7,7>
  2712571937U, // <6,5,5,u>: Cost 3 vext3 <4,6,4,6>, <5,5,u,7>
  2705346596U, // <6,5,6,0>: Cost 3 vext3 <3,4,5,6>, <5,6,0,1>
  3767144496U, // <6,5,6,1>: Cost 4 vext3 <1,4,5,6>, <5,6,1,4>
  3773116473U, // <6,5,6,2>: Cost 4 vext3 <2,4,5,6>, <5,6,2,4>
  2705346626U, // <6,5,6,3>: Cost 3 vext3 <3,4,5,6>, <5,6,3,4>
  2705346636U, // <6,5,6,4>: Cost 3 vext3 <3,4,5,6>, <5,6,4,5>
  3908577217U, // <6,5,6,5>: Cost 4 vuzpr <2,6,4,5>, <2,6,4,5>
  2578428728U, // <6,5,6,6>: Cost 3 vext1 <4,6,5,6>, <6,6,6,6>
  2712572002U, // <6,5,6,7>: Cost 3 vext3 <4,6,4,6>, <5,6,7,0>
  2705346668U, // <6,5,6,u>: Cost 3 vext3 <3,4,5,6>, <5,6,u,1>
  2560516198U, // <6,5,7,0>: Cost 3 vext1 <1,6,5,7>, LHS
  2560517363U, // <6,5,7,1>: Cost 3 vext1 <1,6,5,7>, <1,6,5,7>
  2566490060U, // <6,5,7,2>: Cost 3 vext1 <2,6,5,7>, <2,6,5,7>
  3634260118U, // <6,5,7,3>: Cost 4 vext1 <1,6,5,7>, <3,0,1,2>
  2560519478U, // <6,5,7,4>: Cost 3 vext1 <1,6,5,7>, RHS
  2980498650U, // <6,5,7,5>: Cost 3 vzipr RHS, <4,4,5,5>
  2980497922U, // <6,5,7,6>: Cost 3 vzipr RHS, <3,4,5,6>
  3103214902U, // <6,5,7,7>: Cost 3 vtrnr <2,6,3,7>, RHS
  2560522030U, // <6,5,7,u>: Cost 3 vext1 <1,6,5,7>, LHS
  2560524390U, // <6,5,u,0>: Cost 3 vext1 <1,6,5,u>, LHS
  2560525556U, // <6,5,u,1>: Cost 3 vext1 <1,6,5,u>, <1,6,5,u>
  2566498253U, // <6,5,u,2>: Cost 3 vext1 <2,6,5,u>, <2,6,5,u>
  2646931439U, // <6,5,u,3>: Cost 3 vext2 <4,u,6,5>, <u,3,5,7>
  2560527670U, // <6,5,u,4>: Cost 3 vext1 <1,6,5,u>, RHS
  2634987674U, // <6,5,u,5>: Cost 3 vext2 <2,u,6,5>, RHS
  2980506114U, // <6,5,u,6>: Cost 3 vzipr RHS, <3,4,5,6>
  1175277674U, // <6,5,u,7>: Cost 2 vrev <5,6,7,u>
  1175351411U, // <6,5,u,u>: Cost 2 vrev <5,6,u,u>
  2578448486U, // <6,6,0,0>: Cost 3 vext1 <4,6,6,0>, LHS
  1573191782U, // <6,6,0,1>: Cost 2 vext2 <4,u,6,6>, LHS
  2686030124U, // <6,6,0,2>: Cost 3 vext3 <0,2,4,6>, <6,0,2,4>
  3779088690U, // <6,6,0,3>: Cost 4 vext3 <3,4,5,6>, <6,0,3,1>
  2687209788U, // <6,6,0,4>: Cost 3 vext3 <0,4,2,6>, <6,0,4,2>
  3652194000U, // <6,6,0,5>: Cost 4 vext1 <4,6,6,0>, <5,1,7,3>
  2254852914U, // <6,6,0,6>: Cost 3 vrev <6,6,6,0>
  4041575734U, // <6,6,0,7>: Cost 4 vzipr <2,4,6,0>, RHS
  1573192349U, // <6,6,0,u>: Cost 2 vext2 <4,u,6,6>, LHS
  2646934262U, // <6,6,1,0>: Cost 3 vext2 <4,u,6,6>, <1,0,3,2>
  2646934324U, // <6,6,1,1>: Cost 3 vext2 <4,u,6,6>, <1,1,1,1>
  2646934422U, // <6,6,1,2>: Cost 3 vext2 <4,u,6,6>, <1,2,3,0>
  2846785638U, // <6,6,1,3>: Cost 3 vuzpr <4,6,4,6>, LHS
  3760951694U, // <6,6,1,4>: Cost 4 vext3 <0,4,2,6>, <6,1,4,3>
  2646934672U, // <6,6,1,5>: Cost 3 vext2 <4,u,6,6>, <1,5,3,7>
  2712572320U, // <6,6,1,6>: Cost 3 vext3 <4,6,4,6>, <6,1,6,3>
  3775549865U, // <6,6,1,7>: Cost 4 vext3 <2,u,2,6>, <6,1,7,3>
  2846785643U, // <6,6,1,u>: Cost 3 vuzpr <4,6,4,6>, LHS
  3759772094U, // <6,6,2,0>: Cost 4 vext3 <0,2,4,6>, <6,2,0,6>
  3704751676U, // <6,6,2,1>: Cost 4 vext2 <2,2,6,6>, <2,1,6,3>
  2631009936U, // <6,6,2,2>: Cost 3 vext2 <2,2,6,6>, <2,2,6,6>
  2646935206U, // <6,6,2,3>: Cost 3 vext2 <4,u,6,6>, <2,3,0,1>
  3759772127U, // <6,6,2,4>: Cost 4 vext3 <0,2,4,6>, <6,2,4,3>
  3704752004U, // <6,6,2,5>: Cost 4 vext2 <2,2,6,6>, <2,5,6,7>
  2646935482U, // <6,6,2,6>: Cost 3 vext2 <4,u,6,6>, <2,6,3,7>
  2712572410U, // <6,6,2,7>: Cost 3 vext3 <4,6,4,6>, <6,2,7,3>
  2712572419U, // <6,6,2,u>: Cost 3 vext3 <4,6,4,6>, <6,2,u,3>
  2646935702U, // <6,6,3,0>: Cost 3 vext2 <4,u,6,6>, <3,0,1,2>
  3777024534U, // <6,6,3,1>: Cost 4 vext3 <3,1,4,6>, <6,3,1,4>
  3704752453U, // <6,6,3,2>: Cost 4 vext2 <2,2,6,6>, <3,2,2,6>
  2646935964U, // <6,6,3,3>: Cost 3 vext2 <4,u,6,6>, <3,3,3,3>
  2705347122U, // <6,6,3,4>: Cost 3 vext3 <3,4,5,6>, <6,3,4,5>
  3779678778U, // <6,6,3,5>: Cost 4 vext3 <3,5,4,6>, <6,3,5,4>
  2657553069U, // <6,6,3,6>: Cost 3 vext2 <6,6,6,6>, <3,6,6,6>
  4039609654U, // <6,6,3,7>: Cost 4 vzipr <2,1,6,3>, RHS
  2708001366U, // <6,6,3,u>: Cost 3 vext3 <3,u,5,6>, <6,3,u,5>
  2578481254U, // <6,6,4,0>: Cost 3 vext1 <4,6,6,4>, LHS
  3652223734U, // <6,6,4,1>: Cost 4 vext1 <4,6,6,4>, <1,0,3,2>
  3760951922U, // <6,6,4,2>: Cost 4 vext3 <0,4,2,6>, <6,4,2,6>
  3779089019U, // <6,6,4,3>: Cost 4 vext3 <3,4,5,6>, <6,4,3,6>
  1570540772U, // <6,6,4,4>: Cost 2 vext2 <4,4,6,6>, <4,4,6,6>
  1573195062U, // <6,6,4,5>: Cost 2 vext2 <4,u,6,6>, RHS
  2712572560U, // <6,6,4,6>: Cost 3 vext3 <4,6,4,6>, <6,4,6,0>
  2723410591U, // <6,6,4,7>: Cost 3 vext3 <6,4,7,6>, <6,4,7,6>
  1573195304U, // <6,6,4,u>: Cost 2 vext2 <4,u,6,6>, <4,u,6,6>
  3640287334U, // <6,6,5,0>: Cost 4 vext1 <2,6,6,5>, LHS
  2646937296U, // <6,6,5,1>: Cost 3 vext2 <4,u,6,6>, <5,1,7,3>
  3640289235U, // <6,6,5,2>: Cost 4 vext1 <2,6,6,5>, <2,6,6,5>
  3720679279U, // <6,6,5,3>: Cost 4 vext2 <4,u,6,6>, <5,3,7,0>
  2646937542U, // <6,6,5,4>: Cost 3 vext2 <4,u,6,6>, <5,4,7,6>
  2646937604U, // <6,6,5,5>: Cost 3 vext2 <4,u,6,6>, <5,5,5,5>
  2646937698U, // <6,6,5,6>: Cost 3 vext2 <4,u,6,6>, <5,6,7,0>
  2846788918U, // <6,6,5,7>: Cost 3 vuzpr <4,6,4,6>, RHS
  2846788919U, // <6,6,5,u>: Cost 3 vuzpr <4,6,4,6>, RHS
  1516699750U, // <6,6,6,0>: Cost 2 vext1 <6,6,6,6>, LHS
  2590442230U, // <6,6,6,1>: Cost 3 vext1 <6,6,6,6>, <1,0,3,2>
  2646938106U, // <6,6,6,2>: Cost 3 vext2 <4,u,6,6>, <6,2,7,3>
  2590443670U, // <6,6,6,3>: Cost 3 vext1 <6,6,6,6>, <3,0,1,2>
  1516703030U, // <6,6,6,4>: Cost 2 vext1 <6,6,6,6>, RHS
  2590445264U, // <6,6,6,5>: Cost 3 vext1 <6,6,6,6>, <5,1,7,3>
  296144182U, // <6,6,6,6>: Cost 1 vdup2 RHS
  2712572738U, // <6,6,6,7>: Cost 3 vext3 <4,6,4,6>, <6,6,7,7>
  296144182U, // <6,6,6,u>: Cost 1 vdup2 RHS
  2566561894U, // <6,6,7,0>: Cost 3 vext1 <2,6,6,7>, LHS
  3634332924U, // <6,6,7,1>: Cost 4 vext1 <1,6,6,7>, <1,6,6,7>
  2566563797U, // <6,6,7,2>: Cost 3 vext1 <2,6,6,7>, <2,6,6,7>
  2584480258U, // <6,6,7,3>: Cost 3 vext1 <5,6,6,7>, <3,4,5,6>
  2566565174U, // <6,6,7,4>: Cost 3 vext1 <2,6,6,7>, RHS
  2717438846U, // <6,6,7,5>: Cost 3 vext3 <5,4,7,6>, <6,7,5,4>
  2980500280U, // <6,6,7,6>: Cost 3 vzipr RHS, <6,6,6,6>
  1906756918U, // <6,6,7,7>: Cost 2 vzipr RHS, RHS
  1906756919U, // <6,6,7,u>: Cost 2 vzipr RHS, RHS
  1516699750U, // <6,6,u,0>: Cost 2 vext1 <6,6,6,6>, LHS
  1573197614U, // <6,6,u,1>: Cost 2 vext2 <4,u,6,6>, LHS
  2566571990U, // <6,6,u,2>: Cost 3 vext1 <2,6,6,u>, <2,6,6,u>
  2846786205U, // <6,6,u,3>: Cost 3 vuzpr <4,6,4,6>, LHS
  1516703030U, // <6,6,u,4>: Cost 2 vext1 <6,6,6,6>, RHS
  1573197978U, // <6,6,u,5>: Cost 2 vext2 <4,u,6,6>, RHS
  296144182U, // <6,6,u,6>: Cost 1 vdup2 RHS
  1906765110U, // <6,6,u,7>: Cost 2 vzipr RHS, RHS
  296144182U, // <6,6,u,u>: Cost 1 vdup2 RHS
  1571209216U, // <6,7,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
  497467494U, // <6,7,0,1>: Cost 1 vext2 RHS, LHS
  1571209380U, // <6,7,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
  2644951292U, // <6,7,0,3>: Cost 3 vext2 RHS, <0,3,1,0>
  1571209554U, // <6,7,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
  1510756450U, // <6,7,0,5>: Cost 2 vext1 <5,6,7,0>, <5,6,7,0>
  2644951542U, // <6,7,0,6>: Cost 3 vext2 RHS, <0,6,1,7>
  2584499194U, // <6,7,0,7>: Cost 3 vext1 <5,6,7,0>, <7,0,1,2>
  497468061U, // <6,7,0,u>: Cost 1 vext2 RHS, LHS
  1571209974U, // <6,7,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
  1571210036U, // <6,7,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
  1571210134U, // <6,7,1,2>: Cost 2 vext2 RHS, <1,2,3,0>
  1571210200U, // <6,7,1,3>: Cost 2 vext2 RHS, <1,3,1,3>
  2644952098U, // <6,7,1,4>: Cost 3 vext2 RHS, <1,4,0,5>
  1571210384U, // <6,7,1,5>: Cost 2 vext2 RHS, <1,5,3,7>
  2644952271U, // <6,7,1,6>: Cost 3 vext2 RHS, <1,6,1,7>
  2578535418U, // <6,7,1,7>: Cost 3 vext1 <4,6,7,1>, <7,0,1,2>
  1571210605U, // <6,7,1,u>: Cost 2 vext2 RHS, <1,u,1,3>
  2644952509U, // <6,7,2,0>: Cost 3 vext2 RHS, <2,0,1,2>
  2644952582U, // <6,7,2,1>: Cost 3 vext2 RHS, <2,1,0,3>
  1571210856U, // <6,7,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
  1571210918U, // <6,7,2,3>: Cost 2 vext2 RHS, <2,3,0,1>
  2644952828U, // <6,7,2,4>: Cost 3 vext2 RHS, <2,4,0,6>
  2633009028U, // <6,7,2,5>: Cost 3 vext2 <2,5,6,7>, <2,5,6,7>
  1571211194U, // <6,7,2,6>: Cost 2 vext2 RHS, <2,6,3,7>
  2668840938U, // <6,7,2,7>: Cost 3 vext2 RHS, <2,7,0,1>
  1571211323U, // <6,7,2,u>: Cost 2 vext2 RHS, <2,u,0,1>
  1571211414U, // <6,7,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
  2644953311U, // <6,7,3,1>: Cost 3 vext2 RHS, <3,1,0,3>
  2644953390U, // <6,7,3,2>: Cost 3 vext2 RHS, <3,2,0,1>
  1571211676U, // <6,7,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
  1571211778U, // <6,7,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
  2644953648U, // <6,7,3,5>: Cost 3 vext2 RHS, <3,5,1,7>
  2644953720U, // <6,7,3,6>: Cost 3 vext2 RHS, <3,6,0,7>
  2644953795U, // <6,7,3,7>: Cost 3 vext2 RHS, <3,7,0,1>
  1571212062U, // <6,7,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
  1573202834U, // <6,7,4,0>: Cost 2 vext2 RHS, <4,0,5,1>
  2644954058U, // <6,7,4,1>: Cost 3 vext2 RHS, <4,1,2,3>
  2644954166U, // <6,7,4,2>: Cost 3 vext2 RHS, <4,2,5,3>
  2644954258U, // <6,7,4,3>: Cost 3 vext2 RHS, <4,3,6,5>
  1571212496U, // <6,7,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
  497470774U, // <6,7,4,5>: Cost 1 vext2 RHS, RHS
  1573203316U, // <6,7,4,6>: Cost 2 vext2 RHS, <4,6,4,6>
  2646281688U, // <6,7,4,7>: Cost 3 vext2 <4,7,6,7>, <4,7,6,7>
  497471017U, // <6,7,4,u>: Cost 1 vext2 RHS, RHS
  2644954696U, // <6,7,5,0>: Cost 3 vext2 RHS, <5,0,1,2>
  1573203664U, // <6,7,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
  2644954878U, // <6,7,5,2>: Cost 3 vext2 RHS, <5,2,3,4>
  2644954991U, // <6,7,5,3>: Cost 3 vext2 RHS, <5,3,7,0>
  1571213254U, // <6,7,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
  1571213316U, // <6,7,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
  1571213410U, // <6,7,5,6>: Cost 2 vext2 RHS, <5,6,7,0>
  1573204136U, // <6,7,5,7>: Cost 2 vext2 RHS, <5,7,5,7>
  1573204217U, // <6,7,5,u>: Cost 2 vext2 RHS, <5,u,5,7>
  2644955425U, // <6,7,6,0>: Cost 3 vext2 RHS, <6,0,1,2>
  2644955561U, // <6,7,6,1>: Cost 3 vext2 RHS, <6,1,7,3>
  1573204474U, // <6,7,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
  2644955698U, // <6,7,6,3>: Cost 3 vext2 RHS, <6,3,4,5>
  2644955789U, // <6,7,6,4>: Cost 3 vext2 RHS, <6,4,5,6>
  2644955889U, // <6,7,6,5>: Cost 3 vext2 RHS, <6,5,7,7>
  1571214136U, // <6,7,6,6>: Cost 2 vext2 RHS, <6,6,6,6>
  1571214158U, // <6,7,6,7>: Cost 2 vext2 RHS, <6,7,0,1>
  1573204895U, // <6,7,6,u>: Cost 2 vext2 RHS, <6,u,0,1>
  1573204986U, // <6,7,7,0>: Cost 2 vext2 RHS, <7,0,1,2>
  2572608656U, // <6,7,7,1>: Cost 3 vext1 <3,6,7,7>, <1,5,3,7>
  2644956362U, // <6,7,7,2>: Cost 3 vext2 RHS, <7,2,6,3>
  2572610231U, // <6,7,7,3>: Cost 3 vext1 <3,6,7,7>, <3,6,7,7>
  1573205350U, // <6,7,7,4>: Cost 2 vext2 RHS, <7,4,5,6>
  2646947220U, // <6,7,7,5>: Cost 3 vext2 RHS, <7,5,1,7>
  1516786498U, // <6,7,7,6>: Cost 2 vext1 <6,6,7,7>, <6,6,7,7>
  1571214956U, // <6,7,7,7>: Cost 2 vext2 RHS, <7,7,7,7>
  1573205634U, // <6,7,7,u>: Cost 2 vext2 RHS, <7,u,1,2>
  1571215059U, // <6,7,u,0>: Cost 2 vext2 RHS, <u,0,1,2>
  497473326U, // <6,7,u,1>: Cost 1 vext2 RHS, LHS
  1571215237U, // <6,7,u,2>: Cost 2 vext2 RHS, <u,2,3,0>
  1571215292U, // <6,7,u,3>: Cost 2 vext2 RHS, <u,3,0,1>
  1571215423U, // <6,7,u,4>: Cost 2 vext2 RHS, <u,4,5,6>
  497473690U, // <6,7,u,5>: Cost 1 vext2 RHS, RHS
  1571215568U, // <6,7,u,6>: Cost 2 vext2 RHS, <u,6,3,7>
  1573206272U, // <6,7,u,7>: Cost 2 vext2 RHS, <u,7,0,1>
  497473893U, // <6,7,u,u>: Cost 1 vext2 RHS, LHS
  1571217408U, // <6,u,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
  497475686U, // <6,u,0,1>: Cost 1 vext2 RHS, LHS
  1571217572U, // <6,u,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
  2689865445U, // <6,u,0,3>: Cost 3 vext3 <0,u,2,6>, <u,0,3,2>
  1571217746U, // <6,u,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
  1510830187U, // <6,u,0,5>: Cost 2 vext1 <5,6,u,0>, <5,6,u,0>
  2644959734U, // <6,u,0,6>: Cost 3 vext2 RHS, <0,6,1,7>
  1193130221U, // <6,u,0,7>: Cost 2 vrev <u,6,7,0>
  497476253U, // <6,u,0,u>: Cost 1 vext2 RHS, LHS
  1571218166U, // <6,u,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
  1571218228U, // <6,u,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
  1612289838U, // <6,u,1,2>: Cost 2 vext3 <0,2,4,6>, LHS
  1571218392U, // <6,u,1,3>: Cost 2 vext2 RHS, <1,3,1,3>
  2566663478U, // <6,u,1,4>: Cost 3 vext1 <2,6,u,1>, RHS
  1571218576U, // <6,u,1,5>: Cost 2 vext2 RHS, <1,5,3,7>
  2644960463U, // <6,u,1,6>: Cost 3 vext2 RHS, <1,6,1,7>
  2717439835U, // <6,u,1,7>: Cost 3 vext3 <5,4,7,6>, <u,1,7,3>
  1612289892U, // <6,u,1,u>: Cost 2 vext3 <0,2,4,6>, LHS
  1504870502U, // <6,u,2,0>: Cost 2 vext1 <4,6,u,2>, LHS
  2644960774U, // <6,u,2,1>: Cost 3 vext2 RHS, <2,1,0,3>
  1571219048U, // <6,u,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
  1571219110U, // <6,u,2,3>: Cost 2 vext2 RHS, <2,3,0,1>
  1504873782U, // <6,u,2,4>: Cost 2 vext1 <4,6,u,2>, RHS
  2633017221U, // <6,u,2,5>: Cost 3 vext2 <2,5,6,u>, <2,5,6,u>
  1571219386U, // <6,u,2,6>: Cost 2 vext2 RHS, <2,6,3,7>
  2712573868U, // <6,u,2,7>: Cost 3 vext3 <4,6,4,6>, <u,2,7,3>
  1571219515U, // <6,u,2,u>: Cost 2 vext2 RHS, <2,u,0,1>
  1571219606U, // <6,u,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
  2644961503U, // <6,u,3,1>: Cost 3 vext2 RHS, <3,1,0,3>
  2566678499U, // <6,u,3,2>: Cost 3 vext1 <2,6,u,3>, <2,6,u,3>
  1571219868U, // <6,u,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
  1571219970U, // <6,u,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
  2689865711U, // <6,u,3,5>: Cost 3 vext3 <0,u,2,6>, <u,3,5,7>
  2708002806U, // <6,u,3,6>: Cost 3 vext3 <3,u,5,6>, <u,3,6,5>
  2644961987U, // <6,u,3,7>: Cost 3 vext2 RHS, <3,7,0,1>
  1571220254U, // <6,u,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
  1571220370U, // <6,u,4,0>: Cost 2 vext2 RHS, <4,0,5,1>
  2644962250U, // <6,u,4,1>: Cost 3 vext2 RHS, <4,1,2,3>
  1661245476U, // <6,u,4,2>: Cost 2 vext3 <u,4,2,6>, <u,4,2,6>
  2686031917U, // <6,u,4,3>: Cost 3 vext3 <0,2,4,6>, <u,4,3,6>
  1571220688U, // <6,u,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
  497478967U, // <6,u,4,5>: Cost 1 vext2 RHS, RHS
  1571220852U, // <6,u,4,6>: Cost 2 vext2 RHS, <4,6,4,6>
  1661614161U, // <6,u,4,7>: Cost 2 vext3 <u,4,7,6>, <u,4,7,6>
  497479209U, // <6,u,4,u>: Cost 1 vext2 RHS, RHS
  2566692966U, // <6,u,5,0>: Cost 3 vext1 <2,6,u,5>, LHS
  1571221200U, // <6,u,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
  2566694885U, // <6,u,5,2>: Cost 3 vext1 <2,6,u,5>, <2,6,u,5>
  2689865855U, // <6,u,5,3>: Cost 3 vext3 <0,u,2,6>, <u,5,3,7>
  1571221446U, // <6,u,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
  1571221508U, // <6,u,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
  1612290202U, // <6,u,5,6>: Cost 2 vext3 <0,2,4,6>, RHS
  1571221672U, // <6,u,5,7>: Cost 2 vext2 RHS, <5,7,5,7>
  1612290220U, // <6,u,5,u>: Cost 2 vext3 <0,2,4,6>, RHS
  1504903270U, // <6,u,6,0>: Cost 2 vext1 <4,6,u,6>, LHS
  2644963752U, // <6,u,6,1>: Cost 3 vext2 RHS, <6,1,7,2>
  1571222010U, // <6,u,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
  2686032080U, // <6,u,6,3>: Cost 3 vext3 <0,2,4,6>, <u,6,3,7>
  1504906550U, // <6,u,6,4>: Cost 2 vext1 <4,6,u,6>, RHS
  2644964079U, // <6,u,6,5>: Cost 3 vext2 RHS, <6,5,7,5>
  296144182U, // <6,u,6,6>: Cost 1 vdup2 RHS
  1571222350U, // <6,u,6,7>: Cost 2 vext2 RHS, <6,7,0,1>
  296144182U, // <6,u,6,u>: Cost 1 vdup2 RHS
  1492967526U, // <6,u,7,0>: Cost 2 vext1 <2,6,u,7>, LHS
  2560738574U, // <6,u,7,1>: Cost 3 vext1 <1,6,u,7>, <1,6,u,7>
  1492969447U, // <6,u,7,2>: Cost 2 vext1 <2,6,u,7>, <2,6,u,7>
  1906753692U, // <6,u,7,3>: Cost 2 vzipr RHS, LHS
  1492970806U, // <6,u,7,4>: Cost 2 vext1 <2,6,u,7>, RHS
  2980495761U, // <6,u,7,5>: Cost 3 vzipr RHS, <0,4,u,5>
  1516860235U, // <6,u,7,6>: Cost 2 vext1 <6,6,u,7>, <6,6,u,7>
  1906756936U, // <6,u,7,7>: Cost 2 vzipr RHS, RHS
  1492973358U, // <6,u,7,u>: Cost 2 vext1 <2,6,u,7>, LHS
  1492975718U, // <6,u,u,0>: Cost 2 vext1 <2,6,u,u>, LHS
  497481518U, // <6,u,u,1>: Cost 1 vext2 RHS, LHS
  1612290405U, // <6,u,u,2>: Cost 2 vext3 <0,2,4,6>, LHS
  1571223484U, // <6,u,u,3>: Cost 2 vext2 RHS, <u,3,0,1>
  1492978998U, // <6,u,u,4>: Cost 2 vext1 <2,6,u,u>, RHS
  497481882U, // <6,u,u,5>: Cost 1 vext2 RHS, RHS
  296144182U, // <6,u,u,6>: Cost 1 vdup2 RHS
  1906765128U, // <6,u,u,7>: Cost 2 vzipr RHS, RHS
  497482085U, // <6,u,u,u>: Cost 1 vext2 RHS, LHS
  1638318080U, // <7,0,0,0>: Cost 2 vext3 RHS, <0,0,0,0>
  1638318090U, // <7,0,0,1>: Cost 2 vext3 RHS, <0,0,1,1>
  1638318100U, // <7,0,0,2>: Cost 2 vext3 RHS, <0,0,2,2>
  3646442178U, // <7,0,0,3>: Cost 4 vext1 <3,7,0,0>, <3,7,0,0>
  2712059941U, // <7,0,0,4>: Cost 3 vext3 RHS, <0,0,4,1>
  2651603364U, // <7,0,0,5>: Cost 3 vext2 <5,6,7,0>, <0,5,1,6>
  2590618445U, // <7,0,0,6>: Cost 3 vext1 <6,7,0,0>, <6,7,0,0>
  3785801798U, // <7,0,0,7>: Cost 4 vext3 RHS, <0,0,7,7>
  1638318153U, // <7,0,0,u>: Cost 2 vext3 RHS, <0,0,u,1>
  1516879974U, // <7,0,1,0>: Cost 2 vext1 <6,7,0,1>, LHS
  2693922911U, // <7,0,1,1>: Cost 3 vext3 <1,5,3,7>, <0,1,1,5>
  564576358U, // <7,0,1,2>: Cost 1 vext3 RHS, LHS
  2638996480U, // <7,0,1,3>: Cost 3 vext2 <3,5,7,0>, <1,3,5,7>
  1516883254U, // <7,0,1,4>: Cost 2 vext1 <6,7,0,1>, RHS
  2649613456U, // <7,0,1,5>: Cost 3 vext2 <5,3,7,0>, <1,5,3,7>
  1516884814U, // <7,0,1,6>: Cost 2 vext1 <6,7,0,1>, <6,7,0,1>
  2590626808U, // <7,0,1,7>: Cost 3 vext1 <6,7,0,1>, <7,0,1,0>
  564576412U, // <7,0,1,u>: Cost 1 vext3 RHS, LHS
  1638318244U, // <7,0,2,0>: Cost 2 vext3 RHS, <0,2,0,2>
  2692743344U, // <7,0,2,1>: Cost 3 vext3 <1,3,5,7>, <0,2,1,5>
  2712060084U, // <7,0,2,2>: Cost 3 vext3 RHS, <0,2,2,0>
  2712060094U, // <7,0,2,3>: Cost 3 vext3 RHS, <0,2,3,1>
  1638318284U, // <7,0,2,4>: Cost 2 vext3 RHS, <0,2,4,6>
  2712060118U, // <7,0,2,5>: Cost 3 vext3 RHS, <0,2,5,7>
  2651604922U, // <7,0,2,6>: Cost 3 vext2 <5,6,7,0>, <2,6,3,7>
  2686255336U, // <7,0,2,7>: Cost 3 vext3 <0,2,7,7>, <0,2,7,7>
  1638318316U, // <7,0,2,u>: Cost 2 vext3 RHS, <0,2,u,2>
  2651605142U, // <7,0,3,0>: Cost 3 vext2 <5,6,7,0>, <3,0,1,2>
  2712060156U, // <7,0,3,1>: Cost 3 vext3 RHS, <0,3,1,0>
  2712060165U, // <7,0,3,2>: Cost 3 vext3 RHS, <0,3,2,0>
  2651605404U, // <7,0,3,3>: Cost 3 vext2 <5,6,7,0>, <3,3,3,3>
  2651605506U, // <7,0,3,4>: Cost 3 vext2 <5,6,7,0>, <3,4,5,6>
  2638998111U, // <7,0,3,5>: Cost 3 vext2 <3,5,7,0>, <3,5,7,0>
  2639661744U, // <7,0,3,6>: Cost 3 vext2 <3,6,7,0>, <3,6,7,0>
  3712740068U, // <7,0,3,7>: Cost 4 vext2 <3,5,7,0>, <3,7,3,7>
  2640989010U, // <7,0,3,u>: Cost 3 vext2 <3,u,7,0>, <3,u,7,0>
  2712060232U, // <7,0,4,0>: Cost 3 vext3 RHS, <0,4,0,4>
  1638318418U, // <7,0,4,1>: Cost 2 vext3 RHS, <0,4,1,5>
  1638318428U, // <7,0,4,2>: Cost 2 vext3 RHS, <0,4,2,6>
  3646474950U, // <7,0,4,3>: Cost 4 vext1 <3,7,0,4>, <3,7,0,4>
  2712060270U, // <7,0,4,4>: Cost 3 vext3 RHS, <0,4,4,6>
  1577864502U, // <7,0,4,5>: Cost 2 vext2 <5,6,7,0>, RHS
  2651606388U, // <7,0,4,6>: Cost 3 vext2 <5,6,7,0>, <4,6,4,6>
  3787792776U, // <7,0,4,7>: Cost 4 vext3 RHS, <0,4,7,5>
  1638318481U, // <7,0,4,u>: Cost 2 vext3 RHS, <0,4,u,5>
  2590654566U, // <7,0,5,0>: Cost 3 vext1 <6,7,0,5>, LHS
  2651606736U, // <7,0,5,1>: Cost 3 vext2 <5,6,7,0>, <5,1,7,3>
  2712060334U, // <7,0,5,2>: Cost 3 vext3 RHS, <0,5,2,7>
  2649616239U, // <7,0,5,3>: Cost 3 vext2 <5,3,7,0>, <5,3,7,0>
  2651606982U, // <7,0,5,4>: Cost 3 vext2 <5,6,7,0>, <5,4,7,6>
  2651607044U, // <7,0,5,5>: Cost 3 vext2 <5,6,7,0>, <5,5,5,5>
  1577865314U, // <7,0,5,6>: Cost 2 vext2 <5,6,7,0>, <5,6,7,0>
  2651607208U, // <7,0,5,7>: Cost 3 vext2 <5,6,7,0>, <5,7,5,7>
  1579192580U, // <7,0,5,u>: Cost 2 vext2 <5,u,7,0>, <5,u,7,0>
  2688393709U, // <7,0,6,0>: Cost 3 vext3 <0,6,0,7>, <0,6,0,7>
  2712060406U, // <7,0,6,1>: Cost 3 vext3 RHS, <0,6,1,7>
  2688541183U, // <7,0,6,2>: Cost 3 vext3 <0,6,2,7>, <0,6,2,7>
  2655588936U, // <7,0,6,3>: Cost 3 vext2 <6,3,7,0>, <6,3,7,0>
  3762430481U, // <7,0,6,4>: Cost 4 vext3 <0,6,4,7>, <0,6,4,7>
  2651607730U, // <7,0,6,5>: Cost 3 vext2 <5,6,7,0>, <6,5,0,7>
  2651607864U, // <7,0,6,6>: Cost 3 vext2 <5,6,7,0>, <6,6,6,6>
  2651607886U, // <7,0,6,7>: Cost 3 vext2 <5,6,7,0>, <6,7,0,1>
  2688983605U, // <7,0,6,u>: Cost 3 vext3 <0,6,u,7>, <0,6,u,7>
  2651608058U, // <7,0,7,0>: Cost 3 vext2 <5,6,7,0>, <7,0,1,2>
  2932703334U, // <7,0,7,1>: Cost 3 vzipl <7,7,7,7>, LHS
  3066921062U, // <7,0,7,2>: Cost 3 vtrnl <7,7,7,7>, LHS
  3712742678U, // <7,0,7,3>: Cost 4 vext2 <3,5,7,0>, <7,3,5,7>
  2651608422U, // <7,0,7,4>: Cost 3 vext2 <5,6,7,0>, <7,4,5,6>
  2651608513U, // <7,0,7,5>: Cost 3 vext2 <5,6,7,0>, <7,5,6,7>
  2663552532U, // <7,0,7,6>: Cost 3 vext2 <7,6,7,0>, <7,6,7,0>
  2651608684U, // <7,0,7,7>: Cost 3 vext2 <5,6,7,0>, <7,7,7,7>
  2651608706U, // <7,0,7,u>: Cost 3 vext2 <5,6,7,0>, <7,u,1,2>
  1638318730U, // <7,0,u,0>: Cost 2 vext3 RHS, <0,u,0,2>
  1638318738U, // <7,0,u,1>: Cost 2 vext3 RHS, <0,u,1,1>
  564576925U, // <7,0,u,2>: Cost 1 vext3 RHS, LHS
  2572765898U, // <7,0,u,3>: Cost 3 vext1 <3,7,0,u>, <3,7,0,u>
  1638318770U, // <7,0,u,4>: Cost 2 vext3 RHS, <0,u,4,6>
  1577867418U, // <7,0,u,5>: Cost 2 vext2 <5,6,7,0>, RHS
  1516942165U, // <7,0,u,6>: Cost 2 vext1 <6,7,0,u>, <6,7,0,u>
  2651609344U, // <7,0,u,7>: Cost 3 vext2 <5,6,7,0>, <u,7,0,1>
  564576979U, // <7,0,u,u>: Cost 1 vext3 RHS, LHS
  2590687334U, // <7,1,0,0>: Cost 3 vext1 <6,7,1,0>, LHS
  2639003750U, // <7,1,0,1>: Cost 3 vext2 <3,5,7,1>, LHS
  2793357414U, // <7,1,0,2>: Cost 3 vuzpl <7,0,1,2>, LHS
  1638318838U, // <7,1,0,3>: Cost 2 vext3 RHS, <1,0,3,2>
  2590690614U, // <7,1,0,4>: Cost 3 vext1 <6,7,1,0>, RHS
  2712060679U, // <7,1,0,5>: Cost 3 vext3 RHS, <1,0,5,1>
  2590692182U, // <7,1,0,6>: Cost 3 vext1 <6,7,1,0>, <6,7,1,0>
  3785802521U, // <7,1,0,7>: Cost 4 vext3 RHS, <1,0,7,1>
  1638318883U, // <7,1,0,u>: Cost 2 vext3 RHS, <1,0,u,2>
  2712060715U, // <7,1,1,0>: Cost 3 vext3 RHS, <1,1,0,1>
  1638318900U, // <7,1,1,1>: Cost 2 vext3 RHS, <1,1,1,1>
  3774300994U, // <7,1,1,2>: Cost 4 vext3 <2,6,3,7>, <1,1,2,6>
  1638318920U, // <7,1,1,3>: Cost 2 vext3 RHS, <1,1,3,3>
  2712060755U, // <7,1,1,4>: Cost 3 vext3 RHS, <1,1,4,5>
  2691416926U, // <7,1,1,5>: Cost 3 vext3 <1,1,5,7>, <1,1,5,7>
  2590700375U, // <7,1,1,6>: Cost 3 vext1 <6,7,1,1>, <6,7,1,1>
  3765158766U, // <7,1,1,7>: Cost 4 vext3 <1,1,5,7>, <1,1,7,5>
  1638318965U, // <7,1,1,u>: Cost 2 vext3 RHS, <1,1,u,3>
  2712060796U, // <7,1,2,0>: Cost 3 vext3 RHS, <1,2,0,1>
  2712060807U, // <7,1,2,1>: Cost 3 vext3 RHS, <1,2,1,3>
  3712747112U, // <7,1,2,2>: Cost 4 vext2 <3,5,7,1>, <2,2,2,2>
  1638318998U, // <7,1,2,3>: Cost 2 vext3 RHS, <1,2,3,0>
  2712060836U, // <7,1,2,4>: Cost 3 vext3 RHS, <1,2,4,5>
  2712060843U, // <7,1,2,5>: Cost 3 vext3 RHS, <1,2,5,3>
  2590708568U, // <7,1,2,6>: Cost 3 vext1 <6,7,1,2>, <6,7,1,2>
  2735948730U, // <7,1,2,7>: Cost 3 vext3 RHS, <1,2,7,0>
  1638319043U, // <7,1,2,u>: Cost 2 vext3 RHS, <1,2,u,0>
  2712060876U, // <7,1,3,0>: Cost 3 vext3 RHS, <1,3,0,0>
  1638319064U, // <7,1,3,1>: Cost 2 vext3 RHS, <1,3,1,3>
  2712060894U, // <7,1,3,2>: Cost 3 vext3 RHS, <1,3,2,0>
  2692596718U, // <7,1,3,3>: Cost 3 vext3 <1,3,3,7>, <1,3,3,7>
  2712060917U, // <7,1,3,4>: Cost 3 vext3 RHS, <1,3,4,5>
  1619002368U, // <7,1,3,5>: Cost 2 vext3 <1,3,5,7>, <1,3,5,7>
  2692817929U, // <7,1,3,6>: Cost 3 vext3 <1,3,6,7>, <1,3,6,7>
  2735948814U, // <7,1,3,7>: Cost 3 vext3 RHS, <1,3,7,3>
  1619223579U, // <7,1,3,u>: Cost 2 vext3 <1,3,u,7>, <1,3,u,7>
  2712060962U, // <7,1,4,0>: Cost 3 vext3 RHS, <1,4,0,5>
  2712060971U, // <7,1,4,1>: Cost 3 vext3 RHS, <1,4,1,5>
  2712060980U, // <7,1,4,2>: Cost 3 vext3 RHS, <1,4,2,5>
  2712060989U, // <7,1,4,3>: Cost 3 vext3 RHS, <1,4,3,5>
  3785802822U, // <7,1,4,4>: Cost 4 vext3 RHS, <1,4,4,5>
  2639007030U, // <7,1,4,5>: Cost 3 vext2 <3,5,7,1>, RHS
  2645642634U, // <7,1,4,6>: Cost 3 vext2 <4,6,7,1>, <4,6,7,1>
  3719384520U, // <7,1,4,7>: Cost 4 vext2 <4,6,7,1>, <4,7,5,0>
  2639007273U, // <7,1,4,u>: Cost 3 vext2 <3,5,7,1>, RHS
  2572812390U, // <7,1,5,0>: Cost 3 vext1 <3,7,1,5>, LHS
  2693776510U, // <7,1,5,1>: Cost 3 vext3 <1,5,1,7>, <1,5,1,7>
  3774301318U, // <7,1,5,2>: Cost 4 vext3 <2,6,3,7>, <1,5,2,6>
  1620182160U, // <7,1,5,3>: Cost 2 vext3 <1,5,3,7>, <1,5,3,7>
  2572815670U, // <7,1,5,4>: Cost 3 vext1 <3,7,1,5>, RHS
  3766486178U, // <7,1,5,5>: Cost 4 vext3 <1,3,5,7>, <1,5,5,7>
  2651615331U, // <7,1,5,6>: Cost 3 vext2 <5,6,7,1>, <5,6,7,1>
  2652278964U, // <7,1,5,7>: Cost 3 vext2 <5,7,7,1>, <5,7,7,1>
  1620550845U, // <7,1,5,u>: Cost 2 vext3 <1,5,u,7>, <1,5,u,7>
  3768108230U, // <7,1,6,0>: Cost 4 vext3 <1,6,0,7>, <1,6,0,7>
  2694440143U, // <7,1,6,1>: Cost 3 vext3 <1,6,1,7>, <1,6,1,7>
  2712061144U, // <7,1,6,2>: Cost 3 vext3 RHS, <1,6,2,7>
  2694587617U, // <7,1,6,3>: Cost 3 vext3 <1,6,3,7>, <1,6,3,7>
  3768403178U, // <7,1,6,4>: Cost 4 vext3 <1,6,4,7>, <1,6,4,7>
  2694735091U, // <7,1,6,5>: Cost 3 vext3 <1,6,5,7>, <1,6,5,7>
  3768550652U, // <7,1,6,6>: Cost 4 vext3 <1,6,6,7>, <1,6,6,7>
  2652279630U, // <7,1,6,7>: Cost 3 vext2 <5,7,7,1>, <6,7,0,1>
  2694956302U, // <7,1,6,u>: Cost 3 vext3 <1,6,u,7>, <1,6,u,7>
  2645644282U, // <7,1,7,0>: Cost 3 vext2 <4,6,7,1>, <7,0,1,2>
  2859062094U, // <7,1,7,1>: Cost 3 vuzpr <6,7,0,1>, <6,7,0,1>
  3779462437U, // <7,1,7,2>: Cost 4 vext3 <3,5,1,7>, <1,7,2,3>
  3121938534U, // <7,1,7,3>: Cost 3 vtrnr <5,7,5,7>, LHS
  2554916150U, // <7,1,7,4>: Cost 3 vext1 <0,7,1,7>, RHS
  3769140548U, // <7,1,7,5>: Cost 4 vext3 <1,7,5,7>, <1,7,5,7>
  3726022164U, // <7,1,7,6>: Cost 4 vext2 <5,7,7,1>, <7,6,7,0>
  2554918508U, // <7,1,7,7>: Cost 3 vext1 <0,7,1,7>, <7,7,7,7>
  3121938539U, // <7,1,7,u>: Cost 3 vtrnr <5,7,5,7>, LHS
  2572836966U, // <7,1,u,0>: Cost 3 vext1 <3,7,1,u>, LHS
  1638319469U, // <7,1,u,1>: Cost 2 vext3 RHS, <1,u,1,3>
  2712061299U, // <7,1,u,2>: Cost 3 vext3 RHS, <1,u,2,0>
  1622173059U, // <7,1,u,3>: Cost 2 vext3 <1,u,3,7>, <1,u,3,7>
  2572840246U, // <7,1,u,4>: Cost 3 vext1 <3,7,1,u>, RHS
  1622320533U, // <7,1,u,5>: Cost 2 vext3 <1,u,5,7>, <1,u,5,7>
  2696136094U, // <7,1,u,6>: Cost 3 vext3 <1,u,6,7>, <1,u,6,7>
  2859060777U, // <7,1,u,7>: Cost 3 vuzpr <6,7,0,1>, RHS
  1622541744U, // <7,1,u,u>: Cost 2 vext3 <1,u,u,7>, <1,u,u,7>
  2712061364U, // <7,2,0,0>: Cost 3 vext3 RHS, <2,0,0,2>
  2712061373U, // <7,2,0,1>: Cost 3 vext3 RHS, <2,0,1,2>
  2712061380U, // <7,2,0,2>: Cost 3 vext3 RHS, <2,0,2,0>
  2712061389U, // <7,2,0,3>: Cost 3 vext3 RHS, <2,0,3,0>
  2712061404U, // <7,2,0,4>: Cost 3 vext3 RHS, <2,0,4,6>
  2696725990U, // <7,2,0,5>: Cost 3 vext3 <2,0,5,7>, <2,0,5,7>
  2712061417U, // <7,2,0,6>: Cost 3 vext3 RHS, <2,0,6,1>
  3785803251U, // <7,2,0,7>: Cost 4 vext3 RHS, <2,0,7,2>
  2696947201U, // <7,2,0,u>: Cost 3 vext3 <2,0,u,7>, <2,0,u,7>
  2712061446U, // <7,2,1,0>: Cost 3 vext3 RHS, <2,1,0,3>
  3785803276U, // <7,2,1,1>: Cost 4 vext3 RHS, <2,1,1,0>
  3785803285U, // <7,2,1,2>: Cost 4 vext3 RHS, <2,1,2,0>
  2712061471U, // <7,2,1,3>: Cost 3 vext3 RHS, <2,1,3,1>
  2712061482U, // <7,2,1,4>: Cost 3 vext3 RHS, <2,1,4,3>
  3766486576U, // <7,2,1,5>: Cost 4 vext3 <1,3,5,7>, <2,1,5,0>
  2712061500U, // <7,2,1,6>: Cost 3 vext3 RHS, <2,1,6,3>
  2602718850U, // <7,2,1,7>: Cost 3 vext1 <u,7,2,1>, <7,u,1,2>
  2712061516U, // <7,2,1,u>: Cost 3 vext3 RHS, <2,1,u,1>
  2712061525U, // <7,2,2,0>: Cost 3 vext3 RHS, <2,2,0,1>
  2712061536U, // <7,2,2,1>: Cost 3 vext3 RHS, <2,2,1,3>
  1638319720U, // <7,2,2,2>: Cost 2 vext3 RHS, <2,2,2,2>
  1638319730U, // <7,2,2,3>: Cost 2 vext3 RHS, <2,2,3,3>
  2712061565U, // <7,2,2,4>: Cost 3 vext3 RHS, <2,2,4,5>
  2698053256U, // <7,2,2,5>: Cost 3 vext3 <2,2,5,7>, <2,2,5,7>
  2712061584U, // <7,2,2,6>: Cost 3 vext3 RHS, <2,2,6,6>
  3771795096U, // <7,2,2,7>: Cost 4 vext3 <2,2,5,7>, <2,2,7,5>
  1638319775U, // <7,2,2,u>: Cost 2 vext3 RHS, <2,2,u,3>
  1638319782U, // <7,2,3,0>: Cost 2 vext3 RHS, <2,3,0,1>
  2693924531U, // <7,2,3,1>: Cost 3 vext3 <1,5,3,7>, <2,3,1,5>
  2700560061U, // <7,2,3,2>: Cost 3 vext3 <2,6,3,7>, <2,3,2,6>
  2693924551U, // <7,2,3,3>: Cost 3 vext3 <1,5,3,7>, <2,3,3,7>
  1638319822U, // <7,2,3,4>: Cost 2 vext3 RHS, <2,3,4,5>
  2698716889U, // <7,2,3,5>: Cost 3 vext3 <2,3,5,7>, <2,3,5,7>
  2712061665U, // <7,2,3,6>: Cost 3 vext3 RHS, <2,3,6,6>
  2735949540U, // <7,2,3,7>: Cost 3 vext3 RHS, <2,3,7,0>
  1638319854U, // <7,2,3,u>: Cost 2 vext3 RHS, <2,3,u,1>
  2712061692U, // <7,2,4,0>: Cost 3 vext3 RHS, <2,4,0,6>
  2712061698U, // <7,2,4,1>: Cost 3 vext3 RHS, <2,4,1,3>
  2712061708U, // <7,2,4,2>: Cost 3 vext3 RHS, <2,4,2,4>
  2712061718U, // <7,2,4,3>: Cost 3 vext3 RHS, <2,4,3,5>
  2712061728U, // <7,2,4,4>: Cost 3 vext3 RHS, <2,4,4,6>
  2699380522U, // <7,2,4,5>: Cost 3 vext3 <2,4,5,7>, <2,4,5,7>
  2712061740U, // <7,2,4,6>: Cost 3 vext3 RHS, <2,4,6,0>
  3809691445U, // <7,2,4,7>: Cost 4 vext3 RHS, <2,4,7,0>
  2699601733U, // <7,2,4,u>: Cost 3 vext3 <2,4,u,7>, <2,4,u,7>
  2699675470U, // <7,2,5,0>: Cost 3 vext3 <2,5,0,7>, <2,5,0,7>
  3766486867U, // <7,2,5,1>: Cost 4 vext3 <1,3,5,7>, <2,5,1,3>
  2699822944U, // <7,2,5,2>: Cost 3 vext3 <2,5,2,7>, <2,5,2,7>
  2692745065U, // <7,2,5,3>: Cost 3 vext3 <1,3,5,7>, <2,5,3,7>
  2699970418U, // <7,2,5,4>: Cost 3 vext3 <2,5,4,7>, <2,5,4,7>
  3766486907U, // <7,2,5,5>: Cost 4 vext3 <1,3,5,7>, <2,5,5,7>
  2700117892U, // <7,2,5,6>: Cost 3 vext3 <2,5,6,7>, <2,5,6,7>
  3771795334U, // <7,2,5,7>: Cost 4 vext3 <2,2,5,7>, <2,5,7,0>
  2692745110U, // <7,2,5,u>: Cost 3 vext3 <1,3,5,7>, <2,5,u,7>
  2572894310U, // <7,2,6,0>: Cost 3 vext1 <3,7,2,6>, LHS
  2712061860U, // <7,2,6,1>: Cost 3 vext3 RHS, <2,6,1,3>
  2700486577U, // <7,2,6,2>: Cost 3 vext3 <2,6,2,7>, <2,6,2,7>
  1626818490U, // <7,2,6,3>: Cost 2 vext3 <2,6,3,7>, <2,6,3,7>
  2572897590U, // <7,2,6,4>: Cost 3 vext1 <3,7,2,6>, RHS
  2700707788U, // <7,2,6,5>: Cost 3 vext3 <2,6,5,7>, <2,6,5,7>
  2700781525U, // <7,2,6,6>: Cost 3 vext3 <2,6,6,7>, <2,6,6,7>
  3774597086U, // <7,2,6,7>: Cost 4 vext3 <2,6,7,7>, <2,6,7,7>
  1627187175U, // <7,2,6,u>: Cost 2 vext3 <2,6,u,7>, <2,6,u,7>
  2735949802U, // <7,2,7,0>: Cost 3 vext3 RHS, <2,7,0,1>
  3780200434U, // <7,2,7,1>: Cost 4 vext3 <3,6,2,7>, <2,7,1,0>
  3773564928U, // <7,2,7,2>: Cost 4 vext3 <2,5,2,7>, <2,7,2,5>
  2986541158U, // <7,2,7,3>: Cost 3 vzipr <5,5,7,7>, LHS
  2554989878U, // <7,2,7,4>: Cost 3 vext1 <0,7,2,7>, RHS
  3775113245U, // <7,2,7,5>: Cost 4 vext3 <2,7,5,7>, <2,7,5,7>
  4060283228U, // <7,2,7,6>: Cost 4 vzipr <5,5,7,7>, <0,4,2,6>
  2554992236U, // <7,2,7,7>: Cost 3 vext1 <0,7,2,7>, <7,7,7,7>
  2986541163U, // <7,2,7,u>: Cost 3 vzipr <5,5,7,7>, LHS
  1638320187U, // <7,2,u,0>: Cost 2 vext3 RHS, <2,u,0,1>
  2693924936U, // <7,2,u,1>: Cost 3 vext3 <1,5,3,7>, <2,u,1,5>
  1638319720U, // <7,2,u,2>: Cost 2 vext3 RHS, <2,2,2,2>
  1628145756U, // <7,2,u,3>: Cost 2 vext3 <2,u,3,7>, <2,u,3,7>
  1638320227U, // <7,2,u,4>: Cost 2 vext3 RHS, <2,u,4,5>
  2702035054U, // <7,2,u,5>: Cost 3 vext3 <2,u,5,7>, <2,u,5,7>
  2702108791U, // <7,2,u,6>: Cost 3 vext3 <2,u,6,7>, <2,u,6,7>
  2735949945U, // <7,2,u,7>: Cost 3 vext3 RHS, <2,u,7,0>
  1628514441U, // <7,2,u,u>: Cost 2 vext3 <2,u,u,7>, <2,u,u,7>
  2712062091U, // <7,3,0,0>: Cost 3 vext3 RHS, <3,0,0,0>
  1638320278U, // <7,3,0,1>: Cost 2 vext3 RHS, <3,0,1,2>
  2712062109U, // <7,3,0,2>: Cost 3 vext3 RHS, <3,0,2,0>
  2590836886U, // <7,3,0,3>: Cost 3 vext1 <6,7,3,0>, <3,0,1,2>
  2712062128U, // <7,3,0,4>: Cost 3 vext3 RHS, <3,0,4,1>
  2712062138U, // <7,3,0,5>: Cost 3 vext3 RHS, <3,0,5,2>
  2590839656U, // <7,3,0,6>: Cost 3 vext1 <6,7,3,0>, <6,7,3,0>
  3311414017U, // <7,3,0,7>: Cost 4 vrev <3,7,7,0>
  1638320341U, // <7,3,0,u>: Cost 2 vext3 RHS, <3,0,u,2>
  2237164227U, // <7,3,1,0>: Cost 3 vrev <3,7,0,1>
  2712062182U, // <7,3,1,1>: Cost 3 vext3 RHS, <3,1,1,1>
  2712062193U, // <7,3,1,2>: Cost 3 vext3 RHS, <3,1,2,3>
  2692745468U, // <7,3,1,3>: Cost 3 vext3 <1,3,5,7>, <3,1,3,5>
  2712062214U, // <7,3,1,4>: Cost 3 vext3 RHS, <3,1,4,6>
  2693925132U, // <7,3,1,5>: Cost 3 vext3 <1,5,3,7>, <3,1,5,3>
  3768183059U, // <7,3,1,6>: Cost 4 vext3 <1,6,1,7>, <3,1,6,1>
  2692745504U, // <7,3,1,7>: Cost 3 vext3 <1,3,5,7>, <3,1,7,5>
  2696063273U, // <7,3,1,u>: Cost 3 vext3 <1,u,5,7>, <3,1,u,5>
  2712062254U, // <7,3,2,0>: Cost 3 vext3 RHS, <3,2,0,1>
  2712062262U, // <7,3,2,1>: Cost 3 vext3 RHS, <3,2,1,0>
  2712062273U, // <7,3,2,2>: Cost 3 vext3 RHS, <3,2,2,2>
  2712062280U, // <7,3,2,3>: Cost 3 vext3 RHS, <3,2,3,0>
  2712062294U, // <7,3,2,4>: Cost 3 vext3 RHS, <3,2,4,5>
  2712062302U, // <7,3,2,5>: Cost 3 vext3 RHS, <3,2,5,4>
  2700560742U, // <7,3,2,6>: Cost 3 vext3 <2,6,3,7>, <3,2,6,3>
  2712062319U, // <7,3,2,7>: Cost 3 vext3 RHS, <3,2,7,3>
  2712062325U, // <7,3,2,u>: Cost 3 vext3 RHS, <3,2,u,0>
  2712062335U, // <7,3,3,0>: Cost 3 vext3 RHS, <3,3,0,1>
  2636368158U, // <7,3,3,1>: Cost 3 vext2 <3,1,7,3>, <3,1,7,3>
  2637031791U, // <7,3,3,2>: Cost 3 vext2 <3,2,7,3>, <3,2,7,3>
  1638320540U, // <7,3,3,3>: Cost 2 vext3 RHS, <3,3,3,3>
  2712062374U, // <7,3,3,4>: Cost 3 vext3 RHS, <3,3,4,4>
  2704689586U, // <7,3,3,5>: Cost 3 vext3 <3,3,5,7>, <3,3,5,7>
  2590864235U, // <7,3,3,6>: Cost 3 vext1 <6,7,3,3>, <6,7,3,3>
  2704837060U, // <7,3,3,7>: Cost 3 vext3 <3,3,7,7>, <3,3,7,7>
  1638320540U, // <7,3,3,u>: Cost 2 vext3 RHS, <3,3,3,3>
  2712062416U, // <7,3,4,0>: Cost 3 vext3 RHS, <3,4,0,1>
  2712062426U, // <7,3,4,1>: Cost 3 vext3 RHS, <3,4,1,2>
  2566981640U, // <7,3,4,2>: Cost 3 vext1 <2,7,3,4>, <2,7,3,4>
  2712062447U, // <7,3,4,3>: Cost 3 vext3 RHS, <3,4,3,5>
  2712062456U, // <7,3,4,4>: Cost 3 vext3 RHS, <3,4,4,5>
  1638320642U, // <7,3,4,5>: Cost 2 vext3 RHS, <3,4,5,6>
  2648313204U, // <7,3,4,6>: Cost 3 vext2 <5,1,7,3>, <4,6,4,6>
  3311446789U, // <7,3,4,7>: Cost 4 vrev <3,7,7,4>
  1638320669U, // <7,3,4,u>: Cost 2 vext3 RHS, <3,4,u,6>
  2602819686U, // <7,3,5,0>: Cost 3 vext1 <u,7,3,5>, LHS
  1574571728U, // <7,3,5,1>: Cost 2 vext2 <5,1,7,3>, <5,1,7,3>
  2648977185U, // <7,3,5,2>: Cost 3 vext2 <5,2,7,3>, <5,2,7,3>
  2705869378U, // <7,3,5,3>: Cost 3 vext3 <3,5,3,7>, <3,5,3,7>
  2237491947U, // <7,3,5,4>: Cost 3 vrev <3,7,4,5>
  2706016852U, // <7,3,5,5>: Cost 3 vext3 <3,5,5,7>, <3,5,5,7>
  2648313954U, // <7,3,5,6>: Cost 3 vext2 <5,1,7,3>, <5,6,7,0>
  2692745823U, // <7,3,5,7>: Cost 3 vext3 <1,3,5,7>, <3,5,7,0>
  1579217159U, // <7,3,5,u>: Cost 2 vext2 <5,u,7,3>, <5,u,7,3>
  2706311800U, // <7,3,6,0>: Cost 3 vext3 <3,6,0,7>, <3,6,0,7>
  2654286249U, // <7,3,6,1>: Cost 3 vext2 <6,1,7,3>, <6,1,7,3>
  1581208058U, // <7,3,6,2>: Cost 2 vext2 <6,2,7,3>, <6,2,7,3>
  2706533011U, // <7,3,6,3>: Cost 3 vext3 <3,6,3,7>, <3,6,3,7>
  2706606748U, // <7,3,6,4>: Cost 3 vext3 <3,6,4,7>, <3,6,4,7>
  3780422309U, // <7,3,6,5>: Cost 4 vext3 <3,6,5,7>, <3,6,5,7>
  2712062637U, // <7,3,6,6>: Cost 3 vext3 RHS, <3,6,6,6>
  2706827959U, // <7,3,6,7>: Cost 3 vext3 <3,6,7,7>, <3,6,7,7>
  1585189856U, // <7,3,6,u>: Cost 2 vext2 <6,u,7,3>, <6,u,7,3>
  2693925571U, // <7,3,7,0>: Cost 3 vext3 <1,5,3,7>, <3,7,0,1>
  2693925584U, // <7,3,7,1>: Cost 3 vext3 <1,5,3,7>, <3,7,1,5>
  2700561114U, // <7,3,7,2>: Cost 3 vext3 <2,6,3,7>, <3,7,2,6>
  2572978916U, // <7,3,7,3>: Cost 3 vext1 <3,7,3,7>, <3,7,3,7>
  2693925611U, // <7,3,7,4>: Cost 3 vext3 <1,5,3,7>, <3,7,4,5>
  2707344118U, // <7,3,7,5>: Cost 3 vext3 <3,7,5,7>, <3,7,5,7>
  2654950894U, // <7,3,7,6>: Cost 3 vext2 <6,2,7,3>, <7,6,2,7>
  2648315500U, // <7,3,7,7>: Cost 3 vext2 <5,1,7,3>, <7,7,7,7>
  2693925643U, // <7,3,7,u>: Cost 3 vext3 <1,5,3,7>, <3,7,u,1>
  2237221578U, // <7,3,u,0>: Cost 3 vrev <3,7,0,u>
  1638320926U, // <7,3,u,1>: Cost 2 vext3 RHS, <3,u,1,2>
  1593153452U, // <7,3,u,2>: Cost 2 vext2 <u,2,7,3>, <u,2,7,3>
  1638320540U, // <7,3,u,3>: Cost 2 vext3 RHS, <3,3,3,3>
  2237516526U, // <7,3,u,4>: Cost 3 vrev <3,7,4,u>
  1638320966U, // <7,3,u,5>: Cost 2 vext3 RHS, <3,u,5,6>
  2712062796U, // <7,3,u,6>: Cost 3 vext3 RHS, <3,u,6,3>
  2692967250U, // <7,3,u,7>: Cost 3 vext3 <1,3,u,7>, <3,u,7,0>
  1638320989U, // <7,3,u,u>: Cost 2 vext3 RHS, <3,u,u,2>
  2651635712U, // <7,4,0,0>: Cost 3 vext2 <5,6,7,4>, <0,0,0,0>
  1577893990U, // <7,4,0,1>: Cost 2 vext2 <5,6,7,4>, LHS
  2651635876U, // <7,4,0,2>: Cost 3 vext2 <5,6,7,4>, <0,2,0,2>
  3785804672U, // <7,4,0,3>: Cost 4 vext3 RHS, <4,0,3,1>
  2651636050U, // <7,4,0,4>: Cost 3 vext2 <5,6,7,4>, <0,4,1,5>
  1638468498U, // <7,4,0,5>: Cost 2 vext3 RHS, <4,0,5,1>
  1638468508U, // <7,4,0,6>: Cost 2 vext3 RHS, <4,0,6,2>
  3787795364U, // <7,4,0,7>: Cost 4 vext3 RHS, <4,0,7,1>
  1640459181U, // <7,4,0,u>: Cost 2 vext3 RHS, <4,0,u,1>
  2651636470U, // <7,4,1,0>: Cost 3 vext2 <5,6,7,4>, <1,0,3,2>
  2651636532U, // <7,4,1,1>: Cost 3 vext2 <5,6,7,4>, <1,1,1,1>
  2712062922U, // <7,4,1,2>: Cost 3 vext3 RHS, <4,1,2,3>
  2639029248U, // <7,4,1,3>: Cost 3 vext2 <3,5,7,4>, <1,3,5,7>
  2712062940U, // <7,4,1,4>: Cost 3 vext3 RHS, <4,1,4,3>
  2712062946U, // <7,4,1,5>: Cost 3 vext3 RHS, <4,1,5,0>
  2712062958U, // <7,4,1,6>: Cost 3 vext3 RHS, <4,1,6,3>
  3785804791U, // <7,4,1,7>: Cost 4 vext3 RHS, <4,1,7,3>
  2712062973U, // <7,4,1,u>: Cost 3 vext3 RHS, <4,1,u,0>
  3785804807U, // <7,4,2,0>: Cost 4 vext3 RHS, <4,2,0,1>
  3785804818U, // <7,4,2,1>: Cost 4 vext3 RHS, <4,2,1,3>
  2651637352U, // <7,4,2,2>: Cost 3 vext2 <5,6,7,4>, <2,2,2,2>
  2651637414U, // <7,4,2,3>: Cost 3 vext2 <5,6,7,4>, <2,3,0,1>
  3716753194U, // <7,4,2,4>: Cost 4 vext2 <4,2,7,4>, <2,4,5,7>
  2712063030U, // <7,4,2,5>: Cost 3 vext3 RHS, <4,2,5,3>
  2712063036U, // <7,4,2,6>: Cost 3 vext3 RHS, <4,2,6,0>
  3773123658U, // <7,4,2,7>: Cost 4 vext3 <2,4,5,7>, <4,2,7,5>
  2712063054U, // <7,4,2,u>: Cost 3 vext3 RHS, <4,2,u,0>
  2651637910U, // <7,4,3,0>: Cost 3 vext2 <5,6,7,4>, <3,0,1,2>
  3712772348U, // <7,4,3,1>: Cost 4 vext2 <3,5,7,4>, <3,1,3,5>
  3785804906U, // <7,4,3,2>: Cost 4 vext3 RHS, <4,3,2,1>
  2651638172U, // <7,4,3,3>: Cost 3 vext2 <5,6,7,4>, <3,3,3,3>
  2651638274U, // <7,4,3,4>: Cost 3 vext2 <5,6,7,4>, <3,4,5,6>
  2639030883U, // <7,4,3,5>: Cost 3 vext2 <3,5,7,4>, <3,5,7,4>
  2712063122U, // <7,4,3,6>: Cost 3 vext3 RHS, <4,3,6,5>
  3712772836U, // <7,4,3,7>: Cost 4 vext2 <3,5,7,4>, <3,7,3,7>
  2641021782U, // <7,4,3,u>: Cost 3 vext2 <3,u,7,4>, <3,u,7,4>
  2714053802U, // <7,4,4,0>: Cost 3 vext3 RHS, <4,4,0,2>
  3785804978U, // <7,4,4,1>: Cost 4 vext3 RHS, <4,4,1,1>
  3716754505U, // <7,4,4,2>: Cost 4 vext2 <4,2,7,4>, <4,2,7,4>
  3785804998U, // <7,4,4,3>: Cost 4 vext3 RHS, <4,4,3,3>
  1638321360U, // <7,4,4,4>: Cost 2 vext3 RHS, <4,4,4,4>
  1638468826U, // <7,4,4,5>: Cost 2 vext3 RHS, <4,4,5,5>
  1638468836U, // <7,4,4,6>: Cost 2 vext3 RHS, <4,4,6,6>
  3785215214U, // <7,4,4,7>: Cost 4 vext3 <4,4,7,7>, <4,4,7,7>
  1640459509U, // <7,4,4,u>: Cost 2 vext3 RHS, <4,4,u,5>
  1517207654U, // <7,4,5,0>: Cost 2 vext1 <6,7,4,5>, LHS
  2573034640U, // <7,4,5,1>: Cost 3 vext1 <3,7,4,5>, <1,5,3,7>
  2712063246U, // <7,4,5,2>: Cost 3 vext3 RHS, <4,5,2,3>
  2573036267U, // <7,4,5,3>: Cost 3 vext1 <3,7,4,5>, <3,7,4,5>
  1517210934U, // <7,4,5,4>: Cost 2 vext1 <6,7,4,5>, RHS
  2711989549U, // <7,4,5,5>: Cost 3 vext3 <4,5,5,7>, <4,5,5,7>
  564579638U, // <7,4,5,6>: Cost 1 vext3 RHS, RHS
  2651639976U, // <7,4,5,7>: Cost 3 vext2 <5,6,7,4>, <5,7,5,7>
  564579656U, // <7,4,5,u>: Cost 1 vext3 RHS, RHS
  2712063307U, // <7,4,6,0>: Cost 3 vext3 RHS, <4,6,0,1>
  3767668056U, // <7,4,6,1>: Cost 4 vext3 <1,5,3,7>, <4,6,1,5>
  2651640314U, // <7,4,6,2>: Cost 3 vext2 <5,6,7,4>, <6,2,7,3>
  2655621708U, // <7,4,6,3>: Cost 3 vext2 <6,3,7,4>, <6,3,7,4>
  1638468980U, // <7,4,6,4>: Cost 2 vext3 RHS, <4,6,4,6>
  2712063358U, // <7,4,6,5>: Cost 3 vext3 RHS, <4,6,5,7>
  2712063367U, // <7,4,6,6>: Cost 3 vext3 RHS, <4,6,6,7>
  2712210826U, // <7,4,6,7>: Cost 3 vext3 RHS, <4,6,7,1>
  1638469012U, // <7,4,6,u>: Cost 2 vext3 RHS, <4,6,u,2>
  2651640826U, // <7,4,7,0>: Cost 3 vext2 <5,6,7,4>, <7,0,1,2>
  3773713830U, // <7,4,7,1>: Cost 4 vext3 <2,5,4,7>, <4,7,1,2>
  3773713842U, // <7,4,7,2>: Cost 4 vext3 <2,5,4,7>, <4,7,2,5>
  3780349372U, // <7,4,7,3>: Cost 4 vext3 <3,6,4,7>, <4,7,3,6>
  2651641140U, // <7,4,7,4>: Cost 3 vext2 <5,6,7,4>, <7,4,0,1>
  2712210888U, // <7,4,7,5>: Cost 3 vext3 RHS, <4,7,5,0>
  2712210898U, // <7,4,7,6>: Cost 3 vext3 RHS, <4,7,6,1>
  2651641452U, // <7,4,7,7>: Cost 3 vext2 <5,6,7,4>, <7,7,7,7>
  2713538026U, // <7,4,7,u>: Cost 3 vext3 <4,7,u,7>, <4,7,u,7>
  1517232230U, // <7,4,u,0>: Cost 2 vext1 <6,7,4,u>, LHS
  1577899822U, // <7,4,u,1>: Cost 2 vext2 <5,6,7,4>, LHS
  2712063489U, // <7,4,u,2>: Cost 3 vext3 RHS, <4,u,2,3>
  2573060846U, // <7,4,u,3>: Cost 3 vext1 <3,7,4,u>, <3,7,4,u>
  1640312342U, // <7,4,u,4>: Cost 2 vext3 RHS, <4,u,4,6>
  1638469146U, // <7,4,u,5>: Cost 2 vext3 RHS, <4,u,5,1>
  564579881U, // <7,4,u,6>: Cost 1 vext3 RHS, RHS
  2714054192U, // <7,4,u,7>: Cost 3 vext3 RHS, <4,u,7,5>
  564579899U, // <7,4,u,u>: Cost 1 vext3 RHS, RHS
  2579038310U, // <7,5,0,0>: Cost 3 vext1 <4,7,5,0>, LHS
  2636382310U, // <7,5,0,1>: Cost 3 vext2 <3,1,7,5>, LHS
  2796339302U, // <7,5,0,2>: Cost 3 vuzpl <7,4,5,6>, LHS
  3646810719U, // <7,5,0,3>: Cost 4 vext1 <3,7,5,0>, <3,5,7,0>
  2712063586U, // <7,5,0,4>: Cost 3 vext3 RHS, <5,0,4,1>
  2735951467U, // <7,5,0,5>: Cost 3 vext3 RHS, <5,0,5,1>
  2735951476U, // <7,5,0,6>: Cost 3 vext3 RHS, <5,0,6,1>
  2579043322U, // <7,5,0,7>: Cost 3 vext1 <4,7,5,0>, <7,0,1,2>
  2636382877U, // <7,5,0,u>: Cost 3 vext2 <3,1,7,5>, LHS
  2712211087U, // <7,5,1,0>: Cost 3 vext3 RHS, <5,1,0,1>
  3698180916U, // <7,5,1,1>: Cost 4 vext2 <1,1,7,5>, <1,1,1,1>
  3710124950U, // <7,5,1,2>: Cost 4 vext2 <3,1,7,5>, <1,2,3,0>
  2636383232U, // <7,5,1,3>: Cost 3 vext2 <3,1,7,5>, <1,3,5,7>
  2712211127U, // <7,5,1,4>: Cost 3 vext3 RHS, <5,1,4,5>
  2590994128U, // <7,5,1,5>: Cost 3 vext1 <6,7,5,1>, <5,1,7,3>
  2590995323U, // <7,5,1,6>: Cost 3 vext1 <6,7,5,1>, <6,7,5,1>
  1638469328U, // <7,5,1,7>: Cost 2 vext3 RHS, <5,1,7,3>
  1638469337U, // <7,5,1,u>: Cost 2 vext3 RHS, <5,1,u,3>
  3785805536U, // <7,5,2,0>: Cost 4 vext3 RHS, <5,2,0,1>
  3785805544U, // <7,5,2,1>: Cost 4 vext3 RHS, <5,2,1,0>
  3704817288U, // <7,5,2,2>: Cost 4 vext2 <2,2,7,5>, <2,2,5,7>
  2712063742U, // <7,5,2,3>: Cost 3 vext3 RHS, <5,2,3,4>
  3716761386U, // <7,5,2,4>: Cost 4 vext2 <4,2,7,5>, <2,4,5,7>
  2714054415U, // <7,5,2,5>: Cost 3 vext3 RHS, <5,2,5,3>
  3774304024U, // <7,5,2,6>: Cost 4 vext3 <2,6,3,7>, <5,2,6,3>
  2712063777U, // <7,5,2,7>: Cost 3 vext3 RHS, <5,2,7,3>
  2712063787U, // <7,5,2,u>: Cost 3 vext3 RHS, <5,2,u,4>
  3634888806U, // <7,5,3,0>: Cost 4 vext1 <1,7,5,3>, LHS
  2636384544U, // <7,5,3,1>: Cost 3 vext2 <3,1,7,5>, <3,1,7,5>
  3710790001U, // <7,5,3,2>: Cost 4 vext2 <3,2,7,5>, <3,2,7,5>
  3710126492U, // <7,5,3,3>: Cost 4 vext2 <3,1,7,5>, <3,3,3,3>
  3634892086U, // <7,5,3,4>: Cost 4 vext1 <1,7,5,3>, RHS
  2639039076U, // <7,5,3,5>: Cost 3 vext2 <3,5,7,5>, <3,5,7,5>
  3713444533U, // <7,5,3,6>: Cost 4 vext2 <3,6,7,5>, <3,6,7,5>
  2693926767U, // <7,5,3,7>: Cost 3 vext3 <1,5,3,7>, <5,3,7,0>
  2712063864U, // <7,5,3,u>: Cost 3 vext3 RHS, <5,3,u,0>
  2579071078U, // <7,5,4,0>: Cost 3 vext1 <4,7,5,4>, LHS
  3646841856U, // <7,5,4,1>: Cost 4 vext1 <3,7,5,4>, <1,3,5,7>
  3716762698U, // <7,5,4,2>: Cost 4 vext2 <4,2,7,5>, <4,2,7,5>
  3646843491U, // <7,5,4,3>: Cost 4 vext1 <3,7,5,4>, <3,5,7,4>
  2579074358U, // <7,5,4,4>: Cost 3 vext1 <4,7,5,4>, RHS
  2636385590U, // <7,5,4,5>: Cost 3 vext2 <3,1,7,5>, RHS
  2645675406U, // <7,5,4,6>: Cost 3 vext2 <4,6,7,5>, <4,6,7,5>
  1638322118U, // <7,5,4,7>: Cost 2 vext3 RHS, <5,4,7,6>
  1638469583U, // <7,5,4,u>: Cost 2 vext3 RHS, <5,4,u,6>
  2714054611U, // <7,5,5,0>: Cost 3 vext3 RHS, <5,5,0,1>
  2652974800U, // <7,5,5,1>: Cost 3 vext2 <5,u,7,5>, <5,1,7,3>
  3710127905U, // <7,5,5,2>: Cost 4 vext2 <3,1,7,5>, <5,2,7,3>
  3785805808U, // <7,5,5,3>: Cost 4 vext3 RHS, <5,5,3,3>
  2712211450U, // <7,5,5,4>: Cost 3 vext3 RHS, <5,5,4,4>
  1638322180U, // <7,5,5,5>: Cost 2 vext3 RHS, <5,5,5,5>
  2712064014U, // <7,5,5,6>: Cost 3 vext3 RHS, <5,5,6,6>
  1638469656U, // <7,5,5,7>: Cost 2 vext3 RHS, <5,5,7,7>
  1638469665U, // <7,5,5,u>: Cost 2 vext3 RHS, <5,5,u,7>
  2712064036U, // <7,5,6,0>: Cost 3 vext3 RHS, <5,6,0,1>
  2714054707U, // <7,5,6,1>: Cost 3 vext3 RHS, <5,6,1,7>
  3785805879U, // <7,5,6,2>: Cost 4 vext3 RHS, <5,6,2,2>
  2712064066U, // <7,5,6,3>: Cost 3 vext3 RHS, <5,6,3,4>
  2712064076U, // <7,5,6,4>: Cost 3 vext3 RHS, <5,6,4,5>
  2714054743U, // <7,5,6,5>: Cost 3 vext3 RHS, <5,6,5,7>
  2712064096U, // <7,5,6,6>: Cost 3 vext3 RHS, <5,6,6,7>
  1638322274U, // <7,5,6,7>: Cost 2 vext3 RHS, <5,6,7,0>
  1638469739U, // <7,5,6,u>: Cost 2 vext3 RHS, <5,6,u,0>
  1511325798U, // <7,5,7,0>: Cost 2 vext1 <5,7,5,7>, LHS
  2692747392U, // <7,5,7,1>: Cost 3 vext3 <1,3,5,7>, <5,7,1,3>
  2585069160U, // <7,5,7,2>: Cost 3 vext1 <5,7,5,7>, <2,2,2,2>
  2573126390U, // <7,5,7,3>: Cost 3 vext1 <3,7,5,7>, <3,7,5,7>
  1511329078U, // <7,5,7,4>: Cost 2 vext1 <5,7,5,7>, RHS
  1638469800U, // <7,5,7,5>: Cost 2 vext3 RHS, <5,7,5,7>
  2712211626U, // <7,5,7,6>: Cost 3 vext3 RHS, <5,7,6,0>
  2712211636U, // <7,5,7,7>: Cost 3 vext3 RHS, <5,7,7,1>
  1638469823U, // <7,5,7,u>: Cost 2 vext3 RHS, <5,7,u,3>
  1511333990U, // <7,5,u,0>: Cost 2 vext1 <5,7,5,u>, LHS
  2636388142U, // <7,5,u,1>: Cost 3 vext2 <3,1,7,5>, LHS
  2712211671U, // <7,5,u,2>: Cost 3 vext3 RHS, <5,u,2,0>
  2573134583U, // <7,5,u,3>: Cost 3 vext1 <3,7,5,u>, <3,7,5,u>
  1511337270U, // <7,5,u,4>: Cost 2 vext1 <5,7,5,u>, RHS
  1638469881U, // <7,5,u,5>: Cost 2 vext3 RHS, <5,u,5,7>
  2712064258U, // <7,5,u,6>: Cost 3 vext3 RHS, <5,u,6,7>
  1638469892U, // <7,5,u,7>: Cost 2 vext3 RHS, <5,u,7,0>
  1638469904U, // <7,5,u,u>: Cost 2 vext3 RHS, <5,u,u,3>
  2650324992U, // <7,6,0,0>: Cost 3 vext2 <5,4,7,6>, <0,0,0,0>
  1576583270U, // <7,6,0,1>: Cost 2 vext2 <5,4,7,6>, LHS
  2712064300U, // <7,6,0,2>: Cost 3 vext3 RHS, <6,0,2,4>
  2255295336U, // <7,6,0,3>: Cost 3 vrev <6,7,3,0>
  2712064316U, // <7,6,0,4>: Cost 3 vext3 RHS, <6,0,4,2>
  2585088098U, // <7,6,0,5>: Cost 3 vext1 <5,7,6,0>, <5,6,7,0>
  2735952204U, // <7,6,0,6>: Cost 3 vext3 RHS, <6,0,6,0>
  2712211799U, // <7,6,0,7>: Cost 3 vext3 RHS, <6,0,7,2>
  1576583837U, // <7,6,0,u>: Cost 2 vext2 <5,4,7,6>, LHS
  1181340494U, // <7,6,1,0>: Cost 2 vrev <6,7,0,1>
  2650325812U, // <7,6,1,1>: Cost 3 vext2 <5,4,7,6>, <1,1,1,1>
  2650325910U, // <7,6,1,2>: Cost 3 vext2 <5,4,7,6>, <1,2,3,0>
  2650325976U, // <7,6,1,3>: Cost 3 vext2 <5,4,7,6>, <1,3,1,3>
  2579123510U, // <7,6,1,4>: Cost 3 vext1 <4,7,6,1>, RHS
  2650326160U, // <7,6,1,5>: Cost 3 vext2 <5,4,7,6>, <1,5,3,7>
  2714055072U, // <7,6,1,6>: Cost 3 vext3 RHS, <6,1,6,3>
  2712064425U, // <7,6,1,7>: Cost 3 vext3 RHS, <6,1,7,3>
  1181930390U, // <7,6,1,u>: Cost 2 vrev <6,7,u,1>
  2712211897U, // <7,6,2,0>: Cost 3 vext3 RHS, <6,2,0,1>
  2714055108U, // <7,6,2,1>: Cost 3 vext3 RHS, <6,2,1,3>
  2650326632U, // <7,6,2,2>: Cost 3 vext2 <5,4,7,6>, <2,2,2,2>
  2650326694U, // <7,6,2,3>: Cost 3 vext2 <5,4,7,6>, <2,3,0,1>
  2714055137U, // <7,6,2,4>: Cost 3 vext3 RHS, <6,2,4,5>
  2714055148U, // <7,6,2,5>: Cost 3 vext3 RHS, <6,2,5,7>
  2650326970U, // <7,6,2,6>: Cost 3 vext2 <5,4,7,6>, <2,6,3,7>
  1638470138U, // <7,6,2,7>: Cost 2 vext3 RHS, <6,2,7,3>
  1638470147U, // <7,6,2,u>: Cost 2 vext3 RHS, <6,2,u,3>
  2650327190U, // <7,6,3,0>: Cost 3 vext2 <5,4,7,6>, <3,0,1,2>
  2255172441U, // <7,6,3,1>: Cost 3 vrev <6,7,1,3>
  2255246178U, // <7,6,3,2>: Cost 3 vrev <6,7,2,3>
  2650327452U, // <7,6,3,3>: Cost 3 vext2 <5,4,7,6>, <3,3,3,3>
  2712064562U, // <7,6,3,4>: Cost 3 vext3 RHS, <6,3,4,5>
  2650327627U, // <7,6,3,5>: Cost 3 vext2 <5,4,7,6>, <3,5,4,7>
  3713452726U, // <7,6,3,6>: Cost 4 vext2 <3,6,7,6>, <3,6,7,6>
  2700563016U, // <7,6,3,7>: Cost 3 vext3 <2,6,3,7>, <6,3,7,0>
  2712064593U, // <7,6,3,u>: Cost 3 vext3 RHS, <6,3,u,0>
  2650327954U, // <7,6,4,0>: Cost 3 vext2 <5,4,7,6>, <4,0,5,1>
  2735952486U, // <7,6,4,1>: Cost 3 vext3 RHS, <6,4,1,3>
  2735952497U, // <7,6,4,2>: Cost 3 vext3 RHS, <6,4,2,5>
  2255328108U, // <7,6,4,3>: Cost 3 vrev <6,7,3,4>
  2712212100U, // <7,6,4,4>: Cost 3 vext3 RHS, <6,4,4,6>
  1576586550U, // <7,6,4,5>: Cost 2 vext2 <5,4,7,6>, RHS
  2714055312U, // <7,6,4,6>: Cost 3 vext3 RHS, <6,4,6,0>
  2712212126U, // <7,6,4,7>: Cost 3 vext3 RHS, <6,4,7,5>
  1576586793U, // <7,6,4,u>: Cost 2 vext2 <5,4,7,6>, RHS
  2579152998U, // <7,6,5,0>: Cost 3 vext1 <4,7,6,5>, LHS
  2650328784U, // <7,6,5,1>: Cost 3 vext2 <5,4,7,6>, <5,1,7,3>
  2714055364U, // <7,6,5,2>: Cost 3 vext3 RHS, <6,5,2,7>
  3785806538U, // <7,6,5,3>: Cost 4 vext3 RHS, <6,5,3,4>
  1576587206U, // <7,6,5,4>: Cost 2 vext2 <5,4,7,6>, <5,4,7,6>
  2650329092U, // <7,6,5,5>: Cost 3 vext2 <5,4,7,6>, <5,5,5,5>
  2650329186U, // <7,6,5,6>: Cost 3 vext2 <5,4,7,6>, <5,6,7,0>
  2712064753U, // <7,6,5,7>: Cost 3 vext3 RHS, <6,5,7,7>
  1181963162U, // <7,6,5,u>: Cost 2 vrev <6,7,u,5>
  2714055421U, // <7,6,6,0>: Cost 3 vext3 RHS, <6,6,0,1>
  2714055432U, // <7,6,6,1>: Cost 3 vext3 RHS, <6,6,1,3>
  2650329594U, // <7,6,6,2>: Cost 3 vext2 <5,4,7,6>, <6,2,7,3>
  3785806619U, // <7,6,6,3>: Cost 4 vext3 RHS, <6,6,3,4>
  2712212260U, // <7,6,6,4>: Cost 3 vext3 RHS, <6,6,4,4>
  2714055472U, // <7,6,6,5>: Cost 3 vext3 RHS, <6,6,5,7>
  1638323000U, // <7,6,6,6>: Cost 2 vext3 RHS, <6,6,6,6>
  1638470466U, // <7,6,6,7>: Cost 2 vext3 RHS, <6,6,7,7>
  1638470475U, // <7,6,6,u>: Cost 2 vext3 RHS, <6,6,u,7>
  1638323022U, // <7,6,7,0>: Cost 2 vext3 RHS, <6,7,0,1>
  2712064854U, // <7,6,7,1>: Cost 3 vext3 RHS, <6,7,1,0>
  2712064865U, // <7,6,7,2>: Cost 3 vext3 RHS, <6,7,2,2>
  2712064872U, // <7,6,7,3>: Cost 3 vext3 RHS, <6,7,3,0>
  1638323062U, // <7,6,7,4>: Cost 2 vext3 RHS, <6,7,4,5>
  2712064894U, // <7,6,7,5>: Cost 3 vext3 RHS, <6,7,5,4>
  2712064905U, // <7,6,7,6>: Cost 3 vext3 RHS, <6,7,6,6>
  2712064915U, // <7,6,7,7>: Cost 3 vext3 RHS, <6,7,7,7>
  1638323094U, // <7,6,7,u>: Cost 2 vext3 RHS, <6,7,u,1>
  1638470559U, // <7,6,u,0>: Cost 2 vext3 RHS, <6,u,0,1>
  1576589102U, // <7,6,u,1>: Cost 2 vext2 <5,4,7,6>, LHS
  2712212402U, // <7,6,u,2>: Cost 3 vext3 RHS, <6,u,2,2>
  2712212409U, // <7,6,u,3>: Cost 3 vext3 RHS, <6,u,3,0>
  1638470599U, // <7,6,u,4>: Cost 2 vext3 RHS, <6,u,4,5>
  1576589466U, // <7,6,u,5>: Cost 2 vext2 <5,4,7,6>, RHS
  1638323000U, // <7,6,u,6>: Cost 2 vext3 RHS, <6,6,6,6>
  1638470624U, // <7,6,u,7>: Cost 2 vext3 RHS, <6,u,7,3>
  1638470631U, // <7,6,u,u>: Cost 2 vext3 RHS, <6,u,u,1>
  2712065007U, // <7,7,0,0>: Cost 3 vext3 RHS, <7,0,0,0>
  1638323194U, // <7,7,0,1>: Cost 2 vext3 RHS, <7,0,1,2>
  2712065025U, // <7,7,0,2>: Cost 3 vext3 RHS, <7,0,2,0>
  3646958337U, // <7,7,0,3>: Cost 4 vext1 <3,7,7,0>, <3,7,7,0>
  2712065044U, // <7,7,0,4>: Cost 3 vext3 RHS, <7,0,4,1>
  2585161907U, // <7,7,0,5>: Cost 3 vext1 <5,7,7,0>, <5,7,7,0>
  2591134604U, // <7,7,0,6>: Cost 3 vext1 <6,7,7,0>, <6,7,7,0>
  2591134714U, // <7,7,0,7>: Cost 3 vext1 <6,7,7,0>, <7,0,1,2>
  1638323257U, // <7,7,0,u>: Cost 2 vext3 RHS, <7,0,u,2>
  2712065091U, // <7,7,1,0>: Cost 3 vext3 RHS, <7,1,0,3>
  2712065098U, // <7,7,1,1>: Cost 3 vext3 RHS, <7,1,1,1>
  2712065109U, // <7,7,1,2>: Cost 3 vext3 RHS, <7,1,2,3>
  2692748384U, // <7,7,1,3>: Cost 3 vext3 <1,3,5,7>, <7,1,3,5>
  2585169206U, // <7,7,1,4>: Cost 3 vext1 <5,7,7,1>, RHS
  2693928048U, // <7,7,1,5>: Cost 3 vext3 <1,5,3,7>, <7,1,5,3>
  2585170766U, // <7,7,1,6>: Cost 3 vext1 <5,7,7,1>, <6,7,0,1>
  2735953024U, // <7,7,1,7>: Cost 3 vext3 RHS, <7,1,7,1>
  2695918731U, // <7,7,1,u>: Cost 3 vext3 <1,u,3,7>, <7,1,u,3>
  3770471574U, // <7,7,2,0>: Cost 4 vext3 <2,0,5,7>, <7,2,0,5>
  3785807002U, // <7,7,2,1>: Cost 4 vext3 RHS, <7,2,1,0>
  2712065189U, // <7,7,2,2>: Cost 3 vext3 RHS, <7,2,2,2>
  2712065196U, // <7,7,2,3>: Cost 3 vext3 RHS, <7,2,3,0>
  3773125818U, // <7,7,2,4>: Cost 4 vext3 <2,4,5,7>, <7,2,4,5>
  3766490305U, // <7,7,2,5>: Cost 4 vext3 <1,3,5,7>, <7,2,5,3>
  2700563658U, // <7,7,2,6>: Cost 3 vext3 <2,6,3,7>, <7,2,6,3>
  2735953107U, // <7,7,2,7>: Cost 3 vext3 RHS, <7,2,7,3>
  2701890780U, // <7,7,2,u>: Cost 3 vext3 <2,u,3,7>, <7,2,u,3>
  2712065251U, // <7,7,3,0>: Cost 3 vext3 RHS, <7,3,0,1>
  3766490350U, // <7,7,3,1>: Cost 4 vext3 <1,3,5,7>, <7,3,1,3>
  3774305530U, // <7,7,3,2>: Cost 4 vext3 <2,6,3,7>, <7,3,2,6>
  2637728196U, // <7,7,3,3>: Cost 3 vext2 <3,3,7,7>, <3,3,7,7>
  2712065291U, // <7,7,3,4>: Cost 3 vext3 RHS, <7,3,4,5>
  2585186486U, // <7,7,3,5>: Cost 3 vext1 <5,7,7,3>, <5,7,7,3>
  2639719095U, // <7,7,3,6>: Cost 3 vext2 <3,6,7,7>, <3,6,7,7>
  2640382728U, // <7,7,3,7>: Cost 3 vext2 <3,7,7,7>, <3,7,7,7>
  2641046361U, // <7,7,3,u>: Cost 3 vext2 <3,u,7,7>, <3,u,7,7>
  2712212792U, // <7,7,4,0>: Cost 3 vext3 RHS, <7,4,0,5>
  3646989312U, // <7,7,4,1>: Cost 4 vext1 <3,7,7,4>, <1,3,5,7>
  3785807176U, // <7,7,4,2>: Cost 4 vext3 RHS, <7,4,2,3>
  3646991109U, // <7,7,4,3>: Cost 4 vext1 <3,7,7,4>, <3,7,7,4>
  2712065371U, // <7,7,4,4>: Cost 3 vext3 RHS, <7,4,4,4>
  1638323558U, // <7,7,4,5>: Cost 2 vext3 RHS, <7,4,5,6>
  2712212845U, // <7,7,4,6>: Cost 3 vext3 RHS, <7,4,6,4>
  2591167846U, // <7,7,4,7>: Cost 3 vext1 <6,7,7,4>, <7,4,5,6>
  1638323585U, // <7,7,4,u>: Cost 2 vext3 RHS, <7,4,u,6>
  2585198694U, // <7,7,5,0>: Cost 3 vext1 <5,7,7,5>, LHS
  2712212884U, // <7,7,5,1>: Cost 3 vext3 RHS, <7,5,1,7>
  3711471393U, // <7,7,5,2>: Cost 4 vext2 <3,3,7,7>, <5,2,7,3>
  2649673590U, // <7,7,5,3>: Cost 3 vext2 <5,3,7,7>, <5,3,7,7>
  2712065455U, // <7,7,5,4>: Cost 3 vext3 RHS, <7,5,4,7>
  1577259032U, // <7,7,5,5>: Cost 2 vext2 <5,5,7,7>, <5,5,7,7>
  2712065473U, // <7,7,5,6>: Cost 3 vext3 RHS, <7,5,6,7>
  2712212936U, // <7,7,5,7>: Cost 3 vext3 RHS, <7,5,7,5>
  1579249931U, // <7,7,5,u>: Cost 2 vext2 <5,u,7,7>, <5,u,7,7>
  2591178854U, // <7,7,6,0>: Cost 3 vext1 <6,7,7,6>, LHS
  2735953374U, // <7,7,6,1>: Cost 3 vext3 RHS, <7,6,1,0>
  2712212974U, // <7,7,6,2>: Cost 3 vext3 RHS, <7,6,2,7>
  2655646287U, // <7,7,6,3>: Cost 3 vext2 <6,3,7,7>, <6,3,7,7>
  2591182134U, // <7,7,6,4>: Cost 3 vext1 <6,7,7,6>, RHS
  2656973553U, // <7,7,6,5>: Cost 3 vext2 <6,5,7,7>, <6,5,7,7>
  1583895362U, // <7,7,6,6>: Cost 2 vext2 <6,6,7,7>, <6,6,7,7>
  2712065556U, // <7,7,6,7>: Cost 3 vext3 RHS, <7,6,7,0>
  1585222628U, // <7,7,6,u>: Cost 2 vext2 <6,u,7,7>, <6,u,7,7>
  1523417190U, // <7,7,7,0>: Cost 2 vext1 <7,7,7,7>, LHS
  2597159670U, // <7,7,7,1>: Cost 3 vext1 <7,7,7,7>, <1,0,3,2>
  2597160552U, // <7,7,7,2>: Cost 3 vext1 <7,7,7,7>, <2,2,2,2>
  2597161110U, // <7,7,7,3>: Cost 3 vext1 <7,7,7,7>, <3,0,1,2>
  1523420470U, // <7,7,7,4>: Cost 2 vext1 <7,7,7,7>, RHS
  2651002296U, // <7,7,7,5>: Cost 3 vext2 <5,5,7,7>, <7,5,5,7>
  2657637906U, // <7,7,7,6>: Cost 3 vext2 <6,6,7,7>, <7,6,6,7>
  363253046U, // <7,7,7,7>: Cost 1 vdup3 RHS
  363253046U, // <7,7,7,u>: Cost 1 vdup3 RHS
  1523417190U, // <7,7,u,0>: Cost 2 vext1 <7,7,7,7>, LHS
  1638471298U, // <7,7,u,1>: Cost 2 vext3 RHS, <7,u,1,2>
  2712213132U, // <7,7,u,2>: Cost 3 vext3 RHS, <7,u,2,3>
  2712213138U, // <7,7,u,3>: Cost 3 vext3 RHS, <7,u,3,0>
  1523420470U, // <7,7,u,4>: Cost 2 vext1 <7,7,7,7>, RHS
  1638471338U, // <7,7,u,5>: Cost 2 vext3 RHS, <7,u,5,6>
  1595840756U, // <7,7,u,6>: Cost 2 vext2 <u,6,7,7>, <u,6,7,7>
  363253046U, // <7,7,u,7>: Cost 1 vdup3 RHS
  363253046U, // <7,7,u,u>: Cost 1 vdup3 RHS
  1638318080U, // <7,u,0,0>: Cost 2 vext3 RHS, <0,0,0,0>
  1638323923U, // <7,u,0,1>: Cost 2 vext3 RHS, <u,0,1,2>
  1662211804U, // <7,u,0,2>: Cost 2 vext3 RHS, <u,0,2,2>
  1638323941U, // <7,u,0,3>: Cost 2 vext3 RHS, <u,0,3,2>
  2712065773U, // <7,u,0,4>: Cost 3 vext3 RHS, <u,0,4,1>
  1662359286U, // <7,u,0,5>: Cost 2 vext3 RHS, <u,0,5,1>
  1662359296U, // <7,u,0,6>: Cost 2 vext3 RHS, <u,0,6,2>
  2987150664U, // <7,u,0,7>: Cost 3 vzipr <5,6,7,0>, RHS
  1638323986U, // <7,u,0,u>: Cost 2 vext3 RHS, <u,0,u,2>
  1517469798U, // <7,u,1,0>: Cost 2 vext1 <6,7,u,1>, LHS
  1638318900U, // <7,u,1,1>: Cost 2 vext3 RHS, <1,1,1,1>
  564582190U, // <7,u,1,2>: Cost 1 vext3 RHS, LHS
  1638324023U, // <7,u,1,3>: Cost 2 vext3 RHS, <u,1,3,3>
  1517473078U, // <7,u,1,4>: Cost 2 vext1 <6,7,u,1>, RHS
  2693928777U, // <7,u,1,5>: Cost 3 vext3 <1,5,3,7>, <u,1,5,3>
  1517474710U, // <7,u,1,6>: Cost 2 vext1 <6,7,u,1>, <6,7,u,1>
  1640462171U, // <7,u,1,7>: Cost 2 vext3 RHS, <u,1,7,3>
  564582244U, // <7,u,1,u>: Cost 1 vext3 RHS, LHS
  1638318244U, // <7,u,2,0>: Cost 2 vext3 RHS, <0,2,0,2>
  2712065907U, // <7,u,2,1>: Cost 3 vext3 RHS, <u,2,1,0>
  1638319720U, // <7,u,2,2>: Cost 2 vext3 RHS, <2,2,2,2>
  1638324101U, // <7,u,2,3>: Cost 2 vext3 RHS, <u,2,3,0>
  1638318284U, // <7,u,2,4>: Cost 2 vext3 RHS, <0,2,4,6>
  2712065947U, // <7,u,2,5>: Cost 3 vext3 RHS, <u,2,5,4>
  2700564387U, // <7,u,2,6>: Cost 3 vext3 <2,6,3,7>, <u,2,6,3>
  1640314796U, // <7,u,2,7>: Cost 2 vext3 RHS, <u,2,7,3>
  1638324146U, // <7,u,2,u>: Cost 2 vext3 RHS, <u,2,u,0>
  1638324156U, // <7,u,3,0>: Cost 2 vext3 RHS, <u,3,0,1>
  1638319064U, // <7,u,3,1>: Cost 2 vext3 RHS, <1,3,1,3>
  2700564435U, // <7,u,3,2>: Cost 3 vext3 <2,6,3,7>, <u,3,2,6>
  1638320540U, // <7,u,3,3>: Cost 2 vext3 RHS, <3,3,3,3>
  1638324196U, // <7,u,3,4>: Cost 2 vext3 RHS, <u,3,4,5>
  1638324207U, // <7,u,3,5>: Cost 2 vext3 RHS, <u,3,5,7>
  2700564472U, // <7,u,3,6>: Cost 3 vext3 <2,6,3,7>, <u,3,6,7>
  2695919610U, // <7,u,3,7>: Cost 3 vext3 <1,u,3,7>, <u,3,7,0>
  1638324228U, // <7,u,3,u>: Cost 2 vext3 RHS, <u,3,u,1>
  2712066061U, // <7,u,4,0>: Cost 3 vext3 RHS, <u,4,0,1>
  1662212122U, // <7,u,4,1>: Cost 2 vext3 RHS, <u,4,1,5>
  1662212132U, // <7,u,4,2>: Cost 2 vext3 RHS, <u,4,2,6>
  2712066092U, // <7,u,4,3>: Cost 3 vext3 RHS, <u,4,3,5>
  1638321360U, // <7,u,4,4>: Cost 2 vext3 RHS, <4,4,4,4>
  1638324287U, // <7,u,4,5>: Cost 2 vext3 RHS, <u,4,5,6>
  1662359624U, // <7,u,4,6>: Cost 2 vext3 RHS, <u,4,6,6>
  1640314961U, // <7,u,4,7>: Cost 2 vext3 RHS, <u,4,7,6>
  1638324314U, // <7,u,4,u>: Cost 2 vext3 RHS, <u,4,u,6>
  1517502566U, // <7,u,5,0>: Cost 2 vext1 <6,7,u,5>, LHS
  1574612693U, // <7,u,5,1>: Cost 2 vext2 <5,1,7,u>, <5,1,7,u>
  2712066162U, // <7,u,5,2>: Cost 3 vext3 RHS, <u,5,2,3>
  1638324351U, // <7,u,5,3>: Cost 2 vext3 RHS, <u,5,3,7>
  1576603592U, // <7,u,5,4>: Cost 2 vext2 <5,4,7,u>, <5,4,7,u>
  1577267225U, // <7,u,5,5>: Cost 2 vext2 <5,5,7,u>, <5,5,7,u>
  564582554U, // <7,u,5,6>: Cost 1 vext3 RHS, RHS
  1640462499U, // <7,u,5,7>: Cost 2 vext3 RHS, <u,5,7,7>
  564582572U, // <7,u,5,u>: Cost 1 vext3 RHS, RHS
  2712066223U, // <7,u,6,0>: Cost 3 vext3 RHS, <u,6,0,1>
  2712066238U, // <7,u,6,1>: Cost 3 vext3 RHS, <u,6,1,7>
  1581249023U, // <7,u,6,2>: Cost 2 vext2 <6,2,7,u>, <6,2,7,u>
  1638324432U, // <7,u,6,3>: Cost 2 vext3 RHS, <u,6,3,7>
  1638468980U, // <7,u,6,4>: Cost 2 vext3 RHS, <4,6,4,6>
  2712066274U, // <7,u,6,5>: Cost 3 vext3 RHS, <u,6,5,7>
  1583903555U, // <7,u,6,6>: Cost 2 vext2 <6,6,7,u>, <6,6,7,u>
  1640315117U, // <7,u,6,7>: Cost 2 vext3 RHS, <u,6,7,0>
  1638324477U, // <7,u,6,u>: Cost 2 vext3 RHS, <u,6,u,7>
  1638471936U, // <7,u,7,0>: Cost 2 vext3 RHS, <u,7,0,1>
  2692970763U, // <7,u,7,1>: Cost 3 vext3 <1,3,u,7>, <u,7,1,3>
  2700933399U, // <7,u,7,2>: Cost 3 vext3 <2,6,u,7>, <u,7,2,6>
  2573347601U, // <7,u,7,3>: Cost 3 vext1 <3,7,u,7>, <3,7,u,7>
  1638471976U, // <7,u,7,4>: Cost 2 vext3 RHS, <u,7,4,5>
  1511551171U, // <7,u,7,5>: Cost 2 vext1 <5,7,u,7>, <5,7,u,7>
  2712213815U, // <7,u,7,6>: Cost 3 vext3 RHS, <u,7,6,2>
  363253046U, // <7,u,7,7>: Cost 1 vdup3 RHS
  363253046U, // <7,u,7,u>: Cost 1 vdup3 RHS
  1638324561U, // <7,u,u,0>: Cost 2 vext3 RHS, <u,u,0,1>
  1638324571U, // <7,u,u,1>: Cost 2 vext3 RHS, <u,u,1,2>
  564582757U, // <7,u,u,2>: Cost 1 vext3 RHS, LHS
  1638324587U, // <7,u,u,3>: Cost 2 vext3 RHS, <u,u,3,0>
  1638324601U, // <7,u,u,4>: Cost 2 vext3 RHS, <u,u,4,5>
  1638324611U, // <7,u,u,5>: Cost 2 vext3 RHS, <u,u,5,6>
  564582797U, // <7,u,u,6>: Cost 1 vext3 RHS, RHS
  363253046U, // <7,u,u,7>: Cost 1 vdup3 RHS
  564582811U, // <7,u,u,u>: Cost 1 vext3 RHS, LHS
  135053414U, // <u,0,0,0>: Cost 1 vdup0 LHS
  1611489290U, // <u,0,0,1>: Cost 2 vext3 LHS, <0,0,1,1>
  1611489300U, // <u,0,0,2>: Cost 2 vext3 LHS, <0,0,2,2>
  2568054923U, // <u,0,0,3>: Cost 3 vext1 <3,0,0,0>, <3,0,0,0>
  1481706806U, // <u,0,0,4>: Cost 2 vext1 <0,u,0,0>, RHS
  2555449040U, // <u,0,0,5>: Cost 3 vext1 <0,u,0,0>, <5,1,7,3>
  2591282078U, // <u,0,0,6>: Cost 3 vext1 <6,u,0,0>, <6,u,0,0>
  2591945711U, // <u,0,0,7>: Cost 3 vext1 <7,0,0,0>, <7,0,0,0>
  135053414U, // <u,0,0,u>: Cost 1 vdup0 LHS
  1493655654U, // <u,0,1,0>: Cost 2 vext1 <2,u,0,1>, LHS
  1860550758U, // <u,0,1,1>: Cost 2 vzipl LHS, LHS
  537747563U, // <u,0,1,2>: Cost 1 vext3 LHS, LHS
  2625135576U, // <u,0,1,3>: Cost 3 vext2 <1,2,u,0>, <1,3,1,3>
  1493658934U, // <u,0,1,4>: Cost 2 vext1 <2,u,0,1>, RHS
  2625135760U, // <u,0,1,5>: Cost 3 vext2 <1,2,u,0>, <1,5,3,7>
  1517548447U, // <u,0,1,6>: Cost 2 vext1 <6,u,0,1>, <6,u,0,1>
  2591290362U, // <u,0,1,7>: Cost 3 vext1 <6,u,0,1>, <7,0,1,2>
  537747612U, // <u,0,1,u>: Cost 1 vext3 LHS, LHS
  1611489444U, // <u,0,2,0>: Cost 2 vext3 LHS, <0,2,0,2>
  2685231276U, // <u,0,2,1>: Cost 3 vext3 LHS, <0,2,1,1>
  1994768486U, // <u,0,2,2>: Cost 2 vtrnl LHS, LHS
  2685231294U, // <u,0,2,3>: Cost 3 vext3 LHS, <0,2,3,1>
  1611489484U, // <u,0,2,4>: Cost 2 vext3 LHS, <0,2,4,6>
  2712068310U, // <u,0,2,5>: Cost 3 vext3 RHS, <0,2,5,7>
  2625136570U, // <u,0,2,6>: Cost 3 vext2 <1,2,u,0>, <2,6,3,7>
  2591962097U, // <u,0,2,7>: Cost 3 vext1 <7,0,0,2>, <7,0,0,2>
  1611489516U, // <u,0,2,u>: Cost 2 vext3 LHS, <0,2,u,2>
  2954067968U, // <u,0,3,0>: Cost 3 vzipr LHS, <0,0,0,0>
  2685231356U, // <u,0,3,1>: Cost 3 vext3 LHS, <0,3,1,0>
  72589981U, // <u,0,3,2>: Cost 1 vrev LHS
  2625137052U, // <u,0,3,3>: Cost 3 vext2 <1,2,u,0>, <3,3,3,3>
  2625137154U, // <u,0,3,4>: Cost 3 vext2 <1,2,u,0>, <3,4,5,6>
  2639071848U, // <u,0,3,5>: Cost 3 vext2 <3,5,u,0>, <3,5,u,0>
  2639735481U, // <u,0,3,6>: Cost 3 vext2 <3,6,u,0>, <3,6,u,0>
  2597279354U, // <u,0,3,7>: Cost 3 vext1 <7,u,0,3>, <7,u,0,3>
  73032403U, // <u,0,3,u>: Cost 1 vrev LHS
  2687074636U, // <u,0,4,0>: Cost 3 vext3 <0,4,0,u>, <0,4,0,u>
  1611489618U, // <u,0,4,1>: Cost 2 vext3 LHS, <0,4,1,5>
  1611489628U, // <u,0,4,2>: Cost 2 vext3 LHS, <0,4,2,6>
  3629222038U, // <u,0,4,3>: Cost 4 vext1 <0,u,0,4>, <3,0,1,2>
  2555481398U, // <u,0,4,4>: Cost 3 vext1 <0,u,0,4>, RHS
  1551396150U, // <u,0,4,5>: Cost 2 vext2 <1,2,u,0>, RHS
  2651680116U, // <u,0,4,6>: Cost 3 vext2 <5,6,u,0>, <4,6,4,6>
  2646150600U, // <u,0,4,7>: Cost 3 vext2 <4,7,5,0>, <4,7,5,0>
  1611932050U, // <u,0,4,u>: Cost 2 vext3 LHS, <0,4,u,6>
  2561458278U, // <u,0,5,0>: Cost 3 vext1 <1,u,0,5>, LHS
  1863532646U, // <u,0,5,1>: Cost 2 vzipl RHS, LHS
  2712068526U, // <u,0,5,2>: Cost 3 vext3 RHS, <0,5,2,7>
  2649689976U, // <u,0,5,3>: Cost 3 vext2 <5,3,u,0>, <5,3,u,0>
  2220237489U, // <u,0,5,4>: Cost 3 vrev <0,u,4,5>
  2651680772U, // <u,0,5,5>: Cost 3 vext2 <5,6,u,0>, <5,5,5,5>
  1577939051U, // <u,0,5,6>: Cost 2 vext2 <5,6,u,0>, <5,6,u,0>
  2830077238U, // <u,0,5,7>: Cost 3 vuzpr <1,u,3,0>, RHS
  1579266317U, // <u,0,5,u>: Cost 2 vext2 <5,u,u,0>, <5,u,u,0>
  2555494502U, // <u,0,6,0>: Cost 3 vext1 <0,u,0,6>, LHS
  2712068598U, // <u,0,6,1>: Cost 3 vext3 RHS, <0,6,1,7>
  1997750374U, // <u,0,6,2>: Cost 2 vtrnl RHS, LHS
  2655662673U, // <u,0,6,3>: Cost 3 vext2 <6,3,u,0>, <6,3,u,0>
  2555497782U, // <u,0,6,4>: Cost 3 vext1 <0,u,0,6>, RHS
  2651681459U, // <u,0,6,5>: Cost 3 vext2 <5,6,u,0>, <6,5,0,u>
  2651681592U, // <u,0,6,6>: Cost 3 vext2 <5,6,u,0>, <6,6,6,6>
  2651681614U, // <u,0,6,7>: Cost 3 vext2 <5,6,u,0>, <6,7,0,1>
  1997750428U, // <u,0,6,u>: Cost 2 vtrnl RHS, LHS
  2567446630U, // <u,0,7,0>: Cost 3 vext1 <2,u,0,7>, LHS
  2567447446U, // <u,0,7,1>: Cost 3 vext1 <2,u,0,7>, <1,2,3,0>
  2567448641U, // <u,0,7,2>: Cost 3 vext1 <2,u,0,7>, <2,u,0,7>
  2573421338U, // <u,0,7,3>: Cost 3 vext1 <3,u,0,7>, <3,u,0,7>
  2567449910U, // <u,0,7,4>: Cost 3 vext1 <2,u,0,7>, RHS
  2651682242U, // <u,0,7,5>: Cost 3 vext2 <5,6,u,0>, <7,5,6,u>
  2591339429U, // <u,0,7,6>: Cost 3 vext1 <6,u,0,7>, <6,u,0,7>
  2651682412U, // <u,0,7,7>: Cost 3 vext2 <5,6,u,0>, <7,7,7,7>
  2567452462U, // <u,0,7,u>: Cost 3 vext1 <2,u,0,7>, LHS
  135053414U, // <u,0,u,0>: Cost 1 vdup0 LHS
  1611489938U, // <u,0,u,1>: Cost 2 vext3 LHS, <0,u,1,1>
  537748125U, // <u,0,u,2>: Cost 1 vext3 LHS, LHS
  2685674148U, // <u,0,u,3>: Cost 3 vext3 LHS, <0,u,3,1>
  1611932338U, // <u,0,u,4>: Cost 2 vext3 LHS, <0,u,4,6>
  1551399066U, // <u,0,u,5>: Cost 2 vext2 <1,2,u,0>, RHS
  1517605798U, // <u,0,u,6>: Cost 2 vext1 <6,u,0,u>, <6,u,0,u>
  2830077481U, // <u,0,u,7>: Cost 3 vuzpr <1,u,3,0>, RHS
  537748179U, // <u,0,u,u>: Cost 1 vext3 LHS, LHS
  1544101961U, // <u,1,0,0>: Cost 2 vext2 <0,0,u,1>, <0,0,u,1>
  1558036582U, // <u,1,0,1>: Cost 2 vext2 <2,3,u,1>, LHS
  2619171051U, // <u,1,0,2>: Cost 3 vext2 <0,2,u,1>, <0,2,u,1>
  1611490038U, // <u,1,0,3>: Cost 2 vext3 LHS, <1,0,3,2>
  2555522358U, // <u,1,0,4>: Cost 3 vext1 <0,u,1,0>, RHS
  2712068871U, // <u,1,0,5>: Cost 3 vext3 RHS, <1,0,5,1>
  2591355815U, // <u,1,0,6>: Cost 3 vext1 <6,u,1,0>, <6,u,1,0>
  2597328512U, // <u,1,0,7>: Cost 3 vext1 <7,u,1,0>, <7,u,1,0>
  1611490083U, // <u,1,0,u>: Cost 2 vext3 LHS, <1,0,u,2>
  1481785446U, // <u,1,1,0>: Cost 2 vext1 <0,u,1,1>, LHS
  202162278U, // <u,1,1,1>: Cost 1 vdup1 LHS
  2555528808U, // <u,1,1,2>: Cost 3 vext1 <0,u,1,1>, <2,2,2,2>
  1611490120U, // <u,1,1,3>: Cost 2 vext3 LHS, <1,1,3,3>
  1481788726U, // <u,1,1,4>: Cost 2 vext1 <0,u,1,1>, RHS
  2689876828U, // <u,1,1,5>: Cost 3 vext3 LHS, <1,1,5,5>
  2591364008U, // <u,1,1,6>: Cost 3 vext1 <6,u,1,1>, <6,u,1,1>
  2592691274U, // <u,1,1,7>: Cost 3 vext1 <7,1,1,1>, <7,1,1,1>
  202162278U, // <u,1,1,u>: Cost 1 vdup1 LHS
  1499709542U, // <u,1,2,0>: Cost 2 vext1 <3,u,1,2>, LHS
  2689876871U, // <u,1,2,1>: Cost 3 vext3 LHS, <1,2,1,3>
  2631116445U, // <u,1,2,2>: Cost 3 vext2 <2,2,u,1>, <2,2,u,1>
  835584U, // <u,1,2,3>: Cost 0 copy LHS
  1499712822U, // <u,1,2,4>: Cost 2 vext1 <3,u,1,2>, RHS
  2689876907U, // <u,1,2,5>: Cost 3 vext3 LHS, <1,2,5,3>
  2631780282U, // <u,1,2,6>: Cost 3 vext2 <2,3,u,1>, <2,6,3,7>
  1523603074U, // <u,1,2,7>: Cost 2 vext1 <7,u,1,2>, <7,u,1,2>
  835584U, // <u,1,2,u>: Cost 0 copy LHS
  1487773798U, // <u,1,3,0>: Cost 2 vext1 <1,u,1,3>, LHS
  1611490264U, // <u,1,3,1>: Cost 2 vext3 LHS, <1,3,1,3>
  2685232094U, // <u,1,3,2>: Cost 3 vext3 LHS, <1,3,2,0>
  2018746470U, // <u,1,3,3>: Cost 2 vtrnr LHS, LHS
  1487777078U, // <u,1,3,4>: Cost 2 vext1 <1,u,1,3>, RHS
  1611490304U, // <u,1,3,5>: Cost 2 vext3 LHS, <1,3,5,7>
  2685674505U, // <u,1,3,6>: Cost 3 vext3 LHS, <1,3,6,7>
  2640407307U, // <u,1,3,7>: Cost 3 vext2 <3,7,u,1>, <3,7,u,1>
  1611490327U, // <u,1,3,u>: Cost 2 vext3 LHS, <1,3,u,3>
  1567992749U, // <u,1,4,0>: Cost 2 vext2 <4,0,u,1>, <4,0,u,1>
  2693121070U, // <u,1,4,1>: Cost 3 vext3 <1,4,1,u>, <1,4,1,u>
  2693194807U, // <u,1,4,2>: Cost 3 vext3 <1,4,2,u>, <1,4,2,u>
  1152386432U, // <u,1,4,3>: Cost 2 vrev <1,u,3,4>
  2555555126U, // <u,1,4,4>: Cost 3 vext1 <0,u,1,4>, RHS
  1558039862U, // <u,1,4,5>: Cost 2 vext2 <2,3,u,1>, RHS
  2645716371U, // <u,1,4,6>: Cost 3 vext2 <4,6,u,1>, <4,6,u,1>
  2597361284U, // <u,1,4,7>: Cost 3 vext1 <7,u,1,4>, <7,u,1,4>
  1152755117U, // <u,1,4,u>: Cost 2 vrev <1,u,u,4>
  1481818214U, // <u,1,5,0>: Cost 2 vext1 <0,u,1,5>, LHS
  2555560694U, // <u,1,5,1>: Cost 3 vext1 <0,u,1,5>, <1,0,3,2>
  2555561576U, // <u,1,5,2>: Cost 3 vext1 <0,u,1,5>, <2,2,2,2>
  1611490448U, // <u,1,5,3>: Cost 2 vext3 LHS, <1,5,3,7>
  1481821494U, // <u,1,5,4>: Cost 2 vext1 <0,u,1,5>, RHS
  2651025435U, // <u,1,5,5>: Cost 3 vext2 <5,5,u,1>, <5,5,u,1>
  2651689068U, // <u,1,5,6>: Cost 3 vext2 <5,6,u,1>, <5,6,u,1>
  2823966006U, // <u,1,5,7>: Cost 3 vuzpr <0,u,1,1>, RHS
  1611932861U, // <u,1,5,u>: Cost 2 vext3 LHS, <1,5,u,7>
  2555568230U, // <u,1,6,0>: Cost 3 vext1 <0,u,1,6>, LHS
  2689877199U, // <u,1,6,1>: Cost 3 vext3 LHS, <1,6,1,7>
  2712069336U, // <u,1,6,2>: Cost 3 vext3 RHS, <1,6,2,7>
  2685232353U, // <u,1,6,3>: Cost 3 vext3 LHS, <1,6,3,7>
  2555571510U, // <u,1,6,4>: Cost 3 vext1 <0,u,1,6>, RHS
  2689877235U, // <u,1,6,5>: Cost 3 vext3 LHS, <1,6,5,7>
  2657661765U, // <u,1,6,6>: Cost 3 vext2 <6,6,u,1>, <6,6,u,1>
  1584583574U, // <u,1,6,7>: Cost 2 vext2 <6,7,u,1>, <6,7,u,1>
  1585247207U, // <u,1,6,u>: Cost 2 vext2 <6,u,u,1>, <6,u,u,1>
  2561548390U, // <u,1,7,0>: Cost 3 vext1 <1,u,1,7>, LHS
  2561549681U, // <u,1,7,1>: Cost 3 vext1 <1,u,1,7>, <1,u,1,7>
  2573493926U, // <u,1,7,2>: Cost 3 vext1 <3,u,1,7>, <2,3,0,1>
  2042962022U, // <u,1,7,3>: Cost 2 vtrnr RHS, LHS
  2561551670U, // <u,1,7,4>: Cost 3 vext1 <1,u,1,7>, RHS
  2226300309U, // <u,1,7,5>: Cost 3 vrev <1,u,5,7>
  2658325990U, // <u,1,7,6>: Cost 3 vext2 <6,7,u,1>, <7,6,1,u>
  2658326124U, // <u,1,7,7>: Cost 3 vext2 <6,7,u,1>, <7,7,7,7>
  2042962027U, // <u,1,7,u>: Cost 2 vtrnr RHS, LHS
  1481842790U, // <u,1,u,0>: Cost 2 vext1 <0,u,1,u>, LHS
  202162278U, // <u,1,u,1>: Cost 1 vdup1 LHS
  2685674867U, // <u,1,u,2>: Cost 3 vext3 LHS, <1,u,2,0>
  835584U, // <u,1,u,3>: Cost 0 copy LHS
  1481846070U, // <u,1,u,4>: Cost 2 vext1 <0,u,1,u>, RHS
  1611933077U, // <u,1,u,5>: Cost 2 vext3 LHS, <1,u,5,7>
  2685674910U, // <u,1,u,6>: Cost 3 vext3 LHS, <1,u,6,7>
  1523652232U, // <u,1,u,7>: Cost 2 vext1 <7,u,1,u>, <7,u,1,u>
  835584U, // <u,1,u,u>: Cost 0 copy LHS
  1544110154U, // <u,2,0,0>: Cost 2 vext2 <0,0,u,2>, <0,0,u,2>
  1545437286U, // <u,2,0,1>: Cost 2 vext2 <0,2,u,2>, LHS
  1545437420U, // <u,2,0,2>: Cost 2 vext2 <0,2,u,2>, <0,2,u,2>
  2685232589U, // <u,2,0,3>: Cost 3 vext3 LHS, <2,0,3,0>
  2619179346U, // <u,2,0,4>: Cost 3 vext2 <0,2,u,2>, <0,4,1,5>
  2712069606U, // <u,2,0,5>: Cost 3 vext3 RHS, <2,0,5,7>
  2689877484U, // <u,2,0,6>: Cost 3 vext3 LHS, <2,0,6,4>
  2659656273U, // <u,2,0,7>: Cost 3 vext2 <7,0,u,2>, <0,7,2,u>
  1545437853U, // <u,2,0,u>: Cost 2 vext2 <0,2,u,2>, LHS
  1550082851U, // <u,2,1,0>: Cost 2 vext2 <1,0,u,2>, <1,0,u,2>
  2619179828U, // <u,2,1,1>: Cost 3 vext2 <0,2,u,2>, <1,1,1,1>
  2619179926U, // <u,2,1,2>: Cost 3 vext2 <0,2,u,2>, <1,2,3,0>
  2685232671U, // <u,2,1,3>: Cost 3 vext3 LHS, <2,1,3,1>
  2555604278U, // <u,2,1,4>: Cost 3 vext1 <0,u,2,1>, RHS
  2619180176U, // <u,2,1,5>: Cost 3 vext2 <0,2,u,2>, <1,5,3,7>
  2689877564U, // <u,2,1,6>: Cost 3 vext3 LHS, <2,1,6,3>
  2602718850U, // <u,2,1,7>: Cost 3 vext1 <u,7,2,1>, <7,u,1,2>
  1158703235U, // <u,2,1,u>: Cost 2 vrev <2,u,u,1>
  1481867366U, // <u,2,2,0>: Cost 2 vext1 <0,u,2,2>, LHS
  2555609846U, // <u,2,2,1>: Cost 3 vext1 <0,u,2,2>, <1,0,3,2>
  269271142U, // <u,2,2,2>: Cost 1 vdup2 LHS
  1611490930U, // <u,2,2,3>: Cost 2 vext3 LHS, <2,2,3,3>
  1481870646U, // <u,2,2,4>: Cost 2 vext1 <0,u,2,2>, RHS
  2689877640U, // <u,2,2,5>: Cost 3 vext3 LHS, <2,2,5,7>
  2619180986U, // <u,2,2,6>: Cost 3 vext2 <0,2,u,2>, <2,6,3,7>
  2593436837U, // <u,2,2,7>: Cost 3 vext1 <7,2,2,2>, <7,2,2,2>
  269271142U, // <u,2,2,u>: Cost 1 vdup2 LHS
  408134301U, // <u,2,3,0>: Cost 1 vext1 LHS, LHS
  1481876214U, // <u,2,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
  1481877096U, // <u,2,3,2>: Cost 2 vext1 LHS, <2,2,2,2>
  1880326246U, // <u,2,3,3>: Cost 2 vzipr LHS, LHS
  408137014U, // <u,2,3,4>: Cost 1 vext1 LHS, RHS
  1529654992U, // <u,2,3,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1529655802U, // <u,2,3,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1529656314U, // <u,2,3,7>: Cost 2 vext1 LHS, <7,0,1,2>
  408139566U, // <u,2,3,u>: Cost 1 vext1 LHS, LHS
  1567853468U, // <u,2,4,0>: Cost 2 vext2 <4,0,6,2>, <4,0,6,2>
  2561598362U, // <u,2,4,1>: Cost 3 vext1 <1,u,2,4>, <1,2,3,4>
  2555627214U, // <u,2,4,2>: Cost 3 vext1 <0,u,2,4>, <2,3,4,5>
  2685232918U, // <u,2,4,3>: Cost 3 vext3 LHS, <2,4,3,5>
  2555628854U, // <u,2,4,4>: Cost 3 vext1 <0,u,2,4>, RHS
  1545440566U, // <u,2,4,5>: Cost 2 vext2 <0,2,u,2>, RHS
  1571982740U, // <u,2,4,6>: Cost 2 vext2 <4,6,u,2>, <4,6,u,2>
  2592125957U, // <u,2,4,7>: Cost 3 vext1 <7,0,2,4>, <7,0,2,4>
  1545440809U, // <u,2,4,u>: Cost 2 vext2 <0,2,u,2>, RHS
  2555633766U, // <u,2,5,0>: Cost 3 vext1 <0,u,2,5>, LHS
  2561606550U, // <u,2,5,1>: Cost 3 vext1 <1,u,2,5>, <1,2,3,0>
  2689877856U, // <u,2,5,2>: Cost 3 vext3 LHS, <2,5,2,7>
  2685233000U, // <u,2,5,3>: Cost 3 vext3 LHS, <2,5,3,6>
  1158441059U, // <u,2,5,4>: Cost 2 vrev <2,u,4,5>
  2645725188U, // <u,2,5,5>: Cost 3 vext2 <4,6,u,2>, <5,5,5,5>
  2689877892U, // <u,2,5,6>: Cost 3 vext3 LHS, <2,5,6,7>
  2823900470U, // <u,2,5,7>: Cost 3 vuzpr <0,u,0,2>, RHS
  1158736007U, // <u,2,5,u>: Cost 2 vrev <2,u,u,5>
  1481900134U, // <u,2,6,0>: Cost 2 vext1 <0,u,2,6>, LHS
  2555642614U, // <u,2,6,1>: Cost 3 vext1 <0,u,2,6>, <1,0,3,2>
  2555643496U, // <u,2,6,2>: Cost 3 vext1 <0,u,2,6>, <2,2,2,2>
  1611491258U, // <u,2,6,3>: Cost 2 vext3 LHS, <2,6,3,7>
  1481903414U, // <u,2,6,4>: Cost 2 vext1 <0,u,2,6>, RHS
  2689877964U, // <u,2,6,5>: Cost 3 vext3 LHS, <2,6,5,7>
  2689877973U, // <u,2,6,6>: Cost 3 vext3 LHS, <2,6,6,7>
  2645726030U, // <u,2,6,7>: Cost 3 vext2 <4,6,u,2>, <6,7,0,1>
  1611933671U, // <u,2,6,u>: Cost 2 vext3 LHS, <2,6,u,7>
  1585919033U, // <u,2,7,0>: Cost 2 vext2 <7,0,u,2>, <7,0,u,2>
  2573566710U, // <u,2,7,1>: Cost 3 vext1 <3,u,2,7>, <1,0,3,2>
  2567596115U, // <u,2,7,2>: Cost 3 vext1 <2,u,2,7>, <2,u,2,7>
  1906901094U, // <u,2,7,3>: Cost 2 vzipr RHS, LHS
  2555653430U, // <u,2,7,4>: Cost 3 vext1 <0,u,2,7>, RHS
  2800080230U, // <u,2,7,5>: Cost 3 vuzpl LHS, <7,4,5,6>
  2980643164U, // <u,2,7,6>: Cost 3 vzipr RHS, <0,4,2,6>
  2645726828U, // <u,2,7,7>: Cost 3 vext2 <4,6,u,2>, <7,7,7,7>
  1906901099U, // <u,2,7,u>: Cost 2 vzipr RHS, LHS
  408175266U, // <u,2,u,0>: Cost 1 vext1 LHS, LHS
  1545443118U, // <u,2,u,1>: Cost 2 vext2 <0,2,u,2>, LHS
  269271142U, // <u,2,u,2>: Cost 1 vdup2 LHS
  1611491416U, // <u,2,u,3>: Cost 2 vext3 LHS, <2,u,3,3>
  408177974U, // <u,2,u,4>: Cost 1 vext1 LHS, RHS
  1545443482U, // <u,2,u,5>: Cost 2 vext2 <0,2,u,2>, RHS
  1726339226U, // <u,2,u,6>: Cost 2 vuzpl LHS, RHS
  1529697274U, // <u,2,u,7>: Cost 2 vext1 LHS, <7,0,1,2>
  408180526U, // <u,2,u,u>: Cost 1 vext1 LHS, LHS
  1544781824U, // <u,3,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
  471040156U, // <u,3,0,1>: Cost 1 vext2 LHS, LHS
  1544781988U, // <u,3,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
  2618523900U, // <u,3,0,3>: Cost 3 vext2 LHS, <0,3,1,0>
  1544782162U, // <u,3,0,4>: Cost 2 vext2 LHS, <0,4,1,5>
  2238188352U, // <u,3,0,5>: Cost 3 vrev <3,u,5,0>
  2623169023U, // <u,3,0,6>: Cost 3 vext2 LHS, <0,6,2,7>
  2238335826U, // <u,3,0,7>: Cost 3 vrev <3,u,7,0>
  471040669U, // <u,3,0,u>: Cost 1 vext2 LHS, LHS
  1544782582U, // <u,3,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
  1544782644U, // <u,3,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
  1544782742U, // <u,3,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
  1544782808U, // <u,3,1,3>: Cost 2 vext2 LHS, <1,3,1,3>
  2618524733U, // <u,3,1,4>: Cost 3 vext2 LHS, <1,4,3,5>
  1544782992U, // <u,3,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
  2618524897U, // <u,3,1,6>: Cost 3 vext2 LHS, <1,6,3,7>
  2703517987U, // <u,3,1,7>: Cost 3 vext3 <3,1,7,u>, <3,1,7,u>
  1544783213U, // <u,3,1,u>: Cost 2 vext2 LHS, <1,u,1,3>
  1529716838U, // <u,3,2,0>: Cost 2 vext1 <u,u,3,2>, LHS
  1164167966U, // <u,3,2,1>: Cost 2 vrev <3,u,1,2>
  1544783464U, // <u,3,2,2>: Cost 2 vext2 LHS, <2,2,2,2>
  1544783526U, // <u,3,2,3>: Cost 2 vext2 LHS, <2,3,0,1>
  1529720118U, // <u,3,2,4>: Cost 2 vext1 <u,u,3,2>, RHS
  2618525544U, // <u,3,2,5>: Cost 3 vext2 LHS, <2,5,3,6>
  1544783802U, // <u,3,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
  2704181620U, // <u,3,2,7>: Cost 3 vext3 <3,2,7,u>, <3,2,7,u>
  1544783931U, // <u,3,2,u>: Cost 2 vext2 LHS, <2,u,0,1>
  1544784022U, // <u,3,3,0>: Cost 2 vext2 LHS, <3,0,1,2>
  1487922559U, // <u,3,3,1>: Cost 2 vext1 <1,u,3,3>, <1,u,3,3>
  1493895256U, // <u,3,3,2>: Cost 2 vext1 <2,u,3,3>, <2,u,3,3>
  336380006U, // <u,3,3,3>: Cost 1 vdup3 LHS
  1544784386U, // <u,3,3,4>: Cost 2 vext2 LHS, <3,4,5,6>
  2824054478U, // <u,3,3,5>: Cost 3 vuzpr LHS, <2,3,4,5>
  2238286668U, // <u,3,3,6>: Cost 3 vrev <3,u,6,3>
  2954069136U, // <u,3,3,7>: Cost 3 vzipr LHS, <1,5,3,7>
  336380006U, // <u,3,3,u>: Cost 1 vdup3 LHS
  1487929446U, // <u,3,4,0>: Cost 2 vext1 <1,u,3,4>, LHS
  1487930752U, // <u,3,4,1>: Cost 2 vext1 <1,u,3,4>, <1,u,3,4>
  2623171644U, // <u,3,4,2>: Cost 3 vext2 LHS, <4,2,6,0>
  2561673366U, // <u,3,4,3>: Cost 3 vext1 <1,u,3,4>, <3,0,1,2>
  1487932726U, // <u,3,4,4>: Cost 2 vext1 <1,u,3,4>, RHS
  471043382U, // <u,3,4,5>: Cost 1 vext2 LHS, RHS
  1592561012U, // <u,3,4,6>: Cost 2 vext2 LHS, <4,6,4,6>
  2238368598U, // <u,3,4,7>: Cost 3 vrev <3,u,7,4>
  471043625U, // <u,3,4,u>: Cost 1 vext2 LHS, RHS
  2555707494U, // <u,3,5,0>: Cost 3 vext1 <0,u,3,5>, LHS
  1574645465U, // <u,3,5,1>: Cost 2 vext2 <5,1,u,3>, <5,1,u,3>
  2567653106U, // <u,3,5,2>: Cost 3 vext1 <2,u,3,5>, <2,3,u,5>
  2555709954U, // <u,3,5,3>: Cost 3 vext1 <0,u,3,5>, <3,4,5,6>
  1592561606U, // <u,3,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
  1592561668U, // <u,3,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
  1592561762U, // <u,3,5,6>: Cost 2 vext2 LHS, <5,6,7,0>
  1750314294U, // <u,3,5,7>: Cost 2 vuzpr LHS, RHS
  1750314295U, // <u,3,5,u>: Cost 2 vuzpr LHS, RHS
  2623172897U, // <u,3,6,0>: Cost 3 vext2 LHS, <6,0,1,2>
  2561688962U, // <u,3,6,1>: Cost 3 vext1 <1,u,3,6>, <1,u,3,6>
  1581281795U, // <u,3,6,2>: Cost 2 vext2 <6,2,u,3>, <6,2,u,3>
  2706541204U, // <u,3,6,3>: Cost 3 vext3 <3,6,3,u>, <3,6,3,u>
  2623173261U, // <u,3,6,4>: Cost 3 vext2 LHS, <6,4,5,6>
  1164495686U, // <u,3,6,5>: Cost 2 vrev <3,u,5,6>
  1592562488U, // <u,3,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
  1592562510U, // <u,3,6,7>: Cost 2 vext2 LHS, <6,7,0,1>
  1164716897U, // <u,3,6,u>: Cost 2 vrev <3,u,u,6>
  1487954022U, // <u,3,7,0>: Cost 2 vext1 <1,u,3,7>, LHS
  1487955331U, // <u,3,7,1>: Cost 2 vext1 <1,u,3,7>, <1,u,3,7>
  1493928028U, // <u,3,7,2>: Cost 2 vext1 <2,u,3,7>, <2,u,3,7>
  2561697942U, // <u,3,7,3>: Cost 3 vext1 <1,u,3,7>, <3,0,1,2>
  1487957302U, // <u,3,7,4>: Cost 2 vext1 <1,u,3,7>, RHS
  2707352311U, // <u,3,7,5>: Cost 3 vext3 <3,7,5,u>, <3,7,5,u>
  2655024623U, // <u,3,7,6>: Cost 3 vext2 <6,2,u,3>, <7,6,2,u>
  1592563308U, // <u,3,7,7>: Cost 2 vext2 LHS, <7,7,7,7>
  1487959854U, // <u,3,7,u>: Cost 2 vext1 <1,u,3,7>, LHS
  1544787667U, // <u,3,u,0>: Cost 2 vext2 LHS, <u,0,1,2>
  471045934U, // <u,3,u,1>: Cost 1 vext2 LHS, LHS
  1549432709U, // <u,3,u,2>: Cost 2 vext2 LHS, <u,2,3,0>
  336380006U, // <u,3,u,3>: Cost 1 vdup3 LHS
  1544788031U, // <u,3,u,4>: Cost 2 vext2 LHS, <u,4,5,6>
  471046298U, // <u,3,u,5>: Cost 1 vext2 LHS, RHS
  1549433040U, // <u,3,u,6>: Cost 2 vext2 LHS, <u,6,3,7>
  1750314537U, // <u,3,u,7>: Cost 2 vuzpr LHS, RHS
  471046501U, // <u,3,u,u>: Cost 1 vext2 LHS, LHS
  2625167360U, // <u,4,0,0>: Cost 3 vext2 <1,2,u,4>, <0,0,0,0>
  1551425638U, // <u,4,0,1>: Cost 2 vext2 <1,2,u,4>, LHS
  2619195630U, // <u,4,0,2>: Cost 3 vext2 <0,2,u,4>, <0,2,u,4>
  2619343104U, // <u,4,0,3>: Cost 3 vext2 <0,3,1,4>, <0,3,1,4>
  2625167698U, // <u,4,0,4>: Cost 3 vext2 <1,2,u,4>, <0,4,1,5>
  1638329234U, // <u,4,0,5>: Cost 2 vext3 RHS, <4,0,5,1>
  1638329244U, // <u,4,0,6>: Cost 2 vext3 RHS, <4,0,6,2>
  3787803556U, // <u,4,0,7>: Cost 4 vext3 RHS, <4,0,7,1>
  1551426205U, // <u,4,0,u>: Cost 2 vext2 <1,2,u,4>, LHS
  2555748454U, // <u,4,1,0>: Cost 3 vext1 <0,u,4,1>, LHS
  2625168180U, // <u,4,1,1>: Cost 3 vext2 <1,2,u,4>, <1,1,1,1>
  1551426503U, // <u,4,1,2>: Cost 2 vext2 <1,2,u,4>, <1,2,u,4>
  2625168344U, // <u,4,1,3>: Cost 3 vext2 <1,2,u,4>, <1,3,1,3>
  2555751734U, // <u,4,1,4>: Cost 3 vext1 <0,u,4,1>, RHS
  1860554038U, // <u,4,1,5>: Cost 2 vzipl LHS, RHS
  2689879022U, // <u,4,1,6>: Cost 3 vext3 LHS, <4,1,6,3>
  2592248852U, // <u,4,1,7>: Cost 3 vext1 <7,0,4,1>, <7,0,4,1>
  1555408301U, // <u,4,1,u>: Cost 2 vext2 <1,u,u,4>, <1,u,u,4>
  2555756646U, // <u,4,2,0>: Cost 3 vext1 <0,u,4,2>, LHS
  2625168943U, // <u,4,2,1>: Cost 3 vext2 <1,2,u,4>, <2,1,4,u>
  2625169000U, // <u,4,2,2>: Cost 3 vext2 <1,2,u,4>, <2,2,2,2>
  2619197134U, // <u,4,2,3>: Cost 3 vext2 <0,2,u,4>, <2,3,4,5>
  2555759926U, // <u,4,2,4>: Cost 3 vext1 <0,u,4,2>, RHS
  2712071222U, // <u,4,2,5>: Cost 3 vext3 RHS, <4,2,5,3>
  1994771766U, // <u,4,2,6>: Cost 2 vtrnl LHS, RHS
  2592257045U, // <u,4,2,7>: Cost 3 vext1 <7,0,4,2>, <7,0,4,2>
  1994771784U, // <u,4,2,u>: Cost 2 vtrnl LHS, RHS
  2625169558U, // <u,4,3,0>: Cost 3 vext2 <1,2,u,4>, <3,0,1,2>
  2567709594U, // <u,4,3,1>: Cost 3 vext1 <2,u,4,3>, <1,2,3,4>
  2567710817U, // <u,4,3,2>: Cost 3 vext1 <2,u,4,3>, <2,u,4,3>
  2625169820U, // <u,4,3,3>: Cost 3 vext2 <1,2,u,4>, <3,3,3,3>
  2625169922U, // <u,4,3,4>: Cost 3 vext2 <1,2,u,4>, <3,4,5,6>
  2954069710U, // <u,4,3,5>: Cost 3 vzipr LHS, <2,3,4,5>
  2954068172U, // <u,4,3,6>: Cost 3 vzipr LHS, <0,2,4,6>
  3903849472U, // <u,4,3,7>: Cost 4 vuzpr <1,u,3,4>, <1,3,5,7>
  2954068174U, // <u,4,3,u>: Cost 3 vzipr LHS, <0,2,4,u>
  1505919078U, // <u,4,4,0>: Cost 2 vext1 <4,u,4,4>, LHS
  2567717831U, // <u,4,4,1>: Cost 3 vext1 <2,u,4,4>, <1,2,u,4>
  2567719010U, // <u,4,4,2>: Cost 3 vext1 <2,u,4,4>, <2,u,4,4>
  2570373542U, // <u,4,4,3>: Cost 3 vext1 <3,3,4,4>, <3,3,4,4>
  161926454U, // <u,4,4,4>: Cost 1 vdup0 RHS
  1551428918U, // <u,4,4,5>: Cost 2 vext2 <1,2,u,4>, RHS
  1638329572U, // <u,4,4,6>: Cost 2 vext3 RHS, <4,4,6,6>
  2594927963U, // <u,4,4,7>: Cost 3 vext1 <7,4,4,4>, <7,4,4,4>
  161926454U, // <u,4,4,u>: Cost 1 vdup0 RHS
  1493983334U, // <u,4,5,0>: Cost 2 vext1 <2,u,4,5>, LHS
  2689879301U, // <u,4,5,1>: Cost 3 vext3 LHS, <4,5,1,3>
  1493985379U, // <u,4,5,2>: Cost 2 vext1 <2,u,4,5>, <2,u,4,5>
  2567727254U, // <u,4,5,3>: Cost 3 vext1 <2,u,4,5>, <3,0,1,2>
  1493986614U, // <u,4,5,4>: Cost 2 vext1 <2,u,4,5>, RHS
  1863535926U, // <u,4,5,5>: Cost 2 vzipl RHS, RHS
  537750838U, // <u,4,5,6>: Cost 1 vext3 LHS, RHS
  2830110006U, // <u,4,5,7>: Cost 3 vuzpr <1,u,3,4>, RHS
  537750856U, // <u,4,5,u>: Cost 1 vext3 LHS, RHS
  1482047590U, // <u,4,6,0>: Cost 2 vext1 <0,u,4,6>, LHS
  2555790070U, // <u,4,6,1>: Cost 3 vext1 <0,u,4,6>, <1,0,3,2>
  2555790952U, // <u,4,6,2>: Cost 3 vext1 <0,u,4,6>, <2,2,2,2>
  2555791510U, // <u,4,6,3>: Cost 3 vext1 <0,u,4,6>, <3,0,1,2>
  1482050870U, // <u,4,6,4>: Cost 2 vext1 <0,u,4,6>, RHS
  2689879422U, // <u,4,6,5>: Cost 3 vext3 LHS, <4,6,5,7>
  1997753654U, // <u,4,6,6>: Cost 2 vtrnl RHS, RHS
  2712071562U, // <u,4,6,7>: Cost 3 vext3 RHS, <4,6,7,1>
  1482053422U, // <u,4,6,u>: Cost 2 vext1 <0,u,4,6>, LHS
  2567741542U, // <u,4,7,0>: Cost 3 vext1 <2,u,4,7>, LHS
  2567742362U, // <u,4,7,1>: Cost 3 vext1 <2,u,4,7>, <1,2,3,4>
  2567743589U, // <u,4,7,2>: Cost 3 vext1 <2,u,4,7>, <2,u,4,7>
  2573716286U, // <u,4,7,3>: Cost 3 vext1 <3,u,4,7>, <3,u,4,7>
  2567744822U, // <u,4,7,4>: Cost 3 vext1 <2,u,4,7>, RHS
  2712071624U, // <u,4,7,5>: Cost 3 vext3 RHS, <4,7,5,0>
  96808489U, // <u,4,7,6>: Cost 1 vrev RHS
  2651715180U, // <u,4,7,7>: Cost 3 vext2 <5,6,u,4>, <7,7,7,7>
  96955963U, // <u,4,7,u>: Cost 1 vrev RHS
  1482063974U, // <u,4,u,0>: Cost 2 vext1 <0,u,4,u>, LHS
  1551431470U, // <u,4,u,1>: Cost 2 vext2 <1,2,u,4>, LHS
  1494009958U, // <u,4,u,2>: Cost 2 vext1 <2,u,4,u>, <2,u,4,u>
  2555807894U, // <u,4,u,3>: Cost 3 vext1 <0,u,4,u>, <3,0,1,2>
  161926454U, // <u,4,u,4>: Cost 1 vdup0 RHS
  1551431834U, // <u,4,u,5>: Cost 2 vext2 <1,2,u,4>, RHS
  537751081U, // <u,4,u,6>: Cost 1 vext3 LHS, RHS
  2830110249U, // <u,4,u,7>: Cost 3 vuzpr <1,u,3,4>, RHS
  537751099U, // <u,4,u,u>: Cost 1 vext3 LHS, RHS
  2631811072U, // <u,5,0,0>: Cost 3 vext2 <2,3,u,5>, <0,0,0,0>
  1558069350U, // <u,5,0,1>: Cost 2 vext2 <2,3,u,5>, LHS
  2619203823U, // <u,5,0,2>: Cost 3 vext2 <0,2,u,5>, <0,2,u,5>
  2619867456U, // <u,5,0,3>: Cost 3 vext2 <0,3,u,5>, <0,3,u,5>
  1546273106U, // <u,5,0,4>: Cost 2 vext2 <0,4,1,5>, <0,4,1,5>
  2733010539U, // <u,5,0,5>: Cost 3 vext3 LHS, <5,0,5,1>
  2597622682U, // <u,5,0,6>: Cost 3 vext1 <7,u,5,0>, <6,7,u,5>
  1176539396U, // <u,5,0,7>: Cost 2 vrev <5,u,7,0>
  1558069917U, // <u,5,0,u>: Cost 2 vext2 <2,3,u,5>, LHS
  1505968230U, // <u,5,1,0>: Cost 2 vext1 <4,u,5,1>, LHS
  2624512887U, // <u,5,1,1>: Cost 3 vext2 <1,1,u,5>, <1,1,u,5>
  2631811990U, // <u,5,1,2>: Cost 3 vext2 <2,3,u,5>, <1,2,3,0>
  2618541056U, // <u,5,1,3>: Cost 3 vext2 <0,1,u,5>, <1,3,5,7>
  1505971510U, // <u,5,1,4>: Cost 2 vext1 <4,u,5,1>, RHS
  2627167419U, // <u,5,1,5>: Cost 3 vext2 <1,5,u,5>, <1,5,u,5>
  2579714554U, // <u,5,1,6>: Cost 3 vext1 <4,u,5,1>, <6,2,7,3>
  1638330064U, // <u,5,1,7>: Cost 2 vext3 RHS, <5,1,7,3>
  1638477529U, // <u,5,1,u>: Cost 2 vext3 RHS, <5,1,u,3>
  2561802342U, // <u,5,2,0>: Cost 3 vext1 <1,u,5,2>, LHS
  2561803264U, // <u,5,2,1>: Cost 3 vext1 <1,u,5,2>, <1,3,5,7>
  2631149217U, // <u,5,2,2>: Cost 3 vext2 <2,2,u,5>, <2,2,u,5>
  1558071026U, // <u,5,2,3>: Cost 2 vext2 <2,3,u,5>, <2,3,u,5>
  2561805622U, // <u,5,2,4>: Cost 3 vext1 <1,u,5,2>, RHS
  2714062607U, // <u,5,2,5>: Cost 3 vext3 RHS, <5,2,5,3>
  2631813050U, // <u,5,2,6>: Cost 3 vext2 <2,3,u,5>, <2,6,3,7>
  3092335926U, // <u,5,2,7>: Cost 3 vtrnr <0,u,0,2>, RHS
  1561389191U, // <u,5,2,u>: Cost 2 vext2 <2,u,u,5>, <2,u,u,5>
  2561810534U, // <u,5,3,0>: Cost 3 vext1 <1,u,5,3>, LHS
  2561811857U, // <u,5,3,1>: Cost 3 vext1 <1,u,5,3>, <1,u,5,3>
  2631813474U, // <u,5,3,2>: Cost 3 vext2 <2,3,u,5>, <3,2,5,u>
  2631813532U, // <u,5,3,3>: Cost 3 vext2 <2,3,u,5>, <3,3,3,3>
  2619869698U, // <u,5,3,4>: Cost 3 vext2 <0,3,u,5>, <3,4,5,6>
  3001847002U, // <u,5,3,5>: Cost 3 vzipr LHS, <4,4,5,5>
  2954070530U, // <u,5,3,6>: Cost 3 vzipr LHS, <3,4,5,6>
  2018749750U, // <u,5,3,7>: Cost 2 vtrnr LHS, RHS
  2018749751U, // <u,5,3,u>: Cost 2 vtrnr LHS, RHS
  2573762662U, // <u,5,4,0>: Cost 3 vext1 <3,u,5,4>, LHS
  2620017634U, // <u,5,4,1>: Cost 3 vext2 <0,4,1,5>, <4,1,5,0>
  2573764338U, // <u,5,4,2>: Cost 3 vext1 <3,u,5,4>, <2,3,u,5>
  2573765444U, // <u,5,4,3>: Cost 3 vext1 <3,u,5,4>, <3,u,5,4>
  1570680053U, // <u,5,4,4>: Cost 2 vext2 <4,4,u,5>, <4,4,u,5>
  1558072630U, // <u,5,4,5>: Cost 2 vext2 <2,3,u,5>, RHS
  2645749143U, // <u,5,4,6>: Cost 3 vext2 <4,6,u,5>, <4,6,u,5>
  1638330310U, // <u,5,4,7>: Cost 2 vext3 RHS, <5,4,7,6>
  1558072873U, // <u,5,4,u>: Cost 2 vext2 <2,3,u,5>, RHS
  1506000998U, // <u,5,5,0>: Cost 2 vext1 <4,u,5,5>, LHS
  2561827984U, // <u,5,5,1>: Cost 3 vext1 <1,u,5,5>, <1,5,3,7>
  2579744360U, // <u,5,5,2>: Cost 3 vext1 <4,u,5,5>, <2,2,2,2>
  2579744918U, // <u,5,5,3>: Cost 3 vext1 <4,u,5,5>, <3,0,1,2>
  1506004278U, // <u,5,5,4>: Cost 2 vext1 <4,u,5,5>, RHS
  229035318U, // <u,5,5,5>: Cost 1 vdup1 RHS
  2712072206U, // <u,5,5,6>: Cost 3 vext3 RHS, <5,5,6,6>
  1638330392U, // <u,5,5,7>: Cost 2 vext3 RHS, <5,5,7,7>
  229035318U, // <u,5,5,u>: Cost 1 vdup1 RHS
  1500037222U, // <u,5,6,0>: Cost 2 vext1 <3,u,5,6>, LHS
  2561836436U, // <u,5,6,1>: Cost 3 vext1 <1,u,5,6>, <1,u,5,6>
  2567809133U, // <u,5,6,2>: Cost 3 vext1 <2,u,5,6>, <2,u,5,6>
  1500040006U, // <u,5,6,3>: Cost 2 vext1 <3,u,5,6>, <3,u,5,6>
  1500040502U, // <u,5,6,4>: Cost 2 vext1 <3,u,5,6>, RHS
  2714062935U, // <u,5,6,5>: Cost 3 vext3 RHS, <5,6,5,7>
  2712072288U, // <u,5,6,6>: Cost 3 vext3 RHS, <5,6,6,7>
  27705344U, // <u,5,6,7>: Cost 0 copy RHS
  27705344U, // <u,5,6,u>: Cost 0 copy RHS
  1488101478U, // <u,5,7,0>: Cost 2 vext1 <1,u,5,7>, LHS
  1488102805U, // <u,5,7,1>: Cost 2 vext1 <1,u,5,7>, <1,u,5,7>
  2561844840U, // <u,5,7,2>: Cost 3 vext1 <1,u,5,7>, <2,2,2,2>
  2561845398U, // <u,5,7,3>: Cost 3 vext1 <1,u,5,7>, <3,0,1,2>
  1488104758U, // <u,5,7,4>: Cost 2 vext1 <1,u,5,7>, RHS
  1638330536U, // <u,5,7,5>: Cost 2 vext3 RHS, <5,7,5,7>
  2712072362U, // <u,5,7,6>: Cost 3 vext3 RHS, <5,7,6,0>
  2042965302U, // <u,5,7,7>: Cost 2 vtrnr RHS, RHS
  1488107310U, // <u,5,7,u>: Cost 2 vext1 <1,u,5,7>, LHS
  1488109670U, // <u,5,u,0>: Cost 2 vext1 <1,u,5,u>, LHS
  1488110998U, // <u,5,u,1>: Cost 2 vext1 <1,u,5,u>, <1,u,5,u>
  2561853032U, // <u,5,u,2>: Cost 3 vext1 <1,u,5,u>, <2,2,2,2>
  1500056392U, // <u,5,u,3>: Cost 2 vext1 <3,u,5,u>, <3,u,5,u>
  1488112950U, // <u,5,u,4>: Cost 2 vext1 <1,u,5,u>, RHS
  229035318U, // <u,5,u,5>: Cost 1 vdup1 RHS
  2954111490U, // <u,5,u,6>: Cost 3 vzipr LHS, <3,4,5,6>
  27705344U, // <u,5,u,7>: Cost 0 copy RHS
  27705344U, // <u,5,u,u>: Cost 0 copy RHS
  2619211776U, // <u,6,0,0>: Cost 3 vext2 <0,2,u,6>, <0,0,0,0>
  1545470054U, // <u,6,0,1>: Cost 2 vext2 <0,2,u,6>, LHS
  1545470192U, // <u,6,0,2>: Cost 2 vext2 <0,2,u,6>, <0,2,u,6>
  2255958969U, // <u,6,0,3>: Cost 3 vrev <6,u,3,0>
  1546797458U, // <u,6,0,4>: Cost 2 vext2 <0,4,u,6>, <0,4,u,6>
  2720624971U, // <u,6,0,5>: Cost 3 vext3 <6,0,5,u>, <6,0,5,u>
  2256180180U, // <u,6,0,6>: Cost 3 vrev <6,u,6,0>
  2960682294U, // <u,6,0,7>: Cost 3 vzipr <1,2,u,0>, RHS
  1545470621U, // <u,6,0,u>: Cost 2 vext2 <0,2,u,6>, LHS
  1182004127U, // <u,6,1,0>: Cost 2 vrev <6,u,0,1>
  2619212596U, // <u,6,1,1>: Cost 3 vext2 <0,2,u,6>, <1,1,1,1>
  2619212694U, // <u,6,1,2>: Cost 3 vext2 <0,2,u,6>, <1,2,3,0>
  2619212760U, // <u,6,1,3>: Cost 3 vext2 <0,2,u,6>, <1,3,1,3>
  2626511979U, // <u,6,1,4>: Cost 3 vext2 <1,4,u,6>, <1,4,u,6>
  2619212944U, // <u,6,1,5>: Cost 3 vext2 <0,2,u,6>, <1,5,3,7>
  2714063264U, // <u,6,1,6>: Cost 3 vext3 RHS, <6,1,6,3>
  2967326006U, // <u,6,1,7>: Cost 3 vzipr <2,3,u,1>, RHS
  1182594023U, // <u,6,1,u>: Cost 2 vrev <6,u,u,1>
  1506050150U, // <u,6,2,0>: Cost 2 vext1 <4,u,6,2>, LHS
  2579792630U, // <u,6,2,1>: Cost 3 vext1 <4,u,6,2>, <1,0,3,2>
  2619213416U, // <u,6,2,2>: Cost 3 vext2 <0,2,u,6>, <2,2,2,2>
  2619213478U, // <u,6,2,3>: Cost 3 vext2 <0,2,u,6>, <2,3,0,1>
  1506053430U, // <u,6,2,4>: Cost 2 vext1 <4,u,6,2>, RHS
  2633148309U, // <u,6,2,5>: Cost 3 vext2 <2,5,u,6>, <2,5,u,6>
  2619213754U, // <u,6,2,6>: Cost 3 vext2 <0,2,u,6>, <2,6,3,7>
  1638330874U, // <u,6,2,7>: Cost 2 vext3 RHS, <6,2,7,3>
  1638478339U, // <u,6,2,u>: Cost 2 vext3 RHS, <6,2,u,3>
  2619213974U, // <u,6,3,0>: Cost 3 vext2 <0,2,u,6>, <3,0,1,2>
  2255836074U, // <u,6,3,1>: Cost 3 vrev <6,u,1,3>
  2255909811U, // <u,6,3,2>: Cost 3 vrev <6,u,2,3>
  2619214236U, // <u,6,3,3>: Cost 3 vext2 <0,2,u,6>, <3,3,3,3>
  1564715549U, // <u,6,3,4>: Cost 2 vext2 <3,4,u,6>, <3,4,u,6>
  2639121006U, // <u,6,3,5>: Cost 3 vext2 <3,5,u,6>, <3,5,u,6>
  3001847012U, // <u,6,3,6>: Cost 3 vzipr LHS, <4,4,6,6>
  1880329526U, // <u,6,3,7>: Cost 2 vzipr LHS, RHS
  1880329527U, // <u,6,3,u>: Cost 2 vzipr LHS, RHS
  2567864422U, // <u,6,4,0>: Cost 3 vext1 <2,u,6,4>, LHS
  2733011558U, // <u,6,4,1>: Cost 3 vext3 LHS, <6,4,1,3>
  2567866484U, // <u,6,4,2>: Cost 3 vext1 <2,u,6,4>, <2,u,6,4>
  2638458005U, // <u,6,4,3>: Cost 3 vext2 <3,4,u,6>, <4,3,6,u>
  1570540772U, // <u,6,4,4>: Cost 2 vext2 <4,4,6,6>, <4,4,6,6>
  1545473334U, // <u,6,4,5>: Cost 2 vext2 <0,2,u,6>, RHS
  1572015512U, // <u,6,4,6>: Cost 2 vext2 <4,6,u,6>, <4,6,u,6>
  2960715062U, // <u,6,4,7>: Cost 3 vzipr <1,2,u,4>, RHS
  1545473577U, // <u,6,4,u>: Cost 2 vext2 <0,2,u,6>, RHS
  2567872614U, // <u,6,5,0>: Cost 3 vext1 <2,u,6,5>, LHS
  2645757648U, // <u,6,5,1>: Cost 3 vext2 <4,6,u,6>, <5,1,7,3>
  2567874490U, // <u,6,5,2>: Cost 3 vext1 <2,u,6,5>, <2,6,3,7>
  2576501250U, // <u,6,5,3>: Cost 3 vext1 <4,3,6,5>, <3,4,5,6>
  1576660943U, // <u,6,5,4>: Cost 2 vext2 <5,4,u,6>, <5,4,u,6>
  2645757956U, // <u,6,5,5>: Cost 3 vext2 <4,6,u,6>, <5,5,5,5>
  2645758050U, // <u,6,5,6>: Cost 3 vext2 <4,6,u,6>, <5,6,7,0>
  2824080694U, // <u,6,5,7>: Cost 3 vuzpr <0,u,2,6>, RHS
  1182626795U, // <u,6,5,u>: Cost 2 vrev <6,u,u,5>
  1506082918U, // <u,6,6,0>: Cost 2 vext1 <4,u,6,6>, LHS
  2579825398U, // <u,6,6,1>: Cost 3 vext1 <4,u,6,6>, <1,0,3,2>
  2645758458U, // <u,6,6,2>: Cost 3 vext2 <4,6,u,6>, <6,2,7,3>
  2579826838U, // <u,6,6,3>: Cost 3 vext1 <4,u,6,6>, <3,0,1,2>
  1506086198U, // <u,6,6,4>: Cost 2 vext1 <4,u,6,6>, RHS
  2579828432U, // <u,6,6,5>: Cost 3 vext1 <4,u,6,6>, <5,1,7,3>
  296144182U, // <u,6,6,6>: Cost 1 vdup2 RHS
  1638331202U, // <u,6,6,7>: Cost 2 vext3 RHS, <6,6,7,7>
  296144182U, // <u,6,6,u>: Cost 1 vdup2 RHS
  432349286U, // <u,6,7,0>: Cost 1 vext1 RHS, LHS
  1506091766U, // <u,6,7,1>: Cost 2 vext1 RHS, <1,0,3,2>
  1506092648U, // <u,6,7,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1506093206U, // <u,6,7,3>: Cost 2 vext1 RHS, <3,0,1,2>
  432352809U, // <u,6,7,4>: Cost 1 vext1 RHS, RHS
  1506094800U, // <u,6,7,5>: Cost 2 vext1 RHS, <5,1,7,3>
  1506095610U, // <u,6,7,6>: Cost 2 vext1 RHS, <6,2,7,3>
  1906904374U, // <u,6,7,7>: Cost 2 vzipr RHS, RHS
  432355118U, // <u,6,7,u>: Cost 1 vext1 RHS, LHS
  432357478U, // <u,6,u,0>: Cost 1 vext1 RHS, LHS
  1545475886U, // <u,6,u,1>: Cost 2 vext2 <0,2,u,6>, LHS
  1506100840U, // <u,6,u,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1506101398U, // <u,6,u,3>: Cost 2 vext1 RHS, <3,0,1,2>
  432361002U, // <u,6,u,4>: Cost 1 vext1 RHS, RHS
  1545476250U, // <u,6,u,5>: Cost 2 vext2 <0,2,u,6>, RHS
  296144182U, // <u,6,u,6>: Cost 1 vdup2 RHS
  1880370486U, // <u,6,u,7>: Cost 2 vzipr LHS, RHS
  432363310U, // <u,6,u,u>: Cost 1 vext1 RHS, LHS
  1571356672U, // <u,7,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
  497614950U, // <u,7,0,1>: Cost 1 vext2 RHS, LHS
  1571356836U, // <u,7,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
  2573880146U, // <u,7,0,3>: Cost 3 vext1 <3,u,7,0>, <3,u,7,0>
  1571357010U, // <u,7,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
  1512083716U, // <u,7,0,5>: Cost 2 vext1 <5,u,7,0>, <5,u,7,0>
  2621874741U, // <u,7,0,6>: Cost 3 vext2 <0,6,u,7>, <0,6,u,7>
  2585826298U, // <u,7,0,7>: Cost 3 vext1 <5,u,7,0>, <7,0,1,2>
  497615517U, // <u,7,0,u>: Cost 1 vext2 RHS, LHS
  1571357430U, // <u,7,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
  1571357492U, // <u,7,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
  1571357590U, // <u,7,1,2>: Cost 2 vext2 RHS, <1,2,3,0>
  1552114715U, // <u,7,1,3>: Cost 2 vext2 <1,3,u,7>, <1,3,u,7>
  2573888822U, // <u,7,1,4>: Cost 3 vext1 <3,u,7,1>, RHS
  1553441981U, // <u,7,1,5>: Cost 2 vext2 <1,5,u,7>, <1,5,u,7>
  2627847438U, // <u,7,1,6>: Cost 3 vext2 <1,6,u,7>, <1,6,u,7>
  2727408775U, // <u,7,1,7>: Cost 3 vext3 <7,1,7,u>, <7,1,7,u>
  1555432880U, // <u,7,1,u>: Cost 2 vext2 <1,u,u,7>, <1,u,u,7>
  2629838337U, // <u,7,2,0>: Cost 3 vext2 <2,0,u,7>, <2,0,u,7>
  1188058754U, // <u,7,2,1>: Cost 2 vrev <7,u,1,2>
  1571358312U, // <u,7,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
  1571358374U, // <u,7,2,3>: Cost 2 vext2 RHS, <2,3,0,1>
  2632492869U, // <u,7,2,4>: Cost 3 vext2 <2,4,u,7>, <2,4,u,7>
  2633156502U, // <u,7,2,5>: Cost 3 vext2 <2,5,u,7>, <2,5,u,7>
  1560078311U, // <u,7,2,6>: Cost 2 vext2 <2,6,u,7>, <2,6,u,7>
  2728072408U, // <u,7,2,7>: Cost 3 vext3 <7,2,7,u>, <7,2,7,u>
  1561405577U, // <u,7,2,u>: Cost 2 vext2 <2,u,u,7>, <2,u,u,7>
  1571358870U, // <u,7,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
  2627184913U, // <u,7,3,1>: Cost 3 vext2 <1,5,u,7>, <3,1,5,u>
  2633820523U, // <u,7,3,2>: Cost 3 vext2 <2,6,u,7>, <3,2,6,u>
  1571359132U, // <u,7,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
  1571359234U, // <u,7,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
  1512108295U, // <u,7,3,5>: Cost 2 vext1 <5,u,7,3>, <5,u,7,3>
  1518080992U, // <u,7,3,6>: Cost 2 vext1 <6,u,7,3>, <6,u,7,3>
  2640456465U, // <u,7,3,7>: Cost 3 vext2 <3,7,u,7>, <3,7,u,7>
  1571359518U, // <u,7,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
  1571359634U, // <u,7,4,0>: Cost 2 vext2 RHS, <4,0,5,1>
  2573911067U, // <u,7,4,1>: Cost 3 vext1 <3,u,7,4>, <1,3,u,7>
  2645101622U, // <u,7,4,2>: Cost 3 vext2 RHS, <4,2,5,3>
  2573912918U, // <u,7,4,3>: Cost 3 vext1 <3,u,7,4>, <3,u,7,4>
  1571359952U, // <u,7,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
  497618248U, // <u,7,4,5>: Cost 1 vext2 RHS, RHS
  1571360116U, // <u,7,4,6>: Cost 2 vext2 RHS, <4,6,4,6>
  2645102024U, // <u,7,4,7>: Cost 3 vext2 RHS, <4,7,5,0>
  497618473U, // <u,7,4,u>: Cost 1 vext2 RHS, RHS
  2645102152U, // <u,7,5,0>: Cost 3 vext2 RHS, <5,0,1,2>
  1571360464U, // <u,7,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
  2645102334U, // <u,7,5,2>: Cost 3 vext2 RHS, <5,2,3,4>
  2645102447U, // <u,7,5,3>: Cost 3 vext2 RHS, <5,3,7,0>
  1571360710U, // <u,7,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
  1571360772U, // <u,7,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
  1571360866U, // <u,7,5,6>: Cost 2 vext2 RHS, <5,6,7,0>
  1571360936U, // <u,7,5,7>: Cost 2 vext2 RHS, <5,7,5,7>
  1571361017U, // <u,7,5,u>: Cost 2 vext2 RHS, <5,u,5,7>
  1530044518U, // <u,7,6,0>: Cost 2 vext1 <u,u,7,6>, LHS
  2645103016U, // <u,7,6,1>: Cost 3 vext2 RHS, <6,1,7,2>
  1571361274U, // <u,7,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
  2645103154U, // <u,7,6,3>: Cost 3 vext2 RHS, <6,3,4,5>
  1530047798U, // <u,7,6,4>: Cost 2 vext1 <u,u,7,6>, RHS
  1188386474U, // <u,7,6,5>: Cost 2 vrev <7,u,5,6>
  1571361592U, // <u,7,6,6>: Cost 2 vext2 RHS, <6,6,6,6>
  1571361614U, // <u,7,6,7>: Cost 2 vext2 RHS, <6,7,0,1>
  1571361695U, // <u,7,6,u>: Cost 2 vext2 RHS, <6,u,0,1>
  1571361786U, // <u,7,7,0>: Cost 2 vext2 RHS, <7,0,1,2>
  2573935616U, // <u,7,7,1>: Cost 3 vext1 <3,u,7,7>, <1,3,5,7>
  2645103781U, // <u,7,7,2>: Cost 3 vext2 RHS, <7,2,2,2>
  2573937497U, // <u,7,7,3>: Cost 3 vext1 <3,u,7,7>, <3,u,7,7>
  1571362150U, // <u,7,7,4>: Cost 2 vext2 RHS, <7,4,5,6>
  1512141067U, // <u,7,7,5>: Cost 2 vext1 <5,u,7,7>, <5,u,7,7>
  1518113764U, // <u,7,7,6>: Cost 2 vext1 <6,u,7,7>, <6,u,7,7>
  363253046U, // <u,7,7,7>: Cost 1 vdup3 RHS
  363253046U, // <u,7,7,u>: Cost 1 vdup3 RHS
  1571362515U, // <u,7,u,0>: Cost 2 vext2 RHS, <u,0,1,2>
  497620782U, // <u,7,u,1>: Cost 1 vext2 RHS, LHS
  1571362693U, // <u,7,u,2>: Cost 2 vext2 RHS, <u,2,3,0>
  1571362748U, // <u,7,u,3>: Cost 2 vext2 RHS, <u,3,0,1>
  1571362879U, // <u,7,u,4>: Cost 2 vext2 RHS, <u,4,5,6>
  497621146U, // <u,7,u,5>: Cost 1 vext2 RHS, RHS
  1571363024U, // <u,7,u,6>: Cost 2 vext2 RHS, <u,6,3,7>
  363253046U, // <u,7,u,7>: Cost 1 vdup3 RHS
  497621349U, // <u,7,u,u>: Cost 1 vext2 RHS, LHS
  135053414U, // <u,u,0,0>: Cost 1 vdup0 LHS
  471081121U, // <u,u,0,1>: Cost 1 vext2 LHS, LHS
  1544822948U, // <u,u,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
  1616140005U, // <u,u,0,3>: Cost 2 vext3 LHS, <u,0,3,2>
  1544823122U, // <u,u,0,4>: Cost 2 vext2 LHS, <0,4,1,5>
  1512157453U, // <u,u,0,5>: Cost 2 vext1 <5,u,u,0>, <5,u,u,0>
  1662220032U, // <u,u,0,6>: Cost 2 vext3 RHS, <u,0,6,2>
  1194457487U, // <u,u,0,7>: Cost 2 vrev <u,u,7,0>
  471081629U, // <u,u,0,u>: Cost 1 vext2 LHS, LHS
  1544823542U, // <u,u,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
  202162278U, // <u,u,1,1>: Cost 1 vdup1 LHS
  537753390U, // <u,u,1,2>: Cost 1 vext3 LHS, LHS
  1544823768U, // <u,u,1,3>: Cost 2 vext2 LHS, <1,3,1,3>
  1494248758U, // <u,u,1,4>: Cost 2 vext1 <2,u,u,1>, RHS
  1544823952U, // <u,u,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
  1518138343U, // <u,u,1,6>: Cost 2 vext1 <6,u,u,1>, <6,u,u,1>
  1640322907U, // <u,u,1,7>: Cost 2 vext3 RHS, <u,1,7,3>
  537753444U, // <u,u,1,u>: Cost 1 vext3 LHS, LHS
  1482309734U, // <u,u,2,0>: Cost 2 vext1 <0,u,u,2>, LHS
  1194031451U, // <u,u,2,1>: Cost 2 vrev <u,u,1,2>
  269271142U, // <u,u,2,2>: Cost 1 vdup2 LHS
  835584U, // <u,u,2,3>: Cost 0 copy LHS
  1482313014U, // <u,u,2,4>: Cost 2 vext1 <0,u,u,2>, RHS
  2618566504U, // <u,u,2,5>: Cost 3 vext2 LHS, <2,5,3,6>
  1544824762U, // <u,u,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
  1638479788U, // <u,u,2,7>: Cost 2 vext3 RHS, <u,2,7,3>
  835584U, // <u,u,2,u>: Cost 0 copy LHS
  408576723U, // <u,u,3,0>: Cost 1 vext1 LHS, LHS
  1482318582U, // <u,u,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
  120371557U, // <u,u,3,2>: Cost 1 vrev LHS
  336380006U, // <u,u,3,3>: Cost 1 vdup3 LHS
  408579382U, // <u,u,3,4>: Cost 1 vext1 LHS, RHS
  1616140271U, // <u,u,3,5>: Cost 2 vext3 LHS, <u,3,5,7>
  1530098170U, // <u,u,3,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1880329544U, // <u,u,3,7>: Cost 2 vzipr LHS, RHS
  408581934U, // <u,u,3,u>: Cost 1 vext1 LHS, LHS
  1488298086U, // <u,u,4,0>: Cost 2 vext1 <1,u,u,4>, LHS
  1488299437U, // <u,u,4,1>: Cost 2 vext1 <1,u,u,4>, <1,u,u,4>
  1659271204U, // <u,u,4,2>: Cost 2 vext3 LHS, <u,4,2,6>
  1194195311U, // <u,u,4,3>: Cost 2 vrev <u,u,3,4>
  161926454U, // <u,u,4,4>: Cost 1 vdup0 RHS
  471084342U, // <u,u,4,5>: Cost 1 vext2 LHS, RHS
  1571368308U, // <u,u,4,6>: Cost 2 vext2 RHS, <4,6,4,6>
  1640323153U, // <u,u,4,7>: Cost 2 vext3 RHS, <u,4,7,6>
  471084585U, // <u,u,4,u>: Cost 1 vext2 LHS, RHS
  1494278246U, // <u,u,5,0>: Cost 2 vext1 <2,u,u,5>, LHS
  1571368656U, // <u,u,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
  1494280327U, // <u,u,5,2>: Cost 2 vext1 <2,u,u,5>, <2,u,u,5>
  1616140415U, // <u,u,5,3>: Cost 2 vext3 LHS, <u,5,3,7>
  1494281526U, // <u,u,5,4>: Cost 2 vext1 <2,u,u,5>, RHS
  229035318U, // <u,u,5,5>: Cost 1 vdup1 RHS
  537753754U, // <u,u,5,6>: Cost 1 vext3 LHS, RHS
  1750355254U, // <u,u,5,7>: Cost 2 vuzpr LHS, RHS
  537753772U, // <u,u,5,u>: Cost 1 vext3 LHS, RHS
  1482342502U, // <u,u,6,0>: Cost 2 vext1 <0,u,u,6>, LHS
  2556084982U, // <u,u,6,1>: Cost 3 vext1 <0,u,u,6>, <1,0,3,2>
  1571369466U, // <u,u,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
  1611938000U, // <u,u,6,3>: Cost 2 vext3 LHS, <u,6,3,7>
  1482345782U, // <u,u,6,4>: Cost 2 vext1 <0,u,u,6>, RHS
  1194359171U, // <u,u,6,5>: Cost 2 vrev <u,u,5,6>
  296144182U, // <u,u,6,6>: Cost 1 vdup2 RHS
  27705344U, // <u,u,6,7>: Cost 0 copy RHS
  27705344U, // <u,u,6,u>: Cost 0 copy RHS
  432496742U, // <u,u,7,0>: Cost 1 vext1 RHS, LHS
  1488324016U, // <u,u,7,1>: Cost 2 vext1 <1,u,u,7>, <1,u,u,7>
  1494296713U, // <u,u,7,2>: Cost 2 vext1 <2,u,u,7>, <2,u,u,7>
  1906901148U, // <u,u,7,3>: Cost 2 vzipr RHS, LHS
  432500283U, // <u,u,7,4>: Cost 1 vext1 RHS, RHS
  1506242256U, // <u,u,7,5>: Cost 2 vext1 RHS, <5,1,7,3>
  120699277U, // <u,u,7,6>: Cost 1 vrev RHS
  363253046U, // <u,u,7,7>: Cost 1 vdup3 RHS
  432502574U, // <u,u,7,u>: Cost 1 vext1 RHS, LHS
  408617688U, // <u,u,u,0>: Cost 1 vext1 LHS, LHS
  471086894U, // <u,u,u,1>: Cost 1 vext2 LHS, LHS
  537753957U, // <u,u,u,2>: Cost 1 vext3 LHS, LHS
  835584U, // <u,u,u,3>: Cost 0 copy LHS
  408620342U, // <u,u,u,4>: Cost 1 vext1 LHS, RHS
  471087258U, // <u,u,u,5>: Cost 1 vext2 LHS, RHS
  537753997U, // <u,u,u,6>: Cost 1 vext3 LHS, RHS
  27705344U, // <u,u,u,7>: Cost 0 copy RHS
  835584U, // <u,u,u,u>: Cost 0 copy LHS
  0
};
