
/*
 * This software may be used and distributed according to the terms
 * of the Lesser GNU Public License, incorporated herein by reference
 *
 * Copyright (C) IBM Corporation, 2004
 *
 * Author: Max Asbck <amax@us.ibm.com>
 */

#ifndef __ibmasm_h__
#define __ibmasm_h__

#define RC_SUCCESS				0
#define RC_INVALID_HANDLE			1
#define RC_TIMEOUT				2
#define RC_NOT_OPEN				3
#define RC_OPEN_FAILED				4
#define RC_CLOSE_FAILED				5
#define RC_ALREADY_REGISTERED			6
#define RC_EVENT_NOT_REGISTERED			7
#define RC_SYSTEM_ERROR				8
#define RC_INVALID_BUFFER			9
#define RC_EVENT_CANCELLED			10
#define RC_DRIVER_CLOSED			11
#define RC_NO_EVENT_BFRS			13
#define RC_ALREADY_OPEN				14
#define RC_REVERSE_HB_ALREADY_REGISTERED	15
#define RC_REVERSE_HEARTBEAT_HAS_FAILED		17
#define RC_REVERSE_HB_ALREADY_STOPPED		18


/* dot command types */
#define dotcmd_write			0
#define dotcmd_write_next		1
#define dotcmd_read			2
#define dotcmd_read_next		3
#define dotcmd_command_response		4
#define dotcmd_event			5
#define dotcmd_heartbeat		6

/* dot command header */
#pragma pack(1)
struct dot_command {
	unsigned char	type;
	unsigned char	command_size;
	unsigned short	data_size;
	unsigned char	status;
	unsigned char	reserved;
};
#pragma pack()


extern unsigned int OpenSPDriverNode(int *handle, 
		unsigned int	io_buffer_length,
		unsigned int	node,
		unsigned int	*num,
		unsigned long	reserved);

extern unsigned int OpenSPDriver(int *handle,
		unsigned int io_buffer_length,
		unsigned long reserved);

extern unsigned int CloseSPDriver(int handle, unsigned long reserved);

extern unsigned int SystemDataIO(int handle,
		void *command,
		unsigned long reserved);

extern unsigned int RegisterForEvents(int handle,
		void *buffer,
		short ignore_count,
		unsigned char **ignore_list,
		unsigned long reserved);

extern unsigned int DeregisterForEvents(int handle, unsigned long reserved);

extern unsigned int RegisterForReverseHB(int handle, unsigned long reserved);

extern unsigned int DeRegisterForReverseHB(int handle, unsigned long reserved);

#endif /* __ibmasm_h__ */
