static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * This operation is a port of the GIMP channel-mixer plugin:                 \n"
" *                                                                            \n"
" *     Copyright (C) 2002 Martin Guldahl <mguldahl@xmission.com>              \n"
" *                                                                            \n"
" * The porting to GEGL was done by Barak Itkin                                \n"
" *                                                                            \n"
" *     Copyright (C) 2013 Barak Itkin <lightningismyname@gmail.com>           \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_boolean (preserve_luminosity, _(\"Preserve luminosity\"), FALSE)     \n"
"                                                                              \n"
"/* Red channel */                                                             \n"
"property_double (rr_gain, _(\"Red in Red channel\"), 1.0)                     \n"
"  description(_(\"Set the red amount for the red channel\"))                  \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (rg_gain, _(\"Green in Red channel\"), 0.0)                   \n"
"  description(_(\"Set the green amount for the red channel\"))                \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (rb_gain, _(\"Blue in Red channel\"), 0.0)                    \n"
"  description(_(\"Set the blue amount for the red channel\"))                 \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"/* Green channel */                                                           \n"
"property_double (gr_gain, _(\"Red in Green channel\"), 0.0)                   \n"
"  description(_(\"Set the red amount for the green channel\"))                \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (gg_gain, _(\"Green for Green channel\"), 1.0)                \n"
"  description(_(\"Set the green amount for the green channel\"))              \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (gb_gain, _(\"Blue in Green channel\"), 0.0)                  \n"
"  description(_(\"Set the blue amount for the green channel\"))               \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"/* Blue channel */                                                            \n"
"property_double (br_gain, _(\"Red in Blue channel\"), 0.0)                    \n"
"  description(_(\"Set the red amount for the blue channel\"))                 \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (bg_gain, _(\"Green in Blue channel\"), 0.0)                  \n"
"  description(_(\"Set the green amount for the blue channel\"))               \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (bb_gain, _(\"Blue in Blue channel\"), 1.0)                   \n"
"  description(_(\"Set the blue amount for the blue channel\"))                \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE channel-mixer.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef enum                                                                  \n"
"{                                                                             \n"
"  CM_RED_CHANNEL,                                                             \n"
"  CM_GREEN_CHANNEL,                                                           \n"
"  CM_BLUE_CHANNEL                                                             \n"
"} CmModeType;                                                                 \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble       red_gain;                                                     \n"
"  gdouble       green_gain;                                                   \n"
"  gdouble       blue_gain;                                                    \n"
"} CmChannelType;                                                              \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  CmChannelType  red;                                                         \n"
"  CmChannelType  green;                                                       \n"
"  CmChannelType  blue;                                                        \n"
"                                                                              \n"
"  gboolean       preserve_luminosity;                                         \n"
"  gboolean       has_alpha;                                                   \n"
"} CmParamsType;                                                               \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *input_format = gegl_operation_get_source_format (operation, \"input\");\n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  CmParamsType *mix;                                                          \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  if (o->user_data == NULL)                                                   \n"
"    o->user_data = g_slice_new0 (CmParamsType);                               \n"
"                                                                              \n"
"  mix = (CmParamsType*) o->user_data;                                         \n"
"                                                                              \n"
"  mix->preserve_luminosity = o->preserve_luminosity;                          \n"
"                                                                              \n"
"  mix->red.red_gain     = o->rr_gain;                                         \n"
"  mix->red.green_gain   = o->rg_gain;                                         \n"
"  mix->red.blue_gain    = o->rb_gain;                                         \n"
"                                                                              \n"
"  mix->green.red_gain   = o->gr_gain;                                         \n"
"  mix->green.green_gain = o->gg_gain;                                         \n"
"  mix->green.blue_gain  = o->gb_gain;                                         \n"
"                                                                              \n"
"  mix->blue.red_gain    = o->br_gain;                                         \n"
"  mix->blue.green_gain  = o->bg_gain;                                         \n"
"  mix->blue.blue_gain   = o->bb_gain;                                         \n"
"                                                                              \n"
"  if (input_format == NULL || babl_format_has_alpha (input_format))           \n"
"    {                                                                         \n"
"      mix->has_alpha = TRUE;                                                  \n"
"      format = babl_format (\"RGBA float\");                                  \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      mix->has_alpha = FALSE;                                                 \n"
"      format = babl_format (\"RGB float\");                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void finalize (GObject *object)                                        \n"
"{                                                                             \n"
"  GeglOperation *op = (void*) object;                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_slice_free (CmParamsType, o->user_data);                              \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gdouble                                                                \n"
"cm_calculate_norm (CmParamsType  *mix,                                        \n"
"                   CmChannelType *ch)                                         \n"
"{                                                                             \n"
"  gdouble sum = ch->red_gain + ch->green_gain + ch->blue_gain;                \n"
"                                                                              \n"
"  if (sum == 0.0 || ! mix->preserve_luminosity)                               \n"
"    return 1.0;                                                               \n"
"                                                                              \n"
"  return fabs (1 / sum);                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"cm_mix_pixel (CmChannelType *ch,                                              \n"
"              gfloat         r,                                               \n"
"              gfloat         g,                                               \n"
"              gfloat         b,                                               \n"
"              gdouble        norm)                                            \n"
"{                                                                             \n"
"  gdouble c = ch->red_gain * r + ch->green_gain * g + ch->blue_gain * b;      \n"
"                                                                              \n"
"  c *= norm;                                                                  \n"
"                                                                              \n"
"  return (gfloat) c;                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"cm_process_pixel (CmParamsType  *mix,                                         \n"
"                  const gfloat  *s,                                           \n"
"                  gfloat        *d,                                           \n"
"                  const gdouble  red_norm,                                    \n"
"                  const gdouble  green_norm,                                  \n"
"                  const gdouble  blue_norm)                                   \n"
"{                                                                             \n"
"                                                                              \n"
"  d[0] = cm_mix_pixel (&mix->red,   s[0], s[1], s[2], red_norm);              \n"
"  d[1] = cm_mix_pixel (&mix->green, s[0], s[1], s[2], green_norm);            \n"
"  d[2] = cm_mix_pixel (&mix->blue,  s[0], s[1], s[2], blue_norm);             \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (op);                                 \n"
"  CmParamsType *mix = (CmParamsType*) o->user_data;                           \n"
"                                                                              \n"
"  gdouble       red_norm, green_norm, blue_norm;                              \n"
"  gfloat       *in, *out;                                                     \n"
"                                                                              \n"
"  g_assert (mix != NULL);                                                     \n"
"                                                                              \n"
"  red_norm   = cm_calculate_norm (mix, &mix->red);                            \n"
"  green_norm = cm_calculate_norm (mix, &mix->green);                          \n"
"  blue_norm  = cm_calculate_norm (mix, &mix->blue);                           \n"
"                                                                              \n"
"  in = in_buf;                                                                \n"
"  out = out_buf;                                                              \n"
"                                                                              \n"
"  if (mix->has_alpha)                                                         \n"
"    {                                                                         \n"
"      while (samples--)                                                       \n"
"        {                                                                     \n"
"          cm_process_pixel (mix, in, out,                                     \n"
"                            red_norm, green_norm, blue_norm);                 \n"
"          out[3] = in[3];                                                     \n"
"                                                                              \n"
"          in += 4;                                                            \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      while (samples--)                                                       \n"
"        {                                                                     \n"
"          cm_process_pixel (mix, in, out,                                     \n"
"                            red_norm, green_norm, blue_norm);                 \n"
"          in += 3;                                                            \n"
"          out += 3;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  operation_class->prepare = prepare;                                         \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",       \"gegl:channel-mixer\",                                 \n"
"      \"categories\", \"color\",                                              \n"
"      \"title\",      _(\"Channel Mixer\"),                                   \n"
"      \"license\",    \"GPL3+\",                                              \n"
"      \"description\", _(\"Remix colors; by defining relative contributions from source components.\"),\n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
