/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _PROV_HXX_
#define _PROV_HXX_

#include <cppuhelper/weak.hxx>

#include "osl/mutex.hxx"
#include <ucbhelper/macros.hxx>
#include <com/sun/star/uno/XInterface.hpp>
#include <com/sun/star/lang/XTypeProvider.hpp>
#include <com/sun/star/lang/XInitialization.hpp>
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <com/sun/star/ucb/XContentProvider.hpp>
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/ucb/XFileIdentifierConverter.hpp>
#include <com/sun/star/container/XHierarchicalNameAccess.hpp>

// FileProvider



namespace fileaccess {

	// Forward declaration

	class BaseContent;
	class shell;

	class FileProvider:
		public cppu::OWeakObject,
		public com::sun::star::lang::XServiceInfo,
        public com::sun::star::lang::XInitialization,
		public com::sun::star::lang::XTypeProvider,
		public com::sun::star::ucb::XContentProvider,
		public com::sun::star::ucb::XContentIdentifierFactory,
		public com::sun::star::beans::XPropertySet,
		public com::sun::star::ucb::XFileIdentifierConverter
	{
		friend class BaseContent;
	public:

		FileProvider( const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& xMSF );
		~FileProvider();

		// XInterface
		virtual com::sun::star::uno::Any SAL_CALL
		queryInterface(
			const com::sun::star::uno::Type& aType )
			throw( com::sun::star::uno::RuntimeException);

		virtual void SAL_CALL
		acquire(
			void )
			throw();

		virtual void SAL_CALL
		release(
			void )
			throw();

		// XServiceInfo
		virtual rtl::OUString SAL_CALL
		getImplementationName(
			void )
			throw( com::sun::star::uno::RuntimeException );

		virtual sal_Bool SAL_CALL
		supportsService(
			const rtl::OUString& ServiceName )
			throw(com::sun::star::uno::RuntimeException );

		virtual com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL
		getSupportedServiceNames(
			void )
			throw( com::sun::star::uno::RuntimeException );


		static com::sun::star::uno::Reference< com::sun::star::lang::XSingleServiceFactory > SAL_CALL
		createServiceFactory(
			const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& rxServiceMgr );

		static com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
		CreateInstance(
			const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& xMultiServiceFactory );

		// XTypeProvider

		XTYPEPROVIDER_DECL()

        // XInitialization
        virtual void SAL_CALL
        initialize( 
            const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aArguments ) 
            throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);


		// XContentProvider
		virtual com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL
		queryContent(
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Identifier )
			throw( com::sun::star::ucb::IllegalIdentifierException,
				   com::sun::star::uno::RuntimeException );

		// XContentIdentifierFactory

		virtual com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier > SAL_CALL
		createContentIdentifier(
			const rtl::OUString& ContentId )
			throw( com::sun::star::uno::RuntimeException );


		virtual sal_Int32 SAL_CALL
		compareContentIds(
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Id1,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Id2 )
			throw( com::sun::star::uno::RuntimeException );

		// XProperySet

		virtual com::sun::star::uno::Reference< com::sun::star::beans::XPropertySetInfo > SAL_CALL
		getPropertySetInfo(  )
			throw( com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL
		setPropertyValue(
			const rtl::OUString& aPropertyName,
			const com::sun::star::uno::Any& aValue )
			throw( com::sun::star::beans::UnknownPropertyException,
				   com::sun::star::beans::PropertyVetoException,
				   com::sun::star::lang::IllegalArgumentException,
				   com::sun::star::lang::WrappedTargetException,
				   com::sun::star::uno::RuntimeException );

		virtual com::sun::star::uno::Any SAL_CALL
		getPropertyValue(
			const rtl::OUString& PropertyName )
			throw( com::sun::star::beans::UnknownPropertyException,
				   com::sun::star::lang::WrappedTargetException,
				   com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL
		addPropertyChangeListener(
			const rtl::OUString& aPropertyName,
			const com::sun::star::uno::Reference< com::sun::star::beans::XPropertyChangeListener >& xListener )
			throw( com::sun::star::beans::UnknownPropertyException,
				   com::sun::star::lang::WrappedTargetException,
				   com::sun::star::uno::RuntimeException);

		virtual void SAL_CALL
		removePropertyChangeListener(
			const rtl::OUString& aPropertyName,
			const com::sun::star::uno::Reference< com::sun::star::beans::XPropertyChangeListener >& aListener )
			throw( com::sun::star::beans::UnknownPropertyException,
				   com::sun::star::lang::WrappedTargetException,
				   com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL
		addVetoableChangeListener(
			const rtl::OUString& PropertyName,
			const com::sun::star::uno::Reference< com::sun::star::beans::XVetoableChangeListener >& aListener )
			throw( com::sun::star::beans::UnknownPropertyException,
				   com::sun::star::lang::WrappedTargetException,
				   com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL
		removeVetoableChangeListener(
			const rtl::OUString& PropertyName,
			const com::sun::star::uno::Reference< com::sun::star::beans::XVetoableChangeListener >& aListener )
			throw( com::sun::star::beans::UnknownPropertyException,
				   com::sun::star::lang::WrappedTargetException,
				   com::sun::star::uno::RuntimeException);


		// XFileIdentifierConverter

		virtual sal_Int32 SAL_CALL
		getFileProviderLocality( const rtl::OUString& BaseURL )
			throw( com::sun::star::uno::RuntimeException );

		virtual rtl::OUString SAL_CALL getFileURLFromSystemPath( const rtl::OUString& BaseURL,
																 const rtl::OUString& SystemPath )
			throw( com::sun::star::uno::RuntimeException );

		virtual rtl::OUString SAL_CALL getSystemPathFromFileURL( const rtl::OUString& URL )
			throw( com::sun::star::uno::RuntimeException );


	private:
        // methods
        void SAL_CALL init();
        
		// Members
		com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >  m_xMultiServiceFactory;

		void SAL_CALL initProperties( void );
		osl::Mutex   m_aMutex;
		rtl::OUString m_HostName;
		rtl::OUString m_HomeDirectory;
		sal_Int32     m_FileSystemNotation;

		com::sun::star::uno::Reference< com::sun::star::beans::XPropertySetInfo >     m_xPropertySetInfo;

		shell*                                                                        m_pMyShell;
	};

}       // end namespace fileaccess

#endif

