/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/properties/captionproperties.hxx>
#include <svl/itemset.hxx>
#include <svl/style.hxx>
#include <svx/svddef.hxx>
#include <editeng/eeitem.hxx>
#include <svx/svdocapt.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		// create a new itemset
		SfxItemSet& CaptionProperties::CreateObjectSpecificItemSet(SfxItemPool& rPool)
		{
			return *(new SfxItemSet(rPool,

				// range from SdrAttrObj
				SDRATTR_START, SDRATTR_SHADOW_LAST,
				SDRATTR_MISC_FIRST, SDRATTR_MISC_LAST,
				SDRATTR_TEXTDIRECTION, SDRATTR_TEXTDIRECTION,

				// range from SdrCaptionObj
				SDRATTR_CAPTION_FIRST, SDRATTR_CAPTION_LAST,

				// range from SdrTextObj
				EE_ITEMS_START, EE_ITEMS_END,

				// end
				0, 0));
		}

		CaptionProperties::CaptionProperties(SdrObject& rObj)
		:	RectangleProperties(rObj)
		{
		}

		CaptionProperties::CaptionProperties(const CaptionProperties& rProps, SdrObject& rObj)
		:	RectangleProperties(rProps, rObj)
		{
		}

		CaptionProperties::~CaptionProperties()
		{
		}
		
		BaseProperties& CaptionProperties::Clone(SdrObject& rObj) const
		{
			return *(new CaptionProperties(*this, rObj));
		}

		void CaptionProperties::ItemSetChanged(const SfxItemSet& rSet)
		{
			SdrCaptionObj& rObj = (SdrCaptionObj&)GetSdrObject();

			// local changes
			rObj.ImpRecalcTail();

			// call parent
			RectangleProperties::ItemSetChanged(rSet);
		}

		void CaptionProperties::SetStyleSheet(SfxStyleSheet* pNewStyleSheet, sal_Bool bDontRemoveHardAttr)
		{
			SdrCaptionObj& rObj = (SdrCaptionObj&)GetSdrObject();

			// call parent
			RectangleProperties::SetStyleSheet(pNewStyleSheet, bDontRemoveHardAttr);

			// local changes
			rObj.ImpRecalcTail();
		}

		void CaptionProperties::ForceDefaultAttributes()
		{
			// call parent
			RectangleProperties::ForceDefaultAttributes();

			// force ItemSet
			GetObjectItemSet();

			// this was set by TextProperties::ForceDefaultAttributes(),
			// retet to default
			mpItemSet->ClearItem(XATTR_LINESTYLE);
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
