#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2000, 2010 Oracle and/or its affiliates.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

PRJ=..$/..

PRJNAME=svtools
TARGET=treetest
LIBTARGET=NO
ENABLE_EXCEPTIONS=TRUE

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

# --- Files --------------------------------------------------------

APP1NOSAL=	TRUE
APP1TARGET= treetest
APP1OBJS=	$(OBJ)$/treetest.obj
APP1STDLIBS=$(SOTLIB)			\
			$(COMPHELPERLIB)	\
			$(CPPULIB)			\
			$(CPPUHELPERLIB)	\
			$(SALLIB)

#			$(SVTOOLLIB)		\

APP2DEF=	$(MISC)$/treetest.def

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk


# ------------------------------------------------------------------
# Windows
# ------------------------------------------------------------------

.IF "$(GUI)" == "WIN"

$(MISC)$/treetest.def: makefile.mk
	echo  NAME			treetest							>$@
	echo  DESCRIPTION	'StarView - Testprogramm'          >>$@
	echo  EXETYPE		WINDOWS 						   >>$@
	echo  STUB			'winSTUB.EXE'                      >>$@
	echo  PROTMODE										   >>$@
	echo  CODE			PRELOAD MOVEABLE DISCARDABLE	   >>$@
	echo  DATA			PRELOAD MOVEABLE MULTIPLE		   >>$@
	echo  HEAPSIZE		8192							   >>$@
	echo  STACKSIZE 	32768							   >>$@

.ENDIF

ALLTAR : $(BIN)$/treetest.rdb 

$(BIN)$/treetest.rdb : makefile.mk $(UNOUCRRDB)
	rm -f $@
	$(GNUCOPY) $(UNOUCRRDB) $@
 	+cd $(BIN) && \
 		regcomp -register -r treetest.rdb \
 			-c i18nsearch.uno$(DLLPOST) \
 			-c i18npool.uno$(DLLPOST) \
 			-c connector.uno$(DLLPOST) \
			-c remotebridge.uno$(DLLPOST) \
			-c bridgefac.uno$(DLLPOST) \
			-c uuresolver.uno$(DLLPOST) \
			-c $(DLLPRE)tk$(DLLPOSTFIX)$(DLLPOST)
