/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _EXTENSIONS_PROPCTRLR_BROWSERVIEW_HXX_
#define _EXTENSIONS_PROPCTRLR_BROWSERVIEW_HXX_

#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <vcl/window.hxx>
#include <tools/resid.hxx>
// #95343# --------------------
#include <com/sun/star/awt/Size.hpp>

//............................................................................
namespace pcr
{
//............................................................................

	class OPropertyEditor;

	//========================================================================
	//= 
	//========================================================================
	class OPropertyBrowserView : public Window
	{
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >	m_xORB;

		OPropertyEditor*		m_pPropBox;
		sal_uInt16				m_nActivePage;
		Link					m_aPageActivationHandler;

	protected:
		virtual void Resize();
		virtual void GetFocus();
        virtual long Notify( NotifyEvent& _rNEvt );

	public:
		OPropertyBrowserView(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >&	_xORB,
						Window* pParent, WinBits nBits = 0);

		virtual ~OPropertyBrowserView();

		OPropertyEditor&    getPropertyBox() { return *m_pPropBox; }

		// page handling
		sal_uInt16	getActivaPage() const { return m_nActivePage; }
		void		activatePage(sal_uInt16 _nPage);

		void	setPageActivationHandler(const Link& _rHdl) { m_aPageActivationHandler = _rHdl; }
		Link	getPageActivationHandler() const { return m_aPageActivationHandler; }

		// #95343# ------------------
		::com::sun::star::awt::Size getMinimumSize();
		
	protected:
		DECL_LINK(OnPageActivation, void*);
	};


//............................................................................
} // namespace pcr
//............................................................................

#endif // _EXTENSIONS_PROPCTRLR_BROWSERVIEW_HXX_

