/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef LUIDL_PE_EVALU_HXX
#define LUIDL_PE_EVALU_HXX



// USED SERVICES
	// BASE CLASSES
#include <s2_luidl/parsenv2.hxx>
#include <s2_luidl/pestate.hxx>
	// COMPONENTS
	// PARAMETERS


namespace udm {
class Agent_Struct;
}   // namespace udm


namespace csi
{
namespace uidl
{

class PE_Value : public UnoIDL_PE,
				 public ParseEnvState
{
  public:
						PE_Value(
							String &			o_rName,
							String &			o_rAssignment,
							bool				i_bIsConst );
	virtual void	 	EstablishContacts(
							UnoIDL_PE *			io_pParentPE,
							ary::Repository &
                                                io_rRepository,
							TokenProcessing_Result &
												o_rResult );
						~PE_Value();

	virtual void	  	ProcessToken(
							const Token &		i_rToken );

	virtual void		Process_Identifier(
							const TokIdentifier &
												i_rToken );
	virtual void		Process_Punctuation(
							const TokPunctuation &
												i_rToken );
	virtual void		Process_Assignment(
							const TokAssignment &
												i_rToken );
  private:
	enum E_State
	{
		e_none = 0,
		expect_name,
		got_name,
		e_STATES_MAX
	};
	enum E_TokenType	/// @ATTENTION  Do not change existing values (except of tt_MAX) !!! Else array-indices will break.
	{
		tt_identifier = 0,
		tt_punctuation = 1,
		tt_assignment = 2,
		tt_MAX
	};
	typedef void (PE_Value::*F_TOK)(const char *);


	void				CallHandler(
							const char *		i_sTokenText,
							E_TokenType			i_eTokenType );

	void				On_expect_name_Identifier(const char * i_sText);
	void				On_got_name_Punctuation(const char * i_sText);
	void				On_got_name_Assignment(const char * i_sText);
	void				On_Default(const char * );

	virtual void		InitData();
	virtual void		TransferData();
	virtual UnoIDL_PE &	MyPE();

	bool				IsConst() const			{ return bIsConst; }

	static F_TOK		aDispatcher[e_STATES_MAX][tt_MAX];

	E_State             eState;
	String  *			pName;
	String  *			pAssignment;
	bool				bIsConst;
};



}   // namespace uidl
}   // namespace csi


#endif

