/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.EventQueueItem;
import java.awt.MenuComponent;
import java.awt.Queue;
import java.awt.Rectangle;
import java.awt.SentEvent;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EmptyStackException;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

public class EventQueue {
    private static final DebugHelper dbg = DebugHelper.create(EventQueue.class);
    private static int threadInitNumber;
    private static final int LOW_PRIORITY = 0;
    private static final int NORM_PRIORITY = 1;
    private static final int HIGH_PRIORITY = 2;
    private static final int ULTIMATE_PRIORITY = 3;
    private static final int NUM_PRIORITIES = 4;
    private Queue[] queues = new Queue[4];
    private EventQueue nextQueue;
    private EventQueue previousQueue;
    private EventDispatchThread dispatchThread;
    private final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static final boolean debug = false;
    private long mostRecentEventTime = System.currentTimeMillis();
    private WeakReference currentEvent;
    private int waitForID;
    private final String name = "AWT-EventQueue-" + EventQueue.nextThreadNum();
    private static final int PAINT = 0;
    private static final int UPDATE = 1;
    private static final int MOVE = 2;
    private static final int DRAG = 3;
    private static final int PEER = 4;
    private static final int CACHE_LENGTH = 5;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public EventQueue() {
        for (int i = 0; i < 4; ++i) {
            this.queues[i] = new Queue();
        }
    }

    public void postEvent(AWTEvent aWTEvent) {
        SunToolkit.flushPendingEvents();
        this.postEventPrivate(aWTEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void postEventPrivate(AWTEvent aWTEvent) {
        aWTEvent.isPosted = true;
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.dispatchThread == null && this.nextQueue == null) {
                if (aWTEvent.getSource() == AWTAutoShutdown.getInstance()) {
                    return;
                }
                this.initDispatchThread();
            }
            if (this.nextQueue != null) {
                this.nextQueue.postEventPrivate(aWTEvent);
                return;
            }
            this.postEvent(aWTEvent, EventQueue.getPriority(aWTEvent));
        }
    }

    private static int getPriority(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PeerEvent && (((PeerEvent)aWTEvent).getFlags() & 2L) != 0L) {
            return 3;
        }
        if (aWTEvent instanceof PeerEvent && (((PeerEvent)aWTEvent).getFlags() & 1L) != 0L) {
            return 2;
        }
        if (aWTEvent instanceof PeerEvent && (((PeerEvent)aWTEvent).getFlags() & 4L) != 0L) {
            return 0;
        }
        int n = aWTEvent.getID();
        if (n == 800 || n == 801) {
            return 0;
        }
        return 1;
    }

    private void postEvent(AWTEvent aWTEvent, int n) {
        boolean bl;
        Object object = aWTEvent.getSource();
        if (this.coalesceEvent(aWTEvent, n)) {
            return;
        }
        EventQueueItem eventQueueItem = new EventQueueItem(aWTEvent);
        this.cacheEQItem(eventQueueItem);
        boolean bl2 = bl = aWTEvent.getID() == this.waitForID;
        if (this.queues[n].head == null) {
            boolean bl3 = this.noEvents();
            this.queues[n].head = this.queues[n].tail = eventQueueItem;
            if (bl3) {
                if (aWTEvent.getSource() != AWTAutoShutdown.getInstance()) {
                    AWTAutoShutdown.getInstance().notifyThreadBusy(this.dispatchThread);
                }
                this.notifyAll();
            } else if (bl) {
                this.notifyAll();
            }
        } else {
            this.queues[n].tail.next = eventQueueItem;
            this.queues[n].tail = eventQueueItem;
            if (bl) {
                this.notifyAll();
            }
        }
    }

    private boolean coalescePaintEvent(PaintEvent paintEvent) {
        PaintEvent paintEvent2;
        EventQueueItem[] eventQueueItemArray;
        ComponentPeer componentPeer = ((Component)paintEvent.getSource()).peer;
        if (componentPeer != null) {
            componentPeer.coalescePaintEvent(paintEvent);
        }
        if ((eventQueueItemArray = ((Component)paintEvent.getSource()).eventCache) == null) {
            return false;
        }
        int n = EventQueue.eventToCacheIndex(paintEvent);
        if (n != -1 && eventQueueItemArray[n] != null && (paintEvent2 = this.mergePaintEvents(paintEvent, (PaintEvent)eventQueueItemArray[n].event)) != null) {
            eventQueueItemArray[n].event = paintEvent2;
            return true;
        }
        return false;
    }

    private PaintEvent mergePaintEvents(PaintEvent paintEvent, PaintEvent paintEvent2) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        Rectangle rectangle2 = paintEvent2.getUpdateRect();
        if (rectangle2.contains(rectangle)) {
            return paintEvent2;
        }
        if (rectangle.contains(rectangle2)) {
            return paintEvent;
        }
        return null;
    }

    private boolean coalesceMouseEvent(MouseEvent mouseEvent) {
        EventQueueItem[] eventQueueItemArray = ((Component)mouseEvent.getSource()).eventCache;
        if (eventQueueItemArray == null) {
            return false;
        }
        int n = EventQueue.eventToCacheIndex(mouseEvent);
        if (n != -1 && eventQueueItemArray[n] != null) {
            eventQueueItemArray[n].event = mouseEvent;
            return true;
        }
        return false;
    }

    private boolean coalescePeerEvent(PeerEvent peerEvent) {
        EventQueueItem[] eventQueueItemArray = ((Component)peerEvent.getSource()).eventCache;
        if (eventQueueItemArray == null) {
            return false;
        }
        int n = EventQueue.eventToCacheIndex(peerEvent);
        if (n != -1 && eventQueueItemArray[n] != null) {
            if ((peerEvent = peerEvent.coalesceEvents((PeerEvent)eventQueueItemArray[n].event)) != null) {
                eventQueueItemArray[n].event = peerEvent;
                return true;
            }
            eventQueueItemArray[n] = null;
        }
        return false;
    }

    private boolean coalesceOtherEvent(AWTEvent aWTEvent, int n) {
        int n2 = aWTEvent.getID();
        Component component = (Component)aWTEvent.getSource();
        EventQueueItem eventQueueItem = this.queues[n].head;
        while (eventQueueItem != null) {
            AWTEvent aWTEvent2;
            if (eventQueueItem.event.getSource() == component && eventQueueItem.id == n2 && (aWTEvent2 = component.coalesceEvents(eventQueueItem.event, aWTEvent)) != null) {
                eventQueueItem.event = aWTEvent2;
                return true;
            }
            eventQueueItem = eventQueueItem.next;
        }
        return false;
    }

    private boolean coalesceEvent(AWTEvent aWTEvent, int n) {
        if (!(aWTEvent.getSource() instanceof Component)) {
            return false;
        }
        if (aWTEvent instanceof PeerEvent) {
            return this.coalescePeerEvent((PeerEvent)aWTEvent);
        }
        if (((Component)aWTEvent.getSource()).isCoalescingEnabled() && this.coalesceOtherEvent(aWTEvent, n)) {
            return true;
        }
        if (aWTEvent instanceof PaintEvent) {
            return this.coalescePaintEvent((PaintEvent)aWTEvent);
        }
        if (aWTEvent instanceof MouseEvent) {
            return this.coalesceMouseEvent((MouseEvent)aWTEvent);
        }
        return false;
    }

    private void cacheEQItem(EventQueueItem eventQueueItem) {
        int n = EventQueue.eventToCacheIndex(eventQueueItem.event);
        if (n != -1 && eventQueueItem.event.getSource() instanceof Component) {
            Component component = (Component)eventQueueItem.event.getSource();
            if (component.eventCache == null) {
                component.eventCache = new EventQueueItem[5];
            }
            component.eventCache[n] = eventQueueItem;
        }
    }

    private void uncacheEQItem(EventQueueItem eventQueueItem) {
        int n = EventQueue.eventToCacheIndex(eventQueueItem.event);
        if (n != -1 && eventQueueItem.event.getSource() instanceof Component) {
            Component component = (Component)eventQueueItem.event.getSource();
            if (component.eventCache == null) {
                return;
            }
            component.eventCache[n] = null;
        }
    }

    private static int eventToCacheIndex(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 800: {
                return 0;
            }
            case 801: {
                return 1;
            }
            case 503: {
                return 2;
            }
            case 506: {
                return 3;
            }
        }
        return aWTEvent instanceof PeerEvent ? 4 : -1;
    }

    private boolean noEvents() {
        for (int i = 0; i < 4; ++i) {
            if (this.queues[i].head == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEvent getNextEvent() throws InterruptedException {
        while (true) {
            SunToolkit.flushPendingEvents();
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                for (int i = 3; i >= 0; --i) {
                    if (this.queues[i].head == null) continue;
                    EventQueueItem eventQueueItem = this.queues[i].head;
                    this.queues[i].head = eventQueueItem.next;
                    if (eventQueueItem.next == null) {
                        this.queues[i].tail = null;
                    }
                    this.uncacheEQItem(eventQueueItem);
                    return eventQueueItem.event;
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this.dispatchThread);
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AWTEvent getNextEvent(int n) throws InterruptedException {
        while (true) {
            SunToolkit.flushPendingEvents();
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                for (int i = 0; i < 4; ++i) {
                    EventQueueItem eventQueueItem = this.queues[i].head;
                    EventQueueItem eventQueueItem2 = null;
                    while (eventQueueItem != null) {
                        if (eventQueueItem.id == n) {
                            if (eventQueueItem2 == null) {
                                this.queues[i].head = eventQueueItem.next;
                            } else {
                                eventQueueItem2.next = eventQueueItem.next;
                            }
                            if (this.queues[i].tail == eventQueueItem) {
                                this.queues[i].tail = eventQueueItem2;
                            }
                            this.uncacheEQItem(eventQueueItem);
                            return eventQueueItem.event;
                        }
                        eventQueueItem2 = eventQueueItem;
                        eventQueueItem = eventQueueItem.next;
                    }
                }
                this.waitForID = n;
                this.wait();
                this.waitForID = 0;
            }
        }
    }

    public synchronized AWTEvent peekEvent() {
        for (int i = 3; i >= 0; --i) {
            if (this.queues[i].head == null) continue;
            return this.queues[i].head.event;
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        for (int i = 3; i >= 0; --i) {
            EventQueueItem eventQueueItem = this.queues[i].head;
            while (eventQueueItem != null) {
                if (eventQueueItem.id == n) {
                    return eventQueueItem.event;
                }
                eventQueueItem = eventQueueItem.next;
            }
        }
        return null;
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        aWTEvent.isPosted = true;
        Object object = aWTEvent.getSource();
        if (aWTEvent instanceof ActiveEvent) {
            this.setCurrentEventAndMostRecentTimeImpl(aWTEvent);
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
            aWTEvent.dispatched();
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else if (object instanceof TrayIcon) {
            ((TrayIcon)object).dispatchEvent(aWTEvent);
        } else if (object instanceof AWTAutoShutdown) {
            if (this.noEvents()) {
                this.dispatchThread.stopDispatching();
            }
        } else {
            System.err.println("unable to dispatch event: " + aWTEvent);
        }
    }

    public static long getMostRecentEventTime() {
        return Toolkit.getEventQueue().getMostRecentEventTimeImpl();
    }

    private synchronized long getMostRecentEventTimeImpl() {
        return Thread.currentThread() == this.dispatchThread ? this.mostRecentEventTime : System.currentTimeMillis();
    }

    synchronized long getMostRecentEventTimeEx() {
        return this.mostRecentEventTime;
    }

    public static AWTEvent getCurrentEvent() {
        return Toolkit.getEventQueue().getCurrentEventImpl();
    }

    private synchronized AWTEvent getCurrentEventImpl() {
        return Thread.currentThread() == this.dispatchThread ? (AWTEvent)this.currentEvent.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void push(EventQueue eventQueue) {
        if (this.nextQueue != null) {
            this.nextQueue.push(eventQueue);
            return;
        }
        Object object = eventQueue;
        synchronized (object) {
            while (this.peekEvent() != null) {
                try {
                    eventQueue.postEventPrivate(this.getNextEvent());
                }
                catch (InterruptedException interruptedException) {}
            }
            eventQueue.previousQueue = this;
        }
        if (this.dispatchThread != null) {
            this.dispatchThread.stopDispatchingLater();
        }
        this.nextQueue = eventQueue;
        object = AppContext.getAppContext();
        if (((AppContext)object).get(AppContext.EVENT_QUEUE_KEY) == this) {
            ((AppContext)object).put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pop() throws EmptyStackException {
        EventQueue eventQueue = this.previousQueue;
        Object object = eventQueue != null ? eventQueue : this;
        synchronized (object) {
            EventQueue eventQueue2 = this;
            synchronized (eventQueue2) {
                if (this.nextQueue != null) {
                    this.nextQueue.pop();
                    return;
                }
                if (this.previousQueue == null) {
                    throw new EmptyStackException();
                }
                this.previousQueue.nextQueue = null;
                while (this.peekEvent() != null) {
                    try {
                        this.previousQueue.postEventPrivate(this.getNextEvent());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                AppContext appContext = AppContext.getAppContext();
                if (appContext.get(AppContext.EVENT_QUEUE_KEY) == this) {
                    appContext.put(AppContext.EVENT_QUEUE_KEY, this.previousQueue);
                }
                this.previousQueue = null;
            }
        }
        object = this.dispatchThread;
        if (object != null) {
            ((EventDispatchThread)object).stopDispatching();
        }
    }

    public static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getEventQueue();
        EventQueue eventQueue2 = eventQueue.nextQueue;
        while (eventQueue2 != null) {
            eventQueue = eventQueue2;
            eventQueue2 = eventQueue.nextQueue;
        }
        return Thread.currentThread() == eventQueue.dispatchThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initDispatchThread() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            AppContext appContext = AppContext.getAppContext();
            if (this.dispatchThread == null && !this.threadGroup.isDestroyed() && !appContext.isDisposed()) {
                this.dispatchThread = (EventDispatchThread)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        EventDispatchThread eventDispatchThread = new EventDispatchThread(EventQueue.this.threadGroup, EventQueue.this.name, EventQueue.this);
                        eventDispatchThread.setContextClassLoader(EventQueue.this.classLoader);
                        eventDispatchThread.setPriority(6);
                        eventDispatchThread.setDaemon(false);
                        return eventDispatchThread;
                    }
                });
                AWTAutoShutdown.getInstance().notifyThreadBusy(this.dispatchThread);
                this.dispatchThread.start();
            }
        }
    }

    final void detachDispatchThread() {
        this.dispatchThread = null;
    }

    final EventDispatchThread getDispatchThread() {
        return this.dispatchThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeSourceEvents(Object object, boolean bl) {
        SunToolkit.flushPendingEvents();
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            for (int i = 0; i < 4; ++i) {
                EventQueueItem eventQueueItem = this.queues[i].head;
                EventQueueItem eventQueueItem2 = null;
                while (eventQueueItem != null) {
                    if (!(eventQueueItem.event.getSource() != object || !bl && (eventQueueItem.event instanceof SequencedEvent || eventQueueItem.event instanceof SentEvent || eventQueueItem.event instanceof FocusEvent || eventQueueItem.event instanceof WindowEvent || eventQueueItem.event instanceof KeyEvent || eventQueueItem.event instanceof InputMethodEvent))) {
                        if (eventQueueItem.event instanceof SequencedEvent) {
                            ((SequencedEvent)eventQueueItem.event).dispose();
                        }
                        if (eventQueueItem.event instanceof SentEvent) {
                            ((SentEvent)eventQueueItem.event).dispose();
                        }
                        if (eventQueueItem2 == null) {
                            this.queues[i].head = eventQueueItem.next;
                        } else {
                            eventQueueItem2.next = eventQueueItem.next;
                        }
                        this.uncacheEQItem(eventQueueItem);
                    } else {
                        eventQueueItem2 = eventQueueItem;
                    }
                    eventQueueItem = eventQueueItem.next;
                }
                this.queues[i].tail = eventQueueItem2;
            }
        }
    }

    static void setCurrentEventAndMostRecentTime(AWTEvent aWTEvent) {
        Toolkit.getEventQueue().setCurrentEventAndMostRecentTimeImpl(aWTEvent);
    }

    private synchronized void setCurrentEventAndMostRecentTimeImpl(AWTEvent aWTEvent) {
        if (Thread.currentThread() != this.dispatchThread) {
            return;
        }
        this.currentEvent = new WeakReference<AWTEvent>(aWTEvent);
        long l = Long.MIN_VALUE;
        if (aWTEvent instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)aWTEvent;
            l = inputEvent.getWhen();
        } else if (aWTEvent instanceof InputMethodEvent) {
            InputMethodEvent inputMethodEvent = (InputMethodEvent)aWTEvent;
            l = inputMethodEvent.getWhen();
        } else if (aWTEvent instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)aWTEvent;
            l = actionEvent.getWhen();
        } else if (aWTEvent instanceof InvocationEvent) {
            InvocationEvent invocationEvent = (InvocationEvent)aWTEvent;
            l = invocationEvent.getWhen();
        }
        this.mostRecentEventTime = Math.max(this.mostRecentEventTime, l);
    }

    public static void invokeLater(Runnable runnable) {
        Toolkit.getEventQueue().postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        InvocationEvent invocationEvent = new InvocationEvent(Toolkit.getDefaultToolkit(), runnable, aWTInvocationLock, true);
        Object object = aWTInvocationLock;
        synchronized (object) {
            Toolkit.getEventQueue().postEvent(invocationEvent);
            aWTInvocationLock.wait();
        }
        object = invocationEvent.getThrowable();
        if (object != null) {
            throw new InvocationTargetException((Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup(boolean bl) {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.nextQueue != null) {
                this.nextQueue.wakeup(bl);
            } else if (this.dispatchThread != null) {
                this.notifyAll();
            } else if (!bl) {
                this.initDispatchThread();
            }
        }
    }
}

