/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.applet.AudioClip;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;

final class AppletAudioClip
implements AudioClip {
    private static Constructor acConstructor = null;
    private URL url = null;
    private AudioClip audioClip = null;
    private static Map audioClips = new HashMap();

    public AppletAudioClip() {
    }

    public AppletAudioClip(URL uRL) {
        this.url = uRL;
        try {
            InputStream inputStream = uRL.openStream();
            this.createAppletAudioClip(inputStream);
        }
        catch (IOException iOException) {
            Trace.println((String)("IOException creating AppletAudioClip" + iOException), (TraceLevel)TraceLevel.BASIC);
        }
    }

    public static synchronized AudioClip get(URL uRL) {
        AppletAudioClip.checkConnect(uRL);
        AudioClip audioClip = (AudioClip)audioClips.get(uRL);
        if (audioClip == null) {
            audioClip = new AppletAudioClip(uRL);
            audioClips.put(uRL, audioClip);
        }
        return audioClip;
    }

    void createAppletAudioClip(InputStream inputStream) throws IOException {
        if (acConstructor == null) {
            Trace.println((String)"Initializing AudioClip constructor.", (TraceLevel)TraceLevel.BASIC);
            try {
                acConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException, SecurityException, ClassNotFoundException {
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName("com.sun.media.sound.JavaSoundAudioClip", true, ClassLoader.getSystemClassLoader());
                            Trace.println((String)"Loaded JavaSoundAudioClip", (TraceLevel)TraceLevel.BASIC);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            clazz = Class.forName("sun.audio.SunAudioClip", true, null);
                            Trace.println((String)"Loaded SunAudioClip", (TraceLevel)TraceLevel.BASIC);
                        }
                        Class[] classArray = new Class[]{Class.forName("java.io.InputStream")};
                        return clazz.getConstructor(classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Trace.println((String)("Got a PrivilegedActionException: " + privilegedActionException.getException()), (TraceLevel)TraceLevel.BASIC);
                throw new IOException("Failed to get AudioClip constructor: " + privilegedActionException.getException());
            }
        }
        try {
            Object[] objectArray = new Object[]{inputStream};
            this.audioClip = (AudioClip)acConstructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new IOException("Failed to construct the AudioClip: " + exception);
        }
    }

    private static void checkConnect(URL uRL) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                Permission permission = uRL.openConnection().getPermission();
                if (permission != null) {
                    securityManager.checkPermission(permission);
                } else {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
            catch (IOException iOException) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
        }
    }

    public synchronized void play() {
        if (this.audioClip != null) {
            this.audioClip.play();
        }
    }

    public synchronized void loop() {
        if (this.audioClip != null) {
            this.audioClip.loop();
        }
    }

    public synchronized void stop() {
        if (this.audioClip != null) {
            this.audioClip.stop();
        }
    }
}

