/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private Map<String, Object> myRelId2ObjMap = new HashMap<String, Object>();
    private Map<String, String> myRelId2RelTypeMap = new HashMap<String, String>();
    private Map<ObjectName, String> myRelMBeanObjName2RelIdMap = new HashMap<ObjectName, String>();
    private Map<String, RelationType> myRelType2ObjMap = new HashMap<String, RelationType>();
    private Map<String, List<String>> myRelType2RelIdsMap = new HashMap<String, List<String>>();
    private Map<ObjectName, Map<String, List<String>>> myRefedMBeanObjName2RelIdsMap = new HashMap<ObjectName, Map<String, List<String>>>();
    private boolean myPurgeFlag = true;
    private Long myNtfSeqNbrCounter = new Long(0L);
    private ObjectName myObjName = null;
    private MBeanServer myMBeanServer = null;
    private MBeanServerNotificationFilter myUnregNtfFilter = null;
    private List<MBeanServerNotification> myUnregNtfList = new ArrayList<MBeanServerNotification>();
    private static String localClassName = "RelationService";

    public RelationService(boolean bl) {
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", null);
        }
        this.setPurgeFlag(bl);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    @Override
    public void isActive() throws RelationServiceNotRegisteredException {
        if (this.myMBeanServer == null) {
            String string = "Relation Service not registered in the MBean Server.";
            throw new RelationServiceNotRegisteredException(string);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.myMBeanServer = mBeanServer;
        this.myObjName = objectName;
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public boolean getPurgeFlag() {
        return this.myPurgeFlag;
    }

    @Override
    public void setPurgeFlag(boolean bl) {
        this.myPurgeFlag = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getNotificationSequenceNumber() {
        Long l = null;
        Long l2 = this.myNtfSeqNbrCounter;
        synchronized (l2) {
            l = new Long(this.myNtfSeqNbrCounter + 1L);
            this.myNtfSeqNbrCounter = new Long(l);
        }
        return l;
    }

    @Override
    public void createRelationType(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("createRelationType: entering", string);
        }
        RelationTypeSupport relationTypeSupport = new RelationTypeSupport(string, roleInfoArray);
        this.addRelationTypeInt(relationTypeSupport);
        if (this.isTraceOn()) {
            this.trace("createRelationType: exiting", null);
        }
    }

    @Override
    public void addRelationType(RelationType relationType) throws IllegalArgumentException, InvalidRelationTypeException {
        List<RoleInfo> list;
        if (relationType == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("addRelationType: entering", null);
        }
        if ((list = relationType.getRoleInfos()) == null) {
            String string = "No role info provided.";
            throw new InvalidRelationTypeException(string);
        }
        RoleInfo[] roleInfoArray = new RoleInfo[list.size()];
        int n = 0;
        Iterator<RoleInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            RoleInfo roleInfo;
            roleInfoArray[n] = roleInfo = iterator.next();
            ++n;
        }
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        this.addRelationTypeInt(relationType);
        if (this.isTraceOn()) {
            this.trace("addRelationType: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRelationTypeNames() {
        ArrayList<String> arrayList = null;
        Map<String, RelationType> map = this.myRelType2ObjMap;
        synchronized (map) {
            arrayList = new ArrayList<String>(this.myRelType2ObjMap.keySet());
        }
        return arrayList;
    }

    @Override
    public List<RoleInfo> getRoleInfos(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfos: entering", string);
        }
        RelationType relationType = this.getRelationType(string);
        if (this.isTraceOn()) {
            this.trace("getRoleInfos: exiting", null);
        }
        return relationType.getRoleInfos();
    }

    @Override
    public RoleInfo getRoleInfo(String string, String string2) throws IllegalArgumentException, RelationTypeNotFoundException, RoleInfoNotFoundException {
        Object object;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = "relationTypeName " + string + ", roleInfoName " + string2;
            this.trace("getRoleInfo: entering", (String)object);
        }
        object = this.getRelationType(string);
        RoleInfo roleInfo = object.getRoleInfo(string2);
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: exiting", null);
        }
        return roleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRelationType(String string) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationTypeNotFoundException {
        this.isActive();
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("removeRelationType: entering", string);
        }
        RelationType relationType = this.getRelationType(string);
        ArrayList<String> arrayList = null;
        Object object = this.myRelType2RelIdsMap;
        synchronized (object) {
            List<String> object2 = this.myRelType2RelIdsMap.get(string);
            if (object2 != null) {
                arrayList = new ArrayList<String>(object2);
            }
        }
        object = this.myRelType2ObjMap;
        synchronized (object) {
            this.myRelType2ObjMap.remove(string);
        }
        object = this.myRelType2RelIdsMap;
        synchronized (object) {
            this.myRelType2RelIdsMap.remove(string);
        }
        if (arrayList != null) {
            for (String string2 : arrayList) {
                try {
                    this.removeRelation(string2);
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("removeRelationType: exiting", null);
        }
    }

    @Override
    public void createRelation(String string, String string2, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        Object object;
        this.isActive();
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = new StringBuffer("relationId " + string + ", relationTypeName " + string2);
            if (roleList != null) {
                ((StringBuffer)object).append(", roleList " + roleList.toString());
            }
            this.trace("createRelation: entering", ((StringBuffer)object).toString());
        }
        object = new RelationSupport(string, this.myObjName, string2, roleList);
        this.addRelationInt(true, (RelationSupport)object, null, string, string2, roleList);
        if (this.isTraceOn()) {
            this.trace("createRelation: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRelation(ObjectName objectName) throws IllegalArgumentException, RelationServiceNotRegisteredException, NoSuchMethodException, InvalidRelationIdException, InstanceNotFoundException, InvalidRelationServiceException, RelationTypeNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("addRelation: entering", objectName.toString());
        }
        this.isActive();
        if (!this.myMBeanServer.isInstanceOf(objectName, "javax.management.relation.Relation")) {
            String string = "This MBean does not implement the Relation interface.";
            throw new NoSuchMethodException(string);
        }
        String string = null;
        try {
            string = (String)this.myMBeanServer.getAttribute(objectName, "RelationId");
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(attributeNotFoundException.getMessage());
        }
        if (string == null) {
            String string2 = "This MBean does not provide a relation id.";
            throw new InvalidRelationIdException(string2);
        }
        ObjectName objectName2 = null;
        try {
            objectName2 = (ObjectName)this.myMBeanServer.getAttribute(objectName, "RelationServiceName");
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(attributeNotFoundException.getMessage());
        }
        boolean bl = false;
        if (objectName2 == null) {
            bl = true;
        } else if (!objectName2.equals(this.myObjName)) {
            bl = true;
        }
        if (bl) {
            String string3 = "The Relation Service referenced in the MBean is not the current one.";
            throw new InvalidRelationServiceException(string3);
        }
        String string4 = null;
        try {
            string4 = (String)this.myMBeanServer.getAttribute(objectName, "RelationTypeName");
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(attributeNotFoundException.getMessage());
        }
        if (string4 == null) {
            String string5 = "No relation type provided.";
            throw new RelationTypeNotFoundException(string5);
        }
        RoleList roleList = null;
        try {
            roleList = (RoleList)this.myMBeanServer.invoke(objectName, "retrieveAllRoles", null, null);
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        this.addRelationInt(false, null, objectName, string, string4, roleList);
        Object object = this.myRelMBeanObjName2RelIdMap;
        synchronized (object) {
            this.myRelMBeanObjName2RelIdMap.put(objectName, string);
        }
        try {
            this.myMBeanServer.setAttribute(objectName, new Attribute("RelationServiceManagementFlag", Boolean.TRUE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new ArrayList();
        object.add(objectName);
        this.updateUnregistrationListener((List)object, null);
        if (this.isTraceOn()) {
            this.trace("addRelation: exiting", null);
        }
    }

    @Override
    public ObjectName isRelationMBean(String string) throws IllegalArgumentException, RelationNotFoundException {
        Object object;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("isRelationMBean", string);
        }
        if ((object = this.getRelation(string)) instanceof ObjectName) {
            return (ObjectName)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String isRelation(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("isRelation", objectName.toString());
        }
        String string = null;
        Map<ObjectName, String> map = this.myRelMBeanObjName2RelIdMap;
        synchronized (map) {
            String string2 = this.myRelMBeanObjName2RelIdMap.get(objectName);
            if (string2 != null) {
                string = string2;
            }
        }
        return string;
    }

    @Override
    public Boolean hasRelation(String string) throws IllegalArgumentException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("hasRelation", string);
        }
        try {
            Object object = this.getRelation(string);
            return true;
        }
        catch (RelationNotFoundException relationNotFoundException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRelationIds() {
        ArrayList<String> arrayList = null;
        Map<String, Object> map = this.myRelId2ObjMap;
        synchronized (map) {
            arrayList = new ArrayList<String>(this.myRelId2ObjMap.keySet());
        }
        return arrayList;
    }

    @Override
    public Integer checkRoleReading(String string, String string2) throws IllegalArgumentException, RelationTypeNotFoundException {
        Object object;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = "roleName " + string + ", relationTypeName " + string2;
            this.trace("checkRoleReading: entering", (String)object);
        }
        object = null;
        RelationType relationType = this.getRelationType(string2);
        try {
            RoleInfo roleInfo = relationType.getRoleInfo(string);
            object = this.checkRoleInt(1, string, null, roleInfo, false);
        }
        catch (RoleInfoNotFoundException roleInfoNotFoundException) {
            object = new Integer(1);
        }
        if (this.isTraceOn()) {
            this.trace("checkRoleReading: exiting", null);
        }
        return object;
    }

    @Override
    public Integer checkRoleWriting(Role role, String string, Boolean bl) throws IllegalArgumentException, RelationTypeNotFoundException {
        Object object;
        if (role == null || string == null || bl == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            object = new String("role " + role.toString() + ", relationTypeName " + string + ", initFlag " + bl);
            this.trace("checkRoleWriting: entering", (String)object);
        }
        object = this.getRelationType(string);
        String string3 = role.getRoleName();
        List<ObjectName> list = role.getRoleValue();
        boolean bl2 = true;
        if (bl.booleanValue()) {
            bl2 = false;
        }
        RoleInfo roleInfo = null;
        try {
            roleInfo = object.getRoleInfo(string3);
        }
        catch (RoleInfoNotFoundException roleInfoNotFoundException) {
            if (this.isTraceOn()) {
                this.trace("checkRoleWriting: exiting", null);
            }
            return new Integer(1);
        }
        Integer n = this.checkRoleInt(2, string3, list, roleInfo, bl2);
        if (this.isTraceOn()) {
            this.trace("checkRoleWriting: exiting", null);
        }
        return n;
    }

    @Override
    public void sendRelationCreationNotification(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("sendRelationCreationNotification: entering", string);
        }
        StringBuffer stringBuffer = new StringBuffer("Creation of relation ");
        stringBuffer.append(string);
        this.sendNotificationInt(1, stringBuffer.toString(), string, null, null, null, null);
        if (this.isTraceOn()) {
            this.trace("sendRelationCreationNotification: exiting", null);
        }
    }

    @Override
    public void sendRoleUpdateNotification(String string, Role role, List<ObjectName> list) throws IllegalArgumentException, RelationNotFoundException {
        String string2;
        if (string == null || role == null || list == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (!(list instanceof ArrayList)) {
            list = new ArrayList<ObjectName>(list);
        }
        if (this.isTraceOn()) {
            string2 = new String("relationId " + string + ", newRole " + role.toString() + ", oldValue " + list.toString());
            this.trace("sendRoleUpdateNotification: entering", string2);
        }
        string2 = role.getRoleName();
        List<ObjectName> list2 = role.getRoleValue();
        String string4 = Role.roleValueToString(list2);
        String string5 = Role.roleValueToString(list);
        StringBuffer stringBuffer = new StringBuffer("Value of role ");
        stringBuffer.append(string2);
        stringBuffer.append(" has changed\nOld value:\n");
        stringBuffer.append(string5);
        stringBuffer.append("\nNew value:\n");
        stringBuffer.append(string4);
        this.sendNotificationInt(2, stringBuffer.toString(), string, null, string2, list2, list);
        if (this.isTraceOn()) {
            this.trace("sendRoleUpdateNotification: exiting", null);
        }
    }

    @Override
    public void sendRelationRemovalNotification(String string, List<ObjectName> list) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer("relationId " + string);
            if (list != null) {
                stringBuffer.append(", unregMBeanList " + list.toString());
            }
            this.trace("sendRelationRemovalNotification: entering", stringBuffer.toString());
        }
        this.sendNotificationInt(3, "Removal of relation " + string, string, list, null, null, null);
        if (this.isTraceOn()) {
            this.trace("sendRelationRemovalNotification: exiting", null);
        }
    }

    @Override
    public void updateRoleMap(String string, Role role, List<ObjectName> list) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        boolean bl;
        Object object;
        if (string == null || role == null || list == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            object = new String("relationId " + string + ", newRole " + role.toString() + ", oldValue " + list.toString());
            this.trace("updateRoleMap: entering", (String)object);
        }
        this.isActive();
        object = this.getRelation(string);
        String string3 = role.getRoleName();
        List<ObjectName> list2 = role.getRoleValue();
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>(list);
        ArrayList<ObjectName> arrayList2 = new ArrayList<ObjectName>();
        for (ObjectName object2 : list2) {
            int objectName = arrayList.indexOf(object2);
            if (objectName == -1) {
                bl = this.addNewMBeanReference(object2, string, string3);
                if (!bl) continue;
                arrayList2.add(object2);
                continue;
            }
            arrayList.remove(objectName);
        }
        ArrayList arrayList3 = new ArrayList();
        for (ObjectName objectName : arrayList) {
            bl = this.removeMBeanReference(objectName, string, string3, false);
            if (!bl) continue;
            arrayList3.add(objectName);
        }
        this.updateUnregistrationListener(arrayList2, arrayList3);
        if (this.isTraceOn()) {
            this.trace("updateRoleMap: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRelation(String string) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        ArrayList<ObjectName> arrayList;
        Object object;
        this.isActive();
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("removeRelation: entering", string);
        }
        if ((object = this.getRelation(string)) instanceof ObjectName) {
            arrayList = new ArrayList<ObjectName>();
            arrayList.add((ObjectName)object);
            this.updateUnregistrationListener(null, arrayList);
        }
        this.sendRelationRemovalNotification(string, null);
        arrayList = new ArrayList();
        ArrayList<ObjectName> arrayList2 = new ArrayList<ObjectName>();
        Object object2 = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (object2) {
            for (ObjectName object3 : this.myRefedMBeanObjName2RelIdsMap.keySet()) {
                Map<String, List<String>> map = this.myRefedMBeanObjName2RelIdsMap.get(object3);
                if (map.containsKey(string)) {
                    map.remove(string);
                    arrayList.add(object3);
                }
                if (!map.isEmpty()) continue;
                arrayList2.add(object3);
            }
            for (ObjectName objectName : arrayList2) {
                this.myRefedMBeanObjName2RelIdsMap.remove(objectName);
            }
        }
        object2 = this.myRelId2ObjMap;
        synchronized (object2) {
            this.myRelId2ObjMap.remove(string);
        }
        if (object instanceof ObjectName) {
            object2 = this.myRelMBeanObjName2RelIdMap;
            synchronized (object2) {
                this.myRelMBeanObjName2RelIdMap.remove((ObjectName)object);
            }
        }
        object2 = null;
        Map<String, List<String>> map = this.myRelId2RelTypeMap;
        synchronized (map) {
            object2 = this.myRelId2RelTypeMap.get(string);
            this.myRelId2RelTypeMap.remove(string);
        }
        map = this.myRelType2RelIdsMap;
        synchronized (map) {
            List<String> list = this.myRelType2RelIdsMap.get(object2);
            if (list != null) {
                list.remove(string);
                if (list.isEmpty()) {
                    this.myRelType2RelIdsMap.remove(object2);
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("removeRelation: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeRelations() throws RelationServiceNotRegisteredException {
        Object object;
        ArrayList<MBeanServerNotification> arrayList;
        if (this.isTraceOn()) {
            this.trace("purgeRelations: entering", null);
        }
        this.isActive();
        List<MBeanServerNotification> list = this.myUnregNtfList;
        synchronized (list) {
            arrayList = new ArrayList<MBeanServerNotification>(this.myUnregNtfList);
            this.myUnregNtfList = new ArrayList<MBeanServerNotification>();
        }
        list = new ArrayList<MBeanServerNotification>();
        HashMap<ObjectName, Map<String, List<String>>> hashMap = new HashMap<ObjectName, Map<String, List<String>>>();
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            for (Serializable serializable : arrayList) {
                object = serializable.getMBeanName();
                list.add((MBeanServerNotification)object);
                Map<String, List<String>> map2 = this.myRefedMBeanObjName2RelIdsMap.get(object);
                hashMap.put((ObjectName)object, map2);
                this.myRefedMBeanObjName2RelIdsMap.remove(object);
            }
        }
        this.updateUnregistrationListener(null, list);
        for (MBeanServerNotification mBeanServerNotification : arrayList) {
            Serializable serializable;
            serializable = mBeanServerNotification.getMBeanName();
            object = (Map)hashMap.get(serializable);
            for (String string : object.keySet()) {
                List list2 = (List)object.get(string);
                try {
                    this.handleReferenceUnregistration(string, (ObjectName)serializable, list2);
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
                catch (RoleNotFoundException roleNotFoundException) {
                    throw new RuntimeException(roleNotFoundException.getMessage());
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("purgeRelations: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> findReferencingRelations(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        Object object;
        if (objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = new String("mbeanName " + objectName.toString() + ", relationTypeName " + string + ", roleName " + string2);
            this.trace("findReferencingRelations: entering", (String)object);
        }
        object = new HashMap();
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            Map<String, List<String>> map2 = this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (map2 != null) {
                Object object2;
                Object object3;
                Set<String> set = map2.keySet();
                ArrayList<Object> arrayList = null;
                if (string == null) {
                    arrayList = new ArrayList<String>(set);
                } else {
                    arrayList = new ArrayList();
                    for (String string4 : set) {
                        object3 = null;
                        object2 = this.myRelId2RelTypeMap;
                        synchronized (object2) {
                            object3 = this.myRelId2RelTypeMap.get(string4);
                        }
                        if (!((String)object3).equals(string)) continue;
                        arrayList.add(string4);
                    }
                }
                for (String string3 : arrayList) {
                    object3 = map2.get(string3);
                    if (string2 == null) {
                        object.put(string3, new ArrayList<String>((Collection<String>)object3));
                        continue;
                    }
                    if (!object3.contains(string2)) continue;
                    object2 = new ArrayList();
                    object2.add(string2);
                    object.put(string3, object2);
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("findReferencingRelations: exiting", null);
        }
        return object;
    }

    @Override
    public Map<ObjectName, List<String>> findAssociatedMBeans(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        Object object;
        if (objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = new String("mbeanName " + objectName.toString() + ", relationTypeName " + string + ", roleName " + string2);
            this.trace("findAssociatedMBeans: entering", (String)object);
        }
        object = this.findReferencingRelations(objectName, string, string2);
        HashMap<ObjectName, List<String>> hashMap = new HashMap<ObjectName, List<String>>();
        for (String string4 : object.keySet()) {
            Map<ObjectName, List<String>> map;
            try {
                map = this.getReferencedMBeans(string4);
            }
            catch (RelationNotFoundException relationNotFoundException) {
                throw new RuntimeException(relationNotFoundException.getMessage());
            }
            for (ObjectName objectName2 : map.keySet()) {
                if (objectName2.equals(objectName)) continue;
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(objectName2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string4);
                    hashMap.put(objectName2, arrayList);
                    continue;
                }
                arrayList.add(string4);
            }
        }
        if (this.isTraceOn()) {
            this.trace("findReferencingRelations: exiting", null);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findRelationsOfType(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        ArrayList<Object> arrayList;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("findRelationsOfType: entering", string);
        }
        RelationType relationType = this.getRelationType(string);
        Map<String, List<String>> map = this.myRelType2RelIdsMap;
        synchronized (map) {
            List<String> list = this.myRelType2RelIdsMap.get(string);
            arrayList = list == null ? new ArrayList() : new ArrayList<String>(list);
        }
        if (this.isTraceOn()) {
            this.trace("findRelationsOfType: exiting", null);
        }
        return arrayList;
    }

    @Override
    public List<ObjectName> getRole(String string, String string2) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        List list;
        Object object;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = "relationId " + string + ", roleName " + string2;
            this.trace("getRole: entering", (String)object);
        }
        this.isActive();
        object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            list = (ArrayList)((RelationSupport)object).getRoleInt(string2, true, this, false);
        } else {
            Object[] objectArray = new Object[]{string2};
            String[] stringArray = new String[]{"java.lang.String"};
            try {
                List list2 = (List)this.myMBeanServer.invoke((ObjectName)object, "getRole", objectArray, stringArray);
                list = list2 == null || list2 instanceof ArrayList ? list2 : new ArrayList(list2);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRole: exiting", null);
        }
        return list;
    }

    @Override
    public RoleResult getRoles(String string, String[] stringArray) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        if (string == null || stringArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRoles: entering", string);
        }
        this.isActive();
        Object object = this.getRelation(string);
        RoleResult roleResult = null;
        if (object instanceof RelationSupport) {
            roleResult = ((RelationSupport)object).getRolesInt(stringArray, true, this);
        } else {
            Object[] objectArray = new Object[]{stringArray};
            String[] stringArray2 = new String[1];
            try {
                stringArray2[0] = stringArray.getClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                roleResult = (RoleResult)this.myMBeanServer.invoke((ObjectName)object, "getRoles", objectArray, stringArray2);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                throw new RuntimeException(mBeanException.getTargetException().getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRoles: exiting", null);
        }
        return roleResult;
    }

    @Override
    public RoleResult getAllRoles(String string) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getAllRoles: entering", string);
        }
        Object object = this.getRelation(string);
        RoleResult roleResult = null;
        if (object instanceof RelationSupport) {
            roleResult = ((RelationSupport)object).getAllRolesInt(true, this);
        } else {
            try {
                roleResult = (RoleResult)this.myMBeanServer.getAttribute((ObjectName)object, "AllRoles");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getAllRoles: exiting", null);
        }
        return roleResult;
    }

    @Override
    public Integer getRoleCardinality(String string, String string2) throws IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        Object object;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = "relationId " + string + ", roleName " + string2;
            this.trace("getRoleCardinality: entering", (String)object);
        }
        object = this.getRelation(string);
        Integer n = null;
        if (object instanceof RelationSupport) {
            n = ((RelationSupport)object).getRoleCardinality(string2);
        } else {
            Object[] objectArray = new Object[]{string2};
            String[] stringArray = new String[]{"java.lang.String"};
            try {
                n = (Integer)this.myMBeanServer.invoke((ObjectName)object, "getRoleCardinality", objectArray, stringArray);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRoleCardinality: exiting", null);
        }
        return n;
    }

    @Override
    public void setRole(String string, Role role) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        Object object;
        if (string == null || role == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            object = new String("relationId " + string + ", role " + role.toString());
            this.trace("setRole: entering", (String)object);
        }
        this.isActive();
        object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            try {
                ((RelationSupport)object).setRoleInt(role, true, this, false);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
        }
        Object[] objectArray = new Object[]{role};
        String[] stringArray = new String[]{"javax.management.relation.Role"};
        try {
            this.myMBeanServer.setAttribute((ObjectName)object, new Attribute("Role", role));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException(instanceNotFoundException.getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RoleNotFoundException) {
                throw (RoleNotFoundException)exception;
            }
            if (exception instanceof InvalidRoleValueException) {
                throw (InvalidRoleValueException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(attributeNotFoundException.getMessage());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new RuntimeException(invalidAttributeValueException.getMessage());
        }
        if (this.isTraceOn()) {
            this.trace("setRole: exiting", null);
        }
    }

    @Override
    public RoleResult setRoles(String string, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        Object object;
        if (string == null || roleList == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            object = new String("relationId " + string + ", roleList " + roleList.toString());
            this.trace("setRoles: entering", (String)object);
        }
        this.isActive();
        object = this.getRelation(string);
        RoleResult roleResult = null;
        if (object instanceof RelationSupport) {
            try {
                roleResult = ((RelationSupport)object).setRolesInt(roleList, true, this);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
        }
        Object[] objectArray = new Object[]{roleList};
        String[] stringArray = new String[]{"javax.management.relation.RoleList"};
        try {
            roleResult = (RoleResult)this.myMBeanServer.invoke((ObjectName)object, "setRoles", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException(instanceNotFoundException.getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        if (this.isTraceOn()) {
            this.trace("setRoles: exiting", null);
        }
        return roleResult;
    }

    @Override
    public Map<ObjectName, List<String>> getReferencedMBeans(String string) throws IllegalArgumentException, RelationNotFoundException {
        Map map;
        Object object;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: entering", string);
        }
        if ((object = this.getRelation(string)) instanceof RelationSupport) {
            map = ((RelationSupport)object).getReferencedMBeans();
        } else {
            try {
                map = (Map)this.myMBeanServer.getAttribute((ObjectName)object, "ReferencedMBeans");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: exiting", null);
        }
        return map;
    }

    @Override
    public String getRelationTypeName(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRelationTypeName: entering", string);
        }
        Object object = this.getRelation(string);
        String string3 = null;
        if (object instanceof RelationSupport) {
            string3 = ((RelationSupport)object).getRelationTypeName();
        } else {
            try {
                string3 = (String)this.myMBeanServer.getAttribute((ObjectName)object, "RelationTypeName");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRelationTypeName: exiting", null);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object object) {
        if (notification == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("handleNotification: entering", notification.toString());
        }
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            String string = notification.getType();
            if (string.equals("JMX.mbean.unregistered")) {
                Object object2;
                ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
                boolean bl = false;
                Object object3 = this.myRefedMBeanObjName2RelIdsMap;
                synchronized (object3) {
                    if (this.myRefedMBeanObjName2RelIdsMap.containsKey(objectName)) {
                        object2 = this.myUnregNtfList;
                        synchronized (object2) {
                            this.myUnregNtfList.add(mBeanServerNotification);
                        }
                        bl = true;
                    }
                    if (bl && this.myPurgeFlag) {
                        try {
                            this.purgeRelations();
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.getMessage());
                        }
                    }
                }
                object3 = null;
                object2 = this.myRelMBeanObjName2RelIdMap;
                synchronized (object2) {
                    object3 = this.myRelMBeanObjName2RelIdMap.get(objectName);
                }
                if (object3 != null) {
                    try {
                        this.removeRelation((String)object3);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.getMessage());
                    }
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("handleNotification: exiting", null);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.isTraceOn()) {
            this.trace("getNotificationInfo: entering", null);
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        String string = "javax.management.relation.RelationNotification";
        String[] stringArray = new String[]{"jmx.relation.creation.basic", "jmx.relation.creation.mbean", "jmx.relation.update.basic", "jmx.relation.update.mbean", "jmx.relation.removal.basic", "jmx.relation.removal.mbean"};
        String string2 = "Sent when a relation is created, updated or deleted.";
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, string, string2);
        if (this.isTraceOn()) {
            this.trace("getNotificationInfo: exiting", null);
        }
        return new MBeanNotificationInfo[]{mBeanNotificationInfo};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelationTypeInt(RelationType relationType) throws IllegalArgumentException, InvalidRelationTypeException {
        Object object;
        if (relationType == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            this.debug("addRelationTypeInt: entering", null);
        }
        String string = relationType.getRelationTypeName();
        try {
            object = this.getRelationType(string);
            if (object != null) {
                String string2 = "There is already a relation type in the Relation Service with name ";
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append(string);
                throw new InvalidRelationTypeException(stringBuffer.toString());
            }
        }
        catch (RelationTypeNotFoundException relationTypeNotFoundException) {
            // empty catch block
        }
        object = this.myRelType2ObjMap;
        synchronized (object) {
            this.myRelType2ObjMap.put(string, relationType);
        }
        if (relationType instanceof RelationTypeSupport) {
            ((RelationTypeSupport)relationType).setRelationServiceFlag(true);
        }
        if (this.isDebugOn()) {
            this.debug("addRelationTypeInt: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationType getRelationType(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            this.debug("getRelationType: entering", string);
        }
        RelationType relationType = null;
        Object object = this.myRelType2ObjMap;
        synchronized (object) {
            relationType = this.myRelType2ObjMap.get(string);
        }
        if (relationType == null) {
            object = "No relation type created in the Relation Service with the name ";
            StringBuffer stringBuffer = new StringBuffer((String)object);
            stringBuffer.append(string);
            throw new RelationTypeNotFoundException(stringBuffer.toString());
        }
        if (this.isDebugOn()) {
            this.debug("getRelationType: exiting", null);
        }
        return relationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getRelation(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            this.debug("getRelation: entering", string);
        }
        Object object = null;
        Object object2 = this.myRelId2ObjMap;
        synchronized (object2) {
            object = this.myRelId2ObjMap.get(string);
        }
        if (object == null) {
            object2 = "No relation associated to relation id " + string;
            throw new RelationNotFoundException((String)object2);
        }
        if (this.isDebugOn()) {
            this.debug("getRelation: exiting", null);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addNewMBeanReference(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        if (objectName == null || string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            String string4 = new String("objectName " + objectName.toString() + ", relationId " + string + ", roleName " + string2);
            this.debug("addNewMBeanReference: entering", string4);
        }
        boolean bl = false;
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            Map<String, List<String>> map2 = this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (map2 == null) {
                bl = true;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                map2 = new HashMap<String, List<String>>();
                map2.put(string, arrayList);
                this.myRefedMBeanObjName2RelIdsMap.put(objectName, map2);
            } else {
                List<String> list = map2.get(string);
                if (list == null) {
                    list = new ArrayList<String>();
                    list.add(string2);
                    map2.put(string, list);
                } else {
                    list.add(string2);
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("addNewMBeanReference: exiting", null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMBeanReference(ObjectName objectName, String string, String string2, boolean bl) throws IllegalArgumentException {
        if (objectName == null || string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            String string4 = new String("objectName " + objectName.toString() + ", relationId " + string + ", roleName " + string2 + ", allRolesFlag " + bl);
            this.debug("removeMBeanReference: entering", string4);
        }
        boolean bl2 = false;
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            int n;
            HashMap hashMap = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (hashMap == null) {
                if (this.isDebugOn()) {
                    this.debug("removeMBeanReference: exiting", null);
                }
                return true;
            }
            ArrayList arrayList = new ArrayList();
            if (!bl && (n = (arrayList = (ArrayList)hashMap.get(string)).indexOf(string2)) != -1) {
                arrayList.remove(n);
            }
            if (arrayList.isEmpty() || bl) {
                hashMap.remove(string);
            }
            if (hashMap.isEmpty()) {
                this.myRefedMBeanObjName2RelIdsMap.remove(objectName);
                bl2 = true;
            }
        }
        if (this.isDebugOn()) {
            this.debug("removeMBeanReference: exiting", null);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnregistrationListener(List list, List list2) throws RelationServiceNotRegisteredException {
        if (list != null && list2 != null && list.isEmpty() && list2.isEmpty()) {
            return;
        }
        if (this.isDebugOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (list != null) {
                stringBuffer.append("newRefList " + list.toString());
            }
            if (list2 != null) {
                stringBuffer.append(", obsoleteRefList" + list2.toString());
            }
            this.debug("updateUnregistrationListener: entering", stringBuffer.toString());
        }
        this.isActive();
        if (list != null || list2 != null) {
            boolean bl = false;
            if (this.myUnregNtfFilter == null) {
                this.myUnregNtfFilter = new MBeanServerNotificationFilter();
                bl = true;
            }
            MBeanServerNotificationFilter mBeanServerNotificationFilter = this.myUnregNtfFilter;
            synchronized (mBeanServerNotificationFilter) {
                if (list != null) {
                    for (ObjectName objectName : list) {
                        this.myUnregNtfFilter.enableObjectName(objectName);
                    }
                }
                if (list2 != null) {
                    for (ObjectName objectName : list2) {
                        this.myUnregNtfFilter.disableObjectName(objectName);
                    }
                }
                if (bl) {
                    try {
                        this.myMBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, (NotificationFilter)this.myUnregNtfFilter, null);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
                    }
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("updateUnregistrationListener: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelationInt(boolean bl, RelationSupport relationSupport, ObjectName objectName, String string, String string2, RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        Object object;
        if (string == null || string2 == null || bl && (relationSupport == null || objectName != null) || !bl && (objectName == null || relationSupport != null)) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            object = new StringBuffer("relationBaseFlag " + bl + ", relationId " + string + ", relationTypeName " + string2);
            if (objectName != null) {
                ((StringBuffer)object).append(",  relationObjName " + objectName.toString());
            }
            if (roleList != null) {
                ((StringBuffer)object).append(", roleList " + roleList.toString());
            }
            this.debug("addRelationInt: entering", ((StringBuffer)object).toString());
        }
        this.isActive();
        try {
            object = this.getRelation(string);
            if (object != null) {
                String string4 = "There is already a relation with id ";
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append(string);
                throw new InvalidRelationIdException(stringBuffer.toString());
            }
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
        object = this.getRelationType(string2);
        ArrayList arrayList = (ArrayList)((ArrayList)object.getRoleInfos()).clone();
        if (roleList != null) {
            for (Serializable serializable : roleList) {
                String string5 = ((Role)serializable).getRoleName();
                ArrayList arrayList2 = (ArrayList)((Role)serializable).getRoleValue();
                RoleInfo roleInfo = null;
                try {
                    roleInfo = object.getRoleInfo(string5);
                }
                catch (RoleInfoNotFoundException roleInfoNotFoundException) {
                    throw new RoleNotFoundException(roleInfoNotFoundException.getMessage());
                }
                Integer n = this.checkRoleInt(2, string5, arrayList2, roleInfo, false);
                int n2 = n;
                if (n2 != 0) {
                    RelationService.throwRoleProblemException(n2, string5);
                }
                int n3 = arrayList.indexOf(roleInfo);
                arrayList.remove(n3);
            }
        }
        this.initializeMissingRoles(bl, relationSupport, objectName, string, string2, arrayList);
        Object object2 = this.myRelId2ObjMap;
        synchronized (object2) {
            if (bl) {
                this.myRelId2ObjMap.put(string, relationSupport);
            } else {
                this.myRelId2ObjMap.put(string, objectName);
            }
        }
        object2 = this.myRelId2RelTypeMap;
        synchronized (object2) {
            this.myRelId2RelTypeMap.put(string, string2);
        }
        object2 = this.myRelType2RelIdsMap;
        synchronized (object2) {
            Serializable serializable;
            serializable = this.myRelType2RelIdsMap.get(string2);
            boolean bl2 = false;
            if (serializable == null) {
                bl2 = true;
                serializable = new ArrayList<String>();
            }
            serializable.add(string);
            if (bl2) {
                this.myRelType2RelIdsMap.put(string2, (List<String>)((Object)serializable));
            }
        }
        for (Serializable serializable : roleList) {
            ArrayList<ObjectName> arrayList3 = new ArrayList<ObjectName>();
            try {
                this.updateRoleMap(string, (Role)serializable, (List<ObjectName>)arrayList3);
            }
            catch (RelationNotFoundException relationNotFoundException) {}
        }
        try {
            this.sendRelationCreationNotification(string);
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
        if (this.isDebugOn()) {
            this.debug("addRelationInt: exiting", null);
        }
    }

    private Integer checkRoleInt(int n, String string, List list, RoleInfo roleInfo, boolean bl) throws IllegalArgumentException {
        int n2;
        CharSequence charSequence;
        if (string == null || roleInfo == null || n == 2 && list == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            charSequence = new StringBuffer("chkType " + n + ", roleName " + string + ", roleInfo " + roleInfo.toString() + ", writeChkFlag " + bl);
            if (list != null) {
                ((StringBuffer)charSequence).append(", roleValue " + list.toString());
            }
            this.debug("checkRoleInt: entering", ((StringBuffer)charSequence).toString());
        }
        if (!string.equals(charSequence = roleInfo.getName())) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(1);
        }
        if (n == 1) {
            boolean bl2 = roleInfo.isReadable();
            if (!bl2) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(2);
            }
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(0);
        }
        if (bl && (n2 = roleInfo.isWritable()) == 0) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(3);
        }
        n2 = list.size();
        boolean bl3 = roleInfo.checkMinDegree(n2);
        if (!bl3) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(4);
        }
        boolean bl4 = roleInfo.checkMaxDegree(n2);
        if (!bl4) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(5);
        }
        String string3 = roleInfo.getRefMBeanClassName();
        for (ObjectName objectName : list) {
            if (objectName == null) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(7);
            }
            try {
                boolean bl5 = this.myMBeanServer.isInstanceOf(objectName, string3);
                if (bl5) continue;
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(6);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(7);
            }
        }
        if (this.isDebugOn()) {
            this.debug("checkRoleInt: exiting", null);
        }
        return new Integer(0);
    }

    private void initializeMissingRoles(boolean bl, RelationSupport relationSupport, ObjectName objectName, String string, String string2, List list) throws IllegalArgumentException, RelationServiceNotRegisteredException, InvalidRoleValueException {
        if (bl && (relationSupport == null || objectName != null) || !bl && (objectName == null || relationSupport != null) || string == null || string2 == null || list == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            StringBuffer stringBuffer = new StringBuffer("relationBaseFlag " + bl + ", relationId " + string + ", relationTypeName " + string2 + ", roleInfoList " + list);
            if (objectName != null) {
                stringBuffer.append(objectName.toString());
            }
            this.debug("initializeMissingRoles: entering", stringBuffer.toString());
        }
        this.isActive();
        for (RoleInfo roleInfo : list) {
            String string4 = roleInfo.getName();
            ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
            Role role = new Role(string4, arrayList);
            if (bl) {
                try {
                    relationSupport.setRoleInt(role, true, this, false);
                    continue;
                }
                catch (RoleNotFoundException roleNotFoundException) {
                    throw new RuntimeException(roleNotFoundException.getMessage());
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
                catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                    throw new RuntimeException(relationTypeNotFoundException.getMessage());
                }
            }
            Object[] objectArray = new Object[]{role};
            String[] stringArray = new String[]{"javax.management.relation.Role"};
            try {
                this.myMBeanServer.setAttribute(objectName, new Attribute("Role", role));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof InvalidRoleValueException) {
                    throw (InvalidRoleValueException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                throw new RuntimeException(attributeNotFoundException.getMessage());
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new RuntimeException(invalidAttributeValueException.getMessage());
            }
        }
        if (this.isDebugOn()) {
            this.debug("initializeMissingRoles: exiting", null);
        }
    }

    static void throwRoleProblemException(int n, String string) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        int n2 = 0;
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = " does not exist in relation.";
                n2 = 1;
                break;
            }
            case 2: {
                string3 = " is not readable.";
                n2 = 1;
                break;
            }
            case 3: {
                string3 = " is not writable.";
                n2 = 1;
                break;
            }
            case 4: {
                string3 = " has a number of MBean references less than the expected minimum degree.";
                n2 = 2;
                break;
            }
            case 5: {
                string3 = " has a number of MBean references greater than the expected maximum degree.";
                n2 = 2;
                break;
            }
            case 6: {
                string3 = " has an MBean reference to an MBean not of the expected class of references for that role.";
                n2 = 2;
                break;
            }
            case 7: {
                string3 = " has a reference to null or to an MBean not registered.";
                n2 = 2;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        if (n2 == 1) {
            throw new RoleNotFoundException(string4);
        }
        if (n2 == 2) {
            throw new InvalidRoleValueException(string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotificationInt(int n, String string, String string2, List<ObjectName> list, String string3, List<ObjectName> list2, List<ObjectName> list3) throws IllegalArgumentException, RelationNotFoundException {
        CharSequence charSequence;
        if (string == null || string2 == null || n != 3 && list != null || n == 2 && (string3 == null || list2 == null || list3 == null)) {
            String string4 = "Invalid parameter.";
            throw new IllegalArgumentException(string4);
        }
        if (this.isDebugOn()) {
            charSequence = new StringBuffer("intNtfType " + n + ", message " + string + ", relationId " + string2);
            if (list != null) {
                ((StringBuffer)charSequence).append(", unregMBeanList " + list.toString());
            }
            if (string3 != null) {
                ((StringBuffer)charSequence).append(", roleName " + string3);
            }
            if (list2 != null) {
                ((StringBuffer)charSequence).append(", roleNewValue " + list2.toString());
            }
            if (list3 != null) {
                ((StringBuffer)charSequence).append(", oldValue " + list3.toString());
            }
            this.debug("sendNotificationInt: entering", ((StringBuffer)charSequence).toString());
        }
        charSequence = null;
        Object object = this.myRelId2RelTypeMap;
        synchronized (object) {
            charSequence = this.myRelId2RelTypeMap.get(string2);
        }
        object = this.isRelationMBean(string2);
        String string5 = null;
        if (object != null) {
            switch (n) {
                case 1: {
                    string5 = "jmx.relation.creation.mbean";
                    break;
                }
                case 2: {
                    string5 = "jmx.relation.update.mbean";
                    break;
                }
                case 3: {
                    string5 = "jmx.relation.removal.mbean";
                }
            }
        } else {
            switch (n) {
                case 1: {
                    string5 = "jmx.relation.creation.basic";
                    break;
                }
                case 2: {
                    string5 = "jmx.relation.update.basic";
                    break;
                }
                case 3: {
                    string5 = "jmx.relation.removal.basic";
                }
            }
        }
        Long l = this.getNotificationSequenceNumber();
        Date date = new Date();
        long l2 = date.getTime();
        RelationNotification relationNotification = null;
        if (string5.equals("jmx.relation.creation.basic") || string5.equals("jmx.relation.creation.mbean") || string5.equals("jmx.relation.removal.basic") || string5.equals("jmx.relation.removal.mbean")) {
            relationNotification = new RelationNotification(string5, this, l, l2, string, string2, (String)charSequence, (ObjectName)object, list);
        } else if (string5.equals("jmx.relation.update.basic") || string5.equals("jmx.relation.update.mbean")) {
            relationNotification = new RelationNotification(string5, this, l, l2, string, string2, (String)charSequence, (ObjectName)object, string3, list2, list3);
        }
        this.sendNotification(relationNotification);
        if (this.isDebugOn()) {
            this.debug("sendNotificationInt: exiting", null);
        }
    }

    private void handleReferenceUnregistration(String string, ObjectName objectName, List list) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException {
        String string2;
        if (string == null || list == null || objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            string2 = new String("relationId " + string + ", roleNameList " + list.toString() + "objectName " + objectName.toString());
            this.debug("handleReferenceUnregistration: entering", string2);
        }
        this.isActive();
        string2 = this.getRelationTypeName(string);
        Object object = this.getRelation(string);
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !bl) {
            String string4 = (String)iterator.next();
            int n = this.getRoleCardinality(string, string4);
            int n2 = n - 1;
            RoleInfo roleInfo = null;
            try {
                roleInfo = this.getRoleInfo(string2, string4);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
            catch (RoleInfoNotFoundException roleInfoNotFoundException) {
                throw new RuntimeException(roleInfoNotFoundException.getMessage());
            }
            boolean bl2 = roleInfo.checkMinDegree(n2);
            if (bl2) continue;
            bl = true;
        }
        if (bl) {
            this.removeRelation(string);
        } else {
            for (String string4 : list) {
                if (object instanceof RelationSupport) {
                    try {
                        ((RelationSupport)object).handleMBeanUnregistrationInt(objectName, string4, true, this);
                        continue;
                    }
                    catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                        throw new RuntimeException(relationTypeNotFoundException.getMessage());
                    }
                    catch (InvalidRoleValueException invalidRoleValueException) {
                        throw new RuntimeException(invalidRoleValueException.getMessage());
                    }
                }
                Object[] objectArray = new Object[]{objectName, string4};
                String[] stringArray = new String[]{"javax.management.ObjectName", "java.lang.String"};
                try {
                    this.myMBeanServer.invoke((ObjectName)object, "handleMBeanUnregistration", objectArray, stringArray);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    throw new RuntimeException(instanceNotFoundException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    throw new RuntimeException(reflectionException.getMessage());
                }
                catch (MBeanException mBeanException) {
                    Exception exception = mBeanException.getTargetException();
                    throw new RuntimeException(exception.getMessage());
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("handleReferenceUnregistration: exiting", null);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    private void trace(String string, String string2) {
        Trace.send(1, 64, localClassName, string, string2);
        Trace.send(1, 64, "", "", "\n");
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    private void debug(String string, String string2) {
        Trace.send(2, 64, localClassName, string, string2);
        Trace.send(2, 64, "", "", "\n");
    }
}

