/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBuffer;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LongBuffer
extends Buffer
implements Comparable<LongBuffer> {
    final long[] hb;
    final int offset;
    boolean isReadOnly;

    LongBuffer(int n, int n2, int n3, int n4, long[] lArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = lArray;
        this.offset = n5;
    }

    LongBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    public static LongBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapLongBuffer(n, n);
    }

    public static LongBuffer wrap(long[] lArray, int n, int n2) {
        try {
            return new HeapLongBuffer(lArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static LongBuffer wrap(long[] lArray) {
        return LongBuffer.wrap(lArray, 0, lArray.length);
    }

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public LongBuffer get(long[] lArray, int n, int n2) {
        LongBuffer.checkBounds(n, n2, lArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            lArray[i] = this.get();
        }
        return this;
    }

    public LongBuffer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = longBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(longBuffer.get());
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n, int n2) {
        LongBuffer.checkBounds(n, n2, lArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(lArray[i]);
        }
        return this;
    }

    public final LongBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final long[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract LongBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + (int)this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LongBuffer)) {
            return false;
        }
        LongBuffer longBuffer = (LongBuffer)object;
        if (this.remaining() != longBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = longBuffer.limit() - 1;
        while (n2 >= n) {
            long l;
            long l2 = this.get(n2);
            if (l2 != (l = longBuffer.get(n3)) && (l2 == l2 || l == l)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    @Override
    public int compareTo(LongBuffer longBuffer) {
        int n = this.position() + Math.min(this.remaining(), longBuffer.remaining());
        int n2 = this.position();
        int n3 = longBuffer.position();
        while (n2 < n) {
            long l;
            long l2 = this.get(n2);
            if (l2 != (l = longBuffer.get(n3)) && (l2 == l2 || l == l)) {
                if (l2 < l) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - longBuffer.remaining();
    }

    public abstract ByteOrder order();
}

