/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile
extends JarFile {
    private Reference signersRef;
    private Reference signerMapRef = null;
    private boolean hasStrictSingleSigning;
    private Reference manRef = null;
    private Reference codeSourcesRef;
    private Reference codeSourceCacheRef = null;
    private String resourceURL;
    private File indexFile;
    private int[] emptySignerIndices = new int[0];
    private static Enumeration emptyEnumeration = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private static Iterator emptyIterator = Collections.EMPTY_MAP.keySet().iterator();
    static /* synthetic */ Class class$java$util$jar$Manifest;
    static /* synthetic */ Class class$java$util$jar$Attributes;

    public String getName() {
        String string = super.getName();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return string;
        }
        try {
            securityManager.checkPermission(new RuntimePermission("accessDeploymentCache"));
            return string;
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new CachedJarFile(new File(super.getName()), this.signersRef, this.signerMapRef, this.hasStrictSingleSigning, this.manRef, this.codeSourcesRef, this.codeSourceCacheRef, this.resourceURL, this.indexFile);
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            throw new CloneNotSupportedException();
        }
    }

    private CachedJarFile(File file, Reference reference, Reference reference2, boolean bl, Reference reference3, Reference reference4, Reference reference5, String string, File file2) throws IOException {
        super(file, false);
        this.signersRef = reference;
        this.signerMapRef = reference2;
        this.hasStrictSingleSigning = bl;
        this.manRef = reference3;
        this.codeSourcesRef = reference4;
        this.codeSourceCacheRef = reference5;
        this.resourceURL = string;
        this.indexFile = file2;
        CachedJarFile.ensureAncestorKnowsAboutManifest(this);
        MemoryCache.addResourceReference(this, string);
    }

    static void ensureAncestorKnowsAboutManifest(final JarFile jarFile) throws IOException {
        if (!Config.isJavaVersionAtLeast16()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        try {
                            Field field = (class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedJarFile.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest).getDeclaredField("manLoaded");
                            if (field != null) {
                                field.setAccessible(true);
                                field.setBoolean(jarFile, true);
                                return null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    protected CachedJarFile(CacheEntry cacheEntry) throws IOException {
        super(new File(cacheEntry.getResourceFilename()), false);
        this.resourceURL = cacheEntry.getURL();
        this.signersRef = new SoftReference<Object>(null);
        this.signerMapRef = new SoftReference<Object>(null);
        this.hasStrictSingleSigning = false;
        this.manRef = new SoftReference<Object>(null);
        this.codeSourcesRef = new SoftReference<Object>(null);
        this.codeSourceCacheRef = new SoftReference<Object>(null);
        this.indexFile = cacheEntry.getIndexFile();
        CachedJarFile.ensureAncestorKnowsAboutManifest(this);
        MemoryCache.addResourceReference(this, this.resourceURL);
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                try {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    return new JarFileEntry(zipEntry);
                }
                catch (InternalError internalError) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    public Manifest getManifest() throws IOException {
        if (this.manRef == null) {
            return null;
        }
        Manifest manifest = (Manifest)this.manRef.get();
        if (manifest == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                manifest = cacheEntry.getManifest();
            } else {
                Trace.print("Warning: NULL cache entry for loaded resource!");
            }
            this.manRef = manifest != null ? new SoftReference<Manifest>(manifest) : null;
        }
        return manifest;
    }

    private synchronized CacheEntry getCacheEntry() {
        if (this.resourceURL == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL);
        if (cacheEntry == null || !this.indexFile.equals(cacheEntry.getIndexFile())) {
            Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            if (cacheEntry != null) {
                Trace.println("CachedJarFile getCacheEntry " + this.indexFile + " != " + cacheEntry.getIndexFile() + " for " + this.resourceURL);
            }
            try {
                cacheEntry = Cache.getCacheEntryFromFile(this.indexFile);
                if (cacheEntry == null) {
                    Trace.println("getCacheEntry failed for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
                }
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
            }
        }
        return cacheEntry;
    }

    private Map getSignerMap() {
        if (this.signerMapRef == null) {
            return null;
        }
        Map map = (Map)this.signerMapRef.get();
        if (map == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                map = cacheEntry.getSignerMap();
                if (map != null) {
                    this.signerMapRef = new SoftReference<Map>(map);
                    if (!map.isEmpty()) {
                        this.hasStrictSingleSigning = cacheEntry.hasStrictSingleSigning();
                    }
                } else {
                    this.signerMapRef = null;
                }
            } else {
                Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            }
        }
        return map;
    }

    private CodeSigner[] getSigners() {
        if (this.signersRef == null) {
            return null;
        }
        CodeSigner[] codeSignerArray = (CodeSigner[])this.signersRef.get();
        if (codeSignerArray == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                codeSignerArray = cacheEntry.getCodeSigners();
                this.signersRef = codeSignerArray != null ? new SoftReference<CodeSigner[]>(codeSignerArray) : null;
            } else {
                Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            }
        }
        return codeSignerArray;
    }

    private static void replaceMapFieldWithImmutableMap(Class clazz, Object object, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            Map map = (Map)field.get(object);
            if (map != null) {
                map = Collections.unmodifiableMap(map);
                field.set(object, map);
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    private static Map makeAttributesImmutable(Attributes attributes) {
        Iterator<Object> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = attributes.get(object);
            if (!(object2 instanceof Attributes)) continue;
            CachedJarFile.makeAttributesImmutable((Attributes)object2);
        }
        CachedJarFile.replaceMapFieldWithImmutableMap(class$java$util$jar$Attributes == null ? (class$java$util$jar$Attributes = CachedJarFile.class$("java.util.jar.Attributes")) : class$java$util$jar$Attributes, attributes, "map");
        return attributes;
    }

    static void makeManifestImmutable(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        CachedJarFile.makeAttributesImmutable(attributes);
        CachedJarFile.replaceMapFieldWithImmutableMap(class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedJarFile.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest, manifest, "entries");
    }

    private int[] findMatchingSignerIndices(CodeSource codeSource) {
        Map map = this.getCodeSourceCache();
        if (map == null) {
            return this.emptySignerIndices;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(codeSource)) continue;
            return (int[])entry.getKey();
        }
        if (codeSource.getCodeSigners() == null) {
            return this.emptySignerIndices;
        }
        return null;
    }

    Enumeration entryNames(CodeSource[] codeSourceArray) {
        Object object;
        boolean bl = false;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(codeSourceArray.length);
        for (int i = 0; i < codeSourceArray.length; ++i) {
            object = this.findMatchingSignerIndices(codeSourceArray[i]);
            if (object == null) continue;
            if (((int[])object).length > 0) {
                arrayList.add((int[])object);
                continue;
            }
            bl = true;
        }
        Map map = this.getSignerMap();
        if (map != null && !map.isEmpty() && this.hasStrictSingleSigning && !arrayList.isEmpty()) {
            map = null;
            bl = true;
            arrayList.clear();
        }
        object = arrayList;
        Map map2 = map;
        final Iterator iterator = map2 != null ? map2.keySet().iterator() : emptyIterator;
        Enumeration enumeration = bl ? this.unsignedEntryNames(map2) : emptyEnumeration;
        return new Enumeration((List)object, map2, enumeration){
            String name;
            private final /* synthetic */ List val$signersReq;
            private final /* synthetic */ Map val$signerMap;
            private final /* synthetic */ Enumeration val$enum2;
            {
                this.val$signersReq = list;
                this.val$signerMap = map;
                this.val$enum2 = enumeration;
            }

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (this.val$signersReq.contains((int[])this.val$signerMap.get(string))) {
                        this.name = string;
                        return true;
                    }
                    Trace.println("entryNames checking signer failed for " + string, TraceLevel.CACHE);
                }
                if (this.val$enum2.hasMoreElements()) {
                    this.name = (String)this.val$enum2.nextElement();
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Enumeration unsignedEntryNames(final Map map) {
        final Enumeration enumeration = this.entries();
        return new Enumeration(){
            String name;

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (zipEntry.isDirectory() || CacheEntry.isSigningRelated(string) || map != null && map.get(string) != null) continue;
                    this.name = string;
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    CodeSource[] getCodeSources(URL uRL) {
        if (this.codeSourcesRef == null) {
            return null;
        }
        CodeSource[] codeSourceArray = (CodeSource[])this.codeSourcesRef.get();
        if (codeSourceArray == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                codeSourceArray = cacheEntry.getCodeSources(uRL);
                this.codeSourcesRef = codeSourceArray != null ? new SoftReference<CodeSource[]>(codeSourceArray) : null;
            } else {
                Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            }
        }
        return codeSourceArray;
    }

    Map getCodeSourceCache() {
        if (this.codeSourceCacheRef == null) {
            return null;
        }
        Map map = (Map)this.codeSourceCacheRef.get();
        if (map == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                map = cacheEntry.getCodeSourceCache();
                this.codeSourceCacheRef = map != null ? new SoftReference<Map>(map) : null;
            } else {
                Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            }
        }
        return map;
    }

    CodeSource getCodeSource(URL uRL, String string) {
        Map map;
        Map map2 = this.getSignerMap();
        int[] nArray = null;
        nArray = map2 == null || map2.isEmpty() ? null : (this.hasStrictSingleSigning ? (!CacheEntry.isSigningRelated(string) && !string.endsWith("/") ? (int[])map2.get(null) : null) : (int[])map2.get(string));
        if (nArray != null && (map = this.getCodeSourceCache()) != null) {
            return (CodeSource)map.get(nArray);
        }
        return CacheEntry.getUnsignedCS(uRL);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = CachedJarFile.this.getManifest();
            if (manifest != null) {
                Attributes attributes = manifest.getAttributes(this.getName());
                return attributes;
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray = null;
            int[] nArray = this.getSignerIndices();
            CodeSigner[] codeSignerArray = CachedJarFile.this.getSigners();
            if (codeSignerArray != null && nArray != null) {
                ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.addAll(codeSignerArray[nArray[i]].getSignerCertPath().getCertificates());
                }
                return arrayList.toArray(new Certificate[arrayList.size()]);
            }
            return certificateArray;
        }

        public CodeSigner[] getCodeSigners() {
            CodeSigner[] codeSignerArray = null;
            int[] nArray = this.getSignerIndices();
            CodeSigner[] codeSignerArray2 = CachedJarFile.this.getSigners();
            if (codeSignerArray2 != null && nArray != null) {
                codeSignerArray = new CodeSigner[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    if (codeSignerArray2 == null) continue;
                    codeSignerArray[i] = codeSignerArray2[nArray[i]];
                }
            }
            return codeSignerArray;
        }

        private int[] getSignerIndices() {
            Map map = CachedJarFile.this.getSignerMap();
            String string = this.getName();
            if (map == null || map.isEmpty()) {
                return null;
            }
            if (CachedJarFile.this.hasStrictSingleSigning) {
                if (!CacheEntry.isSigningRelated(string) && !string.endsWith("/")) {
                    return (int[])map.get(null);
                }
                return null;
            }
            return (int[])map.get(string);
        }
    }
}

