/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSToken;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;

abstract class MessageToken_v2
extends Krb5Token {
    private static final int TOKEN_ID_POS = 0;
    private static final int TOKEN_FLAG_POS = 2;
    private static final int TOKEN_EC_POS = 4;
    private static final int TOKEN_RRC_POS = 6;
    static final int TOKEN_HEADER_SIZE = 16;
    private int tokenId = 0;
    private int seqNumber;
    private int ec = 0;
    private int rrc = 0;
    private boolean confState = true;
    private boolean initiator = true;
    byte[] confounder = null;
    byte[] checksum = null;
    private int key_usage = 0;
    private byte[] seqNumberData = null;
    private MessageTokenHeader tokenHeader = null;
    CipherHelper cipherHelper = null;
    static final int KG_USAGE_ACCEPTOR_SEAL = 22;
    static final int KG_USAGE_ACCEPTOR_SIGN = 23;
    static final int KG_USAGE_INITIATOR_SEAL = 24;
    static final int KG_USAGE_INITIATOR_SIGN = 25;
    private static final int FLAG_SENDER_IS_ACCEPTOR = 1;
    private static final int FLAG_WRAP_CONFIDENTIAL = 2;
    private static final int FLAG_ACCEPTOR_SUBKEY = 4;
    private static final int FILLER = 255;

    MessageToken_v2(int n, Krb5Context krb5Context, byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        this(n, krb5Context, new ByteArrayInputStream(byArray, n2, n3), messageProp);
    }

    MessageToken_v2(int n, Krb5Context krb5Context, InputStream inputStream, MessageProp messageProp) throws GSSException {
        this.init(n, krb5Context);
        try {
            if (!this.confState) {
                messageProp.setPrivacy(false);
            }
            this.tokenHeader = new MessageTokenHeader(inputStream, messageProp, n);
            if (n == 1284) {
                this.key_usage = !this.initiator ? 24 : 22;
            } else if (n == 1028) {
                this.key_usage = !this.initiator ? 25 : 23;
            }
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2];
            MessageToken_v2.readFully(inputStream, byArray);
            this.checksum = new byte[this.cipherHelper.getChecksumLength()];
            System.arraycopy(byArray, n2 - this.cipherHelper.getChecksumLength(), this.checksum, 0, this.cipherHelper.getChecksumLength());
            if (!messageProp.getPrivacy() && n == 1284 && this.checksum.length != this.ec) {
                throw new GSSException(10, -1, MessageToken_v2.getTokenName(n) + ":" + "EC incorrect!");
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, MessageToken_v2.getTokenName(n) + ":" + iOException.getMessage());
        }
    }

    public final int getTokenId() {
        return this.tokenId;
    }

    public final int getKeyUsage() {
        return this.key_usage;
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public void genSignAndSeqNumber(MessageProp messageProp, byte[] byArray, int n, int n2) throws GSSException {
        int n3 = messageProp.getQOP();
        if (n3 != 0) {
            n3 = 0;
            messageProp.setQOP(n3);
        }
        if (!this.confState) {
            messageProp.setPrivacy(false);
        }
        this.tokenHeader = new MessageTokenHeader(this.tokenId, messageProp.getPrivacy(), true);
        if (this.tokenId == 1284) {
            this.key_usage = this.initiator ? 24 : 22;
        } else if (this.tokenId == 1028) {
            int n4 = this.key_usage = this.initiator ? 25 : 23;
        }
        if (this.tokenId == 1028 || !messageProp.getPrivacy() && this.tokenId == 1284) {
            this.checksum = this.getChecksum(byArray, n, n2);
        }
        if (!messageProp.getPrivacy() && this.tokenId == 1284) {
            byte[] byArray2 = this.tokenHeader.getBytes();
            byArray2[4] = (byte)(this.checksum.length >>> 8);
            byArray2[5] = (byte)this.checksum.length;
        }
    }

    public final boolean verifySign(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = this.getChecksum(byArray, n, n2);
        return MessageDigest.isEqual(this.checksum, byArray2);
    }

    public boolean rotate_left(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        if (this.rrc > 0) {
            if (n2 == 0) {
                return false;
            }
            this.rrc %= n2 - 16;
            if (this.rrc == 0) {
                return false;
            }
            if (n > 0) {
                n3 += n;
            }
            System.arraycopy(byArray, n3, byArray2, 0, 16);
            System.arraycopy(byArray, (n3 += 16) + this.rrc, byArray2, 16, n2 - 16 - this.rrc);
            System.arraycopy(byArray, n3, byArray2, n2 - 16 - this.rrc, this.rrc);
            return true;
        }
        return false;
    }

    public final int getSequenceNumber() {
        return MessageToken_v2.readBigEndian(this.seqNumberData, 0, 4);
    }

    byte[] getChecksum(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = this.tokenHeader.getBytes();
        int n3 = byArray2[2] & 2;
        if (n3 == 0 && this.tokenId == 1284) {
            byArray2[4] = 0;
            byArray2[5] = 0;
        }
        return this.cipherHelper.calculateChecksum(byArray2, byArray, n, n2, this.key_usage);
    }

    MessageToken_v2(int n, Krb5Context krb5Context) throws GSSException {
        this.init(n, krb5Context);
        this.seqNumber = krb5Context.incrementMySequenceNumber();
    }

    private void init(int n, Krb5Context krb5Context) throws GSSException {
        this.tokenId = n;
        this.confState = krb5Context.getConfState();
        this.initiator = krb5Context.isInitiator();
        this.cipherHelper = krb5Context.getCipherHelper(null);
        this.tokenId = n;
    }

    public void encode(OutputStream outputStream) throws IOException, GSSException {
        this.tokenHeader.encode(outputStream);
        if (this.tokenId == 1028) {
            outputStream.write(this.checksum);
        }
    }

    protected int getKrb5TokenSize() throws GSSException {
        return this.getTokenSize();
    }

    protected final int getTokenSize() throws GSSException {
        return 16 + this.cipherHelper.getChecksumLength();
    }

    protected static final int getTokenSize(CipherHelper cipherHelper) throws GSSException {
        return 16 + cipherHelper.getChecksumLength();
    }

    protected final byte[] getTokenHeader() {
        return this.tokenHeader.getBytes();
    }

    static /* synthetic */ byte[] access$102(MessageToken_v2 messageToken_v2, byte[] byArray) {
        messageToken_v2.seqNumberData = byArray;
        return byArray;
    }

    class MessageTokenHeader {
        private int tokenId;
        private byte[] bytes = new byte[16];

        public MessageTokenHeader(int n, boolean bl, boolean bl2) throws GSSException {
            this.tokenId = n;
            this.bytes[0] = (byte)(n >>> 8);
            this.bytes[1] = (byte)n;
            int n2 = 0;
            n2 = (MessageToken_v2.this.initiator ? 0 : 1) | (bl && n != 1028 ? 2 : 0) | (bl2 ? 4 : 0);
            this.bytes[2] = (byte)n2;
            this.bytes[3] = -1;
            if (n == 1284) {
                this.bytes[4] = 0;
                this.bytes[5] = 0;
                this.bytes[6] = 0;
                this.bytes[7] = 0;
            } else if (n == 1028) {
                for (int i = 4; i < 8; ++i) {
                    this.bytes[i] = -1;
                }
            }
            MessageToken_v2.access$102(MessageToken_v2.this, new byte[8]);
            GSSToken.writeBigEndian(MessageToken_v2.this.seqNumber, MessageToken_v2.this.seqNumberData, 4);
            System.arraycopy(MessageToken_v2.this.seqNumberData, 0, this.bytes, 8, 8);
        }

        public MessageTokenHeader(InputStream inputStream, MessageProp messageProp, int n) throws IOException, GSSException {
            GSSToken.readFully(inputStream, this.bytes, 0, 16);
            this.tokenId = GSSToken.readInt(this.bytes, 0);
            int n2 = MessageToken_v2.this.initiator ? 1 : 0;
            int n3 = this.bytes[2] & 1;
            if (n3 != n2) {
                throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Acceptor Flag Missing!");
            }
            int n4 = this.bytes[2] & 2;
            if (n4 == 2 && this.tokenId == 1284) {
                messageProp.setPrivacy(true);
            } else {
                messageProp.setPrivacy(false);
            }
            if (this.tokenId != n) {
                throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token ID!");
            }
            if ((this.bytes[3] & 0xFF) != 255) {
                throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token Filler!");
            }
            if (this.tokenId == 1028) {
                for (int i = 4; i < 8; ++i) {
                    if ((this.bytes[i] & 0xFF) == 255) continue;
                    throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token Filler!");
                }
            }
            MessageToken_v2.this.ec = GSSToken.readBigEndian(this.bytes, 4, 2);
            MessageToken_v2.this.rrc = GSSToken.readBigEndian(this.bytes, 6, 2);
            messageProp.setQOP(0);
            MessageToken_v2.access$102(MessageToken_v2.this, new byte[8]);
            System.arraycopy(this.bytes, 8, MessageToken_v2.this.seqNumberData, 0, 8);
        }

        public final void encode(OutputStream outputStream) throws IOException {
            outputStream.write(this.bytes);
        }

        public final int getTokenId() {
            return this.tokenId;
        }

        public final byte[] getBytes() {
            return this.bytes;
        }
    }
}

