/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.util.DeployAWTUtil;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import sun.plugin2.applet.DragListener;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.util.SystemUtil;

public class DragHelper {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private static final boolean isOSX = System.getProperty("os.name").startsWith("Mac OS X");
    private static DragHelper soleInstance = new DragHelper();
    private boolean initialized;
    private Method isSystemGeneratedMethod;
    private List perAppletInfoList = new ArrayList();
    private volatile boolean dragging;
    private Image javaLogoImage;
    static /* synthetic */ Class class$sun$awt$SunToolkit;
    static /* synthetic */ Class class$java$awt$AWTEvent;
    static /* synthetic */ Class class$java$awt$event$MouseEvent;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public static DragHelper getInstance() {
        return soleInstance;
    }

    public synchronized void register(Plugin2Manager plugin2Manager, DragListener dragListener) {
        if (!this.initialize()) {
            return;
        }
        this.perAppletInfoList.add(new PerAppletInfo(plugin2Manager, dragListener));
    }

    public void makeDisconnected(Plugin2Manager plugin2Manager, Frame frame) {
        Iterator iterator = this.perAppletInfoList.iterator();
        while (iterator.hasNext()) {
            PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
            if (perAppletInfo.getManager() != plugin2Manager) continue;
            perAppletInfo.makeDisconnected(frame);
            return;
        }
    }

    public synchronized void restore(Plugin2Manager plugin2Manager) {
        Iterator iterator = this.perAppletInfoList.iterator();
        while (iterator.hasNext()) {
            PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
            if (perAppletInfo.getManager() != plugin2Manager) continue;
            perAppletInfo.restore();
            return;
        }
    }

    public synchronized void unregister(Plugin2Manager plugin2Manager) {
        Iterator iterator = this.perAppletInfoList.iterator();
        while (iterator.hasNext()) {
            PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
            if (perAppletInfo.getManager() != plugin2Manager) continue;
            if (perAppletInfo.iAmDragging()) {
                this.setSomeoneDragging(false);
            }
            iterator.remove();
            return;
        }
    }

    private DragHelper() {
    }

    private boolean initialize() {
        if (!this.initialized) {
            this.initialized = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    block2: {
                        try {
                            Class clazz = class$sun$awt$SunToolkit == null ? (class$sun$awt$SunToolkit = DragHelper.class$("sun.awt.SunToolkit")) : class$sun$awt$SunToolkit;
                            DragHelper.this.isSystemGeneratedMethod = clazz.getMethod("isSystemGenerated", class$java$awt$AWTEvent == null ? (class$java$awt$AWTEvent = DragHelper.class$("java.awt.AWTEvent")) : class$java$awt$AWTEvent);
                            DragHelper.this.isSystemGeneratedMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            if (isOSX) break block2;
                            exception.printStackTrace();
                        }
                    }
                    Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                        public void eventDispatched(AWTEvent aWTEvent) {
                            DragHelper.this.dispatchEvent(aWTEvent);
                        }
                    }, 48L);
                    return null;
                }
            });
        }
        return this.isSystemGeneratedMethod != null || isOSX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)aWTEvent;
            if (this.isSystemGenerated(aWTEvent) && (this.dragging || DragHelper.couldBeDragStartEvent(inputEvent))) {
                DragHelper dragHelper = this;
                synchronized (dragHelper) {
                    Iterator iterator = this.perAppletInfoList.iterator();
                    while (iterator.hasNext()) {
                        PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
                        if (!perAppletInfo.dispatchEvent(inputEvent)) continue;
                        return;
                    }
                }
            }
        }
    }

    private boolean isSystemGenerated(AWTEvent aWTEvent) {
        if (this.isSystemGeneratedMethod == null) {
            if (!isOSX) {
                return false;
            }
            return !((InputEvent)aWTEvent).isConsumed();
        }
        try {
            return (Boolean)this.isSystemGeneratedMethod.invoke(null, aWTEvent);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isSomeoneDragging() {
        return this.dragging;
    }

    private void setSomeoneDragging(boolean bl) {
        this.dragging = bl;
    }

    private static boolean couldBeDragStartEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        return n == 501 || n == 506;
    }

    private static Point getCurrentMouseLocation() {
        return (Point)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MouseInfo.getPointerInfo().getLocation();
            }
        });
    }

    private static Dimension getDragSize(Component component) {
        Dimension dimension = null;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            Dimension dimension2 = component2.getSize();
            if (dimension != null && dimension2.width >= dimension.width && dimension2.height >= dimension.height) continue;
            dimension = dimension2;
        }
        return dimension;
    }

    private Image getJavaLogoImage(final Component component) {
        if (this.javaLogoImage == null) {
            this.javaLogoImage = (Image)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = ClassLoader.getSystemResource("sun/plugin/util/JavaCupLogo-161.png");
                    Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                    MediaTracker mediaTracker = new MediaTracker(component);
                    mediaTracker.addImage(image, 0);
                    try {
                        mediaTracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return image;
                }
            });
        }
        return this.javaLogoImage;
    }

    private Canvas getJavaLogoCanvas(Dimension dimension) {
        Canvas canvas = new Canvas(){

            public void paint(Graphics graphics) {
                Image image = DragHelper.this.getJavaLogoImage(this);
                if (image != null) {
                    Rectangle rectangle = DragHelper.getCenteredImageBoundsWithinContainer(new Dimension(image.getWidth(this), image.getHeight(this)), this.getParent().getSize());
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
                }
            }
        };
        canvas.setSize(dimension);
        return canvas;
    }

    private static Rectangle getCenteredImageBoundsWithinContainer(Dimension dimension, Dimension dimension2) {
        float f = (float)dimension2.width / (float)dimension2.height;
        float f2 = (float)dimension.width / (float)dimension.height;
        if (f < f2) {
            if (dimension.width > dimension2.width) {
                int n = (int)((float)dimension2.width / f2);
                return new Rectangle(0, (dimension2.height - n) / 2, dimension2.width, n);
            }
        } else if (dimension.height > dimension2.height) {
            int n = (int)((float)dimension2.height * f2);
            return new Rectangle((dimension2.width - n) / 2, 0, n, dimension2.height);
        }
        return new Rectangle((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    private static boolean isSubclass(Class clazz, String string) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(string)) {
            return true;
        }
        return DragHelper.isSubclass(clazz.getSuperclass(), string);
    }

    private class PerAppletInfo {
        private Plugin2Manager manager;
        private Frame frame;
        private Point dragOffset;
        private Point upperLeft;
        private DragListener listener;
        private boolean notificationsSent;
        private Frame closeButtonFrame;
        private final Point closeButtonOffset = new Point(5, -5);
        private ActionListener closeListener;
        private boolean closing;
        private static final int CLOSE_BUTTON_SIZE = 10;
        private static final int CLOSE_BUTTON_OFFSET = 5;
        private boolean initializedDragStartMethod;
        private Method dragStartMethod;

        PerAppletInfo(Plugin2Manager plugin2Manager, DragListener dragListener) {
            this.manager = plugin2Manager;
            this.listener = dragListener;
        }

        public Plugin2Manager getManager() {
            return this.manager;
        }

        public boolean dispatchEvent(AWTEvent aWTEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (DragHelper.this.isSomeoneDragging() && !this.iAmDragging()) {
                return false;
            }
            Applet applet = this.manager.getApplet();
            if (applet == null) {
                return false;
            }
            if (this.manager.getModalityLevel() != 0) {
                return false;
            }
            if (this.iAmDragging()) {
                this.dispatchEventImpl(applet, mouseEvent);
                return true;
            }
            boolean bl = false;
            for (Component component = mouseEvent.getComponent(); component != null; component = component.getParent()) {
                if (component != applet) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            if (this.isDragStartEvent(applet, mouseEvent)) {
                this.dispatchEventImpl(applet, mouseEvent);
                return true;
            }
            return false;
        }

        public void restore() {
            Container container = this.manager.getAppletParentContainer();
            Applet applet = this.manager.getApplet();
            if (applet != null && container != null) {
                if (container instanceof JFrame) {
                    ((JFrame)container).getContentPane().removeAll();
                } else {
                    container.removeAll();
                }
                container.add(applet);
                this.sendAppletRestored(applet);
                this.notificationsSent = false;
                this.closing = false;
                applet.repaint();
            }
        }

        private boolean iAmDragging() {
            return this.dragOffset != null;
        }

        private void setFrameTitle(Frame frame) {
            String string = this.manager.getName();
            int n = string.lastIndexOf(".");
            if (n > 0) {
                string = string.substring(n + 1);
            }
            frame.setTitle(string);
        }

        private void setupCloseListener(Applet applet) {
            this.closeListener = new CloseListener();
            if (!this.sendSetAppletCloseListener(applet, this.closeListener)) {
                this.closeButtonFrame = this.createCloseButton(this.closeListener);
                this.refreshCloseButtonFrame();
                this.closeButtonFrame.setVisible(true);
            }
        }

        private void setupWindow(Frame frame) {
            DisplayMode displayMode;
            GraphicsDevice graphicsDevice;
            frame.addWindowListener(new WindowAdapter(){
                private long lastActivate;

                public void windowActivated(WindowEvent windowEvent) {
                    long l = System.currentTimeMillis();
                    if (l - this.lastActivate > 200L) {
                        if (PerAppletInfo.this.closeButtonFrame != null) {
                            PerAppletInfo.this.closeButtonFrame.toFront();
                        }
                        this.lastActivate = l;
                    }
                }

                public void windowClosing(WindowEvent windowEvent) {
                    if (PerAppletInfo.this.closeListener != null) {
                        PerAppletInfo.this.closeListener.actionPerformed(null);
                    }
                }

                public void windowIconified(WindowEvent windowEvent) {
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(false);
                    }
                }

                public void windowDeiconified(WindowEvent windowEvent) {
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(true);
                        PerAppletInfo.this.refreshCloseButtonFrame();
                    }
                }
            });
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (graphicsEnvironment != null && (graphicsDevice = graphicsEnvironment.getDefaultScreenDevice()) != null && (displayMode = graphicsDevice.getDisplayMode()) != null) {
                int n = 30;
                frame.setMaximizedBounds(new Rectangle(0, 0, displayMode.getWidth() - n, displayMode.getHeight() - n));
            }
        }

        private void makeDisconnected(Frame frame) {
            this.frame = frame;
            this.setupWindow(frame);
            this.setFrameTitle(frame);
            this.upperLeft = frame.getLocation();
            Applet applet = this.manager.getApplet();
            this.sendDragStarted(applet);
            this.sendDragFinished(applet);
            this.notificationsSent = true;
            this.setupCloseListener(applet);
        }

        private void refreshCloseButtonFrame() {
            if (this.closeButtonFrame != null) {
                Point point = this.frame.getLocation();
                this.closeButtonFrame.setLocation(point.x + this.frame.getWidth() + this.closeButtonOffset.x, point.y + this.closeButtonOffset.y);
            }
        }

        private void dispatchEventImpl(final Applet applet, MouseEvent mouseEvent) {
            if (!this.iAmDragging()) {
                DragHelper.this.setSomeoneDragging(true);
                this.upperLeft = applet.getLocationOnScreen();
                Point point = DragHelper.getCurrentMouseLocation();
                this.dragOffset = new Point(point.x - this.upperLeft.x, point.y - this.upperLeft.y);
                final Dimension dimension = DragHelper.getDragSize(applet);
                if (this.frame == null) {
                    this.frame = (Frame)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (DragHelper.isSubclass(applet.getClass(), "javax.swing.JApplet")) {
                                return new JFrame();
                            }
                            return new Frame();
                        }
                    });
                    this.frame.setUndecorated(true);
                    this.setupWindow(this.frame);
                    this.setFrameTitle(this.frame);
                    final Container container = this.manager.getAppletParentContainer();
                    if (container != null) {
                        container.remove(applet);
                        DeployAWTUtil.invokeLater((Component)container, (Runnable)new Runnable(){

                            public void run() {
                                Canvas canvas = DragHelper.this.getJavaLogoCanvas(dimension);
                                container.add(canvas);
                            }
                        });
                    }
                    this.frame.add((Component)applet, "Center");
                    applet.setLocation(0, 0);
                    this.frame.setSize(dimension);
                    this.frame.setResizable(false);
                }
                if (!this.notificationsSent) {
                    this.sendDragStarted(applet);
                }
                this.frame.setLocation(this.upperLeft);
                this.frame.setVisible(true);
                if (isOSX && !this.notificationsSent) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                Robot robot = new Robot();
                                robot.mouseRelease(16);
                                robot.mousePress(16);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            return null;
                        }
                    });
                }
            } else {
                int n = mouseEvent.getID();
                if (n == 506 || n == 505) {
                    if (this.frame != null && this.dragOffset != null) {
                        block14: {
                            try {
                                Point point = DragHelper.getCurrentMouseLocation();
                                this.upperLeft.x = point.x - this.dragOffset.x;
                                this.upperLeft.y = point.y - this.dragOffset.y;
                            }
                            catch (Throwable throwable) {
                                if (n == 505) break block14;
                                int n2 = mouseEvent.getX() - this.dragOffset.x;
                                int n3 = mouseEvent.getY() - this.dragOffset.y;
                                this.upperLeft.x += n2;
                                this.upperLeft.y += n3;
                            }
                        }
                        this.frame.setLocation(this.upperLeft);
                        this.frame.toFront();
                        if (this.closeButtonFrame != null) {
                            this.refreshCloseButtonFrame();
                            this.closeButtonFrame.toFront();
                        }
                    }
                } else if (n == 502 && mouseEvent.getButton() == 1 || n == 503) {
                    this.dragOffset = null;
                    if (!this.notificationsSent) {
                        this.sendDragFinished(applet);
                        this.listener.appletDroppedOntoDesktop(this.manager);
                        this.notificationsSent = true;
                        this.setupCloseListener(applet);
                    }
                    DragHelper.this.setSomeoneDragging(false);
                }
            }
            mouseEvent.consume();
        }

        private Frame createCloseButton(final ActionListener actionListener) {
            Canvas canvas = new Canvas(){

                public void paint(Graphics graphics) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    int n = (int)Math.max(1.0, 0.025 * (double)Math.min(this.getWidth(), this.getHeight()));
                    int n2 = this.getWidth() / 2;
                    int n3 = this.getHeight() / 2;
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillRect(0, 0, n, this.getHeight());
                    graphics2D.fillRect(0, 0, this.getWidth(), n);
                    graphics2D.fillRect(0, this.getHeight() - n, this.getWidth(), n);
                    graphics2D.fillRect(this.getWidth() - n, 0, n, this.getHeight());
                    graphics2D.setStroke(new BasicStroke(n, 0, 2));
                    float f = 0.15f;
                    graphics2D.drawLine((int)(f * (float)this.getWidth()), (int)(f * (float)this.getHeight()), (int)((1.0f - f) * (float)this.getWidth()), (int)((1.0f - f) * (float)this.getHeight()));
                    graphics2D.drawLine((int)((1.0f - f) * (float)this.getWidth()), (int)(f * (float)this.getHeight()), (int)(f * (float)this.getWidth()), (int)((1.0f - f) * (float)this.getHeight()));
                }
            };
            canvas.setBackground(Color.BLACK);
            canvas.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    actionListener.actionPerformed(null);
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(false);
                        PerAppletInfo.this.closeButtonFrame.dispose();
                        PerAppletInfo.this.closeButtonFrame = null;
                    }
                }
            });
            Frame frame = (Frame)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Frame();
                }
            });
            frame.setUndecorated(true);
            frame.setResizable(false);
            frame.setFocusableWindowState(false);
            frame.add(canvas);
            frame.setSize(10, 10);
            return frame;
        }

        private boolean isDragStartEvent(Applet applet, MouseEvent mouseEvent) {
            if (!this.initializedDragStartMethod) {
                this.initializedDragStartMethod = true;
                try {
                    this.dragStartMethod = applet.getClass().getMethod("isAppletDragStart", class$java$awt$event$MouseEvent == null ? (class$java$awt$event$MouseEvent = DragHelper.class$("java.awt.event.MouseEvent")) : class$java$awt$event$MouseEvent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.dragStartMethod != null) {
                try {
                    Boolean bl = (Boolean)this.dragStartMethod.invoke((Object)applet, mouseEvent);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.dragStartMethod = null;
                }
            }
            int n = mouseEvent.getModifiersEx();
            return mouseEvent.getButton() == 1 && (n == 1536 || !isOSX && n == 1280);
        }

        private void sendDragStarted(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletDragStarted for applet ID " + this.manager.getAppletID());
            }
            try {
                Method method = applet.getClass().getMethod("appletDragStarted", null);
                method.invoke((Object)applet, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void sendDragFinished(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletDragFinished for applet ID " + this.manager.getAppletID());
            }
            try {
                Method method = applet.getClass().getMethod("appletDragFinished", null);
                method.invoke((Object)applet, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void sendAppletRestored(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletRestored for applet ID " + this.manager.getAppletID());
            }
            try {
                Method method = applet.getClass().getMethod("appletRestored", null);
                method.invoke((Object)applet, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean sendSetAppletCloseListener(Applet applet, ActionListener actionListener) {
            if (DEBUG) {
                System.out.println("DragHelper sending setAppletCloseListener for applet ID " + this.manager.getAppletID());
            }
            try {
                Method method = applet.getClass().getMethod("setAppletCloseListener", class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = DragHelper.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
                method.invoke((Object)applet, actionListener);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        class CloseListener
        implements ActionListener {
            CloseListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (PerAppletInfo.this.closing) {
                    return;
                }
                PerAppletInfo.this.closing = true;
                if (PerAppletInfo.this.listener != null) {
                    PerAppletInfo.this.listener.appletExternalWindowClosed(PerAppletInfo.this.manager);
                }
                if (PerAppletInfo.this.manager.isDisconnected()) {
                    DragHelper.this.unregister(PerAppletInfo.this.manager);
                }
                PerAppletInfo.this.frame.setVisible(false);
                PerAppletInfo.this.frame.dispose();
                PerAppletInfo.this.frame = null;
                if (PerAppletInfo.this.closeButtonFrame != null) {
                    PerAppletInfo.this.closeButtonFrame.setVisible(false);
                    PerAppletInfo.this.closeButtonFrame.dispose();
                    PerAppletInfo.this.closeButtonFrame = null;
                }
            }
        }
    }
}

