/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.NotActiveException;
import java.io.ObjectStreamClass;

final class SerialCallbackContext {
    private final Object obj;
    private final ObjectStreamClass desc;
    private Thread thread;

    public SerialCallbackContext(Object object, ObjectStreamClass objectStreamClass) {
        this.obj = object;
        this.desc = objectStreamClass;
        this.thread = Thread.currentThread();
    }

    public Object getObj() throws NotActiveException {
        this.checkAndSetUsed();
        return this.obj;
    }

    public ObjectStreamClass getDesc() {
        return this.desc;
    }

    private void checkAndSetUsed() throws NotActiveException {
        if (this.thread != Thread.currentThread()) {
            throw new NotActiveException("not in readObject invocation or fields already read");
        }
        this.thread = null;
    }

    public void setUsed() {
        this.thread = null;
    }
}

